module `IP_MODULE_NAME(hbram_top) #(
    parameter       MHZ            	= 200,
    parameter       RAM_DBW        	= 16,
    parameter       RAM_ABW        	= 32,
    parameter [0:0] CR0_DPD        	= 1'b1,
    parameter [2:0] CR0_ODS        	= 3'b000,
    parameter [3:0] CR0_ILC        	= 4'b0010,
    parameter [0:0] CR0_FLE        	= 1'b1,
    parameter [0:0] CR0_HBE        	= 1'b1,
    parameter [1:0] CR0_WBL        	= 2'b11,
    parameter [0:0] CR1_MCT        	= 1'b1,
    parameter [0:0] CR1_HSE        	= 1'b1,
    parameter [2:0] CR1_PAR        	= 3'b000,
    parameter       AXI_IF         	= 1,
    parameter       AXI_DBW        	= 128,
    parameter       AXI_SBW        	= AXI_DBW/8,
    parameter       AXI_AWR_DEPTH  	= 16,
    parameter       AXI_W_DEPTH    	= 256,
    parameter       AXI_R_DEPTH    	= 256,
    parameter       DDIN_MODE      	= "",
    parameter [4:0] CAL_CLK_CH     	= 5'b00001,
    parameter [4:0] CAL_CLK_CH_LO  	= 5'b00001,
    parameter [4:0] CAL_CLK_CH_HI  	= 5'b00010,
    parameter       CAL_MODE       	= 2,
    parameter       CAL_DQ_STEPS   	= 8,
    parameter       CAL_RWDS_STEPS 	= 8,
    parameter       CAL_BYTES      	= 12'h100,
    parameter       TCSM           	= 4000000,
    parameter       TVCS           	= 150000000,
    parameter       TRH            	= 200000,
    parameter       TRTR           	= 40000,
    parameter       PLL_MANUAL     	= 0,
    parameter		DUAL_RAM 	   	= 0,
    parameter 		INDIVI_DUAL_CAL	= 0,
    parameter [15:0] CFG_CR1 		= {9'h1ff, CR1_MCT, CR1_HSE, CR1_PAR, 2'b01},
	parameter [15:0] CFG_CR0 		= {CR0_DPD, CR0_ODS, 4'b1111, CR0_ILC, CR0_FLE, CR0_HBE, CR0_WBL},
	parameter 		 PERIODIC_CAL	= 0,
	parameter		 PRD_CAL_USER_SIGNAL = 0,
	parameter 		 ONE_SEC 		= MHZ * 1000000,
	parameter 		 ONE_MIN 		= 60,
	parameter 		 ONE_HOUR 		= 60,
	parameter 		 ONE_DAY 		= 24,
	parameter 		 RECAL_DAYS 	= 2,
	parameter 		 RECAL_HOURS 	= 23,
	parameter		 RWDS_OUT_MODE	= 0,
	parameter		 DQ_FILTER		= 1
) (
    input  wire                 rst,
    input  wire                 ram_clk,
    input  wire                 ram_clk_cal,
    input  wire                 ram_clk_cal_2,
    input  wire                 io_axi_clk,
    input  wire                 io_arw_valid,
    input  wire [31:0]          io_arw_payload_addr,
    input  wire [7:0]           io_arw_payload_id,
    input  wire [7:0]           io_arw_payload_len,
    input  wire [2:0]           io_arw_payload_size,
    input  wire [1:0]           io_arw_payload_burst,
    input  wire [1:0]           io_arw_payload_lock,
    input  wire                 io_arw_payload_write,
    output wire                 io_arw_ready,
    input  wire [7:0]           io_w_payload_id,
    input  wire                 io_w_valid,
    input  wire [AXI_DBW-1:0]   io_w_payload_data,
    input  wire [AXI_SBW-1:0]   io_w_payload_strb,
    input  wire                 io_w_payload_last,
    output wire                 io_w_ready,
    input  wire                 io_b_ready,
    output wire                 io_b_valid,
    output wire [7:0]           io_b_payload_id,
    input  wire                 io_r_ready,
    output wire                 io_r_valid,
    output wire [AXI_DBW-1:0]   io_r_payload_data,
    output wire [7:0]           io_r_payload_id,
    output wire [1:0]           io_r_payload_resp,
    output wire                 io_r_payload_last,
    input  wire                 native_clk,
    input  wire                 native_ram_rdwr,
    input  wire                 native_ram_en,
    input  wire [10:0]          native_ram_burst_len,
    input  wire [31:0]          native_ram_address,
    input  wire [AXI_DBW-1:0]   native_wr_data,
    input  wire [AXI_SBW-1:0]   native_wr_datamask,
    input  wire                 native_wr_en,
    output wire                 native_wr_buf_ready,
    output wire [AXI_DBW-1:0]   native_rd_data,
    output wire                 native_rd_valid,
    output wire                 native_ctrl_idle,
    input  wire                 dyn_pll_phase_en,
    input  wire [2:0]           dyn_pll_phase_sel,
    output wire                 hbc_cal_SHIFT_ENA,
    output wire [2:0]           hbc_cal_SHIFT,
    output wire [4:0]           hbc_cal_SHIFT_SEL,
    output wire [2:0]           hbc_cal_SHIFT_HI,
    output wire [2:0]           hbc_cal_SHIFT_LO,
    output wire [26:0]          hbc_cal_debug_info,
    output wire                 hbc_rst_n,
    output wire                 hbc_cs_n,
    output wire                 hbc_ck_p_HI,
    output wire                 hbc_ck_p_LO,
    output wire                 hbc_ck_n_HI,
    output wire                 hbc_ck_n_LO,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_HI,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_LO,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_HI,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_LO,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OE,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_HI,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_LO,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_HI,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_LO,
    output wire [RAM_DBW-1:0]   hbc_dq_OE,
    output wire                 hbc_rst_n_2,
    output wire                 hbc_cs_n_2,
    output wire                 hbc_ck_p_HI_2,
    output wire                 hbc_ck_p_LO_2,
    output wire                 hbc_ck_n_HI_2,
    output wire                 hbc_ck_n_LO_2,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_HI_2,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OUT_LO_2,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_HI_2,
    input  wire [RAM_DBW/8-1:0] hbc_rwds_IN_LO_2,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_LO_2,
    input  wire [RAM_DBW-1:0]   hbc_dq_IN_HI_2,
    output wire [RAM_DBW/8-1:0] hbc_rwds_OE_2,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_HI_2,
    output wire [RAM_DBW-1:0]   hbc_dq_OUT_LO_2,
    output wire [RAM_DBW-1:0]   hbc_dq_OE_2,
    output wire                 hbc_cal_pass,
    input wire					prd_user_ack,
    output wire					prd_user_req
);
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2021.1"
`pragma protect key_keyowner = "Aldec" , key_keyname = "ALDEC15_001"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
tvSyFeJVgny1JFL7D4KjctAo92Y9XONIIEG7h3MQtSygLlC1QW+aJNUr9Q+TgOlM
rqC/+xjB106PVD4WIU+Jf8D1MaV2nZgBTW0FJnbgxTXWFdQCwXR0vfA6jTNML9co
NMmitQtpcIiMp29v+OSo5K3MYa3FNKIuCnYS0TgtEKe5pJ5YK/nM926JAm57vfbC
ds48yfdJARJ8eoTALmuDSxscJi80tBle+8Q03TUGNxn63WhRnCZ9A8UJs07tOlHk
deQn3QbK9C/DNI1BLjifKXhAEtzDC6nEBExiNVJyewVuDwfvadYgTMPjnEvCLENN
+5yGdmiJ/ru0EzbeDBxXLA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 9616 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
