
# Efinity Interface Designer SDC
# Version: 2024.M.227
# Date: 2024-08-30 10:27

# Copyright (C) 2013 - 2024 Efinix Inc. All rights reserved.

# Device: Ti60F225
# Project: hbram_ti60
# Timing Model: C4 (final)

# Oscillator Constraints
########################
create_clock -period 25 [get_ports {intosc_clkout}]

# PLL Constraints
#################
create_clock -period 5.0000 hbramClk
create_clock -waveform {1.2500 3.7500} -period 5.0000 hbramClk90
create_clock -period 5.0000 hbramClk_cal
create_clock -period 40.0000 clk0
create_clock -period 6.7340 clk_fb
create_clock -period 9.9030 clk
create_clock -period 10 [get_ports {jtag_inst1_TCK}]

# Clock Groups
##############
set_clock_groups -asynchronous -group {hbramClk hbramClk90} -group {hbramClk_cal} -group {intosc_clkout} -group {clk} -group {jtag_inst1_TCK}

# GPIO Constraints
####################
# set_input_delay -clock <CLOCK> [-reference_pin <clkout_pad>] -max <MAX CALCULATION> [get_ports {io_asyncReset}]
# set_input_delay -clock <CLOCK> [-reference_pin <clkout_pad>] -min <MIN CALCULATION> [get_ports {io_asyncReset}]

# JTAG Constraints
####################
# create_clock -period <USER_PERIOD> [get_ports {jtag_inst1_TCK}]
set_output_delay -clock jtag_inst1_TCK -max 1.321 [get_ports {jtag_inst1_TDO}]
set_output_delay -clock jtag_inst1_TCK -min 0.495 [get_ports {jtag_inst1_TDO}]
set_input_delay -clock_fall -clock jtag_inst1_TCK -max 0.125 [get_ports {jtag_inst1_CAPTURE}]
set_input_delay -clock_fall -clock jtag_inst1_TCK -min 0.077 [get_ports {jtag_inst1_CAPTURE}]
set_input_delay -clock_fall -clock jtag_inst1_TCK -max 0.660 [get_ports {jtag_inst1_RESET}]
set_input_delay -clock_fall -clock jtag_inst1_TCK -min 0.401 [get_ports {jtag_inst1_RESET}]
set_input_delay -clock_fall -clock jtag_inst1_TCK -max 0.204 [get_ports {jtag_inst1_SEL}]
set_input_delay -clock_fall -clock jtag_inst1_TCK -min 0.025 [get_ports {jtag_inst1_SEL}]
set_input_delay -clock_fall -clock jtag_inst1_TCK -max 0.153 [get_ports {jtag_inst1_UPDATE}]
set_input_delay -clock_fall -clock jtag_inst1_TCK -min 0.074 [get_ports {jtag_inst1_UPDATE}]
set_input_delay -clock_fall -clock jtag_inst1_TCK -max 0.172 [get_ports {jtag_inst1_SHIFT}]
set_input_delay -clock_fall -clock jtag_inst1_TCK -min 0.055 [get_ports {jtag_inst1_SHIFT}]
#set_input_delay -clock_fall -clock jtag_inst1_TCK -max 1.035 [get_ports {jtag_inst1_DRCK}]
#set_input_delay -clock_fall -clock jtag_inst1_TCK -min 0.620 [get_ports {jtag_inst1_DRCK}]
# JTAG Constraints (extra... not used by current Efinity debug tools)
# create_clock -period <USER_PERIOD> [get_ports {jtag_inst1_DRCK}]
# set_input_delay -clock_fall -clock jtag_inst1_TCK -max 0.147 [get_ports {jtag_inst1_RUNTEST}]
# set_input_delay -clock_fall -clock jtag_inst1_TCK -min 0.066 [get_ports {jtag_inst1_RUNTEST}]
# Create separate clock groups for JTAG clocks. Remove DRCK clock from the list below if it is not defined.
# set_clock_groups -asynchronous -group {jtag_inst1_TCK jtag_inst1_DRCK}

# HSIO GPIO Constraints
#########################
# set_output_delay -clock <CLOCK> [-reference_pin <clkout_pad>] -max <MAX CALCULATION> [get_ports {hbc_cal_pass}]
# set_output_delay -clock <CLOCK> [-reference_pin <clkout_pad>] -min <MIN CALCULATION> [get_ports {hbc_cal_pass}]
set_output_delay -clock_fall -clock hbramClk90 -reference_pin [get_ports {hbramClk90~CLKOUT~75~322}] -max 0.263 [get_ports {hbc_ck_n_HI}]
set_output_delay -clock_fall -clock hbramClk90 -reference_pin [get_ports {hbramClk90~CLKOUT~75~322}] -min -0.140 [get_ports {hbc_ck_n_HI}]
set_output_delay -clock hbramClk90 -reference_pin [get_ports {hbramClk90~CLKOUT~75~322}] -max 0.263 [get_ports {hbc_ck_n_LO}]
set_output_delay -clock hbramClk90 -reference_pin [get_ports {hbramClk90~CLKOUT~75~322}] -min -0.140 [get_ports {hbc_ck_n_LO}]
set_output_delay -clock_fall -clock hbramClk90 -reference_pin [get_ports {hbramClk90~CLKOUT~74~322}] -max 0.263 [get_ports {hbc_ck_p_HI}]
set_output_delay -clock_fall -clock hbramClk90 -reference_pin [get_ports {hbramClk90~CLKOUT~74~322}] -min -0.140 [get_ports {hbc_ck_p_HI}]
set_output_delay -clock hbramClk90 -reference_pin [get_ports {hbramClk90~CLKOUT~74~322}] -max 0.263 [get_ports {hbc_ck_p_LO}]
set_output_delay -clock hbramClk90 -reference_pin [get_ports {hbramClk90~CLKOUT~74~322}] -min -0.140 [get_ports {hbc_ck_p_LO}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~84~322}] -max 0.263 [get_ports {hbc_cs_n}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~84~322}] -min -0.140 [get_ports {hbc_cs_n}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~27~322}] -max 0.263 [get_ports {hbc_rst_n}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~27~322}] -min -0.140 [get_ports {hbc_rst_n}]
# set_output_delay -clock <CLOCK> [-reference_pin <clkout_pad>] -max <MAX CALCULATION> [get_ports {test_fail}]
# set_output_delay -clock <CLOCK> [-reference_pin <clkout_pad>] -min <MIN CALCULATION> [get_ports {test_fail}]
# set_output_delay -clock <CLOCK> [-reference_pin <clkout_pad>] -max <MAX CALCULATION> [get_ports {test_good}]
# set_output_delay -clock <CLOCK> [-reference_pin <clkout_pad>] -min <MIN CALCULATION> [get_ports {test_good}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~32~322}] -max 0.414 [get_ports {hbc_dq_IN_LO[0] hbc_dq_IN_HI[0]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~32~322}] -min 0.276 [get_ports {hbc_dq_IN_LO[0] hbc_dq_IN_HI[0]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~34~322}] -max 0.263 [get_ports {hbc_dq_OUT_HI[0]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~34~322}] -min -0.140 [get_ports {hbc_dq_OUT_HI[0]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~34~322}] -max 0.263 [get_ports {hbc_dq_OUT_LO[0]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~34~322}] -min -0.140 [get_ports {hbc_dq_OUT_LO[0]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~34~322}] -max 0.263 [get_ports {hbc_dq_OE[0]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~34~322}] -min -0.140 [get_ports {hbc_dq_OE[0]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~33~322}] -max 0.414 [get_ports {hbc_dq_IN_LO[1] hbc_dq_IN_HI[1]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~33~322}] -min 0.276 [get_ports {hbc_dq_IN_LO[1] hbc_dq_IN_HI[1]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~35~322}] -max 0.263 [get_ports {hbc_dq_OUT_HI[1]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~35~322}] -min -0.140 [get_ports {hbc_dq_OUT_HI[1]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~35~322}] -max 0.263 [get_ports {hbc_dq_OUT_LO[1]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~35~322}] -min -0.140 [get_ports {hbc_dq_OUT_LO[1]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~35~322}] -max 0.263 [get_ports {hbc_dq_OE[1]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~35~322}] -min -0.140 [get_ports {hbc_dq_OE[1]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~48~322}] -max 0.414 [get_ports {hbc_dq_IN_LO[2] hbc_dq_IN_HI[2]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~48~322}] -min 0.276 [get_ports {hbc_dq_IN_LO[2] hbc_dq_IN_HI[2]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~50~322}] -max 0.263 [get_ports {hbc_dq_OUT_HI[2]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~50~322}] -min -0.140 [get_ports {hbc_dq_OUT_HI[2]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~50~322}] -max 0.263 [get_ports {hbc_dq_OUT_LO[2]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~50~322}] -min -0.140 [get_ports {hbc_dq_OUT_LO[2]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~50~322}] -max 0.263 [get_ports {hbc_dq_OE[2]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~50~322}] -min -0.140 [get_ports {hbc_dq_OE[2]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~49~322}] -max 0.414 [get_ports {hbc_dq_IN_LO[3] hbc_dq_IN_HI[3]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~49~322}] -min 0.276 [get_ports {hbc_dq_IN_LO[3] hbc_dq_IN_HI[3]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~51~322}] -max 0.263 [get_ports {hbc_dq_OUT_HI[3]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~51~322}] -min -0.140 [get_ports {hbc_dq_OUT_HI[3]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~51~322}] -max 0.263 [get_ports {hbc_dq_OUT_LO[3]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~51~322}] -min -0.140 [get_ports {hbc_dq_OUT_LO[3]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~51~322}] -max 0.263 [get_ports {hbc_dq_OE[3]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~51~322}] -min -0.140 [get_ports {hbc_dq_OE[3]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~56~322}] -max 0.414 [get_ports {hbc_dq_IN_LO[4] hbc_dq_IN_HI[4]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~56~322}] -min 0.276 [get_ports {hbc_dq_IN_LO[4] hbc_dq_IN_HI[4]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~58~322}] -max 0.263 [get_ports {hbc_dq_OUT_HI[4]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~58~322}] -min -0.140 [get_ports {hbc_dq_OUT_HI[4]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~58~322}] -max 0.263 [get_ports {hbc_dq_OUT_LO[4]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~58~322}] -min -0.140 [get_ports {hbc_dq_OUT_LO[4]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~58~322}] -max 0.263 [get_ports {hbc_dq_OE[4]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~58~322}] -min -0.140 [get_ports {hbc_dq_OE[4]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~57~322}] -max 0.414 [get_ports {hbc_dq_IN_LO[5] hbc_dq_IN_HI[5]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~57~322}] -min 0.276 [get_ports {hbc_dq_IN_LO[5] hbc_dq_IN_HI[5]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~59~322}] -max 0.263 [get_ports {hbc_dq_OUT_HI[5]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~59~322}] -min -0.140 [get_ports {hbc_dq_OUT_HI[5]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~59~322}] -max 0.263 [get_ports {hbc_dq_OUT_LO[5]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~59~322}] -min -0.140 [get_ports {hbc_dq_OUT_LO[5]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~59~322}] -max 0.263 [get_ports {hbc_dq_OE[5]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~59~322}] -min -0.140 [get_ports {hbc_dq_OE[5]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~64~322}] -max 0.414 [get_ports {hbc_dq_IN_LO[6] hbc_dq_IN_HI[6]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~64~322}] -min 0.276 [get_ports {hbc_dq_IN_LO[6] hbc_dq_IN_HI[6]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~66~322}] -max 0.263 [get_ports {hbc_dq_OUT_HI[6]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~66~322}] -min -0.140 [get_ports {hbc_dq_OUT_HI[6]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~66~322}] -max 0.263 [get_ports {hbc_dq_OUT_LO[6]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~66~322}] -min -0.140 [get_ports {hbc_dq_OUT_LO[6]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~66~322}] -max 0.263 [get_ports {hbc_dq_OE[6]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~66~322}] -min -0.140 [get_ports {hbc_dq_OE[6]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~65~322}] -max 0.414 [get_ports {hbc_dq_IN_LO[7] hbc_dq_IN_HI[7]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~65~322}] -min 0.276 [get_ports {hbc_dq_IN_LO[7] hbc_dq_IN_HI[7]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~67~322}] -max 0.263 [get_ports {hbc_dq_OUT_HI[7]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~67~322}] -min -0.140 [get_ports {hbc_dq_OUT_HI[7]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~67~322}] -max 0.263 [get_ports {hbc_dq_OUT_LO[7]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~67~322}] -min -0.140 [get_ports {hbc_dq_OUT_LO[7]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~67~322}] -max 0.263 [get_ports {hbc_dq_OE[7]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~67~322}] -min -0.140 [get_ports {hbc_dq_OE[7]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~140~322}] -max 0.414 [get_ports {hbc_dq_IN_LO[8] hbc_dq_IN_HI[8]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~140~322}] -min 0.276 [get_ports {hbc_dq_IN_LO[8] hbc_dq_IN_HI[8]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~142~322}] -max 0.263 [get_ports {hbc_dq_OUT_HI[8]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~142~322}] -min -0.140 [get_ports {hbc_dq_OUT_HI[8]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~142~322}] -max 0.263 [get_ports {hbc_dq_OUT_LO[8]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~142~322}] -min -0.140 [get_ports {hbc_dq_OUT_LO[8]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~142~322}] -max 0.263 [get_ports {hbc_dq_OE[8]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~142~322}] -min -0.140 [get_ports {hbc_dq_OE[8]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~141~322}] -max 0.414 [get_ports {hbc_dq_IN_LO[9] hbc_dq_IN_HI[9]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~141~322}] -min 0.276 [get_ports {hbc_dq_IN_LO[9] hbc_dq_IN_HI[9]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~143~322}] -max 0.263 [get_ports {hbc_dq_OUT_HI[9]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~143~322}] -min -0.140 [get_ports {hbc_dq_OUT_HI[9]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~143~322}] -max 0.263 [get_ports {hbc_dq_OUT_LO[9]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~143~322}] -min -0.140 [get_ports {hbc_dq_OUT_LO[9]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~143~322}] -max 0.263 [get_ports {hbc_dq_OE[9]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~143~322}] -min -0.140 [get_ports {hbc_dq_OE[9]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~148~322}] -max 0.414 [get_ports {hbc_dq_IN_LO[10] hbc_dq_IN_HI[10]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~148~322}] -min 0.276 [get_ports {hbc_dq_IN_LO[10] hbc_dq_IN_HI[10]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~150~322}] -max 0.263 [get_ports {hbc_dq_OUT_HI[10]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~150~322}] -min -0.140 [get_ports {hbc_dq_OUT_HI[10]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~150~322}] -max 0.263 [get_ports {hbc_dq_OUT_LO[10]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~150~322}] -min -0.140 [get_ports {hbc_dq_OUT_LO[10]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~150~322}] -max 0.263 [get_ports {hbc_dq_OE[10]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~150~322}] -min -0.140 [get_ports {hbc_dq_OE[10]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~149~322}] -max 0.414 [get_ports {hbc_dq_IN_LO[11] hbc_dq_IN_HI[11]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~149~322}] -min 0.276 [get_ports {hbc_dq_IN_LO[11] hbc_dq_IN_HI[11]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~151~322}] -max 0.263 [get_ports {hbc_dq_OUT_HI[11]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~151~322}] -min -0.140 [get_ports {hbc_dq_OUT_HI[11]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~151~322}] -max 0.263 [get_ports {hbc_dq_OUT_LO[11]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~151~322}] -min -0.140 [get_ports {hbc_dq_OUT_LO[11]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~151~322}] -max 0.263 [get_ports {hbc_dq_OE[11]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~151~322}] -min -0.140 [get_ports {hbc_dq_OE[11]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~156~322}] -max 0.414 [get_ports {hbc_dq_IN_LO[12] hbc_dq_IN_HI[12]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~156~322}] -min 0.276 [get_ports {hbc_dq_IN_LO[12] hbc_dq_IN_HI[12]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~158~322}] -max 0.263 [get_ports {hbc_dq_OUT_HI[12]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~158~322}] -min -0.140 [get_ports {hbc_dq_OUT_HI[12]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~158~322}] -max 0.263 [get_ports {hbc_dq_OUT_LO[12]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~158~322}] -min -0.140 [get_ports {hbc_dq_OUT_LO[12]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~158~322}] -max 0.263 [get_ports {hbc_dq_OE[12]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~158~322}] -min -0.140 [get_ports {hbc_dq_OE[12]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~157~322}] -max 0.414 [get_ports {hbc_dq_IN_LO[13] hbc_dq_IN_HI[13]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~157~322}] -min 0.276 [get_ports {hbc_dq_IN_LO[13] hbc_dq_IN_HI[13]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~159~322}] -max 0.263 [get_ports {hbc_dq_OUT_HI[13]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~159~322}] -min -0.140 [get_ports {hbc_dq_OUT_HI[13]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~159~322}] -max 0.263 [get_ports {hbc_dq_OUT_LO[13]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~159~322}] -min -0.140 [get_ports {hbc_dq_OUT_LO[13]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~159~322}] -max 0.263 [get_ports {hbc_dq_OE[13]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~159~322}] -min -0.140 [get_ports {hbc_dq_OE[13]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~164~322}] -max 0.414 [get_ports {hbc_dq_IN_LO[14] hbc_dq_IN_HI[14]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~164~322}] -min 0.276 [get_ports {hbc_dq_IN_LO[14] hbc_dq_IN_HI[14]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~166~322}] -max 0.263 [get_ports {hbc_dq_OUT_HI[14]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~166~322}] -min -0.140 [get_ports {hbc_dq_OUT_HI[14]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~166~322}] -max 0.263 [get_ports {hbc_dq_OUT_LO[14]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~166~322}] -min -0.140 [get_ports {hbc_dq_OUT_LO[14]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~166~322}] -max 0.263 [get_ports {hbc_dq_OE[14]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~166~322}] -min -0.140 [get_ports {hbc_dq_OE[14]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~165~322}] -max 0.414 [get_ports {hbc_dq_IN_LO[15] hbc_dq_IN_HI[15]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~165~322}] -min 0.276 [get_ports {hbc_dq_IN_LO[15] hbc_dq_IN_HI[15]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~167~322}] -max 0.263 [get_ports {hbc_dq_OUT_HI[15]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~167~322}] -min -0.140 [get_ports {hbc_dq_OUT_HI[15]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~167~322}] -max 0.263 [get_ports {hbc_dq_OUT_LO[15]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~167~322}] -min -0.140 [get_ports {hbc_dq_OUT_LO[15]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~167~322}] -max 0.263 [get_ports {hbc_dq_OE[15]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~167~322}] -min -0.140 [get_ports {hbc_dq_OE[15]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~81~322}] -max 0.414 [get_ports {hbc_rwds_IN_LO[0] hbc_rwds_IN_HI[0]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~81~322}] -min 0.276 [get_ports {hbc_rwds_IN_LO[0] hbc_rwds_IN_HI[0]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~83~322}] -max 0.263 [get_ports {hbc_rwds_OUT_HI[0]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~83~322}] -min -0.140 [get_ports {hbc_rwds_OUT_HI[0]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~83~322}] -max 0.263 [get_ports {hbc_rwds_OUT_LO[0]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~83~322}] -min -0.140 [get_ports {hbc_rwds_OUT_LO[0]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~83~322}] -max 0.263 [get_ports {hbc_rwds_OE[0]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~83~322}] -min -0.140 [get_ports {hbc_rwds_OE[0]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~129~322}] -max 0.414 [get_ports {hbc_rwds_IN_LO[1] hbc_rwds_IN_HI[1]}]
set_input_delay -clock hbramClk_cal -reference_pin [get_ports {hbramClk_cal~CLKOUT~129~322}] -min 0.276 [get_ports {hbc_rwds_IN_LO[1] hbc_rwds_IN_HI[1]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~131~322}] -max 0.263 [get_ports {hbc_rwds_OUT_HI[1]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~131~322}] -min -0.140 [get_ports {hbc_rwds_OUT_HI[1]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~131~322}] -max 0.263 [get_ports {hbc_rwds_OUT_LO[1]}]
set_output_delay -clock_fall -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~131~322}] -min -0.140 [get_ports {hbc_rwds_OUT_LO[1]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~131~322}] -max 0.263 [get_ports {hbc_rwds_OE[1]}]
set_output_delay -clock hbramClk -reference_pin [get_ports {hbramClk~CLKOUT~131~322}] -min -0.140 [get_ports {hbc_rwds_OE[1]}]

# Clock Latency Constraints
############################
# set_clock_latency -source -setup <board_max -1.018> [get_ports {hbramClk}]
# set_clock_latency -source -hold <board_min -0.643> [get_ports {hbramClk}]
# set_clock_latency -source -setup <board_max -1.018> [get_ports {hbramClk90}]
# set_clock_latency -source -hold <board_min -0.643> [get_ports {hbramClk90}]
# set_clock_latency -source -setup <board_max -1.018> [get_ports {hbramClk_cal}]
# set_clock_latency -source -hold <board_min -0.643> [get_ports {hbramClk_cal}]
# set_clock_latency -source -setup <board_max -1.018> [get_ports {clk0}]
# set_clock_latency -source -hold <board_min -0.643> [get_ports {clk0}]
# set_clock_latency -source -setup <board_max -0.958> [get_ports {clk_fb}]
# set_clock_latency -source -hold <board_min -0.604> [get_ports {clk_fb}]
# set_clock_latency -source -setup <board_max -0.958> [get_ports {clk}]
# set_clock_latency -source -hold <board_min -0.604> [get_ports {clk}]
