
// synopsys translate_off
`timescale 1 ns / 1 ps													
// synopsys translate_on

module `IP_MODULE_NAME(efx_dsi_rx) #(
    parameter tLPX_NS = 50,
    parameter tCLK_TERM_EN_NS = 38,
    parameter tD_TERM_EN_NS = 35,
    parameter tHS_SETTLE_NS = 85,
    parameter tHS_PREPARE_ZERO_NS = 145,
    parameter HS_BYTECLK_MHZ = 187,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter NUM_DATA_LANE = 4,
    parameter ENABLE_USER_DESKEWCAL = 0,
    parameter DPHY_CLOCK_MODE = "Continuous",
    parameter ENABLE_BIDIR = 1,
    //bidir TX parameter
    parameter tLP_EXIT_NS = 100,
    parameter BTA_TIMEOUT_NS = 100000,
    parameter tHS_PREPARE_NS = 40,
    parameter tWAKEUP_NS = 1000,
    parameter tHS_EXIT_NS = 100,      
    parameter tHS_ZERO_NS = 105,     
    parameter tHS_TRAIL_NS = 60,
    
    parameter tINIT_NS = 100000,
    parameter PACK_TYPE = 4'b1111,
    parameter PACKET_SEQUENCES = 1,
    parameter PIXEL_FIFO_DEPTH = 2048,
    parameter HS_CMD_FIFO_DEPTH = 128,
    parameter LP_CMD_FIFO_DEPTH = 128,
    parameter LP_CMD_RDATAFIFO_DEPTH = 128
)(
    input logic           reset_n,
    input logic           clk,				//100Mhz
    input logic           reset_byte_HS_n,
    input logic           clk_byte_HS,
    input logic           reset_pixel_n,
    input logic           clk_pixel,
    // LVDS clock lane   
    input logic           Rx_LP_CLK_P, 
	input logic           Rx_LP_CLK_N,
    output logic          Rx_HS_enable_C, 
	output logic          LVDS_termen_C,
	
    // LVDS RX data lane
    input logic  [NUM_DATA_LANE-1:0]      Rx_LP_D_P, 
	input logic  [NUM_DATA_LANE-1:0]      Rx_LP_D_N,
    input logic  [7:0]                    Rx_HS_D_0,
    input logic  [7:0]                    Rx_HS_D_1,
    input logic  [7:0]                    Rx_HS_D_2,
    input logic  [7:0]                    Rx_HS_D_3,
    // control signal to LVDS IO
    output logic [NUM_DATA_LANE-1:0]      Rx_HS_enable_D, 
	output logic [NUM_DATA_LANE-1:0]      LVDS_termen_D,
	output logic [NUM_DATA_LANE-1:0]      fifo_rd_enable,                            
	input  logic [NUM_DATA_LANE-1:0]      fifo_rd_empty,
    output logic [NUM_DATA_LANE-1:0]      DLY_enable_D,
	output logic [NUM_DATA_LANE-1:0]      DLY_inc_D,
	input  logic [NUM_DATA_LANE-1:0]      u_dly_enable_D, //user control the IO delay
	input  logic [NUM_DATA_LANE-1:0]      u_dly_inc_D, //user control the IO delay
	
    //Bidir mode interface ports
    output logic          Tx_LP_D_P,
    output logic          Tx_LP_D_P_OE,
    output logic          Tx_LP_D_N,
    output logic          Tx_LP_D_N_OE,
    //AXI4-Lite Interface
    input                 axi_clk,
    input                 axi_reset_n,
    input          [6:0]  axi_awaddr,//Write Address. byte address.
    input                 axi_awvalid,//Write address valid.
    output logic          axi_awready,//Write address ready.
    input          [31:0] axi_wdata,//Write data bus.
    input                 axi_wvalid,//Write valid.
    output logic          axi_wready,//Write ready.
                          
    output logic          axi_bvalid,//Write response valid.
    input                 axi_bready,//Response ready.      
    input          [6:0]  axi_araddr,//Read address. byte address.
    input                 axi_arvalid,//Read address valid.
    output logic          axi_arready,//Read address ready.
    output logic   [31:0] axi_rdata,//Read data.
    output logic          axi_rvalid,//Read valid.
    input                 axi_rready,//Read ready.
	
    output logic          hsync,
    output logic          vsync,
    output logic [1:0]    vc,
    output logic [15:0]   word_count,
    output logic [63:0]   pixel_data,
    output logic          pixel_data_valid,
    output logic [1:0]    pixel_vc,
    output logic [5:0]    pixel_format,
    output logic [5:0]    datatype,
    input  logic [5:0]    video_format,
`ifdef MIPI_DSI_RX_DEBUG
    input  logic [31:0]   mipi_debug_in,
    output logic [31:0]   mipi_debug_out,
`endif
    output logic          irq
);

logic [7:0] RxDataHS_0, RxDataHS_1, RxDataHS_2, RxDataHS_3, RxDataHS_4, RxDataHS_5, RxDataHS_6, RxDataHS_7;
logic [NUM_DATA_LANE-1:0][7:0] RxDataHS;
logic [NUM_DATA_LANE-1:0] RxValidHS, RxSyncHS;
logic [NUM_DATA_LANE-1:0] RxActiveHS;
logic RxUlpsClkNot, RxUlpsActiveClkNot;
logic [NUM_DATA_LANE-1:0] RxErrEsc, RxErrControl, RxErrSotSyncHS;
logic [NUM_DATA_LANE-1:0] RxUlpsEsc, RxUlpsActiveNot, RxSkewCalHS, RxStopState; 
logic [NUM_DATA_LANE-1:0] RxLPDTEsc;
logic [NUM_DATA_LANE-1:0] RxValidEsc;
logic [7:0] RxDataEsc_0;
logic [7:0] RxDataEsc_1;
logic [7:0] RxDataEsc_2;
logic [7:0] RxDataEsc_3;
logic [7:0] RxDataEsc_4;
logic [7:0] RxDataEsc_5;
logic [7:0] RxDataEsc_6;
logic [7:0] RxDataEsc_7;
logic TxRequestEsc, TxUlpsEsc, TxUlpsExit, TxLpdtEsc;
logic [3:0] TxTriggerEsc;      
logic [7:0] TxDataEsc;        
logic TxValidEsc, TxReadyEsc,  TxStopState,  TxUlpsActiveNot;
logic Direction, TurnRequest, TurnRequest_done, turnaround_timeout;

generate
if (NUM_DATA_LANE == 1) begin
assign RxDataHS[0] = RxDataHS_0;
end             
else if (NUM_DATA_LANE == 2) begin
assign RxDataHS[0] = RxDataHS_0;
assign RxDataHS[1] = RxDataHS_1;
end
else if (NUM_DATA_LANE == 4) begin
assign RxDataHS[0] = RxDataHS_0;
assign RxDataHS[1] = RxDataHS_1;
assign RxDataHS[2] = RxDataHS_2;
assign RxDataHS[3] = RxDataHS_3;
end
endgenerate

`IP_MODULE_NAME(efx_dphy_bidir_rx) #(
    .tLPX_NS              (tLPX_NS),
    .tCLK_TERM_EN_NS      (tCLK_TERM_EN_NS),
    .tD_TERM_EN_NS        (tD_TERM_EN_NS),
    .tHS_SETTLE_NS        (tHS_SETTLE_NS),
    .tHS_PREPARE_ZERO_NS  (tHS_PREPARE_ZERO_NS),
    .HS_BYTECLK_MHZ       (HS_BYTECLK_MHZ),
    .CLOCK_FREQ_MHZ       (CLOCK_FREQ_MHZ),
    .NUM_DATA_LANE        (NUM_DATA_LANE),
    .ENABLE_USER_DESKEWCAL(ENABLE_USER_DESKEWCAL),
    .DPHY_CLOCK_MODE      (DPHY_CLOCK_MODE),
    .ENABLE_BIDIR         (ENABLE_BIDIR),
    .tLP_EXIT_NS          (tLP_EXIT_NS    ),
    .BTA_TIMEOUT_NS       (BTA_TIMEOUT_NS ),
    .tHS_PREPARE_NS       (tHS_PREPARE_NS ),
    .tWAKEUP_NS           (tWAKEUP_NS     ),
    .tHS_EXIT_NS          (tHS_EXIT_NS    ),
    .tHS_ZERO_NS          (tHS_ZERO_NS    ),
    .tHS_TRAIL_NS         (tHS_TRAIL_NS   )
) dphy_bidir_rx_inst (
    .reset_n              (reset_n),
    .clk                  (clk),				
    .reset_byte_HS_n      (reset_byte_HS_n),
    .clk_byte_HS          (clk_byte_HS),
    //To LVDS clock lane   
    .Rx_LP_CLK_P          (Rx_LP_CLK_P), 
	.Rx_LP_CLK_N          (Rx_LP_CLK_N),
    .Rx_HS_enable_C       (Rx_HS_enable_C), 
	.LVDS_termen_C        (LVDS_termen_C), 
	
	//ULPS clock
	.RxUlpsClkNot         (RxUlpsClkNot),
	.RxUlpsActiveClkNot   (RxUlpsActiveClkNot),
	
	//To LVDS data lane 0
	.Rx_LP_D_P            (Rx_LP_D_P     ),
	.Rx_LP_D_N            (Rx_LP_D_N     ),
	.Rx_HS_D_0            (Rx_HS_D_0     ),
	.Rx_HS_D_1            (Rx_HS_D_1     ),
	.Rx_HS_D_2            (Rx_HS_D_2     ),
	.Rx_HS_D_3            (Rx_HS_D_3     ),
	.Rx_HS_D_4            ('h0           ),
	.Rx_HS_D_5            ('h0           ),
	.Rx_HS_D_6            ('h0           ),
	.Rx_HS_D_7            ('h0           ),
	.Rx_HS_enable_D       (Rx_HS_enable_D),
	.LVDS_termen_D        (LVDS_termen_D ),
	.fifo_rd_enable       (fifo_rd_enable),
	.fifo_rd_empty        (fifo_rd_empty ),
	.DLY_enable_D         (DLY_enable_D  ),
	.DLY_inc_D            (DLY_inc_D     ),
	.u_dly_enable_D       (u_dly_enable_D),
	.u_dly_inc_D          (u_dly_inc_D),	                   
 
    .RxUlpsEsc            (RxUlpsEsc),
    .RxUlpsActiveNot      (RxUlpsActiveNot),
    .RxErrEsc             (RxErrEsc),
    .RxErrControl         (RxErrControl),
    .RxErrSotSyncHS       (RxErrSotSyncHS),
    .RxDataHS_0           (RxDataHS_0), 
    .RxDataHS_1           (RxDataHS_1),
    .RxDataHS_2           (RxDataHS_2), 
    .RxDataHS_3           (RxDataHS_3),
    .RxDataHS_4           (RxDataHS_4), 
    .RxDataHS_5           (RxDataHS_5),
    .RxDataHS_6           (RxDataHS_6), 
    .RxDataHS_7           (RxDataHS_7),
    .RxValidHS            (RxValidHS), 
    .RxActiveHS           (RxActiveHS),
    .RxSyncHS             (RxSyncHS),
    .RxSkewCalHS          (RxSkewCalHS),
    .RxStopState          (RxStopState),
    //LPDT mode only supported in DSI
    .RxLPDTEsc            (RxLPDTEsc),
    .RxValidEsc           (RxValidEsc),
    .RxDataEsc_0          (RxDataEsc_0),
    .RxDataEsc_1          (RxDataEsc_1),
    .RxDataEsc_2          (RxDataEsc_2),
    .RxDataEsc_3          (RxDataEsc_3),
    .RxDataEsc_4          (RxDataEsc_4),
    .RxDataEsc_5          (RxDataEsc_5),
    .RxDataEsc_6          (RxDataEsc_6),
    .RxDataEsc_7          (RxDataEsc_7),
    //bidir port
    .Tx_LP_D_P            (Tx_LP_D_P),
    .Tx_LP_D_P_OE         (Tx_LP_D_P_OE),
    .Tx_LP_D_N            (Tx_LP_D_N),
    .Tx_LP_D_N_OE         (Tx_LP_D_N_OE),
    .TxRequestEsc         (TxRequestEsc),   
    .TxTriggerEsc         (TxTriggerEsc),
    .TxUlpsEsc            (TxUlpsEsc),          
    .TxUlpsExit           (TxUlpsExit),         
    .TxLpdtEsc            (TxLpdtEsc),          
    .TxDataEsc            (TxDataEsc),          
    .TxValidEsc           (TxValidEsc),         
    .TxReadyEsc           (TxReadyEsc),         
    .TxStopState          (TxStopState),        
    .TxUlpsActiveNot      (TxUlpsActiveNot),  
    // .Direction            (Direction),
    .TurnRequest          (TurnRequest),
    .TurnRequest_done     (TurnRequest_done),
    .turnaround_timeout   (turnaround_timeout)
);

`IP_MODULE_NAME(efx_dsi_rx_top) #(
    .tINIT_NS              (tINIT_NS),
    .CLOCK_FREQ_MHZ        (CLOCK_FREQ_MHZ),
    .NUM_DATA_LANE         (NUM_DATA_LANE),
    .HS_DATA_WIDTH         (8),
    .PACK_TYPE             (PACK_TYPE),
    .PACKET_SEQUENCES      (PACKET_SEQUENCES),
    .PIXEL_FIFO_DEPTH      (PIXEL_FIFO_DEPTH),
    .HS_CMD_FIFO_DEPTH      (HS_CMD_FIFO_DEPTH),
    .LP_CMD_FIFO_DEPTH      (LP_CMD_FIFO_DEPTH),
    .LP_CMD_RDATAFIFO_DEPTH (LP_CMD_RDATAFIFO_DEPTH)
) efx_dsi_rx_top_inst (
    .reset_n              (reset_n),
    .clk                  (clk),				
    .reset_byte_HS_n      (reset_byte_HS_n),
    .clk_byte_HS          (clk_byte_HS),
    .reset_pixel_n        (reset_pixel_n),
    .clk_pixel            (clk_pixel),
    .phy_clk_byte_HS      (clk_byte_HS),
    .axi_clk              (axi_clk),
    .axi_reset_n          (axi_reset_n),
    .axi_awaddr           (axi_awaddr),
    .axi_awvalid          (axi_awvalid),
    .axi_awready          (axi_awready),
    .axi_wdata            (axi_wdata),
    .axi_wvalid           (axi_wvalid),
    .axi_wready           (axi_wready),                        
    .axi_bvalid           (axi_bvalid),
    .axi_bready           (axi_bready),
    .axi_araddr           (axi_araddr),
    .axi_arvalid          (axi_arvalid),
    .axi_arready          (axi_arready),
    .axi_rdata            (axi_rdata),
    .axi_rvalid           (axi_rvalid),
    .axi_rready           (axi_rready),
    
	.RxUlpsClkNot         (RxUlpsClkNot),
	.RxUlpsActiveClkNot   (RxUlpsActiveClkNot),
    .RxErrEsc             (RxErrEsc),
    .RxErrControl         (RxErrControl),
    .RxErrSotSyncHS       (RxErrSotSyncHS),
    .RxUlpsEsc            (RxUlpsEsc),
    .RxUlpsActiveNot      (RxUlpsActiveNot),
    .RxSkewCalHS          (RxSkewCalHS),
    .RxStopState          (RxStopState),
    .RxValidHS            (RxValidHS),
    .RxSyncHS             (RxSyncHS),
    .RxDataHS             (RxDataHS),
    .RxLPDTEsc            (RxLPDTEsc),
    .RxValidEsc           (RxValidEsc),
    .RxDataEsc            (RxDataEsc_0),
    
    .TxClkEsc             (clk),   
    .TxRequestEsc         (TxRequestEsc),   
    .TxTriggerEsc         (TxTriggerEsc),
    .TxUlpsEsc            (TxUlpsEsc),          
    .TxUlpsExit           (TxUlpsExit),         
    .TxLpdtEsc            (TxLpdtEsc),          
    .TxDataEsc            (TxDataEsc),          
    .TxValidEsc           (TxValidEsc),         
    .TxReadyEsc           (TxReadyEsc),         
    .TxStopState          (TxStopState),        
    .TxUlpsActiveNot      (TxUlpsActiveNot),  
    .TurnRequest          (TurnRequest),
    .TurnRequest_done     (TurnRequest_done),
    .turnaround_timeout   (turnaround_timeout),

    .hsync                (hsync),
    .vsync                (vsync),
    .vc                   (vc),
    .word_count           (word_count),
    .pixel_data           (pixel_data), 
    .pixel_data_valid     (pixel_data_valid),
    .pixel_vc             (pixel_vc),
    .pixel_format         (pixel_format),
    .datatype             (datatype),
    .video_format         (video_format),
`ifdef MIPI_DSI_RX_DEBUG
    .mipi_debug_in        (mipi_debug_in),
    .mipi_debug_out       (mipi_debug_out),
`endif 
    .irq                  (irq)

);


endmodule
