`timescale 1 ns / 1 ps
module `IP_MODULE_NAME(efx_dsi_tx_top) #(
    parameter tINIT_NS = 100000,
    parameter tINIT_SKEWCAL_NS = 100000,
    parameter ENABLE_INIT_SKEWCAL = 1,  
    parameter ENABLE_EOTP = 0,
    parameter NUM_DATA_LANE = 4,
    parameter HS_BYTECLK_MHZ = 125, 
    parameter DPHY_CLOCK_MODE = "Continuous",
    parameter PACK_TYPE = 4'b1111,
    parameter ENABLE_V_LPM_BTA = 0,
    parameter PACKET_SEQUENCES = 1,
    parameter HS_CMD_WDATAFIFO_DEPTH = 32,
    parameter LP_CMD_WDATAFIFO_DEPTH = 32,
    parameter LP_CMD_RDATAFIFO_DEPTH = 32,
    parameter HS_LANE_FIFO_DEPTH = 512,
    parameter HS_DATA_WIDTH = 16,
    parameter ASYNC_STAGE = 2,
    parameter MAX_HRES = 1080,
    parameter PIXEL_FIFO_DEPTH = 2048
)(
    input logic           reset_byte_HS_n,
    input logic           clk_byte_HS,   
    input logic           reset_pixel_n,
    input logic           clk_pixel,
    input logic           reset_esc_n,
    input logic           clk_esc,
    input logic           phy_clk_byte_HS,
    output logic          TxRequestHSc,
    output logic          TxUlpsClk,   
    output logic          TxUlpsExitClk,   
    input  logic          TxUlpsActiveClkNot,
    input  logic          TxStopStateC,
    output logic [NUM_DATA_LANE-1:0]      TxRequestHS,
    output logic [HS_DATA_WIDTH-1:0]      TxDataHS_0,
    output logic [HS_DATA_WIDTH-1:0]      TxDataHS_1,
    output logic [HS_DATA_WIDTH-1:0]      TxDataHS_2,
    output logic [HS_DATA_WIDTH-1:0]      TxDataHS_3,
    output logic [1:0]                    TxReqValidHS0,
    output logic [1:0]                    TxReqValidHS1,
    output logic [1:0]                    TxReqValidHS2,
    output logic [1:0]                    TxReqValidHS3,
    input  logic [NUM_DATA_LANE-1:0]      TxReadyHS,
    output logic [NUM_DATA_LANE-1:0]      TxSkewCalHS,
    output logic [NUM_DATA_LANE-1:0]      TxRequestEsc, 
    output logic [3:0]                    TxTriggerEsc, 
    input  logic [NUM_DATA_LANE-1:0]      TxStopStateD,
    output logic [NUM_DATA_LANE-1:0]      TxUlpsExit,   
    input  logic [NUM_DATA_LANE-1:0]      TxUlpsActiveNot,
    output logic [NUM_DATA_LANE-1:0]      TxUlpsEsc,   
    output logic                          TxLpdtEsc,
    output logic                          TxValidEsc,
    output logic [7:0]                    TxDataEsc_0,
    input  logic                          TxReadyEsc,
    input  logic                          RxClkEsc,
    input  logic [7:0]                    RxDataEsc,
    input  logic                          RxLPDTEsc,
    input  logic                          RxValidEsc,
    input  logic          axi_clk,
    input  logic          axi_reset_n,
    input  logic [6:0]    axi_awaddr,
    input  logic          axi_awvalid,
    output logic          axi_awready,
    input  logic [31:0]   axi_wdata,
    input  logic          axi_wvalid,
    output logic          axi_wready,
    output logic          axi_bvalid,
    input  logic          axi_bready,
    input  logic [6:0]    axi_araddr,
    input  logic          axi_arvalid,
    output logic          axi_arready,
    output logic [31:0]   axi_rdata,
    output logic          axi_rvalid,
    input                 axi_rready,
    input logic           hsync,
    input logic           vsync,
    input logic [1:0]     vc,
    input logic [5:0]     datatype,   
    input logic [63:0]    pixel_data,
    input logic           pixel_data_valid,
    input logic [15:0]    haddr,
    input logic           TurnRequest_dbg,
    input logic           TurnRequest_done,
    output logic          TurnRequest,
    input  logic          turnaround_timeout,
    output logic          irq,
`ifdef MIPI_DSI_TX_DEBUG
    input  logic [31:0]   mipi_debug_in,
    output logic [31:0]   mipi_debug_out,
`endif
    input logic           Direction 
);
genvar i;
//pragma protect
//pragma protect begin
`protected

    MTI!#s''\1[wjin;[TrwroiJ?jRAZo=R;UA}?}~Ao+r?=+GH'}2'_I2GT!-=~CiAT[]'Tma1[|-<
    RKVZp#!a*x7YJ1s?L;Ej-=NE1mVv2W_7@<BDWveIZdO;zI^_QDID#2+s&k$ww}d,#^=$IpBF:R[e
    Y?we'=~[-Gk,zC>Lk__}PA'AIG_wQG,en5}e-n{\'"-w3xU]#=&>}?~:"U|zw~C,}o5Zja3AY!^u
    {D[kDv@J}BOj\isDK+_UQJA'V!-1@OYs!{?]jOlsJo]1Eel==k_GeBi3j*{}H]\j4v_JRp"\Jv;c
    +1@TIX<ZZR5C2r,5V$7A3a]z<j*'>_T=R^@A#{sx{nK#Urk_1}7{K<=Gr,-u~Q@xqxz-aBRG*aD]
    iZ<aJ=A2?uzBT$Gvlo@aK;7{uOQCC*Hja!'Yp4}l#u7WnnG[A{'Rk+E!'=xJYBl~7CN<U!K)M1&i
    v1118Y?mz#]^#75#<=$wm'k'#si7}ADVToR2Ro\$2:C7Gpxo#mI#]O}wWHtn]Tz7As];rz<\@ap*
    U+HHeaI?_#'I}noAjXUb[kX^\_e7R;1$DwWeJ7RQH{=~%QljkgkI!2f'?zri\JuWD-<]7#D_X;^,
    +3*BR7=^h-1Gm+=QQ+&Ez}5:=#p*'Ivi*EzE#7zk)C;-BU*{}+x<D{o,>'lC#oRp,7%XzE^pJ;k+
    +5n8'B'~V'+Z~wz_e3Tnfkv1#zj2@oY7[[;2[2YoX~*~#dE\HKU<o]2OYrJ]em]\D2?RnIOs*BIB
    {m1Kors[E?v!'[\Z-,#<!XgX,K1{riX5Ue=q,>o<@Aop"~sHZ[Xa#puQVpne3M!UEABee2lwIK8]
    E!#U<\-_?5zeB=D3[YYJlR5Vj5z+{WB%I#pWL#wnQ],@H]VJH,n*?$#*v1Jj@EJBJI^@!|QvVnCY
    \x7DJ<,liu]+G2.=?n!B2U_b}AjQlZmQe=K;RIj}>QY2~Qkrwju}GvbV3'Ulv=#'V-_"}JEuBaaD
    0*-}ok}BV;7QQID]uC_oYo48T*[C75&TlDHT-a,L/tAlv-KOZ!B2;{o3Y!t'W\'4Ue][7s2E)weC
    >mIW!B>sUlV#UKo'j4e]u;az$<-RTv,x]R$7J}[3_2CCxW7UwG@l2$Ce*ABx'E3H}Q@1U77CaCmn
    KIAXVo&,YA[lU{[jeGYx2<{BK;^H=J7]eO[U5!k}imZTUX,-aU@=]p,|J[Cp<sa<$]!n'~Y[5]GI
    pyAAJQ_#O^aRT'o_[Gf_}w]tVGi^TQUmO++Z8]vajDX7JRo1!_O_?1p]i53A\k,lUm[x;l@,Hrj$
    QD#BoHs<r=m[wXn[}koOJsH{+j{U+SBL=kv}mCwnIvXo"rzxV}kj!*XB3ll1]v_1o?YD[;op1!XU
    +Q<uwlo#Q',BH1[w2-rls1awU+E^nyVo>wYO$R'\zCoXT>py$>R;]OaaJXO}1$aveMBRi?~Dm]=n
    eZZ7[;wTVpM-o>7G{$BoTw\HnlYo<W2XERA=+xi[jUz\T_@W[,u]Q^W&E#'-o-}mxa[I{=o@[aDK
    o2BvHtD7V@W=k<~zk~Hz_QpCOJolvzK_'wBpw\t2e+zRp3WfNX[]}GiHZ7$O]p?3DRG2~fix7\Kn
    E\=!Q!__Jz,}Uu)VkD,$n2TsXr@HY!j*;C7g2->xKURD7>vwrjUYx5I<^:-aXG^u+JUo{{KT,XH+
    xJ{vHIr>v7t*7=-2*]\p]D}\K\az'QIKO@3OZ;$G1]QiaeQ'JWTvm!$eD3ri5'J[!T,_l7r_SmH!
    3_euOpip]Ir~e5THYzsAVZXIuB#,AOH*?~D#JrR{[5mXI5-32m|G#1jejrJYW_nn=wXT,Yi~6,OH
    {q!p@HA<+jZ*,7+EKCj?1Wn}rT}@-*B7kr?\OJ^VTGIJ7V=<siQ!;[oXUr:4#ork_5$zq-o'B=k[
    {-=EwxsR[,;e#B]-]ATEjmUKUbGGQZy1?Wmx]lZTaG*^IH@vTa~WwnrzToAcl7<_zzx>@p$sQZ]u
    3Apo$w@_5~lpexAAw+B'5wjTV>lk1EppNfBlD$B]nv[awvzap;,}O1U7'wBB'E+z[~N!op7?Yo>2
    *O*rK7+}K7>$>j$v<jzzZ^{a-}rcv2K+,_H1v+{EI-'w!$m3vnn]VHWG$5{D}ZHvU(>1VXcI}O@E
    V=ns_Zom_-\oJjsbqXCm^1j~zV$JB<{=-ZV>I+Bla1$[V\$DR:js}E?n$Rzv<\)JGnza$xUz_JBP
    **GZal<xz)|*:mTm-y2{@G>]nj]|Y'}lr{+u\juJF6K5w'>sl@Y[zsj3+>j-Ha,aCHmwXpB+[-AX
    @$EEXnZ}i-sOwXtG*AsqE+}Vj+]5r(?B{$kx}#Z'a?d.l/.^XRY'~De-U\C_!1}^mjiDA@nOl@*'
    5{utKaAODwTvx''{OJj?=[XTd$?BV-_x+Q*x?YRZl=]H^!{3*>j#$1C,*eo$=Y=jimE7},<<^';Q
    -z.QIr'2p5Ajp^QE2oG5aATlG7mnI$D0Qhv\B21o@+;}okm,znl-'IxvG\UjoROE3^&x!Zpe,oYI
    KnIIKm{mpV-U<d=#*_&;ruxa(CdzK$nx[?15^VV{X3kJeVCQYx!?}W3s*{e,$J{z-+!?anZ_dQU$
    HT5};RW*AHX5+;jol.;vZw:\av^k'<Y*#[uOJ$+F#soiQsZsGKoj{v-!,_Im?,BUuTo;z<$Di<\a
    []Wlb1r~?DQXk|0ZwATQ}'Z{X2XWQn=q5rD@n-V+|}n!ukej7CBZ]D]{mzz^vjTXsQs1w*QVCY>2
    w*AJ_xQQr"Y\@@_k>J*$H~nvJH3R{w={_K]aaj1OV#=_7>2YpnO5}!L[5@p$rRCr@zp^AmuHErp_
    =HkJe?nEGvrHBAwEE+ZXTKzavC>2YE-v;nUzCsmljVxh=$DK_+W,Y{2Wq2nxnVU<H1TZO]15wBWm
    lU=7oC,iX#V$Q\7lo1>*++\^G)y4>[E=kw[OBTrpV?=n_;VEV7{>s#VT;G;u?ECV=*wIz}~U2}0A
    VCph}JX,<=Umoio27-pUsCmIkSD3TrBsGG=inI_zIH^\xo3wuoW[E5sHn2^$z]Wz<>:'Cj@3OBYv
    Q+WOYE~|h^$ixZQszIKsimx7+j}<}R1==,u7KlK-1\Cm^GjR$R}{>NKB!H5,'o1'B['{@j=BDwRr
    Yxpe@JYY<=W7+mrrx\]p?EU7v-pZY!W,XxiQJ^IZ,H]?w_5^^o]uX1e7#Q,G*{v{Doq^<O7TT=3D
    s!j$O,,ow[Cp_$~X=lZXz'?CKoD=JTx)f^jA+Y},T*#K@5_UAoJ{w}w-]|lW7IRZ;n\?Z[7BXQU_
    ^1r>XQCw=H%U-1'2*omCv$}K$$At['RDTaOkuDwEjmQ\-{;G_>B-J_Im+>j1.u*@_ns^sd$*{1q\
    p;p!{a]E[DAIAT}T*Da2[}HJI_Xrr-JTv?IG:x,}p6{p{DOAE2=>1I]]e^O3lZGZKQ2n{nSjQ[3r
    '^Xi<!r_QUn'QDJB?+;GXIl#aDDsIuE?{l{ve@UN>]\Djj$u*nZAyql#UuRe\jSL3+Rzsw'Zq$*W
    Hj;H]u{wn3TUQk*G3B>ER\GH;i*l<*XUpG3j$KE*7z{+~R{vOzYZ3'[*sT{~H3Ro-GT}ARZ<IyCT
    B1BvXe}QK{a{zzr<B;iYViTT~rq!V5}=a,{0GkT7d5]-xqcGI2@ZG<pT[<n_szuO]-T?EZ{~Ha?q
    [=z*!Uu??j~uu5vC?7z5]<@Ow+\~1Cp];__r#5CG5d}rUI3j-Ji-<}iB*p}\2lAQ;m8Rr<#Emj^H
    tR7Rm3l1$#{EjZDZ[_;YEVVrI[UO5cj@j[uE!zVc@Da1;5Am^uOaWR]A1z>JV]]@w]vocLp!57]p
    WZ,Ia=6AzHQpT@C}*Y7V@[YVwYi}$lRN*TwAKCY{k*H@!]o7DG~,xD>Kt9Hw3wzCBC1p*GfoAUI-
    Aa#rnV{{o_u!xn_|=oX*.+xm<A^s]UDoXmVw'-R{@gIRs}zkwEpmx5S7:a,<]GzRGk'$2@S^C[VS
    QQ;Zbp^CJT}X#~{n<C?TTC=CG}\X[wEIU5BiCnwWo>oX'OuX@<TrWj~o@8b,eI3*$}3JQ{2]IY>A
    ,sus=#=/M3_-p2z?~-^_kIa{X:eZY^eWQa_TQT5!JAXCjnRj>\I~w{QMer<'zRo$R}Dadvh71@mg
    V!pulJB>MQY\x^!Q_YoAr[7iDD3T_9QUBB)Ei1T?r1ZB7o2v[kw{OBYOsW-2CZw[vH]+_V[x^^?<
    xJ'~nou;x#o>H\R?[+EwVGzP.ZRE<@72YHEAWoH+}81*pzTpIu:vm5xW7u@15=vIxH2[7Y*Q@IJ7
    [@3q\,wW?D^rx5Es7O#YiG$x}$oGDaWT]ulJ*!VrBQXmX{H[yaaXGuEH*7>W(oW*vf>vau_seXVo
    {W*HY-v_X3fe1=_RZYEJoXvZIRVjyljTx\nUpx>DZu7x_O}B1D3v~]?s_ARY+ls<Z5ZY@DrU!u>>
    GC2~>rB~oB5<oDZVHpi^2gzaD-R}kOU(KT=aC7C?z5x>y#}<Zaxuxw{pmT{73-1z?R#VC$uKe5X^
    acvu+uO7zuFe-TD*!,ZOnAZ1<@Q};O2lUW;ROZ^$GpBqa{;Yv;Rp'e*z.IWxke1$!#];vl#!-ymU
    |#I{eC]o#al~6~Hsk~zuIrA;1%x!<V7<z;B>O{\_z5&~7$p^Q[XGKAU!Q+}$p{{LmlQ5<rXH'Eqe
    pG3OY1KA*pvWOWCsG#!GOA@1T-23Ea2r@K]trDnxv@EWBOYX0=?TO%'@Vx]32HG>\$e?w1!OD{Xl
    Gw73Q<Oan,:k{zU-lQXVpQjA<D@E!GXHUoGJTrvYrT]1>J+f_>el#XQ@rzOkm[A[lp;pGZJr~Q1^
    srRi!$3DE[JRD#}ERmEI2AsCGt\inm5zpK[?j;<+'r+}-1njAXB{Wu,_E<rX5p13Wr@5_-2sHOKY
    5v9_=l=DY?;<h1vlHh7nx{/[@WQ;UUZ^=iu4)11GrQ#+ZG@BBlI;2=Ur+hI_^52a3lxZ!Q2n,mUe
    Vl[KmOx!2Vhlz7;oHWu!,RI\~@vX^ZX1?z@5-QmA]V2O<2K3<7l\#Zl>5Kv55X\arXED3>x$v^{j
    aB<>BwkiRz;\@RkJn<]E$z!Y+1^$<u5~n!VC}oCRkE;BjW,RqG=7<xkVZ5>;Ckl?~zCKs~XRw?|C
    X@_L}Bj]O>_oUD;!\=#pw}#,nz}n[X3E)B\!k=QHlXY7wuQ~_~'5{8dlkD{c\v!]D?ukyXo+~I=B
    *+Ev5aa3I3\=Ak7E;%\$nwY@VnD{[Oj_x\[,B-3<\ZaQ=Q2-}aEuw~vTC-@w]j~aX3}G\Tnw=wp?
    z$vWHwO2X'cOVaV1vVnxn*3Wo@WW>ADO?O^--wuE?\!E\BRjAYV?l,33Dae^z##-soD@axDBnD**
    wG@2HlmA7]}O!5Hm=O!E;n!jpQG=sz?Gw+jz\]rUQ=>olQsx5EjGCA,~5pOAr$}T+lUEl+Yxn<jY
    1kXfpkoryC!UlsW;GOppm;s-575ivII,ajG;!}XmHEa+-NJOmO<v!ID'wR%1S>j;l}Q'#Y'ekOx_
    ?ZU@7,$z=lGH$<U1E~5a_5CZ1$(_'iX;o<1spE?B2eeV#3]L3'IYM>Ve7a^aC^E,>2wI^;E<I8p<
    YTG^ipl=IEoZ7#&][J*hu'w>YQQkB,+k,uX>qjwWETo''E!onLAR{;3XZE4J'VBG%VW\oWY_uYW@
    ItQ~l<j-m[=1ez~nU]?_A[9ieI1Blk{joEwX>UXJz7]\3Hov}\K}$@WsUAsHnXrwRTQ$*Vp:pI<O
    1IU*lH!u*H]\CR1pXOH$$@mu+7*~dt-H12R2;nz{=rWlp''+Beo7BxlGRY\?\pos,OHnQ'xD]jx?
    XW-Vim+vRU3sQGEw+sZVDI<5,ro$w^7ZX5i[akRp@CKUZUKp<HTvvC(c7rOek*ull!5'Djn}<Qux
    '\k{sxlkvkvs<H>J-RVm}\C!%7oZoX'?WGpm*,GnQ4v2\Y@sA2er}x+<]I@QWQ=2}[Yo>O;DOZf$
    <xJ{VEe"$X3JV+unK,i^\+o^l>7nR11\QG27AG^l;'aHTxn!wssA0CGKQ65rpO\!lG;\[,j\?jVx
    37;Rpv1-v~ewK_wzlII<U_V[x2yLv^kQ#T*CBD\ZTxkrF*H*apxkIB_lQiGCk\z2W'_rn^kv,z[=
    HD'\Jion2'B@1s~XU7kxuDm5wm<z3'Kp*R*zeHx<EGY^k0#O+}m7!Q_9=JUmY_AH%Q\V,@}vmK<T
    Ci${aZY'=+l+vJ{5!uGZ~3p]<tWvv}Aj1~Q[XI$sV_~$a>,u_COkEvI#}O"BeBpCHz{KwH=pG2+U
    E$5AH7ie*onT]}Oy1m5oIB@Ij+[<OO+rAop{IKWT5<n5[TjCGr^,+aV=C^mn@{]ODor5*VGXG-Ei
    x]W+HpXvz{E}Q'l;Qm5w=l{!A]Zw;DV$HIjGYeu*2QOxCn5E!C2InQ]=Bx@25+s^yO*CJe'u~Vms
    xneu;^n2$e<HsDQA]$aIwIw{xQQ-rSewOo-Bkn2$;J#<n;e_z39xnZeBj,$xk1?vXU1rYTuRA;Ko
    =w*N*W7Qa7D5|p"5p,VK$7r$3[^d,3vr?RD{{osuAXW;~^le;GOC>AI'D]{'O+K@CZ7x{,!K_k3B
    _*Ua<tEjH2y\^$CppkHxsw;}QUzI!a[j@2-CriK1XXoss*Vw\zJCeuU'7kjVw$I-XH5nY$aDdCEz
    C5aKTQ1UXy_;=<OV[{aG^TJVB;}<aY_K;5v}]Y^p_aka1Jrl@!.IJxJ?{Y;!w<]ERI-j[Q~7D5mR
    vmpk1u;6@zKH)};Joa$CBe>mZ)=Fa}<rHsxTdA'kaDeT[<>pYzp]#,x^we}l+>onKdP-T~UL2s5E
    XH>\^~KvI<xU'-mO3D*r]+$BI,o*__GH;j<A7]Amr}]^T[<eQ;X?X$!x3v=uW5WWWRxK:Y*zZu's
    CU,_OE[~!Nxe+YDIGOQ5#*'BYB$BKw5e=+l-p;'o2okv@vq__m\aUDD1*GuY_ZJuVVssx;$kDpQ^
    K^2{o5+?-]RoW=moU1<#7swqI!-;{BX@Z[#,xX+OEX_x1E<~J<<Elwpi}I~Bop+x2_},#,E],F52
    [TA=#~w=TX4Ja+@O?<u60~}?UY=J<m$<>&nX@rNDWa?p<$e~<
`endprotected
//pragma protect end
