`define IP_UUID _dsitx241128                                 
`define IP_NAME_CONCAT(a,b) a``b                                
`define IP_MODULE_NAME(name) `IP_NAME_CONCAT(name,`IP_UUID)     
//////////////////////////////////////////////////////////////////////////////////////////
//           _____       
//          / _______    Copyright (C) 2013-2024 Efinix Inc. All rights reserved.
//         / /       \   
//        / /  ..    /   
//       / / .'     /    
//    __/ /.'      /     Description:
//   __   \       /      Top IP Module = efx_dsi_tx
//  /_/ /\ \_____/ /     
// ____/  \_______/      
//
// ***************************************************************************************
// Vesion  : 1.00
// Time    : Thu Nov 28 16:47:24 2024
// ***************************************************************************************

`timescale 1 ns / 1 ps
module efx_dsi_tx #(
    parameter tLPX_NS = 100,
    parameter tINIT_NS = 100000,
    parameter tLP_EXIT_NS = 100,
    parameter BTA_TIMEOUT_NS = 100000,
    parameter tD_TERM_EN_NS = 35, 
    parameter tHS_PREPARE_ZERO_NS = 145, 
    parameter tCLK_ZERO_NS = 280,
    parameter tCLK_TRAIL_NS = 60,
    parameter tCLK_PRE_NS = 10,
    parameter tCLK_POST_NS = 60,
    parameter tCLK_PREPARE_NS = 60,
    parameter tHS_PREPARE_NS = 80,
    parameter tWAKEUP_NS = 1000,
    parameter tHS_EXIT_NS = 120,
    parameter tHS_ZERO_NS = 200,
    parameter tHS_TRAIL_NS = 100,
    parameter NUM_DATA_LANE = 4,
    parameter HS_BYTECLK_MHZ = 125,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter DPHY_CLOCK_MODE = "Continuous",
    parameter PACK_TYPE = 4'b1111,
    parameter ENABLE_V_LPM_BTA = 0,
    parameter PACKET_SEQUENCES = 1,
    parameter HS_CMD_WDATAFIFO_DEPTH = 512,
    parameter LP_CMD_WDATAFIFO_DEPTH = 512,
    parameter LP_CMD_RDATAFIFO_DEPTH = 2048,
    parameter MAX_HRES = 1080,
    parameter ENABLE_BIDIR = 1,
    parameter ENABLE_EOTP = 0,
    parameter PIXEL_FIFO_DEPTH = 2048
)(
    input logic           reset_n,
    input logic           clk,				
    input logic           reset_byte_HS_n,
    input logic           clk_byte_HS,
    input logic           reset_pixel_n,
    input logic           clk_pixel,
    output logic          Tx_LP_CLK_P,
	output logic          Tx_LP_CLK_P_OE,
    output logic          Tx_LP_CLK_N,
	output logic          Tx_LP_CLK_N_OE,
	output logic [7:0]    Tx_HS_C,
    output logic          Tx_HS_enable_C,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_P,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_P_OE,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_N,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_N_OE,
    output logic [7:0]                       Tx_HS_D_0,
    output logic [7:0]                       Tx_HS_D_1,
    output logic [7:0]                       Tx_HS_D_2,
    output logic [7:0]                       Tx_HS_D_3,
    output logic [NUM_DATA_LANE-1:0]         Tx_HS_enable_D,
    input  logic          Rx_LP_D_P,
    input  logic          Rx_LP_D_N,
    input  logic          axi_clk,
    input  logic          axi_reset_n,
    input  logic [6:0]    axi_awaddr,
    input  logic          axi_awvalid,
    output logic          axi_awready,
    input  logic [31:0]   axi_wdata,
    input  logic          axi_wvalid,
    output logic          axi_wready,
    output logic          axi_bvalid,
    input  logic          axi_bready,
    input  logic [6:0]    axi_araddr,
    input  logic          axi_arvalid,
    output logic          axi_arready,
    output logic [31:0]   axi_rdata,
    output logic          axi_rvalid,
    input                 axi_rready,
    input logic           hsync,
    input logic           vsync,
    input logic [1:0]     vc,
    input logic [5:0]     datatype,   
    input logic [63:0]    pixel_data,
    input logic           pixel_data_valid,
    input logic [15:0]    haddr,
    input logic           TurnRequest_dbg,
    output logic          TurnRequest_done,
`ifdef MIPI_DSI_TX_DEBUG
    input  logic [31:0]   mipi_debug_in,
    output logic [31:0]   mipi_debug_out,
`endif
    output logic          irq
);
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
ebfr8U221zOv2dGdAbMH08qCLaJ9TlKs2mydDw6uFIp460K3AqRuB2p6Z++ZZOwS
bnep1AsCJ3LyzjjPA4FfF42p+tossE2B/zkIG6ggs7n5sfLTqew+2x91WiQozLhX
q5nJBEzPwKcDJnUwGjBVjF4t4mDh7tiBW6jc3qg/vViMP9No8GfM5gxPP38rQIgQ
iS5n9ZMcHx0Dr8Kosc7xLWEbOE5qxFJcl86AlIG10XpWmL17kXcSmPfPCCWZQ+b1
8dBFq+DMUFhY2xynM08+pUueV0hEqzjg1yFx6poRKoR9al2VY0+0+VPMfcwrC2DH
wDq1u13Ghvp7S9gjSX7Lzg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 8016 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
hckqytkovvgBUwcnEsOBaXM6bqABPdAWHJD3z5SFbAr5WZa4kL98KtBVT7p3X1aE
0rT/aAfQbhuezjgt7PUzFDSRQF5n/OmtAP9YpxGuZJKILUChl94ixLNfvCW6FoTJ
Fng5u0qPRDj/t2Rqg659EhwyVacSoNK7ouKuuLjbEACGk9mgdQe8pInW8O6qg10r
O0SDpIHKkVqWCsOwc22caHbDvNwEDq6SINyq2yMSbE2+Cx1TvrTfLvx7HQjBmqtT
ClHNQlWV7EwxZvD24XFoJQVLCk7kUpHKi/g5dmF5vh/3B56b0P3odudJayWEEcX5
WIZ8kyLIS+rlKKAB0yN3XQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 18144 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
m+4GRxU0jJWGDHqo9HFqeJ0NfmQp18ZMudG/Cc6gZ4prnEWxRAgohS/ilzqMgtfE
lyNxF2I0+5oqM1KbZ/w1lMfWTKtjBfI5lieTIfOBBINmhDi1Y99KbU/KOkccEskf
yQ/ztcS3tFvKytBze4+SKAj09TwHCPv32UMLTdMK8uBRlFlGWlcX2iI/JehCRb6L
168Qw6F0ryHMn13qdgtD5Ky9dmUqUbUNILJkhT2UhEbqlzNAqO3iv2VnTwd+hf7k
hqTMf7fB8W54VQof2CPOJTWp4iD0esEGaqJqYQho1BtyNK+/iAeoc70664vjLsiw
4dEP6uXjliKOx1eOk1pR0w==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 26720 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
Hjax/A2+MhXOZoJcARAYVWo+xUqnZpMK03sl5JRerlKMUt+uTLy+fUrwRWXjDQVC
PRs4qOfF7LhlOL+Zdttbi63cVJ3TDq5FPOB65AvSDwj9UAqj3Y5AW93VmTb/LZPv
7MidhUxIPCxMs5HnLU17wMUDFUcSZP8sK313hpMVI5ByD8tseWt7W+X9kk7+AH6Z
O35zONcoIkfrWUcBIyBwUIZAW9TYKMnay1kkm7k9nefbW9+On97DJIC5Qklf8B/j
Gs/0KvtSNZ3ABkA7DZR3JkNozvh8wWIshI6y0dbVWJaM2qOcSuvgm0IUwAx2V000
lwZr6Rfh0fy9EPjwigdVUQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 6336 )
`pragma protect data_block
8sa/jVHVOwKRyqfS17loEXI8OEEYzyCeSiImj5QLLSXreOodXjYdC2hTSNWEKW0U
nqSG6dbav4l18CzTzhvJM+pkfRqTyn434GcfGBcedvU0J84FbWf8jJwKeiqZG3A2
wsO8eK4MeGtUncPAibpv1k2VRU2AdrGRlBLGBpy8VqXWCZs19oWJM6Eq8VAl9gIr
domZEmiblHjCzfJxlEsfnR553ZSBp70iAxuhkEoETVJSqVYV+y9nuu5IBhTzGQSu
YXOx2tN24cE2lvKddtmsLJ5gVSxrJRdINHOpMMMrfqCmX18kVJOFkGt44NjZ5v3E
cnwcTVHf/x8dpUtgvgA9EuiE86Fp8a7myj3xofluZzCBPzpmmyAkEX19vPoUwUtX
8r3GSvPQs0RZ/2kI5FH9so3CCwBS0ckDIFbK5oUGK0gx6J457kiH5duex2M02/91
6ekvm5QigY1Phaue7d/QCSa18nWhLDFQW7dBCLFhGhalgi1krsb4Um5czoCDu59c
c+JQ8dx2tG00nSD6nUMWT+1vWQkjhTA6pRt0mGNqIIYEzij5OReeXcZIL8ySmoCj
YC3HzZR1lNfJSCRyHehj061ZefAG6V2IJQQzMu/U50v44otf4qu8rclSeZs3fQoB
Z2PWjCOBLfUK42BbxWVaUZw1eNc6DjHDZCAbWT1ruCx7Qh2+iyTJt0p6AHQGSWK8
AaxjdA1RjTPuDV9M1pIB/KV834MuN/up4Ydmhs3Vez7/f7DrCK/ewWiJoSz3zFSq
cKXHgcG+G5U3NOnQLlfTd3pDgvq4eot3tAlK93CYNlGE+JgD4WAz2RYw9uxVPE2d
ni4iiTR7QMYHGj+AsxHz+tHr3aL9pAaEgEA/4pSqSvr3/ZQNbgkJkwOTkIcS7DkP
9myUMSZoWUY1wfonkcf7ViY9q9E9m5x3/98ZkW+FmTzQd6lUdJkcLqlLsFhBL6jy
HR/MssvIexI8cB+dXu4VtNfBGvjNT4w3H/lNsGy2i+A93J3XOaVxvuGwsbGkn6+2
CrYns+uXj5ITsHxXkPjMtKyfgdd3DIttyYdJ31OzsYCDfdLDRdZNup1Qxc3LiJUm
2p7RY6Wg7dniabLNYbXfL65/gEmSvS1j1GftGqf5hlLoE1Pb572yKkW9rNIrA95i
0Sk05C8u+vs/H5Ql/9SZMIVi1V+SZZ69ABXdnY5FIPw+vvALxVctjK3ig4SkN3pM
XDCcU6AaLSt+NaDfa0IBVUkb410VSKXEHxtCT+FFgq1x2FJ3qKNi0OCRLb9Sk6Hn
X+R3+UTEIZD59VYrLel/NII1Ses9tQmv2UA/VgnpEOToO9thncGbQmphMHORwq+4
ojp8o8LS1BMDCoIbXWokf81qLRbH0rAOTxVUNqAjZIn748HrubnGYKoTISknGIQD
9PaBcH798hvdr4n4TCAeQxsP4TGzkhgQQgSwJBEknpCLefiMTXmCz1HwJj5eJPWQ
MjQAq3CdlX8rIgYNu3di3Prj8slWhKf1A53Ing/LTG3pmZJxCCx8ZeqgVCEpmm+o
9yyFqys01jJuefZhNQLf/QdwvccvUdmqckVnaHYYApYmAb6i0EOf/tWVwry+OENh
mzPdS1Zy3tkd342nYkDCO69svHRcMZcxWfgL/3jKDOuEAHEPMWllMxhWFXdb5X7r
JC6xDA78HRFTzBmgzJ+ZsAOP3Hb/EVToG2pHmWC2lGe6+qJNg/tvnhldVdpicymh
ciVpJMrHxn5iRxtdOw/FSHOuwl3KJBthFWk5UwdtzaOhu8VWPUDVDgrWWhh7NWbE
5yUgBs6PQhxsOfDoXsMXsPEjN9pzv9DoOOkKhqbp59jiZa7CdvnXqaIMbq9gk4in
cHISB0a1To/uGPgfMvGi2B+jDMkYBYN4r44EZmo84+p0iA/yXboyAoboJgGI5xuH
h8XG5JSrd7oSZ4k2SPxxVzncaXylGw7hOGuGWTBWOdVPvdt93Zwl/i9Qvgmg/zcZ
Yy4gA3jfMdzgU9zbvedaD+85qOxLfbgOZRzuofeCNzB3v9MlSBtEvjpuNd5tWtMC
eaKBpeROaqzEK7/kQfvoYiha1DL7aLElwY9cNGcDrks7a3MgYCU7QKaS4i7FGTjc
Y8U/SBEL901AbXahY35WS6pyVjI9RqC5GnPhQloRHxJg0SmdDINSMVcvgeV3X1d1
aminAfgjuw02138stOsE20kGMTwZt83zz0pxvYzWzxV7l/Niq6kEppAnpAKPJBlY
+lfov3kKjV4TvXXU0MnH/fmVN9pYBQaoAOxyoJPvLt7MXuz9DO9TySccUqeLFk80
w8FriyNekLr28qc45yKjvY7SbsFzJTkKgE8McQHb9LKL59mXG3TGkyy/x1jL9IVB
/FEOEO6LCbt3PN8tytP/vkuM3iLJ3cPY/ssPiHX93yvYmVtKTWUqcmB0uL/WVxRS
7iBleKwPpUKf3wAw8igwWP7pq+dWMkVIUIIU2cbU5ADPQviRCkoQVOLp2nPkgfJb
a/GRlHKVYR9/4OQUg7BwKx/dMq3gregfIQ7PKeQxpmpLyCbEx0T3cyNR5F0Fp5Hz
+g+8gt61wcN+pz3XRXX9Az9ZG9mn2H5ucNhgdliyHJ9mqqaUpBegJj6+K1qnuh5n
ARJaMt/c3eQYIEnNDn4R21KU6Xhh6Qg1TRpNZEOCyqGiahfWx7hDNv6iADJD+XCR
KzaP+lzdOQLso197A4ijUNr+3dXiwIx1sqSIiL3FC73j+3N1qjFM6Rh//g8lUv61
Gq8bK5NZXV9+mFVl2MJLwaL7ACtPum2yuM5Pt1Prum+WMLVBv/yu66+NMVFbBdpt
rXLo1pQHcI4EJB1OHklI0FO/wcixHVpwKnG4DzW1eBY9wfXyOhdL5Tls8TdeyOTE
haQSzSvku/TMJFZxO3afF3nqvKTE+ttbdeVdjOz9aD5okBWH2XWbrCNBnkPhNVpS
0/mr5tUltkwCPh8Y6/32vPbbGwUOyTbECQ/WRRsf6PJrXmScDuylSIEC7pA3e8g3
XnuxGgNnzX8Jubm4BSWfA6sxGaMpVIWqxU1KgpeIux7wfyvHyginYoJTX7MKU5jh
17TbiRvqZD7B5V/IEGfeE96CqGMpk7VIGJ773qng7T81pxQScRJfC+5RGKpVpjcJ
VFMLfb7XAFAC5kZQQ5SuLs7js2xKR946m06MCKEnr/XlaO4g+6qHqsaSfrmx/Zx4
qIhrTmLuRZrlmwoLJqzcrR5ge55COlkVGgaEyTk88bU0+nyiLN46XYPMIRA0zW6D
TQxtqVEuD0NZ9riGxA/psIJIQdtWmb3zrvVhNtvqM0C/WnOC4YZ4zbHjmpG8WKkB
YIxe1caJ8c4peuQumG+DIjlkDOL/3t7DDPa/kQ3EXC4JmgYYqSgEK5FZI+UeBwBQ
3UObSrFQbMvGkqT6jnTCcMjtLhL6apx4iVPIgUl9wbuzwY671pVwDZR6K3Z/Cljs
TAFkUbefjIaNwSoBBhQdl7XX3xQA4pBDqyObz7ycQjYCARAdnOSrL4KA9Kzy1pjL
odHGGA4oIMsKyjOt91UJUk/GnkLTiu/5Dn+fjU+eWB1ppPAsybtZ7n89h91KOt5s
NM7rPQI8FLoTOtArmJg4zJNfDd1SWCqQ5p8D55iyBcmvy1xfShHahLBEIee8VUMh
VwksSkPFvGZuGeRu+1FUNn8dBydWoh8rYpm4bLNl7AM1Qnp3HBgeaCES0rN+1/UM
L+bomsbFlC0Pjj1BqxNhXT3s4MkS2afnHfa4+Fp+aj0x+xVlnxn/LWYFD8a//eem
7R5fGsrJSuEFlfs2FH8CS2vLXAwS7yPHwYX2uxZDzsNU5sc3fEd2mSUoYqJ6SBBU
YPgyRYdj6tg4c6iFTPXASvUStSFzFYEF7dGSH0lgaIYMK2fe2Wl96VgfTvkouuYK
DS2VTTCQX06STOUHf6OtxX5P/vSGnySGGXvDZeHUcNbVWYDsSNInmoq7kOrw66j8
SyJtIMjMhWrb4F0YP84K9X6fRRPJRHVsbP4uTSA8Aqml/+cxS1KjsT/Zc5Mbi6hP
YLsdML4BufMtO0yXILHUaM1Ivlzwr/xw1tJvugzkthV+r4lYU2pixhCtuJtqwMAj
ZrQmWETCeKEftDDeiGNPyiI7xD2XWFPq1free3b3BO4nGQfOS+/TY/m/COgSCcGM
TPEwfUdgGyCjb6/2TpBCbKlwiq8/Bp75r2yBKjH36aomQ5BMbDOcPhw54l14gt9k
iJWcvbDSmgZtXo2n0Ehy0dsCeJTTTeUItY0iEEY1vja1StMxRLHHMFJX0mgg5TVy
P6iGaQiM7swj9TEgjhfx1fCAm14ZGhfNra7l10pRoKKTI6/w8UdYvOUkVM5dbdOM
fKOo3hcL5CjzVPoQ8zhAvylJF4N57hqS9XetZLvfKymky4EqADcOUD+cRnghoxIN
du107Gbj7F7HQaCQTZaFA9FsOdUdXBw5g4a6reb+eXOUUwaxOzm03s5u9Tgprz29
RFZ2YylOyvsT9vdJPQs1YJOh8vvvSPXuHshTQWpAure0/5F+IQzF/WbyA2ajSU0I
ZUshXpQE4JSlnA/HkF1cpJy3LYlFQmBXZkQRZKbHzE2+7zLHrNDqJdvnpUBRHpCv
xp+hx4mFoDk5dejIDq2DIOKbjyGGFgAsPlCvujjQYfQ1gENuyRinlr3nKEEaTZRB
eM40KrqizWHC7t8VFoCZkjbSxJpOKBk3NfOQ7NY/DPjzz0dJgejTTd3zA0gYiO7l
/QTx4tlvIdSR3XehGKeJp4EH6JvkebqyNm+T3uq5FsIsJ0OLDVN5pbH+YFBat1bx
fYjwF+onWwP6ScTG4AS+0iZv9Z8jc9GbuGemXmaGEItLD6JdG080Wzz6SfnEso/c
L4TDl/LVwM5If9P1stmh8AS5DHwaRybW1H/5kOoiUcnYwu1FVAbD0IxcM92D4OBE
jatkYYPJxmMEVi+RklYrWSPewDRRdKgOXqeLpZ7fQk5Kwh2ud80b0IzohoiwAcrl
eEGi5e4uTK9PvvLJm6Mcszm4RW3lyF0OsZl0t4Iwe4JN4DeEgEbPkpH4MVmkg5Lk
pgneyGjxzuUn1gXc6N7n9/2W7rA/+5mMd6Yval+JC0qToYI7bU9FMmsmC68HqvkU
4khE4OpgifLoYHaoYP1lX3/yZiESeKXfk5dfn6E8cRNxrC9q2XZ8rnCDvFS8c4lD
Qg5XaR9/D5BSi9Ori7AbbdFhrfNX7N5MswFmffLKIctYkX27P+YsLa06bmtwTa0/
u72m+fzLQKoILsObrXxuh/EbY0h4UaecdffLb7axhDzCil5oKGrj6r1n7TAq4tU2
3domCCTXh+YKL5+DAEwCIESrLGOa8HcsBF0ITDeopmQjB8Jsv+lOdpwVPQfnB/Pp
ltTqSlxvjPkFKg6mGNIMmfRl/eOKvkYBJtdVwJk9T1g0KznE4pf9DMJThh8BWWjN
Gix/ffcVZE8/GMTZ1fxy6HsJ6NNHG2I4gxyY+H+wPJonHLKTUd4bu5GKdwV1+0zJ
HaxPK5NOKKNJPCDA890Xmes0BaWkbWchbKdtn8vzNI2pK/cKChorXgTmXdz6l8tu
4tMcMPZMWtPSAKPfxrCbXG171KXchuOjgIcUt9AIUtimfMkT6QXkqr4iQkR4+1dr
NOUzOLbF2zpO9bnWDKpidahvY/ccEK5DzCHXPY8ArKLbclJMh1B3Ub9pyu9sIdHb
vkE/rPIFr8wCpwelV8qdFVPejHmknXQYIHZ/M/kADlPMR3b0zvBwJ3aO8m05bn1S
HS+j1yHtmNl1zTPaS/IguOs1ZaWmDPk7IUlLkOajQvHFefMOEuV7hRNDnK8VL16E
q5x4U1knykgHECBMSMxqyS200s5lQQ27yi7RL5BRsWLLWK6RbkX0QSUsrkYCcN75
eaIT5l9Ddwx9cff9PxDwtGsNz1eA57lrcSnh+jTCeTW0uFimz7a/6apZEaVDrA95
SrRZPdgf3QWwOeLli+GKB0HNz3jKKmGpEKKaKBbVd0Uq4K7zFw2pbxnUMAV2/fZa
yIEeyn2ftEUwPxa4Qu6flhrriD2c8Q6JlfLuuT3QFgjr550exBXmgZ+5X2cKAb6O
SSSAgej0yPjxgxyzjJ30ZXJwhnabMFOWteeAw3oXaXkZlbOI1dycX8/ze8PJP2Um
qvlBL6LsMFcC49wRIEilmXjYsL7oN2S0XnWuAsf/DZlH4iDJRKZMHYNOxoX58SyC
ANdJPztaKiaKxzc6fCOeef3m984yAIsFAlFW79kIj6E4nCOIU1+rnJVNnxKpbpic
5WTN8WLfqc5sMM1mLIBdBRBYjtn2brTSClKXiKgyY3AUyF9Y1cCMk0/WH+NmeBtC
ThninqDJgmEeVG+XukjMKY+JlPUfeMEuMxE7aFmZjC/zgv1Fr2+5z3LkveVVMUAQ
EjDjjzDqjL5nw7P/zDQ5rSJcaruIVzWY3Jo3p1Q6b3U3evQGejXLnQCPTxUp1UU4
gX2cAMQA/di4OsJeo8HRKCn8zm9aV6/T5UhG7xzJ6KzqbyKbbYnUEkWjIq42wH8t
YLH0SlBT9tgqvsdRJz3bpj8Bu+gvRgU9Yo7vDZ9se2UpuwXJ4XXrmgyMRjTsHdVg
NtqqoSRV4U/RAjGEHTz15uFXBST/K9r7c6jzcJe/OOiel39dzOTu2LfRZralEMVf
QZVwECX77ak0AIPiXUaK+VeyECBKxhlu3FXCuCKfMbIGFa7sJr38Utgw4u7AqWXG
OID0IpLHukQmu4SLGzr1uunyohs/e+dLuDrbwud6+Th6x+NxKq6oRKEECYaGAjgo
jU0fjsGE3J9fJuIpwL66YBSAd1vlK6hK+wtzgHahoCg5kGd9Ye/cFVIOUQ5vVUWh
ob2kcj7OazdNWJZwGtCUDuWum9DEvpVHTCwUFqsuG3OdPnyj9hnHt+UP18STejBw
Y31GD6a1+C7ucs0a1RpcHdWwGeI2Sl0aekg5FPwmBYRB/xS667NkMh37c4QwTs6O
UCfKwPyBKwMY/MU9eiMmJJYH6oHDXAbqtKE6I60iKww+/gJpjKdHTJOkp5H+pPXu
2XwkckMPCF1/s0V1pio5X5383iDARp29Q0kJuP+HD5jOhfEwJ7ehZXlRC8ITZqfJ
I21RZPezHR3FsaM9QD6JIlShnlzc6OnYWKlZpUdmX/YWHMpRaeRmunKyz9c77ffa
2HnmEZS7QcBPxaWDEqbyedQEbK8dzE6gdnu5fGDmXmcqNWWre5dmflVYkkd//Cfd
6U6n17txm1icAQlVXzhv7gY+J+ewXQq2zmtz916dayv7v++AkQbJnT2P1aamMNU3
ILM60/dN4DYl4af1WHNAsCn7FhXurTl2Qln3Q1WXoMYIzJ7jA3wA4yRglnKekakP
ZNTSzv+JLfEVFPG8OyAAA2ZIfyCK7oEqQpQ1TJ5TFWUaxCEMWdp33WYvYTjaAwYD
9gKPI/7ATxyXfIEn6BxDyqfZUE7Md/tV+NW1iGgHAevidkOqA507T2/cqFTV+yGQ
0gIjioKE06bfnmcTSkgvOgyq6jCzK5ZM2d1UoPtvTbGTg2vsvNLzqZDnRRhBHljS
g7d8aeS9MNeSmTj718e7//POgA0mOmFwEyy53PCeVshznGHQzXQ3SJa2w/skdefC
nIXoBeEaTYMnJGDwzA+VjVqGAOBuEBFcRqm9uBDZjd1t7+Pl26ystN7XgmI5Ma48
UNIe1dcbS3wNfotHtAPDAXn2SsRNQDnD02VoSu6dciXkwCIb+vt/9Ewqx0xX/AE7
33OwM+OUgT7l1Sdfsb/pAF6fRS/WAteqhIAJdHth1J3nFZcpK7yJTMGsNZj9FR3j
Nue/GIFczg9Xhrb5nU9cqR+7h4GI6ADrPF8zFgWi5cZO3nGrAhU7DctIOAzMB2ew
6ziqzIJAO3+vZ9lApLj9V/1tpEoNbqRdgRin1vBl7PZ+M2X2OFVbTsLSd9No2V2e
GrJfrDGbpYj7lq0K2lfI4sDO8RmYs7VjjR4BIlS/ZkbcWDb62gA8sKMNGL8a6ZTe
cUpBw06sG4R+87EBkwblIb/Uf6GzU8vWwhHs2GHM6lH+QlR1FbJE9zzDiNDloNdD
Kes5oVuYQFYqS5OychY+T8chXz/rkzt8ehjZJVRzEciVq87JLlpAfCJS25vMwg95
a30S8IfdUrOdqMPFVBeC8TlJMlEdJeZqHfObx6AW3velCQl9U/8wHmKzDKJvs3/o
W0I/3Duxlftg4XEEKoWbfZBu7rZ2UDaHkUAsvUyCjhwIfcGoYgM93YmlUBlUO/jP
SFQ4s3cdeseLXwa5U/a46lcI0Bak7qOqkFkr0i8MuVL26pzn4/2oZJO76YUZoqOA
I4qnTo2qceYzQDDf/syjXGzYHzFE1V3xGCwZOy9M+UKXrx6Sz1kl5z6AX7Ca+q0L
kqBpBJmFYETNrMCIgh/nGWjgL2JSxdg2D7bOBJANAVsZ77L4NrniWSUBdPRKtRR/
`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
K4x4VFw/9uIBXGPyeWv1G1Q9vYr4WW+XjPnUQjhMj+Vd+MaLhTDdGdB/z3kAC8eh
80WF7DzuQ5Y0NejKW9gXsPmQFX3ayOt+fWJ2Map/Pn1YeL71UYVmRyNr3VppsU0n
PKluJLyqKV2Vr76T8HMpxnEOHCOjLgCApWuL0H1mIbx1hY/iljoTSRW4szDRfQiH
oeB5BvQ00otm8XPFuZZY5ZusyzzRVeYRgNy6wo95+31kLVB+BcAPJLr/y/i6UK/C
+53aOF9QnFeuJsV09hyiyRPdEkGkqtRH+I6tifrmTMdJ0jcetc5zPHWmp7W+JgHA
IjHzxAuiVx6CtPwBtuXQaQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 832 )
`pragma protect data_block
1VbwXxeGKVdq+BQrBb0tJYrXa07Gpg5qwGUBSZirl+jCgVQ5T1kTXCN2HC3NKFlY
+30RYzUbWG7H5C5aBwa3i1j9ea+N5s5umMh44OEdDwPMlyOIr6fFZ1go6QQ/WsAZ
RxkJWG9ryryiSASYHLV8I901Wrlz4JDGZccgk2WoUQa3DO0kGamMPtCYbvxvoGfc
UmsteDN1m7h1EPXNtPG3ItKkzCMHntyKPUsTzbSEDPIY99LYT1QNNaj9EW6Gp7CK
YqNw7WiQRykRbIIRH5QOY5MiZACxX6ND/dfR/CFD+KRbHuZbN61AZ9gEAwzXcPsQ
zA9VkIiLastpuonbgJaQn8QLoq8Q1bqcBXVtFmD7bDlQ8xLbLejf8yMuvN3XBmOA
/qvqvJqJFk4+J7D2Z/SoBirp870LGC6Cmx450MCHWtQOQ5o8iRMFiMSpopuf24ha
JfwS33yYJtvGxJ6q1IilxthWOE03fvXdMVfldHlZHEY+2TbJJrfd+wtA6EqMGTjH
ibzFnlzgUIP576XIOba1KtZlV1HWYtc7l4YulcQV+jveoa8nrYsW4w/TvJvGsIS7
QwZna93l9jnEHucMe9QKQ1n0GuVN2FDefAGOzJZhzCG4wyiE8L16f3vaV5gzcPCY
iT42Xq55kf1Gw+Icn4HLKCD2R88BbsLvv6ZvUIF33d2kBf7WWPeB/2KrUIhI0y8S
ENfGY7ntNZgI8ExDMS4Jz6soC+cN6vlcBmWjiX6Y7VR2tKRZ0641LZ2OtUband9t
dYWzj4962EGe/cKlvXyXZ92l5cntz51esGlqEII9FT2Qg7ObVOGURyweZLMC6HjB
lAPC331UvDBEXqxVvjh2+b42AuQkDchXomBRaTGP/vro7SNCv485aOnaW2dMz7Nu
A/NbuMv9+Dy2CVQig4Wk4LzruL3OfroZ3M5iBaH6GZz+rg1lHBO5DLwGO4/26Esv
e5UfmhRT95Y88Vp2WraThSfc7jUqnqxT+nO25pb2BB3PEbUt5KcFl+VSQ1c67EeO
NXJy5szIARjI2iw/7L/fTUGroIUUjZoYOo5qxVMZMZtR4zgC/wtrjiXow3+szaNi
16R6ccuTKrU+uKecDDaCQg==
`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
mR6pxLcKpTekOixIkdmH+Ic1cjsuVWeqnb7RrLaEzZ0l4sL3a6/rtEQGxRQAmH5P
E4K7W+En6egfEXKzhEcJlvI7osKcrwD85zwKLfV4kKH2XGhoO+mxX8Ui5GJzu02k
KhLNmCts/wz5vNpURdelXze9PWr5nwbalCsjuJd8k0PkW+zIZGTswRXA5GHBsJZX
+eShaDigk4PvSm5cHWEk1ZVcBA9qLlBaHbVcuVhQ6wufA1JI13mGsG5mNzALPqA+
qmrYjt0v7bqTKCizbahKEPNm/7FMnMugbjAPwDODCK+tEr6GT+FXiZI4eaI219S8
JCTLdY3acjH4pGV6WeZtkA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 13328 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
SOtzZ2s8AYvdXdZP/WZBalG8F3vnqmx7QFb9cXgySyHd/Uodw3VjlfcVlENxSt8u
WKnE5cGtLvaqhbwtSw+/Z69e6mBVhe8n1p5gyTUy3CkQqiRYG5CbJbyohoRJUBDV
fhupmJw9oa+74nAssUwC5m2pRApgOAReMDXBqFFEe9xchF+RTTD62oXeQghqJSoL
hKrI744BFAnCxIKLtKA6BnHOc+hoh87s/7aqQvgwC06fuiNUvmb78CktTxS+EfDl
qtwgkxl/6EkW+8mH5ejT1ZbeIHiEOlAjbaQwvttwte5TUxb6BxpPXJGCmOpz38bO
eGF2et4cK28BWGtlbBymVA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 8800 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
aohDPDu9k1Zs5sNxZXMTObUCOauemPZkUlbvzinNPoaFzeDHHUkVeg1IoDUt4bV4
eN+K2FX2wP8FONEq1LA9j6+sQILAQUR8gOv1gqZy3JFFjKhW/9eTWDQtW7bwHViS
BfM2oSFKnNFJOZSOFTqqyztD9y7tBVX8NlxHm8RH4j6GUEd+Ukz1RV449JArz4W4
5RL/kPkwscN77cbT9RYCueM4j2XHdP75JHsr6LwKtS++1aTRTPIiyE2VCBbNJdMk
IRv3PssDQd7pDUu2ZwPAvxRNT+Pav1gjC/RLDzTY5Z46fpDRHopPCuQxeMy2e3Ph
DpLaX2h1w27OoJbh/RI5lQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 7408 )
`pragma protect data_block
oAytQsh0vnLH430miBA3u1R6OuLQ0ZF/hyvcMz6Vw/5UpGXJ+6U81nZQz0QC8smz
g803GZNQr5D0aOpiSFMgcAYOEB9drEONw8rcVUKoyWc8VgVpPNZb2oG9yzSdbPkP
qZxNbOoaMrLbKRC6RAcMPjqRGOFw1cKx9JwSoMTH1jdSsA//3cxpmXWYDwX/lDEO
1Rq8pDQtWLr8OJBLUIIrlZ1pAHLR4iS4FG4n9z1QKWjJ/QFYAd05zzunZaTWg8/h
5QExQQymJFXPw8ryD9by41qBmw6aB0ByWCm+Y425AJ6B1oNIj0E95eEB6eysCKtY
F96xVu02QzSEcmWQpIBVvK+Rx3gsiM9KzmVMgIbmMdJUz/bfUiW1CEj0WjbHF97j
NaPJq7sAgaMFhPme8tvaLG0MLwz7UpALEkK4W7feIyIlogdsLpkoPwXLClMxSl52
uQLB9d1qJ8Oy6YEoecPKB9zmJ8dmlKfOqRNQJK1VtOTc1tPWAx/VN/yBILQsnStW
xwFkAPOV8DwJSdl/yHeaW8y2gdQgcAoZ9VYorej0b9L/f0PNJsP9sWiFhnYGQeKU
6MmmGxYFJbHqUlcD9EW40cWF7mx5gV1/QW1QRRAUN+Hj9iw8RNQuG0AFYAuHQVh3
lx2KUSvRJ+wjVI2Hp9WsOyCRELr0mdmmqKrYc9YyvKpcwYv92j6MMxk/IR6ZGWI9
C8RYzjRgEAqpPau/QC83Q9EGun9iLPvSvOjskB+TZZ9cYfZK47v5/9kvbEU6+UuO
T/hqZPJ8DdSRo13EG3qw/mDnZTbBEJ4FbxYFCkvsLpRV8uUgakS95EYZem0PXB8R
yoE4lbJZ4nHJJWetxo4vGVXNYI1bu93Nns/9jGFQ/bTgUYVJks+OUEkQHcizrypV
/g8v+XFHN6qELYnfbEhWcims3AJ1qOON/V5YU5gbbeR0SfwckObZWzfYmQ7nyU2v
SOtXkCNbGgG1l6QaJoba8jPAxdnsr5q1gznjjrESV+/+V6aI6H6EDypn5Xbng14C
tke7TLekqXt+UF1TFTmCKCpVOLTO4KwGSjSEsr9leYth+7xa7G3mW+zl6znHZa61
I3JgEIvMr+pHYlrRgB1kqsEaeYxFUYrwbEHKaa1gWcEjm7VQCVhWKYDOmUOmV7Yv
6GZgmV/He+PUZURHevOJPoabDYUzyAvaqxIf5DfJBW/t7b14WkSN0p6jFtqfYrKu
lwnRNTHfrYJQgCQ+Zp5i/A+mLmAsv6EKoOvZk4NipTsIsLGxVuS0uhGG4njJWhYZ
x0TaqIX2KjutGSpnnaVOCJBbyQg5wt//Dd2vE8gPiY8tIujLMd/m4wHiIFj87g4x
e6gnbSKWcmIdujXpKEwzDo1NPTVBVxvFcnCM3Jw4Zf3miS1SyFfQvXCW2SV5OamD
KiJTF/kmOLFH8x7Ynz3XGlE/jinex0W3SeASdCI6WxI8JWdzYkKM/+Ku/IsJnyxk
/FfdnHJCFIScRfySm1NZ2h96DD3X8vlUvAcZ/3FgcS8ajikmdubND/Pd0Nm4zkiV
GAxPw5ehV4jGYOhtkTxXoNLtljprf9RGm6gZ5Q8pJu9iW9mNZq4VAZodOqqYdHTR
vegwQqeeZ1bCdWbyKmaKboW9gHnW3jFXNb3PL4q0K8a9Qfo6dCGQRWlqUD5hQq98
zzVBWeC4fEDd/8s24aEJGgZaSBpgmsqqHFDWBibZfoyYDA+D58apYfYOQZIXRliB
Qp/+ypRPiUYUM5x/xnp9yKvpoggox1j7YJFypR4VvwBW+ak15702D7+qP53JvN4+
05dnky0XaAx0rNGqleJvoZv5NUfH3ICbrSr9HTRvRMkGQlKynDGFJNVVZv8F1KDg
ZzSp7eOPR8n3jfG8XftQr1KOWZetpTs0Gf44m3Dya/KT6e4ILyjw3J1J0aKtkby/
NEzN5gxeeFX6TwF9Hn0PZ6BdVPo1CDUqHrjNqbppOa6zzCwpTVN2KNqNT1j5e4h3
OarCOj7hP42xji4Mr/qfSgBPWcAMDCfnNs3E0q+NGgRxQeAxb+m/ZZtWJ/Sp02LO
6ZFrFAbV0j+cx6iP2Awue+XLNw+smMuolhVbORWno7rMLUSkzuPuH8E8jj1qBEI4
6Et5Mn/Xd06I3TWPd3EJ3lQ+Byz81wmvpDKZOG6QN6mHo4rMujbL6elPGn6uEiw6
qofATsc1g08WDhEjeVGr+NnhEqwmW5X7GP2vuUsYlDQqUnM3zRVCj15wCMyCag76
E447NYxeFvzr99W7KKiYhpsE3xBzq0XsBUCmlaKByxFU7d7z4t95o8N7wYW1SLhV
H5A7So37ttz9o4Rsc0R3AZCL2Ul6fM5nybhlI2bZZzNpMGEla7KIb+yfBXXxzu4y
FT+Z5h4cQxxLSzJnOHmR/9a15gRKKa4BQIRWnsENl1ZRrBcctNYvuSWjmlq2uYVh
y4Rj/YM1C2EIh7hPyf5H9hYUZQkdAIJgAMGwpO8Jg8wrPptZx7iULGAzSIPS4KoN
+ZwX+kJ2uxifF4yYgNcAdz3b5x52EVNNNCQUUdEnySZ0zxTfEw2cV6JXtd7SVyc6
Cgp1T/RPZt89QugNMDDKplOSwYqscgyUxYlGJmu4gYg7pbaxz6EsDIyNyEVb7dQ2
+HzNqR53zxCRkuUNBSccZ0drh+W2zqXfAMiKnHR05oxKBguoV25GAkywMPnjuOgl
v/7bbjVUD1XLdJvdVdoPD0oD/bUyL42cUA/E6HL+8n1aR3ESXM+OqZCKgrbDcg6Y
n5VIRYipm6ccm4CoINV2twf4EMP7HwDLySppPwULQLZy0797DVyUDNmS8uyBIaSp
mqf9lZpq99v6MebodTRMaASsoiBAHNtw0ITwrvR381znBLuDP+KKFTvzw4Imv+ba
bRD6qb+kKiNTa3UtXxe++O1+5MDSbVzjbBwUyyliC77bCMVMvcSP6hM0ODCeg5ZS
hrEW+es6iuuxymDj59RnMgf87hVuz+GUT0fjWvlTf9ACAP0h6GILznJQ5vLIAsm2
kaE3Trjx3TvPv4YbdID52OP0cGfM8957XmfmQkeuEvkFcDTPwCeS4ioWBaq2xAaz
bMq5fHcgx5u7GcAXeB0E0DBsleUrBL4db5XZoWI0EuP9GVVvGNCX2YiJ3jG6siix
+8VBQvLXDKCWeYGHJbPyhhX/OY+KZUcpdXlp6RW9Pc2Ul1ICZWnuOKr0khuKcHe4
0VF5th7VPTvk5PCpFtwdJQBFEbAV9UPpZLob7mEI9v+foEVyZ4EmuygmK1voDYf8
lCfZhkxCaFvvJC92BKOW3+06OvzPNdrerc9CY7G+zE4c2TKWH5kSPOQbm+Xy0xd1
4t8ga/NccMQ4sNNrALUmlUkvNwvRU0r3MZS2+4rz1N0hK0DY6P2Z56fXKRm/07Bf
AJmbVHNgy7kd3Go9PPtSN4axBvJSv+HXZfW/1KQSjueqNtksUGbTlPFfoGbVgg8N
jqkFOxSv1gkTQpXY7YQcsOQbgrAjkzBXyPOOrcqZK63JCqGMeQwteAOlN38hCMfF
arcpaByc3zZKxqTEvLwpmDF+C4qwl1gPyiTilFtsL/sB7gIK6kvUQSMKx6PqLsBb
UD8Rhz3UoVlTbhE/FJvCtmdBBnptul07vHfk/K0bI8cViTuP9gTij2mUTDdEiIhs
JpH0qzc1uHKWITAnh+ieOkJB/iZogntBWkPO57FdiR3lB7AwEcqvMiCJmPF6gJhX
7Gvj0ibJhCnnVfH/3nxKHXq/O4HZElHqkZKCJc4rJ0W1DOeqrlA9xb5BMhRZIX03
BcdKzpNI1sPzSS+V/Sn1v2h89VqlmfjwyDqT3dDsFiusVLJ0CRptyAieAxMv1gAV
oqzWargpbK8deKdF81G4w9ElcEAmE+lMfRX2ljJR/4CYGdj6pgGGmJPNE2ywnxlp
fe09uw5AHRNcg1iX7aMaZuvhttAQWwddKgEgisQq18IaouFO2awMSal2Q0fpQnVE
dYbZGfiXLKA+vq2rtpmrAUtjUknVWGskVkuxH991FKMbfdVR5gIzR7J+KoUvuVka
6Qqb7iGrVJCngUjB5uzYSv9NOs23zqJzymhf6kwfTJqbjvdAvGaKyZahbaLUdYM7
YTJSdE44uLYVpA82hl2iacVg1vf+8tCXutdgtnWzMNvEbnn7GdtlHdtXKXaDrbZD
FRzsxO7e10aJlRXk0ziakg5Jn64fzwxuq5BXE6Oe6lZC+7HP9RHNkTa5jUKEWomf
pRgw4+NW0Deo6cG3R5jcf8eclxpic5O90ZwQ0q5QyXZzWVGkZcUC1lE8If8OxfFh
19MisNHrm6hYyUs/Y4+vNkYg4myDHK8Fw9P1+LZ13sOkpopunbzzM7iAIZDKIvxs
6Ru6d5ecHDVduTr10EE5y39iv3uJFL/y5Osrejy80rdtKoytwpxwuczQShYiJKNV
SWsvvQbRDt1eeHsmihg5HBkFmtDJR23R0Tgij1S5dJnNwbEU4zfz+HLFg545XenL
n96Hkq7fvvez9wCSJJT3RVpqdInmMarQ4hL/IJqJCQtoQlCNSlwkdeplUJHjfk9Z
6OaCHOIh2u2M1emmuPHC9NiDA9luA0tbnob4MH7XSqjb8xutzSP6BwyszTt5nNGD
pFEA/9aGx2lthJmAf86P0ZmRE44OBqYh6yGtPOJ8t8y9LSekJeG22smWouikFFdf
SA43Nto12bgrDcmMr9exfE9s6Nb2CpgbWfg6nC9rxeHwdBZRci5RssOdgAsZZmz5
UJWbp3Gaj+uJK85z91Iprsqn1+KpBIxeJ6t/g29G6wjBflByjHSqo+Z+7PMtcrK8
YbGKs4BjGbMmsu4K7pndp15uYfhdBYogLm9Pvhip4YU48OyfF9FAMxVvFrQskN7B
wMT5knQGJpOlcCJP4ibRQl793B4TvsTetPH9gHGpTBeUjQTMo2Af35GpCVvQZ0Ln
vh1cGrvOpqBPcMHbS7s9O0z8BHwsAH95VwytKLa1WPMZuaVn9FXJ4jqhXai2m8Js
UElgV6r+Rj1XjH1s+pvRvcdqEF3cG20BiOj6msT5kyVFFYPZ17R96ummu6l8ed7o
0JxSQoh/Rd5/On5IA6hUYb3yHyL3GM57BFxJG6R+pa7/dpGbhQu1IZFFSLS+pL6w
4HGl+k9PPEyTikU/KlSV+zPNNjhKsgd/AEpE1lbpl2qs6TcSvQfytDa8UYQlUZRP
xkhybc9/U2j+vvxQYkIIg4yXZynnqw7MD/x0Xjl12fp7cAiGUe6aWyXlXjD30nEy
pGwFNFoseqM0WHbZKz8mWJc8weEXOwBQEmkS5yyyPSKVDxe8LSvNJFSkOjVAR8Ov
YT6/IuB5X44mGXxD08zDxfc1WrhPgK/hbbF4euaDTJf6oS5F2CuFV57nolccPWRR
FTTx7EcFMgH9xXs5ayWKkJj+j2PTPBkXwN5qm22Jf5fNtwbshMKRg0KwUGAO1tdx
JUIMANLjX3dJ742Ff3JydZSwsbjDx5Bj2FQoG/bLEPOVrRdAwwx5T0JED80guRKd
FUGU4UnSz/H3xHE93XWze3u0UE9DF08uByWjV5YQn2k6TRLmeg4lQ5Tzx3PM8gYQ
vlcWa8UTYio4Nl/+9FpUgxttk1AApYI7yIeAob2bwVQxDkX0iSPygH/W7CL2YWS7
qgTWVaHk/dlmMIDwIbgb2GlQbaUZO+sfL5/M7j7VZs+nHGunPPTNmPUi+tBzr+Zk
OzGYyTtELHrmug9/v2P7EkSDSnydLh4+2CmOakSHnTqtqjbPN1WPaJaAEWCZqAeN
YDoYdVgwiQUQtP5Yz0H6uj4WEjMEcmYn50KEP6UOvSf16Jzh7fqHmtWrvIswVFiz
q4MFNc5788PH51wMr75ECo+eZipekA06WWNbqWo+/0mQlTCIgga+ZYjIYakc7Rrv
cKxTvMvKEfXwT8TTLXBOasD7pkrLCHoQjZZZ80C4dtctUhj5WF5N55VNjLShxzQn
NIGzrSwnmc/QtvYsP52Dk20c8HEGn9uNxkCTbxmUcghVWHjEWKxMszzgS+eU4zkL
kYSb9D7eva8R5EOseB7zgjjzTgdAt2mG8AfgySgBD2h2rhtuR2Jib0GFcjCXCzfW
9uhU9foR0lAmJqFKL8lHO9e0CcLi0rSwc37wBzbG9qew9IaBr5DeBBH+0gHAMqFD
emKo7Za+MkdfS+Lgf3C8VTkh7+x86fNqXRcBmJvoTS84SA+vQcpZ3LvJeMoNcXrb
sNjztsSUtatD9iI5sPhtSOTkoJKEXs5iO5wU6S6T3jyvsBycCCB4KMvDc7bA8tmr
t/iRe9UozM4QrORMCfowAA4x5EFF3EW9U1ZM061AqYcrVwYbwdtyOQG5ZhkPgoA3
NodDJcxa3ZvGr0oGCIpABrT9+LTC6L05e1+z388joyy2XpcF0tFaoc4j7jHI8BXL
Il3Yo3p0iyJ2avSGPK5Tu2UsWurXr3W5IBpk//KyPdAkrsSagggOeRavcUq4GNPs
WRc1Rujd+PAjPWtwc3DX6fthY3Tgfg4EepI8HVcEFeKXcCDf6uNTuIX8MYrOfxeT
2CzRvPwfaHGwYP+Y8NiSstU3lxH1OZLk//KWyV+E0+IK/WfJKsDp7N7QRfW2+qJu
9ifXdu2dkKDE7iG7rb8XPvH6lqnY4KrLpWoHDH0fbfbg5zqJl9uKtcWUQGr+SSAT
5JENn0N+B7aQF2nbPqQTj74x8Olnuf5mRCeyAqnBbPqWn9Wq8ssGTIQb+U0mDLSm
1yXC0CAT2ynHLlM37qhsr25AnGG63JCT/AAkttVB9qjEnhiz6vsLd6XPuByZdilF
zbIgTqYWKpWUkbYGnLk9xUWxnhF1kj++S4nFXxaTlYZln0yoKzXhPWGzrUUnOZZK
tsdlVeLRDCTVNKSxnp5qG+/Pf6u5rE1KWkITMCFV8v0uT6qwe2UwsexdDFE3mtAn
u6ID8z5JQqnAZQT9cMWn5sTDJcNZ3T/Dd9P7dI4PYyUntsm/fU48ErV0F0C3N54z
H8tIZpWsDLkcBmpX4WsGtpbwxObxbHDdYaAFEXakmvQ/28pqHBfLIQZnr2fYz7Mv
fgl1BGOeaPvjKU1rjuO42sT0cXBE7WhJVnnsA9zkWMiyDkem8u4ZOi4F1WVrete0
zmANpcno5gyNkXzt5lz6ml7X2kYRYOlTOp80Ez/ej3eO0Fu96iADxkTHbtC7eoW2
dQogJhvJE3AwTrWiPFbNjUd89yCUxyBYLeOrUiuo9SZ7yhmfZ01PAicsDmvPFawT
yhRDp0F04sDCIkYtavhzJNcjuql1ph5NUujKsGQZLedoV6F+8XIXHw5AJ2caDAyp
gQMd3dFJtyKgMGvPC6qBiEi1dZ/IsQu/sJhjiSMFgF3HOyjSdhGYyhxqUcKpFdZT
q6rktU96AF9VZJaAEsWLqol7lCT21HtXZuZVa7oWN47bvFHy6Qy3s0cHQxVmUOZn
152xNnGORn8MigENR5i7kV3blUH1bOKUeO5PlHv+e6+m9W74wp2TGCrYgk7i0IV6
ai84aaEkGLiYvaqZrv9H1gHEWUukTxdEIr61LDhtI5orYc6sxNh+xBknvIqDIIgM
ERs/bOzO0P/gr/gSwod/TqNHMMVuMv5/S0buR5JFj3e74gqxeVZFSSwAfHEj2a9b
DkiVctgfW/UZcNBk9bCrKfAfWdlsjGF8W8I+nUVELt/Q+1rU8hMmXsCBXMggZo98
S0NFuigSDPyU7VvQLD3Up+pNqQGg0BC9SbV4icqZO8pu7Src5/rknkvdoaBaEssS
1nYoCuXz5gOaiyOQ1UXzMOOnn89qM/bjUDIi42OX98ADNmPqeewloUUnGBgfE9ZF
EtwHh2pUpUUvtVjmjETBlf6p6ERlh+HRm3GARjkWqj2BfL0zOu4lw1r92IXwY6dU
kw31mRCG9UFNwXEd+TZxsXsKCEu6OQe+2G4l8NADMevaKt9gz7Ni1MjpD9OLu/DP
45vB1jRfC5qvKdf1Hf30feAMmG0zUYVJWGUZPSeVaq+PvfxLjp0r429u5v3jdkDk
UMVzXmrxJYU5JO5/oo9XlgBcU1//kkQSq0YBr1vosnqcQ9doxSWr1/KSk3uX1MMd
41PEpEnbhGB8AEiP3SW8fG+t6QFzPM4fBCUX37Yhc163x3Y7x0+p+KCAJ8Er91Bt
+wTc/8IzlDDbKOpojWxeU8O2q6mGu+6E2R4AqZWjiQiJZR1JFE1cCiSqFvcTd6mM
RQb3Dsr+unrXiYUGawfxZlI1ljEdXKBVThc8vcwQylcLPlc5t64/gWib19WfvLaN
W0za5agx7VHbUKhEszkFmsSA4VJ2u180vrEdLZ38AP8wVnq9wFyONGglBoCRuzjF
yzmNVzcZoyCSxap7gCRPNqtjHkQLhfkqHlIHRmdvLZ/eUTSBbXwVhjnT/S3MYytH
DODLZCVs0B/nQrB6P9Azbpj2NxYoC3XKXIK6wMGjohxUrSny2iOyU4eyw6Yv/4Ml
dH01kd3BFg1iWiE9WYOLKNHsIAjfYV9TvKYkz6PssTL6bS2n5a8AzGagxu2GdPaH
qk3W+jsE9VafkDxq8qnZcMEBd6o+1WwXS4vAp6fcFmKt7Uwv22Kb829DTP81S0JN
v5N3bWXX8b+cQtJ+Jrr6fOWUdNks3yPN24XEBHQ0mI0twWUjLg80TC1l+Q48c4xf
5sR4tsPltncWZKkBwKdf1nYAaBHVLtEciPr0Q+IwxzTtN8D+gk0BQayL4PsV2Iz9
VNg0KSPsm75I/7kkgbDBFzSdleK4JdaFfmstPfO5uOq7K2ZmGv7OM2BfoOPjZykl
0FB2ybIqQTtGveM3Dkv2Qrg+4EugF0PBR/jvQqSwywhbi9ZRf0nkvKVOEuEZyeou
vv9LhHq61Eis7kdN0I0sS4RwacxHvt+t221r/noCeL4fZJMXjN00btINjnL02rFS
yvB693GSCzS5kwB8rNOnwmZSdQBahVQWM+ovPdGSdAMmzfBxFUs66GsLbg2Vut4z
dJ+JvgdqsP5MiISeZUPkCC0U9oEUjvCdkJWjyjLOjUrBoJ7ymkujvdO9Tp1XCg7k
clno/rgiM3T76Y0tknZ1806zfY5geJ5zIo5NAsIpTChDVtSQD/ksxV3T8rAQFaMa
4ZQUoTBkB1rskIGoo5GRAAmIccm2jMBQU5YbQNiwxhFSIGpKwxVD0DaYh4uPG/MP
yu2Y6O7lL903lH1kZuTpvBKjRnTfmRGZu8fQnlKo9WSmmQn94j2S+8mW7mpp+oY8
ZrYVCdWhMjQ5FHT/zEpwOTaZPUzdT+fKnwWocqLB6yq8FtxRCqvio/dstG7DLFH/
fSH30HlHtUCj30x1kJWMV0ce10HRAmenqwKVyu4O9hCrxL4QmS67eFHv6BJOCFqM
ypkRcS9mEIyPTRKOqa6fqnshK1LsW0n8jFqItb//PgPyVit++lv/x5xiogE50RIz
Ss2gII0QL3Bym/iIyaf2sszt7rbSUmTw0DlEd2oIO2MyThVFKi1REhoeYVw13kQi
/BQ6QYurYkM7oihlMG9qktz0fEVsqcAxnpQgafYWo1eEJiuFxeAv4TvLiKJ6n1+y
oEsDA/18rssK45waypIwBIF7tT57Y/Usr35ZSEjpq0xWYfVEHYM0oPZE6SzFGXW2
Qsv6HAS9OeeQcsxhpaUwaguJ9vLWyeLQhPk6nR3BK+ShOH1871D/nhdq5/ZXA2RU
r8eDOrckWDO+vs+XV45Gjp3PidzPKTfNijeVWMweZLI2e3a4BEHbeDRICEcm50NJ
6reQKLIvAswryphqNU399ckG2QAEHcLqcO3ujTWoRbV78T3PkrddNSXPpeNlFp1v
uE41gYgrGsn4S5vfFEHPEcxlpelp/qfnXfn0jxeOcjfnTVxFT+a9VZz5vLOCRX99
RPMWq0b+U8OvTYx7dwSolw==
`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
Y4IRuWjiFjWT5UBJZ+M9W1dFSY+LkcliEkzCaPFT3VVZuFPy8WwIn5enUegRxvju
K65I1WSSTKFBo8ocjMXvRWRHSV+gm7S2Pq6J6M43RYgLrnHXH2InkSx+JctTcj2k
lbot+lDEIowwREqwh8baAdXS7D8cuQCuDNAj+zqqY/T9Zhb2HEJ7sMo0xruQtbup
6enVreOX0KYzdWOEJv+RTXU2QDy8Wt/2vEd8QN2hUpQrBJzg4nzcPDTh4274GvgU
p/LQgcA6r9ZQoEZ1Z226OjTHI6807yGCgx1D483cMvhhHs7j/IVFUk9KN0rSDkJR
t45NXgTiMhn/fDziGXpjBQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 15952 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
OYBKJ0p2moNJAEzbpuu/CmDkuyACc6NulC+VmBcIwJMFoPEcZZatw1KEkoOerPJ4
ITEerdYicCQjHw+gSTODG/Zd8dZopFI3YzAJXyJYG4jE+R/525JMQCQK2wHvxV2K
3M2MsKkPmr08UZG60DAk9JD/uMEgNZbab39R1qwFYN2FywrHen9ZyHfHJk0ksAqx
31tn957n6AJaaWmJguPf+hq/4yoGErwWPnozrr07Hzy7Duu5s0TbDbh6pxM8I9jr
/pAXx8MYT60ipM27dxiO+/a6q8JjyBNw1VYHMtJsWN/r6oY+GQP197wYSn28/EJt
JeC2/X8SVI8HoH2ipyznyg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 5616 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
e3wnT5DeCC792N/gPClKCGtOikiJOedzoODB5JpUfd5ONIpwgyG6gShPotVzH6mT
W4OflagIyY+N+rEOl4NmcieCi4TCsvpHpT6M1GTp6hvCTflhrD1Gj0ibABifo8wR
r2aGEVKkFgbhIJz2OE0nIwtRJbX9tS/PtXEBKyhDOzGILM5mYa/TsxWl8f88L0Tc
Xkox7TL4GwNijOSV0EBdSnBPztqcsGnPC/ppQAPBGqhIImO0t3i4K+LRkxUis6kf
d0QGrjfwvHRt8h8RnFOhrMy8tOMmC8mH9ANUZLjXP73O3S0D2EvbfCGcN5FbFZR4
FTphpxL3smX+K6Qhg/DI8A==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 6160 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
hyrpyirxhbBxdxDN4HOCaw3lZLxEPGnQ4pFpc9Qd3MO0AkPavLS2zVF5vdImhd/O
SSy0JaiqqLdpEm3gu+TaCPsRRh2+jCcOkC2SibiuWLrMgfuv6TA5Hfj8VGOtgdOT
6gFOQtcZXZHdtTW3KZUOTLc+I3WoHErHoR+C6ESyyAuAn18PRz1H9KoAGjtWxvIz
36mLnVqAcU/49wEBCM/WpEq8YcgFooTFsmydNgmKnyetJOFY2Zhvgt0BuCElSxF1
A0mojLJRDDKJH1Ad0aNUXWwOiaVaXlFTZJx7pdrc9zA2KeDqauVUiMp/fZWmK7g+
j/h6CzyCqnwAtN4HhTOfHg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 3328 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
H+4AoYYrFenGxUyVuROIeY2NoPdRj94eHoEAlPcbKfbpUrT3yppKHRSyTQZgBdQA
ZIHde1UlIpKcIN6u8d5P79FhmBoZgeoSxG54d1dowM6IzJMPSq6TgieFdUMpDPCo
hb6krO18c0jXamp6Va05Te+T2Hnlj3cBjLJqxegbY+9QE2AH1zHV4W/kJ3MX6Dmn
covite6UXynxyfOeH67RrBYptf3yL4MhyxMyIobe8tpc9YXvKZmIQcwc839RT2lS
1PZqmPxX8vDSA2GHt8DcCHhIs4uuoDRJ8071lBI0VS/BkwPWjoYOj6ptdLWh3/7e
15vYBMYSegJE5oNnd2+jPw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 16304 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
Fm1tKLLxGT06lt/DF5CYCP9qAw5riMqWv6QjSTyCpZr4s1yG1mP5T4iewYGs4V+9
ZEwK35i6r88xu86Tfy6ZFeManqRVlKXpPykFMwA8awAS3jCjipa9OOwnq6s9tbMJ
eqlRe3JwErsKtItBLaMooQo+lWhuydTlMReiOTCr4Z29LOpdEF7zwu4nVxQmiY1k
yGDS1rZ9AkPzQwpEv9Wge3vlYqmw77hgpEQx0mJ8hMyCN6bugDiYwU6Zce1Ch824
KkAgOQC+4Jst+ri3qB3370WPbgii82Zg4z5LaA8j2kkAg68zJ9br2Fp+zmQfwPs3
2quxU5t3GdeFXs9HxeunZA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 16864 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
gHgBhGoxwg0ObiLz2yhybM9bjx82d5nOn+tssUyoEVPVqKwDR/NNfx1O60aIzspJ
C1cA+HHp6vwFDxCc3FFGnwKetjSj206YWC6Ux/qHCm+wmy5OA2TSun6bzedz/Bdl
P4SlVHiQGrwtHsFdfCFoMC4Ae1Jb1o3oR3R8CaK/FRYu3BxkggGDHGVSEJeTnrBZ
sLCX5uqIEMIP+7RrEgRka88a8gzMpffGI8JsognqKhBMgKe4PT3DX7JjDXzJkQzo
FWPXldHZPiieoXH4idSlW3sA4n2jquF4TFwFsj1HHUdcpxDBNq9nNQRNnHxKb8Kc
ZXF745JPZORL6Vn/R5mD8Q==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 9952 )
`pragma protect data_block
7FX6YJrNoo2Vu2C3O+wCvcX3STxU/9IAfhcbsqM/gNtgGCLkXO5rw70FXHS8bVr/
flVRbFtjdg202KUzeKmAizlQSz5SUwhqZiT3FVjhF7WgRJK5xOPF9RlnWRj8pmO+
xNkTgp8SisPK7H4aMxYGGa5E89rS/DNyStKlfJXaGFdaEf2xETOd8Vrrhv9HAWUM
3hmFZRcZG4q16XJz8W99SYeqbJ2vmDGk0HYc05VFnMQWx5qm9AVzNKpyIE81hBOn
fARIuZPu0taDJjjgqHmN9o0C1jlag2xMVzUbsHZVs+STdJ1f+hqzD/qoCYBaFbRb
oLXrCdU8Gr9nHqYx0mOYN7S1GOG4W4mLqMKoX9Ll4v8igPig/BWHvINt0UGL4Ru1
mtrvJnR8IyoswxZLJt+F4nK+IgfQ2CAPKmr4QiXcPnpvzDpJhAwMpscUK6N9CdeK
iA8mLliC5KkNrR7HipkCLyeoiHIFDqOy//wBLFEJ0ouW0nbqu4/mdBvyvlPIHD9e
8crsgzCaXId71OxwgshjSLFDVJljmOb7Y0qWZ5WHr0o4zG1NL2faGscQExbyb+DV
lKsIZWVLqtY6p2P7LtVdkIPt6xIsz0+PawA3FbKRxjN94FpxCA/puOfNohWk3qoV
zGV49QRd8YDiFy14Iw36qohVmCpYCZmk9zphpB9D5QC3lzratgyp9bOl7pQpJMj1
Ar62hLGdeGJKwtcTzKIuUjajzVLj/sSLO0eQdvFR66JuwSN0zw1XeLr3zcTvKS0T
jqTacdxojTsIWD+e2vxsSw0nNHra8xKh6Uv+wn/+eV+0mN+Dv9m7I/TnHcHJq/mg
Vr9aTMRLfs5y58mi+G58awAGHhCxf4X/WitJ2rjphfO9aJfwZUEEaUCG9AMOW1Tr
FnbZqut16dcl6ct8QvcbakPSBBOiAcQ8ljust47BDF+IBu25rtIKaeOlPydIipax
Yt76MAUYQsNizs5Xoc/PXPM0gegBH2Y74NXkDY6lrWXKWV+M7URlXcnrcPmhD9Nb
sUxlXJgHQoDGSYpwdbD8uGo5I0PsJKG4GctlVlvlBEfmBnQaP4woDCyJl5JM1ifl
QmU9g/Dw5OtneT+PdeDQ8tSY4sQRsLoPLgL7k3s6JcFwBAL+1NouIuvDPE6+bmQg
qAHYJ/+spXoXag10lZ33jAiAD/yqrdWOY+AXzaoJLhfTCqksTVnWeMl4uBqywdP2
OjPmB4NSXOD+H6zKv1ZlK8lF6J0QrqZHvhMjRXfuM5JodcV+360iSuBrguHCH1ZU
9mZA1c2yNZKR91eIpym5xIuDaMZ//3qdvKhI6/nLvlXcRTo0fgFGE7b4cc274OaP
IGlvFSZf3t10u2Jaz40O7cJ0xnITVmlgVOqq0TR9SwBC/QFN9sRWUsTAaOTOPfOh
lrYOa37eFF+jORx6oHckNjZAuP12b8/1zNNOLjL6e9asNTRyzCnafOkjAAcajLLT
ztd34fnqLJun+SqN6op6nyfgElc2ogiyScHmH/EZyR08gWe8Yh/WSKA/SnjHT5tQ
MMDNZB5iZrZAV33SPw7lynaE7huRpJkBH4CyI7PMg3/JNE6FsmjlTqJOZZmBX0JA
4LJv2nMVGBmvz836FcZrEZJE/O3HNh5hEwa7qxkV1fvzpL2zrPk4Jmk4TFq//Xlu
u8gMC38u2Hb3FjtTQmPy9JTSZ56PuKIm6GzT0VyrDK0u769F1mLwJmdfPwvfKJDN
Nc2nxaTWT03Ujwb13Nhm43c//Wb2du8cAzW8oSrov9m2O/CwdDBh6TD4fe8+JByy
G55uwlJdDnw7D46TwinOavqcbuQJdVyxRxaq+APM/Kh1x44HEXDY20Ylubm0aOhk
8x4x265/26Pwb1Y0z03btGpt+n3zMSi3AtaymCdEr8qrSnOtAW5C+IfhAURqFisw
V2KI5u6Z4MUKwjz7UULxHX++DNXsihf4V1SZ+3nYgfSoNuVS2C0xzAq0IZi0pv3w
q5Jza3JuRGydFPxW9xU/hKpeYcRCg9d4uVC1YeY5JMEFnuMAKEyhSNl00JirslZL
EJKXJUehwLGI+2lsaxqXaavzAdYRM4aIAX8BLIwcy/1Ya6LiM0+5qggFD/k5vbmw
tDs3yzo989mHWD81/2wWmPb0AnRirEq+6D0NdPMFWZOZDFIvGFwIDX52RVb+d8w5
FKHgbFvVNl/nQUy6JbV2lJ+XudMaz7OhA+H5BqptKAIRypqAK6mlu9Ccy0K5CieX
6RBmX1aDdoU+eI+6MjFBFPc/W3zPBiyQbKMouN/zm7FsD74n1QF4+wLrXsHi3Q98
BeJ/sJurHL/6OfHxyePxufGWCOezRkrGqOZe0qlz989AJxi+oyg3Str8e1oEpfd6
3a+89mA0JxuWK5N/eIZYFMkQfZEYugDg3OWUOgLqtCDMm+lzcA7eX5dDTkDWss5x
F6xT+k7QwVomr4J/G9u4FY8M1vZHCYfNZS8Ga/q1RfgtRnwUEq5regX7bZUYRPLs
e4ORHYerLBpVRfJdu1es+81LSXQvjmAslROBfE9Oc1SKMR8MgjzVSnf924mto8VU
Qy1GGPY9z1xn3Ih5Gya/DF2X4zAUAE8c5/Rt5u9Qo4mpEo3eqyOgDnC4D74uXDRu
gpm/5JNjevqHRPzLNRkgMXam96ZAv7w+e64qhPup+xTaJomFQCddpKmW8f0oVlIF
L++9aumNxyWS2IcNwubDmpxAPUB5oJ0O8GVI5uLngBD6cYXZPXAyRkuasH9FY1wc
Br6X8Tbb51RrwMyyGY218LaRnzf5QHhyPGZWzbiphun64pCOgP266gBBHKl5moYm
fr5pnlwQgT+Kh5BmAcjOhLgsEAStCQus4jxmP8Qi96FeZeAPjc/3bUu1uvnmSP/H
jRvp1F6cLvUbqLABrbKH93fC8S8EJ2e8DkIo5fadurPkKxkmVa5rMAgbxACX4jPo
TK6PJ+Au9QthNp440SrpxNb0OkaCy+cifhTj+5kq37S+eYJ8OzVPHJnbNIyoy22/
RAt5fpYtVhhO1CXJaazJh47NeuWv0g99jrJM7ZmA8HrP/pomvxN7Fcx0/X66PFnp
TJLWJyB7f6Py6tqtgSm0ALhZ7uFydaJ640buIJ7KgyuYC2JGvxV5uKey5CGYsGah
/21aDSYWKD6opx7FndtTPVcxTWXyaubkhfvudxcbe47i3BHvvV5HccBqFH3Y68+b
sH/FmSGjxZZ2AsQNbnMaaXkmD9/uCjgpZwNaplAAnH5hXUphVnAeTHSW4sQ4i4HV
sX4jQrJI++TMnIJ7ezGokw+feztTBR8PS+48DsS5kSu3a9nWiruWVMUyrK1ohPcO
mVScPOil/E6F23FUk7bUt+Mdpzv+TXIEmsGR8Fk0eodM/dgl33MYQA4JLJqESA1+
IQoVlLciGEbxRDxajz4saPplqkk+VMwFhlgaYuhTsxYnDp9XBhBoKVyCqTzFre7T
oLv1V94rdCQmsChF85lC2rxMZ6GwsiAtIOL90Q/kAMtmXZg0lHHCWD676BVQHmym
HbuJYzjN5X6VWm+keKJKYKh3FWixtX7Ei2GZnS2Si5T7ylGpPPw+Ov24osKV4JZj
6hHU1jmwUYE74FmIOII6Es5GarIy5H2Gv2MQCJzqQao/w7H84BrTxiIC3g9h748N
vJbYm+tkLouDq0QouSuRBmouDUicz9uPlYRkWVclQ8tPrK4dqhSquQTi1p+dMaAH
9KDRR7r9D7mBEef6cxZSfWqAglgauCgS6/UjHTy7NgKvsCJyf7p0AGOHcx5+o471
v7fD1x88gsLNvq9QFXxtYvc/ysQ/aX8SEgWq25QXRm3MZYtFKU3jwABDI7dY47kf
j4PNinsKTc1UmQeL1ycLLJ4x9T5r73zn9MrNFQz0xgBQZhwtjp3z5QoZE/PjwAAo
bz17IvVzIH1hoxu4lHHboVkLS6YymOhcEM9ULsCP4KgTAxtesMqyW33M0iFbc4G+
4ZkM7T+MJIZ4p+qHqG0einSK7bpBEyswG7J4zyMQiEYhEHlrGqXLEVUUfwQIoVYg
O9/DMx/FB33YSajgshsq3agYFBEQ9MedBmN8xh0ubs8YEq+DKuLZ83elje6XVCY7
CGiQOPflwsrqw9+Vmv32Poz1/qqdqrYuHeV/Xvs3c5Iosod5f0/X5KA4HYm4B7m9
2X3HTGcoiucX4a90qR9Er5PvyThmOZs2sDh3Z/F6kuG0Oa0ShaLrI9FD62c7uDSq
MvS9j718XCFERkoYJunyCBVt4rrMqTNjouQ1jvjbB3L2CBz0BuqC6JYy+t7zM0oR
sDi3EbufzO95uo/JjgYrGG/EetVNkmc3jupThRPISL5A+B43l4NaqHWQ4hlPzCCV
AYQ/cfHAeIJbzWmLNZpR8mtJ2m1Vjm1XsNt2m5PgIMgIb51Abhy9XceRbHIbBj2q
hXLr+9Jyk02ZT84lZdzVGULpxe+PXDmIErWaynRT6j86zMTL+NmOSXbCGeqyNoEZ
KcEKw2juHLHyFFYHPyzyWKoUKx08BuPvhMXuYOWBikD75yvh5Cu07eRvLjmWXA4E
Ak2TCOKrG8WiZWaOskD8ftAVF7FtSO6qxLXPo+UORK2TcqV/JP/FlXJrG1IXqShx
wnNq010pwLCpQWpYCbHzki6Peni5gzMO4sj5kYGxwVFCrHHCdkfB19P4NcCdpVkg
B1e2Dkow4Y5qEiGgbs7+WUsAL6VIVuGzOLWLqv3UFxEjqhtiDoojqxWEWk+ayKMm
9Ym6J65MNVyUawQivVAcbzG8yhu8tZP7GuqEAM1Q/5nx9C9B9tpd2YoUeZ7UXCeY
wybSfPBh9vjdSJ7w9Z7eJYk1Z1cOTO2OTAJph6H6X1ErKm4bLynP3dbF/gPXB4hD
6Rd6X1kp61fzy/E0fSJ/vsjifVT9c1jAEY3GkK22tTwvtRkwCIZFK5mpoDFWUQ/6
ah+dtDZkkSNWkoY0UNlgpyZOZVANZvHgIUQsk9gU8nP220SsVS4p8Oqk5NNXXrjf
teVtpytOV9Lpf7EQrQIXTF4P+PRI4rSaIYtAl7DIhHt+wQEUcy3s1LA+HmQAjC52
T1bQDJ0A9LCvmewb3+t7O7+s4hsf4EIyc0EeGQwozzSuiWX0PNdTDc1C7eoj0FI4
M/RxM7cGKkSB/ZKgHONOjirES/JVDV1zVdcNhE1iJ4PdPZxnYBZrLZVi65ggH8Ix
VVJQZ1LL74n1VJz3WqC5xJgFkY4rVHbZAmCsswW0G/k3IR425NsHCKM5rAksH53D
w99Vw4xtd1v67Ai5lfAhRT0rgRISiBHwb7epgZvd3l108f3Ks2MeTF1QYw1CUJCH
1yptKRr/5BCKax+0fWiSONFLh2fi+/7QO/2Lpi2BmMlaKmwc8+2+Z1noVU+CfQ9N
rltnZtdqKtDenU4ROSvNMwvucFcw0XDrVcpgHzpHW5vR9UVnfn8hzZPgeub0OgWS
jWgxirEpwvkC2VmK070T0EGraq0o/3MwwZX2PdB8e5Km896TkFrhq172gsPSQ2Lr
ZLLKtv0+9o3Rd3ByqhlxId6tIN7wgikB8RIkIsVn5oemBpY68aC6W9XtEqojN1ZG
Wg8R6nH+h3czL/oLQmrEk/9FjddAbFSNckVpWVqubTlOrzJCp7GFgPVmv1EOk8Qf
dBojstKZbmUWry7lKWvoQLwiHO6ciWMzOrU5NT/5aHUI5dRTldO8Q48jZwEWif3f
auZN7/wXEz9Hoflxw46cf6V42B3fz/wty7qjuxpROsCJvkPxgRsE9KNQTjyxQyM5
q4dgKCWq7nyCSNShcFeHwL56oooCTt8A3mUQcyjQyEB/35mySNMwy369SK/++n7+
X8EmpDop/gWihBGgmwazuwicQB16mbUYLU4vWyrSexJlTjmWOBvXuq3cWoeOA/8Y
kmxDZ/GS5M+pvLb0ET8Rw0oszucJ+mcmVACjm3/wwx3sBRC6M9k3FjITegLJFP7T
00DCMl8ItHFE1/ehCmKz97/yf66RmHXEEBgqPVMWKvCDcDeGR7ecRoNgEswSmAkE
RMw0VgALU4yQ/0xgDRECpewfohVTgtHTA1IoqObe9UjCOlGOhFPPgH3iH2xjKn/i
8TqYSy+nJQAs0bHd/YFJfYrQLK2wzcd+KX5BxrnFcbTzYTqOfhrZCFCH+NoFeLek
DQIeoYRvXg80EsboZOUgtrMFmi9czmSHOC31F1FTFkaelK7G8FSotH3fWGlJM3JQ
vPQ6grMEnWhGuiwhlfKC748/Z30vPrtbQHvIQxlaeOGYL3ninD6OHKXqcS3rP3Gi
Q5wDwaPRL0z5Da2J0q9OfH6RZzOx7ub/NP6+c/STurSMF/ZrV5ggmzQOeUznaX7K
wZRCbi/ELagqbPO4MhQe8nReTPEZELqdzHI7nGABzPtyVxtAaoeKniWcFs61n5Kg
hQHO207QrHzkyazuksVWHsPF1JjyKJLr4GZw87crOXxdiToP99akRy0GH5khNI2t
ZuJSqVAKzzfhLWnr096nQ/LvDKpCapZ+GP17wKyaydwo0NI3MrB8IfwQVyGeELAu
TvnBRyTMeiAVo+MOdZ8SDuRNNuG8wB/ywegIiduEzNJC/0sK7LdinFoQGfz9YOnd
NMGRJ9mgfcVMf7K2Hy8tI7sCGk2VbXTD6NMwMeAQpvkU3iK/BXkfAzeEQ/jVin0x
y5TbVoQvxKE19iOo8f8M05yfGmSLNQccPDXaqYS9o2yqf2NCBaTV+tod9BWUJS0A
ZtLeV79fZbrJDy97FEMRpQBkTC2uXikVA5325cLB1szO81Di4/FORWrg1IFlGyH4
aAwLTlQhPm41i+bskx0MHxB4tBnj8zNGwwDZxdRXn9NL6hX8qBYw+wnuwT2AoDOz
bCxwVmxEFnVD0oV5QKpMkUNWCmWXS05euvG3tNXCsE4tAM0fOgPZH6fDKWCBxyG0
S7LW0ZhKQNTS8EVBAghLU99iKKRWY9fJnpbQyOtB95eNn5WjdW0oNWsPeWV+8K7C
wKtDOyDOH7gNMU5ZYlLlExug+VoMY8k0pp3AFCoLuAA3+bigticsNk68bvx67vE0
H4k+T7G9i4PFJWuDxy9FjNyMV4y0e9Fj2UhCJ7qaUMHHCzfdoR4o+GtAOzHqVWPP
uWwuBbdedCIhzUB8/jUrWFDBd2/i3By9OfNDZgHCLx7S3dIBUz0cW275Cbh4cB46
1hFUr51j+NE4CXPrz4DCY/x76pYaWxA+5qjdsmn3+vOhJWHDYdijSlYS99b2yj8z
4Zm4AyKmv4cGq0aaGVAKN4C/hM+ih3IIW35pn1Zgx0ioC5WAte7nLK4ymVCuxcrH
8yUup7w/BYuzm/pRuzEL+MNQiQBXd/CpS8idLbww7+q/nacZfpw+sh39IP/8T4eW
wOibV3NzUsLnbBZ7Lpfr31h8Nx0uxXA5Wp82T9JXKbZOSynNZxmKjApRuof68uAo
vmxBtdyh5rqVzT5FgQhcXGKHD+nH/bB2Pabl2LvBQrka5ah7aPEgKbwruUKAZ57d
BPzY6X0Gcq3uKcZnHo8yFLfEJgmiTY6KjF9VuYHfiQ/YoOo8Q6ADKhNS6zAo7HH7
kDx5NLoBRSE1clErs8My7XgQ+H3PHVPhbjSpTQIFXBCnDwu9GXEJ2qir7E+ednql
NrwcIWbWblv2TfJ1UbUQmMCQyaDKWfLYliSIN908nlRTbP+ZP3vii3LzvvV7prCF
e00aRSyLCm8LGuln93cBHEqfvGh3i8gF/HPPK2pHL7qs8oBZsdxv6hLKqKmZ7Bfw
jZdN7BDEdWtSKweffT4xkWxBc1knF+4d+MZFIQLEDLhQTxv9tvER6rbgVMxJONf3
7hrAu//R4VNXPJ7L81lnsb4BOMz3JPYUWRLBzD0btPR4mhOhh9Q6O65h6mMLGc05
VXsVBVhMfpfId0bVHIaay65h3CLzjvinz8yJ/6v2FND2vQdxrUy2sMvnVlnpNSaw
D0w5xDD9RZ4oYNy3OtrmekXr48fQ+b1ICzVHS4tXwMEeBp1gCpACd0geVVFjVWzq
NYdNod1AsyXH3bh5o2fwJB95NKc0+YgDD311xh3pGs8eMsULKYGm0vujNmy6a8H/
Yz78/lII3yTJqnrkztlLAe0tbC5riAvwOIMF+BA2YO2W/sBRGChbRRjaYqLIWSlR
qpD1KgkOGJ8VuKCf4k3cSLLI/ixYBda5y4Rf4REmHG6rmxYj4Pc4pR0J+zpTW9dc
sWODKKAmi3UADhWMJeWTKgPBXyYXhvVFp7Eohkiza06g5OfLLLoDrHL50fMm5Pq8
C/Y3u5PBrsrvqzWHDPFR+nyYK/LAHptlQzbI8W94qmI9MnR6Hf7c8qfDLonMqNX1
nVocilBmdtmJRVQ7xOd1kPLIoJeAX09bMqYh5WfqsZh47NGzQzXr60d5xOI+ixQs
ncPzW+jbnZxB9bEFDyxMR/lcFKi4nLFfo/1hBUeSc/s57kqj2dl9VYxwbbqsUwqy
XlGjeFLCgTNh6Cq26cAhpkEbhrS35NCFXm0i/NfHCqeYXm3ry79Yh033un/sVaVD
qEgolFpAaRt+cKa3WGaC6uJH5iTr5g/XzAnNVW7H8Z1sEMXnOreNfcIf3TIVfXwI
pOeQRoqKuV13GHk9r9RGAhzSRs9n1sg2WGFEPHjutCwmen41WSnEeR6/WPgNPWfm
mXuNpKi9HKVrcXbk3rmijVHqzfrkjlwdkMGljffd6Fz9U904lSNHVTQb5oUa1sce
/Iod3Fn/hPLz+g2ZVGFVa4K86NOGGm4mOzib0GXbFCctt0vsbbJvBy47SnFZZxa0
8mbqzA1GZ3ffhv83dMNp7FgK/QtfbqOuMDgocjk4QWPvb4zV9m+nBuRE0Mf79wl2
Pi55QGT4jA4wly/WE2b7KE7cqZmQRP5wQYXXpj1hn13GPMh2SyMv/hgBx7kGcG2K
ww1pYSpS6auTvYlYRsreEArOZgQFSeVgzSLXnaGNXehU/VM8dw9wf5Q3XCsZrsMa
I+q3l3f2PPdZGlLCvLWL7iRjjrwziqlez4XyEUwES3RB4q1tkwphl2hT1WAAlT3g
lDRbX3hG1HLaPU2O+Q2sCyqPchPCthli6NOICXec0AhhJSxKBEcJ5eIl7E3fqPSz
LhBI2bRGoaEDgSZ5MuHyuK0g7NC5kjbS9HrGKoC1CGWx4YLphTTC9Mkk3U1lyDqs
0djvc76n7NWN8AGy4sLJAyMHLRvGrPVY3ma7p7uT3IctkzN2ercW3/+By4u+SE/2
xyIe4XAqrN5Q/vZwueYxraeIXsaV7/rg4X9vs1y+x5mKGx2Su76C1ttE8czlJPcU
Y4hu5RjOjFj77+DpbjloTIiNFUjQ36B0BnWENNCu6YpKAM4YK9d+SZXmYHK3KQi0
u8BEprPO6BMmkA7hmDOo1HJHQh0yvX+mDSNKd1Mbnqn/ENRGUMvNxWijH2Dtg580
qJN62u//0/oGKT5w21J2q3uA8jSog3ZYL6AdMHvvUXGcBP/5ZTVHLxtVf0qYwoIi
6NIUxbaGNC1R8ExMduvsQnc5PyqbygnjWTp11uGKuE3H6QSeAIJUZgP85ANF4LfG
Ejog/y62sF3BDh7XG6Pt/xla3jEI1j4W0DUbQ05ZKJ7jixJ0ttmJ76ViYcmBZH4z
tQgo8mrGByE6Wu0ugRznyoDm7UGjXqBRtLOTdMg3+5dAsttKONh3R3p7xjdom0fm
w87SL5HwduuU3G8y4hxxpOpet4dWbZzJFZjKx/AzXzglypT8hJdTMvqLnNdhbn+Q
O65tTAC0Q3BBkdcBh7EnS6ZO7mA9xj++XPJxI+9mZ+TG2y6CBpxYCmv7yAVbBnxd
dl5886I1W84zHvijJvGKW9aaIiM9BqT/gBkdNJfbknJ2P+UK8JehbrUdrqoxhZQQ
Zz/Qyobzy3Ok1wGRE1PxdNfVm7hgovZtk35ewwB3P8uFEgNm63ExIruhNtdWO4kQ
ziSzg9Xq0UuYefC7sLFQpGkivEV0HeuCTiOqkRkDOh3+5+wNkfBElfxutbyYakDd
Aj3UgfnHLWmkilZreNvlPb7eC3x1thEr9U+ov0rGUPyuykscw/zinFNuvTbw7gyi
GyC+lV1ZQc6k+rcZiugLe9zZHDqg5pvWlNms8ebaKeDvi6LRWenkXSeyyG4TTwuF
CPiHmAicdWxzfplhU5hlwfpSpUuv0gmbxXIq1zwVO7gYPF/dnrqubsdd0ZcezAzB
PqwuFMJOCIh82rZCffCK1TDdTtYBNBmy+iwmo9LNTRk9GWOvyVlZDVzSVzev6J9s
dI6uxVV+wxvr5BfzREQ10eTcNXmv43CoUjvJd29J2WWTBTI5LEjPCdv1muZaI7WP
sEm1rvNbBIJhmTWrBlXxh08I/ghT53BoB3yH2proUDdgXCyhzVjvJBYa+djHjZC2
xp9XbtPFNqYf68PdWCCSohY5Etnl1jUqOA5UuDrd62XpJtZkuzU1/eMuPIiNTqen
uH8bCcpmryGD185MNy4otLFfosx0o6VUrPP256eD4orrq1DC9f74rGNCPIp8YdCY
wMtHVSbNe2jc2W+R2JwNa9yX2Bixd4x88dNGXnVmb73zFwlsT/Occ19i8h91A9UM
kc2z6wAOyK8U+LGfkUBVgO1R1AyOcqDmhoP1gFsayvNl2HDrQCJnVNyHnCgHK4Ne
cfhxzcChXSFsCxAuIhPxru1SgGxHsHqr7ZCrjLSt/jwJlvkD/KoBScHA8bj+MUMn
vM5dNBtnxCWnhcrA3ch9x3VeUpMMFFJCQfAkS+WbSP1YOu4kDyTW+heeg/37KQB8
X9wFlmko5MiaHZ90UdNW9v+pAuw9AkLljHJnkO9HgZHqx/78I+KQQkv+q5wnlbAh
hrI5pR8xnun8QWxc1ift04U83sNa6vZ5G4YqqBYIKvHW7gvHkMXcktYj+tVItlhi
qLyJvviipqiVPED4YjoowrsFsZw88TYzSKcZx9agR33lr/yRu09mhgWDkPIq0t9M
q+FhC09YcJppeCcLLIvblN+TCnRPO5m0gQGbPLBQ5aL5SKsfP4zFPU0c+n4b932Y
Wcz5Q/bf1kP2FwmNp2AEAVafgoU5TqCGQU5cZWa31RIZr2HXPZwOZwgX+fAhkAF6
FULU0wM6naIjnXPJmJBhj73JS0GCbWH1lnjbMvkKQTyQD6w8LCq9fI9AsiI26w7C
xItxXQJaMS/Tqxz2obIw7ZzRd+62zR1c4ApRmA/TyJKq1zlDojd2WrIA2H3ysMiO
n5JymxVw9zoPavL5ZKKBcPy725GWFeNxxwJYx1/AXru9XfurKiecpEfExw6s1Fv/
LvNsvjjPT9paopW8cogZTDdjBZfbuy3nyHvKbdNujahWLfFE2MoyXjNcHUcWyIVx
1i03lLwTLA7Tk14dP/g1YLYqlh736MNu2vfBmd2Dy738EJqMV1Fr7V4C+B+iPVPa
zPpUjZng65mHflEXOVabPjHYNnBjuFffiQWFZIdWbD8DAGLz3fh/Z/0JQVjg9Q7I
QQFMZr5Z9sax/7/XCl0Qg3eAloHtCidH7Skg6VrMSKPpXihlohFwVtL5UmE9DrvK
E8DDao4m/udm3YwNB+tknpcTbyFFZmjNKEOPC0cczEV5URT2jyM4hYazETfO1uEa
5g0/g6OeRRDFQeR6x69UqGP/lCsqeShu2XuOabxg5V2N3o1BF1EKZXTHS1gXvSYv
h7XLWsKIuw0aDgJ/tceWVHNWH9BXys9DfxaC8NaZT5qmXL8hvtLascIV03c2DzJ5
3Nin01FIcuDHtSzFTMjjUtFA+x/i4t2MXGGcQp9sytXcgFPMfdCvmtHmF1I4hzcM
mjBDoUz8oHXSVsftK4egA4NuJel+rjeuKi78PBSf5BJ+9JWkS58CPHw4mbzB9d4w
W1gteK8JwnM5chT8FSubJQg16CUPqMqsGKn9qO5AN7gP220177ZHp3dyAC/YN9wk
7Ps/P5Y3JR0KPLA9rJjJKQ9t7UlSAmp89qPp1OlCJk6Ghp8ZXOMp3oevQTkwIStD
1gSctgXqvGQYrrmqA8gPMnbvT+UhbGNT79cziDQzO1q9SWhEOnXzKfIgr0QWOCDb
8i7KWjEwieIAux0KbCwlKORYQQRZJZzy/xlIb3rXgJxAKUeFU4e3kV65dx+HnK+t
dTzPEfCzqLGrzrb6xTDIpDoyCoSNG6r4Yc+9iirXmiiZaPdwtQDd+OtYywNlAzsP
/5MpR0pfehI2fviIgzn6AQVnXVBgMZh6PH6i53TxoxLAAGHKII4VblcAFoCxT2OH
JMxKz6y7HvCK/bF9V8mvJhpGHePtapvv0iom+8JRzEM2SKGZUTKn5Evr/biWdBk3
YOuc1LMJyVqGgGOAuni+hZZ+38M+lwb64u9Wl3jSyfYlPumXboTXCQZoaAggc/de
jle6nQn4EVHgzsAcmXl0QLOWM2uu1dxrA2VMFM/EhexyFuVj1yQtUySIUPIPSf5Z
Jqqh+32VWU3DAvhRhiXe0S/DuBmOozgrRdPfpP8NAGrz1Nqu4+cnbSmmDHV1aqE6
XNcg4aH5p07kygeZbPkCBtW/cggrzoxn3sM8eKhkr//tApnys54DFpSS88yNMphv
ahjlLKLKFMLiN+8Vdyq9Xyac5uyF0eT4rrEdL0UFBViCKbpPC7KEqIPeJAVmpsL7
WkAqguwNgg1+dgct1GvI2qUnMBbXzz/Klm7Qfwqph6jDkEHfw7BfqRVjYCzJk5Ps
1P1TPMqztHiDxzYB8ieRBAyk5EfWT829uoF8BzLzsOuQqxhczskYrYukAYOGB3gp
4i6Es4EUQ/YKWFW3tbNEVJfAYlY+DKaRB3xg/sG8qefy5YlCL8MkWMJVu2P1htb3
u9asfbcCWDxc3Ot+3tZKVZiyZxL0ZnVF91uJuPZuCVaiXYQ8aerQumxxCSwBhhmd
9OASgqDVDUZRvlJo92jYHVgYA28DlVdO0ErKiVLwCaOuTumaudybNr4G52v7wOWQ
dJCmbm0VSAIL2Ocnm7sFUeupWXhz+dnWfIELc3APL48NborLYvHYEGqqoqBQxNEV
uSTdtuJdifr9pAhigC1Po13OZO/q0bKxEab5OCxg9Zw9wVJ4w6FmwCWDa5iseqOo
/b5itB+A4awxBvEr9cKYO3huAj7xm2LxapVWQxi3XJuPuPo1DmdLnRUZMTLT/zOU
rs3Zs9HjjGwb6TAa8Lp+7iSFIMT69xch2cZ3e2vPYlNIVG2nM2mgDeUxs7z/bbe1
oEN0rOzKwGN0SsgTc2ZaTSKvsXauogRT+/AIt4nz/IIm2ARksFfBck1v2zT4nZOJ
P9YOV7Wdk6CDL8ve/C/8+w==
`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
hYJEKYbhswQ9uOSIaKvSQxfgzXP8hsRHUuZ9XP8UM0EvkUPztcnC6421dyu8+jfA
uQYj/rpGroCPa1bFjXw+AdJOK/0iPVKp8MprXt1u7A5Onc4+cDbVCDDtUA2+PQLQ
M1gx3JzMDV9z91Laa5GKXEGha1eU6XfyZ2diQ8qXLywcoNUkOR+xZn+cpbTCOoih
XC23Gxbod2XPhD6Vd6XgrQaqYmHHSu1rUtsEfz3szoeD6JHN4hfUVlfnJlZEPaN/
tVaXfjHX7HRThe+J/cHvtgw70/DrODGIHB+KtYsYsRM/LHPOh6XaDXsgTP1vujAe
fOZctBkgsZNCpWK1wpiQ1Q==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 9856 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
caJlPPSgqt/gEPsi30oqlpH61zXUd/VH8CvK1cMPDYFZWGFAxRPPqv/iQu5ZBDrB
Ff4Be2aRnepoRSZfrx8qGxVgPKPxJuhCc1FuLaBI6+YpOcNUpf0QgyXH8WAecadH
v8xfryNus01Tg9HAOEC4oEWyYUAvxavIqGZz+Ms4z+LM3TnL9dSRl/SDqCmDiC4e
LqiurA/MqefEzqi5+/wsobQL8bQ0V4EKSklEhWFnPU0AYzxrJ3vThv4mn6pqR2go
I74bjJ74qEJmTul721krN7A5Iw7rSwWfmp7vFOAfKwhtpVRqPYXu5NWRvuKglyAS
pKmbJoLj8yn7vN/q5wIqEw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 25392 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
I3UvHspB07PCfOIdnjafydSNRjopIQ+jGhUO6mgxNyIHsQQYdAsiKB1V/ZWHQzKx
YqayM3/4tRRj8vaCCPAUo/Io4RtfpopMWNegVKI/Ya671wxMMlLitIsP+MqTkCNE
89BKfbc2Rz4xmWPNF/KlEKX1G+FRwfLTp8Tm/c1DJBguOxo1YLvfmL6fnxBjGewA
pdsn/tM35qfGimaX9XUpsI3cBhYuRFwjDpWBrmt0Bf3gUe186Wsy6RxLPIuwJfip
yoNyDYKdSsD8R47SstK9pzQt936U35QE3NSmpsllfJWS4QDjm6moxiI304AYh+SQ
MWR7XKCEmu7Fhaw5I8O8kg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 34736 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
UdkznmK+X9sZUPBkhUqKMFqJe8q1R3ooEjIIypmG9ZHinaI5EFEmivqKuEg+28gY
s7D8VLnzSo1ckC7wIGOFEpgMOhyfivOE6HEYMbc1rNp8AXw7sLBVCFbWKNEzocN9
akKTT0lE/8a0P9yT678ukTcAohO3iolekbDcKX26Vd7e3OY1Ld61hen8wTF4+X3W
J2cQ8nSOM1FLjRAGhcwHWS6pJgk4h2alNhZC9zOZA/+OQW4b1S3TjIpT9XdoiRX2
/oy0nKV44uc05B0d6veuCyxW1pUxd7cRnRJBnnYJPBShl4Ukud3ZzZRW402YCrYB
qcYazFgnxZ2S8+kZO9nxkQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 42080 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ns
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
coRQkx3EqGC/neLSqPctaNpnCyhd5TLuFV4a52QzyqlXnDz3YsCoDF01pF7SRUNO
0WdpOuRO/bPNdK5akYCMq4PJsKMQozRoSwehbSqwJwZucNTRXBA+2Pfde5R7ymV2
Rh6uZO4dC6hZ02HKiw0wmE8pFuxpGEHW8uixghOxzZ6FpyaZPm4cZoUUSwUfveOE
WD48GHJPbiNkiqkyOj0nYkHS4pNOEwSt9scEsaQ6aJ+f5GmMd8NoGNaPl4n9/6SH
eu3Ar6alqwVGPMFzK6QyLfbohZbkGUQs8PmWBndClEYJzRV5i9q+DMxTFvaLIurJ
c//KmXtKV6eWERIGP/yRKw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 13488 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
esVfFHmOUWkeqRKZGcLJpkmk5n39O63j4/LRGDwvPxQ9s5wg1G508fJk4yms86OX
x5m3ywh6ymkitmHgUTqZe6B5p/m8Oke8k19TUtlvi4nPKm/giynrove9KfOqJ5TL
g4hbvKFJIg8JSy97OehWrpMTuXgM3TSDQZTBtLMYrsrYaNsZEwgSRa0pokeoIkKZ
dL3QLLzslTN6B0TI2GYN6EmZ2qXYDvs6iRTCDbjbT64V4o46hmIKCF9vTDSmFHMz
AATDXL8iYC/IhMgEUPS3IDvO9YlU9WQiR2v008P1ClCmZAwgdIohGcXF7JRWagaG
0POFrrUKDzI0IyHAuOfXMw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 4928 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
XyvLUZ10zTa3XXjrr7IwF1i51BcJxuG5n6qao/aoFFzcksgOneafZONogHfRBzTQ
mmvRjtrLnLr0pM+4Kw12Uq6BBLzsZ+fiCVQ7MWImd+DSXqNqpocXlcAIKAWRZn/J
UTmHLYQdssJUI5klEoBnZqcEXnd6DkbdzeBLBqiG9N2WAOuUk7kbUC0whtfurQdZ
R+rk7Pp+q49Ck0pKFq7Hk/T5IOA4PYC4AV25tZsbXMpS4631uCNsVnlUSLe3adgf
QuldmNr217ux5B2qsS6tq0S3HFnOifhT/7VLgezKR0vLfQYVEECzXy8l+80ayw/V
/AbXtlJ8syRY0v69QEva+A==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 7104 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
b4kWR1l0xf+gQDMxVagdksbqt2dmHSwL7SXHhRHGT+SIvZq4uRox0t40W0sG79qe
lCrxOkxmbb+t9SaH+KyWZR0dVXX8cK6X3XdqQ9AfW3KVYHSwasm9cFRzBY8GGc1D
GWZ881HOa0ZtkSDBXof52V3Kf0FOfjxZXqN3pgfY8jn8FepVhqqz6+xj2XwwFotT
8LScUOVfA2W1p51UJ0Q3lTuIdZ5VhJYLYNTNIdelIuos+fe/EDXJMnfnz1Qvsa/O
qW0yU8VUX5Ixx1jM4orEGR/eijeDgaPo3sOptKpFRN0uavVouUYwAoVlsYd0Q56V
sLmfNNGQkruLEd7Npe+PRg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 12320 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
S3uwy0h7wKhSMiq1G/xZ62IMqqCP6eVI+qRaUAFe1v+PR7DMG0v+AyscvCtUvwDo
z4URNpYqWRUNQZIs3DjThfEe0ptAeTkPAS4Vx5VR2e6GVdPOYlzFCwlSk1Ctr2LJ
Ic+quxh87ADApICbRZFsvMLELQyHE6En/PVZVdRywDlMVnlFwkOw/PJVZZLb1ql/
VQHAyOP+pQKQnMwkhg1fx3OrQvoX0ifMWR5O7RucHEnVLkwpz3KJpE8E3REdKTq9
EKjhcJ508gLp+xOXAXr004QSZX+PW4YXwg52mUhMJ6Ftwxeq4GEW05r2oiQFLuyK
O+JDBnTS0VGGghfROUASnA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 29936 )
`pragma protect data_block
fO5vu/j24dYF5eDTvgmnntLgpxmgveA+DWpazcP3YG0S6s+Fg3OXqtxQSeT2J9Cr
dLE4+HYRCv6eiXPKXviUk9bYqpyB0XIuaRI5SUs6Vukr9SZUokTuRM/jlvfcyAxd
o4hy2OkiElnC7o1/bfxxlmpezUCBbt3jJul3Wzslc20kGkiQVoEuss5Tllnx6WR+
TBEUDl6g6/u8lBP2YF0lhMkFRtTU8mT3oRTqB0sBAolGo0wqTaip5kPNjxWm6u3w
GQGTXoHBZVz+nsAkq03MrRGlecU8wbQThikM7bTmbG/kDokmNGy5sA9h5phNFqVU
x5FdTvPYfjvrELWWATmblwyZQ34kn6I7wl6OdFZzQWUtl+PySwQStAisO+PmN9IO
8BpfiauuYKq+7I6dGqYCop5+C0QVSvsZL8Rn1xic/E3GS+l/q7/Kp16dVq1n7zsK
WVdOf1tbIi3b5McvglaQt48A3vaIiFM7AzljMllsGgLwnryk/HKb1/kUNdVv33xX
87km3Gk/73KU7FInAa+u3JjMg9O1USm/PITNqtqAPbXI5kHKZzAqTstF4/K2Heri
8ns7HGjcg1UkudXffnNdh3uCKZhsd4YTiR/wQQxFmmqYNh7d9NRQw4Eli4tdorhc
5Zt5/uMHYbaStDqUBxYyVVpIBwgxkf5ljnmkCC4qSX9NyKg73h+MjwKFbkrn59fn
rBkG9s+9NebJjo4xLaLUMXwsrQB9HbzkfCiuQKR6k6R2m3LexxPfE56PusUSphIM
boLpiekbFXwlATC8jxFyRVX8r01f26IWGKsogyNLqHUd1O7NuUm3Sh+jWVn1dWIy
pLNigHAFudzf+uCgs8hplYIhuyQMBm7/hOat6l9jJHY6HLo4475iHpOYGNUg08IJ
cD7OIzb48hfXd9+NGSbje4wac3orzAP/5H3jFn+2J3tSQPzcXNDnCPH1Np9p/2yi
EWlzWEyQ7ah3pImfSUXAnqO2ViLipo7C/7UqMtjkFm5Pmsm6ueKUnB9yw9I18zeH
vP5+w7VFhGvq7FyJ3D5rhqpevCfbgK6QbPBlQBBYb3+2r9EC6/DhExSK+EkTzSrR
B5aOayUQrP/+BWxf7PQYiw9Ll6XMo9dDzCwTpnMSMVDBbl+y7STmNpD7VBz2I22g
FOvYB8SgkGRlllnIB4lFZC6/xkw+aDlU8R0gn0XtFFdqxinj6xWfusfzK/Yj3pjJ
ToQzH+QgMT+UohjJ133tdPCzcR39CdnNLMatW8XnRk3jIN1/bT53bfdyK7bMwx6n
KoeixJCnlJy7OQmDkz5pktDcvpSPtMi4cO40a9Ar+/GECQVYgG7b0lIJ4Ze861CD
CXyUzXSdgA17HwFk/jetv4nXbua8XcV2IM/4S+Da62K+6tuRK89+SHvNicP2/RNR
vlesKfF5obCh6sJYmfLaPeywJVtfhAD8BQoscPs/Lz7KGsb3+eoK4fez6yGG5Ibf
3xOaUN0ea97yz02wrwSwEN/5JlmSBGJG3s7KzHIreP6XmIzMsJMFR5/CljhKLUAj
FVPcXait8Mh3y0c7GLRJuC6bF1V7BW8WP9NIYRWK0EFZpLMc3A7i6qql03DdGLsG
g8ScPRq5mqY0EcDVjozJQRU4fKSWPeQ+rb0L7rD1mcpTC8h5T3GFiAcVvz0JkF7H
ZmYEDpTYkwnyjk7i83nz1sk7LcsZQUAIHL80ooMdidrZd+oArKICiVsRMD9tGG7C
ifliJ8VUAZ2hUWj1LJbc0BC9VnYdQ9+U6CMs3QzqhESR+PuWZ/MzxiuYaTklPiSL
9UtQQeYJZ6D7l3CuaPrCz4opVKFkPKk5zpdJ4QuigVyLMdQu9h+nvewzaMsGOi6d
mF0Dug9DLMdIb93syL82nTKxeacSJ/Aj5l3JfDHO8j70qcMLwh9VsjVqjeJNifyx
z8zx8j2RIcN1RuBtmdIFZbC89srKdAyneSzNx9zijhPrra9OnHHkYyRm5W9NRbQt
hnGpF3qZaoCv+xOV/Htr9HNbG4tV9NijdX9GpqP08a6/Vij8tIn2kBJ82ekLmgtk
N8y9kKJ/oCiAyRFvdm9X0D3TMU1vFSeTTP3DZa+iQOMCK90NsEluvBEJU+M9npz3
RrQk1pHdTJeQzUsRJmacl2sTGyIEn347j2aKrvWFBd4aUUKEsNQNh9GeCEH+qwOH
sxfunrRH+YsAE8yq0j4ivYdeyQgz2T+91xYfkEmvIOntTgRbfKO3KfyQI4zR+mJO
8oFAe4t/5iSdc7NKUqBXD9HjcMz/vt1rOzR9Jqrs0X+IIfqZMDhkgBO769AeW74N
Fb+X6Saor6wWp9ov2HdmSwm8SuQ/jFxtcBfOJHxemvCtpUdOc+jgkksmLX8+6lYw
/FPXR3NsEBM6+l5LzoGYlOkNWJDmeYhpFvg1kmcQ7R7Za2LG2o0V6UZbeWMZrXWR
/9qJe5VPDi/0qd6h9nzV7iQDzpx5UmDimWAvRcApo7ejGBQGYdmpfQB4i8cMsRBe
qIE87hdNUj2SmmwB2ADl5/hRAOph0mp+ALf8mBkGLjb8I9oZ4RziGovnHtUyS8cd
7rU+UMZeUZscuE5HrlEAdFh04o+UqBeXqcetXDxeCV+mDg/07sRckulVwZGq7QNI
LSdc5APmYnIpRfB/skVfrLL1JJB4E+paW5ifXdzbHroQZVDuP4Ts0ToxXhn1oaIK
mVxfmQ9Qlxz0u55pXpR41i1nzy/dy8YlstHrmh1LkKM5Z29MooXcvjopWCnjn5Er
JZ8TbYosED2RfgNIPZKV09YxxgzcRqUCLTQj9JqzUzLcM3rfr4hbzK8kOQpDVWZM
3zaohPmfe6zip6Tiqlb7l+7neOmL0IIrrtMk3FrK9ElwKNMnjJ+UNjLAK/YRjC1l
PbrQ07nbyio18h7gmTXAhp7rcLhib8Z3d/Opr8ydjlK9bkWsx4ixWi9E6fGV7LxG
QfaM2Y6aeh1TIVutHYi/QFuurjPNjOLA2P59eIo7/IyYFFbnWms/I4KLz7MuMK/0
ExYWC2pX9cZgg3j+R0XoJvJZAHa3buFQINsTKL1NYzbQ790897x8uurs3KLpZ9pB
GcwvkUJLAozO6nIJ+dYpU+q4f2fKqxJuHV3OLwIRNOrqtwh+u7f9LMKeTzyc3MB9
aa0okNps/0SFlMvPW0JuxaZSMOY/PA4JcNbaRvGF8tm16qYtZ6koqdwFBnIHYwqH
FklWDYnX/fNyZrg+XqfY6oeIEypVAmAUxw0M6A56M6M6WwxSLinlBKN2w9Sgf3Tz
hVV14hvRLJI3v/LIEaGbxxcY6W04/Rw/8rDI4QU0inm9h9gSJeEuaWvp0Szi029q
X5tGXCQSa8bV2O4hO6tu3HePcaPT/BlCzKZn4VLfyrc5/Zbqn4bsNfGsj/j0Jj8D
pEaDxzGNPjBhH7MJjeA5swmtEcCqh0R6+2hg3SArfBAX9uDcRWG70Pv+OWvPv3uz
iba40sD8mylgBVQ2y59rn39Lgy6Jo7Sn7royWsyrMkjQhQQDayxtKFU7Dl2p7Lxv
mylrrt/p7Tv0TJ3y+0n1A2oQte+YrqX4bA90QMdlapwVQxAwVctCsluUsmGqwHJc
KLeRjSowdwIckfXrOdPvSqlURmkVP9RLCY9Jr7kFyyrKFildij/IkzAitHf1GMI4
+osq3uonvHZPeWT0E1TklCpmquWuv3dwvU5HwWTPMEZl+xrl+8E6p5vFymTOGam1
IZlN1m0ET/5goRZB7/UpndFzq/KIExbCclP0sw420h6n5dUQJ6FOXlro7z2WUwAf
EfViObqMp/NW5YgTARi3WX6oSANKPRI+ifxSAbhP7wdIjbpa1xV0y1XURtZO2peL
fZERG+5JyxBqv1B8cD/6YRN1vIvswdSdtzluEl8qb2HskoqlbpWximTeTHJb1D7X
qpLJ5xzWkLbvw78Tp5UAT+oo3lPRLiXhLtLcuzowwtiEigkM1gpaW6tacvXGign5
cOZH6FWM72MDA8fLGQuJq/LeqeKE9/ItfAN8u3oY4BqwbhBkofEwRphr14c4r32I
+WqXsjf5pvOmYP9PVwLtop7aBSa40kIGisGZBtmlzVwOBiC/7ffE3PiKG1ZSzuTT
AUzgy9qBZ7naSsgWalZiJxMqHLC9TGsytcMvUewzcHCdf7Pyg9Q7AYQ5LF2XPIY2
VlJ3opdXDXwsMWz3nSlLjJUlxugJFBbtKcO/P4/WU2wiaOk7aiS91iDZ8BHM7x80
mHV3ucHhqQBLImgNUzlq4mwxHbz7ZZ1qPeARepWhUVugz7+/Gl9l/WLEwn0fRz4m
CbvyKNM6wxuc3CV+xvKJVMq+zHnAtxgzkgrc3hmVbiNTA29sR4Uj8KC0fVCKjb2w
zOxG5MES4tprRjW83ayPXti5Enp8Oj5bIQvbLDw4vJ8mT7FQRfixPj72/AvuDMKs
RI9le85f/lfTeJZQHPJWAE1FR0Erwtj9aQrIstwcG/AiQa8tKNzAmYkH9yVQieAb
axUs55soHX8PqknnQXrbVl1xAzsACTX2DRunlFe5WQQVOXR9ig+ybT/SdJ1xfPx4
LBaOOgcMGQqJmit0VoeLlP+z2U6OJ9Sez1PhJ9W1UIz5jAzBi88y91WRqnTEhRYf
Dw61K29svGHbLbtQgTS5rwhVLt+i/gvrJ5X8qdkvug55GUqpmZmYXlyg4lcHq3yY
t4k/AQSiqQQSoxEcAsqQCHmTGX8PAi3IFdd1yTQaaY6JSSXUv3dj/uPDlmP+3vcz
eHgrIeGly3Tl7OeSvTGAe1QOwUVcB10jkANi9GuD0NGLSq79YI+XaPJK6cTegBTj
Ya9ipbzi9unO6oWSdec6w4b8tE/RnKuzc3ONtFseUORzaL0uGQThgy16JHJQZDAe
eat1Yjul04Is+MEckYhfBvL152r1vjrmBOTUj7ZJY0jdam8F+TC/7AeJ8DpM7u8q
AITd1qHjyX10I/a21UKnCAIiLiZxhP8AgivpCcBQwmCHs9KCaX4rCrx3E0dGhBaO
NgwfpzVcLnm1wjKTFXQuDliZEDDGH3cW0sJDBCcM8VeTeTJCMOgwEUMYsUp1kf0s
18Naur7DrAx7FSmyWg2p/7gnk7+e/jyIekzj0fqYoWR/COUI/OoRc1nXLbbqVmPK
zHmjmmZ7esuqiXtBcRRalej8yIikzMGHFCz9XlAYf1Kmkmm45DjFPr+A/x3xm3V+
1QCTQ35DAexbxKzwNbKxEIQqSjc2Vy1z1Iu/wzA7ZAHJo6mqOydCrNmDck+KrDCa
xmufY4DavAQF4E9HHZLllTnjTeDT5AUEsUcxlpMHCDXRUiTJ8W3CY3PM1LTis5lJ
PIAaDP/Ifja2ZcFkUL9G9HDV6OXQFZ/DeLU3psTSKP1MYQp3Io/SlGvGg+7DfiKX
ESGFE/H0MfcCAHvAIYhiJ+lQFtj3pq4x6WIi5eXBqOm0pQqrIkE6sqleIrF2490x
huh0SxElpz4K4jXl/6Wu5AOttJuMs9Y70dvJxDMhXw9z2QbhVQe3WakmXEbjxiSg
r3VFIelajnqhpOnoiFob+7B7JRBblmFbdUHKxQ9nMS90VCL02BJetse741gkO+3n
hnwrrxsIx7zNVUa6iPPQXn4b4ulvqPwsc/L6Y1LI77RPDeNmMJlZlLya2VV+ec1i
oO2K5ZhLYCBqu4z485pwDH7B9lGtt+omM2IuKB7pgHfj/tAuZRwXHzBHgmuL8M3C
ezptms/ZpTEF6KveqqVzjBmOaW4OT4tqFFjX+3Skuybmj9KOnChkqbcfOhr2uxDf
1yaQFpD7PlQ3lCJbMIl97PmsJsnGS5Onel5HM3MSoh+DTBzn3DI/87CMS+Jx7SSz
847w48HFtclb2UNsrMBTgwjDMOH/9/3U7sa3+0Cm327KVfBl/SScDJ0WPnEwcRhr
mU/Jgs9bq9jpL/6jBqnHp91guinyCGPbscWbW8mrj1EKcArYKiOJ+AkOCsTs7yJL
OIazNUY7/ojbO3g3pcTqsE8T+ERk1+RoNSpU4OOOcdeJYVYkeM/2D3TAs49lcjSG
hq8r/pI2H9nZwGWiloJW3Z+jOpNS2H60Y/q5053ZX4bl1169/AetyBEVejRvLlD0
GHK+TFxZ5l0fBPxHZ5CMNp4D8N1GgJplAjgR9yMzqQkAtaZCIrrBJCd93yB70mBZ
vkVjKaExoTucJbTNfWGfcNpoMJ1hZWTn2p7Qy68RMS4A0+vzZ+rxEbYGCXvmijyY
SYAyoINuXTs8X5JJli6xL/xM6i+zKOkAxtbEFbR25wZrLRVZP4SP6p1+/Xj+wlO7
8n316oWbAMbbW9F6cA5lBbp30l7peiuWzTy2MydhEL1tKzAL3rKy6nhc7aLvW5yL
hvJXsYrSJjari3HaiTGJ9aiqcVTNlZmRsD9eUXQmAswQ4aMA0ghfLEPxQMPkqnrb
dKX8LkqgfGOVSYHO/mpsE43swEnt4wRNjvbIkuH1GItRAGdx4DEGk90YYknJwpA+
P2q9EPVB9QRBRcdpv/lGiT4AtHU5k8cA1+uttEA3cFWIEFgL2kCGfoO+9SeiHib7
BdAqfln0LzoipPQKlISIGEOseZ2W0m17x8d5FoHBhA28xL4mG1GJSN/08zhowr6K
JuFXgdPEgv0DZ9Uwck+utaCHNG0B9bLFpV+FS7MKXwIT2AjLrTwCwvwrv6tmohrZ
YOx4NRBHl4g7tJF7pLoInFyU3czd0Yn+v8Jqy8IVj3lsQYEfTbeV8XllVS6p6tKh
QQZrys+onyEe7S7byQ2grwv99njhS/kukzBRQIeMQMTLZ2WiJwg1oyolgmA0J0F7
X/7EeHpzQEIbqvRJEM4391H+VbMt4JQYwUeYQHjUqDxl+468HizG1TOQuAmeOO8+
YqwzA7/s+PGRIEOUddeXvwqUXBeQEAfQ5WGpfPMFlGBGNiT0jGrBbukY+/fsH2mp
l37zXPyv5uFmA3R2Wr6o4F2YtUpb/ZZw9V+TkwFCn/dt79t2OB3DmBX7OTJwdu6C
0q/icm5PvVU8pvtgyayh04Alt+wEgkr8kLyPFT8fXPgSSQTDT+UvvCt73WSaUm/k
RCURGux2BHA2HvuLArLljju2eE63bzjrhF1o5erZW/6d86aZdYawIIZLKoEegP0d
czuRntIbRggC5RpM/bJ/nfZfKBs5JsU/53cBBg4FfUm+3GCwVovBSv7yBKnY1qBd
7vJGmQB3N+tdLdLjlamW9x8P86fodrktOsrA+O3lFlbBhIkoAbmTGY6gLf1I5Yuy
NdtApFW5jX/8DQ14PpH/mdHbH5BL6KD6EbLna4ADuCTucXJj2ixpa+hz5Jdd93cN
koskvoIr/aK6bvTg6etdhzRhstR+UsHZ4Son31V41o2cdEhEcOQBx/tpicrk1pO1
q5KaTCRGRzgTEyWbFIPUW5SHYLxrGzcqxVsSotNnuZk+0l8bCDFHmrxmpQaZUE8t
dXRrmGJa/SBzQ0eE8NjHJTt58x24RX9eQJXX/jRzBRLa5cSlJZM8q2Q8rpOdj14C
u58Z6WcSFPoBVIx45KOtQLCIvpkyXQ3oK7PmwPrDfzV+tw3r5OLcIddA8mrvUlcW
3dpPHYPguZSX5LRCFZuei/sSyLdXHpnjdxRUqSPyrBXQMKOTmgd6aQyJxXSJGRMy
cpCr8HMRben2nmogj6uVz07X6qYxqsbtfUXx9xNZUpMXN/sJKUivwaPv6gXamNYc
LXrLC2tLtVMq0DgG5yVIOr/KkI4QpysqULJYXPkqVsNHYCLEObIgajcrw7n6rqiW
eKEVImn1YQJ3cLe9mwcnwpJcviRen6YexyYFZeS9GnJL6aK2FnUs6++gPFWqIAdH
8ds8RUvBDNGhvITSNa/JNbn7KPLDTp4d9hslddcZN/a7ubK4wZfHAXcK1hsYeO4R
FN/nROhghCxHODBZVhiRBBsB496NN9cZFB89sfidQ6dtckt8CWKF0KKUXKlR8xSQ
FOtIjHOa8dUPe/XRF+UuZG+xuJlCoeFz5/BkuWlXjbb9srE6tvAYOG661ke/YcQ8
N4dCZj0PjqmwZvNXKeI4Fi0okf0lQs5gxBBSFAJuuyZz2uuTjsHRXEHV2LgEoTmG
wND+HvJXqkL8xt0W42KtklkpKtpFLfBSx3ZcClZYfrC5xBcpMTuhDppntqSuq6Iw
lGOfqfCA+4sO3LWxiVMvqVoUmOAeDjhYvyLJsX8Nujx+c1Cl72v1IcDNLc5mr5Pn
hQ2w1Hv4u5ypBuOkIe4cbrw4WHCOnxLOx6hk2Bn6PfriSw4D2WbzoYmxmuLnI3B1
YbMaaJlPbqC85wmmsoY8bNz4ijvJRSZ5oJsRBR9z54wYIHm8Nu2ooO9rbaKRJnct
Sy+MPykY45F0jchXfS5CUahZ7yy9vnXPmAREoXBiadSaZRZ60gUllAE8UixacQ5z
QBvAXVDFvSPrC2dbUKUHqRwNBZHxZR9aGbzHpXj51nDmQUpmVs4kPiFbDiKpfI7E
14lvEfydnbPnKznQmie4eEKqvP2RwOet3E7Nlz9C/XBZLnWQe0xth0D/2vzTiFrF
4+zCVc8FN1U3yCbME63VBJmiMq8tzDvwdRBkc764IBZwRK0QZ9OY/G5YCeeCyiwP
d03kMuhqhwL70ygxfKGiQWyqqBbEWWp46SxY+eyjkZQYXXIU9X5ABZ2b8msbAzXp
d8yGWKL0GLiYxcvnSRRJAAgnx4ACThv9utffIbwlD6Kjod2egFcjxsOONsQ6/dSP
IBLsG7DkshtJFSqEe3qdzHZuu+yT7IQOfU0lW7yiajpzIrx8kOg6yUoMpgqWh+Iy
CWVgNByMptqptEcV4D1mWlPzDldWaDF2XDhvEEhmojbqQYwXFjpZMCHsQ/SUA9kR
Iwgr7Z1ZqUixTBFjQWNhlh2SU5dhHx0vcAbmIW1BX/2ZU1eNU8ym3UGmaQNHboGw
FsJy2FueduwYshoVE3pGgbsmESS3xTgYgt/IIB7iL5My8Xs0zP2FyNNs/sGbsTqr
ISU8T3UdZkhYvM6KVRtyZWTI1lcJn1Jn+xTQbDdOIcpuA9JCsK2806fhJpmjzhHC
s4yBV7W4LnaSCKFHOBEyjKN6E6ssqhi1JKa7/Q3c4faQDtdyHXtcd6INelVoCJl1
V5XkGlPfE14HbTcl/4+wUzDYxwooNBFngreljeXmmhYifPOMHg0jphGq66mqrMQp
+h5vUBt/5qFjbSUQZZxd/4Aw9Abl0G17XVAPHpC9d5qFnoB43WXU3opCIM9HeuDe
br088tXjtSV1Lqbt0HYZ7nytf7PNE0mqG0JGmu1Fljvt65XPzikX8fuRMe3PwqKJ
kN6ignrst4YeNe1byMasQEBDd/0JoUIjwsoj+TS8aGqb143IwXInYXUBEFmi2eCT
5+3Hd69uoMUB2Ui77wumcZnz8Jr7cQULJlfvohnzMVj8WLCGhAwCzNxLBf5paYVs
+TZ30W4lLZs5g8iJ9WASSNNqsGkL1lArmXkYoyslWhZ5ThlPSU93jvV5tY4GNvKe
hzJcOt59whCZ4UbpFPfqvIFERWVjpTeGN22XbRJZepVzAPJrTs17tgVx0plaPAlD
1LMYU8g0NqzddJyiQimRIcI9lwHh1FKFzCOE0gXTkoze3xym+HuKK95Tf6ItBqDS
u+sG7j4OuQIlVSl6g96+eWT7MqXP7UfgVj68OU5ohEjh/JTmHyZOifPMrhYpfcCM
Owsc5J9tYPpWW5tU4/YSF+qxSqLibOIZVTTlV4bZd1Nn5xt7wbltNhXzXSo9UYo2
tVmlaIZpm9//d/00Z+9Cqle8MJevGeV+5jyB3ri5L9asxHrmF1ORsyZOWgt5Hn8H
gK3QIbOxDIp7/er+OAjVORXOUm/e3+WpFv8FfKTXE/MasjfyozSW3UjHSDmFZQse
S9kRoyjjUQK3s8pO9u9bGfVtjuFQuvBBrAyMfbCj+rGJ3r4vypLB54kUbdWvlUcg
y/pITPEeX3XdwugJMaE35H8SxC7wMDDulDzdWkilk5no0sJJUpvr4ctnDtl7b92c
Dq4xbEdQ7r6+M0YAeWZCd1G0/6MOzLeJX0DypXUFhey4mTqSODDl3GHei8fBKkzO
ATBi2tkiHL/Tveoi9mjWHAf27JqMC0LK6txi0LLNUDyfXOICoxhy/Muh/9A/uhEO
zdWWBiniF6Dpk6gc+tiK+XKGWG4UEFVGAr4/SeRjxvGCXvZGXBK+Gt72Um/723I3
m3gr/LSmDxr+RgbrTsPoqrN+78Pk6Mj2K6ILIahA16el0FvgXZ+TPKAaDl/ofej9
s9WTtqefvVMYo5A3ZZt0LB+CZW8D6tsRLsB6a+qrrr6crKGYVoKAfG5vk7MxzvIU
EpFgGYxVt6m/hdYEiYs0qqZiroV8Jtub6IMXLim5c46p2H/dYtX97dM9nx2uh5KH
EMw9PhDhss2cirY8SvLA5OpDEw+5ermWNUbb1vdzNTssZXr6LeTO4uUdxTUmzN5e
fRmfpUCATmBIW//Fmol+Q7dlj/5yHETmtT3e8mGquTbS0x2OtLOiedIne8XALnHp
oLDdGP1eYaKp+/X6QQqGgaA9t9+TymfMDs5SfZln7jHMLGiI5nfL3vk+oLsHmWBu
mTpp/w1qfp3BPuf/Yo2f0Hm5I3kCCDg5NYbNJTjXg4DQe58EYofhmE71d7IQNPul
bu7YMLxPew1wjONEauEgPIJfsLQkMHIxHn+SscDuZDLSJn4bVuuUakHyBIZwiZGF
V5cYpDaRshbC8I6TnkVTByHGHAXD0j1A0fOqM/Qgj0Wqo80B3L08x1zrfortHhz1
uLkQFU2YfNjwUh35SLFE3AeSX8AUpdXj6cZNaLcIgu57EoEcqpoKqTrxcU/vZJQz
/P249/YoipioG//nsH/YeJ8ufiJM5gG0vVLcWF9+Q+2U6DdppVOdyfdO/BRX8UhK
FN7UCc37rq+4nfGcgnIVLfq8bZfH0bKvzozF69wwV/FY1w5BIDwk412yokVoJqA/
IeN/6gv15I8hrfy2SzUQ8SUjZdbmzWalOZFi4Cx8GK7HF0/PVoz4vbwqB0HdkoVT
yOTsx+bF4RnpCK8blXxVlqs500AREp6ys00bJKgd52mgJGGaIf6RENR8fE6N/M7a
j5O4bMr6Q1ydSaKI09fBvuMs6F33pODWcPVeO3v3xtgiNugF81LqAtXNnRHJoUk6
XeF/x6kHAUwpHa1V3rUwaQckVRUXYhGTk3oPtlTggeRDokcciB2U0OZEIyD0AK5O
TFWLnQq04059aPNfGzmqc34WS5XRA1Z5q7UKL6+Peiuo6rtAucIBY9GpECB+xWDb
nloo/d3Hvm+tyY0LxcwyBYSFUgptEs84qdEVvmGYe+Z2jGCRhtnnYgDvIMLaazh7
9aPjIzMOXQ/mKkOPgaXUB5MFwZSQ5YCXXQKy4oQG5JeutrOsasa8QB4bM4V6n4pX
JAc6nhuCVjStlrbN1l9umNq0LMjI0GkIcly/l72mCy8NeXcv2ZfmkhzsClnCTW4E
bIk2ecZxGbN9bxfiEwMicj2vQR7/WuElSk9mLiFXt0u8JlrVN28kqxk9GeYPhy30
R8pYW/ACdEFJYv56UyYaaVKyRZ5rIh1vRVsbPoVZj92QymliAiA9s1K8FFwtDyip
/yrpedEb59cfxtiT9zQtYJxajjdShs21M9NMOx7iEdO8IiD5GynGYTjZ6lZl8oP3
edD29kJU06Z2UnnwCaa2BuNYxlK2CZJ3M2lrvntC6ro332k2MEeJRXPhvVfXQwrP
EU3Pi2o21sk2ASV6IrtL6mgBj3uLDoiyn5Eo/iMArX+Pnl7YVhYUqD+1EqbxZq+y
mQT7pzdQk11Z6UctLRxW10eVz8c1Uv87RAO52EromgV93NDfthkKUt8HV3DSgNo3
VnHhNKKk9Bwq4ePRyZjpwm3zRtdkCW3JpTUbC6dcDXysbMZXdnr8vJteIFFr1GM+
Ek3myjfDElb3a4ekEvAmxSNkfnWySoiwhUxZ7ao2nX9Vey4CTydogIQbLutQtEeX
G4bHv5yCb5n25o0Izuxs+Rnv1HZPKhobgI9c8TwUQIA5/YmTP5yOx+deViGhLBka
+s0YLbhOGbBCqUz2VD0kLvgVbwHkRA2Fs8ireO9ZBTyfOuajen9vHhcritGZk9E+
8sQyDBcDk16UIzLOx67yS7kR0jRWxMsFE9xi+WbhXJKC/44bhqMc6frbHzZqhOPK
M7d4RoXUpeEUge+kfpZY0LLCvzhPIgRiM1AV23aqknuYTkO0TMNij+E2EUApQW0E
XmNLhb9WpaRu7lStLhjRjl8NR6oi751dj705brxo1q4fNs98rDv9Zs1js2Xptcpy
4LL6cIVLLyQ6jV7oQ4Q82fWeYeAWuUzEDBH3rrC4y7bAQNNQgDcNJAs1sXXK3Miu
cHa6nVCOMeubKo37BUzRVVtGuz1fkls2I1tqNJCJzTtjbzWxPKl5tn0+TjykHRVQ
6g510U/XWT2fJbM6D/ZnWlO+Kx15FGDbDYtJoUEFEHPjMTt/scxoP29V8mCfQt/e
bDIrsRwjFbJbT5hUZezwA3eSzyqfu3gZZ4ixXIOhAK2Es/RSlYPvlp7GlbPU80wc
2X8r1TMZ56m++Q15wgl+5yZETZWXOvkq1pkKd+y440CbSnc8tArW5qgzae/qMiUK
bTDA4pqjOM7GV3UQjqok6XdBtmN+K+nko7pVZ639FA88n2zsaqou1Gr53GvDLs6p
pXV4IVAz72LxpC1BNUAt6Rpf6LcWmXRbrODNVHvIkQS201Rb9QFv7XYwXzcqIo43
Yg7yQIaOPp2Fv+/Z8jomDJL5Gi/cd9Qsf6OhD+v2EZDzabIJ3TgGchCMQYeS6EBA
yY63Rc3yO6Io/xJsyK0aPl4GCrXx3LTwt+5tW5cdlAVDODD5o+L4PeU0AeVpN11N
st6NoeCwZ5tUVmSR6VgWbLCbcspjjGAdonCYti9KnM0Pq2m7KUrECDTQg+wq1s5i
p6bs1N0CpkeiWiRvBMAZRhPsJUXMtzQr24+Fr6WaUVeTm2gaZCgMi+WVWvIx5qeD
AQnF+YQNs0BnZdq3ebvRxofjTY9cB9iaaACpI6xutMRGGw+UNbl9ldSPmcRJnIOY
i+IruJDIDeTjxZ8YQib8U9orRo8YmLkcEzlDl3EE+vIX54uVLEVsqdsMsyvzdcRw
n92Fwos+SdUDnTaigBard38/xrQwLE1fl+NIJFTU418cmxBrEfuyaoDmXTQ8XGO2
NlsBb30+d2y/SSTqYeuzbzVj0hu9slbax2P0JuUNsFTcKRSSrr3qCMj51rcwEAaA
104eVpvV5YD5n4ewdF1oP79/JetA2peRoqBdkb2SJpfPW88WXlmzXMYXYpy0lDeg
N8uRBlH4a+UgKuetijNJlE58sPnKTDCjKiR62+Es7wOx7Gw5hCJ+T5Fu3yigLRuz
EG3K7lCaEuClqOel0aJTdjf/VaIKKXdDr8L9Iw4p3HNzsCp2C/APa2EQ6gl5qfNL
G5dBiVfjSpiPrquEkE39RuwVKCtPjwYXUK5q/RQ84GZTepWv80WGg5VMmIPHH03h
In7GGaAeMlJbSHqm9XUWwWNSne9dMmvhpFaVQaNwfVQ5bvgn8LhG1qz4M6DKHJqc
KNRRxxEnu6S82SVZpJPidcOex0L+0knRHfQtbSIKtiN68Ns0uE6KDwLj4uSHtL5G
G/99flu/V73A/Bmp9a+32y3OR1Mex32JKQOnIoZ1rR/FBSadS6uT0mfh+b8Wwu4W
fAtyHt8v3CR0mYUhUOABMt8IFMtiSzRj2o8jNRXImLv3C2LuWa+BxfViTIMrgsrf
ECj0kreR4ham9TlIvNeCn+r/yyiYZF7Uqzs4Ft7ICCdSTjpyEkghAfEnHQWwYmEd
m4kH3yqDr7RYJLfSJNS14dpY+yY3m8O1rplQm/5hvcGlJno1kzA2NNwecVVdm2Nz
dPmoJ9SFKk8zS6/xetYR23S52Vq/tA8BwVNMef2QniMirQBmatq0wLedD4XkOg5p
qxwTml6tfzhh7VIlA6q5o6meB699lmdyEXVi50cJM3Lrz2428VWOo0o+bB5z+HiI
nlk7BUMkDWJOn5A3ZoMqzBzE/OPUBr4lRFj5/aHop2KE8cjAyZc8YoY5SFJh/Dq/
k/I8sV6g50ZmsVZXPGDnnNEkr2OHXCJN4qt7ncv8lAYO1H65hQGUqUBdM2zccKUk
STy/fTuf3LTqPnEadQQMnSIfHuMSjVvdIhLboERx7wlwx5NI/4PQzM7XYuIMY9kB
V9J2mmDKtaDoE6aelw/bez+Bv63QIPUDgdECx3h74/DVjcZpmQvDCLwR2VQfG0g8
wfuRfkvQpWHXi7T6RHDoqMp9wgMCbc5zR7BSa8rkf6SCALY3FyLfPllay8Y4l4Xp
RQ7UpZO4CrG7ZcOzMCqgd1gnuHSPv53/ByKrxJWrm/NUhhqYjz8qc5AAkMM5uZ05
xdjWMa0LWQs2P1VRgtTRZ5Pln4aKO7Y5v/dGBjp6ibX9SXqfx3WtbN8D+T75i29h
L0lFE0iVnig1FnP18NP1VNW1HzQLkdZHD5F1UnkDJsy3+Mk7jHfnUJ3CjFH2Hzjk
PFiAJKJT5mDrKMk5chqV8H3l/3ttu3n98SQhuHpjiTX3wWjV+B1xVG2MQjFua4Po
8xMx01FHjYrHHrpHhlQP8qq1iRdF6UHLk576db9qSBSk1XDcxw8+Z7bgZXG6a9Sn
tRRZB92eToDliq1HnSO6OPABgTcz5QnS+zelALn0nKQTqllE8Aq/3cwRHA3ZTlZD
KKIFhdH06CP2rThqkdB9JaZujDTTit6+nrEbemeR/ZtzmqG6dRnTA2Oi4QXZGN+Z
owHvXJEj9fBQNjYabLmfQF/FLpxdIez5r5Q4KjHmBIoUDIUrmAO/pv0rH5eRJYAk
WHh8JUFQArORpNsazVvhJh/E/XtljTm6cemFhvm9iEroBshEQvil1PjclIJ3NAG6
EhO6vZCpEt/gHHI3mgfSC0hS261BpWZ5eLDyI7YD8yVAzQTYRLPeKmJOVOKH382C
VZ/kPaSC9WzVz/9k0Ey/94urgqCKOEYP9BI/VCHvLTxnhCqPDJ15RF/a+ESfEJix
J8JmnYXTEChWtNbS/Fv7lnssLvqFHsn9iq3YRYz9ekzJoTahFAaT1PKvvSm+duUt
lMSHAnW0mdZZl6VHOc+hobre0cZlAvu5hHZJms2iGnjMJ5ByEqYVV1rn/p6MeLLb
c8ahjYz1YhktjIn/rZa2ti+nUoL4g7WXyoUjGwRfDFtieg+NgQOkbiB2868EBsLn
1gQwQZhEIkOb2Pj5VuXZ6JPVBT14UnsJL/nGAprZfxZTXW5r9Ajmutn0JpGjQRab
oHviNvo81J+9Npe8gHNVcqvNI7vaSUCfXj9Y7T5ch7eubfyociObM6mOVKYznS6f
Uc/t7wJiCLctnJI2EifuBeSKnUaL2r1hm07LHLgiqmtE14T5jgjKZXsujZ3jsECF
EfPqN2cVMQaewq+A/Pqqbw62yrrsFVMgYg+ySON7ybtzVqsP6tci+xkq9RUG5AqW
Cv4FYt64esyBdKygOiT3OXt8pzcdJ+Ol33cHjXVNlX/BMperLcrSXX5N7Epibnzp
kqPvML2s8KJdUluk94ZLHYDwAJBd18ymUQriGRaEhYIRVMgv4WNmzNNZn1CeOpKn
RPEJ5DvigRf/hpJSmtukXx1yqcMDgLTOz90rFLeOqUJBG9Bbnz90uu17pOIahME+
XDPB//yrs1VgJB7FlupUYlOoTIwdntCZ9C/328SGNflYa1Lzi2lYo3HHX8kycsaQ
pi3NJKvOstDMZi9ULC8iE0t75wsFb57Sc88WDejx2eCUIZkcrPcxXGMKP+kAVA1H
+Uht72Z1ci+szNdDqCK5qbe6M8QoUv8DBgMHjNxp7nLhdEBzadQL82LUUpjwZdyd
dfVHLUEK5LLBhO2XdMqoPAVQwrncNqo+4YnvdXG6WHpQWY8u/3lEWYp/oG7wUk9M
A+2vFrHWEhbRwPx8ryrDPiotMGxZwgHuNN/MpybCVk9u6eFdU7WMGiybbRXOx95W
ZPscXR5ihwZM0ixBjGt6xHSe71oES98dXPGPMEk/r2/KDOKAI2yeJHdx7NCTrKNd
LINuVmuKsMrJYiGqiFVa3dtA+Zrslrg4EqSH6+d5lpuc6WAZnauPUlIDEcviDaLU
BAC3YKq6RkCIbo66Wl4EJy3z85vlMD5CLuZ4gjtSeBpOl8GgLacCa+FIwaw4Nh4U
mKQc4dZoPpGnxKQBhGoWyUu4d3e/u9t7B5T4kucXG46mzJ3yfzYzA512v65j9lmr
lZwHWGCAfXEmH5AdUiU3FOt1lCtMGYOghSXjkkkyIw+ifHCIOFKyn4zgbe3X2ZiP
Mw+UntTs88FjStO7E9lVvpLPnuhkkcCKbpvvE3f2yVil07lEwXdHopN3l1T8T5mo
BUmby3Bd11DI176S1VBEqIx1nxM1UIxFS2ynef6BrAxwX5XutKFL+xlEFqFXCrKp
Ut5u/q4GeXimsK/jc4c4L7tSo1CIKmcYGyRfULIU3IqcNM4202pE7KC3YgH8FV02
p+rjmPmffL15a8k/YWv/kvS/SUWfobR4ChUl5IsQaIpirLm2owVetOHv3IeCruFw
hAYPuwYydaDcEo0phBdr1bLHm6uvlWFE0MWveWqI2jtgYDjz5ybZD4Mi0L1Dza3C
ptFYY0s1nVtLxQTSS9FncaT4pz8vj+run1+ODZ9IkejKtmA/zhj/HCPaPokw1oaR
7Q0UDLMQiRBz3zEvD3hA06jT1ocOQAzyL4eGG5fHQaETMYxEMsBzFKCz1dwG/Yoi
aYCxDKAGuMl0gm7g5eyCesjGrWY80ChhUIcSsKZzsALLvhzKR86gEbRA5vRQU1pd
S3YadfPYCUVkIIS08DLNniW4Hf9iwVHZsS2a8OWqkZmQ5PoPvMoaDggxj7vzNd94
tEKXkbasTm8rTgitmAfJ3BvM3qOkbOPVDK56+uNtYzADqu4HGNl/HNh40rXOjryu
znFlJJDp00aBFs8sRsBb3KJRrsbflNRP/qnoqhHP7Wk2cQhL8azqyH3rgi2WK/fo
qcYyNYXCENh0xej0y7zGDPvbsfM5tE6vxbQDhpljOIDg8pII8sR6OwjhKL7CRAnV
N0wh2TJdoCJq08QEHFFj0V2j5dzxKPy8ASofVlD+XcJcN2NgZi0pGg91bteyLE7o
ai15PQfGVpFSW1FUBsdGKuA/3OwvBLDT6bnQm4vdHBLE/T7/0lXyYHwS1iaU1MA2
EcmFOfVaZVBlNAbLwiggVn/iNzwNWHaOfEUwhnXZWb7PSB0yhNH5xc/hBCH3O8BN
+wX8Jszwz3J8/CpFiLi/1+609TD83YsuYyPzDWyIJ2Hm1RN76+/4kD9FpJTkMJ27
n5JxP1qpN2I4TGcfVqCI1rfpqbsNto8h8Zs/3ooWxq0ZOz5FJ69GCAV7xOYPhw5V
o/VerFrtEl71fHe1O9CsuW7rUYru/x/xqUiLbbuRhQQ4h6OXV9mXX5rl8MnwqtiD
xCeNHEfzztMYDKHNV1bMdQtljIXwpwauMERK5aclcfFH8lG8SbGYtNEdzgnj8H6G
NxideR9U82LhAhT5HnN64f7K/r9sEOWbc7pjUI7B8oGw39CAWUp3nSZDWNZdl2uU
X6Dr4PQ0KqOHy3jcfolMmClDYrN5BiVY0ETa+FsiqgpL936kFbNcr4ra/MySAB/0
3wiAE5YdKlalivrZOu3Pe3k08mNgFPjmghAXlpHMC0wT1u3I/mEeN0fBqRtKtwxP
BSvCczUASKdalaOGPnSx4amOgcVzKtl2Af5C7JXCi68vXM3U1ZQRUMbmGm2PwPF4
lmFJW0iaTOvV6/Dv0o5k3i2NTK1UMOcvm24wgyKJfQChJspesWrzzQ/QX1RlMTAa
emiza6+a8WC2sx5muhCKo4kjklTl8v0dtBZ0WQgDbPuOQ3uHvdidyjTh9SzQ8IxZ
Ablp8bpaEsX2W9aFoIS1SIMvEK1GNul8gcFj4McLzbc/q15m5AhzI19jn/Ee56qV
q0qxsaA44FDIjHxQ9cwieZ2zaxk6UE7i8TnbwZgb15sYWBazDXQgAyGmvAYMqafC
LmZHwGDzwOc/WI9vppk/MO8W8KPDyLyUNIRNFqfJQIfO0EUGkzZBDx8RjR42aRII
LWMJZneZmc4uQMIxeNiPdGTsi73I13MMDikUYbYH0dIy3tFJY3M98Ck9F5v8ttF9
Qo4s0S3Kbhn5LTTfFAcJIySr77vqpUIK+pWqRQTjDv5Wc55TWasasT0JuUKl3od6
XTD+sIZoBkSO/vBOHCxH7NuDM5OZ85xHyKll2YEowPFD+nogF1oukzVnT3rMtwmW
B33pE8hKtLVdZJ+4FZhUWkABjF2arXAxnY+jCFfv8kASEvfhaelSofmO4P/HRlUZ
bKrlhBmCXAzQl4dSNlsyMdZVtNvJbK5uL0BY6WGV1+wjx81o2OyF/DJpKDLaqPyH
LJVxPjxJqPO9IocM5WTDJtJzNeeLmhfPYcm+HwTxV6zxf0DcJjrx2EB/VxjV+trd
/P+zTaIO7TjdfJzuAEiorkZsMd9Qn7AMpiEXlhJuOKtkxarYI4qX6gQCWBMcAqlh
+zvhp7qHX6YOzjUnNNB5O/6nvXHRVRNeZ2resWlUi2zr8rbShiN1DgBI7BeX0otw
W5nP9YKd/KactGPrc4S8ObFu7IVjfMP2dpIo1CRQk2onDzOjysvHotpPo0WGFG9K
9x9MnH/NQ8EBHE0JFTpK6Y2e4ucREU3Xzdf3Hx6CC8PvaTLJIAgd6iZ0Rvfge+k2
DPnJaIFDDnOkFW9aMpHyDq34E8odGT3shYOg34lS3dxkjs7FNxy3c5g5rB3Zry3k
4rSjGA+AiJO9TJ9KMQlUf6WWBTOvBiIV6Iur5RXInS397v1vm8MsjsGG2ZT9Osb+
G+HdV45QNzyBaT5DTOcL6oXGw033DlZg4thCH36Lc65A0k6vCmpL8w06yP1QZjOJ
6DTBIrnzzMRY0V10VBAAKPQzl7I+KqExeUPuHUEFUanLUGd5Pb01wcyIx+OUDUik
oEhGfjC3pvhSXhGzA2/dz7RpMpX3Rtmvme60j+hxhDV+Sgss+o2tstYAKiwABMXd
X150uSYNM+2OxtIqcgaiqPnwNxFOvNDWGL0iuSkifZXiC9ljKkv8i9pVP38WGw4L
LGvSHIIctfHWB0WePke8uYUFwD+qXmnICYi6mtr9ISPjWOdcIaY0xa7SZOXuAnpE
RhFIvGLTyIZcwZgrEh5nYNYZUeCDgsgb4Vm9qW+0DsYLmWF73hksQK7YqAxyHA8q
mjMvDDmxV5t6bP1KKV8HpuAqylpYgUbmiUx2RnEkxquMc+JDHyv2AjQGYiIzuj92
5omIKCU7PvsnjiL3zIBwjL5tEB79pESL/usD9JW4Lify9qeKSDEZjNgXK9Z5yHRj
9jAidAjxmw6d578n16+08j+gnC8CK7N/wkz23n7lokwJHijhWvtD2ZsdS5xYW2Z5
LS+Nmwgsq8zAt5kJ+tdPBMLr48fzf4GSPFMa6/mwLNYFMMR477EuRn1RX+NOKg15
WKIcgYoeTUsOb5VFo7N34f+cX8hKAcxHROcrQT2emIvXCzxvnlGfoGHUxHQkmMZb
QJzH92YNPthdAHDCMFyVuXx6vE9/VzdTAOLA3YCx+hnuv74c2BMbdplyLMgHDuvA
KLwM/thfFuUDDpn1hLaOnlUiinwu4AYKppSAIWkbIRelX6FUuyFi16qkuvxC5Y1V
2GI0gr7OmngIH0QWBDkjeqVaMBXHx8BxFzVmYWcuM1dC5JMJYRoS34V1b8mFxZv2
pIzPDbfRbPECLBJu+w5+cMGI7w6P9rYxvgGKUe+MKeW7s331URtZ/Gr92wEILNDB
l/+KZoFk8aWPyev96DXZV7Fa03+d0AqDj03iAx3DSpUdB3IQRqT5YtFg2HHDTvL8
h8aFPJ02nWG9NT131vl7jFuT300agfx1kESUgpW6U0byijAurb1Qzude6YEd3zas
Sf5L6Eoz5zc/5/UZDEOmlKkoqIkvPXBcpDuNL/VIOhtJCRFxNHlnSfk2kCc5DVas
jgQVD6tpOK1QJXkxHoI7ESKHSoKz7GfgAwKJ2hHf6GfjHSc1rB5Ne1Mi5kygrldV
V+mjXZjpaVwDVz06gSEb40gwh0YeSxZox2G02D+QprCaXcG8MRK/5am+6oHdD1lj
jsEGH7VhXLAA+MIglcz0koVSWDOdGuqugjXr975Rr04PO8Ye228PmoZ0m3Rjn1l2
Kg3MIrooauYPOcMjbg/4RkdOYd8LBsA6j1CdeyG9ETZwS83CYRe7eBhmyIo+0NYd
xiH7jaHcdhgT+z4WFxNMnnEp9bKeVqpcH1J/z3rgo9RPl1qoIiqNTukYtYdG2NR/
Ven2JgVvP0cXWSSCUhx4fecX5mrWPR+awjL3gHCTwMyNFD3rune9XeXOmVlsiI6e
QPMT+NZiL4RGMfbM/yAAiTD4j8yCLW6tDJYBQrrj6+J4QSeF5JVAaJBtLEu5Avxd
KvDDdm252u1kPiXeeIRuGXgvFs2p3PNVGRkq3rJRgbdvCAr8+uHbTqT6fDjKSfhl
RolJ/pPmUcYjMLdQEU4DbR8+xKDLVJuFnnstF8YjrFSCqWETS79rOSFTuVqZ9vlC
U9SHUqsgry7F4LGA9b3wo652ZTXd83LCJIcqzJStkdHh+ZO9xPQ/06VjzOt1cBq1
SdVbpshOVhKJwdHTzJoyJEkCeKbIIJbkRwDVRTANT4g2WAVHNrektBrftb0qml7g
qZQr0Qv/vmEsYuB3etMct1N9pYuGzHXbguwoVzKshl15y1QN/XMuJvsnImqzy3O1
6H8D60M5Hi1G66RkOQj2mjIvDO9XHWpngPYiCp4seeYqBU9d/jiedMBRqP1NXWBv
/5gDmJqnqW+hbDc0b7u9ACMLn01HbAOm4iOmjPuNo7Dr0U3rBevHmgXG3i/OJxwN
+aM5wr1QkIWtgl9TgnHCNOlVmDdcHzXy72uzv6fp6Uqk7aAaeQraxB/mIq99Vafk
mRP1d5BsEeHPmGvTyZAVF7Am9gkNSqnypk/RppCTsgD1gn3Q2X6JikS4eV35Jjo9
D57P3JChph7SUD382dN2AOwNePlotcG+BJgzVSKQ6GVZrxfZzCc/WX+n3ONhHqLs
o4doLqjju1GPt0yPg4hiFaZaYre/b8BN9wyQKwWxvheAlWJDbCXWCY9AMYFGEfcX
0x10YMvWOG8m1tPti4RMjGE7qy+F9eLFwjatPYJb40Z8sbl/5U7ugNOw41NVz3Dz
Aj/ltKVArjXGQ0IsJTeAxp3HedSi1iK8bVRe5BGgLR1snJXFEAEj18kxDLZnR50U
onwQKLQD8FCnRu77rYyCF0qHHzHd6nS6ErSMxReszL4aTMeiGCPay17PTP/qqs9/
kbglJitnnkJbzO1BqUsjv9Z8GPESi91c1M6SvMzFbPRHcn3wL7VXg+iM/+CNTL3w
uLD3pN3t63ZgYbCLO/Pd0wJezjLASx5Dr+fsZOpFW+LX4l4CiKoSE+uuYATb/I2+
sO8UMtHPgBh9TFtr4ir1uXMRRWNsKn82r9Ue0Tq7/w13GuQL78LOktIfIsktUaP3
tsW7blrLmPIgmg6s8/v6uo5Lv1zCOLb5uZhJXq8VYPwF0caKg3At9P2CUHHqv9lT
u6U9zm9Yl8whKqgYwN8wyR+wzUUZ+ArvaAg0BBjawIaSfEm3538RBVNiJYydZFRn
0eLuk3RiXlEelkCR44cW2vRAS3m3ny6FhdovPNe7DS4EhoPP0PkExa2aoeKYhbPv
WQkwV801tc8za9+MbPsypULZe3SzbBcwcrarDG3wEUANYy6b57JBYKjE/ERlzWMh
DkFWRX45vimoTa+Aqm4YEEIxqyY10A7ewCI+RmE937ruNIIILWPtGICk6kGnAPe7
cDMCbDprQPfS/MFBEULHJexoiNABhmxVuEw8svJrY1AG7qf9CEas/zVWAm4g2aUp
Ys1R12s9Lyfpak7eyaHKsH4lJfHHW0vwzyzsXkTGEcT3OzfCFEH5LkrmgtXtRgLS
czLimTdCZbREF/4Yh3UsVm3v8lNDsCvFFvP29C23EY7sEPtaPrVc2WpgRGcHEx8R
RJm5D30PBMQifIld+iQHq7QKKK89XAWuKTFpVX72X35c2NPBIwFNMh6O7O3QhFYF
Fwa0wXckCG8y1jk6kaSlOTdT5JHYjPiOmTWoraVvepAxRRNGwPQHI8OJgwTw18WY
YDDHXhkkMzqhFT/qJKf+NpYFpAWcaGgs6fM50LREnKHfFd3ZIaCcZHCRbUK4qlMT
JJ6KZQlHRvXE8NL3FwlsMfJD3D/i5/Z5up6lr2WZcdlyhHMs6897VxRn3gEmSbqd
Lyen4VYMhShdshLMOFtNK9ATlAh1KWesWkuf8l7JeKaaJUmruSBNvi89FAHrqMnV
z5kFGSU97nkSPb73I3PzrDhEG5ad2DC1NZmaq0q8R8H4cZbuFtg30vPvnTqJluU4
etuuqlhnCuB8Ky+9ER9tP2L6W7nUEhCmbzmgekm7RkDjMMX37lOQDKOCRjQMuqAc
2o1YR6VLWPIJJkbjcNBjBZc2MujE8VOB0OaLB637VGR+xVsINXrzfvkmdMJkHwNC
jpbNgchnL4LBtsawj0wGIKg+2MWfy5HSvLHFBsQo+/h4b2tl5kwu3b5AOsW/OE7W
uJngoKWh5TNJVvwQfgyhX04iWvHlcS8UGkWtj64S+lj4bS9/BpPwwBA+IRTyCFlv
XzGLaRUZ0wugrMZSGM1ktbPlWuRYQi4o5NJNdtXxlPmLj9GK9pNkoHNMe1WbBHRj
o5onxNX2Zr0wLVZyp+Hx6ZmtMhaSkM+XowD51p8/kaW87pWRJwYJlAdJlu+fxCFA
WxiUcdO8BqbhuLTsyb70F1ihQGCEdjfryaTRbiJZEJIWFU45tcICwbKhli7aOEQL
64RhqdUoiM1KyNxQE87aEMi3qByiTc7d1gBnLgnBMBG5ymd74XtzxvHuLoCjIYKA
DIwql1xKHouY4auJTWogTVxjfUSJVzPrnA4tc1D6AvFdSbxUJJP5E++qT/O5ovFp
McaW862SQijMAhILwlUQGFfXGQmmNxaBMG8CizXBpcy4zFe09Zq9Qh4XqwBQ0PoK
wb6wTYeDWJfCF9Fjm1TsSGLBVfuO8QEZgX0k/mGolhQPw6KVqgmHbFeH1lzLVawi
sxdibL3c1HZUu4pfPu3V/P0W04NvjcbtOPP7ANNj3TIVFB77oVLf2Kq2i481IcKW
mThyoJunLK667Gmly89uz6IAg9dRawjcYenVwX+uvg5fOZNQ35KOlVNYIXHi286P
atQya+TYCQJeYV+8xTF+86QF7D4QAiMOzRS5PAOP9X0/dsO2Jt06uFufqsCO2HsI
pAi5bCRXzdD+XyZnJwiSe7o0Y8bJGJb/DWg3zbBSuxc5iKEnzaaYWtt6DKkYEZ54
/KTVVsXMcqWOms+SzRnk1Hmt0aMa7wm3rpDTghc749urklqZM88BngJkEjuAHsL9
UoP3DH4+nb8B0W3H2xlMS5a2OnoSEbj3nXsniUgn9KvYXl+60C/gfDXkTLE1fCP5
47jJlpyerQJdCGhf5KR//il05DMS8vPeR+08IpDmqkSoTf2MBjHuqNca7okZrVut
ptu3o40tYnaQc+nM7y47v4qQm6g5untqknNqK3ABKGUDqwFfI1lNZHdu3pmtg2xQ
aqgocPJj9FN+zMOJ/tvbP1Lc5dguYD9SViXNQ705EpyODm4bjjgu1ZeioKmO0+xF
xrgKzN3LlkMagEzGIW8ePth87+XZxKjeoWOe/4ukzWhnoXzqR0jk1y2ExiykVzwf
63Dme3qzv76P2gt0fJuFa29FI6W0wdeTx2M3gMCmgdVs9rklvFMbJGAqSAHKGpuL
F629D+cW7iTlj3uXXU+nI2vcDTDTfn4xEqpjQ9LzgiWPruUjgIttcfzAQcZvgp0F
GjbtErXqK3ioGMlWWyD1jI2SpzZolHy7kKabw+oontskDuu6ZU61Em77VV8jnW57
1GQRXvNnIRWT2N86bYVdlDTpiIjYMYEb/KaImQGTQn1S8UPkpYv3Zul0edKnnqXq
dUueQIR4puSfXVItutKeMCqSQu9CaNm02XrHgahbkFJpHTaTwTyVvBLONKzCxv2m
5vop0JYAZDu/mCwrTXYhEQ/MzEIkZELU98zOpqV/oKlICoLW/YUCNi1hxOBteOKx
zZcIZeZVRrSnrGvekYHDdGlSV2fKuWE8qBUmBs+5NS7GwdzYfhQ3YuUEOkZcsYRi
hA+ONT0e2Qixo7z7Kx13CQN/uOVjzDhGCm7JQ69/zLtwUrtCCESaI7lUsrY+MEBa
H0JKRgyipvKxv9ohhk7vspO9GCn7oDSK19VX3uo1uqh0YLEoKKlSSMpdRunidl9B
wmt6di02bqx8fSbDWNJu6/MJrIAsQn8eVd2LBli1pQhhi7NDW3fTNQtScAaKbarP
+pJ1F+uW8ARn6rXQQPPnLcus8PuF96aqXndT14qFF01em/x10T2trS8hxCFwJ1QH
rr0DSt9zAJxe57byjOZoBttCQsmTpOr6pWE1QmZNAchpw7KfXCwQPQ3oMScmwKdp
V3/BdFn55Ud3juS35hzk+RXdqlDIIY/ouz3+InJibRQwqM5JWSZ7DvLJzlY8cquL
+PYNqPwKUAUxYaHiipbQ1uyDRtvcNlEdErQTQO2mHgzUmenFNNAbjH/7jR+3LCl+
b0hHgfFV2dd7opMMgPmwtuzo4p28plmg14g6YF19AdvKHqPdlKc+KX52Qca6B1hE
BuOVUVsX+mxl/VecHw7OOVnVhgWE5b+p6z1tjOfLsEYNg8oq1odKWUBZiPhBr2B3
A2lMMB4BzSlUoKmt/0k+17QUEnuLPiae94Lz9PwkgVboR47VmRADvKMnMgKctCfa
ow2wKHJ2+QJpM6Ku+jRAiH0d6ZuFGO+oLKuNhmHptVU9jIui6r0uwaqPITEei9dj
V82WV9NSWw46Mchbhtmuyj02GMn2U3NRHO/B009jn8hnvbXNPUNhm6+I0bcI2Ysm
AZinJ2TXfvdMTCnmEjF1eQKFap6MTQIf1g+cHzN2/OpDLftiTgWHW3haP3fMnd8U
86jYqjix8flDpYbK5c4fjN8F17EwB/cwg/5d9u4u6PYTAZHbQQBc41nCHE96IvOA
ifwyh1tkNOvnvhf0J04oFAHfN0QXjrX5aSd5l4g5PgNDFyOW+M7bGqB3gVWYpAO1
YBfHIU0nMS6pVovEUQ3mX5vGfKTkSk5JkBO46ykoiK5U2S0y//5wEL0pktBYR/P2
h/L+6AI8rnX3FgE+CQ/JTgQAALHtTlNEkm2OiPtdE0qDsaQJ4SxJDpKvLI63wnki
/1YtdIhRWSSMPG7GQBNOBJHn1jytJR0KBLq9PdoGuaSwMlyHkSZOD8N0PccsJrvd
8Kib6VUmSwKrthsJIEB8IJ/PjCutNc4jEwxrM8W0FxRHXIrBdvRGumNiL9TUtsMI
KqCRN9j5sSdz3OYZzwY58lNBjhBLamnnfrWgvCCNgLvE1IwZl1Sg1ZMlWK1wR68S
4Bb0QUpYRAMOypXGKczgv0qgCN6SW/xtCPJ7j0Ixo+tJ7UYdc360h3UUKc5IxxFj
fWejNXYUu8O3JWpLiHgUqMSW5RnliFz245EYZGDhNiBBpWRDeMayqwaFoiIlr9r7
SQYT5aHNfW97ln9ylLcrVQcDnggYqhgs653kliOSibBf1ti1mVOW0UtH9KqYHOXz
e89ffa8fyTkrr8wLirTp6gJO93JZMGAsRyBaJHGYoXkORnMgKlpBZwblo00n6J3J
royI2rZSiJmjUfK8ahb4KSLrA1WohwTwF/WM6PAtp2LVDLEIoXRE4ccma+7DTFNJ
Pw+1R9imiYZD+UKrDOThn/CF7JIzW/uakF2D9X5c+jbsmIZ31XE6nDiyjrwGTh0E
f+VsmGq71XlM27OYYlrMw5t/UvGKymEyBRPkWTPmCfBm0HPfdS0j7TLV/6IIp03q
dgwA2gdAFUapxqu56+P4VCXp9MC0TIFyn8ezV+R5b/ldA2nQrGvzKzUdAEhCoob+
LHt0xRoYdPnqobkLVNfNLSTmgyDLJe+Z7+2KKmPi3hS/nmck5bleiNhw1Yt+57M9
9/beAPF3Cgs8BVTr+yDkr7gibPchy8bvPbSQBzIph0foRyyd7r5a0rwYlVtNXOr8
JWxyPvsOztlBM7PIxN1zL1Lu+KjLWZdQT79dqwFQoU2TRG4PStbAM6anZvq4CiKg
jacLUuElyQ21QSgVfcpnUqAxN27BnwhtHhFRsXSVOhHnoiY+QjGt12MhbY7FRnvt
LBtpB6c3d2uANQ9+GHgvhKkzlxaP0QIfvfjeWbWNGhwZlNTxLvu3dpWLeVzplJAQ
D1ZS5WB9hP5zV1041k306zTMEuvyPvt9/5C0AR30s7RKQc7A7aX514qqD5Za6jt3
6wD/faKANZxmaXP4lTuxn+fj1ZhFYK8brile416KXAmuRgYsWK7PTe10C00Yhbke
wXnrDxWIcQfA3YbJw9Vd3qCTonyi62M/nthdVdv9eOezqsa7U8hzOVef+3/DK02+
oz3QFyGnfQChJVihBXmLJ/mzVdTiHHUhOYn/TrPGq4b22maXJWFHlvxLc0GR7+fN
2YKWeXc3v+a4IbGPHmZNjVmWGNWUK/vBfUcUM1RgV2AQCEmVkBC/+kE2gzF8TFPb
vSguqK0XFg7iic1c0+Xd9BUdlWuii5CjRSHDtwywGlbCbsF+Rwq7aQzRXWlvcL2V
Vcaxt+QlFo0e2DhRjkb7VGd/pTEED3aNEbdIqwyRZQErAa+hAGsTLmyjMJyUFQzl
I3yK0SsWU2Kmr73smXURdIhq2jRK8Sj+/F82ZcLi9Uref3xXsPDBVDonPMkK6RvZ
8/kszRhcn7gViz+FHFY4prFemYJ4jCyUsHdNEoxnzV1mtjQ7LmLiM4AKWLT2f6aq
EPiSqmodbQeyMTAUIETNkYrqJiwjTUh9UqXYn1Z5YJ5J7AX4eCmDFAoTp6ktt9hm
IagK7/GsStJL6kb+qoiMgMbgJAqzpfPJBduAYoAGG5yeRXqrS2JuCLI0KF5Pkc/G
Lts2PjRY8fa2VfcvLWU4eJ7q/j8m6xbpj5yPmvNo7hmrbys5jvUwpfcZiAASqlZ3
mk7J9J6iGrUvu0TT3DlDJC/j2oRO4jaOjvYom3tQKGPScw7AfKLPuyfuuncJYaz8
T6UfxApCSnmCegYOA8oJd+PgrAeMFogC85aaPEiCnFL8hyAUT2h7pWS+IxWuGCmu
fevayqohAH+CRr2ZI7g7GtLtlu1BLWOeKJ3o0bdbEsl+P/Ypk5m8WflyRWyFDHcE
bz/dxreEv4NpFgT9p/TMBbewUUlLwsIXD3owBPvHdnbfsn1PvRigVfMof06i0XhC
FNqHx99sU8g62BrMy0OZq64QaowWMP5fu5bl5WFe86f+P2/BZ9MWaZC/yYhs9Bog
mn+aAU9nyUU9SjH3EynqUREevLJ5Y7eD1opFTSYgoLbKajXSMXwFpBRMwzlYyQeO
Y1WLqg2dsLRIpsm1krn/iKfhx11+WHKlU1b53UhChrTtiCiJmwlTIb5eYhJPe3q8
aZ7a8/1xpLaD31WApzUA8b4IEwcenn9Ax9+8LZLHlH3x//8eeRuLWViO+v+ViMZ6
li4D4+xrrUYPw6vEr3LMDh6/v5AxU2/+eTeBIxd6RrpRWiq+MLC/NbHZTYVgbJUw
heuTKF7M8cykxk6u/IebyC4NErsKSMl+eFMprIy0jyxYrc93x8Ualy4q+EziIXH3
a73DHALSAFevnNsdzCMq9YjIQN8BVIUmonl+MI372mwVJJYvJveOuptd5wEpS0hl
p5yLItg8dx9mMTOtTmQzOso2/r49z8IfoF2nFXNIQYdiv77Gm1ReOXgSEaCQ4NIl
tA3PiCgz50q+8Oxsq97Z6TLvV3WJ/DvMIz+JFjuBY4RA3nk+AHezTgp7/o4lN4Fg
7P8oA5O+SgLTlVVU0NsDYjLKJIRylHIZ3mdq1/b3xmrfA0PrJBQn/CoL0kVkPitZ
RfraTG5aKINyc43tdSHPiQZogWBzXURnAPZR+9sFkGhxm//JtH+mX7YLXnAEKbDM
Q90cUwNtoRHXZ24SnaCc3Cs6z+W436wbOvziyE/LGVmnADNc73NnfHXIkWxFGWai
EFgqB2fVBE9X/yG3kDZd9dNr/aGiqy3ZpmzNq7CXCqIw+5K6FO/skIgQIomEPkGd
6XTwa5EFBnLD61Q3vwhqsgZLma8oejVduf0SdQGZylDHV4LxIfvk9PreT47BFI8E
j6OK2X5pTgrEqPbe8Jx9ORhTd4Pti6FIQpy0dyQxnTTdDk+Y/Kud17P359gtsz9m
D1tzdB3Rgl0+V+EapcF/ehOKlhQZmaOoJ7jgFZSqJV3+MSGDoJJjX1HgVS2sRj+x
P7VBDYMlsqD+4gjW3pnnpsjb/TrYDFHlYaRaj4H7kGPMOd99QUsvxcJkZXe62EW+
zdfgYKCc6EIixvy9Vw8emZouA60oAhR1t9QYTD5pZXuSBO1cynhTIMW69alKrI4y
h6dJfOIMG1uwNVUfolS+grfAcYLAJP0Umz40Pif4ICgENqLnfZ6V4hS2o5vNIGHb
uMTr2wiYyw4qnhIImkuIuQjh4RK/F3h7/UaGd98SiLbckNDQ8zcViTvDKXyAjqXY
6OsrUc5YxfxHaAJjVLxytqgm4GpAe+qVqBCQEhPgpOTnYmRIBAv9TlZ6TPhVRHpV
QJEpHd29y4rBPBsQ8IEhOu5wWhoRyf+nZ8hw990eJ+IxgUOAXk+f1UZh1cSu0QVY
+Z0HqEnoDn96zPfNxMXpl7plGSy7xkP82gIeGojLfTFgZbnihV5HIVZqQlEJqtsu
y0BuQ2t4TSwnZ0h/8wgeOxVfc1QEw1ZYuixXwCDVi6yxLIoGm2fJtDNM+UdkGGpc
316VoTdYwwQbusrjJWkOCjikWia+SY2F7PqoCEdf7RO8YgZ6gkJKsOI7qv6EeTAp
PEFlKSrN0bcXTD1D4PKau1h/ZGIDsClSSachD8HhobgdeocJBowAeiIofvjbimtc
hv4yt1sl5sFpwhE9k7v02vy2jdTPatBRL1TlUFs+b6IRbMdYds8sSNA1g39yqqtA
il717ZNLx8nK9aaMOnYApoeZA4m/egpOewhILavmrxoXHRPOyEmDXydbKRI/GRDi
T7tU5h8cBNJrLqjOIOpYJVrRYg+BbTVe7uDJQyP/lbfdHceodkvuhqUnS8+lPITk
Y5O5Daqt+uz/r+OAzCl5dkx7fCXoOZq9lMiM10LoEe+6nPu8U4P6lZzcKAum2I0L
fy/Me2u+G7DjnXRd4XlgIMTEe5OIglj3UW4ApExd8OHFD9vZSbnKPNNCGJH6ZcyS
K1iZ7sV6bUO++wTo0I49oIunPqj+NcpHa67hqXwXIiED/sjeJMVu/WXSVDK5R3ls
kx6pQDIVSvvVcqAbAN1MhXdPrigDSGEcn+W3IQ0CHpQ1aP3Z38/HZuOBXn7CskCJ
XjIm/ZZMW4wuWUaRtueETU7j3egeDeFXfW+WJxejlFwdOWAzfLJFCWQ/vrnWVbjV
OSzlGKr9OX944woQg9te+0kOftXwUlfrGEo/TelSLhoJ9QLdpTS7kpBNeYCFoibX
OsFGP9fO/N38h+xlR9FWxqlvvBZJLcl7MZjmwKCpr/Vo16XcqIS42AgJO8jdjkkd
nkT3GsZa3E4beNqhiCWTBKYDo4q7XJVIiRd09Ss9KYFq/4lSisvsi2SOX/9WvVeV
s28POt9W7v58vIGOMc66tzA3Tgb9dRUHyJuJoVtZjWSlm9XlUqwGLR+6aDbWL+oC
u8NmCHSpBa2Wa+luiVsbdol9QZbd1FUYvp21TRSn7l7Fz2uy/jf1eWNPnw2VUXTp
cLHl1tOaJ6RL8o5RmNwH/bdJ38xYTX42QpnPUoWWHS7D6Fw0Tl96fdQSJrkbCBe6
9nbg5wWF7s1waRMAU7k2dTURH66BdgI6xJCtRJ64YdFJr8W92sIeZc2WnKrJgSok
WTRHBehagrnEMyY4fwIoRMjsLSwbH9FERjfyXux7P2X/H8NxC2XDphSqsT5R8t63
2Ufen54KXe8Dx3SHvBGtgM5JDvd7cEd4tm6BeOxaBmd8RAwsy1iKwFvX1vOKP0Jv
yVMyScFc2G6a/kIXjH7hQqxFQFgssWSuPOliveAEFv7DK+pCzIwEC5M1owLHFNYN
QVh7YQN4rLy1wrfsIMQsJTp5nrydEQrgkZTxk5sK9bZtzw28GvkZy7XqbpO5S4FG
QrtLjGxJoGsEPRg9TxfFeXnteM4pO1hljgOT9+QrU4KiNLuyMJeEVeeqhrVePpcx
3TLDmom8j7vd8xfi6aWm4TgJAp+Xz9PLXYVDU2w2Sfu0WMSQJbGc3A+gJMJQBjT0
ndsKRqsd4Jt7fDGFHj63HQMeAEZq36Ao4mc7ju431FM8fexFTtwl1s04q/U2L+mQ
+dSz34JUZTwIpl5IfJQNYFJhSjEs5cU+azmtYjCN/VMEVdU4oui1G5/2uwBxHmv0
9Uzswb1UDYRclmTr8aj2ZRvQu43rXDjhPEYvbGZRzmVFB57xRGPlZOoBH54UxHXn
UwwMYuKVfQoTZwJ4nZFzFXuG5x/ck/LD+vRvMJkKyEGHaU+ftWvYfu/kPlzoEW7+
0fBPLOBG5NlidBNaEWL2IHtKSYfkTNALYV2ECtJEljUyYMYqR+Sv74hNVhquO5T0
pGUtI6QUC76YJkJtPyNBs9FGnBznrVpI1GTx8aZ8h1MwcOu5JLB6wi0CKTYGVcD8
EQ+4BAWaqQgP3hT11YGf55EAbW7fn6leIyQHh5D/18nPLIxzqCd+2AQMgQSgqvir
rVaC3OpqoIcdmAMDWbY7NBMmAiW+wTjis4w4Fw6CLdjnXA3M+ER5KkCMSyQKSaDO
Ib8gmM09HWDr230zCGza6Sd/crUiOvi5mPvfOwzxnJO1EyY3FTl/6w/rqJ5GANm4
bPZY5NYIABIdW/KdNNlRwTOVlcu53vzP3C5S7P7/Ii1Qv2mXu5fG4wTxWytyKYVP
4dlZm4NbrTziAMW2KC+QA0/FnrzfLiPORwN7R2mqOAHHD3QNn0Q1YhR+IAk4RQ1b
B/Qq+qLCtFGPPsZOKSQyVfhdlT8C3MCSPsUr5Cxr/w1NlS8f10Zs3CWMdiGR3FaB
DSwi2DHduu82r6sfLIu7JPq/CEf+JRcmDukD/6A8Jkseid6SHlZdQHCmnICmQVGY
cD3Fya5HIYLc7RZdVaYzOJLffTVIJXr3n4xGBIjaBLEoecfjKfNX6RlNj7hp5fAd
cL+yB8ca6ecQt3wPFVKaGI9N0E8diJaah+xys66MskF8F/1ibJWyC8oj+p4/qjGk
W+jPgiGhP8yQVbUCIDE1PCr4LKKjpaeJRUYEpJtRS0PGrOl2HSrWG9NMoNM6Jevq
KwHPB8x0tckG/iUMT25spjFUtH4TdRoJZokxyOAM78t663LnOjWNQgqiH+10n0t6
wPlgQx1nQtndPdsvS+zoO6dXtOhdhTvH5CgO0Cpe06dA8+rV5hLVfHqXYiqi+k77
HreIktPYx3qU0Kwy80IsKLMpKn1gABshL0mJD7yha0/x0M2V6QlLpSrWtuux7Shc
gORC/E+6tvifcAuZmIlNiBtUER+KobBjC0lPUk6pyeizQkFzaFCNwtS/EWK/5Dob
7WXu+jC7HDTn0PB7XP/DGHftrV5OOT28wXfNx98KBAyWK1hXjBtDyJY1GZ6u30fg
7h5YeYQGbhDNK4xgLe7W+9SGs3WCuHtGsPnaKq0QPIpAI1LcXYSHRjVDK145Qm81
9uoaVVDk5egaqSvlx3nRGuXVQwYnpm5gflH6H6qSpBOPmn+LO+jQ4+5AAXlKo5Mb
b4XzIyc89WAPkowob33iMn+efaW6a4tk0CBW4KG+Z6qOlxtYNHyQPeGoy/4wkczQ
WjuQ3MBWvtralqN+YKVxne6Cm8B5DXep0Wa3PPx+wdfDt0pM0C2iqxT51bSnPyop
0ETgsYIfjfUsBhQch5yoCLuWCuA6whFyz2UgmEoC4CU9zmoA2jEazNRj+havL6Vx
mfevSeDXmzxfaqMfRfznpUfa9TGDxvQVdA2RXxyO1s/4xOFpXNi4lOOonkTYQaGU
3R/GePm5kh0tu7EXwUmpita12Q1DSxxzlCwB2iGYdm6CY/+pRW9ZXfMEz8NQFHJC
AzTnQKB7wq6HwvznBdh8y/isGz+DDMfiGXj4RdRVTD18YdcdMN1gMdHnHxtnwzL2
F2Vu/FN0bUGnFD/rEbn/m5JwBXPz0Ew3H3FsPzZglPLR6r/9gaChUhWINLD3gnWJ
JoNWcCCaBGdU1eo0dHa7DzqgR2Bxdkel42yMf16aaLnByR7k/jPmlQcBUHTtv3ax
Ka+urbIfOVkgPo9YJq9y6USXfNJ6R6qFfr774NVTSQIAtXF/DmxMwbpIgwhJE/FY
VxgUPcKLd9NPLR225FyCT1rpFDco4cwPGDs0Z5m8VOfKMxgo6/LH0JbVTcvf1zw/
uLCYSg54Q6ds47cE18Mvtao9Q/9F+daz8N9tY26PyXBv3sKe+A0cL15IuLy49B8I
IV1Zg3HmBQUyST+HlirIPVoEKFE3mAhc9VzhuaoGYmh5fD6iGOzzo0lo2j1A5BBf
7qhE4LPar2s0oeggOQUw3BAf4+DHuj79ARO+dqp6G1cW1yb+eqXewgvbGseeSij7
kuUXG+1BriiSHLwNTgn9bPZw6WtJeBCLFj4MFXbcl8V+xWFcKJ+nKUu3c3xkjqUQ
fU3sCGfV2VaT7xw7rLSAXGVEr8dCVeLYZrynThCZGZ/dprYpRKPLih58MP2nqNlq
CrJKisHRZOebslAukcHupRTWHFfqWL0md38QztD5dSiXtNW3Oi+q7eipz5bf+Wyl
CHJrjqXGmxylt9vuTjVxXSpgblVa+iNEYUkBEJFwJ+Mv50ODZSzsKlFnyACuP0l7
on8dCVVRxFzjWU8FE5jDvRytZWGtgedz+/QkdUMXd2G8Xj8mUQqnDl85K6T6v/v0
EZhdEPFlfKeClHXqlvnCu9F4NPdla9p7ZT5AnNJjcGrruYoDWyBMxPVL8UrYbvM0
9F2xkF5TXKG+MY5jWpQ472m84ZvV0lndJ5sqb/tkryi5QVyLxtq9QxgnNtk6tSsp
BgwzFI/tV5YmWNIHv1y+yXb8DxBqTuuQvsDsh2yxZ0e+2x/Rd8MZinuxediH02Hi
shPu7eu0Y/tIHZ5tuzsyTSok0euOXXj5oOo5X43i9ytcL+G74XaUBd6wXj05tikl
88yy2xggMPgx1QyTuuxz9yC5S5CKPIeMoMQWYjT3bdu/aMDIDpvWzNDXLk1qNGFL
h6tdKBUfdq6LmML01XzoyqICHxN5fUXvlOuHY/nSot+13DYOQ6i/DGrHCWtwRk2w
nsQ1A+l8CThP+nXAQhhNkjIAzq5YG0eD56323h9K/7oF28BB14LfmlRQamC/8BBh
Gcp45wYDpbncUGYkk3oa05rrj1Pgw47HECPzt0nPd6BNM8TMm0vT/H4fvSE9Zy9+
532F5ZyhuYdt/95KQWo79jlpMBM4rhwZtyid/Yw4LboKIMBMo/zoq8l7gaXhACxQ
mpnA35///lP4Tv+iZ1yr9mgftE5UI+3p71Uu+Fgda6mitG8HZzBlpCsLEbRTn99T
+lMcah4y0MaWuE2AyAqP70sF4RDDqtsd5wQLYfEhlRAviy8kqNOp+SjJW8LXCYTt
WGDXL5F612NSNWT5uZitJcOiNLpCL0+3O/1Wv8/J7IovKxbb0fdIWmpAs10Uxq9B
+w9MQjSiLDuOyBfyzoUr+vpr0Hx7jII4WaO31RCB12KDKHEHlm806teXQ2nwg5O2
wvYyrU0Ev0y4CZCY1qk6cQ0puombI1zhmb86T08VaLL3UjjPD05hJE582wvokHiP
/VPbz6TnL0kenjN+sx7Q9I5YswI+NqzTUTwXfDtXSoq225bTeXQN2JCHN6Ig9ptF
cbxfiAJiM1MoRZZPsd6hoggFT99vKLPbGvEwmVLC2P7DCt6RKTB9U/AkU4RdVViX
XiBKAVGXB8m2526gHpoGt9uEk6pHhLl5ySE/TX8r3ChPlLa+2btTJt4fgB7Xjwu0
8Lo3/jiPKIXhXMf68N8M3oKphYmRxZSATYQCLJ6tMAYjOLlyM86TgBXMEPkPIvsn
U6dR8x93XMIcZ+R8ARySo9tUeXz77zb5CVexW5CZTPEYzdPhmf0ffM8qU8wbGblG
m0PW2mT0quuyDveePQHdLPOTFqLB6Qi6KaVaiZTdMBCDjEvN7rS01d6bgeRf69xV
86nkLw/BDj8rg4hXzcFmiixYGLAx7nKPWoblL0+PGxrFIoXTYbA5M9O4iiWgRxuC
kCSWLfYTPRTKr+TAFTUs8uasO1C/si4VLzbYNez0qUxgO0ngYemQr0B+S/LLDTli
pKe+/hZBVij9hW39v5imSKPGtb5hnJN2YfCo4k248VIwbYhXM1/EjTl9IdABq4P3
jCqSQ9p9AhV/4GduKvuvZWKWWTIvm5L/2hE3vDr1VuEUdGM7P9od3jgpWuGhrTcQ
+u63qUqHROvSqlys3HNzuYp5ijb3Uv17qcETy3Yjvz5RI84/uKpKEN2cGB8SWzkm
HQYIYDLzqif3ClId+gRuW0Ue2skhoT9tNiIAJMCuKLegDF5gh+wkJqGp94uv2gI7
22AfmvZMUtlg5M7ePMukVj/rQnytRhUSIM46Vh2mU8pSev2A9rZZDOh+zbDrac7O
10/dDefPPGaJxXqf60Sx5HoX42brHJO7gWDIS8rgcdSh55D1yO1Vf1iVnKq78VMG
uDJkxKcbiCqz2WuMspT1+ciUVOGaiGsoyRXkXdwgyfwJ1QsmpcfsxTGzeuGRr0Uh
A65lJlSbjcMF/M5DOXJ/HbfU1eLECAAPJ66G1XQ4V3Rz1+mkO44JwQEq9t0M+8ZF
7UPzp5uNeueFkV+L36ZBE6XPlQm7sXA8OFTegJAAcRuEafPNVHgSN59PHD8LFmCt
AC7us+DtfBN17/vOqGldOG2fAQ8cBF5YeOl/Yl0ze4W4YwcdKvAG390HI/CWWKd4
rO1fjOm7q5qLIa3z325t0gNEKZAsJ4J75oQk3067a/L7ybzDWSssKQoDA5vyI7cM
IKZkeVw7lgitHhojOD+pLnN7MHM6GQk334z0gUSm9ETMixzPPWDYl5C7knIb4en6
8ZuJ6mUdSGpicNygB4MgLW9V+stw+wusgQsLSgaJxTkE2f542LzSMHy1ECqmzj75
0QJYelxDfQYAb4Ei8aNfJAaSbQ+NWJXJF2rkyZQtkwE82Yxv9dg2riM6ri6vy+bt
s2/oKpaP5ksSleqGP3KzmEl87axMVPQrQoblEoIc3mKUoqd8J9TyK+g5BTt8G8cg
PI7khS5eQ7uql4G5Z6a6v+yz6qp2MHOOx5BixRgL6sKQKjC/eqF4M6vl+ycdkZeX
37t/oKj8s27pkYMfpYpQF71bpp2N3lSnS/KYbELTzbDYxIbFw5bixEiQcgbaKSQX
Plk5gCiNs+DEJEI3ko11/q3pfdACh9rx7463trwJ24YfVwkieVLxGDzSU/RxWnuZ
hxJl+Sz2bLzb6pjnGiYvyDOm8K+tWV6WCWwl3E9eLuAM6XriiGhNl0nRguxp3g/m
RMIKCPCtMXyYqbp3KDltGSXX3NZA8rfCCgPPLAYXndAJn0yoei3Xw5DmMDvkmcLs
0k0xeOkA29e9MTMcM1UnZdTN3l+zLnOai+PI3b4ZF8l5KH30AYNN+gjWjm6HBoTI
Ackw2Fe0/Jmv7BITBvFG9x/7fK17TcDVLbP5nHaj9mQmlPsPGi/o0RgSMNxw8i8Y
4SeWF+iDILHe5pkaJiOH5XNs+VhmdMIfBGKThiADSxjiCQrVejNIj+eoBZhZ4WdB
JhjfG8tl5X72ZnsaXW4MAylTOP507DhEUic/RYeuzktI2mCGRkw3bLx3Z552wjMQ
u2tc8e+QpQOgiSvqgTaGajp09MzZse8vHCSgvUyVHm3k4Z/6FZB4B/Srxibz4Ohc
gQsdE0Kmvw2m0dfN3t0xYrQZylqWYNqdVzP0HEEv5wml0hUAqEgg3537q1AAlKV/
jCEJz42v/GXw8tb0StunTns/5eXA/dpi/rjqy5++lNeQrZaD0tmsRUHdDXenTEbO
WBwbYsgMh5wnPZIKqwpq4buI/HP4lWjG6GDDNmgvkkBbOXd0tmP82F/Lp7BWB3B7
gFl799y1nGfPbS7kvipAJDs2EVu5OpOFFa5Pi86qIPfcjZytRuSjF8Y18xFuS3Ny
2/UR3m8kxIqFjTrJixhKkLDkrczVAf7Somdc1wyCm2mjmc4fnEBVH5gGlP/cdCc8
g8Y7AHFSpJomPH8bXhXpcBRxaXmwNXIM39hjATuU5XVAR8V9UMHqMjtEOj/K1Y63
9+F7SAFRJSZ7AViSIYHzy5vECp4YRZl5Jbx0X7B5gqKV93/8vLs5maB8ikpPfq0f
Oa+OUCIg/8GCozqV2jHJHtyBzQBzXDZ+lHlW+YeTRVCYSH6wRxHUrm6hw6Lx0kYG
0Ed6G3qcN7TC7gjLcP86MwlMSy586Fs0vBRAn0J1lxQptFrU0LLsjG/oMgST5qj5
stx0FjqDlQJZPVJhkeKVr0LuF24Q9atibIfh/7BFe8wancq5et+CLtzTXSKRohaM
+Lmlik+VNjsgL1GQEJugqdans6vFiGrCK93o3Td56MaNg9GrJIA8gHlYRPxVhhp8
ZaNDXzUePKN0ovSCDJufiBxXsa2NylOJpvNEy4473/8UklJnJ6PGfQDOThOhK1lk
u8XFjnueQ9lkNq7a+t5sL88RqyjUCNLuHhYuAbi3lRUmwxCxHJAgNRULWBT1yRfz
12a4hRaqkKBrTS92t2FfCdbgFzn9oTboznauZGtnPaXuLA3vbe339cPe5hU9Ierr
NGNyTi/fuvaPU7fRGvZWw/Mj3cSMD6I6iTOkANZxvIz4y6aDFWOhZ2w+mEO08tUD
s4vLdHuMsv7XJZle3PuJWqmR7JbcuoMZPKU0EP94ZBPuWe5s+1erraJnHzPQgu75
GynDxIQWAPZgFMr2SF1hMWMWOV2Cvv29hYV//M7MwpAkC2nbizLnzpQOeMHZHvCg
UyVKdroOJPaobR3g/+r7BeM65Is8L9Aqd5A6jnbGQsySiV3EFVN1/nugEvCJ2ISJ
kbheIijyAI2n0cGt3gsKE166r95jF4PSw5P0ZaV3PqbXVExs1yqk4YfA8gnaMpl1
VZDk6UljdgFi/KgQG41ka90Ui27FpGYaSbHH6rT+jOY+5AIK4IOj12RPW83VfcFR
BOqVInCR6fzjPg+WPLZy3YMBjo47Lsrg2SgnXzWlQtT/FMPfbCR/rneXw5M5iziv
rAs2Q77Hms8HchFcVfLKoj4wmYn/O1wEXJfcyrrgRQdoB1N0bb2lYMmdX9wxEqgJ
MIGI7RQ2q570AWr+9hrJybxJJ4NugTIv4IAvJHd4UBjRzBj9JeTYuipA+9BQWNxf
k2uLVm37jeCFguJMWrSN3DGdx6A34WpDNorZpYdaWjHmIZFTdgZFidLHWVC1Kpof
W+1Jpkccm8OVsZI1N/thWDuo24N0ybKhbb9GM5TZvKyQLHS/iId5JhyL9mcz9W+k
wpm7vUM9/IrcqlDKsuLdmh3SE7iCxTpwlcxEyX5U3nsSHQvI3iRuLTk7zEsEOYXH
BoLMDlgOmPAKXEuZXUX4JIrBH25pHOKDbQNFrAsr0CCrRKfgmAT0wXovC5U2/bdC
4b+ZsaQThp4SNZyHKE4ngLyhxpb42vhSCz15fqjCSYtd3UAH29DB9y0pBT4TSbsp
mJceBDxn1v9HAE8YJZIig5d4Rc2av7SmJRUjiT4Yyv4vCwTjUDf1gP7lbMpDFRB+
JBL4tkZf/Vf69JSonqSl/Wg0Tz5Vpu2JtnzTt8DptTyE4JT/1p0ng75Ye3et5b1a
D12PhW804yUXe+pWHKj7FShk5xF1YeAAqMGFtF3nupQo/axPKYMJkSZ/FO4h7OFu
GLV5UW6en25kjQ23LR4hnRJ9nJP2k/0Z+U5/KpqdTFtoFgpysCAsgdhHjSKrKSQK
mRKbqZUf1pajD1H/QdQKISViVE4Q99XkGf5BepR29AMyPb2CbcI2ZzUOrmbyozIp
qD6rnF+OPZGARCc1nWzgvulEONYfyYmlPuJcIi/SZ2fX4FvJUhdwCfp2Y6xU5oDn
VSHaxjX4AhP1jmOMjcfL5TKDHGhu7VVQE1I7lZZABR8uWRNYsVEjxpxKe7NsCySi
uUr4OxCqTCjEd9tVHTSjCBGDkq05ouNiSn7bP62sPALeQypRrAnOZH7VaJ1U5e8r
QKmHJn4yZmUd6emRcpZVM6XJzyqS6U+qnX6yRlzSW0qeFwl00NzHZLfhT5VVlIb2
RwdFe3OclONragcYdkkYotnUBFpTTlc4wL9sja02/b/PdC3Kk3p1u89UL5XDP898
WA7s1zzxQYeSR/JniYpErBw3/sHOvAtVyRe6yebmbvF8TkLkc86pDeHOKKM62l9z
Pmj/LLscqeJK6zJiIIOSZva/J+HpOMuNXss/f9F3m05ZfQGqTjUZ243JC+4i6uu/
RDov+/ofJlVUmgLj3YrXQZd/6580MarpFLP8pERuxmfnDnwXP0eyogclwmspTMoW
TYyeA8x6wjoHNZYwXDKouRSp5D8L0fBci/D+c/2R5M7iROPHbrRRcjvar9uKOy4H
gr7Bl4Kw8QgjhAoFwsET2B88itWvfqlKoBrG/tyj47DfN9cAoqHpgXoXzZFVh+WJ
9hsbDzPf1tWKHVA4SQSKhBZaoGANiDyxAHvFePxrfXUhcsF9AMNi6Be3o06y31Fk
jiqRSpacJLQ5H+Afny31TNBNKioQEfGLf6MpfN8eCriyuf5mmj2PiUPz4ftc82Lq
JTgY1vBEq4AlGbMXex+4OtfwtSMX0bVoQ3jsPkfQvTvx0SeyoVzxUkbEj5g3kKsx
nPzdGe6IMbX68i9RaZtqIo3jwJoR67X4k2K7pVX/QuJo2IfidwS/9ICsrvfqTG96
t0j92zNe4ovblUd3gDkOhV358bO8IMRXMqORVuNtIoOzCqGF6wHa0fcf3fwbk3Q/
mTz+L3OdV/kqVAbq3AlDnqiXdP9Ae6W3ytMxY5BdDsyDFwfG8t842SHIa7ynfWlK
C1q+vgIpGuhBUqHmhn/1mn0PSNBAg38QG246+CEkRI0Jvm5A8suHnCvI6inUA9qU
OJ2I7uGTCVeVBO9xoETyNruivoLkNtqcNYUu+7UQnZWj4piBbZnqh9vDmQ7aGASM
TR2n0gFr9XtVNh6EocG9qsRht5IDi9bV80q37YKv1gBpZAq9oB9yws1yzMxhL6sz
XqkN0GHhxdIDl2Vhw9KWvEgemA5oAIYiFL2GOXuMZYGqS7ZcrDprVEDRlp4zY6+u
TEwv+lM8cyErsYpG2sI0QJV04MK/r6NOtAA7mzgKDL92VH/UpLIAXMUCVKEJcUw5
sE6kjXE9NR/vMp12tC4P+akfLht9aMEs6aIuiEsMZDAIeCpCLNFlLpNIqf6wpivH
1YPs/eLRYHgFa/FnMp1SnaKmgGr+gS/6VGxHCstic2yJL7aBIpvf/wq/i9A+pdQS
EunNMYPiS50vHtUHoog5HRJrx1FJxMPqBSp5zCWwptS04EeaZ3aiYMvxqtnzS8Z+
FCc++KInbKmVSLAhwADUwFxdMFW4vE6RrNUZCX8Q4RWdeAsMTqY+IrJH1bRMhMJ/
TTqHaT2fntwYm5oAMjPAHXgDLO0RuYUfwkFEg9nPH2Qzx6R5RLorudC8AId4NNht
gilUeHwbKL1SytsPCWUVwuCDIUHhh8z4Z0ApIftFCz0SAqS1pkGBXGobgHo9kF3h
+tvaxQ4cdVHQ9UF67MnyyTqnH/BGWxmRAGhOtZ9L0BI=
`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
CgsN9UUq2oSf8Sy2siAgHZmYRE38tt9OG97Uu7p8CA0i0PXx+0HJH+GuyC9AjH49
huxsOoEBZibuDIp/pCSenCtqNHqcRbywCFszVn41Bu5wplar7UI2jfK9sFxZ+rj2
rLs/Ns7+ZvJDJXhLEEkvHafsYVYUkrcEhaDL2rwOpXMJCIMrtqYKsAM0knZ9sFKO
Zgz5w7jGiOx1JnkXr9wMlV5TcQOpyKcrtt6uZmfAfmwoy20d0QYPHf+OMxGP8rnn
3/Nye0sMPzln11K9lJZgEHYiDKJb7bKsL9qE2ouP+Eono/FX3PacQb1P5F+2MKyi
74iy8gmH6BB0hvT9p235+A==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 2384 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
R804tQeTxuC9O7urYHmGPOTfw4BQquMdjYmS8Qd6qki4c0mN43mLLPGnwyGmEj3f
FaDGTyTinDrTCdWkoBpI2JWJikoQCrOFa77sEiS+Hfb07/cECgrAyY5TUkCZOTbs
fflp0s5JVibUtslpn9CuJtRgxmSgwA+ijAQ7Kd1Na6fk7kFlucjbzl/Kmgoyo5Yc
u8FajkJ+dIRtuhghJ9b5JPGqE70GUf3Az0Y2noQIaRVAfv2R1ID5fV6o1xGbXyX4
VJKfq2uY2Pcy5BV0GaIr+C+4MwLfvtlvFgcMrL4iLckUpK9I0w0FBEkQUpWo5aC7
X+SkN1SGaRQ8+/+OtPcsGw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 3808 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
fkV7qipqYi01iMXjqsz3CnJAYyPQZMJ5/Fnqde4GEjXbOVTqCCSOo+PDbAX00EOn
snbjRBkOV4glWEumrpfoxj4hxBPuz4X4hrUi/RLUIbwMqd2XOvTsAhAhXQvilOHJ
PalXuI5nNfY1cfISmqpZihUSCJXgHBmiGFni/RV3HyXbJuIzM54dAF9FeXuQX135
vBryUNJzKVIPsmM736NO9eKDJfPEJwOQ49u0vA9KCvisa53s3etMM37bO2PhqqnI
lANVrI7wK0bJQ1Am3tuWlp+R26rjCCjYd1R2JgfVkhsDcg4kjmwQbA7yu+5Xb143
/xjWAR6xLkzJ/ewcymSYGg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 1712 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
OklNHSSGy5Gtoz0RlM4llEsJwR4RuCwyY2d5cBhOKs6ldpd4TRIxzYZnTb0YO1yF
perhTn2w2xHHHZWGOJ/GnqfAKwB2QZwfXRSXluQB+f+qORJnuQvY7x+w6WqxJ0ac
HqMjqmxeGZx+xmBX5UDDFk+zhAuK9eUPmJtDnWGAGa8DAYj+JYPq6adt/ZSP1GL6
NAcdB5uOVQMVTLnQ5RI2PQWilZj6VXJV8DSYn0kMyWJHhvDEutBqdXL5BdLh3cRv
tSfC+zuM3cCWfgzGfe8rHEJBhJOp70YuTsmWC1b+ndUyxb4NDd5sv+76h9RgrE/h
FVfdckxU14L34YIhHQt7Tw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 6768 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
Hp2Z4AOWLWC7IRwO7amUsITflzmFiwRaUdQZmEcdALxXk8s/UiLOoSoMjR0e+sVV
t84fHbjNRQ5RIrvo6v5QBfAMznwLsNthcqEQTIcCLwGXP11qukklhRjPF3CDAZMK
9829Vv39+Wp1t8ZLoBozYHhQVngYm/tOC2Yb7X8L6sQO4tE9qjbiSzJILwcUzUb8
gw2K6gsqlcdl52xLxeczb83kOh/S3hYMV/+DOCr6EbVeKOxwEeqC55+x1cvQn2z1
4hgrXfrjDavhQu1+RpZzvUD5BN4YOLe+RAogX70aPH+aw2es1DrIA5NQ3S0yJYHJ
TJmbFduNa/fCbvnt4JX2Tg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 7504 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
hMT2E0C6qkrdbPZ7Stj9QeEs3kgjs42xMrutaMXQX9SOX7mHQUDCx0YbtHYCLWPp
ytQp3rsy9e9SDRieayyfmaqjiaXKwXpvNpUDUU+xjJQHjRxydFZuanWRco6xtRTy
uupXz+BlJvTFcGjaaGV9fBeNe8njqfL1/ccwRshAiV0MqMwPdmiziootTKYMW5Uh
CWNPeLuOzdnmfs6hFiX44AUYSMk3xQiQ+sxiYRQ8mgDRuSU9F5e8yWZR540/n2Q5
anoEOAI9ZQJNpPAA5/Q0CkU03L0x/7pyKx/ZpYCQ4sgjZL+wU9KzKM3kvzzRHCOP
+PQ/0pCH4VRaKkImAIVgPA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 2784 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
AGu4H2tYD/lAJ0jStM3NWgryRpP2qTUIqJBQ/xVIGgUmIyyBNT/7dmgay9lgcDIp
TJYfzeS578L/HPZq+Q/mVD81ir9O9iw3Ig1ipWIyn5vwCou6Fl71ar6DzUyzlKIX
0B7p6uOZAFSKdXqOV2XLRiapDgZcB4j7aOflgbHoVu1dbktVs5Usx346AyIaxJHg
eweF28YE9OHoISB324E1eUByxk4m04hY9m6UVrK0qZdaYCQZpWc90QgHxw+qejU2
fPVAta93ZH4tmW44hmm3lHEBs4xuGGFHEeLigoYlNSsterN0vQeiouUi17c42+pl
O43gapjGn33FItsITmQlGw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 10848 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ns
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
dbqeIXFM3Zeo4gbS2Kzeygd0+xZU5Sv3kuDu5zU3TYiDLtdjhjYeDwTGztaquojF
piScs9yEAcYybCgKGeB9Fu7ckmCgJGfzc3dEASmny+XUaIHNuVkNmQh7lU0Cst1c
JQSn9gMhGRWnprC5PN9Y3gQI3P0vKXGEiBeTc/shuq7xJj96DguzZvb1vyz+E+Av
0j7gVB04tQ18DbxKn6YZ8a7V9xlkC410lN2pW/shOJG5sMRwLo5TRfyS3EdjnErD
XbuV7ZAFoREqzMtRAOiGYv0re8RE+Nu5a8XM43yFXxGMDrAXsWjoGA/jQEWiltf/
yhnPr8rMbP5BDL6YKl5vRA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 37600 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
EdkpGJjSEG+8qHGIKgU+8M0rp4SRoY2v1z/ZU7DdkAIkzAZaTi+iAlxG8Sablvpl
JuSTy9gluLkn7BtjHd234M5HsH90W5L0z6Bx717CV/EJp2ZF+sOCfADndTVNPyK3
99cy8uz2cbP+TCbdMVagkN1nabMmPYyVq26Qw8MdGekps9SC+FjIsgZ8MUBno4Bs
0SFY+TTjIXsfQrxMKt6EayL46yfteQGN7VoT1bdF+M7Y08hmQo0MFm7iXkrm4csQ
uBRK/3TpzzpL/pXnajQvnMxH/Lx8ynYrRXmNPgA496Su8mmDhRJA3iJXqg1YvVOW
7kxJ9F0Hx9PHrd1xiHm0VQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 27984 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
Xm/sMhn4fIO7C+tsVJKw5twhlxk1r2OLjzUGu9y70a7H1eY3b8leal/LUGCnTZGf
tzY2t+uspGP8cGcN+2zd88OS3d0TdohzwOkO5Xrgm5c0l1yJP9p6dEHNRhjYWuMb
BJ8F1EdxPXSlH6pAxUaG2ZU6p/u6YjmdtJjczCIOnBXWHr0qZ0UO6kakLdlJa/Og
fxm/bq+hPmV/3ei/4LMtIvukbcish1KG7UbohW46kQbAC0DiFGnAOrG6Fh4NuLbT
C+dq0OG/dJ8jb8+ytXtgLBKcS7E6zO5XJ0ODVjV0dDlxDXGy5EXU8jz5VPvUE3b1
g7USRLjE2GeM/UtzZrz4sw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 30624 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`resetall
`timescale 1ns/1ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
fkEitW/pL8OYAvgWTin/wx2ytmJgMAVrX0eeSHiYg+LSuZ37ADSkfLVCfvm9gn7Q
L6UQC7g3mDnquqOlWDLE0b4o8/41dwRVCuM3jN714R6R1l5/uAkY18AmRzLtY35p
1fRY0ouID4n9wyt39Z4z+0LlDPPvOFMpm0sAVCh+rV3pBA0WFtudP3b6kmfZyVbm
KYxwBvvNUDnU7zWseFfiwEjNpTJEm1WThqWXSeBczZZ5wHS4d7JhVF7SxnPgNiGv
qx4qalvEbZNBv0RO5TJaxySIhcbYUgBjy9GFyHBX+P6xvV/adwTVZTTf2YI6NDmK
2gjCFtcZPgfD/LJu00T6Kg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 656 )
`pragma protect data_block
BKH9oH9RgbBANv/m9kenM0EAQ+KUUcvKCnTTiKokVEPwrJe2Vyvp4fzqRTbft7y/
ToT7YboPI2zXIgcRxJx074N9eBkgdDq25SS2J/B4kcKlXxgB7It+8ALCMW+2pnyD
fBhmuV2dTI2lrmPgQcH8uJQrzqmj7mV1CqzvjDko97Fnr24SuJLLOPQfsdwmmLWP
7E7b+d6gIE/gcaHRzD+ICIfdHtGPD8QT0nfA30oPXcb2q4biPb594R6NelgK42eB
sEVF3jVaPSOAgoyhkHKJ9ZKKWDfyqnkofct4jDK+ihTXs3t4UrNVPyGAxFMq7fXL
rCXp0S1d/9KVgyc7a/aHAqr8DvkXw+mjh7m5301JOQDmo10yFQRcovUfqhLrjAi8
nm7V6ASIXx/sfTYo5el1r59g7waYvAtWUjY6UlGGmka0u+iGoQnpoLj5ntHsBXLs
WfmOCHk7RtlOgrG/DMXAkIaoQA8/hq7Yxv3AuUucoQSAsv1MgovR+r3xuJ4XpL29
IEBZvguv2MT0cXUQJ7w2wW/hrz//MxFfNyo+gzkv3pqrB5C+F1nASaGT0c8gLzs/
oroUSHGnIXnc8neA2OxSV3TjYmvrxeRI64vplPs1a0+isspUczkWoij0Wmjc0CjL
mEVjcoxhDBVbLFLiYz79LbhMFU+qDkrvg15gmKxmlJfhdcbE2q2PnFi4FdzDjuJP
qz3vSFDj99WtSSfxk26v1Fy2/WzN0XKqZ5m+NJARk842rCdKEp4qZa66+Dy1wTbF
nuG6cfv0JlL6hS9BKdGMm5Kk5Eci1DROAvnu4upXdojUniNpZKS6LVOYRxoCyK6T
ArOoR2oT2ZCt4VOCB01VfTqFJ5LdtWfCmb/JhF/wyOs=
`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
NwrJzypOqlMi6jwED4D9v1tYD0hWIvotLzp74CnvqkFKPmmdDn14SmB3bt9gIYrq
mDexNAc8fkxmWBk5QhbOYbnGIk//MrJNCWhJMeyl8m1Zy+BLcJV0pWFVlM4TMwbT
vh4x37Ki2ezVrw8eyodm3ZoV02+uHQFiyNZVRml4EHY5SpP5CAsJ16QtAkS4tMTg
y2H81RoVPsqRiq6pYyLWO6dm2x3CO11ITjJUQfH5PMpgWfJ3W0/O/krIsXBj9+PI
ZBzFClMl++7Jbcw3Z63K66gLcxhiHp1X77fT5hjIq8rUu+Y9ACt2STaR0/JP8BYk
8afT+4jyUlUaRgRzoda7KQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 13232 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
FCsp8lsGru1iz88XORuy1R2Kl/bP+/rI/Ax5DrEr/N8L/pWTR+s4EjyQufijnJEX
W+obHDUe63KZDyRG6zDsQw9KxP/YCizjc961ZJkf8ONJXDX6QBb2qM2B0zK1MSc6
3gekSqNzrq9vXDAlGPpNTMuN99PSwjcwOrhExQ3WhfDpO6QUIx1OkjOlS8GGSQz9
Ul4U5mz8RzCS6NipwfvVKvvqb2QR25nbqLss8ajw+CbKJHarAtbDZBHzORVMPWQ2
0xrVmoiPStV4nC97hqZcmBaHotOmn238v2GGBQfPc4GBNjng5MDQm9iXICK1d3p2
YKnR7+euPBd+w6XCzNTHcg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 544 )
`pragma protect data_block
9/C/X2ZK90ijS6puYGstdC1jEhx2ma36pq3MmA58wZyYt7+I7xbW442QXAApjpHH
5xYTNSOntR3IQF+4GJHlmEPrAgvAUrN1XPM78gQWHySNh+/CGlW1zidw9wgQQx93
yUlIbuXNRPXBEMFjCd54IKjSCqdh2eHtIUo7oYcjhkZRkjWFFh3nauiKIZotbGBr
KlUmm+vrDVsZufLaqjXpz5KppOJkYaxkKcjQb6I4EUEuheTCHahUMiBJKggDRWyd
cKFRGGwT3jcNHNlJkwbKnl5DwVS7K6KAxbb/25oHSuTdbiqcocbLWW+2dggwOo8B
1bdOR/vWfmSnEFdZdEaDlcZbZIOF15Qhr04qQWX6290x8WRggGr3xox8tE8utwy7
BAZLwp2rx2T/5Ve95d4VQAWocDKamXVu0jxJVcA2ONZZ34qkHqxav38eIOsRytk0
6nyWaSX5JyMSCQfBl4w2TmB5FkV1RH1Yut8Gh0k7Lj65hPXTjeRewsrOi0qO2S+l
HFXoICv6lJ9yV8bkbvtDUrqe0CrVtA+LoLv0XqsXyhbkew4ivVr94PK4PcaqemIy
xztckpqz7myguvJwi4vbSDXIgLvDDssd3cl1Bb7lR5htonodWgXa+Uh2J4BNvHFh
s2348ufXuL02yJc/Ds9DkjR50G+oRPW7LUBCuk5BS/N12TR/rfyU7yQNOUqw0rLp
m9PtKD9e2hgRmpF/8QgEQw==
`pragma protect end_protected

//pragma protect end
`resetall
`timescale 1ns/1ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
TaOVoUKKIEf4H66JJZb1fBnSl06qvB/mwG8xYc9yD4Clo0oYIXGY7YdViiHZ/QGP
XeEbwd3Ri6WonE+LxhIRFg44iKsAkOq8X0d0dNi3GP3qy/VhUdqa/DWlfdyXx1Op
MNSRL69BiPK9axMuYM+WKOr77K4x1fbhXNOPVn16aAePGjBPJd0qpQXoqtUmmtNu
nP7aKyjh0I6ljlPLSlZjYJ0d0rXMmltv/Nl+p5d6ccZwWV8oa0O8gmpKi9vlPJC9
xh6si4pooLTj4YaPRUvDkYlnIh4NlH4893QDNivZxAP8znda0jNZg6lcYD818Ej4
6/Km7+y9ENcIF2YKJNsgEg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 704 )
`pragma protect data_block
pYClikrZPcns+xoVpZ0POSFUKXnGeAfYrpG0s6bcWHMUVegdLPJCcVhLLbde6MbI
RVwwgLYJuE6801yCBETgaf5QCHtvYfyF+rRBmSzD5YTnjJX6hEZd0ZaSBbrvPIek
FeU9lxmxoOaysueSxes4MZSEPd7pvZjtQP0caCBIAHiANaF29uFlWvBuzdsp8VIR
9B1BiW22oaiEYQOhf5mXlGGks4ZPAyrIFKDYgfbyPitFbGl50Hnf2+e622T9Gnvv
IBmA5jBpCcaMGhuK323YV70b6W1loYCPTiHHzNnAMqGq+wRYMbz6qZcTxRbm2nRK
U6L4I+NAT2o8aNr1L1kcJmeePtwi70wEzgjMm0F9u2ImqWbywarS2YdR5atbR5nb
o5Ny/sA7yCpnJT4JRWsTSU2rTVpK5ZN7CGqOJXjRapIzyN+MvI8tCfd4TxQTI+SB
xFCqd9Dq9Livm6inabY6ql98a6ytXunGIZjuKl5S2ApMsziqFr3PJo1/RfETBdCB
kQm2U1OjskXqgcR15OeQYV+QIHgbsi+QCcOXj0VBMBhLg7x4G5kypPLyxGXU2L0g
xvoAL7bSwBgtX3AZ6XYMYbLEQodj297X1AjajKYU3C9qMXw4C2buTv2FiBTAnLGg
ASfFhEGVXyUffd8YfFoK/tnkeRJHYbDrq4AcfbG/MFhDOt892S9djI10OqqPqHjL
PpmtigPXIe7hKQPP2QjNHTuBk6feHJnWTdIsw1p8YLAiFpZepS9BIIIcVl41f32m
IPd+OfNTeyQ2F9XmPJ/ukTP2/Pe3nrzH7o6698Iewkfn8C6ysM4nqgjxF1+t+hKp
JWEWhP0cVohnP1wVdGw2qPJ/+teiiAPM9TYSd37w9z5hkLEG7lvJg0e5Jt+IW2o/
rxPQYJ+YvdgzE4wneB7Y+Pxnyj0eDzdcivGi/SpRdn8=
`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
RND46uoP8CpmxPvJbTjxpotl/NyZwJ5gv2GpnuBxkAM/nG7KWNOwd1bGqYk+1RFF
mKDzPPMWbJkky+bLz9IVQbxOKMym/tLrh+bcdiYUhmdMlwXMIZsLX3xcx1sWP1o2
x+JIqLThGmjVafUYq2ewK25hN1p9MUZ/Jq0KzNUpG4w5OXP5kfHlED7TTyr2hut+
qXQBP34sBmlFSqja5PZcRvXumpKIrvtLfmpCSobCbsTFpFYo+wbtLU31f/40W46R
f6WLkJiu4cZ0Kro4kQJ9L7XXY8U+UdV+dGmogolStQRc+AWdRyiv/s2FuPEFaK8+
QFkhQlzFNr63C0jDTrPuIg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 9936 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
EALB2H01cFtIqeJt8r8whJ7LUX+B3ezaPSgkqI67C3LBEMowWSZR4DWP1oBnJlgq
iZ3lmHZrq561/fFB5MCLmskJv08fQCHVDG6dzyIs4IuLZRSjgR4oVgBuTw3kDWqq
O2NdbaF+Lu04bDu5IX19SoB6zNer3izs0XyfHqT43yp60i4MpDPxBZ3Xvx43wYbp
9StsRjDmzAeS+pZ/YymoftBTYiUOycYjHFL1udPzyMC33/E7bqwK8Lnf/v6UVGHA
kvokIbywVehBxAxVk+Sj54Pfufj8ykSvnPrghrRnMsGvwLJX74vwmpVcumZH/ack
EejRlZxYrgtdmHQkmqAWWg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 9504 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
EZ8Rp7OmCbHh6RScDMKr5OWzjdUQ6KhdtVwi1rAJw9KmrCGlARwTyNqbmfaen5W6
jyghGu/MdDul+jrEqPtKz8aJnfJZqIQXU+TzaS/CTMZuNVtvAZrUemwjl1pLu+fp
m6E/h9SW/Qyv5sFyuWTuCJrD38AT/KdmEHIS+vGIeOGhogkpdQBPwxiJZFX9Wfz8
EElcnaf/YsIA5Xc12fS5sB3u/WwLLTDoWNNjHkDoB99TeQWoQ3LHLEE8Hl2AExhA
5lFDXh5m0HGf42OJirwBM6v2WvUCGeF40ckmKLamdjCqRLYKOqjPo6SGU0+Rg0yK
EqeI0KpkzrUuNG4yaFLU9Q==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 944 )
`pragma protect data_block
/zjslOHKwAuKU3j6iVTCd9BnqwrISSv3TJYUc1XPm8VZOf7NCVkmflDQ7RByBN8l
G47+p3B+uR6BdnpKcDNo6XBiAopsvcmbKhAAbOyCTZavzPmnLrWYjnBCLAvBExxx
lh8p1mOFs2ibExrq/uVEMhGp3VEGjsCo1i8+h4bky9jI2EvLRqd3y8wO88htwJS2
F+Lgt61zT8sp/k+J14WkDj2Y35GA8oVYBvO28jMdgs0/m6/WOHHhe2fjO6A5T53J
whJur+K44Os1kdsYaqdcW8Gfxn0Nhbqh2BA8IwdJQhwJ+XDRkYK3aquVbJI+6wQL
C7/btkBdbK6T3/Is0HG/PENEKK4mbtkSKAkbVX5J3hhdvRfvqTjvos3GelNZ136Q
9mX+c9tiT93GpofvVI5QDPb55Nao74j5/WQAjFb/pvKqWiAon4T6yNs++WfCnLzv
4uLUEfunO3sVA4eildqT6n77jXQv52fY9e7wECZJLBPCsinS/ewVWZO3TVA3fmNt
JkzB0jcs9W1tEydc6HXv63mcm5PiiS/oWZLf0G2mYgxHZOp8BwxJ+MyvlukUzH5k
3yOu39Wnh0nWYq3kNBI/rOkYytPAhvbyLJnAvzlfx2EbQ52LeS0v2hVb1wNG17Pd
YIb1FjXag8XwgOgSwagadufJrZNvMm/pMncbPMjgyNsCQ80jjy1pm4OiqxlriJ8d
1sJTGONQ9iiaRu07kvxIHYghYtDvnULZptKrqrbPP2nXdYR0SqOSqYnVMkA/+YNB
nyWGaRwOJIdmsO7pLWDBzwuVtjx9uUqer4ZZypIuo9tJOKpvc+JfKswyRKKi082V
jaY38Ncl6ni+PmV9u0PR6vIXQk7ltzl62iXQuZOCDTZMDRMTTXEtvyRvGZhPFFmd
02g5STQ+64sblnrWJvIv2bgu/FlKYqqf8/ahDJ9oRp3LtGCbEtHqi0bxPUC/4w3z
vJut7/xxmMIvFDfjRgybdMSR8orjUgK23U7dwlkNI832aYWF8MJDFLjqLpEH9JMD
GLKqgdsRMsYWm370m47M9r7zp4/3BIXxn9KCpQvNuLMgqxNRagGQsdjv7yhDkbw6
dJYDyeJeYVXXjolwBMsyq0tY7OLyrWAGCeQxVWq5ubKTnJ2pj9F4dpliNUvD7LEo
UTEooteA0/vNE+9UcyFbyrFqrSp7bWac0e3ePOWue2mMR0imkYZl8OlZhPhadHOn
s3QPDI+WJ1jLkYIWJoBDlqb0DV+9ruksKoG/Ly3Jqgc=
`pragma protect end_protected

//pragma protect end
`undef IP_UUID
`undef IP_NAME_CONCAT
`undef IP_MODULE_NAME
