module top #(
	//TX parameters
    parameter tINIT_NS = 100000,
    parameter tINIT_SKEWCAL_NS = 400000,
    parameter ENABLE_INIT_SKEWCAL = 1,  
    parameter ENABLE_EOTP = 0,
    parameter NUM_DATA_LANE = 4,
    parameter HS_BYTECLK_MHZ = 156, 
    parameter DPHY_CLOCK_MODE = "Continuous",
    parameter PACK_TYPE = 4'b1111,
    parameter ENABLE_V_LPM_BTA = 0,
    parameter PACKET_SEQUENCES = 1,
    parameter HS_CMD_WDATAFIFO_DEPTH = 64,
    parameter LP_CMD_WDATAFIFO_DEPTH = 64,
    parameter LP_CMD_RDATAFIFO_DEPTH = 64,
    parameter HS_LANE_FIFO_DEPTH = 512,
    parameter HS_DATA_WIDTH = 16,
    parameter ASYNC_STAGE = 2,
    parameter PIXEL_FIFO_DEPTH = 2048,

	//RX parameters
    parameter CLOCK_FREQ_MHZ = 100,
 //   parameter AREGISTER = 2,
    parameter HS_CMD_FIFO_DEPTH = 64,
    parameter LP_CMD_FIFO_DEPTH = 64,
	
    // Video parameters
    parameter MAX_HRES  = 1920  ,
    parameter MAX_VRES  = 1080  ,
    parameter HSP       = 100   ,
    parameter HBP       = 100   ,
    parameter HFP       = 250   ,
    parameter VSP       = 3     ,    
    parameter VBP       = 5     ,
    parameter VFP       = 6

)(
//`default_nettype none
    ////////////////////////    CLOCK & PLL     ////////////////////////
    
//    input       dbg_clk,       // for debug/signal tap purpose.. 
    input       i_fb_clk,      // for axi config.
    input       i_sysclk,      // for pixel clk = 2.5G * 4 / 48 = 208.333MHz
    input       dphy_byte_clk, // for parallel/byte clock = 2.5G / 16*2 = 312.5MHz

    output      pll_mipi_rstn,
    output      pll_byteclk_rstn,

    input       i_pll1_locked,
    input       i_pll2_locked,  
    ////////////////////////    USER CONTROL    ///////////////////
    output[3:0] led,
    input       i_arstn,
    output      o_lcd_rstn,
    input	    i_inject_err,

    ///---- MIPI blocks related clocks   ----///
    input  logic         mipi_dphy_tx_pclk,      //MIPI HS byte clock from MIPI block 
//    input  logic         RxClkEsc,   
    input  logic         esc_clk,   //20Mhz
    
    ///---- MIPI blocks control signals   ----///
    input   logic        mipi_dphy_tx_inst1_PLL_UNLOCK,
    output  logic        mipi_dphy_tx_inst1_RESET_N,
    output  logic        mipi_dphy_tx_inst1_PLL_SSC_EN, 

    ///---- Clock Lane   ----///
    input   logic        mipi_dphy_tx_inst1_STOPSTATE_CLK,
    output  logic        mipi_dphy_tx_inst1_TX_REQUEST_HS,
    output  logic        mipi_dphy_tx_inst1_TX_ULPS_CLK,
    output  logic        mipi_dphy_tx_inst1_TX_ULPS_EXIT,
    input   logic        mipi_dphy_tx_inst1_TX_ULPS_ACTIVE_CLK_NOT,

    ///---- Data Lane ULPS ----///
    output  logic        mipi_dphy_tx_inst1_TX_ULPS_ESC_LAN0,
    output  logic        mipi_dphy_tx_inst1_TX_ULPS_ESC_LAN1,
    output  logic        mipi_dphy_tx_inst1_TX_ULPS_ESC_LAN2,
    output  logic        mipi_dphy_tx_inst1_TX_ULPS_ESC_LAN3,
    output  logic        mipi_dphy_tx_inst1_TX_ULPS_EXIT_LAN0,
    output  logic        mipi_dphy_tx_inst1_TX_ULPS_EXIT_LAN1,
    output  logic        mipi_dphy_tx_inst1_TX_ULPS_EXIT_LAN2,
    output  logic        mipi_dphy_tx_inst1_TX_ULPS_EXIT_LAN3,
    input   logic        mipi_dphy_tx_inst1_TX_ULPS_ACTIVE_NOT_LAN0,
    input   logic        mipi_dphy_tx_inst1_TX_ULPS_ACTIVE_NOT_LAN1,
    input   logic        mipi_dphy_tx_inst1_TX_ULPS_ACTIVE_NOT_LAN2,
    input   logic        mipi_dphy_tx_inst1_TX_ULPS_ACTIVE_NOT_LAN3,

    ///---- Data Lane LP mode   ----///
    output  logic        mipi_dphy_tx_inst1_TX_REQUEST_ESC_LAN0,
    output  logic        mipi_dphy_tx_inst1_TX_REQUEST_ESC_LAN1,
    output  logic        mipi_dphy_tx_inst1_TX_REQUEST_ESC_LAN2,
    output  logic        mipi_dphy_tx_inst1_TX_REQUEST_ESC_LAN3,
    input   logic        mipi_dphy_tx_inst1_STOPSTATE_LAN0,
    input   logic        mipi_dphy_tx_inst1_STOPSTATE_LAN1,
    input   logic        mipi_dphy_tx_inst1_STOPSTATE_LAN2,
    input   logic        mipi_dphy_tx_inst1_STOPSTATE_LAN3,

    ///---- Data Lane HS mode   ----///
    output  logic        mipi_dphy_tx_inst1_TX_SKEW_CAL_HS_LAN0,
    output  logic        mipi_dphy_tx_inst1_TX_SKEW_CAL_HS_LAN1,
    output  logic        mipi_dphy_tx_inst1_TX_SKEW_CAL_HS_LAN2,
    output  logic        mipi_dphy_tx_inst1_TX_SKEW_CAL_HS_LAN3,
    input   logic        mipi_dphy_tx_inst1_TX_READY_HS_LAN0,
    input   logic        mipi_dphy_tx_inst1_TX_READY_HS_LAN1,
    input   logic        mipi_dphy_tx_inst1_TX_READY_HS_LAN2,
    input   logic        mipi_dphy_tx_inst1_TX_READY_HS_LAN3,
    output  logic        mipi_dphy_tx_inst1_TX_REQUEST_HS_LAN0,
    output  logic        mipi_dphy_tx_inst1_TX_REQUEST_HS_LAN1,
    output  logic        mipi_dphy_tx_inst1_TX_REQUEST_HS_LAN2,
    output  logic        mipi_dphy_tx_inst1_TX_REQUEST_HS_LAN3,
    output  logic [15:0] mipi_dphy_tx_inst1_TX_DATA_HS_LAN0,
    output  logic [15:0] mipi_dphy_tx_inst1_TX_DATA_HS_LAN1,
    output  logic [15:0] mipi_dphy_tx_inst1_TX_DATA_HS_LAN2,
    output  logic [15:0] mipi_dphy_tx_inst1_TX_DATA_HS_LAN3,
    output  logic        mipi_dphy_tx_inst1_TX_WORD_VALID_HS_LAN0,
    output  logic        mipi_dphy_tx_inst1_TX_WORD_VALID_HS_LAN1,
    output  logic        mipi_dphy_tx_inst1_TX_WORD_VALID_HS_LAN2,
    output  logic        mipi_dphy_tx_inst1_TX_WORD_VALID_HS_LAN3,

    ///---- Data Lane 0 Escape mode LPDT   ----///
    output logic         mipi_dphy_tx_inst1_TX_VALID_ESC, 
    output logic [7:0]   mipi_dphy_tx_inst1_TX_DATA_ESC,
    output logic         mipi_dphy_tx_inst1_TX_LPDT_ESC,
    input  logic         mipi_dphy_tx_inst1_TX_READY_ESC,
    
    ///---- Data Lane 0 Escape mode Trigger and Turnaround   ----///
    output logic         mipi_dphy_tx_inst1_TURN_REQUEST,
    output logic [3:0]   mipi_dphy_tx_inst1_TX_TRIGGER_ESC,
    output logic         mipi_dphy_tx_inst1_FORCE_RX_MODE,
    input  logic         mipi_dphy_tx_inst1_DIRECTION,
    input  logic [3:0]   mipi_dphy_tx_inst1_RX_TRIGGER_ESC,
    input  logic         mipi_dphy_tx_inst1_RX_LPDT_ESC,
    input  logic         mipi_dphy_tx_inst1_RX_VALID_ESC,
    input  logic [7:0]   mipi_dphy_tx_inst1_RX_DATA_ESC,
    input  logic         mipi_dphy_tx_inst1_RX_ULPS_ESC,
    input  logic         mipi_dphy_tx_inst1_ERR_CONTROL,
    input  logic         mipi_dphy_tx_inst1_ERR_ESC,
    input  logic         mipi_dphy_tx_inst1_ERR_CONTENTION_LP0,
    input  logic         mipi_dphy_tx_inst1_ERR_CONTENTION_LP1,
    input  logic         mipi_dphy_tx_inst1_ERR_SYNC_ESC,
    
    //mipi dphy rx
  input mipi_dphy_rx_inst2_ERR_CONTENTION_LP0,
  input mipi_dphy_rx_inst2_ERR_CONTENTION_LP1,
  input mipi_dphy_rx_inst2_ERR_CONTROL_LAN0,
  input mipi_dphy_rx_inst2_ERR_CONTROL_LAN1,
  input mipi_dphy_rx_inst2_ERR_CONTROL_LAN2,
  input mipi_dphy_rx_inst2_ERR_CONTROL_LAN3,
  input mipi_dphy_rx_inst2_ERR_ESC_LAN0,
  input mipi_dphy_rx_inst2_ERR_ESC_LAN1,
  input mipi_dphy_rx_inst2_ERR_ESC_LAN2,
  input mipi_dphy_rx_inst2_ERR_ESC_LAN3,
  input mipi_dphy_rx_inst2_ERR_SOT_HS_LAN0,
  input mipi_dphy_rx_inst2_ERR_SOT_HS_LAN1,
  input mipi_dphy_rx_inst2_ERR_SOT_HS_LAN2,
  input mipi_dphy_rx_inst2_ERR_SOT_HS_LAN3,
  input mipi_dphy_rx_inst2_ERR_SOT_SYNC_HS_LAN0,
  input mipi_dphy_rx_inst2_ERR_SOT_SYNC_HS_LAN1,
  input mipi_dphy_rx_inst2_ERR_SOT_SYNC_HS_LAN2,
  input mipi_dphy_rx_inst2_ERR_SOT_SYNC_HS_LAN3,
  input mipi_dphy_rx_inst2_LP_CLK,
  input mipi_dphy_rx_inst2_RX_ACTIVE_HS_LAN0,
  input mipi_dphy_rx_inst2_RX_ACTIVE_HS_LAN1,
  input mipi_dphy_rx_inst2_RX_ACTIVE_HS_LAN2,
  input mipi_dphy_rx_inst2_RX_ACTIVE_HS_LAN3,
  input mipi_dphy_rx_inst2_RX_CLK_ACTIVE_HS,
  input [7:0] mipi_dphy_rx_inst2_RX_DATA_ESC,
  
  input [15:0] mipi_dphy_rx_inst2_RX_DATA_HS_LAN0,
  input [15:0] mipi_dphy_rx_inst2_RX_DATA_HS_LAN1,
  input [15:0] mipi_dphy_rx_inst2_RX_DATA_HS_LAN2,
  input [15:0] mipi_dphy_rx_inst2_RX_DATA_HS_LAN3,
  
  input mipi_dphy_rx_inst2_RX_LPDT_ESC,
  input mipi_dphy_rx_inst2_RX_SKEW_CAL_HS_LAN0,
  input mipi_dphy_rx_inst2_RX_SKEW_CAL_HS_LAN1,
  input mipi_dphy_rx_inst2_RX_SKEW_CAL_HS_LAN2,
  input mipi_dphy_rx_inst2_RX_SKEW_CAL_HS_LAN3,
  input mipi_dphy_rx_inst2_RX_SYNC_HS_LAN0,
  input mipi_dphy_rx_inst2_RX_SYNC_HS_LAN1,
  input mipi_dphy_rx_inst2_RX_SYNC_HS_LAN2,
  input mipi_dphy_rx_inst2_RX_SYNC_HS_LAN3,
  input [3:0] mipi_dphy_rx_inst2_RX_TRIGGER_ESC,
  input mipi_dphy_rx_inst2_RX_ULPS_ACTIVE_CLK_NOT,
  input mipi_dphy_rx_inst2_RX_ULPS_ACTIVE_NOT_LAN0,
  input mipi_dphy_rx_inst2_RX_ULPS_ACTIVE_NOT_LAN1,
  input mipi_dphy_rx_inst2_RX_ULPS_ACTIVE_NOT_LAN2,
  input mipi_dphy_rx_inst2_RX_ULPS_ACTIVE_NOT_LAN3,
  input mipi_dphy_rx_inst2_RX_ULPS_CLK_NOT,
  input mipi_dphy_rx_inst2_RX_ULPS_ESC_LAN0,
  input mipi_dphy_rx_inst2_RX_ULPS_ESC_LAN1,
  input mipi_dphy_rx_inst2_RX_ULPS_ESC_LAN2,
  input mipi_dphy_rx_inst2_RX_ULPS_ESC_LAN3,
  input mipi_dphy_rx_inst2_RX_VALID_ESC,
  input mipi_dphy_rx_inst2_RX_VALID_HS_LAN0,
  input mipi_dphy_rx_inst2_RX_VALID_HS_LAN1,
  input mipi_dphy_rx_inst2_RX_VALID_HS_LAN2,
  input mipi_dphy_rx_inst2_RX_VALID_HS_LAN3,
  input mipi_dphy_rx_inst2_STOPSTATE_CLK,
  input mipi_dphy_rx_inst2_STOPSTATE_LAN0,
  input mipi_dphy_rx_inst2_STOPSTATE_LAN1,
  input mipi_dphy_rx_inst2_STOPSTATE_LAN2,
  input mipi_dphy_rx_inst2_STOPSTATE_LAN3,
  input clk_25m,
  input mipi_refclk_ch0,
  input mipi_refclk_ch1,
  input mipi_refclk_ch2,
  input mipi_refclk_ch3,
  output mipi_dphy_rx_inst2_FORCE_RX_MODE,
  output mipi_dphy_rx_inst2_RESET_N,
  output mipi_dphy_rx_inst2_RST0_N,
 
  input mipi_rx_cfg_clk, 
  input mipi_dphy_rx_inst2_byte_clk,
  input clk_50m,
  output clk_25M_OUT_HI,
  output clk_25M_OUT_LO,
  output clk_25M_OE,
  input clk_25M_IN
 



);
assign clk_25M_OE = 1'b1;
assign clk_25M_OUT_HI = 1;
assign clk_25M_OUT_LO = 0;

////////////////////////////////////////////////////////////////
// DSI Tx AXI
logic [31:0]    w_axi_rdata;
logic           w_axi_awready;
logic           w_axi_wready;
logic           w_axi_arready;
logic           w_axi_rvalid;
logic           w_axi_bvalid;

logic [6:0]	    w_axi_awaddr;
logic           w_axi_awvalid;
logic [31:0]    w_axi_wdata;
logic           w_axi_wvalid;
logic           w_axi_bready;
logic [6:0]	    w_axi_araddr;
logic           w_axi_arvalid;
logic           w_axi_rready;

////---- unused signals  ----////
assign mipi_dphy_tx_inst1_PLL_SSC_EN = 0;



assign pll_mipi_rstn        = i_arstn;
assign pll_byteclk_rstn     = i_arstn;
assign o_lcd_rstn           = w_lcd_rstn;

logic w_hsync_match;
logic w_vsync_match;
logic w_pdata_match;

assign led[0]     = w_frame_cnt[5];
assign led[1]     = w_hsync_match;
assign led[2]     = w_vsync_match;
assign led[3]     = w_pdata_match;

////////////////////////////////////////////////////////////////
//==============================================================
assign mipi_dphy_rx_inst2_FORCE_RX_MODE = 1'b1;
assign mipi_dphy_rx_inst2_RESET_N = i_arstn;
assign mipi_dphy_rx_inst2_RST0_N = i_arstn;

////////////////////////////////////////////////////////////////
/// glue logic for color bar display example design
logic        w_pll_locked;
logic        w_global_rstn;
logic        w_lcd_rstn;
logic        w_pixel_rstn;
logic [8:0]  w_frame_cnt;

logic        w_fb_clk_arstn;
logic        w_fb_clk_arst;
logic        w_dphy_byte_clk_arstn;
logic        w_dphy_byte_clk_arst;
logic        w_rx_byte_clk_arstn;
logic        w_rx_byte_clk_arst;

logic        w_vsync;
logic        w_hsync;
logic        w_valid;
logic [9:0] w_out_x;
logic [9:0] w_out_y;

assign w_pll_locked  = i_pll1_locked & i_pll2_locked;
assign o_LED17_B     = w_frame_cnt[5];

reset_ctrl #(
    .NUM_RST       (6),
    .CYCLE         (4),
    .IN_RST_ACTIVE (6'b0000),
    .OUT_RST_ACTIVE(6'b1010)
) inst_reset_ctrl (
    .i_arst({6{w_global_rstn}}),
    .i_clk({
        {2{i_fb_clk}}, {2{dphy_byte_clk}}, {2{dphy_byte_clk}}
    }),
    .o_srst({
        w_fb_clk_arst,
        w_fb_clk_arstn,
        w_rx_byte_clk_arst,
        w_rx_byte_clk_arstn,
        w_dphy_byte_clk_arst,
        w_dphy_byte_clk_arstn
    })
);

wire [63:0] w_data_mask;
wire [5:0]  video_format;

////////// testcase specific /////////////////////////////////////////////
localparam PixelPerClock = 3'd2;
assign video_format  = 6'h3E; ///RGB888
assign w_data_mask   = { {16{1'h0}},{48{1'h1}} }; // RGB888: pack type 48.
//assign video_format  = 6'h2E; ///RGB666
//assign w_data_mask   = { {16{1'h0}},{2{{6{1'h0}}, {18{1'h1}}}} }; // RGB666: pack type 48.


//////////////////////////////////////////////////////////////////////////

// logic to handle the init timing of dphy 10us.
localparam MIPI_CLK_MHZ = CLOCK_FREQ_MHZ; // leverage on esc_clk
localparam integer MIPI_CLK_NS = 1000/(MIPI_CLK_MHZ);
localparam integer INIT_CYCLE = ((tINIT_NS / MIPI_CLK_NS) + (tINIT_SKEWCAL_NS / MIPI_CLK_NS)) ; // for init+skew.

logic [31:0] w_init_cnt;
logic w_init_done;

always @ (posedge mipi_rx_cfg_clk or negedge w_global_rstn) begin
    if (~w_global_rstn) begin
        w_init_cnt    <= 'd0;
    end
    else if (w_init_cnt < INIT_CYCLE) begin
        w_init_cnt    <= w_init_cnt + 'd1;
    end
end

assign w_init_done = (w_init_cnt == INIT_CYCLE);

dsichk #(
    .MAX_HRES       (MAX_HRES),
    .MAX_VRES       (MAX_VRES),
    .HSP            (HSP     ),
    .HBP            (HBP     ),
    .HFP            (HFP     ),
    .VSP            (VSP     ),
    .VBP            (VBP     ),
    .VFP            (VFP     ),
    .PixelPerClock  (PixelPerClock)
) dsichk_inst (
    .i_arstn        (i_arstn        ),
    .pll_locked     (w_pll_locked   ),
    .o_pixel_rstn   (w_pixel_rstn   ),
    .o_global_rstn  (w_global_rstn  ),
    
    .i_fb_clk       (i_fb_clk       ),
    .i_sysclk       (i_sysclk       ),
    
    .o_vsync        (w_vsync        ),
    .o_hsync        (w_hsync        ),
    .o_valid        (w_valid        ),
    .o_out_x        (w_out_x        ),
    .o_out_y        (w_out_y        ),
    .i_data_mask    (w_data_mask    ),

    .i_inject_err1  (i_inject_err   ),
    .i_inject_err2  (1'b1           ),
    .o_hsync_match  (w_hsync_match  ),
    .o_vsync_match  (w_vsync_match  ),
    .o_pdata_match  (w_pdata_match  ),
    .o_frame_cnt    (w_frame_cnt    ),
    
    .i_vsync        (vsync          ),
    .i_hsync        (hsync          ),                 
    .i_valid        (pixel_data_valid),                 
    .i_pdata        (pixel_data     ), 

    .i_init_done    (w_init_done    ),
    
    .i_axi_awready  (w_axi_awready  ),
    .i_axi_wready   (w_axi_wready   ),
    .i_axi_bvalid   (w_axi_bvalid   ),
    .o_axi_awaddr   (w_axi_awaddr   ),
    .o_axi_awvalid  (w_axi_awvalid  ),
    .o_axi_wdata    (w_axi_wdata    ),
    .o_axi_wvalid   (w_axi_wvalid   ),
    .o_axi_bready   (w_axi_bready   ),
    
    .i_axi_arready  (w_axi_arready  ),
    .i_axi_rdata    (w_axi_rdata    ),
    .i_axi_rvalid   (w_axi_rvalid   ),
    .o_axi_araddr   (w_axi_araddr   ),
    .o_axi_arvalid  (w_axi_arvalid  ),
    .o_axi_rready   (w_axi_rready   )
);


// Mapping to DPHY TX
logic                       TxUlpsClk;
logic                       TxUlpsExitClk;
logic [NUM_DATA_LANE-1:0]   TxUlpsEsc;
logic [NUM_DATA_LANE-1:0]   TxUlpsExit;
logic [NUM_DATA_LANE-1:0]   TxRequestEsc;
logic [NUM_DATA_LANE-1:0]   TxSkewCalHS;
logic [NUM_DATA_LANE-1:0]   TxRequestHS;
logic                       TxRequestHSc;
logic [15:0]                TxDataHS0;
logic [15:0]                TxDataHS1;
logic [15:0]                TxDataHS2;
logic [15:0]                TxDataHS3;
logic [1:0]                 TxReqValidHS0;
logic [1:0]                 TxReqValidHS1;
logic [1:0]                 TxReqValidHS2;
logic [1:0]                 TxReqValidHS3;
logic                       TxUlpsActiveClkNot;
logic [NUM_DATA_LANE-1:0]   TxStopStateD;
logic                       TxStopStateC;
logic [NUM_DATA_LANE-1:0]   TxUlpsActiveNot;
logic [NUM_DATA_LANE-1:0]   TxReadyHS;
logic                       TurnRequest;
logic                       TxValidEsc;
logic                       TxLpdtEsc;
logic                       TxReadyEsc;
logic [3:0]                 TxTriggerEsc;
logic                       RxLPDTEsc;
logic                       RxValidEsc;
logic [7:0]                 RxDataEsc;
logic [7:0]                 TxDataEsc_0;


// Mapping to DSI RX
logic           hsync;
logic           vsync;
logic [1:0]     vc;
logic [15:0]    word_count;
logic [63:0]    pixel_data;
logic  	        pixel_data_valid;
logic [5:0]     datatype;


// assign mipi_dphy_tx_inst1_ESC_CLK = esc_clk;
assign mipi_dphy_tx_inst1_RESET_N = i_arstn;
assign mipi_dphy_tx_inst1_TX_ULPS_CLK = TxUlpsClk;
assign mipi_dphy_tx_inst1_TX_ULPS_EXIT = TxUlpsExitClk;
assign TxUlpsActiveClkNot = mipi_dphy_tx_inst1_TX_ULPS_ACTIVE_CLK_NOT;
assign mipi_dphy_tx_inst1_TX_ULPS_ESC_LAN0 = TxUlpsEsc[0];
assign mipi_dphy_tx_inst1_TX_ULPS_ESC_LAN1 = TxUlpsEsc[1];
assign mipi_dphy_tx_inst1_TX_ULPS_ESC_LAN2 = TxUlpsEsc[2];
assign mipi_dphy_tx_inst1_TX_ULPS_ESC_LAN3 = TxUlpsEsc[3];
assign mipi_dphy_tx_inst1_TX_ULPS_EXIT_LAN0 = TxUlpsExit[0];
assign mipi_dphy_tx_inst1_TX_ULPS_EXIT_LAN1 = TxUlpsExit[1];
assign mipi_dphy_tx_inst1_TX_ULPS_EXIT_LAN2 = TxUlpsExit[2];
assign mipi_dphy_tx_inst1_TX_ULPS_EXIT_LAN3 = TxUlpsExit[3];
assign mipi_dphy_tx_inst1_TX_REQUEST_ESC_LAN0 = TxRequestEsc[0];
assign mipi_dphy_tx_inst1_TX_REQUEST_ESC_LAN1 = TxRequestEsc[1];
assign mipi_dphy_tx_inst1_TX_REQUEST_ESC_LAN2 = TxRequestEsc[2];
assign mipi_dphy_tx_inst1_TX_REQUEST_ESC_LAN3 = TxRequestEsc[3];
assign mipi_dphy_tx_inst1_TX_SKEW_CAL_HS_LAN0 = TxSkewCalHS[0];
assign mipi_dphy_tx_inst1_TX_SKEW_CAL_HS_LAN1 = TxSkewCalHS[1];
assign mipi_dphy_tx_inst1_TX_SKEW_CAL_HS_LAN2 = TxSkewCalHS[2];
assign mipi_dphy_tx_inst1_TX_SKEW_CAL_HS_LAN3 = TxSkewCalHS[3];
assign TxStopStateD[0] = mipi_dphy_tx_inst1_STOPSTATE_LAN0;
assign TxStopStateD[1] = mipi_dphy_tx_inst1_STOPSTATE_LAN1;
assign TxStopStateD[2] = mipi_dphy_tx_inst1_STOPSTATE_LAN2;
assign TxStopStateD[3] = mipi_dphy_tx_inst1_STOPSTATE_LAN3;
assign TxStopStateC = mipi_dphy_tx_inst1_STOPSTATE_CLK;
assign TxUlpsActiveNot[0] = mipi_dphy_tx_inst1_TX_ULPS_ACTIVE_NOT_LAN0;
assign TxUlpsActiveNot[1] = mipi_dphy_tx_inst1_TX_ULPS_ACTIVE_NOT_LAN1;
assign TxUlpsActiveNot[2] = mipi_dphy_tx_inst1_TX_ULPS_ACTIVE_NOT_LAN2;
assign TxUlpsActiveNot[3] = mipi_dphy_tx_inst1_TX_ULPS_ACTIVE_NOT_LAN3;
assign TxReadyHS[0] = mipi_dphy_tx_inst1_TX_READY_HS_LAN0;
assign TxReadyHS[1] = mipi_dphy_tx_inst1_TX_READY_HS_LAN1;
assign TxReadyHS[2] = mipi_dphy_tx_inst1_TX_READY_HS_LAN2;
assign TxReadyHS[3] = mipi_dphy_tx_inst1_TX_READY_HS_LAN3;
assign mipi_dphy_tx_inst1_TX_REQUEST_HS = TxRequestHSc;
assign mipi_dphy_tx_inst1_TX_DATA_HS_LAN0 = TxDataHS0;
assign mipi_dphy_tx_inst1_TX_DATA_HS_LAN1 = TxDataHS1;
assign mipi_dphy_tx_inst1_TX_DATA_HS_LAN2 = TxDataHS2;
assign mipi_dphy_tx_inst1_TX_DATA_HS_LAN3 = TxDataHS3;
assign mipi_dphy_tx_inst1_TX_REQUEST_HS_LAN0 = TxRequestHS[0];
assign mipi_dphy_tx_inst1_TX_REQUEST_HS_LAN1 = TxRequestHS[1];
assign mipi_dphy_tx_inst1_TX_REQUEST_HS_LAN2 = TxRequestHS[2];
assign mipi_dphy_tx_inst1_TX_REQUEST_HS_LAN3 = TxRequestHS[3];
assign mipi_dphy_tx_inst1_TX_WORD_VALID_HS_LAN0 = TxReqValidHS0[1];
assign mipi_dphy_tx_inst1_TX_WORD_VALID_HS_LAN1 = TxReqValidHS1[1];
assign mipi_dphy_tx_inst1_TX_WORD_VALID_HS_LAN2 = TxReqValidHS2[1];
assign mipi_dphy_tx_inst1_TX_WORD_VALID_HS_LAN3 = TxReqValidHS3[1];

assign mipi_dphy_tx_inst1_TURN_REQUEST = TurnRequest;
assign RxLPDTEsc = mipi_dphy_tx_inst1_RX_LPDT_ESC;
assign RxValidEsc = mipi_dphy_tx_inst1_RX_VALID_ESC;
assign RxDataEsc = mipi_dphy_tx_inst1_RX_DATA_ESC;
assign mipi_dphy_tx_inst1_TX_TRIGGER_ESC = TxTriggerEsc;
assign mipi_dphy_tx_inst1_TX_VALID_ESC = TxValidEsc;
assign mipi_dphy_tx_inst1_TX_DATA_ESC = TxDataEsc_0;
assign mipi_dphy_tx_inst1_TX_LPDT_ESC = TxLpdtEsc;
assign TxReadyEsc = mipi_dphy_tx_inst1_TX_READY_ESC;

efx_dsi_tx_top 
// #(
//     .tINIT_NS               (tINIT_NS               ),
//     .tINIT_SKEWCAL_NS       (tINIT_SKEWCAL_NS       ),
//     .ENABLE_INIT_SKEWCAL    (ENABLE_INIT_SKEWCAL    ),
//     .ENABLE_EOTP            (ENABLE_EOTP            ),
//     .NUM_DATA_LANE          (NUM_DATA_LANE          ),
//     .HS_BYTECLK_MHZ         (HS_BYTECLK_MHZ         ),
//     .DPHY_CLOCK_MODE        (DPHY_CLOCK_MODE        ),
//     .PACK_TYPE              (PACK_TYPE              ),
//     .ENABLE_V_LPM_BTA       (ENABLE_V_LPM_BTA       ),
//     .PACKET_SEQUENCES       (PACKET_SEQUENCES       ),
// 
//     .HS_CMD_WDATAFIFO_DEPTH (HS_CMD_WDATAFIFO_DEPTH ),
//     .LP_CMD_WDATAFIFO_DEPTH (LP_CMD_WDATAFIFO_DEPTH ),
//     .LP_CMD_RDATAFIFO_DEPTH (LP_CMD_RDATAFIFO_DEPTH ),
//     .HS_LANE_FIFO_DEPTH     (HS_LANE_FIFO_DEPTH     ),
//     .HS_DATA_WIDTH          (HS_DATA_WIDTH          ),
//     .ASYNC_STAGE            (ASYNC_STAGE            ),
//     .MAX_HRES               (MAX_HRES               ),
//     .PIXEL_FIFO_DEPTH       (PIXEL_FIFO_DEPTH       )
// ) 
efx_dsi_tx_top_inst (
    .clk_byte_HS        (dphy_byte_clk          ),
    .clk_pixel          (i_sysclk               ),
    .phy_clk_byte_HS    (mipi_dphy_tx_pclk      ),
    .clk_esc            (esc_clk                ),
    .reset_byte_HS_n    (w_dphy_byte_clk_arstn  ),
    .reset_pixel_n      (w_pixel_rstn           ),
    .reset_esc_n        (i_arstn                ),

    //PPI interface
    .TurnRequest        (TurnRequest),
    .TxRequestHSc       (TxRequestHSc),
    .TxUlpsClk          (TxUlpsClk),
    .TxUlpsExitClk      (TxUlpsExitClk),  
    .TxUlpsActiveClkNot (TxUlpsActiveClkNot),
    .TxStopStateC       (TxStopStateC),
    .TxRequestHS        (TxRequestHS),
    .TxDataHS_0         (TxDataHS0),
    .TxDataHS_1         (TxDataHS1),
    .TxDataHS_2         (TxDataHS2),
    .TxDataHS_3         (TxDataHS3),
    .TxReqValidHS0      (TxReqValidHS0),
    .TxReqValidHS1      (TxReqValidHS1),   
    .TxReqValidHS2      (TxReqValidHS2),
    .TxReqValidHS3      (TxReqValidHS3), 
    .TxReadyHS          (TxReadyHS),
    .TxSkewCalHS        (TxSkewCalHS),
    .TxRequestEsc       (TxRequestEsc), //
    .TxTriggerEsc       (TxTriggerEsc), //
    .TxStopStateD       (TxStopStateD),
    .TxUlpsExit         (TxUlpsExit),   //
    .TxUlpsActiveNot    (TxUlpsActiveNot),
    .TxUlpsEsc          (TxUlpsEsc),   // 
    .TxLpdtEsc          (TxLpdtEsc),
    .TxValidEsc         (TxValidEsc),
    .TxDataEsc_0        (TxDataEsc_0),
    .TxReadyEsc         (TxReadyEsc),  
    
    .RxClkEsc           (esc_clk),
    .RxDataEsc          (RxDataEsc),
    .RxLPDTEsc          (RxLPDTEsc),   
    .RxValidEsc         (RxValidEsc),

	//AXI4-Lite Interface
	.axi_clk		(i_fb_clk		), 
	.axi_reset_n	(w_global_rstn	),
	.axi_awaddr		(w_axi_awaddr	),//Write Address. byte address.
	.axi_awvalid	(w_axi_awvalid	),//Write address valid.
	.axi_awready	(w_axi_awready	),//Write address ready.
	.axi_wdata		(w_axi_wdata	),//Write data bus.
	.axi_wvalid		(w_axi_wvalid	),//Write valid.
	.axi_wready		(w_axi_wready	),//Write ready.
						  
	.axi_bvalid		(w_axi_bvalid	),//Write response valid.
	.axi_bready		(w_axi_bready	),//Response ready.      
	.axi_araddr		(w_axi_araddr	),//Read address. byte address.
	.axi_arvalid	(w_axi_arvalid	),//Read address valid.
	.axi_arready	(w_axi_arready	),//Read address ready.
	.axi_rdata		(w_axi_rdata	),//Read data.
	.axi_rvalid		(w_axi_rvalid	),//Read valid.
	.axi_rready		(w_axi_rready	),//Read ready.

    .hsync            (~w_hsync     ),
    .vsync            (~w_vsync     ),
    .vc               (2'b0         ),
    .datatype         (video_format ),
    .pixel_data       ({w_out_y[1:0],w_out_x[1:0],{3{w_out_y,w_out_x}}}),
    .pixel_data_valid (w_valid      ),
    .haddr            (MAX_HRES     ),
    .TurnRequest_dbg  (1'b0         ),
    .TurnRequest_done (             ),
    .irq              (             )
);


// Mapping to DPHY RX IF
logic RxUlpsClkNot;
logic [NUM_DATA_LANE-1:0]	RxErrEsc;
logic [NUM_DATA_LANE-1:0] 	RxErrControl;
logic [NUM_DATA_LANE-1:0] 	RxErrSotSyncHS;
// logic [NUM_DATA_LANE-1:0]	RxClkEsc;
logic [NUM_DATA_LANE-1:0]	RxUlpsEsc;
logic [NUM_DATA_LANE-1:0]	RxUlpsActiveNot;
logic [NUM_DATA_LANE-1:0]	RxSkewCalHS;
logic [NUM_DATA_LANE-1:0]	RxStopState;
logic [NUM_DATA_LANE-1:0] 	RxValidHS;
logic [NUM_DATA_LANE-1:0]  	RxSyncHS;
logic [NUM_DATA_LANE-1:0][15:0]	RxDataHS;

assign RxUlpsClkNot = mipi_dphy_rx_inst2_RX_ULPS_CLK_NOT;
assign RxUlpsActiveClkNot = mipi_dphy_rx_inst2_RX_ULPS_ACTIVE_CLK_NOT;
assign RxErrEsc[0] = mipi_dphy_rx_inst2_ERR_ESC_LAN0;
assign RxErrEsc[1] = mipi_dphy_rx_inst2_ERR_ESC_LAN1;
assign RxErrEsc[2] = mipi_dphy_rx_inst2_ERR_ESC_LAN2;
assign RxErrEsc[3] = mipi_dphy_rx_inst2_ERR_ESC_LAN3;
assign RxErrControl[0] = mipi_dphy_rx_inst2_ERR_CONTROL_LAN0;
assign RxErrControl[1] = mipi_dphy_rx_inst2_ERR_CONTROL_LAN1;
assign RxErrControl[2] = mipi_dphy_rx_inst2_ERR_CONTROL_LAN2;
assign RxErrControl[3] = mipi_dphy_rx_inst2_ERR_CONTROL_LAN3;
assign RxErrSotSyncHS[0] = mipi_dphy_rx_inst2_ERR_SOT_SYNC_HS_LAN0;
assign RxErrSotSyncHS[1] = mipi_dphy_rx_inst2_ERR_SOT_SYNC_HS_LAN1;
assign RxErrSotSyncHS[2] = mipi_dphy_rx_inst2_ERR_SOT_SYNC_HS_LAN2;
assign RxErrSotSyncHS[3] = mipi_dphy_rx_inst2_ERR_SOT_SYNC_HS_LAN3;
assign RxUlpsEsc[0] = mipi_dphy_rx_inst2_RX_ULPS_ESC_LAN0;
assign RxUlpsEsc[1] = mipi_dphy_rx_inst2_RX_ULPS_ESC_LAN1;
assign RxUlpsEsc[2] = mipi_dphy_rx_inst2_RX_ULPS_ESC_LAN2;
assign RxUlpsEsc[3] = mipi_dphy_rx_inst2_RX_ULPS_ESC_LAN3;
// assign RxClkEsc[0] = mipi_dphy_rx_inst2_ESC_LAN0_CLK;
// assign RxClkEsc[1] = mipi_dphy_rx_inst2_ESC_LAN1_CLK;
// assign RxClkEsc[2] = mipi_dphy_rx_inst2_ESC_LAN2_CLK;
// assign RxClkEsc[3] = mipi_dphy_rx_inst2_ESC_LAN3_CLK;
assign RxUlpsActiveNot[0] = mipi_dphy_rx_inst2_RX_ULPS_ACTIVE_NOT_LAN0;
assign RxUlpsActiveNot[1] = mipi_dphy_rx_inst2_RX_ULPS_ACTIVE_NOT_LAN1;
assign RxUlpsActiveNot[2] = mipi_dphy_rx_inst2_RX_ULPS_ACTIVE_NOT_LAN2;
assign RxUlpsActiveNot[3] = mipi_dphy_rx_inst2_RX_ULPS_ACTIVE_NOT_LAN3;
assign RxSkewCalHS[0] = mipi_dphy_rx_inst2_RX_SKEW_CAL_HS_LAN0;
assign RxSkewCalHS[1] = mipi_dphy_rx_inst2_RX_SKEW_CAL_HS_LAN1;
assign RxSkewCalHS[2] = mipi_dphy_rx_inst2_RX_SKEW_CAL_HS_LAN2;
assign RxSkewCalHS[3] = mipi_dphy_rx_inst2_RX_SKEW_CAL_HS_LAN3;
assign RxStopState[0] = mipi_dphy_rx_inst2_STOPSTATE_LAN0;
assign RxStopState[1] = mipi_dphy_rx_inst2_STOPSTATE_LAN1;
assign RxStopState[2] = mipi_dphy_rx_inst2_STOPSTATE_LAN2;
assign RxStopState[3] = mipi_dphy_rx_inst2_STOPSTATE_LAN3;
assign RxValidHS[0] = mipi_dphy_rx_inst2_RX_VALID_HS_LAN0;
assign RxValidHS[1] = mipi_dphy_rx_inst2_RX_VALID_HS_LAN1;
assign RxValidHS[2] = mipi_dphy_rx_inst2_RX_VALID_HS_LAN2;
assign RxValidHS[3] = mipi_dphy_rx_inst2_RX_VALID_HS_LAN3;
assign RxSyncHS[0] = mipi_dphy_rx_inst2_RX_SYNC_HS_LAN0;
assign RxSyncHS[1] = mipi_dphy_rx_inst2_RX_SYNC_HS_LAN1;
assign RxSyncHS[2] = mipi_dphy_rx_inst2_RX_SYNC_HS_LAN2;
assign RxSyncHS[3] = mipi_dphy_rx_inst2_RX_SYNC_HS_LAN3;
assign RxDataHS[0] = mipi_dphy_rx_inst2_RX_DATA_HS_LAN0;
assign RxDataHS[1] = mipi_dphy_rx_inst2_RX_DATA_HS_LAN1;
assign RxDataHS[2] = mipi_dphy_rx_inst2_RX_DATA_HS_LAN2;
assign RxDataHS[3] = mipi_dphy_rx_inst2_RX_DATA_HS_LAN3;

logic [31:0] w_rx_axi_rdata;
logic        w_rx_axi_awready;
logic        w_rx_axi_wready;
logic        w_rx_axi_arready;
logic        w_rx_axi_rvalid;
logic        w_rx_axi_bvalid;
logic [6:0]	 w_rx_axi_awaddr;
logic        w_rx_axi_awvalid;
logic [31:0] w_rx_axi_wdata;
logic        w_rx_axi_wvalid;
logic        w_rx_axi_bready;
logic [6:0]	 w_rx_axi_araddr;
logic        w_rx_axi_arvalid;
logic        w_rx_axi_rready;

// axi are not in used currently..
assign w_rx_axi_reset_n  = 1'h0;
assign w_rx_axi_awaddr   = 7'h0;
assign w_rx_axi_awvalid  = 1'h0;
assign w_rx_axi_wdata    = 32'h0;
assign w_rx_axi_wvalid   = 1'h0;
assign w_rx_axi_bready   = 1'h0;
assign w_rx_axi_araddr   = 1'h0;
assign w_rx_axi_arvalid  = 7'h0;
assign w_rx_axi_rready   = 1'h0;

efx_dsi_rx_top 
// #(
//     .tINIT_NS               (tINIT_NS               ),
//     .CLOCK_FREQ_MHZ         (CLOCK_FREQ_MHZ         ),
//     .NUM_DATA_LANE          (NUM_DATA_LANE          ),
//     .HS_DATA_WIDTH          (HS_DATA_WIDTH          ),
//     .PACK_TYPE              (PACK_TYPE              ),
// //    .AREGISTER              (AREGISTER              ),
//     .PACKET_SEQUENCES       (PACKET_SEQUENCES       ),
//     .PIXEL_FIFO_DEPTH       (PIXEL_FIFO_DEPTH       ),
//     .HS_CMD_FIFO_DEPTH      (HS_CMD_FIFO_DEPTH      ),
//     .LP_CMD_FIFO_DEPTH      (LP_CMD_FIFO_DEPTH      ),
//     .LP_CMD_RDATAFIFO_DEPTH (LP_CMD_RDATAFIFO_DEPTH )
// ) 
efx_dsi_rx_top_inst (
    .reset_n              (w_global_rstn                    ),
    .clk                  (mipi_rx_cfg_clk                  ),				
    .reset_byte_HS_n      (w_rx_byte_clk_arstn              ),
    .clk_byte_HS          (dphy_byte_clk                    ),
    .reset_pixel_n        (w_pixel_rstn                     ),
    .clk_pixel            (i_sysclk                         ),
    .phy_clk_byte_HS      (mipi_dphy_rx_inst2_byte_clk      ),
    .axi_clk              (i_fb_clk                         ),
    .axi_reset_n          (w_global_rstn                    ),
    .axi_awaddr           (w_rx_axi_awaddr                  ),
    .axi_awvalid          (w_rx_axi_awvalid                 ),
    .axi_awready          (w_rx_axi_awready                 ),
    .axi_wdata            (w_rx_axi_wdata                   ),
    .axi_wvalid           (w_rx_axi_wvalid                  ),
    .axi_wready           (w_rx_axi_wready                  ),
    .axi_bvalid           (w_rx_axi_bvalid                  ),
    .axi_bready           (w_rx_axi_bready                  ),
    .axi_araddr           (w_rx_axi_araddr                  ),
    .axi_arvalid          (w_rx_axi_arvalid                 ),
    .axi_arready          (w_rx_axi_arready                 ),
    .axi_rdata            (w_rx_axi_rdata                   ),
    .axi_rvalid           (w_rx_axi_rvalid                  ),
    .axi_rready           (w_rx_axi_rready                  ),

	.RxUlpsClkNot         (RxUlpsClkNot                     ),
	.RxUlpsActiveClkNot   (RxUlpsActiveClkNot               ),
    .RxErrEsc             (RxErrEsc                         ),
    .RxErrControl         (RxErrControl                     ),
    .RxErrSotSyncHS       (RxErrSotSyncHS                   ),
    .RxUlpsEsc            (RxUlpsEsc                        ),
    .RxUlpsActiveNot      (RxUlpsActiveNot                  ),
    .RxSkewCalHS          (RxSkewCalHS                      ),
    .RxStopState          (RxStopState                      ),
    .RxValidHS            (RxValidHS                        ),
    .RxSyncHS             (RxSyncHS                         ),
    .RxDataHS             (RxDataHS                         ),
    .RxLPDTEsc            (mipi_dphy_rx_inst2_RX_LPDT_ESC   ),
    .RxValidEsc           (mipi_dphy_rx_inst2_RX_VALID_ESC  ),
    .RxDataEsc            (mipi_dphy_rx_inst2_RX_DATA_ESC   ),

    .TxClkEsc             (1'b0                             ),
    .TxRequestEsc         (                                 ),
    .TxTriggerEsc         (                                 ),
    .TxUlpsEsc            (                                 ),
    .TxUlpsExit           (                                 ),
    .TxLpdtEsc            (                                 ),
    .TxDataEsc            (                                 ),
    .TxValidEsc           (                                 ),
    .TxReadyEsc           (                                 ),
    .TxStopState          (1'b0                             ),
    .TxUlpsActiveNot      (1'b0                             ),
    .TurnRequest          (                                 ),
    .TurnRequest_done     (1'b0                             ),
    .turnaround_timeout   (1'b0                             ),

    .hsync                (hsync                            ),
    .vsync                (vsync                            ),
    .vc                   (vc                               ),
    .word_count           (word_count                       ),
    .pixel_data           (pixel_data                       ),
    .pixel_data_valid     (pixel_data_valid                 ),
    .pixel_vc             (                                 ),
    .pixel_format         (                                 ),
    .datatype             (datatype                         ),
    .video_format         (video_format                     ),
    .irq                  (                                 )
);


endmodule
