`define IP_UUID _dsirxtop241128                                 
`define IP_NAME_CONCAT(a,b) a``b                                
`define IP_MODULE_NAME(name) `IP_NAME_CONCAT(name,`IP_UUID)     
//////////////////////////////////////////////////////////////////////////////////////////
//           _____       
//          / _______    Copyright (C) 2013-2024 Efinix Inc. All rights reserved.
//         / /       \   
//        / /  ..    /   
//       / / .'     /    
//    __/ /.'      /     Description:
//   __   \       /      Top IP Module = efx_dsi_rx_top
//  /_/ /\ \_____/ /     
// ____/  \_______/      
//
// ***************************************************************************************
// Vesion  : 1.00
// Time    : Thu Nov 28 16:45:27 2024
// ***************************************************************************************

`timescale 1 ns / 1 ps
module efx_dsi_rx_top #(
    parameter tINIT_NS = 100000,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter NUM_DATA_LANE = 4,
    parameter HS_DATA_WIDTH = 16,
    parameter PACK_TYPE = 4'b1111,
    parameter PACKET_SEQUENCES = 1,
    parameter PIXEL_FIFO_DEPTH = 2048,
    parameter HS_CMD_FIFO_DEPTH = 128,
    parameter LP_CMD_FIFO_DEPTH = 128,
    parameter LP_CMD_RDATAFIFO_DEPTH = 128,
    parameter ASYNC_STAGE = 2
)(
    input logic           reset_n,
    input logic           clk,              
    input logic           reset_byte_HS_n,
    input logic           clk_byte_HS,
    input logic           reset_pixel_n,
    input logic           clk_pixel,
    input logic           phy_clk_byte_HS, 
    input logic                     RxUlpsClkNot,
    input logic                     RxUlpsActiveClkNot,
    input logic [NUM_DATA_LANE-1:0] RxErrEsc,
    input logic [NUM_DATA_LANE-1:0] RxErrControl,
    input logic [NUM_DATA_LANE-1:0] RxErrSotSyncHS,
    input logic [NUM_DATA_LANE-1:0] RxUlpsEsc,
    input logic [NUM_DATA_LANE-1:0] RxUlpsActiveNot,
    input logic [NUM_DATA_LANE-1:0] RxSkewCalHS,
    input logic [NUM_DATA_LANE-1:0] RxStopState,
    input logic [NUM_DATA_LANE-1:0] RxValidHS,
    input logic [NUM_DATA_LANE-1:0] RxSyncHS,
    input logic [NUM_DATA_LANE-1:0][HS_DATA_WIDTH-1:0] RxDataHS,
    input logic [NUM_DATA_LANE-1:0] RxLPDTEsc,
    input logic [NUM_DATA_LANE-1:0] RxValidEsc,
    input logic [7:0] RxDataEsc,
    input  logic       TxClkEsc,
    input  logic       TxUlpsActiveNot,
    output logic       TxUlpsEsc,
    output logic       TxUlpsExit,
    output logic       TxRequestEsc,
    output logic [3:0] TxTriggerEsc, 
    output logic       TxLpdtEsc,
    output logic [7:0] TxDataEsc,
    output logic       TxValidEsc,
    input  logic       TxReadyEsc,
    input  logic       TxStopState,
    output logic       TurnRequest,
    input  logic       TurnRequest_done,
    input  logic       turnaround_timeout,
    input                 axi_clk,
    input                 axi_reset_n,
    input          [6:0]  axi_awaddr,
    input                 axi_awvalid,
    output logic          axi_awready,
    input          [31:0] axi_wdata,
    input                 axi_wvalid,
    output logic          axi_wready,
    output logic          axi_bvalid,
    input                 axi_bready,
    input          [6:0]  axi_araddr,
    input                 axi_arvalid,
    output logic          axi_arready,
    output logic   [31:0] axi_rdata,
    output logic          axi_rvalid,
    input                 axi_rready,
    output logic          hsync,
    output logic          vsync,
    output logic [63:0]   pixel_data,
    output logic          pixel_data_valid,
    output logic [1:0]    pixel_vc,
    output logic [5:0]    pixel_format,
    output logic [5:0]    datatype,
    output logic [1:0]    vc,
    output logic [15:0]   word_count,
    output logic          irq,
`ifdef MIPI_DSI_RX_DEBUG
    input  logic [31:0]   mipi_debug_in,
    output logic [31:0]   mipi_debug_out,
`endif
    input  logic [5:0]    video_format
);
genvar j;
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
Mvgdp+HwuT//9Kl15hLpn/GKvDXnEOVBpXi3HEOLr8ruJlK6JfTuCx8Ni0xATvO8
PlAY80rOYWbegZ+vIPpbaRTmt0H16a8Y2XbfnUTsKgcYisOm52pnSajd4SnyEI6Z
b2xKhvoVexhX77HHoXz2lNIOgeJZAFuSmPU0KKygComv+B0EpQsPo7nWjMm2gkdg
d64pMJRvmR3Wl6EQeNx+KbsdjLa2gD8t2syZhXOzH+OofbnCqmalU7GVxL4/jmS9
y1gnQzf1fNc531BuI/qgQG8Ztrk5P8K8ZwxeREw8CJXRValM5Nuyo+WBErZR9OQL
QjSlRFO+2x2RKXBpgZmHkw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 12160 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
YTSgqKuNBr8xKAX5FObbKX+99IqOdKs0MIeBXxL3S6BccFe9dgvXNXZOsR7sCnP8
/N++MjbFd4Yg4i6QBn4BuUAbib7065YEyBiEMvGefw790fgNARKvd3mR+DdQgo0W
3m5PsFPABeNb46BTLi9Gknfh4ClMzv5thE2MQfAlkChIvm+lKRWoGre6zYnMdx1m
QJwVkfSSnUblsMO2bhuZD8BpMDsJh4sRo4vBY0bJBL6l90WnQcG9EdOHTL0DtP3h
KVuUDqIYiaOAkj2Cvr9gIIfBqa4coPjw7SekjM2FmIlVUR/leLTfapEboMxTNyLX
KoWx2k3T0MS3N7I0hZz/xA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 3328 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
b7x77IBtC+hVXAb/N1BHIuqzbWxppeRgGxrW/fR51rciyJ+OfR/w4vSREXCCvnuf
NPvaNXHG2l+KNT6MwecrCYf0fKiy9YzDBPxcUL4+5I0Ew4ew9TG+mTslvZvfBYfV
g2xZV9SROwOKBR5uJb+EfOLd0IPmoDsZLvU23dAz6UQBMTnrxeoOD0z5zgvdPP/t
1OQT5MFmYfetf8kgz4Qn7nCf3b2AmGgDsdVM4vAsIHUA+/EVkzOsPhvlN/TxmeY9
fvnagDgsoycUfO4YxPWclvmyu10WuUmxO3SPgoYlexJKC70wJS6+/ZTJkwsH6Urc
Huu9kOXknE8rqY4RyKrw5A==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 26656 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
LZbOpTYx90lk2A4htzlvEjbu0LycI2EZmWGVwjbDj8umbxKmY5rms7vmp7Dt8qNW
Ys1OEarCx00/rA7TIKBgm07tdgl+UrPkRqtDrxiWdKwe0ieKOF4yaXvPElZr5Aen
Sm2yP1X6hsCEFtiXcQbN8pdZa7852pE3DqjP5xli1fzw8rjldclroL4Isg+i7ayE
MjIctQNN7s4P5v7r5kN8g3npurhbBBEDRqUvXIHtBq535UJxnjToe2pTZUpdL6R0
vTOg7Z+boAN4DlGODR288FtIFc0H/4xMI2HAA6Yzk5Xd2KJbxUsRge+QBybeweJW
x0lv8JtGeDqJdPB2FQU7MA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 10016 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
ExTKf6sMiT4EX1PIKG2EXfJ/bKZEkFptfvKDCnO3jM3nvlHZcTJBOyzRaq8m64NI
IBzUMg/feakcC5OtitXVrr0FE+s6DOxDLFF9XU3CH8T5Z5rtWZ84pfTJTAgwZ+nK
vl6jWAwdWHsFvVT8emb9x/rJ1XNvtlt9LSyu720x9OxsdutZe/WbwKJv5iTAF/Vj
32dV+VXANXxQ3OU/fojaKAMSuqnh0tfv7sFG9y4ADzSMs0lax5DwXw9rF6x5N7U7
i/2ia7iHHrPIGra/tpVULBdmGSBdbmYZqxY/k8m9/iVBDDQP6rntW9GvMT+qSLcL
UJ17HYLv3Mp+8R9PND8XyA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 4928 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
Qe476zYstBh5xpp/0+IhyPC9xNxLPPAsUKNwwdB2oXHu/VTQyUIARyqECp4U1HZ+
bLZBVdye3gsoTnsW3R7Fc5yrORytrJfptsNQdTfJIdtW9UIBmLDpaBmMbc68r2Hs
mkjMvIiPwVNDF/KJRJmqVz/Bxx8tYTUWf+qlZb8M+4S3wa2BD640ngDUKYlvQ9Rw
M85mSdk4CB6e+O0MvrtMatcIT9oH2hOipbFYQtPEUDg+Ojs0xOrOC8zWkTNK/thE
OfeqdVLvJ4wa/jTm4WG3QwSMRU37djVtuEfWtMqcGuiMdAnAsCy4D+Us46RipO2R
wA9JdikM9PN0lJNg2Y3jVg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 7104 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
BPejWFtUQ+JpZqK/wVCIwqkYnqBZ1ivr7az4moMlYp3RwlJcizinWnTGUoh1p7NA
7I0cgFvxfMNjA4mWDIEkGMyGR6BlHARDZ5JeCnuVI+PWuflvgn2R1QnWZVh1EuOA
IA3zMDXtseyd5JbkJ1sF7sqe8OUnRnJnsA18kdhQO/3PT9xAmL0WYKCAgiCX+COK
yB8f34NSaOfhGmSprLdEXRksvjGhCJFTFfRwipMCTvYPJBXTp5z9TPA53qEO+uSm
78ba+mHd4lw3P2zp5QNL/6fI5DpZEnAo6NT4Xk1spgq2JCtAPmc6WaISVUrXce/X
HNT9zRzX43kpweBj0UI43A==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 12320 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
cQiS+89fDS5akJkEnH8B0/Yl7rAG6N3ZzvcS0ZqdnSKMjgFEkppuMHV/+2rpLCE1
PxgR41d9t80lq8dFdHlnWK+mfh+YIkB85im3akW608c+aTUIJg9nVN1Vr3trO33r
EbJkqqOQQG9k8V162BtICRzA9QvvcGfaW+xt4UmTH8qBw9lvDm6gKrLTS9jUIdBM
XtsOi0kfHPw3pLJAjdlubj7OHlm8BWAZO8P7RQhn9Mv+3fpqiOELn7ldlBBbnQrR
yaym7yM39zD9q7eTTq0CAR6GHbPiWQn6RATKUpd1TyDGl7TA0Mpd+/+npI6efMlV
iwUvgtRREKPGc4LwE0xYXQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 29936 )
`pragma protect data_block
qdozrJtcVII3vusTN+FADCb6HqMXRZpRHsp6rwlKXkcWSI6HzZn1p3FVHN5GUBg5
GLJ/z23IrXQsB+TsO6ZEYtzpSDX6ejG02QVQBnUn7NJzKsX/xDN4h/SRnbCuXGO9
B6PtmqUCKzKW1AKQ2C+42R9f3G6aURvHwc+E49EI7sRmWsBiH2qaqQVBeTwzXi2i
r4SHaewWE7Lbkkw6UR0bjJTEfVQR7epJWV7XsR8MgregDDInCN2fVVn8tNOJTuoG
UN49qGjz9RKMS89IPiUVLoKhXSLFvvWGdNac3l1ON+tGnizWy9jjRQ3T/IGuke3F
3Z+tDSwcbCyKdzyOhMMj1oS0IOu9n7Tsh9PfT13AAPJ3sS58A+vGRL+VoMOh5E7M
jrKO5KArYuOD1S1wFVl2wOnqQ+f2MDTGvaqY+hpRN4Koe+Un9E4QyWOkAj1XAnpO
4zKyK/D++YOc1vG+0hNTp+bhRaV8IbH331UaW6YYSafIugEd4kkfok11UgWooqaS
wyY+LHxbjrseGsiM7TROjJZluLqhysRrSp1RYtV71r9qUONqAB3GaHDlww6a7flv
9zdoY7O1CrWBemejSm4Wtp2XzLTADY3X87clmKE+LsR4/nT47kqSEV+K5wBOU6Ta
iJXvyk68tjEgqtce4WpSSzObW8enN6A6dGuD2Rh207487DRxyPMfW/e4dkiX8mWi
wo9yUnF5QY3zPoRhULNicqG9F7GDGigU6vaOOrrRL8/v1uL70xGENImCXRiWJV3v
t2T+P1FaSgv8HMNUg94TWSUJzPkUGdLr0ljGL4KDkmaRVB2zgo57swuXZaLSBhYK
jmFruVp0NVoHhJNLcD1p51xDueEd1im0PkU1iMpbcjTunAhLPh8fiywAGlhIigB9
0MGUAXvdizS4Nwjpng0wDWDuoGz62k3BhKFL1mMJkBVq3+wk6LhBA9mezgnb29gF
WwhNVi77a2uVxWbKiSyYKtgno0FXU1hwx+tk9ouUdz2qc3kmZ+pB8ehw18mmRWWc
vW071lTCGY2ckd6Ce4RflbStPue3H6TG5T7IFsVSYjEgW5wNY0nagzWMHvdmeBUh
sIX0rz+GJ2eSmo6ldOz0DjSc6g/2SE/yMqu6fF9JwGwjO5GcttK/WiftIi3tNhLv
NQsYfMuVAhO+sx4uybFLxTe6zIuyWJaKI9ui2JR/w1bp7AECZx6OCZXrhLMq9M4w
qPlDyvW7zFaHoFEFp5gEcAUTTYXx24qGUM0Ve+7q3XmCWTSltKbzfPjxmqNRt1cY
DENwuSZjq2tqaRWsHlcwsecUYVJwgUTKubFbfA0/ecGHS5kv5T5B/Ksm3yfNDdUM
WveMUeFqH7CiJ0chq0kFl3E1arHN/ZAkBTa9Iu1qCoup9IjIWM1A5v+qHX4xtgo3
VBbDOeBzMV1z91v+QDNH+m8nGV7wPShFmxxw5tMyXuPrzERovC/wg1tR58zNXoc3
2HnvDtobj5/sx2JPKwQG+5T14qvEsEC8jBa6g46NVfmCvutBYLU6FxuxKz7q1oj8
Ah1msoV6I7vrswDG8S5nmR9kws6kxzDDJENjnRcf3NXlbS/ntIcOngd11rPXIjoq
YM3VU3O+gdDXa2z1kl2pAMBxeSpkTqBDd+YocEeKJjS1HJn0AZD4TPuJL46fvq1g
eBKyjltRfgNqPoAPbCezp8K3dM1WAHWuXkpZrj2RL9qOvAAvEZ9QNxOaD3NIjwXI
cio2Wi5IbKGUL7axFS8Tbe7pQ2VX2/wh1YOOT/wWpZn5DHSanUj+0C1o48jCU85o
DRS2JXStZAynSrMJhqnfO5mRnzlYmyJ1ktECD/VaINGEOQhDaMMljdt8InYHnxqU
GTdpaBvZkjGPF/O3T9LIsAFeXEgYo5CSqSYyHq/mpF8NKClWIlVPp4c81SFITh7x
ylLi95krCZYCgwtK2xge/PBQRbPuSXOrgqCsiQZcqFDLLz/n/RDg06wDYAa9WGHB
IvegzNTfe2wCk/PsqNujLX0zZ8QOkVI9yFHRsBSbnkpSD9sA/347iFpqHSgCjohK
vVwKo5j61rJ/XL9UGv9hvxp4V9mV71F/CrCDA0vaSz9WhB+jaXOF5d3n2mu217kT
fiQwmtnRsnHr2XbaUhM2zjmn3h6SeW3L+qxHfPPjWgjBir/ZPALD1tqr3VMXdJzi
372Y2NKIvaURN68KlzoIqaHmKcM0goNvcAfYQk4T3hRY1pEtRkmpr90h2AN5rCx2
qA4CkXh5QDfcGvt3y3KeEShO6iMX7PvqHFHIfsG7A95qt8RFy+XX4cGTTtfkZojq
tguH66Sz/HXCTtM6+Bef6hZWWL5iGQDYvw9KQCbf2KVKkwdLaLIw6s8Px/ByQ1gS
2biZAX8avl9Lf3bdveWrOoah1UkriYOfytlm0gdvoA7Sr6XdwHWOS6jrfeK90rQa
yfSZbb1FP2BUHY2X1QJD2yhxnfowIPf+NR0fIkoUhIUPm8NlbyDkuUtSeda9UrZC
FBmn87EM4N/y2KhVj5Q105mUzqlH4yl0tKUfR9PmQ0wB6rWFZ8hFpdj0FQV1sScA
ItSgh176C5asHn2f1Q3YmqHg0VX6Y3w8n72uN1wQ53Be9tNZV1tulxJPiQP70U8J
unaOI32lTs1PQAFy0l52cOJ8AWoZ0ctamqlmZCO4hPBtdEXmUYQuvtECYl/PpmNh
qJpBaZHSlOQ97VcRzujJVjfBny/vteheyfjAZYMiFBBqRlUPfF5asHsiohSFnmXc
pVUIEOnZrFelO0TxzeRVF8kazQsAT4PCq+pp+ERvoeuL8jE3OukkAno2i6ODg3Qt
KFtm9kMp/AyEk/z9j9hTOaFYBhIJxpUEbnQb9dlppXqj7l+e3cm1wldNfmksOjdc
zS0t38t80gmPoLPn3Mo7YPBpPc2ceMiAQbiMU9jXGvFRTMT74ah2nlo46vOHUXwd
aoOO1p+pYnbCJcwACKCnyZwK4KwNqaMUxOehse6Qn2dAL3pDxbUiw34afE/hs9tR
vcXOMegOOOJtvIb6juBBd3bKMbkYiFxMAO8o2ENfCvrsfBBBemYvRrhMAcYK3WIZ
F6DXL1okILVS5y8m8ZJ2Ic090ZJKei/Fj/2co/jAsYPXJP6C0vhKwSQNZVmsT+7T
agCcxWzcY/jtHWdg4RK73CNQq1a7tZAA6TOqZbIV1Hv7bjAft4saQGRtYwi/LhMr
sZ9s3uRwemZOzVVxRd2IJs3olue2Ue/XDpF2KfEj9bTGCLYj8jYGtiOTXOMuU2Vo
rhwP5i1BhLJ6729Ox/2sFIWDAB4lD8wRmLkzpSMXU2IAXK+RqwbDFxRC6g0CqHfn
Ejd8AQcW9KEQE3dEyWTqcUy7+BA5nty/tyDF9bvxXW+mb+AfOk/4QNzU2Mf7KQiB
Gbdsz8CO+EeuB5NWgEkPs9/zAdEsxwo4xrNyhHe6eG4QCrTUAiA0vcmEWP+iTJlk
6S6bogebnGm4XpFXUdaVdfKo9vOt2QEVpPfZhJpOUBQB/9td5ufY32EFi0fm+qRE
KIzrcarc9QolRI8KIan5/2VjgaTPChWbm3uIvpvkECLizVqgln+vJ/vKKMltywl6
Oymhl3YERpxf07oiSd5izuxKzyy2DrI6LUr9WEcPySV0f6egLqXej8fbOsVGPtIU
aGEJIOsIENePDUpMX1LCrZGQS31rUnGkeIvEmj2NxRehli08PjIyk7cql3aQF4kL
9I9IxBX2QGhfKSuMOZooT8R4zsFKOXDsUiIwySuRzUzq0ozc7KkigNiEdJbw1dNr
f8PrTzo63/yJHJ/YYnie2mtq2hlgHBdlXETWNWoEmmQDsu0uaRmhtjVwPCpjmH7K
NjFCm4ZoHNHyby6jAkeK2XkfviPK5w44MrCPDxY0nrrDmoiyzcIpXzUqerJPHivG
gmaIPfAd2vhcSyfiEZth/gromkf8D/aPWZd6PNGSYAv6BCAGT2VguZV1HW9T/cnh
gLHJLJhz1TEWSTEZ0nxQ3OU4jg2nYBPjhd+2Bdvl9b3onhulIaoGU9LXDvPWAuLO
QIwL125XbCWZS9a9I7DjCGl2NLlXDgDIaiwDBJtzPz3xb/ZYytFqOJ05aWzRlNbI
PKXujduMnMuHLeFdtKdsyLIehdH0R/2zJwFt7GrF87N66GdfuOrC7r6J0jdwyv6m
T59TASYo22eNOBDNId5Y6HyfPKLoCZrHXIPUNZiffKd3vJxBa5KQJYmxbSm6JnWB
8A78FQkfzwNv8xo1wcFUPwPMu2185VXgRyziJBhDPcyJ8IvFOS0IOv9Its/nRUv3
VFMOA2uegA/zgJjmU0h+dbQ23RyX+8+INfNrIAxK3jNPtmfkUBl3dqDMD/DT6weA
zfOSFP4+jQPde6YV+Pn/KVQ8BjEGGEJ2HnJnToijAjMlR+AAEZ49C/EKrxxMlgRq
AnNTl7os7efo5x78xn0cIi/Q3Gc5YLJEs4nWTsmiCpE7eSCCL3sAA+7zJFsIVDWm
dJCM09EjwWaMPMzWkyEfk+HKyJHjLqbIhPZ8laAYROERYAPAqFomvwFNe2Gi+2MZ
0f685G7GbbvVLnNR2ptyxaW3MGD+qbLJhmDsqxXCUIQZUgQZ8WbE0oVJV3HquKjE
DEXOb2r50QHRbT0FEkDJ+Kr8gWSrCWy91kEDPvyc1cu6IZJIxCaiZu1B7snu2b/N
z5xBy4hEbO3BzLpStuXxOOA0FLtERvVy1EMoS+mbGY1vgMZr+n2tgJhSjglVP1Vh
S9bV4IRS8+fufkEBYebNuewdvDyPMkNdUKG/SoBPEeXtRuLvLGuixo95ipoQ2v20
s1+oRXRB8FB85zMRJD7BP0eand8+BFxx3+D86K/xs1MgUMzLuZLwqbDZCRcZn7e6
AobKgohBllXo0m2at4hk2s3i+OzNGXskDMo89sdpOJRptye5D8N+tFNs0jc3di77
VHDxM+/ohUe74yl1OdHr4/cZd/+afgbfNtqG1Nqr1Qbx8pxOTkoVVEmjdjECg+f6
egyvH+gbNV6PhijjmI7QVuPMxPHIZn03RXJFfOlMQ2HIQYkW81nGuAmrKjtn3n8/
yU+F/gp4cGTyh7FzoT70+glbx4IUwReTZDV69c9TqEfmP1WrQAJ/xFrZEYmus38o
hs6NAqtLL7YrMGyAKSbQjC35Ph33bXlD3o+JLjAK+LiPswHyhg4Bv/prBURjTn4K
bC/XV1PTi+hrlnvZqiEw+lpmTV40VL0EDb+LJMjbSioacutwaOFPQmanFcAnuSYe
VmHjRsNmYQisFWmX49ORhjfvtrIHHnolsn3/W1vYVhLwpX1V3mzi3sGDWOPQtc51
Zy1kZQk4eg7osZbGE1Wi77Ncis0BRLjdsp0pzSUGSWCN+wh5M74CXwsi0qGb5crL
+nZieJa69h0Cs59VQEoYlCa1ZfNywijf1xdBQW4kbAHl4GzwpAHsseQT27tpEz1w
6htrGtXlOcE0PFce5dSVTMHTHZJAXSWpbDPCC8iok45ORY9Gu8E9R3h3bRB5VlgA
Ds7stQCKpgG25YM1mhjsezVhKm9GVb9N3SaZDM0+2OzsYjtctYvojaeY8IpaJNfU
Dd0nNHtWJhKxBBzcWVqyupPLxPH9zzy83odOQiUNORMmdZLnqTcLxArg3F2o39Dw
XgNM2nHttDtot3BqmTYMwiC7MaItQdMQi5Qrgo5NZbxe2+6sa6C13jHMOmdSVJGx
rPWJKVkjowd+HrFpaeJyZs0lWNkrTtSM7Z1u0Cj225WKpYjAVjSb5Y4VJLalCOez
i9WL2D5dcKEbCIqwYA9Vod3gWvXTF2yZu8sEith5kjzvfSDAWT0gLO3kwxhVqx6T
xXQ/AQYTqW2Z5itboHhPPlIyGHgZHimwE/NtLFqz73ajgmJ4M80XgLEXhwsqrh+k
maYw/guYljgoJL0Mqp2hvUVD1s0y6GiFblYMfIl+nTNOBw7kOGZdT0gnniGe8x4Y
koF5NIXItiQp0pphkGAvPc56Eqzo74+B2PEd6lMitfixoL8rLNmh4cz1cm7Sy3Mx
DFXLn3pueSsBM89DsaaulBvkY2fO1d2FotuY4h/8buoB55PbNknnV3ctG2gPPNwW
CN8AgNYKUEFoznjgPKPfldAj5ZvuTJWmrvg312UB8/6On1FUUXXGjuLOWEKOB6B2
43JK7cww5PPSjJqUi1CgPgDspsBVJJnAz/yYsw+o4O8H29QkiASJ1MFZ4jhjjawF
x3Y1qQpZCRwHWXL51cxIktJk3T6/cGQ/HE9desZt3vqrFfOUxi2In8ZVYOY6Vj2b
QBmQZZWj9wHRPtheHg9Iq1tkwhWzAJkXr0LNGz8oazA2uuPZORT9Rx5lbLmQGMQG
kt2VljXYmCyqRWCCp2ljGPTgadKhNw2Dfp4EKzpFGdnVk7HOna4bNu12AAXxRXnz
o6PT3v9mXWkWiiajqu3FMGrioJQm742mSpG74hQJfSW17FxBB3H3P1vEc2N8DHEE
gJ7dTIAM6rB2ncLiQkZDFeoM3wPc1vELLjHeUJn6SufwDCPJl0l88oDoNLoUs9aJ
60sjT1NE8tSMut+h/Wr/TyScN9EpYeufvyWhnXCdgKVWCjcuCCOeIdaaG5zcQi+a
tstuYQh2raO6hvo7829AnLON+M1GpZ7HrMRqVBRaNXUwMl4uB746PQ+hLL01Lz3I
ogXHlZSUKkLmgp0KkaN3um4BmESX/zIqy89iRPtaOBeVxNbN2h9cAIQrLXXZ31eP
LZ7mKT+0ctJucwHggCGAvZbVTPQ/6ii+ur9FvFVJh2P4/vVbZ64BVG8nPsPFj4kd
Iiqxzt4hthfllwf17dKtYYsrj7ymvLDK2PHSPZm+nqIBqhJQPhSJqYjcaJD1QQ1O
rNQL92RknvCOsxKx7O53iRjc7jM4ip7vwOQXICDivGFUv0wZLU26XVnM6hWn0PDF
x2MohtVoEUCL6omzOQa8VDxnxoDjD0hQfIunXs5JXltiLfg5y11FVh+9f5zqNnEQ
cRv6t99iM5vjQdJewzVMrZ+DguDl+kvbqGK5SvlgVeik9Co7ayEWEPOorV53Nime
ZR/L8X/QAS5BRzS+KfxezaaOOv9jU25adHtDRM7daIMFY2Ow80Lymerzylj/0TPQ
mKD5zqpKl+64+YoD7vPn0cuJ6ssALaeAuraElkfzIulXSeEZiCOZkjloarIhwaQI
rGEZawyqLMNY6Bf5ngnCxbbjnwply8XUFrcOw20RH+5ZJjlYMaSELyNF0TjVIqNR
9i0CAQeZsd0Fgz2BeH5nbYede/YXD2u5lJpleNLfXS5BzkhMW9ZEaay0vSBoUyUO
Tsw+6DrXpR7UyCIJlhMdDroY6m+S+AcIPSI861Tj1z/8K4PlGrcWJTbzwqcV2d33
miwqlnu/4JPxuWtD/PRm42deCYbjGP7JadpuIRcINdOyF/ks9ubPBA0PGKSXjPGa
8GOeqn0uiitQYJbGLE3KgfqLszEGh4CI85x8S4NHkyI7dFcDY09TxM/zP4kCbe3o
oVKldA8YCmerSj7dPxSn961wd5cgS309BXbkLYVjxv5TUwN751wsOHeB6z40K42G
fONR18+KTPJVYZYMLfNEOsaUZDPi10UXjxLhLwsUw2KDGJfdv7UH980iJbU6qgnT
12zLxVeqaEjJdzU3ilitDnwT+/6/rqWsf+pYY3VLELhH8TNyPDtXr6dsahN+Kfh6
hqgDdonnCNpv0A0Qqx/1aOOAo9kfi9BdOMr4Kjolp70fXHi1rHsZ81Rwu7BXtdcy
masE6ZV3HZwCb33K73J5ArOvLCfstfaQszL2gvYCOHCPShW7c7W4lxyxUdQmT7AT
gh7UyRUKE1vRnhDOmjBsqJhcalh/lzEVmzUdMq43EPSkVBYtfNWxG6ffwd3LDPR0
Xnj826BcF4p9dqTDv+MXKcAGyQ9zuAgnfcqZe8GCqzQOIbBtaYdCvRNwoiTsgLSU
4gx14oJ4pmL0El2XkQ4Sl/9oH/JCEWKkcZVTBTYh/RC0WyOWvv5gA1o36QKAzyjJ
/Xy633vblH5OyRRaZoEfOjlQPUj+xnfu5QX/brclzseVo8oHx87gXuBlOAhQc8a8
Uk4mcpf7aIY1ovVrGJrPI9EI0knE+FpsCAELc3v+M9w97ilHBjznVq9dsndpft2w
kQa46+4v3Vdb0ha4MU9LJ/KfLsj6Xo4BiOLfvyFyXu+KCARGdI0bHYSH5pQxRUa9
axP21kYlojRIIReMML2GRixzB5ZGsbGoau2iCkXcFWq7vGYvsDX4Wn+RtlUQnR92
8papUH4SU12IzwlNqAyKJdmNW0FaGh70e7g/iVOQiyAcnpezcSLwXwNED0b6Mxen
I73TFiXPtu/gF+i0+U7xJ7nPt/hBLis8UsUYoIrjanijn1wKTdw/w+QPEEqf5kk1
K491VrGTOaVI8PbJy0TUYq4mHvKYCOVOCvflan021Gl3FX42E8L70HMSjdzM3lA9
whOmQcY/Vtrrzmk9bR5tnQUgTYWUJQZWWw8jofPpSKJMsaBPlBKAfsOwPptfPcAE
r/cvXtLLfSLzwedyogQ/r8ZMq96Jx67mHEe/0uehBWns92EpPInnTOult9HZ3M+L
bkB4uP6oviDn3JgPQJSvri6iX10O731jisD9tIK1APmEvn02/iB+7q0iuIFfuxA3
l4Bf1B1p22LWd1Hn8Upl0paxUQih8lC5B46VGWL7bUznl3CJvQhdSGgV4XSehJKx
D2dd16HY+3ZzU3XsXsxxaVXiG+w9t+ZRBjRuyIWLPZI8jnizf3JWRxewOZWl11Qp
BzdeYYNcNfzFJxW1UQRHiX1G6L9fx29vFAbMW+X60ViykjJknTpLbDok8LEKK/Mq
2aOeHLSoFuDDxTM66/8l3T7koC4CcQdZjKNQbUX+j+XiTHyVZoo+89ZX9OV+Izxm
81PNosS9scyvbcocTIitQaI2q9EQkVKhuL1LNczm9Y6jK+RVx3xNHWmX1WlY0OMy
64tmSTwYlqR5GxKrZKB0iAzkZe7La5fTSedtMgP03KlDAvArXCUSv5Kw7lNpK5a6
wYywJRbfuQveoeptpPfNE8YziLJXCAFomf2o4+ts5XVKc6S43SD4N07/XGPSh/w4
W4BHigGzwvzRlv9vSLuUIVvLVG5QL2NphU1kPvCIj6GkgYVVlxoLKs72WpWRFqru
wi25+DOY7UJC1QfRabL5gWpfs8PBMx5z1lxep62mdLcqYpJYt/i25ifZBYlC87Cm
a79CvAPJzvNSIupma4sW8SQZSEwdFVGRSmk3RvTiC5zLWUETjhy3Liqcego9kCLD
wmbr/zD9kbm0iqpYlsXyp0iO/E/euAe7CDYwfmR6U6n81EO++qak/BALzfE+xNAd
Ey+agBypGHQdbNr3ct9kZikq5Lqr3nyKaADlzyggE9MkOl9aKlXIf+2JWlOQ9qTt
CP3EXdo9K+MNlCMxVKIUBrafa8m3JrTUohflI0dsCLtLd3KAXfhl179/EW4nT/xT
ujzsm4VXzDRCxK95nY422mRDAXH8AzQzZ9gynmUH+4ZgDa6ketZKdrPe5nDZRoS5
ofL1nK6yqHeKG8cbotDKeEPToeH5A82kcVZBW3A0VMx2XpPJsI1rWOp6wKwHmif6
5rEYMOrCZUsQSD1XIie68ENdtRPYt0BnqPfiFJ6CPvY/rDYMoYnKteQHcspop1EH
0vtYIbxRX5ld3PIi99l4+IgdC1rP9+E4VcaiVOW6gTD4GJHRkgIuY85WP3M4ZZmw
60KbEnhumKvyru81CMzdzSODCjgqxUA5Ky+H4a3GXBkUmIrt9I0gkKWl1Zstid00
PrILyMiXHjtuSD4INmBS5e2b3QtxRJx/cmpaJYqNo+uwrVb5EgVbLQXoKxpW7er4
sEJGcsyT3N6wvy2SO8bHgxdzfQ24sRbHxCgNq9BQd1jMN5adLkE/nfFrYmFv5CxL
YMWsIMpboWM4/c+I2bfiI7Olw4w65eZiI5MKTdcQOpfT7KC5UDpYeN6J+53hdp9s
BdaF5f9pZioaOrnRVlNZF8HIGdcA1eVjVFHECQIIuRrB3OmwOwd5p9O0kbwYAlJ2
6gJ04tO4PVkw2i4SumW0FqLkZcL/wOFWVsW/9BiFWVKddTpfeWTMYyNEIuuQLk87
uqVzIdlS2HqvdRkTiR4UHD9egxhIn1S0c2mdEu+nx0OYHNn4QHqPHxSmeJnGwuX/
pxiI7qxKxQY2NVI0RcXxzcPL7ou5uGHTkBm2S/46cDmeHsLttgEVtGg4bCHr4HLJ
fFR3za2jBNQjbRvTaODkp52hHbh9OFiXNVjQyT9YUNhjlIcx3pgnYVVUDQxsDBIn
RAyI2YJAffXW4GCuaE35NVdn9wEXpwL+4c+e+WycJKHjRj0iv+HWAqmB1ZA1/MUO
owwFSwNaFx1z7p531FNkdLtwdCU6e7o4W4PefedPT0KRnW3hXHr3Vj5VX6t3cwZH
iqqAuj/LCDOFepjVknKHz14NIE78LkC0zEo4lHjp55Zlx0xumXUKr6ULEvuvl92+
uH9bArqX7za4raamJbITcpYt+QRQNLh69tgftpdbtW5em35c2L/44zLVYKgQUdJ1
Wj67snt7ob/A97LKqWxkcDXmzvwLrzvJHqtX03FkydCRVScoFJG+r3+AtzAqKBqE
e4XTWA501TNNgnqW/Dz3E/3az1dJNh/2iNJRP1iEo2i54PMyjqWJVtyj2MAOnoAw
5AoXtl03HGqL+7NFqntJEqPxSgUA9EdHbcLeaKb4/IuGv2Snh2/YRDu4cH+GPap5
iTRTr2eL39ogGUQyjveg802rwo/7ewXC4C8YlIEX2kiXiy/XYrebhciOOO/Jy0HX
8M8Yt5/kUVB3+culGDt5J7d7RNd+SnCZclUhkF/m0EUvdprRuxa8uOFsFGIZJx//
wTwZjOts2WKPYShfgoARFtKrK9tOoWBpVpOTmWfMEMFE7n4Ne9XJYkZ4mIp7NE5s
oojaWhGpim5/2aHpWmzOv/ZPGTTlhl3A3YJ4sq75B/Zi9OXzDNbkiEhwEePnMnZ1
pqFs2inYSNlHfVjv7k0EbZMHuN68AwrLmB1kgWs9gie23i6J1zgF6gZr69VO5mRX
THO/Vimq/ETPt5N8hhghncEkm9ZefXusnEku1DtqI8ckmGXK7lbvCHHMw7cDsLgS
Y+iUqnowqpwEgQir+CKRWKhZvnXyocIovVPh1lCgUNuq/lggdjruu6bwEAh+Wplm
Z5sy5sw2m5dl8EFxpx7CXtVMgIMW536f2f2no6j3ZQqSZr4+5qHyE0mrip3nBEHt
mD4k+HW9cD124aM7qvWnoBG90B+MRAdJjABE49mI9Qzy6hUy8U8w1r5d0R3STDZ5
0siufYzqBSTa3s42tR02cnZ5szYuBNXL5ws/ArTrrrtmQVaeBsSWZdxIRfQ/TbLI
4LTmGCxxlGbaaUEU1Hh+arD0242WaifrTUYKQi22fOUY4nqS/1PSVnFYZjnlHBfY
QkhBn4l7xB6ImTJF99qBCrxzRee0OKvloxS4l/hHXi1PtbRyN1nu4pvFvLxdLhr1
C0J/p4wBJ4a1tG1XPT8na7t5QZELLEczS+oR7zS/3TO+sqJI7I63BEybVsh6NrFH
QcrTtWeIeMbdfW3C1cCRucf3yLuPsquNj7Mw8dMvXfXq0N2vPbXGlgMSA8fv5dN1
wppyWDEdR7oL8ytjya8rSs85SkZlQTzgjk7GmQXu3JJT+U08mgjoryNPC7va2rdv
bzlQd/l7YDuPjCyAfyTSdBRk8JoBroKZ1pZgrIpWj8EV+xnjuWIOz6dax/bE44Up
ESQDkII6LAk7J13rVnjvZX8BMCzBzuGxsWvIdZ4WJLLgZ1rl0WD0uDYUWWkjsYMX
gzXwi1dWDCtue0zSkNqWxl0+JRazgAKlDLc2nQCX40XUDhq5ga/jQtDcrVNq0EJY
2abctro1Us/R6DVd/d7NuE+ogy8twylY4r4b/JT0LisOVCTYp6C62+Le+a8PGJ2a
0C6GnBKQXiUlR4k8ymUw59rWyH/SLvbVMwu8bFMqJdBghFAJDeGCkGQpgSDqM3oW
gtEHSps7y3u0+kRpWN3utaTRKLvSkrsic8sA+fuoWyKOtFrQ+bV4lJ5tkB9SRYpZ
+bV9oexqmJucqiEy/R3q3E5mHfz/pLuwNe3KPJlXwgiv4RBaf98hJ0no9hDb2PlE
x+fyWLt8oDjzYHrq+jRKVRAw/O6QYtfOthjWe6q4+rGKzgH2q1ywhK9Yiii+SZdT
YSOcydDdSleLqWBr7+XoJJyzgTlDMrm7DKbsm6T8IAULStb7cKaV5Ag7EWgybafI
mXDuH1nWXS4VCeo9iuCbO5+7MGPVWltN+UWBpxlGawltMdsSjY2PpFLmUKlBa5ck
cKPugbb+v/oUDtktVjp95+4j8eX7DvFBOHMsrfi8z9tYy5wXumkU/XoiLPkWabpL
Yksm+LjM9ja5b/MPUTcpOw3LpTDN0Y9mkIvlTShaVMTLIok/n1R3DA/hLin3jAyr
j3mlOGBEjLOlDlhsOP7ZlzSs+krCX2FFB2USw8j+d7yFgW1tVNn0EfSELnL1YcK6
TB7gRZd4d2CyAHTaMC2/9H3T5Iv3mN9oYBAPugtIp4zreCsMVxLVvMwOlzvBs3V3
IJP0uK+CAaGurTpI5n11aSpM8AIuDekY9OAjORFR/Sw9kWlaUJqwuPmZNJRttO5s
cWEXe8l23Hnf+2nO6Kr7LNEPhbL/CWzFHJQbT0zSIu8Z6gU+Jt9VTWtMW08TAQUc
ebW/0tX+JA0NURP/iBcOJdnFx425jX06ir+fh7tY0/PNOxsRKp7/8uzo7bzhKEPp
Vq2y0kH+1pJOTgswqD/LRtbvWKtOIS1G0s9pjOvCcptlU/BbUyIr1nrL/3rkLkLY
c3juX7H8MD1kEwfrAH6h+Rw+3eUDWVTtZh5Lqa0ak0uOr/uYlFuU40usPawVDM5T
h8gG9hDgdlEUIzK+LUpBHpZ85NWYF8fVJi7mRW+X9qn7SIp0F16ibQy4Nbm5qb6m
k9FRXgpHLvp1OtsFnHu4cKP5pAjHuAXBuNi9Csi8qovUP20JTLa3aQ7Slqxmadp+
viq/JLBPL9lty3cg9wmRXLDQTn+TfZfjCfws/CCV8GaGax8R+hoT2XYdHHk7Jg3X
B4Dki91gHe4qcxf5GtZVBvUIbtoYBYCKoFGqMml7BF+j6UkJWIVV32GnFdiusJj9
tAzdVWgrTCQD5ZTjs6RZtoNUzRVjK6dElKReg8RIvrm870XwdmzMVtMzoWmMcTDY
bzX162E+cPjMajgjjZqUhupW93ZQHofyTvLNZ0CCDm/HoRT0x53OgMnEeLCanORB
f5Cv83KHWiVT735OmRuy27DNGetaXVxnTMO/kmczIghOPHuN2aiownUafb6BtRTG
LJKV9B6/LNVTmp9ez5B5wo2hbWN34J1SKZT+UbrxzAw0pheSv8rUUG0ugtd3Mt00
Cx/hoBgFkxZXyBOM7sGJa846C64CUY3XEDa3mfohTd9/UICCHO8IAA8MJINrTCnm
7HZGyLkLsVK2mziwSADy6hf9A26OgB0SPCRURRfb9dNYlTJtu683ql7Mc8DE4HFo
8puedFeslCU/J/b14HoGI74PMeZzZyGhv/AAu6wB/yOUXpevd0jVmKV8Zs97b//8
0otbiqz7VrSKzPCn7fqXfaTwzCw2Mq0QADs93miqeMEtqrhoBI/QT1Ld5DJzNx7K
G25SJ1kf4gsJJi0CiGHLoDZ63N5zQ2JO3R2YOnLZvzJa2hXp/WPAN5Q/33IO686q
1wQSKH+Fd+c4mQpKtfq/bXH/syskwmCoe/JA7EHhOV6RWn/voPENReh8f9ZS8da4
A6N9Uo8lYphGnP9aUvnlhdtiyxklTMm0a8OgTOQj5WoSmCKTOcQg/5VMUxc05r+X
s9z/sL7v95YzDhmLx8wwM4DudTUEEwraiisVIHu+z6IAIxfyCTntILX0+qsGCJ2u
ubH9VG3V0ZeHrRf26L+f5fOfRhHXdsPlpMchUpztBGzOpJGhVBWfySlRey3yBFio
azTRXMWqqCMtQEAiRsZnLWCKz3k1O3XPVeT7gHCqEsgYVLmbqPaHY9ELxMvvon5I
WpNy2Yxw/96dStED3IIZmmGqZX6tzYMLqajqjxwZNdeDRuKF9UTkcS+DIqNP2NL7
UfqDHJT+p4XSx8zMSUQdoBPsDpIMz3Nzl4GDzzPDMk/tgy1kBwjQ2/mKK7AtHH9q
AvaD7FK/D6gnsQrjMHY/nfKVlgynSGSjuXH6U27XsGZ6/A+1x7SaK8fdmt2zBhlu
C+wQZBGa5vrV6TBBW8p1o5BFkpCBYy6RJHPd6WiW5m1HgTlAIWEfwYxVoC5LU++N
Kur3up8fgaA8/lEHl7BF6BnCDwMhmvJeOnbwIDFlpqKZ7vVWAcAi1N+mqh1mkSjp
hTx7FgLVIaLIIBbwm2e4zktP6cfXt/yVl1CL9iM59Ib5qS5vwOHRGcXB6EV3akfx
Kua4037jy6qQvlfagQkyX2ky1Bpb+MpjF34X4GXU8xWcC7hDeizJcU0HUg7FR7rs
qzBFRjoR46dCn7/r74xlt7FWSUnApjubIfrnMM4VPV/9QEm1wCCHGsrlGeVNEmkM
6TB9cfhgrVmTsWsQQoLFs4+YqPYPhRykvwsE6Nc+zaDXOEZAt98JCruXULMH89/J
w+GipcjGm1FbEQvvd24MGVJpPyQlOAJ7piqWDMOut91a4f/ooyzSkQ472kmp6tvg
sjAkgqhCTsZevWpOU6y74qjJ7C8CxIBl7rHIskFrQRY6sZYzRZ2Qx+NYihtSIWyg
LcdoP1NpBduq54N1cpS6/ERvg+r3qYWW872BbTLCriSRnWrpEPXdCjFqUyNUoCDg
NbD/YqMhl44nG5UhxTGCGZxmP5ZAYKOQqhRSo3hAPXJNmF9mXu39T9YK1q4zRDUV
7Uywh+wFtqx/pnXkIlPu/nkheFX5vInK8J4NF3W4b2d+lj4u8lxDOHWrlJz8h/6x
obVQg4RtHpC/mWFjchaU+Ql/poFv8TG8YQESaqfoVP++nRHNDiWzWPowvkt4338Y
EfMutx69GKS/+DWOEHknJySjxhLy0yMCxOnOj+wE6/0/eRNXbAYHVIAn4ZuktVZ4
sMdNW6/T2FxmgnhM06/kNFC9tgbBpbNcOMrMUgiMvBpPFHqkROT33EfInryq/XBG
Cw6VlBx9jaCFgDKkAP/edr6SUfu2ffenag3iJcfuARZRPS7ZadR2qpAGbMz4+fSw
YHxVLcqOW3sgtLx/+8ypTzlJSG2tPj3qkgahhI3gfxiDNOBY2R2T35GkpTh3BT9k
EvaR0Gq+tpb3vmAZgjpXQfS39sIWXNIMBIcX3uL9u/kM1x2gqLKD1Kdm7LAxQmCd
1I/3aXEcJf6YpmYIfd7IEsZNrxN7BPg2m5rtifXZSUOg7YFHhXDwf58ctEmDIDOO
jDnK/wyMjJoTYzM5tdVWzS/wocGGKLQl41QKP01xp6Iq1dceNeW7GXpBV+/ttLh5
XA0frz2UoF1kIFQcVPHYV/SUB0FRi7U75PDj5ABkWfZEQahTMdTiJThae+DaFcl6
XqRpqBp763YsxsaaPF8CkgB5z259QM7lZCEMjNdYYcZFABb/hvqjnRSwYcqHnjA4
9k4xMUWPc2ptSzWe/RiB5e1DSeuHvdtS75NmRg7CsSLZMhlCCyt6VJaU7JvklJ5L
SeKfbQsAP2I0J9FcUVmltkvS0rQyfPRb/DRcYJTrh+YiT0+oOKVvi9ZeWGCxdS5J
wGEz5Nf4Sg8X+mnrROylJjR+lAG/VeAQCl5Ythz58ktYaYMG7fPKkbzuboBEj8j0
xunErfnQASIo+8k56gNyESJ3tT0xjtwMXWG7GyK9OAL4A8XwPR+rn5vxPTpLcM95
q6A7pYG25rjewqc2jyxyO9+UpA5Si8uERSPKu/C7U4y1rbbEhGycfgpoZ9uhYrc2
LZ8C/GFpdLZSdd99lIXfR/FuetiLxdeh5xcAtMOMqXTUrKDCdKNbgBrZhWEWifqW
o8uSFf4IGK8Kg+9AzIgxdpXVvS/VZ/DlFikqQ8tPKQEnaaj6+SbU4i/0RLj59XJZ
+jf79GS7E8Ug2VDvY93IfudSPDFfiGPryl0VzGL4pO2fUJI+JhJudrQhh5zyw10u
V4qt3RDPFKINDxPmM2ZXLygoIXoUkoX3uzYwO/SA/QZuNIiVHrQBDJnQqf2oEBjg
cmjct9Cj2iGT/G1n7Mt3lT7xIcL/H72zjqVox5Rg9vKrOKWrOXYb1oEHEL/lU/f/
v75v68oNbv06qfVusIYVSCzVOwChUQ5OkwEQe3zWwbhv0myl9iMv7yK1dfGuxQYS
LQ988ZKIlOoTWiAe7++Ri5jkQAM3Ga1ACz0Kk9oZmxEEU49mj/NUcg7WmQ3oSu3M
pGhcOLX9dhNEeGpbMflsMAZO5iXQBxGzoVB1GSIffRRnzo/YfKNB+ExSMv6xbTXv
rsI0uDgUivTDgZunUOe9xUIVScTTIdZwD5M5DCSxoA+aEbppvzjM9RQfJ4HBsalV
P5Xys9HeSYZRXcMjHloT8NxXIwH5cLBclPRa4lvSR+ZTzb7UeDoFEc6V1B75DTDa
nZTffoy/nQhqM7o5Xglwwa0yMZlfQsHGNry0wCt+8GG4gsrhl56+Eoygo/lgktcK
GoCPB+C/As5h4Bi6wbxiBWPUWmLrbJYaX7i8tephWezEZxahxvrcu71GdLVEv7YW
lFJFszGm9ailGdiX3pzhkSJdcn1pR38FERX84XvtacB6vUDdsP0MfcFyPDszaHse
SgKuGHw/tDOTrinXT2OMKWuONT4sB+txG9SFn7/yiN46rupEGmW608nCAY+oWt2i
YK8eF87DKyyyE5Oqw7GCtFql6oE0yTYIHzhKyFhRHffEfzrwUdXoBPSlds90OpaC
SS125TItMhd+9UDMrzeVtuhfklL8eEtE4OoVnqJgddQpadStl5Ote/71cemy57Vu
kaA/wopuJQalTzVE5HH9Fjla2nN0n6wx80qWFkmUUaC6HT4PlL0I5xUMKxWOnxL7
8JsYOLA68noQkq+Ax9i6Ol+5s4iQp2KCJJaT/XQupeOntwtKE9V/kFDxPU9lL9s/
fa87FPkEkuiVibsRmWjhliNbVxQuMhrrHhkTCHV0GEeoBWh1G6COG7/BGd5PRgLE
qvzTdp9/QDii+maU6wLb8Af9jh0hBKXme70P7u/kowBGrPPEb0chqdN+8f+yDHj8
r9fLNtfg8mE5rpTlXUhylZtpzpwb0cZ7anrBe0yl65DuK1oDW7WUTH5LPTAPVsjT
dGjjUFAZoPWlu+AvNqejLsIPtUAncd3rliaVJnln77rynb5VekQLC+L41ZVVcS+p
XMEEDqECH6awg4Kjwil2EPrLKUIiCvlxd416J8q9n+r6Owk0Q4WRB8eUcraaPWT4
1IqsMWUuTsdEoDLt4jsIyw4kh0NP7wTVFFaBJtRVSef8wyKgBhTLFXPjgm+b7TKy
P+uAqj1WYC+Jlemp6Oicj9Dlgza/PJaBQQxJqxuEYT5T2uBT2Grcs0Ihz83JGraf
Ba+tl2pCCW00FQ+mWafQ+lJB5VGj55LW893JeweoSH9JXCG8kaH7ja9KPZUXUhYV
NJ+eMTKHAhPJczzfKqYWZChs6gRiba6r0EeQkO5KT0OVmMRGrY0WfVDNVUSfBhFq
jyFNi9CBte8ENCEbn82PKNnjQ2oQU+euDDXuND2FeMmtTzk4xIEyiz9eUUiCXELh
/tf83iT90S9fHU5E8NUVup0YZqC/z3XuGtihpsun002+X65e/cEIdKZFFH6hI0Tc
gsQEYMQ5ZJML7h+eThIDM7O8X8zE67dfrZsWQSCzRFe/49wqfoliTqDsFoeUl3em
jQ7KW+hr9rNlepJixOrLOdKcJLtTWhf204fX+SOLWLcU8pkoBlFyJh8yCU5Fy8Og
PgvOSuYqy5z2OUy1icdPoKGBlQtxt8nNWiN+AyUOgvsXp/thZvWwngRG7NsNrr49
5OyEdhuEM0UoV/J1fm+raL6j3j93K+ybkL7WPqukaQLR2JLT/K/QPWh6R5Q43hy2
/GEN4TQd5Jo7irMveQbXFE+u9XVROxZi80/F3zFigUqLalseXIY9OiYSHTUC21F4
kW++W4Cdq9IXPSSO9VnBHR0rH87NRMczrHi814vhwRYoYYSJKqpK8EV7ULCU80xO
TtZnyjvniFEhKsNjmRPI6jzDCU/Dl/8pzU0xXAAlmBoNGlzOpGP27rjxfqvF0shC
y72aKjEbHnxc/nS59/8k69WFPRnwT+3Kh3Fm1frr29LmxQ/CeqSHYMRZOlbVLaOp
OLJKCvMyT/PPxGHd6ONU5YnbgrkVX+TWEfdBzchSbVGVZCq25jRxlKuWncK1mMA7
bec+Irm2urWl4JRJhaE4sxlVSxxMHiVOv0i+Lfn//O5+ZFmIfzX9wrFVlaaTZ1BB
6kmOvCTfgP2aSgWOGz3OVLFlHJSdHcSi+tAt/nmZz3b3JxW9MJfsMYDUHqS3XUyq
AtHzJ6yrPMM+dq8HbYn9CSsrvpfamqw9sNk5SrENd8ogqBNwpoLVhbLo+NAfkaHE
nQyCTEFp9p6eV5+xamQ4uFKlePBXp8BeFKkwR6t2qlejbrj9D1929VBLi7t9Y4yC
byxZ7unUwAU4A6evf1BxBqjX3r22Qb/D5hDceCjwEjNxNxTqZ6IuWDiZkBfmzmdh
uzCxhvCnpAeFdV8vlhAzyjaPfJU10W8m3FkhDdbyBecxuIfGpMb/3RpqOgxLkYjk
VO39hA2R8zcT6IToYP6+3I1nJpFxTri1mFpPimFvswY1l+RANVGqEkwBDo7FpOYG
LbVaBCjLdx+iaFXiCt07WQF3jDW3O8Ve3nCrskH98n0qSpF/ka6LkiAzJHFtJFtS
usyow41J1M1kP+nRIDd5xOSEEb2DjiFQn7Tu+UQ8b1/Jmwz+84zLqbC7kUYP1RiB
hXVkct3NUP2UgwbgBh2T1cNUlcsgYzM5/zz0101j9KlBnlZh8he7In/a0rqwx2Ep
1ajy2xjF2BdlRJdT7r5PFRYfD9UAGtGOQJv5HsLFhtirVa/Vtul41i+6EK109MWN
hdCIew/5AFWfftiax21PJFZ9wayvP0+GAi1gO4KUP+Al/MjYR7cXeThmp1GhZAWQ
u+mdBxsNKdJlSyF19AhtEjFqJANRVekaS3RqZtVDNcuBDRUufLmQKzVeYDLH6NrX
sS/vV1WN3tau0ux3DES4UwXlFhDrYE6BmKrgTjxiBxLsXFhN2V0qGfFNzZIP8ckJ
/D/jvn1XL49Xf7wXTxsfu4RbZTcoCvL54sMExsOW3gyWlt/mQXuBlZ5BixoPX7Ux
DFL0OV6j6nh0kuPiYaKiZHg154PwUczDgOQyEob0XJMCY4llYB0KweufZ9dRnjpH
6YlsD7cx67GNdmmOehKt0sG9nR9LUaKdrmM9WtdvzjoyLRQ9o3Do9xZTFK88aPBz
R5Oc/sybMtyJIch5tuVEf226qLEqaP0PvH7NZp977pl1iIjtQMJ1jZO2w5YT2uIr
kgotEyCMzPYgHJvwffSZQL/o0plVQOv60iGmM4Owsl9833qGybKmxhmWKp5O0lmp
h4oVbEIky6N72BfaybTS2LiGUauyn018nxQuJC+MAemD9tdXMdcZ6a0VprfH+Eaz
PDBoPh+FzTOkKqn1aFduaV0uVwr6pBkjns546qQw9ZJNWSLd8DTu8DHD7jHUuTxt
WZaqGoP0BGFy9bvijPpijYkKbuPz7AzrSHaxmvZLyc/vWFk7v3imbXettqzkdeJj
EfHe1HOria6/o0JDoin/c21HAZ6mU+pH7X31rjbckrIiXoWFK27C1OCUsyhiX0SC
zAv62SXFE+eO7jN+rCMzH1PUo7l5iFjBkzkzjq7HyibEQx0XMUAJulUJwfWqJ0Ta
tH1aftgGa9HjZW6DTPg7pij3chgR0e9G+OyvYVLE00NgKyEVlrt3UH+uZubURsJ4
jOktsOgSIajChQ1qkPQN+6BA/fI6LFzDxqA8mveh1GSYLTkUx8Vskdf00J1kkM/t
flfzxt2UhQR5ylruOJam5UQOqhR5dpn0lQgGN4Q+4qTAySNwH/z1QXgcfvecmhXZ
IFwKzJmDhrJW5mNb/N4Xc5+mc1CwwPhPKyG31FZsx+GrkmozVJnUJ0DC84zyUBk1
35T7fUwxPFLKaa+5cf7bQFAUYD0JqbckBbnpWXIx7lOq0i25qV/Fi6goPOCqyS5z
UWhe4fPuVooZMQlSc6+L24owNQFO6SWss7mshB4hFUWOiRCDru50oiuNEyBK/6Sa
ZOhWxfExatEoAQACTpd0SqRVpUONmfxxbgBJWNkLpuheK02H7cr7x2u2dgMmtdnl
16IcnTkmw/Dry28kkuo83EuYenZx/MrPsMUNsLBIBqePmNZomVa9bWqMdqLKf5Cu
Lsk4SwIHFdzGJNo2zgIt4EMmTOysBnNwYykoJ8XfCem7KDx+PTnmE6cs9COVI5qt
KdiVtlaR6C0GCW1Cl77mosuBZG1YeX2vFCLZ8/6UF47+u2fqJhliMaQjZHxnMbCN
3iPckeu24iApeQW7+3QqwU4JzJRIN397Hgn7Zqe0IXWwk+K4JPc8SVYD74u9bQOV
bD/kjfHyI+GY7U3LhrUFNybhoGwXVwPIsv4lgIcgi0JD80GYis6RvQK35pOEyo+3
REtklDmyEUXjyiVNMsZMWliab9oL01ue1ee9vft95q0uq3q6tw8WtoU3EGEkEThn
lFUWmEWmt1c+xXFzTEAgmlf/3RW5rxj7RQuvIyu2NbA5IjPRBm9TYcCcHpLTix8i
4xNFwlI5oo/ZEAitkDV3hARFjY5rpRp/4JS341x4gHu5xRd6aFjqBQ7fzMMyb9yW
Jtb+a59FpqA9p8WL00NxA0WIfKWS6f3IsjbHcDgvjSmYjmz18w6wGXB4k3d7Jmde
E9cL08/1Wh2L+d3tHvNtu+JmRwnp1DvToq8O84bs7YW52uy+lw+sjJz9S6hr39M+
DYKmI3RCiDdXFnNCe+sHUxOxWdw0Y3mOQ/Mkp/rAucrttyGsRGR3ptlUuCXtuJsM
xoMuck6uzO2dm+qsfPko6/XYnH9YIdvIQ0tjZIcAZBJ59arnQ9Fh87SnzkJqu9sn
4uMQVu8fc0rRJ5lu8I6lvZIL95QLeIrTi63TdiJQM9rWT9IdFYzny5EDuTqbSgCn
8xy5C6SOWkUumR/fNIgfJxJ7TAWKc4HzQgaC397bZDw5jSTNY+90Qr4GavBSbnGC
rDyj+Y7f+16P5v6xSqEf6KVX38GGvyq4Y0ic6FoANGxyi21HD+6KZZbZjkQNml2P
42+bWTjtZ7EiD4jWV0iVvbRHCgprBykvDOhODTn6A5KPZKs2zRI8J0hiEsyPfpXQ
nHB04oi9znkZfM1dfH0aWc68Y7oUCtWaOh148cNJt62Sqr+bznY8275XoMUdvt+/
Ycgax3bxi3QejTfUyo+TcnY+jSdTf0ol1UIM0xkKRxM5vUdCiLuhEMmLPoXNZVsS
GPvrFlAx98+orqtwUmPSOJ+HqIwr1HfdSH6twDrTy7oploXhYGI+FPTWF/g8XELT
Qr9ANIOFnTRYkiRr24jVzBPsauI9E7vN3i6qTF05CCnJy4aP3s/h6oY4ZpMsngZw
tbbXNPEcWTHPia4slR2XDuyWukxReAMz7im5bin6v/qH/2r+MzuQE5kJrNaOVjjh
BJTN99wDQubhjZNuBEO+PyQymu1DmDgmBst9arworwSthZgzqTXH+mGwQSGR2Li6
mKWqbAYMvXKHKiwWBBzlcfmnqPTpD2HLx1Ndupc6lnoeeuM8pzBaWyp5YeTeUU1w
UYUbvUbFn1gUD5jMbmZFZft50EZkWoh9YHJkGQ6+id4la/nsmlSvKWfy2x8kggpg
dBy2w0dulS3Cmhe5La6jViL5EgTSb/mpH2G/vP2U5SD55orVHSqMd00OAJKfCyk8
9AVuO3N5EXnlP8BSjgWv0xhvWJRr3TyFDDnaBxeZi3X4pOlBl4vyWDedicUdEx2V
EjigfUmhv7fN2r2mg+JIx9irSYLE+zc5fauApcZlk1WHWep0iHvzmXxXDwikzTL9
87ZOsRp4iTQxDPRka9+I0mntXfWAYnOjarob7twShe2xo31IL4PWa4GZ1XEojfKj
tYotV3aF/sFwGzEgdKI+8KYsxGPjO+rySPI3+94XqGyzuqkU/u06zFBrkLIWv8ip
y+32o4fObac+KDfDJq897imFhAvjqZI1Y3LJ7JTiZzU0BJJOvXCJlyYgfXlX7By4
PMWDofKHskFVH5T9tMwPPjDOi8O+0IhmkfNag31kiXAom81EbJlgwlT4dFI2X0gb
T78HYagxlu9sUfszZqmwRNR+4v8WepJcMgexwAQ1dV/DMO7CVBfshdxBGt5pMNBA
u6+jknM/w6fG92unYmZw4aQHT1WSq69AfpUr4+Y4Kpg7uPSFk9zV+5SHzMQvS7om
2qLGiavYZ98UD3zZ2Xj0NHmk85nJIkdQNjWvyHB9ubOLKzbK6nFTDemlOYPn4Ln/
JUq4KWNz0ySyHNdB+T+MS/PliPQrmbc4zCp7ABSGw3q1d3c+9byhbV3yztmE+GVb
06J1vDF/FmVvuVm+UO2bUUESN2UB77iFMAmbSVg1gcV8VjcjWYqaNuwkFjoRrGAM
TIAlgk9m0OV3nYVI0T9nkJmAR7o1P8qVMBgEmi1U926+RvvDj4ag12bucDmHyY9B
LtlTOT2KWQPA59vfGsOkAzx7UZ/phv0CqAUHVxUgfUaNUIWp7a098VR415kD2U6G
fU191QvlxznthTjxrsjKVQli/1oyS+UcF5LlhUkaJfE93illbdURN+pg8ZORAghT
jz9lO2WpR83ruptjtpPrTRG/4rYc3PBwVdfCoxjEWcbBRL+AOa1MtXYIaNBGPasX
P+etkgT5ilxS984Kc+VMFeVK8a2UnyIHVvBQk8E+FSqPs31RxQgf4TFlCu5M2pHr
/dcE1WPOUWwPxLLNkLXHwNCuOVDn7wY/sq62mQyaQuhsvGANihmCTjoSO+sU3BZv
IUbFljY1a5ZM3YWBsUiB9XKG12+XaWecAEu7R4JHBzitbg2dcxicLqjoS2ftGmwO
HeshhaIXjeJUKOI3+JKpEjvOuuio+9o6v33ndLHfIdrqjodtuSr9sCA4A05u7s3S
pzWFydDGTuF5iKHfZUcG0CkGxkjIQjaG5/ObR2vSjRihCMlhMm7NEpKEiCsH2aYk
tSvJhTxN4tM569ibel71LfwPze7+2KWmIqlEM+EGu/q+KtXMYD9V6rBxMeqGImfu
bCfHohOJpAmrKp9xwpzuAeg0XRLUbPQoYZpJjuU0B0PgccJ/bLlfjMMEQ4vpK4E1
gveXB7r6QMzQpE/j16amiQ5dXRn6bFJ8tlVuxBBLVF+oBtYHnyONE+LUxF5esA07
+RsoHch+gawEV2UO01UzY4t/WFYDNXp1qrOh2gtODmYFDJWbb+dTZJUCOpJ0cocA
N4gLLpoXGxwh9+kVdMcc8nKgAFzscSqkSOEUuc3iSbEEGAQrzP/TjvULdbYXKgk0
co+/tKNefMpiuqJcRIr4kbYdRP9SBbYBYFYbAzCLlDpvL/UeOfYgCA37YA2doz8Q
qBscK1lUz3ulYXR7ZPxghR+gNaBmwlC/t25nO/0C+T+wISGcIMU9pWn2GiBuXuM7
hAAs6iavXa7LHdPVc5ZZYHod2w4/poRvFOLyNTfMpZ6/HkEGVUl1ZUcnQ5Az1mN+
4HmY9VIBHtIIDESnFxtfA0rydvHVFjx8W3qRqevJDrkeXA7nfdfXIyzkKvQmWCwK
ziKWW8yWIgD9PClch1D1fYmb6N0ju0V3wgWYkYWphVAGFvkcshin8y6O36ixHI1u
H1X4fwdHRMyjJj7eYhQUFFXcuMV6OT6v+uzghZ/I8pbjGVSf0JmB9hwQ2qs4ZfN1
sFqYJaZ9za6dgVHI7ZcmLELn11Eppz/AjVVhp7zmTsRwsVX6beV3QB1RBLBK1Pbe
UQ1cD+4JqkvPu6+Y8x8LSGmhklZv0pfi+UJHm9wqRplNdcTj0QZ76MVLnpfa6atn
lqVE0fTP5mJ2lMi2Dcc0fHKaO0v8OseULdqIJ5youEMey6+GNObiKuQeaFUppkQL
bwDQ57znUtzEgP7dqWeTLCe1cDfdwy6+LTVOvLpx18pGuSAADaEkVBdCzA4IPTgm
n9qecxaFRjW+KLOGzVPuMoDDwDI1ikaE8rjxNAtbBlRKxJCQ0mWAMQKEeziZqESe
XtNG0vMfFHgcRuxP1aKStc+iaqsj1t4mkf+d+Wap16geakJ0I2HWRsZ4hNA0rGjb
iYNUq9fjBF3fDiCNEK7wA+rPX7zrlON05DvcyguAsBxWLgWPLXche4hpFxyvqgi1
UJYPrFjFtZkLl9QFi/UuFB+MZwgj3RwHIhB2j46fewLFE+iU4UtE07htQvsp7Ruh
2OtRBEZdacJZNZe4xHAgf3pT0SVxc6idojAvwCGIjLuQItZvZJQmzeIRCsz1/xp2
D0FSlXnVu7DxljGFEq879laz8bYIVMfXkokKDWNFEUyUHJZrTjq7vtZfgCNebO/8
gla0mv7cEn0PK9a1U2Hl88lNFCWsRXtB38cItq1YbnUSB0ZJB50oGYGyXcJEFN+n
1k2R0J4kNSaQLyWII7ifq3SbfTfFTUVQSIwXXWmPHiEquNFgHd1sxLMs3Dxr/cMH
eDJE3js6S2s3Yx0idTnLFBkrxWisJUsQFlEU5+o7seakV+lBisGDWQM6WSDYVe7l
q+SiiEpIp51BC/jipV6nIu934Aq3XZgXWN1rxYbjG7h1UNuP3wdSPDjQjEMqjDwS
oWkMdQcj6/fk2qWvF5z8i6sGjD2d4VF7Znbe2JT2XOOEWBz0VzRsts23BkSxiSnn
obksYSYN+iIMyJUq1lDyuLF4VQJ7Df+Q2z4iLfnwTTcGK5VLx2N5OTM2YyFCqfms
BKDtYthStsV8P5kj/w8uotZI2ZMnJnQgkhuXXR61txYHJSdhYQCvvAb8RtePWpK+
TaeTszgbPNA1wc8rTfVR7IDvPVOSP4m8GytxKmK/iY5/q/39qImzNLf3YSd8b50O
kPKeyMcIpt1GRDF5wWsNark3A2Z3fC7qwGR312DxcnTHxnls2LLjbAwuxPKXMmhT
S+XJ600lQJMwnM4PxzT7c+TrKjxh7ZFuyh6FTkCOZeb49ycsT6YusH9fYvVTGZmE
JtpKuQNZQKy7WNTTfrfVHiejdyv4svz7aWqs/HVVX9v6SH1H37M945WUCMGtsYXC
mXgsRNstiEEhrKuxi18r1DgHwVQCm4BYcZHY2G1aeGNzTWXkkwVlRZd27HaiO+dS
yd/cQ4+TK2zcOQegehBTFxw2ATsb4YeEdeiT7nE7jXg6KsNffn2qCaoKoUlq81bU
r2z4Ph02jsykx2BqXwPnWOfkhRyMHU+wDi0+S3Hr5nJ5beom7wFj+GrRlRzSqpV3
NUNQdL1q5cvqbNyQAPb+vHKxvQlvbhDMYtHOB/qMLe2f+0sQRB839xcVka0hnOkO
37+PND7gCQg7ShMng5xUQsp/e2CvKsd0mRSmGFWhvURc7KR+0wx9GA5uDxRG+WQc
mzqpshyYNDOJ/ZiN1yh2kYlUrYzb+GRdN6+Zxb/6cr9ei0v2k1Vld4RMEH9yZ2xn
s/Jdy5S4v0uMEOAIz90JBbTXf309FOavYHUcdWaXBWGwY68dmC2JpBlLTRB7Fh4G
US67QstS+ct6y6KQhBEs7jyJY+NiWqcbEGo0kSfK3AWkEVB+tuKcI5Ft0kh3JRP2
Cn5OMAIiZg8yXPXN00xTeEZf0Ej8pFnWMkqvJkSBTBrmMCGHYQWwJ8NtLhtf3PJ/
zjr1tALhJjTXBNQtN/KDXtNFOEo+KeXkd3nY0DugOQfhjjJ7YA41MCXV2UhgNHd2
ZlR7Wk1jD9S0yvNIq67cObWe5igdmilFyR6Ve3Je16yelyzjenYKIszd7u381xBi
vFPtkL9vSGAjM0QQt8vCENTfBBH3zzBcRVUPT+v7cXyw90sL03TUCoQ+FeOnNq6L
h20G549Ori62JpWyH4cfIz9VRiCQZrlJBqxNavMUMe12DsrOTUKpqMnVZUShxCMQ
BHesMSVyBs5t2cPn6NsaBwB1iq2OUXKdrLyJOJ5QHddKvYhbFNN7VzHEuvtxG6hB
l1DQIsncQ+u89WJpoCFAcU/9z5m8eDuOVSFrC8NTi3vZNrpu/a7NGJDgOSLwu5vs
XcRCJK1BnJ5Ezi5L7db20Hrgr2Hx6tpsGY4G3kK1jjdB6zVTvBfSka9VaHwR2133
DhrndMTjuGeODuSlJFLr8sujh6j+5W9XmUxYRFWX1MeqBCcfyTGmLcdpmp3Kp3A9
YuyMwlEqfZJ6TpGj2xRDFoOjkhTPknrsWO7zbayqlfxsOeJT8a/HgjHSOmlpiY92
cJL2kgbr+C+JyJ0XtE+sg2wl1/JcaVeRvdCajtwFWvQF47Ns21hMA0IUcbKCo2lf
jjZjHvPt3gmODLFzl8TVdMzgMl/dR6tBkVgzsaiM0gWG835B4rGHewnm4wIEui+T
lKqXGpZfDVuhoQLkXBtHdwZbTVYhjeS6QDUbVsZRzzOfGAiRZyNlNMR97EdYn76V
1khBwOsPc6eBulk8mAPusTm6QQ88N8An0ch3J07eZ2LSBtlxSoxGPYoVV9wb+lv1
FhD97kCP4mCkrXtQAEytllAmc4IlMj5dVEmL0bux4hWYWMt4tcpadf2UzlWOdgBy
wdkTd5Ny4c21z8c3lZPPcko/gt5eR7tGu3xxCXxWxjgm2j5mVUZ1Uw/9zi8GsaCC
RnU5vCJtDUA1zYZeqt5P2NUGMDRoTCY1BxSHIOT/yGaUq3ZZ42qfUbAUr4gbbYlM
oF6i5joJYPBKrQJzsI939PLpVA6iq8v1C7EE0jANitp+o8yNr4zRl/go3SbEzNp2
nAvjaJ0MhKRj8bzSRF843IWFeHyAbG8jBrUaz3OUWurgFxmEgNKYe0WBJvhI4QqY
VuBw9ASp4ZIEZsEufl8NZvcGA2FQxagAocMF6SeoQShegh09frkq50c5OskOrVaH
8cq2uLptqRqu7zDYfmQdpqDII3Sse67rOH5jyPzgKay5Qvj8tbFIzqVUE7Hmf5sM
dfBLE3u8lLvxlpZFe3PdO0zVLcxJUfXKIZ3HrB7F1Xeq51Hl+4ubjGxd5mIViPEd
Ykf0rapTQjuHz3PcW9zydbOO5da5tVCY1hW9S6liCEMAY/9NnmbfIiqRP4wVvY9a
xiHfGnrnSxWhUAZtr+/SHNIXZbtjBA6EoGXKGnJxK0roXP8MbgZNYmXOjGsZcAdZ
0ekPIe2ACnr4jbD8fZIWvrrG9eq9zCJLE5hU7LDmCzIrI+r/z0PQLbxjDPqjETcl
FfBLUqqPZXzoRKj4MqDUE9xzQd/qnEAdWAHR/xehhKw4SMwF/2yrVMfhXJCSCFKS
oVH0Nnc0vyftamQLXUuJjQMNDVGtnsYOYb0anqF8DSsWIvZcXMFTHQ0clb4+upEz
bu9ZYlxmbabXnO4/1augYNi5WmuAVhKE+R+cNhCHdFr9BRqtWkk+lyOEu43xBNgt
rEYqCJbfMuPUM9IFV58EbEpE4GqWOwFcxNx7QDnJBEeTfEejDdW73w55GJhD3kFd
MY0expP9RhH4IQmqWLtiJjTYN/i5pNH3Z3Ec5QxASkZn/57LbDoh0ih4aJAdl3IO
Xy4NgfMitpmhyQ1OebkBUT9DQ6I+F07Ciak5PFktICNJahWHoM/fNVcNFNuKD7lD
cim0ubDXnsWgpocjQvuseWu9HXpZsWw/7gGGVtXMKn5UDQKVn2Ivh6D1/rgt7uYt
Z69xMomY5rl9WE0zcm5RIaaHorfJAeJLjcf4M9jf+5aF98lMNfOJ4bpwp9QPc+GG
FEHTBTV0vxDewq1hxBIdzpwZPwiqAlqNPkktQhRAHj6scazpdX/zVYPbl8BN0wXk
3HsK6eIdwRzutgP8UpqRDt5Xznt7qSjdPbmXiyGIvLxheXrpWJUyarlFLg7qpjTy
Tvn2Hlunk7biHXwX2OXZNMJUzaLtLDq/Mkf5WIpvg6W715LigtgZaF4r1xXK6MCx
XUg+pC0ozLlK/tdz5LTsLD1pWjpPQbvprwpjPAe6A/s+3DX4DzI8IjnLZw4KYTKv
3TgP4HEA24mgb9iiC3R6Sby2REhgRGilynoe0wNDVAyKXuHWhZr5JUp8vORDS167
Vbnyei7h3tDoxS9AErHe03kjKLSpdMfm5Cx8M3FSW40slTfGDsT6QPErIT+H/uVR
6eeaQJ2NSvOCB2XJaYbBRY2lajjK6LYl3cVNiTMEzj2QAaxVRx5QKfgQS1ijqP4S
DlWco6AjlwXL6d7pgJ4kEbHE0w+ivPDo0P+3xmBcq/93Rmq1AOZ1cUflcuZbBxz7
V3To2f0VVc74BRE3XaXRvywXLBa6mAAJk+Q2jFHn1vmGybWPLgT/GQui6ncJVWzb
esatdFJuQ3Kb/SXlIw2feRjB5EY5OapODvY5IWzeusH2x8ptUrP5sdmmLPfM3Xnt
fs6/StQVjyHUfdJdzLnmU1l6JwvmHVC4VFoZrU4Tae6cIbxjkiWGiRShXHjNtJvP
DrVnTRFRUucAXUm30yPB0X15BiixhAGlfG8Gk87W51JFQydYbFCmgjHb1l7GRPsR
LLY50VAsYVxHrAsT74bmQCI3sRDoNjiOM+dethrZzMHxbYlRELowyS4unGXrAeu1
2oKZgk1xAZaoETViCxsmpR/RD4FuqHkL6Vt9viSeuI4qESAYUGDJWrtmrR/J/k1m
9+KqReu+7Bnf9K7jX5gMedBmw4Gsslglo7ytuKvXhJJRrh+u5yvmFhunF9uSTtWK
OU8BYKnvysI9d8pcEUWty/kRJY/ioZ34u/l08XBPI/5NYGHyKPH1x0XG4vgu3EB2
m0GqiNa9fDceOXBx+8U+bK9ahY5fpk4/QSpt3CtzJHwH0WvpN2hkSG6FJGl2Zlyy
t8yjgDPpS/fPjTO5WbHdVTNug/aMHgAyik4hTeOo1oJfLU3SEUWVZl580Q7sx1qw
X7wbHtPKNXw7Hivt+790LF1fyYdDsSx6GSlRdZwvLpm0w0OTkmswrqU8NcaDV9xF
2KFothcb+TRVCnyuAiL6QQahuPkJ5sOE8UKZdsYRNllToSEqMbszSA5s2N/6v41T
rgZJxDIASOn1unDYd4tRJNUKfP3KCu3M4FywUICBKnPl/1vgITCpVw6ikyi+pyyx
1UyUfmLYYrzuXa8MIPpVj2gKypFv+B0k4TzcGASIGzHWqZCVuYKYRMxwkx4B6kDI
IOmZJZ2/zlWP2O7DX6Ysb+/F0TOjqYAPRJssHNbsGcYskR1GNwQ56LEKKLx59b34
X940oj1GwjKaOWLWrtsJXuPuaSo4XsWdoldVU+kov9Oi+0afSjfYrJ8idKg3U8EJ
bhGB1qQAT90xyvoz7mjmEcS/Mlxgpx3nOJjvhM1/38jK78Lt6vGWZdxXAf7kcvPD
IZ7knW9Pg4FyR84PyukE3vtRslVh2XZkXtWDuk2vLHfsWlJyN1QbYE0OvA0OZRce
JKHi8v4895QoZ+ygP3g/EnTmfVlYlA7w/fkZg3O/vFGJOGg7eB2X+cJc8ZkrPjL2
0WQKiEFNxyZVnwzZke1aw1TlIi6IbOvKa3jOM24claUkf0yQtLn53mLCGmOTbvrX
Lx/Ecnw2yIMuBHgCgwwr/qoT2Va+D+xVckUDlweDfIE7NJTXG6DqwTC66JshX2pS
We1b9gl7okWHRYYpkS/aoO5iovnLMG9pG+2wEdR+CRqeuVfnEDsCLCJ7TFTWGbJa
S7EvRA3PdK8KiBarmTTylYAP5vMqtgumUviPR/nV6y5hA7mRhz5CjzuWt9n/2bpv
XpFVnaWs8bnpMVpKmxqQC94Z5YSaDnQAcvWCoovVS+w2fhn54nCe4iHhayA8R9XQ
u8OwZAvoG+vsNdKFWyidvdz0ru1cdUhvNJbq14SZUK8j7TibcnnBVG7m8PjDYooU
JrpR4dWVkk7CZrXDqxmZxoh1wOJfVQ4g0qWzzYyE7ia2D7NVqH/7BR8FOc69UnJZ
cb8cQqOCYIz2qHSBJfKzn1D32WQb5Ti+G//WyhZMYaNBrQ6ZTER+9Q1FsdhaQpeP
IBRdI6VBKOqHSn0I4Kl19ZRt9S+VRu94wtAIzlhAWhzm22tAkpGLq/J592IiAiv/
9LpRU2Oj1oXIktqssXvJZErCUB0FsG/rxTMACDJLWN6L95c3El5APi4WrI5NoICn
vPCl0kCm7i3rAhUEETyLI3xDu2/mnmnQJuSoElGFr/TjkhQ+XqFYMneO3hxdX5Sg
oOdn6ZfCXHudRceez0vy9YHbvCoaBXyNDT8SMoOO/UWVqqpq5k1BmglSlsTyKh7S
Lp+Xegp54dugO9uPV6r0+APHMPLgK2P1vQ9BekRqwNxmDbn6ueGRzMWLF/TMsnYb
/cMNcdOWu7Qey0AD7IgxtwVSAMu8xVt8mQNZBYK0qoR234q8YhQOj9oV3mGupcTB
x9tO4420pyrduNsp/Ewy39eQF7YPJR/pZb3HN+kBRxy10ndWWcuH9JD5ibmGibZP
HzC0pyJUtoyB8s5yokZ7g8qDlBOSDnqEeWByipQbXVnIwqULxbTgLscmZMgZ3wi4
hWEGPP29uMPCP0Hr+ZyiFAtZzk12s4AXr+FQ00wLunUyXwjwCdafnSDVZl/zhIDp
CJusQ1PSK0P+zZGsYUNPC1VY+IV0XUJFCLx/vt9s3j9XGaqLLFqdtsA7jY8J3lVR
Y5ticLeX0618AcutIuMlLdkQAYH+UWvzav0HRfdbCjKq12aHSEGoUr2dwaVWWJLq
358ZoZc31TTolxN7ciO8qi48frKwbcgS8jITPv9xalPPduVm+8vcgaBG/qKJGj3r
FrQ1mc/LzxChRKY075tqQ9aWJLR98/wrJY/e2Cj9Z3moO/Vm087aqXJhqwjr4Bp4
kAOWVDSXbYzMStQQfka/mm2EGsJDI3trl+tnHLRbM3SAj3HGiys6/oefZfv9/Eq0
L5sBpNJ3JAkksd1rX4glaRkCnW0gAkbcBatyHKhjToGos/inBrAEmrNGt8nIa9Eg
powTdqZWEOkte9fQcRXIJ7SVLWXwHseUu9+wfFcEuVvOz9a354rgAPc6k1hzdFIQ
5WkE6i2+nVG+bqgkhizaCxtWx0hn0v1Majs72wX9BMeDZ3Y4bui3e0RNE8WL1W41
bZZZ0cP90ow8XZ2KziCNakpsN5P4O9MX/dP1hRhrvncZSOGNgoqzUgcmyVD6DppO
Mt1XrUnHHDezYr/Hdx63UX4YmsJQS5PwYtTPs7gRK6p2zUYN/XOEfHiO7sqA0CuN
n3BRiugrdQ2vZBq4ns4A/mRI8OEdjG/G4/2K4vIf3zH5uhQ4eXIATXVDMZLTj7BF
lfSprzifzWEDHGf8/NXWjYvgiZ85dLaY72gPyaY+2jKFLJZv0I81VvsubZdhuAMe
RVwPyES0n+0jG6qkE0PJmPUo0cHZM0YtIfkqFO6IlVbFBbHosxtAYSUizOZE1DkW
knYzVUV1IIka/L9cF/L0LchmN1rJTKT9kZCKFs/zr1d4xZjE7qlErrxpPXuwM21E
XBMvqTI9/3f5iBILy45upGrstL3puOMgqyxjPWqj4UyY5PjCYgsqXHrX/9RzCe3u
D/nDETihHOPIDgUjg0OdKaF79V5aB3Hki0Vtbcd0ijS9LtiitwtzzXL0P5D5VHkr
KvFW+onXfTDUzqm1OAoRbm37YR97azdmbqUU12W3feYbhz6O4vSZZdMiv7ZaLi26
pn1AHE9e2MZMmVWZYcj3JohNV9uzbU6NhwT8NL46m8ydrzklEO7nsJgFLR9tBT3T
JCgRRHI+hD2Qa+M/qlcQtfTtGErZrnCGh6vb5rqg+QaDRDS6px9gT84xa3sIU6gl
2qm2reBzGSPbZgvMNLf17ul3a4QhGB69Tk6oh9OkYydhiuznCvQ1jhGikPfRNarM
mBzD7rTTpTKmpaipkRVLMCWETpdS8x97EvonbQktL+iWjWVTvrOt/WEkF0Gz7a+/
l8pvyFQYW53xj4zHuRzx6NvApdvz5AKlXrr0UBIBtdsQcN95pua+DD/LkmtTkzMA
8F/uOf3XqZtErFvjxYJwzZ9tnu7Mhazw7jurtxREwXJrStU+JKc290zH2fF8gTlW
Ye6DodoZpvQSXmdQEzoT8Ae+D9P0j7u16MpIV4wfundaANuXgFR4jcH7pyRmUrGn
VgdVB0Wc0JW+BcsgYVAqLyzPtKrTKjRSgqDyx3P4+Q12EpJmRZSQ+jdsWoJs2+1A
9L5g/YjP6caGi/pVHZNhkXT3bz0Cn5rqFEmXx9nddQGLG8lOX9z7mluwG5tWV/98
HMt2dyaEo4atQGDgMFEQgrSrhy3WdJHz3f3RZIWjTiqUAo0f4i5yrryAf6EG0nwG
s7JKH5TndoRWTiaenmZQ2X5vNQgDmEkbTc4nmlUn491V1qtWiV76koC9IXx+QNYC
b/MCe1Gqo+CNc/odXx2hWu0nV800VZKLJ1ropeR011Jfj66+igJyDR8AS8K3oNXi
VVRgvUv1unAi+hgzs0btlibIThHnhI0u4AKPlB2bS4p/Y/TCdoJf8pwxZ6ke9PVX
0etsfzQUKT8NcQzqwv8e5dpjdvj7IdNZKl6uF/9TIBEOc8hI89TSEcHgvrHnbEaW
Iq2l1KIC3S1refzYdt91ZX6dkcvL2LwXtcBbKfYSnBpYzbCRuX3Owmwer3+cRRAW
0NpcOu7lQTcBaMiAt5pjzP/YeMCkEcJEAA22YyAUfFsZ+n7LRJyr4v0NOHaXuRlj
oNOrGE6BDY/cjfk7CcbbwzP6Rgyr6ninD2WI1iQNXzk0E+9+HPpVMASW2SffHGY+
oRyuCukmUtBU7IC1WkZQR6BI+C49irTBLzOhmfZIlKjf2kxJGYG1/oDd6JUQxrRZ
uP6fGx2rFcVNfHFPIClDjx0lx89A4x7Qzrju2UNQ53ST1ZTxkLSg/lWpDiZrmnDt
a7kXtHB5WnA7eLo2AIdJ581OcfE7UD+FRLNN1Q5IpLoeZR1/QArk5qJsxJGrB73v
FGEJWlpIO8KT+siDpeRpYS1BaCixl8TIANGfZHco3+arvQdusrYdgi/RdDrfmfu5
ndZd4Az0xuW60SE6MMZKy11IYYpODQ5BzVkz1DLRLlBYgfoSDj19jGmxDQvlciL4
Sj5cQP45/XJSO7cY8RGAWEFyJxTRlNb3pYruPdmb7ehqcm1e+QTG2+rtFFIy160K
gXCmuRjVoGhwnO4ibQH5IiCUyGQvE9Et6TYzZ+trBbAIVQzgbXaydAFH4p2fvp9A
N0GL91KqrADBrPDZqWrboctCHAeDRPjaa1PfH8ilcyv03HlH5Pd0Ttd4Rj+v46vO
Ty3FLDrDa8MMctuSOjWGkfX7PeE7jmey7S55Z4ozE/u8SRJH63nnVp/sOT2hvVR0
Eg4eDoo0og5FhXKBIawflPJYRi1iD0SduiNREThEEYlTFuldOJsI2d6lsmS6bqpG
2dCif5yk8kdAV6QnnOK0qfvy0aR8IHtEva2J2bbMhPeL5DNz+N+T5CCq8uq5p6iC
f4mBwHRioc1L7AWmx4Ahvr5Q86nEoiXhgApP4t0FcXCHGKriqLcvOTGOLrarpgFt
OI64p7vd74MY8v/POVH4Mul03xNkw5r3lJo7nbbynFhtEawlzE28e+IvCkwy672p
ycht+E9yZSNDwRo9gYc7QKserbrFw17nhzpHfEC6vWHiJmDUB9+zZfuLaONeuxBM
5TbyHhKgxipUEIk0CWYIkq07s4t4imSlDL34dj+YBbh2Kt7kWoSbeT7mb0Fw+gzs
mLj+GJDvEI7DLuLiB/89670jQD2BOw0c6hJpfkiJPfI3x4EtEtGITzG4hn/Alp0U
tXMCkGJkvjDauJ9TlgIfb4Dqex8SFR/faQNlSPygA//5H10BT/LzQGbRcZ7yqyTN
MqWjR5Uvx0rmOCp6jeVxdOsBwXmBTYp5PtgiBrdqcWgzzy1Aot5FJxNJO3GKCikr
TSf+UOFmlaw9IjjskyfL4TBbXVkI5oxiFAKfV3x1KJU0Eeno0xvH3qB/WikCOlsd
C4xniGuGOotWRxMIuMGbi3Zz/tdrI6+5tsft1chnIG3KlX6Kgkk35wujb4IG7L56
L0wP5DQ9iwqIVlG8y1O+/Y43Ui14pYZG4Tn8fMdq+veQeTKfY29OUwWFcrAX18xr
npaYxXD6nPjzzKMD+U3Rnk100mihSpsXQNY9Dq/g6jDFG/+wbqo3geVYP9TK/IRL
g+Zw91E42/C2SrzayeBdjTaQ4W462excjaVu9WN+JkzpQRSPUPlhxULEYQq7s8Yg
n/ru/TNtdJCt03xCCPZceJplWO8O0n7vY0Us8JbQgJ454CouedHzSuXOGXDmyUMI
9nGzH0Lar3cQiGJHtH88zInkyEfCGrltZPr3Qvoui1ICo+17M21heI/pMCqvWj6Q
QCrxZ8GSPv9LjykUPz2euSgZDqpxCB+foRRlg+9YB0Xj9a8ONtgSgPACYn7KNx1G
wLIEFvPzL/q06b2Gd5NFfucZ8T7cQ5Uh79xHWHnaH1pCW8uDgye0K3rZrr3J3ZI3
O1eZ8cqb6vfCQclqtAp/NrSm+eMmyi08mCHv19p0ZHatb8/8T+nq3axx+oI3+Roa
VfgKmEHq7dIemfQkoAH/tkxBlepdCrYVOk+Y+5Pk8o26lC5TfKLVOj2zZKnEeSfP
SWZkMKscdO/0vvfNNH7ayjhYpDZXJVvQysGmC7JcBeOlG5MrS4frGExJi32s5rpY
mBd6twfjkSM+uiYRHgvBThi6KWb6aWp2JtbS5vhA9xnE0ZyfUsQh4i5VjuScrAOk
3qV7nVGE/HzxD6CDqqf9wNiXlT9mb1NezimFEILHeleMQr0ct00fyrjEyXDZHCsM
s9l6vdZsmAdXH9h1w04JAEGElK7ILgoSr4fPo6h5Ug4jvlu/b7hMDmnJ9vhgfLJi
alTaDyN0+ADFjnzGJNMqsqPJKHyawfaYvzY/OBx29CXBzR00eUsxOuuIRXovL36l
vAoKajbzRHJwGAk1wWXR1EjOUd8MnoK1XkcVfQpAX28bE4tJ0ldlYHgJvR4pFnET
2xIsdNdZ4MZtKSxHWz7XrSm7xIuNioQkDpiB5ku53FPkoMyWeAsBjzJLAgvOO7xb
OsJk6+LIhIToUU2a79E7aiUYjWEcoIKUYrXdrtqCNu2LE+9DauyJcBScUDpNUdOS
G8ESWGo+Rypkj2mvt9VV1rAPnt+iPIok2ldP9b+lpwtDyrBnJD1r/d7Mp8helLrE
RMDd1s9/D8Q4RyGHS5tWYrMRmDcV0s0P/iV43A+e0az/qRnQMpVJ0UvL7l/qCsVM
5nXabFL/IvJlMUtCQYSbcxJN9tq7Oa+d3CSAnGD2TmrBAHTZx0yeYpvwwm4rxtUM
Jhd+yAcGHF+XjSCCx3h/OnXNAdJiUvVYbj/hAKDKsqGs17JdTnFg5I+vFCdW7s9E
Xu6L4oYyUa1JG+kUkssadhX529A4Aj7Poa/nHUHPQzHNd4xj+mA6CiXFqXNgxHcj
FNVQbkpqerKpauMB5O4UuQ019SVQ8YF6tkgLlOJJytf6o791JGg/bw7i6EnlVNqq
G0Wu3IxrRsjENR4Yvf8t+oA5G9ISrenYCelecENMNJBD/h6vkLAkq/m/z6M9EBJd
gtlJqCxOD6QaNG4VvFg1tx6wCQumnyq6pgQl7KGDmLko7X/fwcY+T0jH/cTJsf2d
Pb6oA8R7hAqvyCiPMCQnuMtjjAxXQML9zBcAraMUoL3+BtneTIQs9haWhGy+EV6S
deoNVFlQHlndYJoVWjV157BLw8Bae8fmxmoL8qHJptBs2COoswMPymeTscp6N5ZT
FZGLJmY2Z2zbZFyE7IOpfpsUJB+BWpUJtC51seCGAGO1wottC0SUmxSSKufINGIy
NmjP6qJNLboVYVUP3tWXnFw3xaB7MCwpISxVb1Hlxompv53+eCEps7kO/6GZ9CTm
ztT3SICixWLXlkhrYJgrTO1pkCXIbHh76i2Z5mEG6SZWL7/M/1koPvuE9czesTS3
R50GfA6XwSHH5NPKyQhE4V+Mghh8usWwYOzU4MjvAo04Qt3rtakwptWFx52CEdLA
YIKlV7i+Mz2cRBVlnqY1FHTaFI/9LhG92315iRqoRk1nkhZbhNjsv76/bW66xECX
5fhGRKqX/8bSLGwS5zrSiHqBEmJT6oTKEH613G1Rkrxe9oiC0wR9DtyKspeaT/OP
P8l5DUPkOpzRK+QdxjTbPSjTMWrXn2faKEdn90z6VRNou92Vxn4YrWIudFWT2exO
KRL8ylecM/3Pq2wA8Toe7wwAOqZctyTmTImuLh0vx+gTBGLmz+sI5iisrnjgdG1K
Ox73BzZNkCy9kCocSKkYXWrzozMG92KpNxYvP59W7r0wR1EJUarjpKbt3exMiMvV
TY+qjuMvq3klC+iEsSD6vKzEsTbaP1sU+XNwKRxXdO4SyCwxsKUdsgmMlNy5A6HV
SnSEDi/8ro+XehVWnUnMt02/hbc9FWpGz0z9NBJv28Iz6a1Mfv2b32UA9OdHCki3
VdN4k+vzB2/hJ0pH2roCOzbISk3dzTvIIkW3XZT4BPe7jh2K7T8btj2f5MVM0CR3
3TsZfYMZYWrFV2ujRSU3LkRVqytO3byZZQ5g3i2PcQz5axqwdHF6y4GuNXNsqzN/
ZxQau5SxgL91AmFlAi0jH0Ini0/54yJL8BhtGF3lK+/CKbDGWVrwnOve33ffm+m8
dZv/B8wwuY32ayCBdAkPv2LGVccRUI29krSV/dBorfVcfnIKo9w8209jKkhEPTMT
UdjydUN1GVekN29GaY67Hbw7dT+2Ow/xwbSsQD+AzoEtBR9RaYJp9Bn8LaZA2y/t
tuttSir1MP7wjJvGDsPYdYqMnrWSAYWMoLKiB/Z+Us1eelkyP8E60e7W9kicQr6a
f0qa6ax/poqHKTKM5OkyZcGARHh4kEaQ+wTlIOjcPOGpU9aIu0l9md/XZRxC8979
kiUs75jrHg4dLjXw1zJ9Qu2X9YONfZqYmqHoBLeI1gVWohahafUJW7y7qgVdO+jN
aMJO07/65dMCFt6CNpH0s66Gt7U9jRCU0C/mPmnbMxUCQMQq81PX1glWqr0dUuvN
ubGl61T/5Cv76tpBB/F+GDMa5p7J/JLGuiSn7zu5V1ghOpqdIZPEEqPQu/7fxuaF
4WYEQMqIV91csBBb853uTSQidUFs+2+7kWGoInWfb/ij57x/+X0XEC0iHAFk8+hE
2gklhGQTbwjy7iGhcPAzauZdNG2mS0ZpIg0EtI1W1byAd3v2dekqUOhJMV711An/
16yRQzXpqTT1TJG6z5Ekcz2k1StMudiGZTf9RW9VVG1/CUFDgcxdjO0CXLxM7DDI
/7mVPD5IA6RykmU0Cah6myo7JgU9+KCVEiC8mL9r1OwXrbtW6lg7CvZ4QRm2S4lj
QhGK3ZdXyeRrAXUhBjI5D0cf3dGXkWLnQq7+yzKS/qu4j+TGTG7svWfMim/ky87i
NBmZc8URC5z6+KXhkGBIsOWZpxSOLJR716cC0aNdE9vW9JCXyrkUS/pMvgXHNFmS
qU2BZnImdXX/2JqyENPvH00C1mCfnD+gD2zNKmsSCJJvV8ifgpOb0u6WKbh1Zo79
VdtJgVV9IrIAGs0oerjxJbS0wh7xYkNnvu+4YUd6ab43vDzoKycEBDhlTTV88/Js
IiLYmQ6siiE90gt4gVnify0Q3HoiggwkQ+a6XIQl4HLRXhEqDlQBlvG4b89jBiYA
C4AhRdkx2CMwaHa7Qf9cr0aWqg0Mt44Jngs8D+D79jr0ing+krbrI0pP5+MK5qBl
EN7ynZ20nxkCUDZKFCgsf1EX2FyeaJIVXmHcUpaBsKklCDYEbePJ8AsPZx6Smkyc
MLWZUw+HSR9sY2i5zgbWbNWJlxKF+0QQms/nWGia5yLPsVksnGy7k9Ni0fnu8FS1
BP2Tff0iD/4T8zIEtSBuchUz20UPqLbkbJrn5zBM8tbp6GKj0Bv8Jpqru4/cNsAk
rd635o1J7c8FBmQ/mhzjVKjXkkGGvQwCh5ldanKP1MgRnT+4qGc66tyh1GRQSE1c
hmXhG/pHqYrFovclEOFdzy9NelDWJv7G6NlVPgdDb1f+BCB5XQAJ1zX+MVboWZSf
IudWf6W6idcLfyqeABw0S8U3I9RfbxfMayVz9smA3v4oImOqrH9v66nqHqF5+AY/
F1dsZKdFn2loifpLJhU6OcMv3oDwdVpcKSW7s3hLZETB9xQjklO95GX4xI2N5+Qt
n0AcHfOg9PFIvXZWltJo2hAfNL9YMMKjBk+MPbawZuXpp23lSlq4FcknL70bzO5w
I0zFoXZdgaMUI4gK/kJ52k9f14XuKGsB96KNF+f578OnbE9yj4QVawuinfY2JrqP
qezHp39iwYjlIpxrLfZxPfW6IonR1uAXsKG0gEkBp/maFFgPC+iGw4FNO1qZV8jy
EuTAz0Qz7/OFWx50PF1xRS9hScflWYqJTsQ+msr98fiuc/VjlOzB0m+BSlSZ1eJL
/xW0hJyhX3xPxYrSTqeXJVg2ff5SbruHKReR/u/gc7hoYeyWefEqB/U6DNGbv8qn
kFaJweubHqoC3WB2NC4tEvBk397DerxquAj334g8/APTAQjo0cLYvsjYdLu56do+
7eqWZBzvA9SA52L2z/4km5P29MV27oERwBRFX1cIRP42clENrgtpxmYlbOJk34ye
dapU1EVXBJda07P6tfKDqLtdlKPuCeqil5ZiX4ZOZUejt+79gBVhqbiYYrNePLrn
GDy34sUkUhwOFVacDd+TkEcb9EqPEpHiRSzh78kktJr6gE4w/E8LtDYmIYiwXfi1
MyDmpvZSj1RpXdpp+zop/38JDrJ7PR87EXx6+i101fqhGAt5qo4qk7yThyBwi8q/
jvGk5QyrXRUZ/35wkzOz2bZ/Vfr0h/kxT73scy9SW/GzxcpOW49r5JhulmMRR3tE
TUes42KIen3SsHRtnWVRix4tcFsXQavJ5qu8JU8o9XE2J+W+34eLiqpAbYOWsrEG
WK+1PZC814S+RjeCxLV5NVjotuhW0YLY+hKH/e1gU+JZDvteQe8mRr+HGKbbSitX
FSeoJqGuNzgWadzgHxAE6GCptLbvomGUyQZYUTh3z+qKY5YyQafU05/zQZMyFIu2
XC0gI1/EWbx2e6bomyKSFNu1wcrW+0p5L0OOpsbeHnr2HI/tcVZJhEIRsm+c1C7z
x9ObY0SzWBcc8Lb2WB7QdW0xbFdM4t9g+IOiQP1h9GAsHw3/FCF58EO+/SPoGZM1
R3pRP6QV4GihLgAvozy83kbV7OjyOc0OQyn4MdHLglxv4HSmxEyUWu/jPTH6NYgm
b9Bms/Yf4ZKTy2FFSc5I3MQeHWWjENGsoau3FaHd35CgZWL+X/n2di/3urdODSgg
naGF1hPUEDm1366Ku9LXvYuJxWKbsVKk4mlnvf77HL5d3ZELj8O07g90HuMy8LDO
5DzevOJYZFlOqUKRprvq89xVwboWOJ0/7gkdPJORUP00wBjYSmTVIJGRl9hLCK75
DLP1SZ8CI61x95wubSDOjvxhquXINoq6oV+wX30EPp0S8nXewLDSVl5oSSOKzA1P
pohamU0p612u2bJEix8Wca/4aepybPtxZPOhGX4C9CI2ISvefcJd8MB3a2/Oqdaz
M/ThXWyDmppnDqDm5Gx3E3kzYmKCH3mEJMunxdi471ZSHuIzscCI2zKR3mMjDLEA
J9hwMr5CphE9zTWWYewTe9xCl483i89O2eEgBS2ZWSQNU+swmDOrwJFr/JXac/t5
zORbQmW3JgSyaPOxzT5uDXnWdbbtpbecugkPk1kSV+M=
`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
YXCNtMTlKgImQ/b7oedEslJXlDxpuPMczavVsVrpp6hyVAHvfZ20O3Ta8t5TL0jn
8R3pT0B1yF4S27VH+dd6GqXnDlR5sNf3R3OZ6LmKFpJtUvPrx2rPB/tEJ+Y7DaSg
ztFJpyl24dWSeUH+PJ9CUp4uPE3+N3bosSx9Tck/jmO1XucZidjtIPF1kuau4nJi
2cGUT2TXMcFysK9wB+Qh0ZXCqbe+ccl5NVqQg5QsyrgBlNpxZZ/BcDsmvmwC/ucR
yuv34l4ZwZCXgy8QL7MuAakqH6W/GyMZIXA/4T81VgqZ4Um63tC7nhS2Tf4VyMuc
b+ZvpunXLG4i5PEqqvc4vQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 2384 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
j/0vnoA8xgH6HWlGAEJFWj4C6jpi1W+c+FsA0ZnPawpTbFY4kscBwBke4HpgihcE
i3uumz0BgBLq8RkodfdLYCHzyyux5zliuhcnLcLKkpk/d7A5DkJEwqMzEK/9Fd51
ua/89R7MV5lptYTwk615OSw9rLseCWR5WcCRERnUNraXioyMZlQlJq+fFEluxf5a
7t3AVLO/uxMRb5Q5ds7m+7wMe5m0CVtDXbH/Lew/+pllYeibn+IbmBEycB3JG15N
PDsDVfDXH05hanWJk+1CKstEDP0dgATTLKCllr0bHBblfTBBDR65o1WU2xYc+i9h
MIjQgoW1rBxVI4d4xuD0Aw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 3808 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
FdIkrezKywuN4E2klNcBiYdNJW7uM0L9JLp//y8SKk7HzloKFsuVWEfFuwcSdbCC
01BllQPMKKxG5nm0enwwvuiA1dEWS7eWhnjUf0YG6AlhqvmqcZA7CWlzYahthD5R
E5ws8T0UKPna3GE34NMIcpvQT5Kw7cEQPdTOrW9g3BdheB3gNluJM1ZlV51ZvafT
V1Bo+TgtmukHkGwcDhlOqVogyz4xbOzBOfGHsC/IVKV2qunZLA/TiSJIn+uNi2WF
fuUWuvrhQ9nPFM3U9DE8y8gnq3QIvnFwZa8TmB1OM7nn9ri5vTphBa5w6AxXxfv3
mtSU+c3Pot1D9E97pJyA5A==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 4992 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
kz09upYXRKeeqvjAtcbMeqHR9N7qHnWIzkA51dAQDAbKFNPWjHCIEZVkDG84skDC
gHYO6ge5RX+Ol6XdI8rcBHSz/tbooXmhtPa1IzIXuf+gmTyNEQmzNNn0ImNBqRt4
JiKTVh6neHIdmj6eBfXeO7tI40amxR3yzJozZqe5jazQV+AkxEk5ilCbV610FUk2
tdPANVOkCp+lR9fbr9AJbWE9Gw3FE8FMcPOWmREQ3Jr+TGEzTl2w/pcXfVMRDzs/
stpCK4nHZPxAwswIjk0eMWmd4N7iTV/nFBkZVtVX0fkLI6BZ7uE/zpAJNik37pbi
eg1pzNt813XDaDxLkOaK2w==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 8640 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
jw/aHxHlIjLFFhXaSOOxneR4//VemxT7ViCZGEqw5HOF8Vi88kAfFo++yZGXf7KW
s8RrqdDjumxoKbxOtukSUzapcDhuUFPE/q777Iuyh2gFoeHmPAPUtqoo/HKtrjbM
9+LQt5sBASXZokkwRjyG906Pn+3dvLTwo88SGtB+LUqhhFF1Nvbd27Vq3svu5VnC
rQ2fJBvHDIuHXomS+ylXOTsO82MAhEk47eW41PIVFYr8RAt5u+HgvERyvMAwjHl8
nsDqEbxF5bz7W9IVp8ONoKYJ9EC7yJOWrbtTXTaAJxklvyXGnHPB2bObCtLzd2Hq
+Yr094k31HW46INEjm4CYA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 35920 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
fDZq7TqRDUKC95tJBEt2C9QlDXK8DcfOzrREuY3z/2mQENi/ZBSJahxzxPqGfVyh
quVpffLw/rSjjKsxYKM6PDO7MOfBKWIyrZmjBUVLbAePH7xEZTn6ipTv9fCI91Y1
i2PpmH/oIncrHoYJa0Mp0x9RsZDpoiGfjGY2w9pGeBaksjWLMG+nzCWX9dOm7jAT
WaIblfZ98JjqwGORJdAtmKnHn3+RFh/qiVD4MSYHjjHmrVsMSuRBoH8oNSa1Aqjf
Mff355XbCMsjN2LlcYthFGqJEAMOc1n/CMNq90T4AAOJq2BWXplahYYj8ZZh71Jn
UiLeV4fcTqVKNCzxh0hhbQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 8784 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
XmuWMWaBOhc6QEpU79oNjYqN1gEWy+BEWAqGLTLUIoaU+rXSF8AEj+tVvBHSh8sk
I4jGEMWx1RLlFpF4cJvPup1LGWCNAmSdw/ADK+sRinIJf1unOPGOQ26iuKju9jK/
4uLoVGoeSVUm72pUL0uen20lgfytpxCzOPkszbm5n/KwEXBy4MF7TxnZ8tQrrndZ
EBXk2Co9lZbLwWEp+uT/qbDaFXIalux/t+uXoa19mxwOt9BeMfJCHnH1r0rdgmQ/
/FVNs1fZBIlPIbuueDLJTf+hY9cs09HrX+utphgj1I23lG+NMiDhPvUXpHs8AiJp
CCBxU8wjXiIm6u6L59r55w==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 1712 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
IsMEFYstR8ukRlM+OYfrrE6+OS/tZnW4GrA+K9ITwdEFPQ1mJC3lpBx94uq+0DMK
t7sOrbEzaRkcisxCjoWtnTdPUC9wkbW2Fb2Q9D+1BYvBtPlEBP9JesaW99qXwrrX
I72FdUytnn92qe4LYyHbiwLTpaoeJFvYWa7a+auhbY2ueo5Q39Qh36HMw6G8EaEH
PK+RIWJ1LqKKtWJqdzOLceCKOAUU9JduLiexI2eKsPIMT2y2GNAMdFu3nT8Rdck1
f4fuCUR8+RNJHl5mNOhv4g2dAx3rI7rvRoUt4f3TqRgrkWt1AcmEPj2wj3jfZ35E
03uDMnf01kr2zqmzmAgDGQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 4624 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
GJh9gnnmo5AuReiv0TWfJMlyjCuMqoFxUv71nFXBm381ak7D+saNImMNwDBGT/95
JEma0Q6myNUKvdLN/5mUyA5tXtdBPhgGB7xiQd3gOL74lOPUX/7z7vK8kjYLQaSU
zmlOvv86xqUFkQiIdKeqihzlyEjpA4qp5dinsCW0DgsqSEeMwKR2vqiXU+40oouW
geizO+23kDA9QsGrCFLUj+T05maDdjmzsSBpeNGivQvuEjdiJE8U7qA3N5TKuTSg
+PsDncZLBQzc8o8dwPN2u6EgWs0+XFTK+aKimCPDnRvaxLDkotZ+Gzqv5onTnUPu
tq0zk+HsBSXbs7Q1qlHfMw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 7248 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
E0KpLVJrb8rvGx+sVAjfeLtlScx1eCP9b+c+K05p3k2N4pltlRZV+ixDlDEBN1Jw
n+p52x66WumbOux730hX4D3nG/oVhS6a83jCOik5L4QOHbBZ2jrt14JsKfiqvf2q
8Z7jn0PapjSdWKyRt0RyiQ6tJfJFxYUeFWvlEPT5PSZQaKABEGvvdEXoFUSC9zVd
qlXbEx9ZaDyCU/KSpBBbs9e1AlIPpw/V9aPca/TCrQSY2hKwUk20jrurDtAD1+j+
dAz062sXnCwgMKvl6ybypSXrbWgl9EVixLQSx50rlfhgxaqADPYKNifxQx71Tz8O
nihHR/0aEqgWCtQtHn5J3Q==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 45072 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`resetall
`timescale 1ns/1ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
l3yJz5GxkMRVUNELsLiZuc7b0j+OxzM5/fTTMNLaZ4JtjMwUoliDxidYhdgkp3sJ
TGsjeRZ8gkZRHzT4NByNGGWGzIvAuOCGxa/k53yNZw87ncmREphLrBm3X21s7Ss/
lTbFBMnRWVNpvkqtFmixwWTzOrYOON+DxkRKUBBCTivhcxCADlElSb2razNE3XDL
iqsnyLbEoH12xN7Faeys4B7qnnk+xMfSqIMzwUy7JRqEmeuvIt0Ftx/GkszQL/HZ
479Ch9YaTlNxm+xHD87/p7sTLkH1pbUwc59sjSqzsWuLkYBUKxjVoZev/HXOjxhq
0QrMuJOg3IkX+9AZTAzILg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 656 )
`pragma protect data_block
ELrmdavm7cpkJU3ejQxEVHwsyhWSzSvyKrm8y23388Zn8nZt77Mr4an4AfTWxRWC
4g2Jfn4X7Z3RyxeBxwKGfR3t12wgjnnNh30MGj1fwuQzJJus5VGHPi4RtzaLEhMS
IsZCIaV4x9g/tHTbkS0ZJKOHPzM0PNmv5YhunoJ1KIIuvKH9EfSS0Ybz4c+qOS3j
PD+J+dMjb96yx7NQ8BzHJmXs/4lhJ/zbwfXH2tWqhIwtopOAx14+WOwGLGsv5VXC
kqKChAO7lcx0Z96zb6kfCRMvVmwY1f5/7V35nqvM2cc9dCGYolM5pvT6yU4s/gEp
yxH/v0fI5O/bruZMEv2doeWatbYqcS7zsWwHurL3guYjF7XyYtmYsx1V9Sz/DjAK
7w6R0/8AI3sscA056z5BH7Uw0ZMsz6xAF+ZS/1E0ARlXc9I2hwAoEbIhW0N2Q6hH
5APu/uLX+9CnQKtMh862+IsRe485hEL276akIhonsOYXJ6KaLTPL2be1a4NcRKf7
Hg5U7vo6zFOB+2xyS+ZEQ0o6Mul7LPqK+ewXECWL9ANFAczPcM2w/UQiQh5Pc6pv
pGT2VVVNlx67Toc/ycSIN+DHcWq6B8EFBPAVONagRZd0DJvUqDBgtUh2njnKrIYv
cEPeYgewqt1ry2eZOtVUA2CLk392oqPwuvHgtN31LM3Decw927nWrOcl41brJPuG
TUFbmX+KOCtyeGbM+bBoPqCx1FWIn+31nllg6ghOBZLutoA1qXgLQz54/IDaoJxy
EhEw1aY6gkn1pZLT8rue593OVjQ4+U5fFCrUIUW8Zr/xBCFgTieQ7voiaiYxsGqH
aXnL+BYlsFDycfxMt0gRLlh5curelNm2+hWAUVfalDI=
`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
ShW3pOVXqaVQwmw9zw/kG9PhjkDaSBeO/5m17YfWuC7NcVSFGnAR144P+zS0jnBL
HIrxIYUzG/z9muV06nJ1iQexIbPJYEfszq9JsjpT0Zw48+vusSHaMVhK5jnG9D+H
MCsfbZxHm91wiM7SRHgTdBwwzXGo4BAOmHVOq2YthvgcUkDoL/4wK+T7m5izLJlh
rJHRJJZp3yi+G+GOL0AHqA3RaTExpl7v8rRooMZ4XSNSFUqwigV5Oxf0AKIU99lr
1S1ZsxmtEden+Xww4c285jCTtR1gGWigz2jmDu9h/q5W2Pj7X/LPX3dDTmsBjMqq
Rb6dreGhMSGwBSf8SlKDBg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 13232 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
i8vQRE9eH1ZQ2a8/C8gPbGa6z+KGByL8SCQXDeG3MeGre/EOr6s4T4S2rE8/klF6
n2u8347mjSGOVG1ItaLxC2KYaEk9hfoL62QtyWWuTZv01rDW/37yH+FL0Yys8dKq
IDwuiElgPqH/SaZxVePIBV9pR3XHBaLo00XQcgGIkReg8kjeluJ7gsxMoyjGqhDj
cALdrYkTCE5n0xz3ew51sQrJY78Y3U9VX5YlZ4Pas6kLP7EzHBtFj2gbz1Tas60m
3NbHAhw/ixV57+yej7In92q+576roCid/BMvLAyh9HitaeduoE3GE4cdI49Dcmlu
lC/a9Kfa5XCvjQTdCGP/9g==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 544 )
`pragma protect data_block
gIhBWY6GdAXMyi0Y6JiWCi4tBkPCEo4G0BkMXsp8JBF7pMRROqCwjkxftNJNHtzq
IEGWsQPenBjepdCC08Feguvbc0gYXOGfzmAB4EMv4YQrSaDQCvkbhH3g0ISOFgc+
VhmXbFRWl0aWJ+MT+aDhan+LNWGQoXAR+oC3MzWtmY1MEKUIQaqD9amui0NS9j9N
txm8zVVAhufv3Kg7CjXI4ingg9hIPyCU/8P/36DxI+Cuv5u9UfpMK8ZFqDHi8Sa4
Hm2OQdfsCzINwr8aZYB/yKxrPeap7dQhBv/DP+KoULCa8vJz52i+gCrttILWHYmg
El6HAVD88Sqa6jUJDnYAMduxs4xO/h8y1UDCbm36cTxBC54Sbe9W5mdrdEq6EW9f
sqFtb+EF8p1JtJE5onO334E65edROIo+lX7Pqejhp4qjLaAjQTWyMX+vBEwBsyGF
ldclWvQHZ2oTa0mLQpO1FLRn/YKvGW+0NRZnXaWhcwcu5C9hmZ07Ky9WuSlQt9j0
PdH1GqMoGIgCYPLMzVx1FebDoLbpfbi/3NGpZuFxKlinpGURkUZpD7PKHsSJlkZ8
/HSGU65qBuE33Lfq7N2Ghas4tLOXLwa3Zm5BN/YRTlYRD2qjuFHiksZAYEZgVd8m
cp0LGeDLi2KwMoxRYEFsLeUQuiI6mrHY/R7HxtlDEqgZT5a6MQzqFXJTB/isuRPg
8NpCg+/5qoN3JrhfoC+zMQ==
`pragma protect end_protected

//pragma protect end
`resetall
`timescale 1ns/1ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
T9C8OrS7gYPcQfJuj60gJDuIwwsGexc2FNjpxnh5+nQPMOJ+ZBxK10JVooA7MSQ2
jAHABs0bWF2vJ0rV/af0T53nQnC8QhaHkl8jtCTUNbda5oOe7AeM8UeSAg+Al36d
JXxT0N5DaQTOFiJimYeA0Jq3OgHzsuw/Genm9nPB2VAljDCWhpMUxmLaTSpnZp0T
uT2Wqfyb81bHeZ7onPU7DG+6caSPT3fWKNmY8cHeXotZnwa9lvMf2jr9TROvpKYg
OlrVFG/ey73ertX/0hWoUR0YRc/ggfoEVqnFCi6Cpz3wHs24a+YV4O5emfQ9AOmf
QQaaezwp2lKxqb9dz7ErbQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 704 )
`pragma protect data_block
0n5KTu4HynPxMfnJGYnTo/CIf6x2uaaFK0F/yqYz2RZwQHUzWP0MkdZho6F31mu+
/KjVj92poDmQ01yUsdqXwoO4zRcSHaY2+Jd0ZcO/rnq1I9AdzljwSI9dvUiQrLqU
cFGDnCZ9c1pwQIbZd/r9kJPUs8fkDOf4PF1StitsEPgpb/jl2vOm4SQ1mLBkGUj8
rTxmz5QFRh5KejWZIrilMMyRqcWP7YZnFRyPGNhAd8pgRwkD1um6TX38aGYJhAgb
QbEffsk26S4pGUqJWhYS7bBOcmgV4D9KBJR/ovO0nQigMxJikgDh7yTSgH3hiVkd
rjzOmMDsnwbCNg2yviptt0yy55PZxbcwCEKspDHGtUQr5tGMuo95qdFu2ADFQyOa
hYFPxP2Sa+LQ5PPATyNSzkW8Sbq3X5E1nYUddYM8l0FCYlBbk3QWyCVE1/KR6pHf
7YLLxIVcdSb2V2+xuB0pzuqKX4tSHyusPJ3Q9AfrbbOkpjFf2RxqjxmkNUDv0JRF
M+UN4xE1TFRO+/1wENAe7jYD3HCflEJMT7Js8/ctOMYSh8LYED0fK99jPEfrOyO0
+YuGfq1qRb8N7br3OXpVGcskKv13ge5W0ZYFVdzK1svnFzGyCJ9QAM93S1cNh3tL
zNZl9QNQc1b5kXcitbH0XRYsxEYHVyeKDPkkd0wkc9pPpWjPfh1c26T2w0sCHmia
g9gjkj0p1NQGGg/ci5r7QIS5vJ2GTSEQWFp9WVdb0LqAlCJMb0RJi6otnaFEDE03
Dkafb1c2mSavqWMW3GABNLniXCdY7EIX3a1jfeRbZNROiKhWMORyjU4rNejoe17M
0LURT7LI0cY7VGC5kNvDrWhs3wsf/hDiMuIEG/pFL+61lILrynfhLGOlC8bCa0/P
W7CQ4VN/8f7yieH+WZCF8IfWdq34fv59aTdZl2tak+E=
`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
ja+eeLxSUL4bDg91i6UWceUlRiJ2w0Dlf7Nkzrul6KKACDmeEolUQD2eaJGhPTip
maAk2T7oL0ysuhIeiuodtmYAJ/FDkm+seCUL/0cLZQhwRkj71m31tnjL8uMJERlJ
wg9Rkrmkz6CZPQkBNAoxfc2SD7Q4qSnRED7x/o8DPE2CUUYq7wXWxd3hH5WXHCBo
LdBce6iiHHnAa/8R9PX0/8vIibJZDRLnfQdpA4SirkiOgzbhoHj0PC+X922pMqjX
ZtrNeTvvrdOLE+pH1QCbdMX6cZhZWXBzma2rSCST4LcVxfHEdmBq0do9h13UpY2g
4MfgJB6DwlWGJ+X3oCL5Yg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 9936 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
jTanDkF7bnOyOgBTHWek9vsMGN7RGCq2Y99qAgU7XdHBk+fffnHZMhycTDIUU3vC
WBskUb7w9Fs9f5BB3GjCIPLyi8OLfzROImy76tx2zDEVmBMtdJASP/0lbQUuaT0D
ghxGycDK7vtUKZhe6OV+7Kez6H0YEXUhKtdQXyEUjcUCAy/XJLRJ0yIUB1qeOzm4
PTJMJlJhR/k5XyZH7RgSllsA9hv586QEELkoVpYMr9xl1YqkauBx2r5rds40cBq3
r7BYtM60YW1+8qFo/P9eXOgSwrPit7FcWRDERtQHZzSmYQhOZtnRlvzAzSR0pm7F
9tQGI9lXafQs168pU1fQjQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 9504 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
imnMxrasTZz+XG0xTE1qzkry/7BaHgvIH6f5Z5uckPNHqvnHQeeNXz2X+9fSAI6/
G/uVJTLcwPR3At/CC/Ng2FWrovBEzzE/aZy/XEnh6WBiOXFTbgLCDryQfXmpO0fj
lzaBRS0XugXj9ryCYZXmq3+YCWRZnckSx0ZGKJi844cWNb6TcRmu0/+OzeI/P1YW
mw9YzONFoQPArn4kok6Nlk/QyzwZS9ZzsKGke/QGUVJvWAmnVGDifMPOLgdcyBLF
odxLiE/iFaqlFYA1eVAZctHno/+qgcNCmUng/jBUmWDOfsbul4xsyO44RzhxVJ8/
SkSKdcoiWuSEJ0+B9kF8RA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 944 )
`pragma protect data_block
1KU8LqNdlv92I3EMj5rRw/Y67b+MPg5arSO3IgRaMWmX0HBA6mpB/wqCZr4Za9m/
RkF7EuiPzzIFzxTiR+T7OBBuiAqJI9ZXNDbgb2AXffLZs1oDkRlG668CveGGgdB/
AniD7riegeq9hpRSPJsg2naAymRM0kFX7qKW0M39AxLJ3Z1v2pyYvv9rQFs1qpBG
icUxT9ntp+5/AfCZk3WuMgKFNhVvCR2XyUfS1Ci2YShFtyE1osi+xF0T/8Ul3hLG
5k+BmV1RMo7yOc45yuYBLag+l0/2zKC3yBT/QKO/D6Pz+LyXtrZ/KMOj5kRvbGl4
UE/COLcGgsQiV2e8Y9GtnKlJgaHH6rrWw9ymwWJVPYeTp//8JKQZdWYdNPwYn3Fr
8qxhl2Vv2BgBB4ALPhWTgLziFuqG0aFN4Kfkj1r3O4+U9kaYfUIo86ce0ZyDQXEL
W0rJkDFa3JOmrcYSf6l/G3ZwT0RfDo9jK6wP8VK6HXjBBVdtWRg8Ma4FgmE8oLh7
N7m8c+UbeB8EFIO/pA1wuPtqd/yhgzXCqRhg3Geog8zNdCl184zrEyxGa4iH2zoW
GBV3BHWHHzvT8T8xlIRGq+E9mVvtBZIWPjRgmeaxefSD0hyFvonYUJCMgRXSaWOt
7XcmYOscXuO2MtQENgJeaxXDaTtiSSoZnVhaBWL7+M3lMUnCUfvb4H3vcxypIQpv
4/jwBdVwXjE5zlKnOR9P6NyTyMGbnN1Ft5n9pXmx9+L7EyHkc9VTHnz8fCueUWfM
TyaMEWldGi5k6A1Q3f44g0l0SxeWqbjiTnDLdi1Nphvwf2KP6J1NP2EzZMRX314y
oRO64I4w0iWvawl+wltXW6w0/yGUjAc2cctj2i77a9vgpdu1IM3iTxLkdZChZKA5
ds0rSXAeDNR5elvf73In80gGlFgQeBEcxvPXCXdgEWwDRdfSZvmxWfrWADlW+AID
WWy83Qax36ECOb29VZzjiCGbtUg6JAlVkwETMTQEOs0vNRHD8xbb3Pv7SWw3eWCp
T9MCemZ6aOPZ8+jcE2X5FhISTMkr8ylGOpMrrWUzrygqJV5XyAf4jtZ7Loc12qct
akUQdbALpEHIj5xFhIi8kLuoMs17ae6zI2+nPb2U+n8lkTTqtHvLt1NhZGuB6llq
MzgDtLoZSyH6ikvzDvrr0m5tcKNGssVZAc8e14UOsn3LwOYpx/GnbQCf2g3FsWz8
0Tnfz50hn61zuPD7U36QSDurtXBDLTRQPsllwJCSIN0=
`pragma protect end_protected

//pragma protect end
`undef IP_UUID
`undef IP_NAME_CONCAT
`undef IP_MODULE_NAME
