// synopsys translate_off
`timescale 1 ns / 1 ps													
// synopsys translate_on

module `IP_MODULE_NAME(efx_dsi_tx) #(
    parameter tLPX_NS = 100,
    parameter tINIT_NS = 100000,
    parameter tLP_EXIT_NS = 100,
    parameter BTA_TIMEOUT_NS = 100000,
    parameter tD_TERM_EN_NS = 35, // for bidir rx mode
    parameter tHS_PREPARE_ZERO_NS = 145, // for bidir rx mode
    parameter tCLK_ZERO_NS = 280,
    parameter tCLK_TRAIL_NS = 60,
    parameter tCLK_PRE_NS = 10,
    parameter tCLK_POST_NS = 60,
    parameter tCLK_PREPARE_NS = 60,
    parameter tHS_PREPARE_NS = 80,
    parameter tWAKEUP_NS = 1000,
    parameter tHS_EXIT_NS = 120,
    parameter tHS_ZERO_NS = 200,
    parameter tHS_TRAIL_NS = 100, 
    parameter NUM_DATA_LANE = 4,
    parameter HS_BYTECLK_MHZ = 125,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter DPHY_CLOCK_MODE = "Continuous",
    parameter PACK_TYPE = 4'b1111,
    parameter ENABLE_V_LPM_BTA = 0,
    parameter PACKET_SEQUENCES = 1,
    parameter HS_CMD_WDATAFIFO_DEPTH = 512,
    parameter LP_CMD_WDATAFIFO_DEPTH = 512,
    parameter LP_CMD_RDATAFIFO_DEPTH = 2048,
    parameter MAX_HRES = 1080,
    parameter ENABLE_BIDIR = 1,
    parameter ENABLE_EOTP = 0,
    parameter PIXEL_FIFO_DEPTH = 2048
)(
    input logic           reset_n,
    input logic           clk,				//100Mhz
    input logic           reset_byte_HS_n,
    input logic           clk_byte_HS,
    input logic           reset_pixel_n,
    input logic           clk_pixel,
    // LVDS clock lane   
    output logic          Tx_LP_CLK_P,
	output logic          Tx_LP_CLK_P_OE,
    output logic          Tx_LP_CLK_N,
	output logic          Tx_LP_CLK_N_OE,
	output logic [7:0]    Tx_HS_C,
    output logic          Tx_HS_enable_C,
    
    // ----- DLane 0 -----------
    // LVDS data lane
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_P,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_P_OE,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_N,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_N_OE,
    output logic [7:0]                       Tx_HS_D_0,
    output logic [7:0]                       Tx_HS_D_1,
    output logic [7:0]                       Tx_HS_D_2,
    output logic [7:0]                       Tx_HS_D_3,
    output logic [NUM_DATA_LANE-1:0]         Tx_HS_enable_D,

    input  logic          Rx_LP_D_P,
    input  logic          Rx_LP_D_N,
    
    //AXI4-Lite Interface
    input  logic          axi_clk, 
    input  logic          axi_reset_n,
    input  logic [6:0]    axi_awaddr,//Write Address. byte address.
    input  logic          axi_awvalid,//Write address valid.
    output logic          axi_awready,//Write address ready.
    input  logic [31:0]   axi_wdata,//Write data bus.
    input  logic          axi_wvalid,//Write valid.
    output logic          axi_wready,//Write ready.
                          
    output logic          axi_bvalid,//Write response valid.
    input  logic          axi_bready,//Response ready.      
    input  logic [6:0]    axi_araddr,//Read address. byte address.
    input  logic          axi_arvalid,//Read address valid.
    output logic          axi_arready,//Read address ready.
    output logic [31:0]   axi_rdata,//Read data.
    output logic          axi_rvalid,//Read valid.
    input                 axi_rready,//Read ready.
                          
    input logic           hsync,
    input logic           vsync,
    input logic [1:0]     vc,
    input logic [5:0]     datatype,   // data type of the video Long Packet
    input logic [63:0]    pixel_data,
    input logic           pixel_data_valid,
    input logic [15:0]    haddr,
    
    input logic           TurnRequest_dbg,
    output logic          TurnRequest_done, 
`ifdef MIPI_DSI_TX_DEBUG
    input  logic [31:0]   mipi_debug_in,
    output logic [31:0]   mipi_debug_out,
`endif
    output logic          irq
    
);

logic [NUM_DATA_LANE-1:0] TxReadyHS, TxRequestHS, TxRequestEsc;
logic [NUM_DATA_LANE-1:0] TxUlpsEsc, TxUlpsExit;
logic [NUM_DATA_LANE-1:0] TxUlpsActiveNot, TxStopStateD;
logic TxLpdtEsc, TxValidEsc;
logic [NUM_DATA_LANE-1:0] TxReadyEsc, TxSkewCalHS;
logic [3:0] TxTriggerEsc;
logic [7:0] TxDataHS_0, TxDataHS_1, TxDataHS_2, TxDataHS_3;
logic [7:0] TxDataEsc_0;
logic [7:0] RxDataEsc;
logic RxLPDTEsc, RxValidEsc;
logic TxRequestHSc, TxStopStateC;
logic TxUlpsClk, TxUlpsExitClk, TxUlpsActiveClkNot;
logic TurnRequest, turnaround_timeout; 
logic TxStopState_1P, TxStopState_2P;

`IP_MODULE_NAME(efx_dphy_bidir_tx) #(
    .tLPX_NS              (tLPX_NS        ),
    .tLP_EXIT_NS          (tLP_EXIT_NS    ),
    .BTA_TIMEOUT_NS       (BTA_TIMEOUT_NS),
    .tD_TERM_EN_NS        (tD_TERM_EN_NS  ),  //bidir param
    .tHS_PREPARE_ZERO_NS  (tHS_PREPARE_ZERO_NS),  //bidir param
    .tCLK_ZERO_NS         (tCLK_ZERO_NS   ),
    .tCLK_TRAIL_NS        (tCLK_TRAIL_NS  ), 
    .tCLK_PRE_NS          (tCLK_PRE_NS    ),
    .tCLK_POST_NS         (tCLK_POST_NS   ),      
    .tCLK_PREPARE_NS      (tCLK_PREPARE_NS),    
    .tHS_PREPARE_NS       (tHS_PREPARE_NS ),   
    .tWAKEUP_NS           (tWAKEUP_NS     ),
    .tHS_EXIT_NS          (tHS_EXIT_NS    ),
    .tHS_ZERO_NS          (tHS_ZERO_NS    ),
    .tHS_TRAIL_NS         (tHS_TRAIL_NS   ),
    .HS_BYTECLK_MHZ       (HS_BYTECLK_MHZ ),
    .CLOCK_FREQ_MHZ       (CLOCK_FREQ_MHZ ),
    .NUM_DATA_LANE        (NUM_DATA_LANE  ),
    .ENABLE_BIDIR         (ENABLE_BIDIR   ),
    .DPHY_CLOCK_MODE      (DPHY_CLOCK_MODE)
) dphy_bidir_tx_inst (
    .clk                  (clk),
    .reset_n              (reset_n),
    .clk_byte_HS          (clk_byte_HS),
    .reset_byte_HS_n      (reset_byte_HS_n),
    //To LVDS clock lane   
    .Tx_LP_CLK_P          (Tx_LP_CLK_P), 
    .Tx_LP_CLK_P_OE       (Tx_LP_CLK_P_OE),
    .Tx_LP_CLK_N          (Tx_LP_CLK_N),
    .Tx_LP_CLK_N_OE       (Tx_LP_CLK_N_OE),
    .Tx_HS_enable_C       (Tx_HS_enable_C), 
    //PPI clock lane
    .TxRequestHSc         (TxRequestHSc),
    .Tx_HS_C              (Tx_HS_C),
    .TxReadyHSc           (),
    .TxUlpsClk            (TxUlpsClk),   // Transmit Ultra Low power on clock lane
    .TxUlpsExitClk        (TxUlpsExitClk),
    .TxUlpsActiveClkNot   (TxUlpsActiveClkNot),
    .TxStopStateC         (TxStopStateC),
    //To LVDS data lane
    .Tx_LP_D_P            (Tx_LP_D_P),
    .Tx_LP_D_P_OE         (Tx_LP_D_P_OE),
    .Tx_LP_D_N            (Tx_LP_D_N),
    .Tx_LP_D_N_OE         (Tx_LP_D_N_OE),
    .Tx_HS_D_0            (Tx_HS_D_0),
    .Tx_HS_D_1            (Tx_HS_D_1),
    .Tx_HS_D_2            (Tx_HS_D_2),
    .Tx_HS_D_3            (Tx_HS_D_3),
    .Tx_HS_D_4            (),
    .Tx_HS_D_5            (),
    .Tx_HS_D_6            (),
    .Tx_HS_D_7            (),
    .Tx_HS_enable_D       (Tx_HS_enable_D),
    //Bidir mode data lane
    .Rx_LP_D_P            (Rx_LP_D_P),
    .Rx_LP_D_N            (Rx_LP_D_N),
    //PPI data lane       
    .TxRequestHS          (TxRequestHS),
	.TxDataHS_0           (TxDataHS_0),
	.TxDataHS_1           (TxDataHS_1),
	.TxDataHS_2           (TxDataHS_2),
	.TxDataHS_3           (TxDataHS_3),
	.TxDataHS_4           (8'h0),
	.TxDataHS_5           (8'h0),
	.TxDataHS_6           (8'h0),
	.TxDataHS_7           (8'h0),
    .TxReadyHS            (TxReadyHS),
    .TxSkewCalHS          (TxSkewCalHS),
    .TxRequestEsc         (TxRequestEsc),
    .TxTriggerEsc         (TxTriggerEsc),
    .TxStopStateD         (TxStopStateD),
    .TxUlpsExit           (TxUlpsExit),
    .TxUlpsActiveNot      (TxUlpsActiveNot),
    .TxUlpsEsc            (TxUlpsEsc),
    //LPDT mode only supported in DSI
    .TxLpdtEsc            ({{NUM_DATA_LANE-1{1'b0}}, TxLpdtEsc}),
    .TxValidEsc           ({{NUM_DATA_LANE-1{1'b0}}, TxValidEsc}),
    .TxDataEsc_0          (TxDataEsc_0),
    .TxDataEsc_1          (8'h0),
    .TxDataEsc_2          (8'h0),
    .TxDataEsc_3          (8'h0),
    .TxDataEsc_4          (8'h0),
    .TxDataEsc_5          (8'h0),
    .TxDataEsc_6          (8'h0),
    .TxDataEsc_7          (8'h0),
    .TxReadyEsc           (TxReadyEsc),
    //Bidir PPI signal
    .TurnRequest          (TurnRequest),
    .TurnRequest_done     (TurnRequest_done),
    .turnaround_timeout   (turnaround_timeout),
    .RxUlpsEsc            (),
    .RxUlpsActiveNot      (),
    .RxLPDTEsc            (RxLPDTEsc),
    .RxDataEsc            (RxDataEsc),
    .RxValidEsc           (RxValidEsc),
    .RxTriggerEsc         (),
    .RxStopState          (),
    .ErrEsc               (),	
    .ErrControl           ()
);

`IP_MODULE_NAME(efx_dsi_tx_top) #(
    .tINIT_NS                  (tINIT_NS),
    .tINIT_SKEWCAL_NS          (100000),
    .ENABLE_INIT_SKEWCAL       (0), //always turn off for soft DSI
    .ENABLE_EOTP               (ENABLE_EOTP),
    .NUM_DATA_LANE             (NUM_DATA_LANE),
    .HS_BYTECLK_MHZ            (HS_BYTECLK_MHZ),
    .DPHY_CLOCK_MODE           (DPHY_CLOCK_MODE),
    .PACK_TYPE                 (PACK_TYPE),
    .ENABLE_V_LPM_BTA          (ENABLE_V_LPM_BTA),
    .PACKET_SEQUENCES          (PACKET_SEQUENCES),
    .HS_CMD_WDATAFIFO_DEPTH    (HS_CMD_WDATAFIFO_DEPTH),
    .LP_CMD_WDATAFIFO_DEPTH    (LP_CMD_WDATAFIFO_DEPTH),
    .LP_CMD_RDATAFIFO_DEPTH    (LP_CMD_RDATAFIFO_DEPTH),
    .HS_LANE_FIFO_DEPTH        (512),
    .MAX_HRES                  (MAX_HRES),
    .HS_DATA_WIDTH             (8),
    .ASYNC_STAGE               (2),
    .PIXEL_FIFO_DEPTH          (PIXEL_FIFO_DEPTH)
) efx_dsi_tx_top_inst (
    .clk_byte_HS          (clk_byte_HS),
    .reset_byte_HS_n      (reset_byte_HS_n),
    .clk_pixel            (clk_pixel),
    .reset_pixel_n        (reset_pixel_n),
    .clk_esc              (clk),
    .reset_esc_n          (reset_n),
    .phy_clk_byte_HS      (clk_byte_HS),
    
    .axi_clk              (axi_clk),
    .axi_reset_n          (axi_reset_n),
    .axi_awaddr           (axi_awaddr),
    .axi_awvalid          (axi_awvalid),
    .axi_awready          (axi_awready),
    .axi_wdata            (axi_wdata),
    .axi_wvalid           (axi_wvalid),
    .axi_wready           (axi_wready),                        
    .axi_bvalid           (axi_bvalid),
    .axi_bready           (axi_bready),
    .axi_araddr           (axi_araddr),
    .axi_arvalid          (axi_arvalid),
    .axi_arready          (axi_arready),
    .axi_rdata            (axi_rdata),
    .axi_rvalid           (axi_rvalid),
    .axi_rready           (axi_rready),
    //PPI clock lane
    .TxRequestHSc         (TxRequestHSc),
    .TxUlpsClk            (TxUlpsClk),   // Transmit Ultra Low power on clock lane
    .TxUlpsExitClk        (TxUlpsExitClk),
    .TxUlpsActiveClkNot   (TxUlpsActiveClkNot),
    .TxStopStateC         (TxStopStateC),
    //PPI data lane       
    .TxRequestHS          (TxRequestHS),
	.TxDataHS_0           (TxDataHS_0),
	.TxDataHS_1           (TxDataHS_1),
	.TxDataHS_2           (TxDataHS_2),
	.TxDataHS_3           (TxDataHS_3),
    .TxReqValidHS0        (),
    .TxReqValidHS1        (),
    .TxReqValidHS2        (),
    .TxReqValidHS3        (),    
    .TxReadyHS            (TxReadyHS),
    .TxSkewCalHS          (TxSkewCalHS),
    .TxRequestEsc         (TxRequestEsc),
    .TxTriggerEsc         (TxTriggerEsc),
    .TxStopStateD         (TxStopStateD),
    .TxUlpsExit           (TxUlpsExit),
    .TxUlpsActiveNot      (TxUlpsActiveNot),
    .TxUlpsEsc            (TxUlpsEsc),
    //LPDT mode only supported in DSI
    .TxLpdtEsc            (TxLpdtEsc),
    .TxValidEsc           (TxValidEsc),
    .TxDataEsc_0          (TxDataEsc_0),
    .TxReadyEsc           (TxReadyEsc[0]),
    .RxClkEsc             (clk),  // for soft DPHY it is using clk, hard DPHY is using clock from DPHY
    .RxLPDTEsc            (RxLPDTEsc),
    .RxDataEsc            (RxDataEsc),
    .RxValidEsc           (RxValidEsc),
    
    .hsync                (hsync),
    .vsync                (vsync),
    .vc                   (vc),
    .datatype             (datatype),
    .pixel_data           (pixel_data),
    .pixel_data_valid     (pixel_data_valid),
    .haddr                (haddr),
    
    .TurnRequest_dbg      (TurnRequest_dbg),
    .TurnRequest_done     (TurnRequest_done),  
    .TurnRequest          (TurnRequest),
    .turnaround_timeout   (turnaround_timeout),
    .irq                  (irq),
`ifdef MIPI_DSI_TX_DEBUG
    .mipi_debug_in        (mipi_debug_in),
    .mipi_debug_out       (mipi_debug_out),
`endif 
    .Direction            (1'b0) // hcteh 230223: Direction port to indicate if the DPHY in TX/RX mode, when BTA triggered. use for 2.5G, tie gnd for DSI 1.5G.  SIP-306
);

endmodule
