`timescale 1 ns / 1 ps
module `IP_MODULE_NAME(efx_dphy_bidir_tx) #(
    parameter tLPX_NS = 50,
    parameter tLP_EXIT_NS = 100,
    parameter BTA_TIMEOUT_NS = 100000,
    parameter tD_TERM_EN_NS = 35, 
    parameter tHS_PREPARE_ZERO_NS = 145, 
    parameter tCLK_ZERO_NS = 262,
    parameter tCLK_TRAIL_NS = 60,
    parameter tCLK_PRE_NS = 10,
    parameter tCLK_POST_NS = 60,
    parameter tCLK_PREPARE_NS = 38,
    parameter tHS_PREPARE_NS = 40,
    parameter tWAKEUP_NS = 1000,
    parameter tHS_EXIT_NS = 100,
    parameter tHS_ZERO_NS = 105,
    parameter tHS_TRAIL_NS = 60,
    parameter HS_BYTECLK_MHZ = 187,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter NUM_DATA_LANE = 4,
    parameter ENABLE_BIDIR = 1,
    parameter DPHY_CLOCK_MODE = "Continuous"
)(
    input  logic       clk,
    input  logic       reset_n,
    input  logic       clk_byte_HS, 
	input  logic       reset_byte_HS_n,
	output logic       Tx_LP_CLK_P,
	output logic       Tx_LP_CLK_P_OE,
	output logic       Tx_LP_CLK_N,
	output logic       Tx_LP_CLK_N_OE,
	output logic       Tx_HS_enable_C,
	input  logic       TxRequestHSc,
	output logic [7:0] Tx_HS_C,
    output  logic      TxReadyHSc,
	input  logic       TxUlpsClk,   
	input  logic       TxUlpsExitClk,   
	output logic       TxUlpsActiveClkNot,
	output logic       TxStopStateC,
    output logic [NUM_DATA_LANE-1:0]      Tx_LP_D_P,
    output logic [NUM_DATA_LANE-1:0]      Tx_LP_D_P_OE,
    output logic [NUM_DATA_LANE-1:0]      Tx_LP_D_N,
    output logic [NUM_DATA_LANE-1:0]      Tx_LP_D_N_OE,
	output logic [7:0]                    Tx_HS_D_0,
	output logic [7:0]                    Tx_HS_D_1,
	output logic [7:0]                    Tx_HS_D_2,
	output logic [7:0]                    Tx_HS_D_3,
	output logic [7:0]                    Tx_HS_D_4,
	output logic [7:0]                    Tx_HS_D_5,
	output logic [7:0]                    Tx_HS_D_6,
	output logic [7:0]                    Tx_HS_D_7,
    output logic [NUM_DATA_LANE-1:0]      Tx_HS_enable_D,
    input  logic                          Rx_LP_D_P,
    input  logic                          Rx_LP_D_N,
    input  logic [NUM_DATA_LANE-1:0]      TxRequestHS,
	input  logic [7:0]                    TxDataHS_0,
	input  logic [7:0]                    TxDataHS_1,
	input  logic [7:0]                    TxDataHS_2,
	input  logic [7:0]                    TxDataHS_3,
	input  logic [7:0]                    TxDataHS_4,
	input  logic [7:0]                    TxDataHS_5,
	input  logic [7:0]                    TxDataHS_6,
	input  logic [7:0]                    TxDataHS_7,
    output logic [NUM_DATA_LANE-1:0]      TxReadyHS,
    input  logic [NUM_DATA_LANE-1:0]      TxSkewCalHS,
    input  logic [NUM_DATA_LANE-1:0]      TxRequestEsc, 
    input  logic [3:0]                    TxTriggerEsc, 
    output logic [NUM_DATA_LANE-1:0]      TxStopStateD,
    input  logic [NUM_DATA_LANE-1:0]      TxUlpsExit,   
    output logic [NUM_DATA_LANE-1:0]      TxUlpsActiveNot,
    input  logic [NUM_DATA_LANE-1:0]      TxUlpsEsc,   
    input  logic [NUM_DATA_LANE-1:0]      TxLpdtEsc,
    input  logic [NUM_DATA_LANE-1:0]      TxValidEsc,
	input  logic [7:0]                    TxDataEsc_0,
	input  logic [7:0]                    TxDataEsc_1,
	input  logic [7:0]                    TxDataEsc_2,
	input  logic [7:0]                    TxDataEsc_3,
	input  logic [7:0]                    TxDataEsc_4,
	input  logic [7:0]                    TxDataEsc_5,
	input  logic [7:0]                    TxDataEsc_6,
	input  logic [7:0]                    TxDataEsc_7,
    output logic [NUM_DATA_LANE-1:0]      TxReadyEsc,
    input  logic       TurnRequest,
    output logic       TurnRequest_done,
    output logic       turnaround_timeout,
    output logic       RxUlpsEsc,
    output logic       RxUlpsActiveNot,
    output logic       RxLPDTEsc,
    output logic [7:0] RxDataEsc,
    output logic       RxValidEsc,
    output logic [3:0] RxTriggerEsc,
    output logic       RxStopState,
    output logic       ErrEsc,
    output logic       ErrControl
);
genvar i;
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2021.1"
`pragma protect key_keyowner = "Synopsys" , key_keyname = "SNPS-VCS-RSA-2"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 128 )
`pragma protect key_block
SNC0ka9omV026m1n0pEiXtZjn9bBh0cGje9DJkfvqlkdwlSc9MwxEFJWkvUeoebi
IA+WfWl9avJO+QNuRTc8Gpm6nRd/kR1Rdq/po7SxmFCvZc2AERtYsEt8qYYOQS4W
4zx0KbBteNuaHP9EnDrKrodnKrMjhX6TUyuB6VDXj78=
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 12848 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
