`timescale 1 ns / 1 ps
module `IP_MODULE_NAME(efx_dphy_bidir_rx) #(
    parameter tLPX_NS = 50,
    parameter tCLK_TERM_EN_NS = 38,
    parameter tD_TERM_EN_NS = 35,
    parameter tHS_SETTLE_NS = 85,
    parameter tHS_PREPARE_ZERO_NS = 145,
    parameter HS_BYTECLK_MHZ = 187,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter NUM_DATA_LANE = 4,
    parameter ENABLE_USER_DESKEWCAL = 0,
    parameter DPHY_CLOCK_MODE = "Continuous",
    parameter ENABLE_BIDIR = 1,
    parameter tLP_EXIT_NS = 100,
    parameter BTA_TIMEOUT_NS = 100000,
    parameter tHS_PREPARE_NS = 40,
    parameter tWAKEUP_NS = 1000,
    parameter tHS_EXIT_NS = 100,
    parameter tHS_ZERO_NS = 105,
    parameter tHS_TRAIL_NS = 60,
    parameter RXSTOPSTATE_L2H_DLY = 0
)(
    input logic        reset_n,
    input logic        clk,
    input logic        reset_byte_HS_n,
    input logic        clk_byte_HS,
    input logic        Rx_LP_CLK_P,
    input logic        Rx_LP_CLK_N,
    output logic       Rx_HS_enable_C,
    output logic       LVDS_termen_C,
    output logic       RxUlpsClkNot,  
    output logic       RxUlpsActiveClkNot,
    input  logic [NUM_DATA_LANE-1:0]      Rx_LP_D_P,
    input  logic [NUM_DATA_LANE-1:0]      Rx_LP_D_N,
    input logic  [7:0]                    Rx_HS_D_0,
    input logic  [7:0]                    Rx_HS_D_1,
    input logic  [7:0]                    Rx_HS_D_2,
    input logic  [7:0]                    Rx_HS_D_3,
    input logic  [7:0]                    Rx_HS_D_4,
    input logic  [7:0]                    Rx_HS_D_5,
    input logic  [7:0]                    Rx_HS_D_6,
    input logic  [7:0]                    Rx_HS_D_7,
    output logic [NUM_DATA_LANE-1:0]      Rx_HS_enable_D,
    output logic [NUM_DATA_LANE-1:0]      LVDS_termen_D,
    output logic [NUM_DATA_LANE-1:0]      fifo_rd_enable,
    input  logic [NUM_DATA_LANE-1:0]      fifo_rd_empty,
    output logic [NUM_DATA_LANE-1:0]      DLY_enable_D,
    output logic [NUM_DATA_LANE-1:0]      DLY_inc_D,
    input  logic [NUM_DATA_LANE-1:0]      u_dly_enable_D, 
    input  logic [NUM_DATA_LANE-1:0]      u_dly_inc_D, 
    output logic [NUM_DATA_LANE-1:0]      RxUlpsEsc,
    output logic [NUM_DATA_LANE-1:0]      RxUlpsActiveNot,
    output logic [NUM_DATA_LANE-1:0]      RxLPDTEsc,
    output logic [NUM_DATA_LANE-1:0]      RxValidEsc,
	output logic [7:0]                    RxDataEsc_0,
	output logic [7:0]                    RxDataEsc_1,
	output logic [7:0]                    RxDataEsc_2,
	output logic [7:0]                    RxDataEsc_3,
	output logic [7:0]                    RxDataEsc_4,
	output logic [7:0]                    RxDataEsc_5,
	output logic [7:0]                    RxDataEsc_6,
	output logic [7:0]                    RxDataEsc_7,
    output logic [NUM_DATA_LANE-1:0]      RxErrEsc,
    output logic [NUM_DATA_LANE-1:0]      RxErrControl,
    output logic [NUM_DATA_LANE-1:0]      RxErrSotSyncHS,
	output logic [7:0]                    RxDataHS_0,
	output logic [7:0]                    RxDataHS_1,
	output logic [7:0]                    RxDataHS_2,
	output logic [7:0]                    RxDataHS_3,
	output logic [7:0]                    RxDataHS_4,
	output logic [7:0]                    RxDataHS_5,
	output logic [7:0]                    RxDataHS_6,
	output logic [7:0]                    RxDataHS_7,
    output logic [NUM_DATA_LANE-1:0]      RxValidHS,
    output logic [NUM_DATA_LANE-1:0]      RxActiveHS,
    output logic [NUM_DATA_LANE-1:0]      RxSyncHS,
    output logic [NUM_DATA_LANE-1:0]      RxSkewCalHS,
    output logic [NUM_DATA_LANE-1:0]      RxStopState,
    output logic       Tx_LP_D_P,
    output logic       Tx_LP_D_P_OE,
    output logic       Tx_LP_D_N,
    output logic       Tx_LP_D_N_OE,
    input  logic       TxRequestEsc,
    input  logic [3:0] TxTriggerEsc, 
    input  logic       TxUlpsEsc,
    input  logic       TxUlpsExit,
    input  logic       TxLpdtEsc,
    input  logic [7:0] TxDataEsc,
    input  logic       TxValidEsc,
    output logic       TxReadyEsc,
    output logic       TxStopState,
    output logic       TxUlpsActiveNot,
    input  logic       TurnRequest,
    output logic       TurnRequest_done,
    output logic       turnaround_timeout
);
genvar i;
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2021.1"
`pragma protect key_keyowner = "Synopsys" , key_keyname = "SNPS-VCS-RSA-2"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 128 )
`pragma protect key_block
OaT8XeBVExX9VY1af+pswE9UWRVKsj+WZnyy3pqaDiWc6xHTLZnKxhikCv5s6YyX
rl0BR2LMmV3LOrMLHzCY8L55fyPp3S+/XNM0aEbgjq1CwIm6j1/Jg9qNePfXUE0D
jQdInCFepFXhIMIsULZPwNg+awx1fZHRRtyyJAcy9aQ=
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 12400 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
