`timescale 1 ns / 1 ps
module `IP_MODULE_NAME(efx_dphy_bidir_tx) #(
    parameter tLPX_NS = 50,
    parameter tLP_EXIT_NS = 100,
    parameter BTA_TIMEOUT_NS = 100000,
    parameter tD_TERM_EN_NS = 35, 
    parameter tHS_PREPARE_ZERO_NS = 145, 
    parameter tCLK_ZERO_NS = 262,
    parameter tCLK_TRAIL_NS = 60,
    parameter tCLK_PRE_NS = 10,
    parameter tCLK_POST_NS = 60,
    parameter tCLK_PREPARE_NS = 38,
    parameter tHS_PREPARE_NS = 40,
    parameter tWAKEUP_NS = 1000,
    parameter tHS_EXIT_NS = 100,
    parameter tHS_ZERO_NS = 105,
    parameter tHS_TRAIL_NS = 60,
    parameter HS_BYTECLK_MHZ = 187,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter NUM_DATA_LANE = 4,
    parameter ENABLE_BIDIR = 1,
    parameter DPHY_CLOCK_MODE = "Continuous"
)(
    input  logic       clk,
    input  logic       reset_n,
    input  logic       clk_byte_HS, 
	input  logic       reset_byte_HS_n,
	output logic       Tx_LP_CLK_P,
	output logic       Tx_LP_CLK_P_OE,
	output logic       Tx_LP_CLK_N,
	output logic       Tx_LP_CLK_N_OE,
	output logic       Tx_HS_enable_C,
	input  logic       TxRequestHSc,
	output logic [7:0] Tx_HS_C,
    output  logic      TxReadyHSc,
	input  logic       TxUlpsClk,   
	input  logic       TxUlpsExitClk,   
	output logic       TxUlpsActiveClkNot,
	output logic       TxStopStateC,
    output logic [NUM_DATA_LANE-1:0]      Tx_LP_D_P,
    output logic [NUM_DATA_LANE-1:0]      Tx_LP_D_P_OE,
    output logic [NUM_DATA_LANE-1:0]      Tx_LP_D_N,
    output logic [NUM_DATA_LANE-1:0]      Tx_LP_D_N_OE,
	output logic [7:0]                    Tx_HS_D_0,
	output logic [7:0]                    Tx_HS_D_1,
	output logic [7:0]                    Tx_HS_D_2,
	output logic [7:0]                    Tx_HS_D_3,
	output logic [7:0]                    Tx_HS_D_4,
	output logic [7:0]                    Tx_HS_D_5,
	output logic [7:0]                    Tx_HS_D_6,
	output logic [7:0]                    Tx_HS_D_7,
    output logic [NUM_DATA_LANE-1:0]      Tx_HS_enable_D,
    input  logic                          Rx_LP_D_P,
    input  logic                          Rx_LP_D_N,
    input  logic [NUM_DATA_LANE-1:0]      TxRequestHS,
	input  logic [7:0]                    TxDataHS_0,
	input  logic [7:0]                    TxDataHS_1,
	input  logic [7:0]                    TxDataHS_2,
	input  logic [7:0]                    TxDataHS_3,
	input  logic [7:0]                    TxDataHS_4,
	input  logic [7:0]                    TxDataHS_5,
	input  logic [7:0]                    TxDataHS_6,
	input  logic [7:0]                    TxDataHS_7,
    output logic [NUM_DATA_LANE-1:0]      TxReadyHS,
    input  logic [NUM_DATA_LANE-1:0]      TxSkewCalHS,
    input  logic [NUM_DATA_LANE-1:0]      TxRequestEsc, 
    input  logic [3:0]                    TxTriggerEsc, 
    output logic [NUM_DATA_LANE-1:0]      TxStopStateD,
    input  logic [NUM_DATA_LANE-1:0]      TxUlpsExit,   
    output logic [NUM_DATA_LANE-1:0]      TxUlpsActiveNot,
    input  logic [NUM_DATA_LANE-1:0]      TxUlpsEsc,   
    input  logic [NUM_DATA_LANE-1:0]      TxLpdtEsc,
    input  logic [NUM_DATA_LANE-1:0]      TxValidEsc,
	input  logic [7:0]                    TxDataEsc_0,
	input  logic [7:0]                    TxDataEsc_1,
	input  logic [7:0]                    TxDataEsc_2,
	input  logic [7:0]                    TxDataEsc_3,
	input  logic [7:0]                    TxDataEsc_4,
	input  logic [7:0]                    TxDataEsc_5,
	input  logic [7:0]                    TxDataEsc_6,
	input  logic [7:0]                    TxDataEsc_7,
    output logic [NUM_DATA_LANE-1:0]      TxReadyEsc,
    input  logic       TurnRequest,
    output logic       TurnRequest_done,
    output logic       turnaround_timeout,
    output logic       RxUlpsEsc,
    output logic       RxUlpsActiveNot,
    output logic       RxLPDTEsc,
    output logic [7:0] RxDataEsc,
    output logic       RxValidEsc,
    output logic [3:0] RxTriggerEsc,
    output logic       RxStopState,
    output logic       ErrEsc,
    output logic       ErrControl
);
genvar i;
//pragma protect begin_protected
//pragma protect key_keyowner=Cadence Design Systems.
//pragma protect key_keyname=CDS_KEY
//pragma protect key_method=RC5
//pragma protect key_block
3VIpbB5rtcQnNmW+cHxAcepdJU2UkAKbAJiWd7i3GMZGkfi74BNNsZBfGnSK3QBU
Bs3kbzB0IN77/D4bIHXXAiZOlWHb+bFPSUb/A1MiTSY8n3teKQ4RghKvM6gKVlsX
m2BpNypE8drV4DB4qUSk/xb4QjnkQLHTSJ3JySPN9gC/tcv+qEe0vA==
//pragma protect end_key_block
//pragma protect digest_block
TUKtgyd7q7qmrT7PbY+6T3gc2Bg=
//pragma protect end_digest_block
//pragma protect data_block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//pragma protect end_data_block
//pragma protect digest_block
gg5udiP1ytMp/FQSfU6Hfh+0/q8=
//pragma protect end_digest_block
//pragma protect end_protected
