`timescale 1 ns / 1 ps
module `IP_MODULE_NAME(efx_dphy_bidir_rx) #(
    parameter tLPX_NS = 50,
    parameter tCLK_TERM_EN_NS = 38,
    parameter tD_TERM_EN_NS = 35,
    parameter tHS_SETTLE_NS = 85,
    parameter tHS_PREPARE_ZERO_NS = 145,
    parameter HS_BYTECLK_MHZ = 187,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter NUM_DATA_LANE = 4,
    parameter ENABLE_USER_DESKEWCAL = 0,
    parameter DPHY_CLOCK_MODE = "Continuous",
    parameter ENABLE_BIDIR = 1,
    parameter tLP_EXIT_NS = 100,
    parameter BTA_TIMEOUT_NS = 100000,
    parameter tHS_PREPARE_NS = 40,
    parameter tWAKEUP_NS = 1000,
    parameter tHS_EXIT_NS = 100,
    parameter tHS_ZERO_NS = 105,
    parameter tHS_TRAIL_NS = 60,
    parameter RXSTOPSTATE_L2H_DLY = 0
)(
    input logic        reset_n,
    input logic        clk,
    input logic        reset_byte_HS_n,
    input logic        clk_byte_HS,
    input logic        Rx_LP_CLK_P,
    input logic        Rx_LP_CLK_N,
    output logic       Rx_HS_enable_C,
    output logic       LVDS_termen_C,
    output logic       RxUlpsClkNot,  
    output logic       RxUlpsActiveClkNot,
    input  logic [NUM_DATA_LANE-1:0]      Rx_LP_D_P,
    input  logic [NUM_DATA_LANE-1:0]      Rx_LP_D_N,
    input logic  [7:0]                    Rx_HS_D_0,
    input logic  [7:0]                    Rx_HS_D_1,
    input logic  [7:0]                    Rx_HS_D_2,
    input logic  [7:0]                    Rx_HS_D_3,
    input logic  [7:0]                    Rx_HS_D_4,
    input logic  [7:0]                    Rx_HS_D_5,
    input logic  [7:0]                    Rx_HS_D_6,
    input logic  [7:0]                    Rx_HS_D_7,
    output logic [NUM_DATA_LANE-1:0]      Rx_HS_enable_D,
    output logic [NUM_DATA_LANE-1:0]      LVDS_termen_D,
    output logic [NUM_DATA_LANE-1:0]      fifo_rd_enable,
    input  logic [NUM_DATA_LANE-1:0]      fifo_rd_empty,
    output logic [NUM_DATA_LANE-1:0]      DLY_enable_D,
    output logic [NUM_DATA_LANE-1:0]      DLY_inc_D,
    input  logic [NUM_DATA_LANE-1:0]      u_dly_enable_D, 
    input  logic [NUM_DATA_LANE-1:0]      u_dly_inc_D, 
    output logic [NUM_DATA_LANE-1:0]      RxUlpsEsc,
    output logic [NUM_DATA_LANE-1:0]      RxUlpsActiveNot,
    output logic [NUM_DATA_LANE-1:0]      RxLPDTEsc,
    output logic [NUM_DATA_LANE-1:0]      RxValidEsc,
	output logic [7:0]                    RxDataEsc_0,
	output logic [7:0]                    RxDataEsc_1,
	output logic [7:0]                    RxDataEsc_2,
	output logic [7:0]                    RxDataEsc_3,
	output logic [7:0]                    RxDataEsc_4,
	output logic [7:0]                    RxDataEsc_5,
	output logic [7:0]                    RxDataEsc_6,
	output logic [7:0]                    RxDataEsc_7,
    output logic [NUM_DATA_LANE-1:0]      RxErrEsc,
    output logic [NUM_DATA_LANE-1:0]      RxErrControl,
    output logic [NUM_DATA_LANE-1:0]      RxErrSotSyncHS,
	output logic [7:0]                    RxDataHS_0,
	output logic [7:0]                    RxDataHS_1,
	output logic [7:0]                    RxDataHS_2,
	output logic [7:0]                    RxDataHS_3,
	output logic [7:0]                    RxDataHS_4,
	output logic [7:0]                    RxDataHS_5,
	output logic [7:0]                    RxDataHS_6,
	output logic [7:0]                    RxDataHS_7,
    output logic [NUM_DATA_LANE-1:0]      RxValidHS,
    output logic [NUM_DATA_LANE-1:0]      RxActiveHS,
    output logic [NUM_DATA_LANE-1:0]      RxSyncHS,
    output logic [NUM_DATA_LANE-1:0]      RxSkewCalHS,
    output logic [NUM_DATA_LANE-1:0]      RxStopState,
    output logic       Tx_LP_D_P,
    output logic       Tx_LP_D_P_OE,
    output logic       Tx_LP_D_N,
    output logic       Tx_LP_D_N_OE,
    input  logic       TxRequestEsc,
    input  logic [3:0] TxTriggerEsc, 
    input  logic       TxUlpsEsc,
    input  logic       TxUlpsExit,
    input  logic       TxLpdtEsc,
    input  logic [7:0] TxDataEsc,
    input  logic       TxValidEsc,
    output logic       TxReadyEsc,
    output logic       TxStopState,
    output logic       TxUlpsActiveNot,
    input  logic       TurnRequest,
    output logic       TurnRequest_done,
    output logic       turnaround_timeout
);
genvar i;
//pragma protect begin_protected
//pragma protect key_keyowner=Cadence Design Systems.
//pragma protect key_keyname=CDS_KEY
//pragma protect key_method=RC5
//pragma protect key_block
LGZ3I5ZfLmy9xLqL+dP/HJA02+RMQgg+vVNUaLyUYPJcqTldWsD+2K/lnef5rg3y
gPHRFIN7BMlvpuw/SN69p56rzrVcFRgMkveBZwozirYJXT/asqyDPi/YwvLLXaVi
7GowURk9FzK/4e6a9/RzjWTki2jWx7lhdsuQNcmfPz9WkJaewi/oWQ==
//pragma protect end_key_block
//pragma protect digest_block
zWFGtVtdYoa9HVBg/e9hi3BHtXo=
//pragma protect end_digest_block
//pragma protect data_block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//pragma protect end_data_block
//pragma protect digest_block
CiopUsmiYzAP3m+tj2+5bYxFzR8=
//pragma protect end_digest_block
//pragma protect end_protected
