`timescale 1 ns / 1 ps
module `IP_MODULE_NAME(efx_dphy_bidir_tx) #(
    parameter tLPX_NS = 50,
    parameter tLP_EXIT_NS = 100,
    parameter BTA_TIMEOUT_NS = 100000,
    parameter tD_TERM_EN_NS = 35, 
    parameter tHS_PREPARE_ZERO_NS = 145, 
    parameter tCLK_ZERO_NS = 262,
    parameter tCLK_TRAIL_NS = 60,
    parameter tCLK_PRE_NS = 10,
    parameter tCLK_POST_NS = 60,
    parameter tCLK_PREPARE_NS = 38,
    parameter tHS_PREPARE_NS = 40,
    parameter tWAKEUP_NS = 1000,
    parameter tHS_EXIT_NS = 100,
    parameter tHS_ZERO_NS = 105,
    parameter tHS_TRAIL_NS = 60,
    parameter HS_BYTECLK_MHZ = 187,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter NUM_DATA_LANE = 4,
    parameter ENABLE_BIDIR = 1,
    parameter DPHY_CLOCK_MODE = "Continuous"
)(
    input  logic       clk,
    input  logic       reset_n,
    input  logic       clk_byte_HS, 
	input  logic       reset_byte_HS_n,
	output logic       Tx_LP_CLK_P,
	output logic       Tx_LP_CLK_P_OE,
	output logic       Tx_LP_CLK_N,
	output logic       Tx_LP_CLK_N_OE,
	output logic       Tx_HS_enable_C,
	input  logic       TxRequestHSc,
	output logic [7:0] Tx_HS_C,
    output  logic      TxReadyHSc,
	input  logic       TxUlpsClk,   
	input  logic       TxUlpsExitClk,   
	output logic       TxUlpsActiveClkNot,
	output logic       TxStopStateC,
    output logic [NUM_DATA_LANE-1:0]      Tx_LP_D_P,
    output logic [NUM_DATA_LANE-1:0]      Tx_LP_D_P_OE,
    output logic [NUM_DATA_LANE-1:0]      Tx_LP_D_N,
    output logic [NUM_DATA_LANE-1:0]      Tx_LP_D_N_OE,
	output logic [7:0]                    Tx_HS_D_0,
	output logic [7:0]                    Tx_HS_D_1,
	output logic [7:0]                    Tx_HS_D_2,
	output logic [7:0]                    Tx_HS_D_3,
	output logic [7:0]                    Tx_HS_D_4,
	output logic [7:0]                    Tx_HS_D_5,
	output logic [7:0]                    Tx_HS_D_6,
	output logic [7:0]                    Tx_HS_D_7,
    output logic [NUM_DATA_LANE-1:0]      Tx_HS_enable_D,
    input  logic                          Rx_LP_D_P,
    input  logic                          Rx_LP_D_N,
    input  logic [NUM_DATA_LANE-1:0]      TxRequestHS,
	input  logic [7:0]                    TxDataHS_0,
	input  logic [7:0]                    TxDataHS_1,
	input  logic [7:0]                    TxDataHS_2,
	input  logic [7:0]                    TxDataHS_3,
	input  logic [7:0]                    TxDataHS_4,
	input  logic [7:0]                    TxDataHS_5,
	input  logic [7:0]                    TxDataHS_6,
	input  logic [7:0]                    TxDataHS_7,
    output logic [NUM_DATA_LANE-1:0]      TxReadyHS,
    input  logic [NUM_DATA_LANE-1:0]      TxSkewCalHS,
    input  logic [NUM_DATA_LANE-1:0]      TxRequestEsc, 
    input  logic [3:0]                    TxTriggerEsc, 
    output logic [NUM_DATA_LANE-1:0]      TxStopStateD,
    input  logic [NUM_DATA_LANE-1:0]      TxUlpsExit,   
    output logic [NUM_DATA_LANE-1:0]      TxUlpsActiveNot,
    input  logic [NUM_DATA_LANE-1:0]      TxUlpsEsc,   
    input  logic [NUM_DATA_LANE-1:0]      TxLpdtEsc,
    input  logic [NUM_DATA_LANE-1:0]      TxValidEsc,
	input  logic [7:0]                    TxDataEsc_0,
	input  logic [7:0]                    TxDataEsc_1,
	input  logic [7:0]                    TxDataEsc_2,
	input  logic [7:0]                    TxDataEsc_3,
	input  logic [7:0]                    TxDataEsc_4,
	input  logic [7:0]                    TxDataEsc_5,
	input  logic [7:0]                    TxDataEsc_6,
	input  logic [7:0]                    TxDataEsc_7,
    output logic [NUM_DATA_LANE-1:0]      TxReadyEsc,
    input  logic       TurnRequest,
    output logic       TurnRequest_done,
    output logic       turnaround_timeout,
    output logic       RxUlpsEsc,
    output logic       RxUlpsActiveNot,
    output logic       RxLPDTEsc,
    output logic [7:0] RxDataEsc,
    output logic       RxValidEsc,
    output logic [3:0] RxTriggerEsc,
    output logic       RxStopState,
    output logic       ErrEsc,
    output logic       ErrControl
);
genvar i;
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2021.1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
VmXWw+OlyYcCa1c9D+ff6vGZkX6DtgwfILH+++NmOgdWPYWOZZSk0OSEPUNnEd/k
vpww0vlbZUooYDJDt8y0lSICgGHpD+mdBc5KBQzbweMmPGNweKg51XjDxAGXYWy4
O2D58FNLJt5AF7mDH9RYB2/mZdsS4CwhKdeAKvl8WvZU+IlNQDA84ZSUgzaud3Pe
tRXeMj+F+L808ezqw9zbj4n8s2Rzsur5w460vifI92hbnism2Tfa8s3LgA50v9he
txuGWvLiGXr8dOQnjbEIu0SGdxjTfgbZ7hjmibPc6CAV1g9FgpCsr9AvHXd1OVj6
z77+w6ACUR98SIn3QC/wbA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 12848 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
