`timescale 1 ns / 1 ps
module `IP_MODULE_NAME(efx_dphy_bidir_rx) #(
    parameter tLPX_NS = 50,
    parameter tCLK_TERM_EN_NS = 38,
    parameter tD_TERM_EN_NS = 35,
    parameter tHS_SETTLE_NS = 85,
    parameter tHS_PREPARE_ZERO_NS = 145,
    parameter HS_BYTECLK_MHZ = 187,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter NUM_DATA_LANE = 4,
    parameter ENABLE_USER_DESKEWCAL = 0,
    parameter DPHY_CLOCK_MODE = "Continuous",
    parameter ENABLE_BIDIR = 1,
    parameter tLP_EXIT_NS = 100,
    parameter BTA_TIMEOUT_NS = 100000,
    parameter tHS_PREPARE_NS = 40,
    parameter tWAKEUP_NS = 1000,
    parameter tHS_EXIT_NS = 100,
    parameter tHS_ZERO_NS = 105,
    parameter tHS_TRAIL_NS = 60,
    parameter RXSTOPSTATE_L2H_DLY = 0
)(
    input logic        reset_n,
    input logic        clk,
    input logic        reset_byte_HS_n,
    input logic        clk_byte_HS,
    input logic        Rx_LP_CLK_P,
    input logic        Rx_LP_CLK_N,
    output logic       Rx_HS_enable_C,
    output logic       LVDS_termen_C,
    output logic       RxUlpsClkNot,  
    output logic       RxUlpsActiveClkNot,
    input  logic [NUM_DATA_LANE-1:0]      Rx_LP_D_P,
    input  logic [NUM_DATA_LANE-1:0]      Rx_LP_D_N,
    input logic  [7:0]                    Rx_HS_D_0,
    input logic  [7:0]                    Rx_HS_D_1,
    input logic  [7:0]                    Rx_HS_D_2,
    input logic  [7:0]                    Rx_HS_D_3,
    input logic  [7:0]                    Rx_HS_D_4,
    input logic  [7:0]                    Rx_HS_D_5,
    input logic  [7:0]                    Rx_HS_D_6,
    input logic  [7:0]                    Rx_HS_D_7,
    output logic [NUM_DATA_LANE-1:0]      Rx_HS_enable_D,
    output logic [NUM_DATA_LANE-1:0]      LVDS_termen_D,
    output logic [NUM_DATA_LANE-1:0]      fifo_rd_enable,
    input  logic [NUM_DATA_LANE-1:0]      fifo_rd_empty,
    output logic [NUM_DATA_LANE-1:0]      DLY_enable_D,
    output logic [NUM_DATA_LANE-1:0]      DLY_inc_D,
    input  logic [NUM_DATA_LANE-1:0]      u_dly_enable_D, 
    input  logic [NUM_DATA_LANE-1:0]      u_dly_inc_D, 
    output logic [NUM_DATA_LANE-1:0]      RxUlpsEsc,
    output logic [NUM_DATA_LANE-1:0]      RxUlpsActiveNot,
    output logic [NUM_DATA_LANE-1:0]      RxLPDTEsc,
    output logic [NUM_DATA_LANE-1:0]      RxValidEsc,
	output logic [7:0]                    RxDataEsc_0,
	output logic [7:0]                    RxDataEsc_1,
	output logic [7:0]                    RxDataEsc_2,
	output logic [7:0]                    RxDataEsc_3,
	output logic [7:0]                    RxDataEsc_4,
	output logic [7:0]                    RxDataEsc_5,
	output logic [7:0]                    RxDataEsc_6,
	output logic [7:0]                    RxDataEsc_7,
    output logic [NUM_DATA_LANE-1:0]      RxErrEsc,
    output logic [NUM_DATA_LANE-1:0]      RxErrControl,
    output logic [NUM_DATA_LANE-1:0]      RxErrSotSyncHS,
	output logic [7:0]                    RxDataHS_0,
	output logic [7:0]                    RxDataHS_1,
	output logic [7:0]                    RxDataHS_2,
	output logic [7:0]                    RxDataHS_3,
	output logic [7:0]                    RxDataHS_4,
	output logic [7:0]                    RxDataHS_5,
	output logic [7:0]                    RxDataHS_6,
	output logic [7:0]                    RxDataHS_7,
    output logic [NUM_DATA_LANE-1:0]      RxValidHS,
    output logic [NUM_DATA_LANE-1:0]      RxActiveHS,
    output logic [NUM_DATA_LANE-1:0]      RxSyncHS,
    output logic [NUM_DATA_LANE-1:0]      RxSkewCalHS,
    output logic [NUM_DATA_LANE-1:0]      RxStopState,
    output logic       Tx_LP_D_P,
    output logic       Tx_LP_D_P_OE,
    output logic       Tx_LP_D_N,
    output logic       Tx_LP_D_N_OE,
    input  logic       TxRequestEsc,
    input  logic [3:0] TxTriggerEsc, 
    input  logic       TxUlpsEsc,
    input  logic       TxUlpsExit,
    input  logic       TxLpdtEsc,
    input  logic [7:0] TxDataEsc,
    input  logic       TxValidEsc,
    output logic       TxReadyEsc,
    output logic       TxStopState,
    output logic       TxUlpsActiveNot,
    input  logic       TurnRequest,
    output logic       TurnRequest_done,
    output logic       turnaround_timeout
);
genvar i;
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2021.1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
R5lfZOjv0WLg1PSqY8zvozFYOND6ehgEeo4Jb0kAtJAqXWvcfXHEMaJD8iG/H67h
rZjJt8vyDbuaw2qbmJchrPBHu6MJGTrYvYSFCKw1QqXDXYpaCUaOtzFxKfP6rTkY
JJc79rFuEBcY4NGIfPDBxYCSJ4q3YbWToqZ0hD0bLpFZ1LMfqUnN7oNe8n/dfuvA
pE/tN3he+Xg9YrTkz9+jJrrm549Ff0Aj1h0+AgrNnkYgG9dJ3UMz4UAcrea6014Y
l8Mf9+dTY6UybxC5QY9NJdZruzUaEUfi5JIVSVvhbcp2LQ09QDnnuoSo4uTmZYgx
/sF9gZMetmuJKutgaGlw+g==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 12400 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
