`timescale 1 ns / 1 ps
module `IP_MODULE_NAME(efx_dphy_bidir_tx) #(
    parameter tLPX_NS = 50,
    parameter tLP_EXIT_NS = 100,
    parameter BTA_TIMEOUT_NS = 100000,
    parameter tD_TERM_EN_NS = 35, 
    parameter tHS_PREPARE_ZERO_NS = 145, 
    parameter tCLK_ZERO_NS = 262,
    parameter tCLK_TRAIL_NS = 60,
    parameter tCLK_PRE_NS = 10,
    parameter tCLK_POST_NS = 60,
    parameter tCLK_PREPARE_NS = 38,
    parameter tHS_PREPARE_NS = 40,
    parameter tWAKEUP_NS = 1000,
    parameter tHS_EXIT_NS = 100,
    parameter tHS_ZERO_NS = 105,
    parameter tHS_TRAIL_NS = 60,
    parameter HS_BYTECLK_MHZ = 187,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter NUM_DATA_LANE = 4,
    parameter ENABLE_BIDIR = 1,
    parameter DPHY_CLOCK_MODE = "Continuous"
)(
    input  logic       clk,
    input  logic       reset_n,
    input  logic       clk_byte_HS, 
	input  logic       reset_byte_HS_n,
	output logic       Tx_LP_CLK_P,
	output logic       Tx_LP_CLK_P_OE,
	output logic       Tx_LP_CLK_N,
	output logic       Tx_LP_CLK_N_OE,
	output logic       Tx_HS_enable_C,
	input  logic       TxRequestHSc,
	output logic [7:0] Tx_HS_C,
    output  logic      TxReadyHSc,
	input  logic       TxUlpsClk,   
	input  logic       TxUlpsExitClk,   
	output logic       TxUlpsActiveClkNot,
	output logic       TxStopStateC,
    output logic [NUM_DATA_LANE-1:0]      Tx_LP_D_P,
    output logic [NUM_DATA_LANE-1:0]      Tx_LP_D_P_OE,
    output logic [NUM_DATA_LANE-1:0]      Tx_LP_D_N,
    output logic [NUM_DATA_LANE-1:0]      Tx_LP_D_N_OE,
	output logic [7:0]                    Tx_HS_D_0,
	output logic [7:0]                    Tx_HS_D_1,
	output logic [7:0]                    Tx_HS_D_2,
	output logic [7:0]                    Tx_HS_D_3,
	output logic [7:0]                    Tx_HS_D_4,
	output logic [7:0]                    Tx_HS_D_5,
	output logic [7:0]                    Tx_HS_D_6,
	output logic [7:0]                    Tx_HS_D_7,
    output logic [NUM_DATA_LANE-1:0]      Tx_HS_enable_D,
    input  logic                          Rx_LP_D_P,
    input  logic                          Rx_LP_D_N,
    input  logic [NUM_DATA_LANE-1:0]      TxRequestHS,
	input  logic [7:0]                    TxDataHS_0,
	input  logic [7:0]                    TxDataHS_1,
	input  logic [7:0]                    TxDataHS_2,
	input  logic [7:0]                    TxDataHS_3,
	input  logic [7:0]                    TxDataHS_4,
	input  logic [7:0]                    TxDataHS_5,
	input  logic [7:0]                    TxDataHS_6,
	input  logic [7:0]                    TxDataHS_7,
    output logic [NUM_DATA_LANE-1:0]      TxReadyHS,
    input  logic [NUM_DATA_LANE-1:0]      TxSkewCalHS,
    input  logic [NUM_DATA_LANE-1:0]      TxRequestEsc, 
    input  logic [3:0]                    TxTriggerEsc, 
    output logic [NUM_DATA_LANE-1:0]      TxStopStateD,
    input  logic [NUM_DATA_LANE-1:0]      TxUlpsExit,   
    output logic [NUM_DATA_LANE-1:0]      TxUlpsActiveNot,
    input  logic [NUM_DATA_LANE-1:0]      TxUlpsEsc,   
    input  logic [NUM_DATA_LANE-1:0]      TxLpdtEsc,
    input  logic [NUM_DATA_LANE-1:0]      TxValidEsc,
	input  logic [7:0]                    TxDataEsc_0,
	input  logic [7:0]                    TxDataEsc_1,
	input  logic [7:0]                    TxDataEsc_2,
	input  logic [7:0]                    TxDataEsc_3,
	input  logic [7:0]                    TxDataEsc_4,
	input  logic [7:0]                    TxDataEsc_5,
	input  logic [7:0]                    TxDataEsc_6,
	input  logic [7:0]                    TxDataEsc_7,
    output logic [NUM_DATA_LANE-1:0]      TxReadyEsc,
    input  logic       TurnRequest,
    output logic       TurnRequest_done,
    output logic       turnaround_timeout,
    output logic       RxUlpsEsc,
    output logic       RxUlpsActiveNot,
    output logic       RxLPDTEsc,
    output logic [7:0] RxDataEsc,
    output logic       RxValidEsc,
    output logic [3:0] RxTriggerEsc,
    output logic       RxStopState,
    output logic       ErrEsc,
    output logic       ErrControl
);
genvar i;
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2021.1"
`pragma protect key_keyowner = "Aldec" , key_keyname = "ALDEC15_001"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
j34G7MerzLPpxpuHscYAp5ydBIe9ADYE6CUPa/2UfjmtoAi9+B9MxgKbR2CHWi6F
l8e3sRmBaWWgwrf1HHEX+APBuAcdxlyBzlmNuceXLYuCgKpY48QJAiqGjrMYsHC2
sInB+k0B1hLLDWt2vwGW8TnOuvPpy0L+7B79+MIqn/UL59c7mlOoLLFdKTSg7vdK
xT4ZhxXhzTTQ5Hyjh7HQDbMzwAlD6wF4/9Q88WWlrRXCyulp7AHRdNjKBnq8kN5N
TdttWCOcHBDiZrZYMrADEjhSOxUQ/iMg4P18e1M9kOD0U7JLk9nSn08g5txE8chz
vYlSVVv/5xuLFv71iZ1WFA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 12848 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
