`timescale 1 ns / 1 ps
module `IP_MODULE_NAME(efx_dphy_bidir_rx) #(
    parameter tLPX_NS = 50,
    parameter tCLK_TERM_EN_NS = 38,
    parameter tD_TERM_EN_NS = 35,
    parameter tHS_SETTLE_NS = 85,
    parameter tHS_PREPARE_ZERO_NS = 145,
    parameter HS_BYTECLK_MHZ = 187,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter NUM_DATA_LANE = 4,
    parameter ENABLE_USER_DESKEWCAL = 0,
    parameter DPHY_CLOCK_MODE = "Continuous",
    parameter ENABLE_BIDIR = 1,
    parameter tLP_EXIT_NS = 100,
    parameter BTA_TIMEOUT_NS = 100000,
    parameter tHS_PREPARE_NS = 40,
    parameter tWAKEUP_NS = 1000,
    parameter tHS_EXIT_NS = 100,
    parameter tHS_ZERO_NS = 105,
    parameter tHS_TRAIL_NS = 60,
    parameter RXSTOPSTATE_L2H_DLY = 0
)(
    input logic        reset_n,
    input logic        clk,
    input logic        reset_byte_HS_n,
    input logic        clk_byte_HS,
    input logic        Rx_LP_CLK_P,
    input logic        Rx_LP_CLK_N,
    output logic       Rx_HS_enable_C,
    output logic       LVDS_termen_C,
    output logic       RxUlpsClkNot,  
    output logic       RxUlpsActiveClkNot,
    input  logic [NUM_DATA_LANE-1:0]      Rx_LP_D_P,
    input  logic [NUM_DATA_LANE-1:0]      Rx_LP_D_N,
    input logic  [7:0]                    Rx_HS_D_0,
    input logic  [7:0]                    Rx_HS_D_1,
    input logic  [7:0]                    Rx_HS_D_2,
    input logic  [7:0]                    Rx_HS_D_3,
    input logic  [7:0]                    Rx_HS_D_4,
    input logic  [7:0]                    Rx_HS_D_5,
    input logic  [7:0]                    Rx_HS_D_6,
    input logic  [7:0]                    Rx_HS_D_7,
    output logic [NUM_DATA_LANE-1:0]      Rx_HS_enable_D,
    output logic [NUM_DATA_LANE-1:0]      LVDS_termen_D,
    output logic [NUM_DATA_LANE-1:0]      fifo_rd_enable,
    input  logic [NUM_DATA_LANE-1:0]      fifo_rd_empty,
    output logic [NUM_DATA_LANE-1:0]      DLY_enable_D,
    output logic [NUM_DATA_LANE-1:0]      DLY_inc_D,
    input  logic [NUM_DATA_LANE-1:0]      u_dly_enable_D, 
    input  logic [NUM_DATA_LANE-1:0]      u_dly_inc_D, 
    output logic [NUM_DATA_LANE-1:0]      RxUlpsEsc,
    output logic [NUM_DATA_LANE-1:0]      RxUlpsActiveNot,
    output logic [NUM_DATA_LANE-1:0]      RxLPDTEsc,
    output logic [NUM_DATA_LANE-1:0]      RxValidEsc,
	output logic [7:0]                    RxDataEsc_0,
	output logic [7:0]                    RxDataEsc_1,
	output logic [7:0]                    RxDataEsc_2,
	output logic [7:0]                    RxDataEsc_3,
	output logic [7:0]                    RxDataEsc_4,
	output logic [7:0]                    RxDataEsc_5,
	output logic [7:0]                    RxDataEsc_6,
	output logic [7:0]                    RxDataEsc_7,
    output logic [NUM_DATA_LANE-1:0]      RxErrEsc,
    output logic [NUM_DATA_LANE-1:0]      RxErrControl,
    output logic [NUM_DATA_LANE-1:0]      RxErrSotSyncHS,
	output logic [7:0]                    RxDataHS_0,
	output logic [7:0]                    RxDataHS_1,
	output logic [7:0]                    RxDataHS_2,
	output logic [7:0]                    RxDataHS_3,
	output logic [7:0]                    RxDataHS_4,
	output logic [7:0]                    RxDataHS_5,
	output logic [7:0]                    RxDataHS_6,
	output logic [7:0]                    RxDataHS_7,
    output logic [NUM_DATA_LANE-1:0]      RxValidHS,
    output logic [NUM_DATA_LANE-1:0]      RxActiveHS,
    output logic [NUM_DATA_LANE-1:0]      RxSyncHS,
    output logic [NUM_DATA_LANE-1:0]      RxSkewCalHS,
    output logic [NUM_DATA_LANE-1:0]      RxStopState,
    output logic       Tx_LP_D_P,
    output logic       Tx_LP_D_P_OE,
    output logic       Tx_LP_D_N,
    output logic       Tx_LP_D_N_OE,
    input  logic       TxRequestEsc,
    input  logic [3:0] TxTriggerEsc, 
    input  logic       TxUlpsEsc,
    input  logic       TxUlpsExit,
    input  logic       TxLpdtEsc,
    input  logic [7:0] TxDataEsc,
    input  logic       TxValidEsc,
    output logic       TxReadyEsc,
    output logic       TxStopState,
    output logic       TxUlpsActiveNot,
    input  logic       TurnRequest,
    output logic       TurnRequest_done,
    output logic       turnaround_timeout
);
genvar i;
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2021.1"
`pragma protect key_keyowner = "Aldec" , key_keyname = "ALDEC15_001"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
d4ZERaHTVzgknozfJNUdlZH/6ZXlwTRf0MnIoIDz8fSLU6mQHHNQBy/AD2KeLyyA
gic2/Gkn3VD7U3IRsXTSQB45454fBD6ZjxDyeZS7Q6P5JxhuPpnfV/EjgQu+cB23
bSO+k0Ooc2mnaJMrR8nwN/plIEzpuPtl+7hBXtdOMqtsQtnbQdwTdP+f3hVCwpCG
kThObsywBQlbzcOzQOxzL0HGY+CbzdppOh/QmTz3Me51AZ3q5I8dZRUwpoFeEdQ1
e3ErjKTfTu+vcfrRHaz0R8Lw2SYtPdsSKmQkpHYisWx1SJBTFv+sevvUaXf1d5IJ
n4Y3yTOK+BnyqNTbtaWZBQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 12400 )
`pragma protect data_block
PVMhzo7fZIsiDMteYplJa1cAimsCnNJNEYrccTRdlp+2ENtDn6C6u/fg036di31+
Vb5FsDxQqlzzFwyxF5xy/gtlFc+NfgMPZyg8Mzb/fTeadeBOdusJ0dsH9T++2w1g
jqAhgHdoE/KHoPrM4/ld17S0JTkDnQlcrQU7mpjIm+WQp1wlsI+049MP9CPwp5Op
l0T6iEzKK9lJ6hGN6804y8BlhdHQtmgvg0Ea/P/hHi/uHliPV3Gj1X93EG1CSmIB
WQLyxHPe0Fh6KImrCdVUqsO9lpgJer/jdV22yYj1ZdKki0v9IwLXVCgtcIi6u5Fd
4tL5ZdkqjXvEWmy91+3zZkuc6gOygzYeR4dQkonA3icIeMbbR8JZV4Hz9sWGpc22
Rtv1XiwYHpwlNrmkbtXIdlpivoTQLvHymFEM8pSnPpWQ7KMTtmjFLpvlKLhTUL4J
dompR7iKg/zhvlqGvhswyk+4FNAljtWtUzcTpaXg3S9DRVNbA2+KDY8QPW8iKFty
Da6miTrTRXsjmlEsEjRx914My54Dq69NvqllY12voBVXETXse71wTBpuTm6tX4gY
QfPbrvXvuCiBY2GY+3Pz8KcdqWaQx7/EBpDFPSY1O1TKe33SvNesULXm0Bnpa02/
Vc+xc0EMwCMwqTpGKBYL014t7OZMZvR15RuSEqg3A3rbWdxWLAKLZ9LXUGKIZ3HU
CqFHRwYw2dxGUjQqj8+EkJh/+R5KjH+F8UZn14aIWAKkgy5wPNqpvMnM7HsrfChJ
Umiu1SXe6XaFfe1qrmpZzYzyvbUWyRhUsfk+eIyOMPRqg6yO4QJVRH9Z7HDi9k1I
9ARL91/hRwfg6m3qgD11FRtzBAOp+gFdqJZ7om2bUZZS+665DTXQ1S5sN+yuJkJT
4KNvG/EH78P7hW6CdvolWPupeU5t6ivewOgytL+1E9no7LnmpNJ/VXZSiJiu1XCI
XBbVtU+VUBklTeknIfNAxtDmnVGMOKe8ceDqjcwiTk4y+LqLaJ/Bp2iifY6drI8H
i10+7r1r0cmsAikiOpMq4rAiP2cAasBcGn6tXwZJL1719UH6kNDz4aFcQ9KmibkY
GBN1jEjO6SAovG3pAYr+Xt3F66JmzKXEy8loUguLGUImYAL6bovMTLTJ5Za/IHzF
JSiNvU4sKuMfLuaFOImwV9BkTPyct+HUaHIWPm/fNgIWNrr1xea1OhO7BwZJIE87
mc1KMRIn5vaLvnSj8Zpv6Z52XB1x3Qhe8OfDFbBkJnIXEuvtrFOUjwpdb9AtFJWB
9tvW4vhz6EvVjqMW+dBIBiKXAacfbsIyvANZgRO1UeDkiZfMY69bfB4/yV2R7uMd
G6OtCd8iOPNEOPnqOUBVsBoaewB73V4PPVYQZoGwQq5xfyCjBwR+nrsGfAKMrZP4
MWUsmJfxbGCHOnZkY1QiLeA8WO8/THu38tNdg2s2DP0+90x/4nFpH3ffVf560uNa
vQGP0WXboh5boA+4p48Hu15Dcsra4lZlQTyG08r85v3HEYpRgksMiUpdXA1aMuat
Ewqs7b3ZYhSJAJcemacq6HId1Q5XyJv99J8jUEqTDTAHQeDnKtfrbBfjj9TJsfjn
hZM6weDQE1KgIu5PjyAmYVW7LX3yPTI/Fn8V+JscIbZweD/5aE7caBunX73QWhku
juTCY7y2sKPceridhLH+yALOipGjQNf5GTEc+jHJsN26pjyGtZlRTQNo9CClV/B0
ffbOLQZH30NN4iSlaSf8IQnEOMxw+FkYzwvllsYt4Y5PtiG/Pa1d9hi6K6ChpSbB
kkB/Tl98PgTWREQxQ6IOLhBauJ8lt6nrg8z6zXh4jOiCB3tYjLbKy173RM45H7tp
8psEAb5I9memSnkAcYtwi9eAQ3Svci6RKxBhUNxmDR2uCOAnLDhc4XmU3W/mJ4EV
LP76LFOepaYHAQgpMzy8q4BkTwAX0vEG59Qc9d/A+uECJqJ+izbw2LIkuxmNKP49
VlRUqrpiRTt52s2XXCL4/g5qqo/afb5vA+ycaRkhXkNGhIikHXYRPkwABK0nNtc5
byUy9hu2Cn5W81XvHXBT2CaIbxNGQhTAXHtt+nUNxzZUhYWbkMeCp7pQKvvzgHhp
V3EuXb/iKnr1wUZRG9b7gijiNwPkxp80NrWkiiiUNKusOvB8dK9qfsSEvIgwnxs8
vVTZI4xcu8tn4J9ifKk0AuRTtf3epW+z0SdNElQL0fX/dt59l81OE91Hg66ld0aq
zx/IQwevf6iwDnCRYy9J05dx43O3sxoKqzH7QAGdhQwD0Tv9Q5V6rfzBJCkFBJsC
DibdXgtFOdLrksdLUwU20LMypEBAIKUUzOinhLc4SQOEzbTbzez/MN6yLH3ncsTJ
cqi11S4YdRF9WdV7+UiDE44UToGUAjUCJqa+flWLSgG0B6tLaraVlkD54DgTfD5O
2ENNhnId3N0tGDsJteJTJTTNOyj5G6vVQ7T1LIF0KVw8/oX+jgwC/1eU5Z19nH23
pKdXHBHu7Q2i3PTfnYGZ0g5m1INVZeyP/plfuqKUWl1oFUzvWG0EqY50bA+F3ovA
W72VBRzUGeitdWhFZj+/XCAblWOpt54mFVhL3MZPPJo66nQw1Mai8mA6nAFYcp6m
w6l7kky2n0VOfGBtPutCw7Szyc8NSYKpDCr6QY4HlNUnGWLgeLTMxJqAU6nNuyfq
zluavfcJch8NOZOEk/603nrtfJhgLXYdDcPaReWcC3QbvRUN3glzViDmULoG+AK4
m4EeWHxYnCAPtgXjPUQTbDQeymXqkLjbEUbU6LaWOTK0k+EtBHABEjIVmlKnoavr
KmAe56cFPd9PJw6R4e7BgMKv9VElLZ+wqsyNFkAVstEJYhprbf1SdCfAEPqra7dF
bbNbovB/fk+IRj2zh6c0PhQ2bM2kbw1W8qt9M1xFS0qcKQNrHBSYrYqtx6XXQ86K
/yp4hVmtH8vg6tj4doU7KSIDV8+TTwYl629NF/Qdq9avhjRwYsINDMNr+S9kOEuI
gCel4uDyAyLb/75BwKFkAQjK5cC5SwYV/8nbzCEZDoqN7Huq4exFowSJrarFJAtB
B9Q91arO0Yp7OZJujoW6GPCAGsGfymawwLuavrnbgamWwVTkIvJ2IMT2Q5EHnm37
yv3Bp3CcTH05qvtUs3imTF/pZFT8krZpeUGoz0/nJx5l6+gwcqAdsVJQq2vRekq8
QWd/yP0hovSmzLoUDOgci155fVOQovlG+D1okRPPv7oIsFVoNKcpu2p6XI5SkYWr
tXPT51z3IiqsxtKSjKcDRx9/Z8pjMXk/dT/EqsRHUkVgf1f2y+DXlN7BzveP0Lyp
B9aiI4PKkiN+wN9loeCi3+6/Jsy2ammeRy25WCVMqD6EH6ZkVgEq/Sr/0ygJjdte
xNHPJoWcQQ+qG9vsujWwcbSKqd1FoRbp2Nj+AAeLfXDc13jF6qcaBq6rsFjK29do
bFMDjl7DU4CeOA3rO5cS1l5st/ugY8UfUrJTvXpgZM6uxfgLD2rWJrj1e8AHJzIP
CXsA17EgifXyU1gsXgF3QUN5p46CUEhFasxzhfroSAwqNg+XDyelvo707UMNOxtu
JZ/MJ1LQ7PjSydQb5i8eYufWxph1VPFikAV1jrkzI1aNbXyEBB9VJWVtrawjFPFH
M82sN13oXamY2qWYP+cBdMThJSZs48B+dqigX2pQdn0Aoz0t9nBXS+D4QvJTakGa
tQ7Jz+ahiFBBYXJ6SNhVz0GKTXFv6WlB5VzxkdRXo6p2g9atQe/BCEZmzyNl2+aD
tWNwZJi1W/xabXO7CTpZQrS9QZhs/7+H9LvcoliHmLxFIfkeGRUBcoCkkzQ9vFUN
4syHghFFT4j01MF+PU4HfN3/KTezBtPYjyHCgDfccO4MUwK8oP3g+f5EqYHRWpgF
88TjUIKxy+Uy28y1qGn6l0mbj5Dkli1neWhwZwzlNaCmXyku2R4kLS4nlStlWkD7
rZHzZiga8q2Tujmmw+CG60dKh7akAvtY0Xx6cUa5SrYEP87du2CdEye4jBHKaXdi
C0EuHMxEQqonwEQzd3xtc4gUIWA4/XJVvbqYflUr/fbxhBX4TdLIxVLu6cNi6Qly
qVOVNHSVCWretkTvvxDLFOa/joHFD6ZyMCbRghxSKqBg5hVW/LKwbH9SvpZGiKUO
YUFvFHBiPuGuzz4fOu+7UH6gnlFAASscZZ4zQX1Dzl0rSPaqRxwPvvG4FfktDh/8
ud1H4+uNgJ1X/Qq+7q9gbKtpbtpL51jhKAHj/EskI7mxZjimcegOVt44Rd6mkkiB
AG9uKRF+0yGr9KP5IgD42BGpyOOldweHP0pbd1RplBFK57bSzhoLpLtpz4S4jXDQ
iU0C17sgUAlD39gh7s05ZiNNTB0Vf7Re6Ley+9AH03qoYuBpnL4Te6HOmOOJ879W
QPuFPD9+XtCvXF37n8nZCGnN4Js5DATTdZ8FDu9e9yCGneVUTA+4KLW6OVPKoHwB
5Fs+LiVB9cDZvqQaaKvMrhAuYVQOEEJiVrowWJYM4OL0JOhxh+3QLMFfd1p3D3bK
VqzCO8u9cpD/j23gMvqUPom2I4JL6a7mnKlnSdlQq1fnQGJTDZSJOw9m20OU4FYv
1XI6tHt5kQNsWq7nYJ3dqSLoVnVuZfg87phuvS0hImDnDGGFZCVNH5EuEClg4KTw
wRxiPfTtRacxotebQcJsDrPXmvO+hkwsjlkRuuBcyNzR8NqSr2hJtSS2w6A5ejvd
i5IQLm1/mYurxYA9a66eu0fYa8bZ/70BpaVwDNVMFxCO9apm9C611glVbFHEJuf3
VY5NN4vr1LiG3pBrfxlWK8yThybl7f/3h8I9JiqTzvgS0+YxQhA6EanBaOBrk0Le
JwZ9uQHaz/YEGxGIKRXtHnEg/JLNWiX6IujG28EVS4FaIQFJgwxYwijgn4wafWOC
4/bh0U118qgj7GWCUAD9Fv6F/gtIFzSuNNVB8kQ/PfbXnuvSrzvLWTlysxOx7deS
7tMsmR9xd+kLk8nJlQY8Tlmwd4fi92ylJbrtwvGKD9T3DdCSIzE92Y5evUheuKqq
jh/0BKXqF5faARoPuWn8VnRLWt9h250y+Kik6Kk6jZVwtLWMvzrp8TRLkDKdtXT9
BeZU7naIZV9Gb1vXPMyXs3mEOjpJGcIGCWkoD9kFulntT4IwZtreHBOtTYCBW3X0
pXLmL04kWJNPnQSzdhnywzNWsTCYdY+BVc2z6CsQZbRh4kaNF1KVLkrEmv3JHhkk
4+hPfZKTfI2RXdBlZiADg2VOV9Za7oCZc8+q+/28pvFsYabC4D2jED7/p1GXDVZ6
ceGwN5KIRvuO5/z6KGN0zqgw1P1KGnB4yuUTQuWzdjKpW79n8cNf2vAzj9kTW1Ea
wgbiedmBgCaDSSDHTGZpH5rsYdm0hJp45fVgVkjigfqQsDI30kVhPNJkr+mZOC+d
bH4JEuS/LIn9EXcy7yDJoco2HKwC9RvXd+37WcOzEQFEfi2iTlDVoxAbugZ3FDLQ
dkTagRpO8NxpP7/YTLnCGhoJ10VeHKqa82JiGfycdqhKyIWdUvxWRDGCmlubkr7T
jNuqKX2uxIXrvRfEhIGbCrlEj7IJgYN0MrX5V9XsIqtX61o8YUEmtO+m0v7j+irA
sa+BsfZn3fxzegs9sce7mNllSgwWyJ1IX6s360cOQ6on2gTCVt+pYXrMO0ANic6K
qWr+6IPpGpzpH1n7kIYkAsD4BQT3HVdtdmjAwmXmP5mRUneIuDeWlYsIW0UqoUp9
N6Cw3+ZFHyErm6hb5D4ym/n9wzOy5akrebvYO7v+n9gXFXDRIYOhfFmt7Qr3xtZN
9H0vlGbwUv7bJ9lDGYGac7EIxgIIFBediOQxqDT656RxyJaXpBD+8j/ochB1W3gJ
Zf3q/dxjTZIIxqGmkp7tZVFS9kjsTIdRg5HZyeT7DK/noIl41rT8atS0ZnRtBLgw
a4p3FlHM2BdkG22PraCf4vFusizhZEpnLdDp5lJeBetQnboRUc0fbk/P5aFEK1Fb
5mMf6QMJTObje12oH7ltJ3EdEaIRzKF9dGaxhQ8AbL34sGpUWmTVla/0SnOiLQMH
DE16aICPWC4D0JrTlyG78wDoQHK3r+3OxVz9OTQTJR+Ty/DfR/9quyuBAxpzsvpm
Owo/qQIKpa7W504bAK365pXPZQHGSCiq1gSEc64jgrNgB2rqr5DSNLSpU/HkppqV
aIE4Sh3lAkTYpH/8trcf8TaDWN1Wkk+mF5MhdUCFQn7yYg924Gj9U+po+f41ioxB
M5UB/vrxoRhJuTNJLlUcGf78g5QHOyoQaf7kXUDmwcdYnfoonQIZPd98/QJ89TYH
oopo2NUv1u39gM5RGrp9JnEGTgmq+mZlegHfnsil6jVFcD0Wx6HzqC/A5kfjBkpy
+qM4kaEycGejv3/2aRK3IF5Va0Vj0Q3Y9KB4GT9MSxnISmE1zcZ5cvIKDpCf8PfU
QPctk39ki7Wcb9vQQ+2Ro8EaIHaLK1z4m7XbcxsCDY6hBufmd0DvEyOb3tIm3m1e
jCT21+P7bg4c3WJi99Zc1NG/z7OIMBNTQABnu9O3XixLETiiSuEvEZWWnIdcdb6u
jFL+EwPTLSWo7CjxMeP+4PR5A0zTVKpeiZfRRHWYkudV1eLPYYv33SoTRFYBbc+o
vAZBOSmWU1zzoYKNZAoeY5n0OmRTpumXd3fSEv8LvMCSdD0LobO86vHQTwCAmV2D
dEbMes5cbPesXjDAn72DZ8xpNXnzz8cTx/f8RH/grZgHYmAfZ/R8j5sEYY563zLQ
eqQryrpg8dbG388WDmgMePFm3KhadRIZErY9gx/QcAUfGwwcv0fjPUnBJ1N7GuU4
cRBZDpFlpV/QFB98J+CIxqDDjjnmXirsoyis2BkWuFFr3lpGC+Pu/jBtr1rytMTd
OtKbhwPRC5CLbK8n4l4aDY8jtxJMntlZC/o70AqunRrg9HBE6mM03gbNf1KxXGAj
5HUpmcEzh3zLduSkw9wv7xVo59tQ+y2GUb6lue+AjPvC11muXC5FjNb571fnVbax
PCNJLKXWbIl96vZYpadTeXo/OAekFqI+IHN/6MY040wBzVSSTGQW+RCdJjSN11TD
tlf4Z6d4DvE90PiX6dhn2G28aL1y4GZiPpQKE6FFmSnjO0SStE0OYiO0qgK3C3oX
eT7+TA0mpNHUoh/zzyf2CN77bthf4/xwUQKA4zQ2VONSAFvF+LVqjD/CqJKz2y5L
IYuJyTzm6Hnz5tJU29bXo5N0Or16LIBKqzj3muyWdhU5GWR6I8MhXocPvtFEbybK
rq7mfJpUn6lTgc1xGryydAfC9HXs8FWq0xVWOJGHo9pxKWKxkWX4dCU1bntPt5rS
BTHfXuRvHOMzlbXfV2vfo5C8Tt4sEn6AptfqG/QRRrsRg4aqrnB23IhtorRZu5QO
RFybcg0x/+aqmCzJ6Qri8CinQP/9Vgbie5SovndMBWg2/lsC66u2fJilRtz4D/+u
2qlqyaIH+ubwgUkREiKbw9wBuPzSX5CQIRpu5+cP+wyXRMWLNytuZGLTdKeOWjJu
7cMoqsSJQSY/CSSP7zlBV3DsvKgqKJSrLeeXhRunGJ+LfWBJk3QfYlM22P/jj80y
w5ybYGszG8a7fbPdfSp7NeTTfsx5GCVlmuVliCA0wjR5TKojWa9mnelMMxl41ixg
wxl+TN6u2ZZtBMMgSsU6G1/V0mD200aCvvkQRy5puLNlrPKnpofeXbJH7p3ikfSr
WnHUj9DtEAN6x8RbitFtZfGRv/Mu2qBA8n9ZT5Yf2Jj/o+QvmYvwnpgKOtWNqG40
PT2kSBr/aFL4LoaWbyujTuqHbdu8JAc7nWPcnIakv+JsmjlphjgUBr+pYBYEEJq8
DujjY7beQMHwmxsXSKQZDxoPddKmv7evVBpHzWriJt5YATVHM17BEnigiLr2JHbb
8quBVfhgYO5wqWqWKHqqIXmF6w9zaBqvnwFpPRdRjACt73suEHtgoeXpltZ2TkaY
pQRuW8asfT1+nf4L6wsvrcNSFih4Qa2HmZ3ujp6pNkRRM2L8w1XjFPXcNKPyvjD3
LKoOym7KoXrtbvIz06TM9Ug0BKewITWSpPuEJxL09yqSqRBA/Zg15C1iPselJ5Qw
SXuz6FYa0EGC45R+RNr65nMnywuRDSlUTh8PsjZDrARc93rcOnWC59Jwtlk1RV+L
SZ+yC8LMAhIgxQFAnr5PMvL7tM2fp1ppO7BAbP5hTToalHWTAAWb87Z9QWFFW7GS
fnAVANHRuHXkrmLoIk2nHatu6DuwxNE0RWawbJ23OEn29O32pWVmr9cd0isM5nK1
PcHBMrelGizxpi12S30G7iKcd2Po6CxIYPdSL1+w1xL4U6PbCNdfmDgJp14k/Cmk
94sIn8akFg5NUYn2U+HGZeDjLD4VmhwCI0mP0MZ6qbJf5otJmYLqtbviTHpOzZUt
zF0Nh8mWhwhct52HXon7tXlKKEOvXumKYVmfx/2MAtIISZXn4BWDlHsOkClDzQ8p
EGoR99QbS3Q+2fIfBze8rUO6dmQnnoOEHmfDB7ZAiHQ//xYQ8ohAo1xso5Zm0nQ2
kzYCkxbnBZ3FRBCyqnoHjI4tgMBCwjRNZMtvgGMul1kVPUp3UENtOaYTnv0LaB4j
0o0VwEoamdf4q2bqfUO1Y63aaZFn7Z06EHR8FL33ZLt19wM1CWOZaGjV3JsMrB8w
zkLmirmpYmjCYOjXudpoafaj8+VhcFluOmf+1AIOsTmd6hteLgQ9uHuXNTZg8k/8
ilTsfqpa5WkQDhLziQ28owczdq+DRrbZ26c2Tqix+WdC4Y7RbZqwlJ+oUBjiJ07w
/cHMQl1e+5NP51yQodJJHdFkS+m/tJLKlHrKMxlKngXwd4EnT4KV3w1LWLctzwwk
/Yk+E1jAg3b343IENyc+4GH4mYIxbKdJt9ojaw6g/RFxHTUThMF17O3yERM5TrKt
zMiQYIvxaqKaL7n5FehRemHQLSUY8zAeKg2KPqkFqZlGP0LDRV0/wef+Y+5PiLqC
IT7i9QzpBWSAXztfIuBYLAks359Ie2PPCWqtj6n+60q28r7EDcPUGb+shRBciMFW
jvlO2+E+mSwQ0esRT5LGf0KLfsEliYufJvp97qjjgxB/etf0Eh1OXlu6D77nq8jV
no5SV5H7CeaZ0y6p8FUQWTgERPfYE4KloDaqCP8fA+lss5LzKS0nY6Sv/fmYW++M
O1D2czXDTBVWTIos1FctsYDeKFc8l46vNghc1+I1pX+rd8rvv2oFKr0A3OvEiwst
FYtnYwA/NxgKOrZsgggXAleIfo+FT4XeV/ynJYsTIh3DpZlh9+0MAQPRjrNrUdQm
ONqh3APWpCuRoKzruMKk+okCapKNshgIXYx0N0Qlzyl88K2D9f3SNJjdjeS55X+I
QyZMImg9T32Uf2NOHl7ehgwSl8HOD/4hMDQ8f9lvn75/3Opq9vHdy6+UyJ6zd/tb
sdizSfwSl9w3dMgS5g0hHWHRtsOJW2LZCeDG5zYM6tEq5HWnrDocB/4UjaQ69lgO
xLwEyRK9MhtgRscb7nkTvUYOC7DmiCL/T4v6fxO2LNzzEv6mxshTw6tzpbXsFxBg
esNT/f9orzqoPzjsImy4zDCT3p2U1he/ZVnq/hHmLw8cs9JNrlunajA3oaJfJ6jO
l3g/N8nA6X8r+RtA4Tn8ZQQZB9x8Sc6pbIvBlXc1JM5vr6m/nF6uhRD7hCmnSPCs
8P+Ggc+dGm5dLQ+O4EehCEMMw6e0vJqqs1uKBDrtRy4RA1+7SD1HctnReA1FTTXd
+aZSZICEoKbHOyjAzXUviruPhamqUMiMJvAtWjfEY4ENmZyF9h81UrZjmvNjzKr0
kCndAXuFlqhpslmS7Npkh3YyDoM87Q6awAoWxf1lRDmY1aYBc0rxpMGbSlWFyof6
SA6qO/XuuXwe4lT+aJiBFLrFbAz4mLmbQDSJz7Bepwnku/Jda+hjcIIFgXyQCQoP
zCMBJbLm4lKRLO4JWZt4Z8oWLopVi/nq0I+Gl4bYofFoUh9XwKiana2yrC/3c9D2
xyzYSFTvA+NqGkyy6YvTATHZKicVqZqbVJHfx01nAlp18UaLPHH96AFujGb6hRuY
h58JBOKTWU8u3TbJDAX12W8MEGLTYEpIOMgnP8W/OJVpj7xlk3n4O/Z5troeFqSw
KnpLj+KNQsI4vx0MYj7wF28agrm2yDf/w/Jm1lnvfC2XlzAezCxx4pk/l9Uk0Ww3
gfaE3huFJbqMSnwWJLvLDUbDo4PFeyUhRLD4i7BP5loueqdKyqZDM31aa3Xdgoro
dalHavK4pxCX77ARntjH7dvH4gLVMDhvDbj6pymURm2OFM0PjFjg+sIGLTh6hmMP
4fW/dGjmx1EdscGViWR6h8nC1MsZ0dVIyRSHWCXjX4qQpsyux0gxNERAFj4MNA93
9AC8ZMUJSl4dwVZgAL2oXtaMZ5u+LeJ15dXgjih54t1DM8pzFx+t2ukF8QPhR032
E+f7fyaEDvjqt8vuBge8A2zdxyqpZsB+8DXUxMm0zevBme0b1VQVr3ts9rD8twVb
dQiO5ARfWrLdBE7pUD5k9NF2mlhREIeDNOfu6m1qu9tGh5WFh//pLjV26701tDHE
HqPfyIsl3VDK3kdiuq09Io8YmMf8a9ZMgQi6oF0ZYTjMwF9PgJxBmYGovipTIoMc
OuiHnGoEdP4BVVj+H3q4lpTQCyob7uj9M0OAMQj6aPAVTsUVU6v255Q5Y5krqdUp
aMJuRmW8fnuXdDC9E/4hI9NpC7bZ5KUC16QHymtjvm1kABsuUm+6r2Aonok0HKi5
I+diVRMWfmSIEb7zfblvgZ21W1c7eb9X7TgOpbmjSqM9kjmBefahtlH553n3k8Nk
EwE2l28Bv1j8W6yntxHsGmqmzwq4gwP4hqpM6mhY/aZMEwqcln7VCd5+TEl6Pr8/
VKxgKZpbhIOPpued6vvWFknog3L2m1OJUoUGIFPsO7sxfXhOuZjJjxRyrzaJLDkO
Unjt6++XEAd2RWgwQhiG2xyK5gk6YsD77QhrUygMCQHo70xo/yzZeApLdLRH1b/Y
/lFx7bbtRTyBQVvE9vgSrMN8HGueiepzbSfshoSZ9oddyeequc17yiNAlKSO/A8b
mGQz1EJ0v7/MLTDo3hKXmdst8lf7Fj+SLnRr6i6IDP6gfBqxWfYm2fkW8YZjxjKr
B4hGyKetkWYD+D0Yx2B6GMCrJYVWWFb+f5X+Uds/tvxJXU7vGQ+5pHqrNXAMDFIi
vRR+iqUlFpPII21vRG1Q1yq+ovFFzZ5qbnHSFhXtoyegjvL2MzZaXM13M7TMypRE
DQI7KzJYRak3Li3h8RwAY3z+ixVJn568NITJXoLtUvpGJNTshJx6InHVI2vvKuIa
jc+jPY2u/zQYGyNOnSkdy/9XBxuCHKHAAdeqOZ8VKjxo82aEBdHG0gkYMZffQf/t
ShRCQ2DbJFexHdGIHLMnc7MmqufbDi3SrwYAmQju1NoIYU+qIsPWoHgnU8HW/kgn
GyHeiId9mAKrDYNzKIHsVuorssQf94jxrGilcwiiFFJnrk9vjCjqgt9nPsLk4kcY
50ALBK1h/pvJ7QX5WhdTAfdNE3Quq496PtuDwDb70gqHemTkR6+nKazsnUQu2xPK
9JLXJquFq6sP4qmj87to/s/dvwkBO4+csEs9wAZ/+LNrQXWFLl6ValN5OHWp6ldX
DaseRNo7g21PT3HWmteenGAeNua1FzquicfW1Gh8qzSvJq9oSPM/pbzSVsETSjYj
2JoDyi8CUOij6S96d9H0SDHPv0ZAAMryW0Ehls/6dto9W64vSqYUgk6i0eJme5jm
3IEJKWB+RlfoVx0U822nUhlSTHjkKdqwNu5uYSsAsrteJyP5pHY7InviAgWggVAX
oHFToxErqLA0TWY93q8J8r0W3WK19b3rVfvtj7bxH4KSqk4SXg5nw2xoWs3R9hiI
zbsgyk+NPDEiDaZlz1jChaLyDu+DkaxON+syaG4iFim1fp/nxsWzfc2jk9y+QAyC
sxmXShb2a0e0RxC241GEeoiYmzyHUPhdbttVIQCPeE9ZaYUdU6l+KoiVEVjWmCjA
3ULFMr4VEpiCab2vHgqR/Sf9JFpsmnzZc0eglgPfAObg09HP8nbHd47Qmvu2TnzE
hwWNd1WrmGy1wWp/9mguezoSobz7KD6g5HAOp2N2MTisPvVM000ASXX0hwgq+09b
FHvMo/RxeolrJvgnuZy1asesBm/U3UgldnQIxxvp5JAVs5hz3qD9sYYp1iFVXHXX
O+hyY5qbOE2mQbrAC6cQVhz5h302OzH9TfGGLgWAjwRnNnlyMe5CyLRXBn+WYjFj
pnOYOCjveda8Onk9rluXi844IOQjBRJdcKyM6EjDLM57K62BUPIzEyS9HLd34IYJ
1mkbM83YF7W3K3RYLolqU0wn4NIsiFk0DruYtK/1NoALuO7QMOo3RhsTtMAX+nEU
ajxy11nELw4sFwbY19CER4H7S6jBMaBA3haxFtW0lvS1RKPg8HJud9+p3XgsZKT7
sKmdUMuXf2ed9nYTk/queSwFvVdTMM+LjX/KJ+PV+wisAh0Fcu6EiC9HZFwv86h2
/4g0bxDe8g0tIl6EC3UC+2C37XRXp3D67CO9gqJ3FUKjF20LqbRKcwvf4iulUNSH
eHfmlntzVNdU86xXrCsFk84Cn4R/3zGT9Fn4v0zXEmrpePDdZ7qjDhU/ti0rNt8m
/WNkxbjjiX/SL0J+BmXjFEUWNCXEENFQZ11YxA8TifvsXFiyLXrvn2wfVozPmpGA
r/+wGmBBwxPBRMKyXATBbxBIQI5BIz3ji5QkWytR9t4DUHGEm3/ZpSaZIdMvwr/k
BhrxzaQM8CsBopkT1rCZvXVdXMcdvO9ePyc2sQidbUAOwhgn71kIpZVUnW5za7O9
uosU+LIJX+dNuFAxBELKjMMSBJtBk5g3r4eBeqKlbxhsvOzXc4vrt05tvLyU1Zhr
bzOCQU1Ofe6imPsxBULGoay6kadlCyUHvdpX3fhpq29LFxr5V7s1KQenmyz5SNvP
YIWYpjKlOWg6Tr5VZShcAmBbfiwqwEkKGlVjiGuCf7aLrrIKB99qDyLAU/ByIT4o
A05T82RiY6HMMp8p1lHY87M2vnAm1C4XIswNE2jDsXrPpfYkbE2iki1ppsQ0W3JB
QowCOo8fVo0tI11IgH6aZzF6+uTQK3rRmwm7PDJvkEG+V/y5bNjUrtzIABJbXlr9
AY5VwJNs+7hWHZkIF/KGkZNJ4ZDdWv6O1a38BZCl0UOmzX9EQMXRefrOBATgZIdz
i3IBm1FH0V/cGnANukjUADSTy8I8v5oFzcqkr/e9fsj3e62AjHSwAGQmnAy+/Whn
E7U+xo+1+KgFZiN/R0+qkl4+9eaAkyV1tbAezmnv/Qdh90d/ER0zgfE1g4hFJZIh
Z6qDuCLGhPLYibA0MA+gUpJz0B5BBvLO6VP010+WannJo+GXD6e+euPCLoPog/l5
3nUULXGXWpvDpHfb4y/lTObYSfAIhRScDA4tMi6UzorC9Kga/70ePH8Jf2DfGWf4
CQBqM4XV5nrF5ZXgxz3bmvGT6TRmJFnFIRJ0iiFWa7liA1xwcY4qiyaNUq7zJDVX
FMt/djrJnouZolK9lEnD9o3On8FtM+5VPem7JCoxnAbd3wPw63depO+TVC0XS8qD
P1dSxD8dm4RMo3chaF6jQgHL54FsdZSD/IONW3k3JTW81OIxOL7GHvMoJf8u7tKo
25eOqKU/74jY+w+JjUSXoDwWEnEILq23qcKuhYtrKa88+aEuv2EMWmZ04EkeKvFX
tKujiN0NBfXZlv/nKzHe7MVymfK9TKyH9lQ6DCsKpH/JeJWp7HEgDzzE2ViZ49Ii
7cyDeOrgg+VOkvgP7nWwguWDv1DuiCwWZRaPiA7tHKWXXHXaSbEY3esxD0tQAx5M
/JAhc+Kg5WwXghtA0SgXdrY1oIt/9SM8hXdPWOVUjQJu0WjxYRiyE5UMMRP6x2Lw
XyPZHcaHrVTAvfW/1FSnvfR+1r3TnJbkvGmVQeCIWia3W9BBn5DhMjJkEWfpCBwC
+asjjzUoAokE0uyKQ5uq62pMtsxjXU+QPfwu8CHf3AoisVqq2KW/9A9tgPmbI5L5
t6K2U4aB0UxtCWvep1u8c4mKKcrxKj2usD5aqS/NC7FzUzW4Cz6Gk+oFhnrs+x0e
ye0neCOF0hO5nwPfz5OLUFoN+JiOL98lC3T60D63oWBEtHjem9FQfmPoL52CbIHl
S+t/pmjeN8aPaS/3YXvdvc3C7Nbm5qebqyFCi42ylqSWdCLfYPueO7vJ2j2X3Rr5
rL5y3EazmbjQ60Tpyoxp6QDUGy7otpk601vW3ncqB1sLC+z3iPibxzREqGzpnQLH
wF+6SxkjFXDibXyQi2mry/+vN2eoofGquEn5V9whFOp6jqNSfOiUMNe5TO+flEf3
+o9+OQo5dHp2I8K5iNuCHaLWrdrKDRgbwG/IaIR7jp1jtqD5uKCxr9tHhwAhTxI4
0CEDr3pJjcnQtoy6Dt97GJB4lhSj3JnJSaasvBU4LmjQ51WsgUVZW+XyXxPGxDjW
TUtFsyQQUzecanN3A76MXd53jg0DwqrR3hjoQMfUp7konMEWd2xTfrr10gWryNDp
veCjxmnNehbq0fdEeuAxQoAVmPKAnlEAXs7roFEI6i3t+MB/3il02BafPjMz6scO
tfKzrnJkIh72ZV5WgG9Nwzpe5RQNGLBpm50SWbqeMNHyI55/TqgsVWGRZTH16NG7
1HM4MXsSGqaaCcC50gzWiRWQBiUe1rLapBQTDtRCibFX09MJpttmZhLZQdxRCgha
O8JowfXX7NBYBOkyDhDdMCsbDZzvTCmpM0KNAyIUjpScg3LLpU7HQY+tWGy7a2YY
s7vaUH6kE31EVH5NYFF9vGrZEQCki3rZjeNAnH9bmP+4nJ3fvoOshulckwzrtHw4
HwRpBIxJvb9Dr1ZlSn7ymOHb7OOWeOr2tOWp8QpLAeQOOIz8M2iF9VT4xgZnMlVA
hBXiOn15EdafUDt+3pPVcGLHEzI37Yq7CDea/Jr0c1M8u3dBBu+QUqpqmY2Dlmzt
GAXsRM9UmkNVyT8DJU109dbrVv8ykl5WivlMCFAYmZCXz6CdP2pRhPNPeeXpONDW
w7vRzOzoCRL/Asa5ub9RlfyLnkSFHj3i9nihXUW7HwgXp9g6BTxGxquLnOAIYQzL
nIfZ/bimSZC6H9fqgHoz4WL/HJBKIS69yMWq9Owq1YX9WEHiiWUblMNs2nKwBO9S
oRv8n/lweGtrRQH9Jc8i8fvLN/D+k+THg7jIWHe6xsw3uIr25+oigQr8AoCF2TBS
kS9tsjaSMV4oa+kL9NadcrT3H9k30JFQJuWlkbufCkzvfa00GhJR5L2cSNBk99B/
v/jR9968BDggR4HNnlTa2p8vOb3K4U4VtK4WuarkM/tskpzTq/WVa9t0EmNcLuCy
hmTJ8z5CBhqF3g5aE+21OQBTVy7blAupaXB9YOI4q0jrcjcJwwoltr/4XD/Q92ew
vN6wc9vKhFilqvfzGcHdlVJBY/8S7+D1Vckh1na5XLHhZCfDw0FXJL6sA1CFWJV2
UmMgNqmooPEoi79HHvjHixZ8qCv8DT2fWBxUTy9nqQIl2YvTV9/rjvebIhR/5taw
XZdfEQWJBItd19/ZdHldOIUBalEktPELwbg1ccNa81BWDzMNIt1Pz+2Ts3PtQi/8
Xui7iS7r3nEAVdD7cJOagTXK1jmrfbEydQ4ks1mAt8Xic6NtiMGLgfbxzdv0Fqu1
T92H3flM3SSt/VUgn6Vt0oo3/Fg6N8vVmjbQ0FSIz6iurJnIXUqU7f0j/FMbna1p
Bw/0Xk161bJlJfKIvX7M424BuvTNVg2EG9LOBqIPoZpCPoCW7ng1rpGd/vwEO6cu
A+DGFYkKb5IJyGvoc2g+VNKkhWNVPp6bfaSPV6m/tURtzK/iz05dUwiBo+8NolJ6
lV8SPORGJKM08ahpOs215qA2P9rjgQmPotWV/k6nNzDS2uDc14zm+Z2YV7ytutLH
MI7cqliCasr0pPuWGgJUMxHsZApFMifF4B74JPAsEc69sjEW/1TWogAy1kS3K7ja
RKallbF4s8QVizzVQN1EFeJZrB4a2BmLZ4mvWBhlhtTyeL/ydrG/K4EYkbJNYW+p
MLIqNJp+E+nhVVJvvQ5fG08SVSID0lidXxpJLa2syn11chmH2NDGuXaiMQyuHPsc
5C1GzruRgvG74K0PbV8+Gf0eDZ2c+JAGPrHbHGmga/JI4lkxq7rPMpq6+FwLOnlB
lGYAaYj5ENWTWuQwehbOrnuMbMGoHSrA2mudy4mNK+9mSehTsQOv8urPoO70GDDp
7ECobpwEKxZIEGF2ANzpCvZkrzJFDTR7R4zURQnc9vMl0iXCw6s94lppFZ610eBF
R3+0K3+WEGiNRrK1aKChjSC3X1FWWqtG9AsVNKEU/ALErzXLYIjIo4kldzTmVDGj
1M4vdgFXpF6Q5KcluuYWgQ==
`pragma protect end_protected

//pragma protect end
