`timescale 1 ns / 1 ps
module `IP_MODULE_NAME(efx_csi2_tx) #(
    parameter tLPX_NS = 50,
    parameter tINIT_NS = 100000,
    parameter tINIT_SKEWCAL_NS = 100000,
    parameter tLP_EXIT_NS = 100,
    parameter tCLK_ZERO_NS = 262,
    parameter tCLK_TRAIL_NS = 60,
    parameter tCLK_POST_NS = 60,
    parameter tCLK_PRE_NS = 10,
    parameter tCLK_PREPARE_NS = 38,
    parameter tHS_PREPARE_NS = 40,
    parameter tWAKEUP_NS = 1000,
    parameter tHS_EXIT_NS = 100,
    parameter tHS_ZERO_NS = 105,
    parameter tHS_TRAIL_NS = 60,
    parameter NUM_DATA_LANE = 4,
    parameter HS_BYTECLK_MHZ = 100,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter DPHY_CLOCK_MODE = "Continuous", 
    parameter PACK_TYPE = 4'b1111,
    parameter PIXEL_FIFO_DEPTH = 2048,  
    parameter ENABLE_VCX = 0,
    parameter FRAME_MODE = "GENERIC",    
    parameter ASYNC_STAGE = 2
)(
    input logic           reset_n,
    input logic           clk,				
    input logic           reset_byte_HS_n,
    input logic           clk_byte_HS,
    input logic           reset_pixel_n,
    input logic           clk_pixel,
	output logic          Tx_LP_CLK_P,
	output logic          Tx_LP_CLK_P_OE,
	output logic          Tx_LP_CLK_N,
	output logic          Tx_LP_CLK_N_OE,
	output logic [7:0]    Tx_HS_C,
	output logic          Tx_HS_enable_C,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_P,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_P_OE,
	output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_N,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_N_OE,
	output logic [7:0]                       Tx_HS_D_0,
	output logic [7:0]                       Tx_HS_D_1,
	output logic [7:0]                       Tx_HS_D_2,
	output logic [7:0]                       Tx_HS_D_3,
	output logic [7:0]                       Tx_HS_D_4,
	output logic [7:0]                       Tx_HS_D_5,
	output logic [7:0]                       Tx_HS_D_6,
	output logic [7:0]                       Tx_HS_D_7,
	output logic [NUM_DATA_LANE-1:0]         Tx_HS_enable_D,
    input  logic          axi_clk,
    input  logic          axi_reset_n,
    input  logic   [5:0]  axi_awaddr,
    input  logic          axi_awvalid,
    output logic          axi_awready,
    input  logic   [31:0] axi_wdata,
    input  logic          axi_wvalid,
    output logic          axi_wready,
    output logic          axi_bvalid,
    input  logic          axi_bready,
    input  logic   [5:0]  axi_araddr,
    input  logic          axi_arvalid,
    output logic          axi_arready,
    output logic   [31:0] axi_rdata,
    output logic          axi_rvalid,
    input                 axi_rready,
    input logic           hsync_vc0,
    input logic           hsync_vc1,
    input logic           hsync_vc2,
    input logic           hsync_vc3,
    input logic           vsync_vc0,
    input logic           vsync_vc1,
    input logic           vsync_vc2,
    input logic           vsync_vc3,
    input logic           hsync_vc4,
    input logic           hsync_vc5,
    input logic           hsync_vc6,
    input logic           hsync_vc7,
    input logic           hsync_vc8,
    input logic           hsync_vc9,
    input logic           hsync_vc10,
    input logic           hsync_vc11,
    input logic           hsync_vc12,
    input logic           hsync_vc13,
    input logic           hsync_vc14,
    input logic           hsync_vc15,
    input logic           vsync_vc4,
    input logic           vsync_vc5,
    input logic           vsync_vc6,
    input logic           vsync_vc7,
    input logic           vsync_vc8,
    input logic           vsync_vc9,
    input logic           vsync_vc10,
    input logic           vsync_vc11,
    input logic           vsync_vc12,
    input logic           vsync_vc13,
    input logic           vsync_vc14,
    input logic           vsync_vc15,
    input logic [5:0]     datatype,   
    input logic [63:0]    pixel_data,
    input logic           pixel_data_valid,
    input logic [15:0]    haddr,   
    input logic [15:0]    line_num,
    input logic [15:0]    frame_num,
`ifdef MIPI_CSI2_TX_DEBUG
    input  logic [31:0]   mipi_debug_in,
    output logic [31:0]   mipi_debug_out,
`endif
    output logic          irq
);
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2021.1"
`pragma protect key_keyowner = "Synopsys" , key_keyname = "SNPS-VCS-RSA-2"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 128 )
`pragma protect key_block
jbw9GRi0dzZ6EytzTW9rzFqjyAf4KKZQxFtM/rZ3Q8wzgfNgaExKKxMn+w0wvpXi
YSC4YIbO6N56VA3x8QuEcBD8cNjneKoEwzlDyD9hWAs9xEqlU9go6y0jQDTqjOQi
BOk/75Fu0t0EaTzNM1ZnogBS6fWTOAfRPFlXEMyhuuI=
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 7840 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
