`timescale 1 ns / 1 ps
module `IP_MODULE_NAME(efx_csi2_tx) #(
    parameter tLPX_NS = 50,
    parameter tINIT_NS = 100000,
    parameter tINIT_SKEWCAL_NS = 100000,
    parameter tLP_EXIT_NS = 100,
    parameter tCLK_ZERO_NS = 262,
    parameter tCLK_TRAIL_NS = 60,
    parameter tCLK_POST_NS = 60,
    parameter tCLK_PRE_NS = 10,
    parameter tCLK_PREPARE_NS = 38,
    parameter tHS_PREPARE_NS = 40,
    parameter tWAKEUP_NS = 1000,
    parameter tHS_EXIT_NS = 100,
    parameter tHS_ZERO_NS = 105,
    parameter tHS_TRAIL_NS = 60,
    parameter NUM_DATA_LANE = 4,
    parameter HS_BYTECLK_MHZ = 100,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter DPHY_CLOCK_MODE = "Continuous", 
    parameter PACK_TYPE = 4'b1111,
    parameter PIXEL_FIFO_DEPTH = 2048,  
    parameter ENABLE_VCX = 0,
    parameter FRAME_MODE = "GENERIC",    
    parameter ASYNC_STAGE = 2
)(
    input logic           reset_n,
    input logic           clk,				
    input logic           reset_byte_HS_n,
    input logic           clk_byte_HS,
    input logic           reset_pixel_n,
    input logic           clk_pixel,
	output logic          Tx_LP_CLK_P,
	output logic          Tx_LP_CLK_P_OE,
	output logic          Tx_LP_CLK_N,
	output logic          Tx_LP_CLK_N_OE,
	output logic [7:0]    Tx_HS_C,
	output logic          Tx_HS_enable_C,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_P,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_P_OE,
	output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_N,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_N_OE,
	output logic [7:0]                       Tx_HS_D_0,
	output logic [7:0]                       Tx_HS_D_1,
	output logic [7:0]                       Tx_HS_D_2,
	output logic [7:0]                       Tx_HS_D_3,
	output logic [7:0]                       Tx_HS_D_4,
	output logic [7:0]                       Tx_HS_D_5,
	output logic [7:0]                       Tx_HS_D_6,
	output logic [7:0]                       Tx_HS_D_7,
	output logic [NUM_DATA_LANE-1:0]         Tx_HS_enable_D,
    input  logic          axi_clk,
    input  logic          axi_reset_n,
    input  logic   [5:0]  axi_awaddr,
    input  logic          axi_awvalid,
    output logic          axi_awready,
    input  logic   [31:0] axi_wdata,
    input  logic          axi_wvalid,
    output logic          axi_wready,
    output logic          axi_bvalid,
    input  logic          axi_bready,
    input  logic   [5:0]  axi_araddr,
    input  logic          axi_arvalid,
    output logic          axi_arready,
    output logic   [31:0] axi_rdata,
    output logic          axi_rvalid,
    input                 axi_rready,
    input logic           hsync_vc0,
    input logic           hsync_vc1,
    input logic           hsync_vc2,
    input logic           hsync_vc3,
    input logic           vsync_vc0,
    input logic           vsync_vc1,
    input logic           vsync_vc2,
    input logic           vsync_vc3,
    input logic           hsync_vc4,
    input logic           hsync_vc5,
    input logic           hsync_vc6,
    input logic           hsync_vc7,
    input logic           hsync_vc8,
    input logic           hsync_vc9,
    input logic           hsync_vc10,
    input logic           hsync_vc11,
    input logic           hsync_vc12,
    input logic           hsync_vc13,
    input logic           hsync_vc14,
    input logic           hsync_vc15,
    input logic           vsync_vc4,
    input logic           vsync_vc5,
    input logic           vsync_vc6,
    input logic           vsync_vc7,
    input logic           vsync_vc8,
    input logic           vsync_vc9,
    input logic           vsync_vc10,
    input logic           vsync_vc11,
    input logic           vsync_vc12,
    input logic           vsync_vc13,
    input logic           vsync_vc14,
    input logic           vsync_vc15,
    input logic [5:0]     datatype,   
    input logic [63:0]    pixel_data,
    input logic           pixel_data_valid,
    input logic [15:0]    haddr,   
    input logic [15:0]    line_num,
    input logic [15:0]    frame_num,
`ifdef MIPI_CSI2_TX_DEBUG
    input  logic [31:0]   mipi_debug_in,
    output logic [31:0]   mipi_debug_out,
`endif
    output logic          irq
);
//pragma protect begin_protected
//pragma protect key_keyowner=Cadence Design Systems.
//pragma protect key_keyname=CDS_KEY
//pragma protect key_method=RC5
//pragma protect key_block
hiecKEIXAHnk+HPlXgxdv0m8a/SPG3ZOc64PFS0gWt0NrlzO7A2rCbNrx08jBSph
Mp9+gaVbRcTvgEA960vTBOmC/e3oAvA+jzLs78n9X52yjY5qCe+ORZ2cn1goSPO+
gx2aVgoKdIJ+XiTkFOSZBE6+g4WXiXu6bxL4z6DcLgHYptHi4kwOaw==
//pragma protect end_key_block
//pragma protect digest_block
FQ/vmAyt53wivvGnM/qTA7D58/U=
//pragma protect end_digest_block
//pragma protect data_block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//pragma protect end_data_block
//pragma protect digest_block
OGQwLyGk0gi9ewHfNyKqV3Gxnh4=
//pragma protect end_digest_block
//pragma protect end_protected
