`timescale 1 ns / 1 ps
module `IP_MODULE_NAME(efx_csi2_tx) #(
    parameter tLPX_NS = 50,
    parameter tINIT_NS = 100000,
    parameter tINIT_SKEWCAL_NS = 100000,
    parameter tLP_EXIT_NS = 100,
    parameter tCLK_ZERO_NS = 262,
    parameter tCLK_TRAIL_NS = 60,
    parameter tCLK_POST_NS = 60,
    parameter tCLK_PRE_NS = 10,
    parameter tCLK_PREPARE_NS = 38,
    parameter tHS_PREPARE_NS = 40,
    parameter tWAKEUP_NS = 1000,
    parameter tHS_EXIT_NS = 100,
    parameter tHS_ZERO_NS = 105,
    parameter tHS_TRAIL_NS = 60,
    parameter NUM_DATA_LANE = 4,
    parameter HS_BYTECLK_MHZ = 100,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter DPHY_CLOCK_MODE = "Continuous", 
    parameter PACK_TYPE = 4'b1111,
    parameter PIXEL_FIFO_DEPTH = 2048,  
    parameter ENABLE_VCX = 0,
    parameter FRAME_MODE = "GENERIC",    
    parameter ASYNC_STAGE = 2
)(
    input logic           reset_n,
    input logic           clk,				
    input logic           reset_byte_HS_n,
    input logic           clk_byte_HS,
    input logic           reset_pixel_n,
    input logic           clk_pixel,
	output logic          Tx_LP_CLK_P,
	output logic          Tx_LP_CLK_P_OE,
	output logic          Tx_LP_CLK_N,
	output logic          Tx_LP_CLK_N_OE,
	output logic [7:0]    Tx_HS_C,
	output logic          Tx_HS_enable_C,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_P,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_P_OE,
	output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_N,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_N_OE,
	output logic [7:0]                       Tx_HS_D_0,
	output logic [7:0]                       Tx_HS_D_1,
	output logic [7:0]                       Tx_HS_D_2,
	output logic [7:0]                       Tx_HS_D_3,
	output logic [7:0]                       Tx_HS_D_4,
	output logic [7:0]                       Tx_HS_D_5,
	output logic [7:0]                       Tx_HS_D_6,
	output logic [7:0]                       Tx_HS_D_7,
	output logic [NUM_DATA_LANE-1:0]         Tx_HS_enable_D,
    input  logic          axi_clk,
    input  logic          axi_reset_n,
    input  logic   [5:0]  axi_awaddr,
    input  logic          axi_awvalid,
    output logic          axi_awready,
    input  logic   [31:0] axi_wdata,
    input  logic          axi_wvalid,
    output logic          axi_wready,
    output logic          axi_bvalid,
    input  logic          axi_bready,
    input  logic   [5:0]  axi_araddr,
    input  logic          axi_arvalid,
    output logic          axi_arready,
    output logic   [31:0] axi_rdata,
    output logic          axi_rvalid,
    input                 axi_rready,
    input logic           hsync_vc0,
    input logic           hsync_vc1,
    input logic           hsync_vc2,
    input logic           hsync_vc3,
    input logic           vsync_vc0,
    input logic           vsync_vc1,
    input logic           vsync_vc2,
    input logic           vsync_vc3,
    input logic           hsync_vc4,
    input logic           hsync_vc5,
    input logic           hsync_vc6,
    input logic           hsync_vc7,
    input logic           hsync_vc8,
    input logic           hsync_vc9,
    input logic           hsync_vc10,
    input logic           hsync_vc11,
    input logic           hsync_vc12,
    input logic           hsync_vc13,
    input logic           hsync_vc14,
    input logic           hsync_vc15,
    input logic           vsync_vc4,
    input logic           vsync_vc5,
    input logic           vsync_vc6,
    input logic           vsync_vc7,
    input logic           vsync_vc8,
    input logic           vsync_vc9,
    input logic           vsync_vc10,
    input logic           vsync_vc11,
    input logic           vsync_vc12,
    input logic           vsync_vc13,
    input logic           vsync_vc14,
    input logic           vsync_vc15,
    input logic [5:0]     datatype,   
    input logic [63:0]    pixel_data,
    input logic           pixel_data_valid,
    input logic [15:0]    haddr,   
    input logic [15:0]    line_num,
    input logic [15:0]    frame_num,
`ifdef MIPI_CSI2_TX_DEBUG
    input  logic [31:0]   mipi_debug_in,
    output logic [31:0]   mipi_debug_out,
`endif
    output logic          irq
);
//pragma protect
//pragma protect begin
`protected

    MTI!#y"njK1C!j,$2<D$j~rtrvk<^o7rIHTV|(K_5[c8W[i;k15*<lH~TY?<]c]BCz~5'nGDWeRQ
    KOZ$a@7Q-Xj@;$O7eis']Xpmp=zWa;aI\rN@wzrp~Vo7J>svzil@]ATr#[Yi5spTQw3Z+li7p,o7
    Ae?1DX-E+=Ad->@Qj,DTqR#Q,BuX*W}A;]\#pmnmOF$HVp:E<pE;1lH77I3.RA}<HGJ#s{v3CR3u
    aoliTD-Ttx5X*8QerDel5$-*WH_]+2\EYoQ!@@k]U\x}WOrmasv]wraXz?*T@<#5{]=j>ma{OOze
    @VIuR\=-o$Il>Vzl+koH*i{]*YFuxxX=?\R1sVTp>'v}?B<e\jZ_T+}_{TaT'+$'m[?Pp2<5HGi,
    Yl1[tk}R['~7Kd3j;j}HRXZTyY1<#,_{C(Q~K'5Kj}5G#aO^O]on=G(,vp~=@_>3nK;M{*J$-$;n
    uEHav!!{HE\<p$]~{1nj3UJTxeiWwvs@P'wGHoC;;-TAI=OWl=YIr%]=CJuH[~aS'a5D?aI]~s[U
    njaUQ@J@5'}vr5[w@AnkTX@Vl+r*pUYRw1E7-R;n?\T}7Wu?BYCo7k$uQZ5G#En{)(v;[WJ{H*^<
    2rBiT]A<+Bz1io3xB,;o@!v>GuvJa\L3HKxQ=;a37k*Cz*o$^+WW*R}ZY;n?^1V+C^,0vHoQCv+3
    u$5]Q;r;\vO7:r~,;}}mr+XvvBAR;$eBZ$Dizx*-$=!Q}uE\Ei7T=@}UVUjn;Yf$=x@I#j1(?j]G
    2*aY"@<XG:i$nYR+<]^{U!b0kE]aIOKnvmUsOz*m~oIRZXIpDHn+94$aE]dW[vI_v\<^-7V%@+&D
    iY_pxC[(l_Y]8>BY#yRz]slR^pe\BR_R1A/|lW\HuvTk*+}7}wY7Q*T!iU+e^K+u2+mQlkVn?vUW
    D[B*#OW]E$mn>$Xx>QKsjU1\!$BZK7$i#R7[}Z[?-jE-QazG0*zv}O=l;E;+V9WU,U2OU3GQ[#KD
    7i=pkkyG{!1GK=;57{ElWenOQ?1x1}eviXAB,'Q}-vZ*JT\w^uT=s\Kxv*i5J>*j}rw.;rR75\aK
    pInaLI8~aG@@T-ujin^KCo+E_?;CHo735RUF'>@G}lY$%^3~H$DwE}*QuZGHo#YHTp=ACH^pJ*D@
    Vq*[@elGTDB[v;x?=D21eV-BV;Wwj!E;UGsu=Q7H*A?}Gan7[#gVKxu|\*$IR$}U#HDB,~;BTw'?
    KUBz{_?-%xa[V-{22^~KJ27r*f}CVR#'+lVsH_BG7[to6e!}=[2]nZE*Z\CE#-}W\kRn;uzrek],
    -Co^}!EQ#ZwQQ}wZ<qj'JmwRKeB^Js(mTe*W\Wko^w$DCeQMr,Z[=rvZHnDG;wDr5mVs[^{>vD3s
    oCTJvG=]jm^'n_i]*2_e*lVQU}**BIkvt,B#j8e1k]h0{RI7N@nW[E=Wv)vz=Qk$D,|9pZ*$Cm3E
    F<BYxl{XRH,@+ZD2<5_j$}^a!R[7@E-7<+[}WwHTw2D,rkD#!G@HDvm$-r-,]Tvp]2E=][+XUA+<
    75$JC;QHQ3-<UCZm{GJOe(l}k]Y!I>rr*Y[+FH$^ox@K1]Bs<?w\KI$X}iIG$_l!1,~-v@Os<R-K
    R/O1*J[CvKW1po5<!~i9Q!XJl*ODE,x=~HGw=*RndQDaOUR]mkYE'EB?m[-j27\3@iVmIX}D5KSn
    <JCh~GXY{^o[,1n-D'ixq1=sYU5iIw_lll}lZ^++JO$uZf{+@~^Q[]'}sneosWO;H$}#3y0K>o;B
    'w>JsawjAZW>UDO^CA=;wCk%br[p}>-W~'?m<B=G7!<UvFUxvR-X~Z'o@ZlmnDo?[l?CZG#[Zp+|
    *;[$L\1kwOEH-n{j}=>~QR^*x]rsQ=-5@Rk<A[^n>}v,]z2_s5E+'*RmsRGY^MZ5W=*OU~^<Gp^O
    =G;*A@>7w@{}a_w-JEFGEZ[RD$^odIu;pCH>uZV~$eaYxrj5X1<^B@D<+a5-T\m!CEU1e=s+]BK>
    s,^CKHO$3+^K?<7maeinm;Yi-a]#?^wKr2sG~,@Ua5~5zxr$O;_B}J]^\%@1>k7JeeDw+5''UZw7
    _prR]<-H$T^;*-nI7Ym_?H['*Vk'^Cx_vaD\}+s*DGOnY3E\<=O$RKs@Ci]i{3@v}3R@'iS?{*^?
    n[n$7#Tp-5e)Mx**-#{\_YkDUIu*7]GXHaEQUQD1$n^+@R+,Y(ka$Wa+TJ.ru73i_7<jriE!{CC4
    7Q<J>xpo(<_i@~*=}ZQRBV}<!-+}E.,zj?a}H+w+ju!wZ>*wR'Q_mrEe@{wUo+<rIG4AxYmcZVUW
    ]KJuRfoQ723H;x]D2uo}B<oORJGlZ1@^m25}[esxeTE+7a'GZ,x{U,y<Yj{vEE=^,5m=wC_s5D$y
    V{\v[Jz?,aeOm}=2eBIrwAX][I],p+7}RK<2mlw\m6x{<G6[awHRj\$Q2E_;p,1J,7TK-,Zje7V%
    ,C!TviXrO+WoPez!'EH=xDP&pk^E2QmQ;YIv+eQQTp{e25ZWD\m@}HHV!HeTs=eaWw=3~<bnsjX0
    qk<{^G#K\KY*>,#7*p'RTlwZ_-Dnv!CoCuX5@jelw=2n1Uv>JuX$AvlnsTBH+IUJ+^$QC5J]RBCw
    l2>CJt?1YviR_3<[-oU=n*=QR\I[<WHGzX_X-GRjO=\+r#v'CW<^[5BlJ+mlREK-}RVA^VuV{D,:
    j]s>eY3@vw2~ln>;3'aHi_[$BYW+x>VR<7Vsp2>j]W}+I<5ss[]eD#nW{eBBe\@xHU<w[DK'G>l7
    lVKsKs,@]?<^{j3JBVXnuYBo\UHT{Ixxm[VQcI3=j~r+^;eIDc*?m-\RxJnSCpvTZz}CuY<D_-$*
    H<zx^[QOnr5sEw-3QK;j_5RGe7\V++BQjBYsKHxiKT3$nQ@Kn+1\QinWk<!'T<a*E\$D]Tm3\<OI
    pECA|~AuUNE7IC$2Yn3^E^BoB><aZlTGKI1mHu9K[VG^<l7<C!>IR!v'\~25JuY>Gx3;rjus*G3j
    ka~r$C>1?K!\ZCE5#B7GEolG_=zi*Yu^>EYQsYx>oepsZJ7!X!2YK]Y,O=a7@HO=@nBfHX9sU\<K
    }wz_Q<@rDRD73[;*elYr>G5]=Bk*yz{$s^@VplXU};RIuIZv;Sa|#}AuRIYnE;l-sO[{^zY5T*7p
    -rJxi*a-xU\J^zom_O,D=J{eW$Ou'zr3[vD{*;pIOIWaa}euIm3T=4rD+{pJTn-5_uMNj?@HoDHQ
    ,7
`endprotected
//pragma protect end
