`timescale 1 ns / 1 ps
module `IP_MODULE_NAME(efx_csi2_rx_top) #(
    parameter HS_DATA_WIDTH = 16,
    parameter tINIT_NS = 100000,
	parameter CLOCK_FREQ_MHZ = 100,
    parameter NUM_DATA_LANE = 4,
    parameter PACK_TYPE = 4'b1111,
    parameter AREGISTER = 8,
    parameter ENABLE_VCX = 0,
	parameter FRAME_MODE = "GENERIC",    
    parameter ASYNC_STAGE = 2,
    parameter PIXEL_FIFO_DEPTH = 2048  
)(
    input logic           reset_n,
    input logic           clk,				
    input logic           reset_byte_HS_n,
    input logic           clk_byte_HS,
    input logic           reset_pixel_n,
    input logic           clk_pixel,
    input   logic                       RxUlpsClkNot,
    input   logic                       RxUlpsActiveClkNot,
    input   logic [NUM_DATA_LANE-1:0]   RxClkEsc,      
    input   logic [NUM_DATA_LANE-1:0]   RxErrEsc,
    input   logic [NUM_DATA_LANE-1:0]   RxErrControl,
    input   logic [NUM_DATA_LANE-1:0]   RxErrSotSyncHS,
    input   logic [NUM_DATA_LANE-1:0]   RxUlpsEsc,
    input   logic [NUM_DATA_LANE-1:0]   RxUlpsActiveNot,
    input   logic [NUM_DATA_LANE-1:0]   RxSkewCalHS,
    input   logic [NUM_DATA_LANE-1:0]   RxStopState,
    input   logic [NUM_DATA_LANE-1:0]   RxSyncHS,
    input   logic [HS_DATA_WIDTH-1:0]   RxDataHS0,
    input   logic [HS_DATA_WIDTH-1:0]   RxDataHS1,
    input   logic [HS_DATA_WIDTH-1:0]   RxDataHS2,
    input   logic [HS_DATA_WIDTH-1:0]   RxDataHS3,
    input   logic [HS_DATA_WIDTH-1:0]   RxDataHS4,
    input   logic [HS_DATA_WIDTH-1:0]   RxDataHS5,
    input   logic [HS_DATA_WIDTH-1:0]   RxDataHS6,
    input   logic [HS_DATA_WIDTH-1:0]   RxDataHS7,
    input   logic [HS_DATA_WIDTH/8-1:0] RxValidHS0,
    input   logic [HS_DATA_WIDTH/8-1:0] RxValidHS1,
    input   logic [HS_DATA_WIDTH/8-1:0] RxValidHS2,
    input   logic [HS_DATA_WIDTH/8-1:0] RxValidHS3,
    input   logic [HS_DATA_WIDTH/8-1:0] RxValidHS4,
    input   logic [HS_DATA_WIDTH/8-1:0] RxValidHS5,
    input   logic [HS_DATA_WIDTH/8-1:0] RxValidHS6,
    input   logic [HS_DATA_WIDTH/8-1:0] RxValidHS7,
    input                 axi_clk,
    input                 axi_reset_n,
    input          [5:0]  axi_awaddr,
    input                 axi_awvalid,
    output logic          axi_awready,
    input          [31:0] axi_wdata,
    input                 axi_wvalid,
    output logic          axi_wready,
    output logic          axi_bvalid,
    input                 axi_bready,
    input          [5:0]  axi_araddr,
    input                 axi_arvalid,
    output logic          axi_arready,
    output logic   [31:0] axi_rdata,
    output logic          axi_rvalid,
    input                 axi_rready,
    output logic          hsync_vc0,
    output logic          hsync_vc1,
    output logic          hsync_vc2,
    output logic          hsync_vc3,
    output logic          vsync_vc0,
    output logic          vsync_vc1,
    output logic          vsync_vc2,
    output logic          vsync_vc3,
    output logic          hsync_vc4,
    output logic          hsync_vc5,
    output logic          hsync_vc6,
    output logic          hsync_vc7,
    output logic          hsync_vc8,
    output logic          hsync_vc9,
    output logic          hsync_vc10,
    output logic          hsync_vc11,
    output logic          hsync_vc12,
    output logic          hsync_vc13,
    output logic          hsync_vc14,
    output logic          hsync_vc15,
    output logic          vsync_vc4,
    output logic          vsync_vc5,
    output logic          vsync_vc6,
    output logic          vsync_vc7,
    output logic          vsync_vc8,
    output logic          vsync_vc9,
    output logic          vsync_vc10,
    output logic          vsync_vc11,
    output logic          vsync_vc12,
    output logic          vsync_vc13,
    output logic          vsync_vc14,
    output logic          vsync_vc15,
    output logic [1:0]    vc,
    output logic [1:0]    vcx,
    output logic [15:0]   word_count,
    output logic [15:0]   shortpkt_data_field,
    output logic [5:0]    datatype,
    output logic [3:0]    pixel_per_clk,
    output logic [63:0]   pixel_data,
    output logic          pixel_data_valid,
`ifdef MIPI_CSI2_RX_DEBUG
    input  logic [31:0]   mipi_debug_in,
    output logic [31:0]   mipi_debug_out,
`endif
    output logic          irq
);
//pragma protect
//pragma protect begin
`protected

    MTI!#cU'PJE*a2]I=H}Rn_7335-E<$yJpml"F^ms"Asw}m=zVW-2'Q22[b9s+meFE=W=}xV*'By[
    x$+>*#^U1@GF}QQ2Oxv=;IlUUSln1JZ$wo8O8ZB><eK;C9oj1;^D1kwnRGO~r1HnK3}mA>O\5#2l
    x[oC!Qr\B_),B#,$riGw1ikKNYT!m<p7??AT~FeQVu6/rxJux1R5xZ<,eWQe2rRT55_\(}-!Wa+=
    Be3WAzXD~Oi'+g)4qJYaY;9>1e_C<p;>DiWp*{1n-OYJ==+11I=r_poN~B![l#<@K5s-z1=l{Ivz
    7~s7^nA;\CiCGBl2sxeR=?E]I]X~)zl]^NJXHn9'Do@<7QY{[U]LaC-nV1H,w7Qpp>Oa}v\YH[uT
    Zek$QV~kH1vZinUl^uu?To,>B,ks=po*vY9V}BBxeQ=cJTT}(51_Z=,Ro[}1}_{O-Yn>e5'$3se~
    H5[Y_U<>o-U5HE-{Gel,*=C$~U,#+#I#;C1@$H>xs^#+^pDHJo*[Esv5Y\-lpg;G*RJ\nrkH=pE.
    lKX,;[!XoX}J^X^lQVKr'KB#9?{Az"<CE[HY@R)"=-3*YW_@[G{UWzV5\pl-{YaT^XA]}ZKpS6uv
    +e]vRjD'V<5<>r3C?@jGT2+TDvbpH5ena<#(QnEB\mn++]HQ/NE->=JaAsVKf*=R'I5eO12=<KIG
    AQ<,K^5CRuU}QAEvW]OC=nsEriUQ',=u]^H1Z7o3?AoJ!6[wAUH+Z#$-E#u^BixQ>_j#q>1no^#2
    w|*=k?#r+<Kn~pZnn~D*Tn*m!n}T!@jO#@=W!xs'?>2ne$sozDBv^Xj>Xo{lzi2>Zvk_BoxR<-;\
    \iI]\jU*ERZOzYYl$*7!GmgCkY_QZZ{>j@?_<JJ#I2TbQ-v*w<j{[_vp2TBpTGO$H{H#O7{UBApi
    ,vpJ?5,$GBxKI@VWJ$iQo8-'X<$@IWji}+jwlVm<'K\AIuv*,Qlv#u3YVTd~s^jB@j2^jm-B7~uC
    ^@<k^_}T^[EnYp$>,5rrZ<]$*-3x=oK=$QJREeU5Grn1sosC"BTenB'[zZp17,{Hni^[VV,WmG\'
    Zi[e_[nr>xo5~O=AGE;=#{so1N'K-j2-<-T<<_rZCsf/r%Coz1x+xar0f%S=aD[_n!Xy3H]ouDvZ
    HIBk?ex,,=~e<-2HKVjOXoU#D<}1OBm;[)Yn,[Urx''!G+edok<kBXC^BUj<^vApp]w=[Hnx5ske
    @s_?4ozm#!,_Q=1s_o71e0HR<V~ejrhL=R{](VwDHvee75"X$kuDVHC]#;\=IvA*e~CGZv$;jKQ/
    [@5mU$o3-jp!is[*cB#sZ7%\AKvJ$@u\*Ql<<_j]R~~QEQ!0ZwY_}um!qxs\pzow<R]><']VpvUO
    KDD:AIXmBWvOGOwDRp$,5ozp5HZG[>zA!j[2iC_nQR+[Sk$]!v3rp^Ao*rrn$R7+;#}^nQ^<'Is1
    C_O*[XrKA1C{Tpw@A^\'iP^k']TQEVsRv~Kl2}%BBo'kC^=A1]~JRa^]7nY~{rZQ@o-~wB7(V[,?
    QuWG$nsk,{H>'l-{N[35$Ru*Qj7,[eY,u2EB[J}A$1-!RCkr]x}aKR$JU-w@Y:~+j\UD5T}eWD{[
    >D@U>Ds~<Bsk]+m7]k#YP%PH*n{VxEuT_@jI_,[5>nZY2R]zuTO{1B,>D]<lY.@o?*}-oR=J}C6@
    'Y<zJ=J~Y\~o?x~NFr>5+1DVVk{AVkr~,&[kWxj1~Dv$R'X1A5u[<Z-a*52BUs7XD}j$\s;7K;[A
    jrTlueIpXQwje=#$>7*lZlks~v~zH{LU8b,l'D_XsjDD$*we,e=>Q_fxs\Xr5C}V@nrjk_$k^Z<5
    ?~VmoDT!H<xC2w]QTYl=EC2VReDA,AuEGw>Wx<Y,'Y+>+HlA<v[/wAX5e5A^c5AK*kC>WY<Op\3~
    !ao}Y2TT>Hna=zCk<'$T!\{U~U}1!xH@+2YiQJl;Yp}j@9q$XlOVK~3wA2E.tTVB_!V2{Te$=2^z
    J~w+v_Q'Y\7WEx#B@x)w<z]z~;IZw'}B=]TyYp[Y*3HQp#lOa-R+G_[I3Co-];m;lOIC^R<]>}lU
    iU+XUB2rw}XoZ}A\u<T{#V3pCx#BI;-o-Hve!eCz3RAE$C2V]OD#HwVBnpKEBommQY\{q!'eodl@
    ;'pRnwrD1kjX2E1-&|*R;&azXI^H=-;Ca2k=;zrEixn+a_JjAw~I!@pX1'R;Z55-~B3>sYe#2}@[
    +HiV~;rK\{U=7K^g[7[2lkZ*m-QG1QYB+_e3=uvp7!QWu'siT[?=J<Xv,k\$RED[|7z>n1rv]E*>
    W^kG1]^*IArau~\!,}K!V-_'HU]>x;}p5pJQGIwAwjJj5i<E**^;K'vXHT>;pp+ZKq]3lKxKG>$a
    5]fE[IU[p;U?n{J{Nj!!u_*XVR{G,3_lkWV{UTH[RK5mee$*}IA+]Aj^#UA{\-'\T}*WZUHz*v2]
    E^.VG+?KwxW+$a\so+ps5oK|[~7UjjS?au#l'XnL6D{u]Q+H{d5TD[IJZB)=l'@yB>JmEk3kEeY7
    zx!#k,\~~ji?AE<xBrBmn>WO3Y{m1]3~s[r7^k{lSpIiJj#jeb<ozD^n!e2}J]DZ+J]eQOWRoEa>
    3'i,GYj\CQn1k,lBImav-s/CejwlRYH;UmB)!X\1TYCrpU3_(XYZ+^Iw-sJs@EQ[#[Zn$lHJ_2E?
    B\7G]Ho#']!;>p'n[1}_zs;{=7,3{DXB}>TBJ%J>~[BLko]QeH>QZC[Y'ElBB1AH]{'Z$oW\*>Xe
    Us*J>jnnaj*=BWvDi{X'OC'2(lW\;[w}pIZuCTAB@VGZ[v2WA},_wI^~3$H7pUvGH0PBnzC]1*+/
    Pe=p#C#RuBU*Oj=aXnl<@^G7l=u{H<w2u?zUo)#,u?gze=JWrVr}HXj=aXov<Gu{epJ$,!~B[?w9
    :ff]Ul]g+z5TwCQ=}.-<AGY<XvY}E@B^I[Y_Wj*VxWI;}apnKHzDxUGo'a,TR!]v2rDVZ2sw}u0i
    wv]3>e,zwBTQA{w_pHu5Kl2;}IrsAVoZ<a]3eKx,!A!masX+v_lk<1{9=7*wW>m]:@*E>'V<@K[Y
    3ZlGV{A'smT*s*lJ;pwBmooiunz+@u]-lgI<Aj[A>3r{zUjEKV2<~kg'fJz*3Kl*@oxi?I3\o*Gn
    {E#Hj<LS~Xl{v5w*i^;>R3x*-5\E2pZI_kupx}=x[/Vs;jpB5+|gURo?/IB^{PCQCJBvZ-LwE?nE
    4g,s[p-aYD'5AG#jIp5W\lO5<\wA[al@'KC>*<Zw!}5aU_p$i7}5zknsUmKO~a#rEr$IKUEnT]J$
    ~QSQ#,3I5r1<Irr=D$2Cj$kBZj2|z^@,(IQK~Y>-z1H+o~]U;&Hv_k:1?;Rjm[zBTJ<CJ=-5s~?l
    !\I~$AIG'U<SBu=!awlJIB_{=DojVAe#|*ziuQHa[C7\<#O2[},vTpWJ_?'p~_YAmy]XX]I~Gk&\
    HaD^eZYoElVn1C?77VUUaGp>s={s'evrT<_[@!?iU;oRTEasiK@C[*AXT$e|E<wwx8#UE\S=WH@[
    rGG!lOJhnCX#?>1^,iJ11JKYc$le<a-Y!a>J=VRO~$OvoD5DD_7DV+VEJ\1s~!-[^Klw{zSEC-?7
    -\uOUj=V3u$oD^mT]_{E'^mal=\J55vU$wuX-z,oO7[;ej5'l]uC,A!ZaBJC2XU-E@IB}E-f!}]Z
    2><Dz;n$<n{TuRwx%]*>[An}B\lRYrWVwf->23N=^ru*a>vsu;7_,;I2RB[0+X_^)2XTu-O[2C;B
    Qmx2!g}]V{z[[GZ[zT)pZsDhY5[$l!EOZ1GU^Y7VW$XA*Bb3Q-@+Tu$mx!BGaj@~z+;Zl>XiTw7G
    ^C_DOUpv@zCG5>IvauxZU^ixU2rms33*uj]\m-=AxW~9G\R}VWm\]OAVDZQK'm2Z'3Go.Y'B$^H>
    JBJu}]Hxi>r5Gm]jY,mZT'pi]k*nIJ{D2@9x@vW40rv#nf2=jA*OEno}?}zB$52<Y7R+U+ooe1mY
    ?[U}~\;=IE{VsT}*kxU[Ir%O3^=}]ZDwTYj5KGY![e\P!,}TQ?Os(j\,HD\$+K*3RbCG,_0~B{B@
    v@ZF*WJv@=KA7\R5@'A!mA3!O{Jm=m!IRT!1H_5u<R'YK\Tx0u]s+mnv2KzeTU]Z!%Z$Ka~ooK.1
    AXA2[XXv1#<[>VD$sjO1x#'7)-rm3.$<~=5pTOyJaAWn}_{e!BU>A!<PYv*;ToKxvklVRi2>_D-7
    lUBJkE}p~7_;Q*ABk=xnr*Ri>xjj3UJI;C-*C[=AKX1xZUooI^x5#O~7z_\u*3}_,iS{>_un{r5x
    i2Ojg\}Wam]^V[Bu#nAUJun}$<G}p-raE)._}D*=2[p\]z^lu\]$}]ZHQ^lvVEmrOr'oIm='OnYv
    ^!\]ZOTHI+k9A5x1'S2>'2~8*-VrGB#Q{X\l@eK]-,sT5rH~Y+C$*=O5I31eQTuAO-a;l=_x+[;E
    t!v1r!j#_+YJ2\!o]ul;3X,Q])C5AZZ+-I-OeK#<5uj!o+DAz-7?W]#q^~~DnD}~s#m]Hp='IGYE
    H_<Y73Cu,!~m]XYoB@muXQi,M5s<]L}OH+$[A1/4b]O+ExaDrJUQK'rVZ+TZ1TG'EvGu[$I^esQk
    p#{=r'V2O"V\lIB3V?J}z}{5XD~p3a3l'o't}7Al7OZ@3Vu$1*wQuDx@;za@B\jBS,kjJ#a7#R?-
    UX>mTI<SDwUodR=m[n>DTC~;vG*aY7WXsl3u#oUu$ssOze*?oi>7VEzjB-]TI2Hw#5rOAKA<-E>;
    s}YkTv~aZ3{-+|urn$eC_!=K$exFDZ[B{ROijL5Ez#F:5>Wlk,sE>T<#xAA?,rAo]%B-zo5U],v;
    -1iX;#VC}pG--!h1C!eADeTr^{Q7Ce'Y\nUu<pIzeG#8s1mxZ^>lK_?])LZXHJp[n@mC5~mwTp-j
    j?D?XBG=vA^!@o2-HTf2Yra-lnB=na>Zl[Rz'3E^Oe}zBax5DW3AB^Cu[l>%1r^rDpn@KCA^]*A@
    y!.}}5Xsjl<+l5_1iI1[D2JkX-@13!o-R@3$j>e\J@uVOlRG;2}7}vk$UR;@>2{n+ppj}[pUl\Tq
    TD~~vm!=lo[ZwDwe\5Y^4i$5$K>7['A!-sGJ<oBQKHE~OQ]}$'2_\7_QAE,vJv'~Bze!jpvYTEQ;
    _y[eZw{rwe7Vv^x<n3qnIpB|7K\$ee[A**^2zB#Zq@5-5xxH@}?E#YmJGn<\W*G={x+579F^]Ejp
    UORAOIsoAWHYZlaqO<A]5Op9pGkHL{rWwkr~ewXXn<l{!E+vIe}$W6B,Ta3'<xk{uZH>^v#T1K$K
    ORj3\enpjm{IW>\[<VrT-A?=NBu__V]Aew^e+TUOs~OUH'KOa.5sT3EWm\T-s?IJJ5>j'Iz"^?_m
    #D_^A+n]KAnoBvrn]a->x+$Zl{-Z-TDHT'r#u$Ze-HOQ^wmKi[u@ZH*YW^@Hp>{[j>v',;sOkTDi
    D[-5A<_3H,Y~Yn[v-vozoz'B>a7]3lVz[!\~$J@,oaROxHGi)YH,Z2l2@V}Qx6@{nZ7'rrYUv{rD
    O#lZ$!e+EJ}z@Ou\-k<onxHjkpzR!D*w=Jx]UvOAGXV_=*m{1-F(#aGuU7Ori^'U!r[D!Gz'#p\J
    Z5v?JQr\o{'}T^xR{<$5Drk2\wjJ:/"naGV]!Jxn{IV?^e1-IAWv=GG#oE^lkv-;zm<'s{_<=3*w
    7'n)CZ{DeC2J|[k5=$5eY;z=G6EpOx3rB>t-vO-BD\Z&;*oX]\XTYim!oa,Z<D]l2nv,azHT#AYC
    ~Ek<P42]uVsuWE)pJV\N;BG5lD@D+-ZZI=nkr^sDRpxrCl5J7DoVuolUsGn@fz>>rg5HHU?n*j_<
    p=R^$vz$sCx<vzz-ps;H$nJI@1r@T7W^D<IQ^1,KVwlzs@D]*K%?5rne][BIE*j#5G5Q7p7/e1pz
    CJ$ZO;j<>UUuAT1l\@$Y?_<OX<~o*>OeeU,vjW3-<{!=vY<ze<Ylo<=ZRp,;ArlOX',;CBZTfK{C
    ]nU[}InEQ^:TTQu\KJ@1g!]T=U]z<rC[QZ[U[y$jnnp-p?
`endprotected
//pragma protect end
