`timescale 1 ns / 1 ps
module `IP_MODULE_NAME(efx_csi2_tx) #(
    parameter tLPX_NS = 50,
    parameter tINIT_NS = 100000,
    parameter tINIT_SKEWCAL_NS = 100000,
    parameter tLP_EXIT_NS = 100,
    parameter tCLK_ZERO_NS = 262,
    parameter tCLK_TRAIL_NS = 60,
    parameter tCLK_POST_NS = 60,
    parameter tCLK_PRE_NS = 10,
    parameter tCLK_PREPARE_NS = 38,
    parameter tHS_PREPARE_NS = 40,
    parameter tWAKEUP_NS = 1000,
    parameter tHS_EXIT_NS = 100,
    parameter tHS_ZERO_NS = 105,
    parameter tHS_TRAIL_NS = 60,
    parameter NUM_DATA_LANE = 4,
    parameter HS_BYTECLK_MHZ = 100,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter DPHY_CLOCK_MODE = "Continuous", 
    parameter PACK_TYPE = 4'b1111,
    parameter PIXEL_FIFO_DEPTH = 2048,  
    parameter ENABLE_VCX = 0,
    parameter FRAME_MODE = "GENERIC",    
    parameter ASYNC_STAGE = 2
)(
    input logic           reset_n,
    input logic           clk,				
    input logic           reset_byte_HS_n,
    input logic           clk_byte_HS,
    input logic           reset_pixel_n,
    input logic           clk_pixel,
	output logic          Tx_LP_CLK_P,
	output logic          Tx_LP_CLK_P_OE,
	output logic          Tx_LP_CLK_N,
	output logic          Tx_LP_CLK_N_OE,
	output logic [7:0]    Tx_HS_C,
	output logic          Tx_HS_enable_C,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_P,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_P_OE,
	output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_N,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_N_OE,
	output logic [7:0]                       Tx_HS_D_0,
	output logic [7:0]                       Tx_HS_D_1,
	output logic [7:0]                       Tx_HS_D_2,
	output logic [7:0]                       Tx_HS_D_3,
	output logic [7:0]                       Tx_HS_D_4,
	output logic [7:0]                       Tx_HS_D_5,
	output logic [7:0]                       Tx_HS_D_6,
	output logic [7:0]                       Tx_HS_D_7,
	output logic [NUM_DATA_LANE-1:0]         Tx_HS_enable_D,
    input  logic          axi_clk,
    input  logic          axi_reset_n,
    input  logic   [5:0]  axi_awaddr,
    input  logic          axi_awvalid,
    output logic          axi_awready,
    input  logic   [31:0] axi_wdata,
    input  logic          axi_wvalid,
    output logic          axi_wready,
    output logic          axi_bvalid,
    input  logic          axi_bready,
    input  logic   [5:0]  axi_araddr,
    input  logic          axi_arvalid,
    output logic          axi_arready,
    output logic   [31:0] axi_rdata,
    output logic          axi_rvalid,
    input                 axi_rready,
    input logic           hsync_vc0,
    input logic           hsync_vc1,
    input logic           hsync_vc2,
    input logic           hsync_vc3,
    input logic           vsync_vc0,
    input logic           vsync_vc1,
    input logic           vsync_vc2,
    input logic           vsync_vc3,
    input logic           hsync_vc4,
    input logic           hsync_vc5,
    input logic           hsync_vc6,
    input logic           hsync_vc7,
    input logic           hsync_vc8,
    input logic           hsync_vc9,
    input logic           hsync_vc10,
    input logic           hsync_vc11,
    input logic           hsync_vc12,
    input logic           hsync_vc13,
    input logic           hsync_vc14,
    input logic           hsync_vc15,
    input logic           vsync_vc4,
    input logic           vsync_vc5,
    input logic           vsync_vc6,
    input logic           vsync_vc7,
    input logic           vsync_vc8,
    input logic           vsync_vc9,
    input logic           vsync_vc10,
    input logic           vsync_vc11,
    input logic           vsync_vc12,
    input logic           vsync_vc13,
    input logic           vsync_vc14,
    input logic           vsync_vc15,
    input logic [5:0]     datatype,   
    input logic [63:0]    pixel_data,
    input logic           pixel_data_valid,
    input logic [15:0]    haddr,   
    input logic [15:0]    line_num,
    input logic [15:0]    frame_num,
`ifdef MIPI_CSI2_TX_DEBUG
    input  logic [31:0]   mipi_debug_in,
    output logic [31:0]   mipi_debug_out,
`endif
    output logic          irq
);
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2021.1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
DVM2vD9oKSwM1awWHwg1h/yJRMNkZqI5xZulQIbVwiVtNFhSesKUCv5wS0M3adOl
D5Nd85FB8lziC1AdTYfgpF/VQOlz0O3p8N+/QNCCf2rKu2ZnN8uW93raCApI3ppm
m0tIoUpF1LBH0qhaIxuZcUefmoVQlXE8IpESO6glPd70TTyDv8g0sv2shEzcKmW6
ckWn24cmihERZcCLJ9AwTSvsYwBIdBb/bh6IRK8cE4G4UawOZqUwws3dB1frcrDb
OOyQs6LMTdKlBqqXWDN4HjsqwTzzn384G1Mqv5gA8uw30IZM/kQX/RR2WXufG5Iw
W8MxHLjTXkK+EBgDtwxwEQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 7840 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
