`timescale 1 ns / 1 ps
module `IP_MODULE_NAME(efx_csi2_tx) #(
    parameter tLPX_NS = 50,
    parameter tINIT_NS = 100000,
    parameter tINIT_SKEWCAL_NS = 100000,
    parameter tLP_EXIT_NS = 100,
    parameter tCLK_ZERO_NS = 262,
    parameter tCLK_TRAIL_NS = 60,
    parameter tCLK_POST_NS = 60,
    parameter tCLK_PRE_NS = 10,
    parameter tCLK_PREPARE_NS = 38,
    parameter tHS_PREPARE_NS = 40,
    parameter tWAKEUP_NS = 1000,
    parameter tHS_EXIT_NS = 100,
    parameter tHS_ZERO_NS = 105,
    parameter tHS_TRAIL_NS = 60,
    parameter NUM_DATA_LANE = 4,
    parameter HS_BYTECLK_MHZ = 100,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter DPHY_CLOCK_MODE = "Continuous", 
    parameter PACK_TYPE = 4'b1111,
    parameter PIXEL_FIFO_DEPTH = 2048,  
    parameter ENABLE_VCX = 0,
    parameter FRAME_MODE = "GENERIC",    
    parameter ASYNC_STAGE = 2
)(
    input logic           reset_n,
    input logic           clk,				
    input logic           reset_byte_HS_n,
    input logic           clk_byte_HS,
    input logic           reset_pixel_n,
    input logic           clk_pixel,
	output logic          Tx_LP_CLK_P,
	output logic          Tx_LP_CLK_P_OE,
	output logic          Tx_LP_CLK_N,
	output logic          Tx_LP_CLK_N_OE,
	output logic [7:0]    Tx_HS_C,
	output logic          Tx_HS_enable_C,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_P,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_P_OE,
	output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_N,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_N_OE,
	output logic [7:0]                       Tx_HS_D_0,
	output logic [7:0]                       Tx_HS_D_1,
	output logic [7:0]                       Tx_HS_D_2,
	output logic [7:0]                       Tx_HS_D_3,
	output logic [7:0]                       Tx_HS_D_4,
	output logic [7:0]                       Tx_HS_D_5,
	output logic [7:0]                       Tx_HS_D_6,
	output logic [7:0]                       Tx_HS_D_7,
	output logic [NUM_DATA_LANE-1:0]         Tx_HS_enable_D,
    input  logic          axi_clk,
    input  logic          axi_reset_n,
    input  logic   [5:0]  axi_awaddr,
    input  logic          axi_awvalid,
    output logic          axi_awready,
    input  logic   [31:0] axi_wdata,
    input  logic          axi_wvalid,
    output logic          axi_wready,
    output logic          axi_bvalid,
    input  logic          axi_bready,
    input  logic   [5:0]  axi_araddr,
    input  logic          axi_arvalid,
    output logic          axi_arready,
    output logic   [31:0] axi_rdata,
    output logic          axi_rvalid,
    input                 axi_rready,
    input logic           hsync_vc0,
    input logic           hsync_vc1,
    input logic           hsync_vc2,
    input logic           hsync_vc3,
    input logic           vsync_vc0,
    input logic           vsync_vc1,
    input logic           vsync_vc2,
    input logic           vsync_vc3,
    input logic           hsync_vc4,
    input logic           hsync_vc5,
    input logic           hsync_vc6,
    input logic           hsync_vc7,
    input logic           hsync_vc8,
    input logic           hsync_vc9,
    input logic           hsync_vc10,
    input logic           hsync_vc11,
    input logic           hsync_vc12,
    input logic           hsync_vc13,
    input logic           hsync_vc14,
    input logic           hsync_vc15,
    input logic           vsync_vc4,
    input logic           vsync_vc5,
    input logic           vsync_vc6,
    input logic           vsync_vc7,
    input logic           vsync_vc8,
    input logic           vsync_vc9,
    input logic           vsync_vc10,
    input logic           vsync_vc11,
    input logic           vsync_vc12,
    input logic           vsync_vc13,
    input logic           vsync_vc14,
    input logic           vsync_vc15,
    input logic [5:0]     datatype,   
    input logic [63:0]    pixel_data,
    input logic           pixel_data_valid,
    input logic [15:0]    haddr,   
    input logic [15:0]    line_num,
    input logic [15:0]    frame_num,
`ifdef MIPI_CSI2_TX_DEBUG
    input  logic [31:0]   mipi_debug_in,
    output logic [31:0]   mipi_debug_out,
`endif
    output logic          irq
);
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2021.1"
`pragma protect key_keyowner = "Aldec" , key_keyname = "ALDEC15_001"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
QO+LhnZkKyrt1ZmMyscgtkD5G6OBxRBs5zeev47Dq6V13GSwjlZbCmYhaA5mNWgs
JFMs6kXg4eTVsEHcS9IfHw7av3Uc5riTA+xXqWsv82yYn/gaOWyML8mH82FJRPYp
XPUvl1NmN3TaXA0WJKGT+GUhjkXf9rOtrxGzkzpRNig5yP7Z2xIjS/Yl8QtoGG1c
axpSYFc7HwsrBA66EQEFi15Jdkb1wmPHrGzlRQsDfcQVLIE1gyE3TriDt1C1DfoI
yaEMgEMDkZCDxr26O7+mrn6R0V+t0UVY1jTPfcgacbvaeSZoFDKBvVAQZ6yGu5d9
Iywp6xwIjCTrdVjLcOKN8Q==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 7840 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
