`define IP_UUID _mipi_csi2_loopback_design                      
`define IP_NAME_CONCAT(a,b) a``b                                
`define IP_MODULE_NAME(name) `IP_NAME_CONCAT(name,`IP_UUID)     
//////////////////////////////////////////////////////////////////////////////////////////
//           _____       
//          / _______    Copyright (C) 2013-2023 Efinix Inc. All rights reserved.
//         / /       \   
//        / /  ..    /   
//       / / .'     /    
//    __/ /.'      /     Description:
//   __   \       /      Top IP Module = efx_csi2_rx
//  /_/ /\ \_____/ /     
// ____/  \_______/      
//
// ***************************************************************************************
// Vesion  : 1.00
// Time    : Thu Jun 15 14:09:27 2023
// ***************************************************************************************

`timescale 1 ns / 1 ps
module efx_csi2_rx #(
    parameter tLPX_NS = 50,
    parameter tINIT_NS = 100000,
    parameter tCLK_TERM_EN_NS = 38,
    parameter tD_TERM_EN_NS = 35,
    parameter tHS_SETTLE_NS = 85,
    parameter tHS_PREPARE_ZERO_NS = 145,
    parameter NUM_DATA_LANE = 4,
    parameter HS_BYTECLK_MHZ = 100,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter DPHY_CLOCK_MODE = "Continuous",  
    parameter PIXEL_FIFO_DEPTH = 512,
    parameter AREGISTER = 8,
    parameter ENABLE_USER_DESKEWCAL = 0,
    parameter ENABLE_VCX = 0,
    parameter FRAME_MODE = "GENERIC",    
    parameter ASYNC_STAGE = 2,
    parameter PACK_TYPE = 4'b1111
)(
    input logic           reset_n,
    input logic           clk,				
    input logic           reset_byte_HS_n,
    input logic           clk_byte_HS,
    input logic           reset_pixel_n,
    input logic           clk_pixel,
    input logic           Rx_LP_CLK_P,
	input logic           Rx_LP_CLK_N,
    output logic          Rx_HS_enable_C,
	output logic          LVDS_termen_C,
    input logic  [NUM_DATA_LANE-1:0]      Rx_LP_D_P,
	input logic  [NUM_DATA_LANE-1:0]      Rx_LP_D_N,
    input logic  [7:0]                    Rx_HS_D_0,
    input logic  [7:0]                    Rx_HS_D_1,
    input logic  [7:0]                    Rx_HS_D_2,
    input logic  [7:0]                    Rx_HS_D_3,
    input logic  [7:0]                    Rx_HS_D_4,
    input logic  [7:0]                    Rx_HS_D_5,
    input logic  [7:0]                    Rx_HS_D_6,
    input logic  [7:0]                    Rx_HS_D_7,
    output logic [NUM_DATA_LANE-1:0]      Rx_HS_enable_D,
	output logic [NUM_DATA_LANE-1:0]      LVDS_termen_D,
	output logic [NUM_DATA_LANE-1:0]      fifo_rd_enable,
	input  logic [NUM_DATA_LANE-1:0]      fifo_rd_empty,
    output logic [NUM_DATA_LANE-1:0]      DLY_enable_D,
	output logic [NUM_DATA_LANE-1:0]      DLY_inc_D,
	input  logic [NUM_DATA_LANE-1:0]      u_dly_enable_D, 
	input  logic [NUM_DATA_LANE-1:0]      u_dly_inc_D, 
    input                 axi_clk,
    input                 axi_reset_n,
    input          [5:0]  axi_awaddr,
    input                 axi_awvalid,
    output logic          axi_awready,
    input          [31:0] axi_wdata,
    input                 axi_wvalid,
    output logic          axi_wready,
    output logic          axi_bvalid,
    input                 axi_bready,
    input          [5:0]  axi_araddr,
    input                 axi_arvalid,
    output logic          axi_arready,
    output logic   [31:0] axi_rdata,
    output logic          axi_rvalid,
    input                 axi_rready,
    output logic          hsync_vc0,
    output logic          hsync_vc1,
    output logic          hsync_vc2,
    output logic          hsync_vc3,
    output logic          vsync_vc0,
    output logic          vsync_vc1,
    output logic          vsync_vc2,
    output logic          vsync_vc3,
    output logic          hsync_vc4,
    output logic          hsync_vc5,
    output logic          hsync_vc6,
    output logic          hsync_vc7,
    output logic          hsync_vc8,
    output logic          hsync_vc9,
    output logic          hsync_vc10,
    output logic          hsync_vc11,
    output logic          hsync_vc12,
    output logic          hsync_vc13,
    output logic          hsync_vc14,
    output logic          hsync_vc15,
    output logic          vsync_vc4,
    output logic          vsync_vc5,
    output logic          vsync_vc6,
    output logic          vsync_vc7,
    output logic          vsync_vc8,
    output logic          vsync_vc9,
    output logic          vsync_vc10,
    output logic          vsync_vc11,
    output logic          vsync_vc12,
    output logic          vsync_vc13,
    output logic          vsync_vc14,
    output logic          vsync_vc15,
    output logic [1:0]    vc,
    output logic [1:0]    vcx,
    output logic [15:0]   word_count,
    output logic [15:0]   shortpkt_data_field,
    output logic [5:0]    datatype,
    output logic [3:0]    pixel_per_clk,
    output logic [63:0]   pixel_data,
    output logic          pixel_data_valid,
    output logic          irq
);
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
MJsL4afRq3jPm5Z5JF+kTGo7nuFQKomSwMc5FCXzAf4pGIy6aYDBG6WFDe8qM+fI
TgR6GhyVvwYtKKtDY88OicoFDmWT9vyuGrSnILtmqZlVvj7t5wxUO+4n3/kpji6j
1ASmnkBZ5RBEnvoPzrBVlxUNuCYdYI/8tEFHkgWSuV72987GX9wPJOs7mG4RFOe7
cqAEbDfjdUNcRXQdRHfF0H4v/t5/F0L9qBXnTL2qzurVFoP1VKDRTcyRG2KNug8z
bQ37kdX1l8KJHLOvbQfYeKuhMNnv+nE09oqM5Z+e0JIMKp51fIvwTHGcYnxTLrjo
w1pC9qtR7aSZTInNYbPrbQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 8464 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
KCPRw1svjIenKiHrleHUWznH/1dtlN1GYxPo0cbdWB8OGkWiMrppjWNxJD13fiY+
f7H63g0nBYjm6Gk+DtyN2qQA7GuvUOa9VGasbQUmJ/Akrdd1nH8ekGvU9rUbsUOY
ojkY3ChmWbWmZ58sHaO8qaaMjDgrJKRk4rSwoVsaNMw56hs5KmK0lg4rNN9S0l/i
DTcFmlCI41KcFl12TZEgjuTNGY6GGocU9YYUl60G5rEA00AyNy2fXBncjpzVcrx3
J7nxNVsEgnMAcEdPrLikzbbPVkXM6+EwWThOu4kj/XwlTA9lyotU6V3eCiXMaJqe
iZThqHVB0xEZKANZbBnwAg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 6336 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
kaWszgagobX/21ieQ3xXQ6lQwAtRUVI7i4Ra+VG4V2jZcsII3G/pUZs4RS6cWMi0
9LAiLOgdEGXhBY7CPJ5AiAuEkPM5qXltXjDD1eV0eni5LH0Wj99jf33CalzV+/CM
GnC+V2ckge7yL/DIM8/fKBPB6sKKZfCo3qQ5zsdFlWfNI3giRKsDaZdyi1+ZUtKf
ydP+sBn632zC1EdnME84//5F9QI8j18lmXcV4ZkeDkuPsj/Q7KYrsWJa4Haqzv2K
TrrJMSDk5L8Lz6P8Bk0WfqXKH2Jxy4zySW2oMJ1U+b7hkcBSp4u1GFSXexPSvqdy
Hf5ZSXQ1EfxZ4Z6F0oIwJQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 832 )
`pragma protect data_block
nqeKZXmzGw4uZ1I4UD9JER2XnIWSZowzAB/tHf3ufjQ72BAkeDPKhtdMNMkVgEr0
//Z3BMGTLCvBGqtgWS/rXpWeZfGI7aBQJSuy8QzwiCY8I1iEo8uqjItdh0+AJg74
7AZHYdDdm5AUCy6KxJGss2d0R1D+kUqRGQj9sg2C91+9ZkmhaIGcq9TWtESBUbhn
Kj1KvrZgrvXNKlOkCWujqJtx6MKgyY85dAizVePkL+oKCrsn1+Gu+TzdM5vJkGzF
uonpP9/WymUzhW55EgUlW+Rn0itd1/mBkqOOgEyDvi9VVYHLtCh37PxG8SrVAg7P
kjK2EiIvoTI56bnTlRr+eN4N7BNBYfJmbHlkmoz2DliGwU8N7AbXIRU97THTJ0Qo
BSdf1q0AfPL8lUpLTz+/i/unWJxl8/7KQeWr9oKNbLOWUaNix8+tbb4bT6KiRvTD
nbq4ozOmO5bShCUhDXceeseDCYimn4Fr6rqonouW6HNAeb+3tZi/He1r6oDNjZil
XMxR77r0twjFywnCYm5hrqQXvswt72SgKAw5iRAGUtTJuSAa2oykWFflSakZEok/
Q3xcr4n4trADFV0w38FPfEfcPNrjmFUrqzggr/mcCk8Tjwub7ICTUQ6jrRw0+V+g
NHA/bxcxp6FyT3ZS8sAPYQbZTmRVa9By3LSb4c69F9rn31Gf4gkTsC/uefNIBL/U
7O4lb37XDiLePb/XAQkM53q8dumC+WJE28W8TgczWTwUT1xZ2RX9GEgt17GTx1K9
JLfiUUtMt+tHg4rgcQ43M4X/wG/v+p5OgniiJ3OF80UzQf7p/ga5OH56x0hwmFNe
DLCEPXPh7CKUM8S6IHd2KUbNxtLwbUakY7qAcAS5v4iT0JQMq45i3krghognZsSr
a6HTb2l/Yg0UOZ1i74z8xyTSvQod9EfK0Ii0zmu2vH3ojIlJH4BbTQ0QzxNlHiAu
hxbJxBU3fPJaqnQwWd4khCMNKHnfR0NvyNu7g7lIZuIVH3NVJd9SB33ECvBX68j0
fQmhHezLhBNizFmV/eahYwASmo44C269xEkOWHQzkw8VstySGszFuY28tiKAlTXJ
nSg1TJVjJ8xxi2Vqmy8mCA==
`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
GILw25B+CNFpGeRTAx62p0OSTNvZxl4qT9SrWxJN9xWs3aAFqNZljafbBObdPQ99
pgGWpSf0k0vND8e/LTttvi/Eyxlx3EO4lwtubW4nL+gn30QOSapEj/6SCs134jk/
STiE3Y4Mhhzy/2XZbZ+caN96Cybf8MfcTMj4xu18csv3n7pVdEYKBghrce6Ii3wJ
sq8JMY2tHyPmgfuBU2b7yly89Kh3Gfsd/tAaaXeC/XeHHG8Rj6l3Dm//I3cVS+8a
1dlzccdTFRckJDENyzb4mTKXNneyoUKXnSGSzQOuwwVAJzohAPL9LEnMcoTffbZ1
9tUq4Uu18MJOX0l+huLVqA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 13328 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
F9l/pTqUEQnS4BDyt/KF0AKLOXSCRFAE6SUd+FKAQqORSQijWaS79RjrkVBBNyAX
8RkgWaGn75RQjqFnVu8g59jKXvdvAnaf5Vc34tUc6vlyyZd0wJZIIu6yFOL9iF8/
pe2HZjNVqa0kX6EOwXAIFwxLR65VbwBwzLM4b5zjr2kRay8b9aXsirnfFFt8ORXO
H8ELIdJcxFz4y4Gc+CpCWLGOSz1tlurlcjJ8NtUXLhPwiPJrmiIB5ojRWoaYhsio
sO2B/U0n6t0OSv2nRTeQcrKMpfxMrFVb3rXJj055OUJwqQwNieUHVziRuHtNfqoz
RpFTJrBSzK0ibXmPv16oew==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 8784 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
WNp1tXFav56zxjVWUV2WG5V0hx7HueFBVMyC5SCRhuEB9dgVrn7583Kh265vyg7z
pI8foId6Nz1B6l3Zmjs2uQW50KvAhY6sjmJNXEGLUsU+qf9Whas4cbAqfkpnhLI/
O3YrJThNA3GeTvlNZezxxNCByFcTy81PQvot2R5GlILXF3q6nnZf9OgFi9emXO/s
9xI6nYjbXgzs3/c4PVTWpPZTxnflX3iaLAW972KDu85bcEoL5lL8xZJuq2/tiFVh
A6+yfShYjSmyQfnzpxkSKq7mGLBHdrSWyVbYWhjtf8fYTeEFlpF4ZoUXv0CJkJsy
ZsKKWmTIUc8T/xIFFUpvWw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 7408 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
iPVP8N5EoNwFJCfbuXzLy+4wvVYYmduhf5rGrF4IcfGYFZvoTWf8bxHitDmDP7fp
N0kH6TyiNkD8g0ygudrcr5iufGi2fpO6jPZOKypfrRkq9R9twsVV/+P4TetGo6tO
65ld3OdivogxX2wCu75Ym2B67/CDWMTauFSMYZG2lj71VPXPaVd2GMf5MTojqA6Y
kQ1c6b4ENSHaj4ZNGkw6IW0DzKVY9PqJzTcyivpCaVZShDH5bFjPJshLZ+k8yb3Z
oIpe2LJ/wa9f40l2HisXDwaZIpSH8THbbubcdUkG82x6a4hlv11QQ8uId2CoC7oj
NhbDc1K7PqCtnBkhBy0Dsw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 15888 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
cc3JG8PUAgN6e07B2XpQGEsSjp98HCy+xQoSc/VnHQ0dD1HCQG7ydxqUsmQe/Vco
djlG8TGyvE2wRLH921gdXRl3lV8AWvSMSg2eyHp6NBu9d2gKTMCv0hFOpfkAava4
ek8+4ViDYS3eANQpn73Qkvs2dJk8tUUFSJTan/0DBayF14sa497b48b+du42LxnI
OmdzJ6a1BEMLTEGKrY0znAax/pQtD+SwvkcESA7rOAu3ng+e+6LnWZgRHSWg5osq
oFFqDQJlp4SX5Clhagxx9pSJovhL4WlVfDu8Hfsedb6N50W6yDZnNslTckUFa19O
MyiNp06GUhxINvaQGkMLMg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 5616 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
AwhJrcOeMXbc7JR69STeeySgzPY/ljRROSk0uT0PkKJ9JaapoifTtTMJO4o6RlZP
Q50Kq/pzBruMwyzWvFStg1JnQaP3s6mn8YHFLPMqnthAD0WgjAMEch5ExMAPHm3f
f7e/we3wY7RtGTWVJBv3mE8xB7WXJxkc5IK2SM3SADafrVFgddDaVUhatueDrXVr
7iaJQBvIjwTdgsPfokc+0WF36Nc/T5Ro18c5+VEfxV+Hgo6vHDTFBAka2+8r3rRq
y8JA6iizDb17KU5R6Oqk76NLH0zlwXMl9Qx1pvdqiAmTBbp82hmrHAlx8iiFkZLO
OiQfdcIN/g67XHVwHpvqqw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 6416 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
l1ZizU5o6yu4nauNoq14U89RrqCb6wZY4IODR9tImbaP7Z59g+Iq2hz/Rvxvk+eY
TWrEKkSUkrdr5OMpdUngQL6UVoxcRXrAHbsO+pHvnQeInO7W+sTUSctYJFeZcghb
jvWK7XVu5bqJS+9Zie8cx3GHxZObJxkHVmCamnJYHlUiPsiW2vTE5MX1ewUCxrZB
KwEhjWUAnKB1sEQbvyGA3GGAxoGniSTAMFCBoXIUfEuoBr3uoXZnKP4n6tDvbNMR
rxxbPmX9Z29G/Wt/VZFcfojYRY627/OI4KxNB5+zAU5HdyXqLKq+ZBOlSMcm1sjh
jSdtMRbs+rl3Jvu0wePl9A==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 944 )
`pragma protect data_block
QF7JKA056brCC5CY4MlUaICkWejxNrPBudK7BLMNubbXtSZ+7C+Jq8Y7lSxVfpp2
FTJfkxRTEYsDC8vI5y3Tc1NRveYNpg6ulva1kfws0pr/lcCXcEUCF3uqXPYmCFBT
Yolap6m5CrKYwqzAoYqK0pJArt35E7eckuj1OQ0Kag8b7ABXdhk8QGM0BuvMzxDu
2FHyO8I1UGrASSurYplgPFr/A394cuIBgSmy1Djigcd9jTrzNL/CmSc5FA8uRvCM
3Z6fJxz1H8sfgAsidG4J88CTVoI3BaNkuG5J3xalirIR2S2XJ5eIz0pVVaLxmXrH
hQt2VpRsI7SvJnJVANzxKh6Ut6JUD4ufO0GkOkg8JuRfJAgENPdt7EML25AlSk3P
c0gvdFD9gofNsCkOxW5yeAi+YDfzygsHymQVaz/lY6QJ1xn0PYSm6wo4FFrg+glu
s2lEL/J0rvsNmveTBDl8KzPp2f/JG1E5fTu1wJS+WhV3sE8ETslTn3QLQ1us8BYO
Gr72ezGjg2y1QbV6ROTsp6B9XW2uAs36d8hyBMdIZgY6Q8wncVnCX3+ttRJhcmIP
d0tlpQKMU1YFBhOtiy0mFB2BhnKcMYdtRJ3j7kOSCmtzvXgXCMnCWLxZ8RL/EGWp
k/qo2i/SWBX3RtHsDYBDQM8AAh+DX7Gpxaw4NDQwtfJudVI0SzB5CuP/h+Sl3HfB
ilZjt3VT0ABRf6H8cBiJ3Tqaoe0rPj0m4xP+9Ffmv94+WFnKq+yx0lLZp4cnDVJI
cQer5JUa/PxRl1gKXH9BIUvP0aOy9bP4XUP+515hWTf/vwc+zqaQ5840roK5BbUy
QxY0soiRnB9q5uN2jOCdnTYNw2eNkk9YRw0wJkOYPbw5uWtc7Cirx4V7UqbLE8/H
mmxZnDLXVFfmHHSCxdl63Yv7ERQxPYrh/Y0FYKcI9YI0bnpMNJM1PtTsg5oseSvO
8vuv71Yb3pGYUhbAqe8J4UzrQx1Joqoov25viZEvmqgqv+3C3T+syCwxJuuOZ1Xh
SUg2eELPUrbpy29L3EmAJ5e679NfM7iHhzcPmIdTyIFjWuA6JELYng6fps76rZEK
TcFJHXf3GXTDJrgeyzQPPce9O/++sRECfgVp9NPWe/qV4M8aoCvTEiK1VJsNx2FC
DkimFdLTvZu0puSvfwYNIM56iQTdJz3QqkY+iQyELo67/gQxZrt92yhpnambzMhR
nLf1M/YCfB6uR8qjp1csPdyrcKpF9fh9Zy8ase97A/0=
`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
Fbb7vC0U2Gt3L4vw2CZcpTBklMunzak7z71wMzDyCqxIJPFDaagf8VZAYTWeSWBf
q2LdzlAhijs6sMC9wpG5gE7+IP3opWyqFib+FrkS1Vo0TtZY5xv/fQfKcqufMGIG
fe26OAOu8u+kumfLD/m7tjWAuVxonvUuA1NuOeVJDU3z7qwmq1UOPIsxX+VWI5fJ
1v6SJelLaRJQtntopcD1TfOGTA8YqrmhMwsUA/VCnV6ePZULnBrYGRWYPXOHDN9o
aGuljrWzE2sxolur+id2JgEwgR3OmQkTFvWGmiUXU8uj0xJOnSTS6rQm6rq5s4dy
7ugaCW0/Lnzqtd5fX8fLQQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 26432 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
hcfHh34YuTiQUHDtf09f1zDm7n6xCmNL07lCadzfOdkzFAqqqSeVLCJP5V8pze81
FMeIXSqnirK+7AeOmzbgYa+h2+5d8HTC8ZrZ5cZnPauJn1h4ZFtlaJPSjZ7zvQ86
u9RIxE/WLFyUTHpvWRauJvSsh9G+IvMRrKlQ/msYV1kJGxqpB7WvNqHZWRuNjoO9
5ujt66gn8LKVIwcs7IsjCFhYW2IbYifRjrYGU/6bzfMK1hWcJjuJXCOku7Zt1H+D
T1Q3xBwlDMjcUZyv9GAt06uwpQGINkPZV6sUvUtOwdgtnfZbVUBrdxlg6RFZwhFD
K3wj7IT4gh0+giHMc8vA/A==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 4672 )
`pragma protect data_block
5QY3HrcL3REoMp1ylg5dsl9FCH5FjOz+SQpO06vYDcd1QLvMoB/Kl2VEYHoSVwWj
eASjN5IquLZkUGQ3z+6ylJCYdtnF2NGo2hldmXiQFowlHTalzy2xdP/N9Tog5brB
0wqNNAUm2ESuholx24K527HachzvO7nYCSOgvgrn5/c3kPnnBiisoFS2gWZgJRdN
WVW/VdJBr+EL7JGuP3br4ctIM8bWOCdsAe6wuia5E6wCXRZowVJF4mdgwteIvsxg
PL0qi6raLQor2NcSzM0DpEnecfaBWbZnDJqhwYnwnihRKR1bpvTNG6JokHOGB2Zv
pmI84r7ZAg/632sVohK/S1Ku5unnxSusTCZ4AWx1mB7DJQVtxO2S2tUyuMHEVrQc
ul4Gs2L45ZhcmSBhp83r78N8H1dzopb5OwN9Be1YdpaBPwOswwLryrkERv0uwSs5
2bAKfhuwt/ZmFJnqgIz75ArOtGEOlPNOl/kdfGNalUhGqDK7NGw6FWG/ionNWy3w
7/pRPHSY1/J5MEXmHweWcV5hAhO9bKCF5Ez/qjLHdvpVZDhF6ogzSDE2pVjLP4XS
2jaxDShreFWv+QjvLZVoklfTsUhUbjCNinE8x48swSWqWcqBl56CrGGlhpNj7KBa
LvfZ9koDB3I7F/qabdZJej2o+o1n5TSGAGL4++meS+6yADTDwEgAi75MrYi/cqwd
gZU0OdwXiH4Bk7exmOK4T3dsD1MP/fTs7GU7qRlQ0lgq3ItxjHAg0Muz8kt9prwz
JjcF/uGEW7LGlM49O0bCMgSoJ4mDqqcwUeQQQ4pmCS9OBm5lSni2OMXtkH5+Crnm
Itnqm8gjeqItYQbqkIFMLZ0ZlwgrOYEXVmW85tEj8en/KX3Or15OeNONyAya/waw
kyDYvCf5qlYYc4lreS6Zw2Mem5kfFO/9dswmxDtz3hSHTp3cXDBXG+oz+CWo9jXa
XoxeQ+O0yO38wjyVTqJqG7j6440QPRsI4kZ13xhaFctqvrCwcYhVPa4irgSU4LgN
X7JKozF/K0WifTz/gx9f42TMwBFhtHJ/9d6IdE9lDPbTxKmO3TreQLJLRamxcJUW
uxnJRdUi2Lodwbl5Kt+0+smdZrHQghyetGOuQVvhT0m7ckLmQgeLgMnukQ44D9N6
/Fb062owqX9JjbZvts8arTgn5E+DcL3eCHbbUg28J6VUiW8tMEb2+sdlLY4o8vtp
OQJSgtKbIuriiWaXp2cdmfz8vVz5uMzUWz3Lx3WkW6E6R1WefcWhJyhC503CEPWB
HCV/fjkcjjkGy/43LErRHkSF5A0NANrLxgpc78QZIyjiz4gSbBkptA7D6Ohrye+U
NnsAtmDD1EWYUIZ1kD7iZE3/HuO+0tdUKIaGEASdYiUpdwP8KM5ar7fh1Gy6HIi1
Gq1mNg+pOvAM6lKdICe3DRUTMqEc+I6nOgH6rvG7WQVPCusuoslLKxnFwQd7Zj7b
DmY3tCr3mcNxD6P4BhNI10Vc7k4EnwpoYTREyO+ysDA1MBGMf512lprLWHJBM82q
EYHxw1IKKdgIFnVS5cutnva5zA0umqTKDq65l2CpumvdHeueJDHNEd2eacRnvaew
Sdi6hG4nvielWNBNjEZxBUha9nmpbOcEzqd+B3U32wQlqIk7rIKvzTaFcgUighR+
8VVdX7dgbjMkn7cOaGx8QpBH9lszjU9kC7Y+Tl7NSZhtZfoLQKSHOUGHkd92hXil
zTgqlS97pqola47HuDsA8dFRLWC6j23V+b6NYDAO7FnHauNwI5HKiQXZpjT0Ab9E
6B3dEcskccbVAuPeBdLkECPs9haVXPgT8ZoHTGEVtivExJAduHAWF7Aht8KuIGEv
GTcaUVYmO+DGBNTi/X9XZY6PL7EEYEZW6PMXFREeNjnTE/W1n1BNw4+y+xXBK2os
JZZ49oqiKwejttNiYzornlwmZrdao0uEcaNDJwCXTwZR5FW1nTvoApSmgr4G1vR+
ESqSdN7/0SerpW9BZPutDnrnUMbFQAxACJ4aQWXir5m79F+T/KiCb3sWoX9p8yyg
rVZzN/YAoWY5cZXV9zF10WvIoYqTlrrf2iOdi3vZPMu/cmy1eJIpZ+VffIVNK5K5
XtGCT/jf7KWU/wtIEwk5FQIeeBCrAZ/Ih8fQ/ZMk6bX9+yTclj54P+Ux0OA6EC1P
8ZFIYVYu4MheUROmk0p1K1a/OnOxCAxjo5Y9neyoHn5JivBOT2VLFxDYbg5I4tI/
mMXMMk2uZHV+wwO+H3cjYVwa5hwfEmz1rHApzrgm79Z9bsCDssdBHAtw/82OG3t9
+2TYyISEqQcu5t7nVBQINkodArzrjT4uGiosYT7WwxRthRE0fk5Kq0R+zUTzy0nP
dur6K7jR/A3JANwOe+8TmIsvxdJk/BbLRmugG4mrv1LrHdXm9L+qmjzXMJG457KQ
DdBrf0Q8GWP6EWzx0W9eQ7zcOy2GQED7Vc4WHHBRjF6KZcq59RpgnT5Q0wlUhtex
EtBVMAQkMpGfr1rwi9DvbQt1JbVkG6BXXgyigBMPt1IaExHiwC9y9pRiLUlr15sg
zgHlHbzbJ4CYanjKqD1YH8Okf4gQtQQFjENyqDjTfOL9H0XgQKJIOMAjGg22hSBQ
dJ0S1GGOgl53jYZCG/+hoci/oeSsCtIihoUiCDHSWZQbuJOZHon+atULab1/wMOq
3mNH3ZG2vQSsKrwx+tq2USQDu3CWt3D0bIxTktJWr3YZ4ojgBre3hGKag3SP0r10
2zZo7D9qwcY+gM/0myBtvbStXOFKhd/7PD4M9QLXcTUTJqAYVCKVwGu+KeVJeUQc
Z+yIN+dpqgiw6cPZyo2s5y9YAEWU+MtnDYengLJ8f3nrZgmpJeLKjG4BRaG98fDS
MbF8MMpFHpoCmbFViWuARpPHwDew0R1r64hvr8CvQgDTypBINIbdsRZLDfZfKVgk
TBNX3s2x8FSp/tCE4DZaARMpsLvPEnlBQAeuOVkD1I36POb5xJGbrA1Tcg4CONwb
y576J7A8LAkDPPx2qb3YYqsfCdM7MeJXmsf3vjPdo6AxQfggQ/AU7+8L09T+QGSC
5w4JG9Xb5LnQazC3uhZqR8LvHI6KLP3jLC748I+F9WOBmtHzn4ujdjn4UpyFoClj
2ti/LHPHqi/5HUB12N8N11o3W+iSze6R3EMTwtterBIv4HH92sBkZf/zqS6lvQdB
vz91M4ELcbXVPzlrvMbgKu+r2RD9fUYKDfqVOe7xd8ZckLFJF4+DHhyPGNp3BVzN
mGXAyHndpldeNj7cyxK7GX06Rm23RZD3gWQieXTkNjodgj0Myr6Az8EsSt+2HZp5
qAvcz5/r0zAm9ICRrDI2hbd5YKI/aj8wJhOxStOuYL1Yr/bC7ffl3DQtgPRa9hkf
XzjzP2BjELlizGX9da1k6i3I+BuHv0HA8ahMmFdDo6w/JGwr4k+CCVtgNihbFkH9
+oQCdoKJPxkBDXh+ohvUFbmyN332XXPfxnmu7YZ4lLuBerTE+oqH8FJUy4WYuQCA
m6xoEm71GbcR/O84eLik98aMRpyPVYvluaKgd6p3GCzvVuk1AdGX/HhKJ3nMpN1W
t+Lk0htx9yvHq+VrlU387pQpSvp0tZo4/UH0N6TjB7Kk/2J2bocMYf5Ea2cEshog
mGAnHzoHICrB4QF6NBYNCSiZLzt5qrFNaoDaFN1+swWKr7KYG1QEFNL9gwYrmBLJ
N2hiKFsAHnh2qKMLE7YmYEN5TXtHa84FS2siTLQZ1ABunqhXSeYXmmMulxjtlyAf
/s1uuEZOWwCAW9lL0IenvG3nW0JFMAgkvmcP1Y5HhXij5M7xhDMuxDF5kmkfMCF/
gqK0rZjf+coJ9K6F/8hFHuPKzLyKN3cqUMUpZ0bCVwTWtzmYQrVij3YxA7FFY3Ij
Y77OoZQwNojnMt+3MvwWITe+KUhTywkxKa3qxL3+eIIlRIGR0cg7NOTaGtAflRMN
p4VrytEpJ9EQWzW1zRd+ZymbY3x/exxH+Yhdjwl6X3N4IBMjjwW3hkPNajgzbPXy
Xw6g1OhZmjcjvyymB9W7HvSw0Q+TiKSpbMFOZ4VsFrhzayQ2ZK5md2OdSqr+AgLv
HVJSPvqSjEMqfi6ugQo1+JpVkLnL84ADcnVR2pj9lj38korCkTsmunGLOrM+Z1WA
x6md0Zv4+c/sP5+40rQKzGUwQIB90ny67ho7nLhJ0EqGO3bWFIOVCjwNRpMNgRtD
r5dj3mLSlnAUXjfZ8rYFmzqKQKh5ixM+bCLIEESxtsWM4B1cIXTqanAcvhL86J6j
QBdBQzH9NPCyVMUI85PhDZ/TicUp+cKHquk4JBrGVX83cTFY/Rn/T00sP49LHnIl
wUkYGVBUa5U5ClHlJoJ4EUvPaOx93oMuEgwkpMxBkeOaIPhxtdfmKEx9XXkTl7As
B6dYfRbqxh5/oHwN7+woYhM0ENtsvXFg28/+aTPfOMoy9griQIbRkcGEfkSsB5xu
qmDkauVwRDDwGty0JGNAcGnystWMsIUfueeKwFG3stJ87JvilIY/0CEffvJe1VXg
DzDnIy17VKEDRIyWCocdeQV76mr8b2eiSnHGiPWDcLqVTS94OzpbhGzRjMxLNE2A
kpiT4xB3JUtf9Bmt0ootGF/ERnLXRUtnpdu2U+pehSZKig/lxBgTRpR9sOc+aw5N
kRkX7+gIGDELXKZc/m2D92KsIP+21VXrvcDIO91Q/go4re3OZe3FuPg1z/w6ofjt
EKywIrMgGvNTXpz8ZPErW3ZucwRMQ2O0ubKTsvHRaIF9uQWv4VLBFUdcU+KUp/w3
cb43/LGEOKVNuGsnAxnGMBw474B3vk93Zku4deAikh0lIMvmAZ45cwZyBTtut9Sg
wB6k7sadZMCUnDlb8NkTQCejc0TPMynJ5/sFTTDjg57zXCi3SawbUqhK4StdmiRp
GsMRFN3lVVDD0gvHfNYeIx8MqVpXlkr17ECgAX3W8c4E5nXRg0iP4m+YUBluUTth
1IBwMHRZflnUE2cTqQTvMBi7CFL+DhYy5tEksDaSJSGjGZsSafiH2vXvGjSseyFY
Bcrm+kNIEMJ6lXW8iQVH7GrvvNXYurZ/68+ovAhBxJwf7fXlSx13lXx5UFjbRjrj
9AQX03Fu7lHl1JQHBtxzpiPgr0lOip7nqiTVO42FQRb2+fDVkmJkdwUOcgVLR08D
jVPMTzHxAcuTLXPfkPIpYsrBKmbARP+AtJmuC9FLMUB/CEm0Zj4txBow+cXnZuvo
OI3bUFcmJ3mFEwRJ98C3gI7/HFenD2jswjB40dDD8x4k7aiVX4UzbE+EJ5JziFGX
GyFp/HT0UUk+X+sLpCGfaB3NEbvC/VILL2mh3Zmpe/AeVpeMy0d/jpkOaLovmBvr
ZJvAL9T0VywYlyaPI0QH5SpoUkX9SyDj3NcbG4yQPRApvENohahV4w6lB07u6keX
pyg9W3hKkj7Yr1wUEAW0TfV75Xh0no20fE1pgXifsnCKYThVKTPp8TYQcYk7KiGE
CZR0Ik7PZUxTGZrpg2GMI9qA5IHt0kPCoo18Uk9rHeFNmgQ/eAStgB3mBJnCNaEf
ihgi2npKwT+4e4hpLqwivdHRsLXJz23rTYB8YgXp5MChhl6b43BYViPnpJ/StZFY
9AKbgXfY1KTQd2hDkycLLDL0hbHffVDshmIeeJHy70J+lR6H5LASe252Cxzw7LSn
JWh7erbznEtsEprM+1VLtOrC8TUb3E4JP8A74xK3u5JQP5WkkfTy9jyY38+IB8Cb
f1HQNY1KLuGaC3Bx4Ofjb7zikNCD3jJxvTI7HRAZTSbPJM559kGgfmSuY/nubLyM
ElvxrcdK/3H0UJkMFRqvy7o9lLDR5WlxnEFcVMg4wpXHZ7N3LeCfJjH76+9VaFjf
jNUwszYOB1hUiF9aQd/G9lJLQoDC5+r5+YN/I9a+EUFvHEPULo/kvUsjA7yyy7iV
oMBD7E9M1ePUrGfwzfAqWubPb73Yt4Ag2zZwOxKw1yri6luSaMb9GsKGRjaZLg3w
FCHF2qNMusKfpgMsbc6pM3lCc1PKQ0s2G5TPM5M08k2bubUomQncQTff0KdydoLQ
A0Y6eWEp6jiNuzbi8Wqs0X3DJQ3SvRc7sUQ66D0RTnjsKu4GqUPigGLXeN3d5SYS
f094PRD8sGOdARBRqHkrHQoA1KWLwYOzADb9eH8CxZWDQS+grhIRv66yo+0n+5VF
EgNN3LBAJRFAzWvEYdkrgg==
`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
V1Tta5fIqnTSDtHjZH5UI84wJoQmv4Tqwgs3Q+N2Y5FgIrW+XwNjzB9dhsL4OFGQ
BWao0TTuB+VItMwntQqbb/hIeLUEA8hgUHbWWosiVe6uTs1YQggvQneK8nbKIOGA
+nnHLdfUOSUEcoZsO8u5ZYHhl7djCU6ydl5gN09E+tEnnCOT7CZmVR9BDrgbJLQ9
dUfDPVqE34XMP5ZLyWSGyCwxdzYcWIRdaDtCBH2DkdR1/eiF7VV2FHgn45fVkWYE
e8UqdOAOBq6U+aLn/RSeHqXNzBk3/f3J4YMezDXYXv5fN/cxxlY1ErP2VszxyvT8
0ngEDW5pGE5OM4OtmxPnlA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 11552 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
Pm5lQhI7Pra+36AaoUdUcj+ndwo3w9dm6NdFW7uBbzi571t5Ovsurms7SGuOLMr4
iyNfX5SYp3qUDNP8mWKccyAYxAonFUkv8nmqsQE/ryJONbKPBRDnd6Wa7RYxlSJU
aljdjHgcY0xhdsexL/lg5cWk5Hz4B+XZDJQVUvBtbv7ZnogcAFRrcfNU/5iZfCKN
hBv3HONRIq3hE7AhXDjl7w5WHdlU7/fxR1o+VEoR2QeY2upC30WNPUhSbTHNuRQD
A5HQYBqy+5toJbex0+FkQhFotpYHpB9fIwc7SJePVB2J6garBofJUru1TmKpS3bf
ATjfxWsMg4dPIYPLkTsc8g==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 31312 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
AIkIKMZlIfayJsDs6nqzIAjMRz9Xg6VaqIVoZMz87dJCJy2qhABd7N+t/n5Cbss0
Nog93A6o86JaubD8fgGr8OiaXABNf3K+BtP7sF1TMWU/MCcT+5wjxwo81ZcMrWSz
/126//5ZIxbxty2DLqZDuSbWABjA4TFpD5I8jBthVZx0IZfFve2FRvsdGkPn34mp
AnTpC+EHN3QRrTjwcDOYCFg+TZmQ4frmCCOTxNmvm58zcDe1B418qOU60P2fGLpP
HY0uAXQNs/kcQ+NPGvpEOY0ZkK4hMoMwzZqvBcwJiJjWqSWx9xwblo0i+ldbBayL
uTdVsyLhe2KQdRCha5+tXg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 2384 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
iCdMq1lALVDtP8CIG56HIJYS6kJhd1+ruQ/D6MAoYO5sNZIaiXfKZ3qT+BJgx9RF
QU3EpXl6QUHZ4dMAZBET/emf7YOKvp4/RE8bDs3QSEyx5Qxcjh0t0QKPkZrgAx6G
UxCouRiy2X/fvThYrTdmcmq7SMlDwBftSRbGc79PjIiYhwxGRhWIN9GWz1ggv7CL
s0gIk6QPavwW8h4HwlgTopVU7mGgtaYPpwR37VhhOWgyYcurOY6EmHEdMSWtGnIX
W0omtiO/oPUvFKvUt2o3Xqao/gQ4k1WzMvAhrnuj8ygod5qgSq4EgEVEB/0P7BWZ
m5DvBW5NzGWBq2tU+29QkQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 6048 )
`pragma protect data_block
kvzLdJD16pFv84uVpTxNFRkEZzr4bsmTFcGzlFdHckYzAV+rjXitTLR0puranKku
KJzeXfLim5BKA1C3w2wZrG7BM0QBILO6cYrX5R/2opyGFtV1OX4v1fSylPWOmPjq
WnJcTnXVbhwiMK3oobG1bmCrfWR/HlfVsl05BM/yF2/LnDlvhaqqgUTQcPcNSA/K
nYnFx8yWNHngLFxn+ftIJXkj6zuBoeaFWKOO7SLm8yyARc0tw1FG1T4YWS/TjmEJ
uqIOhL7xeRqDPEL3j/rYBRSPcPA3EF5jjaUKjBwU86auV17K/FRMb20GUq9W1W0x
gPJ8cyOejYtcidKnu9vd7S+/KvL2pz0+RAqZqlW/WAaHxPSOxDTmPv9nx3uYjf3q
8OBQLZyX6XSSdereT3YUEmiqljhpQoHxM4Dr8vrU0q47kmNwbTRVo2Jj6+FxY7Hn
v11BTZL+ebNbC8Ca8vzD+HdGd0j3L1TMDJLCGe4/e4sSjf4DwASfOlvqmrH11T92
rytQEum39SbkgDf8lMEZCromOlJ/mmYBCf1BSQC0buKEB0oMEhvp8HnT+xnRTJac
XN5v6JBXq3P/xzXZ7ICH/M5Wi2KNpBzro8SL60CFInUTJ43OLUxusPTQwtOQm9nQ
gksdsvWmegT5512C9fu8dyyOOvLmPluZb21b1OaMJo48gQC28ya93K6JjXS2GXbi
191cfU6xqME0Z3ZLG03tf2RMIoVtE3ExgaiQ+F1sgezZ6Kc8bPCuW84874AkozDY
H8APG2qVO9xSRCZfP6YJBIdj+2E/W+c43w1KClGV/8b3FnvQ/KNRKB23Wv01Jrol
KJ43dv1GNqrYKePCl7x2LlVQQGwnWwXOAS/P4lon3LspK/gjeHDC10vWudnIUP3G
W92b3qh+z6vQ4iDrillPDJ9lDv7uJUUC8U13GuxH+K+0rRFlUelp5KpmKahxcMrc
NyFnvfhp4vZWuTG+SZaouS52nv1u7XLsFUyfWh6wZd64i19iZsFFazFijNUMLH9O
iSxrQfKDrUaECpTRiBIe3nYdpapjgUZro1WS3bQ9NVMAZW3ZT8B7P65cWxbjFFKD
xeFPEueiY3W/1YER4IY9H2nasFfafM8b624w3omVlhBOdROfoQOQg/RTLhJb1DhW
AYtDAiGPhFsNqBdpwUtEw0yngkvmLOVJ/j37OBn1s7xjSd30TSN5VV1tyChvot3X
GiOEuz6U26rq/SWNpBWvZzCQUbP9pLs/3/unZUKSi8wgiWmwL4PyUa6iwGStJo1A
H5+ehYnUG19RtmC8/BdyFh7fU9N4lSizN2+KQ70PmZDiXTCpqFjkPM0SfzR7tT67
cGIGeO5RyWNUfeWXXY2DyVSSrC6f/Y4agxp+bm1KAbM4tSP2hOU7RLY2sspHeXzo
qVnn+TahZeM8RfFvEedLKOcTP4f/ooP5yXu0vR6jgPsGGsXKQREZ8blFsR3w1MU1
r1KPAc7nUtEYK+7a9CO6F3bcY9gosBq4PJPM76wv3IvIIgayaeaj26vQcekDE/GB
qwgKY6xseiOHYiVlh+FeqCbC2SkOrE5MpeUBDMbAMBxyEWspi1zY8ylVgidsuWnh
qbInd+88p5D5HerbH8+sjCIg35GsCckvhlsL3BBbhRejzeZU9sUH4zq5ihJKie5L
hSkIlxJUYWodBcAmxxEYgJZOEDAxeZAXYfdi+KiSc+RMocWsb4plplLKHgga+aum
1ANsKq9TmMDvLEUnnKyymvak4IIChcNdkZasx4CNFSqJa7qN4xMj5Uye8mR/6tKE
66WgxNOFIncTDWaQbltYI0S8arHuABxxz7lSbOmcM/qbb+8VR9jI4RV3i74fQk2n
yHn/BIVtiMbZA4guECrdeHez0EBQwKHQ0YAX/VVHjmbQTODqPajjSkOYkPgBYqqG
rFyTFZ81vUZEbEF+kOVXd9wOnJh1eYU7FN+dOm3KTw7lArcEJm7stucMqgpcVnl+
lHPCFmRaegdV9zldjNg0eVM3rNSpROGmhRptg96CfUdssKj+mj/mPnJe3N5W0OrY
nUTvZs8tJA1YlpbW1Vyh7zdQJ7o3cJSsltEf8/+i6p+cl5xWeV/nV1yfRHeqnWCW
W1XoUkcC/kDELtTapj3Cjc53YgLGEcOFirk3wgetVXTxRMXhOQ0sBNQaeEVuIO7U
K22w/CItTFc4tXdQZY7FHMXO+MTsFXu4bmUZLhmfp29pvOLUXZy55U23HOogxzY6
rB+15wrHtTIf82A9OtBEDszNSWrfoP62RRirV1yourI0lfHnjWXYU0Le6QhsswUh
P5RzgWGXx0ddf6HC+ER+33enYUOEu7uW7Me9WPUHIbwENxAYTnZTACV0R8e6jSnx
YovgNQPet0JrIDgTJH2rEv/0HMvVwxz9urBU3STuJf3qq1CnBAUHXQv4MNVlH4gg
MZAhXiUn7DlQaQONi7sQ6at2vEJ5ourCH2sdpQgigDIRZz4ws4EbSTmuHZmGkCn6
kANp0ewBsyKxIqtOMDDbyxRxF5K4yQWgzkvplbGfmPLy73Tc1xnwXaeGOPQtT5aC
WPeE/76rLPDWBiowrYiRir2+1EoAbVqt4kpTXTc++BGwL6so40DtlfIf48GPe3Ur
jYgNCaT4zUodAr+Iap3MifIDyuVDtI2JA8byouiaFIEerwHl0H1m8LCDkIjg1dIh
vnyOfmC8d3OSDQdYnkbc1AbhzHki2Q4j6e2a0Q+NnXOCygEPmcRcjWjFq6hHtX9R
YUNLXCgqTOs+YudUSUtoZz6w15ToAW+i7N+dMwEhneqZipVZgml9/GKyDWyRZU47
4nvaVXOl8JNdNIwkOwiRcCH6r+GI/fMKEVOi702eNrDCJko0en3H3LzR3n0Tkmnz
O44aTghsOgsCKhQoW48pAo0tfXActgVudT5qgHujH8qrFFrvCiUIQLhQ3FIPTQf1
bT1hxeJdaziAOetYH7n5whSEThuQddIxbzWB/UCcuX5BdF0Dl6Gdaw75saTUm4P1
pKG+dASQtYhLE00tUzbqCpmOySXpazhYqoIvelCrfdggZJdaS0+cvEnklIIpY0AE
2dhq9rzq2wu9NKMe9vNGrJHdXU1mQhIxA2MXyPn6eJIP5LcgxqJOX2M1I/xdjpJe
vaM+dZQ66vocqefuaAclPhvaLc4uy8NbuHVYxYTBEGIf55o0z/4i4Ar5/LnozdJo
Fv2drFk0E55rOXyJJmJnT+ZFagPdvPAOdvcg5t5mGjr2zenLqwF5+748f9fAvZVQ
cfQam0eSqfN9bvVca2MviZwJcz2cnguEmAeFY3bwtskDnQPfIEjwOe0jMsQWI8q4
V8CExe5LrXtz1fXBDXhHyQeUIqwlAewGuIfamzknvN5EMwuRLXbaLQ2JxJzflsKV
iohp3yxWeKr9SYqL5w/O0pjdrVJMf17PGKdwLUe4n6rMa5hLJHL2SflGTz8FXLdr
Xvzuf0NPTqzrSPtImvydRWwf1TbrCUj0s74b3d7SESBwLaBJqqN0Pydi2cCwN6WU
qLyroe8ZuvKhvNtYcAxFiihS1uoGblBuBzWZ+TpayA1r8I9zwzMRpT35AZ9gI8Nq
B80Z3xZyE43Fy2YOHPAf39ETjLcKliG6ctVdBYcDzO0myqTDdbDx3BTUg3y8HIru
CbJaM7i4ILXk1yJoculU/ZyohMukJhv2AqJgT5oARAAalOHze29PGgIeA7lzs/x6
4R77JYZ8/wtvJy5KB+6Z5DRzB3p0p6hIu3EXcxtegF4RhllHUu5uGrrqB3CJRGoO
73EIS0kSHxwbPMEIdsObRVJkis1hIsjUH6ERNNwO01npWY2vJnnW31dg5n4bN5+i
6hO2kl8e9fBThiUZG6Pkp45MB1kIZai6WA5RHSthx2eOXKVzNEHAqgknvRMJMf6I
M+tvBiFIuxMCv6hqGOKX1y0cTyKhoaOGBf1Ajkcwuolfog6T9clvQO00VsreUsQ1
h9odyt+f01xPThj5eG0iq5zQIbyD4ztm/qi+mA+uYs3bkZ8EL7zFkrpd7GCBfGXA
6iJ5Cb4DUhwLshRACIQkmjSuKKQovl6zL5ziSmRXpZAWUlziZplZR7sFrDUuQZ6H
gsG7HwkIpiZFalR2zwOxhgJlUCrVBIQtCEj03I6wyxE+2Tckx0AnKTnoEg1qmNgf
9UZ2dQptSTWAlff2oolVtkMrs2BrL9fAegHD/ikP34MC7QBc8iYLjVgj/kGX9qvw
UphwcYPDJDBFnjhufAIuY9700exqPhv2iO1btyqgTp+iVIVpefhbxU5JFdKflK1w
l7svgMpVxX9XNH6whyUDUv2803Sav9oFndUdbwWu+DgKepPVF9oJMwRNZlyKAJ3Q
y8jOrCdRgLfu+VR9CgVtqHer50fDgqsZ53tsC+08J25/jXtEe1/yooYJ59xzCVyk
B8hcWcHrxKnVcdUivEOOclTFx3lLtTjkz4eKwy2kFF7GmdE5729abaWGfmhZVNp8
7mIC8di1pipcRSdnEYk4WBcctrXuc8CgYkktbBoLzco6e7Uu2bFDjtPb2k0NTo5Y
/eymloEOVvNvspeahlcs+SCbhVhziBB7zX0ICD7Td2J2WyGyHpwwt27eetmyMfAi
5ZyutWUs2Ax72MYMkLCUAc3Yx85qAcEZAew0libB1BlOlSPXdEhyn7CYtOwrzAmm
Tp6tnzymsB8RAW4OFbtm6rdsH3qhfQM5GzszQ0NgVr3G2U1yABz5udChR482ZbPc
HMcUl8DKmRSSotG6eRQQ5Ue+PGUSd+AYtYf7rXdc+R1ZV76L2Jwh++LnWsHQ9vZ8
tWHFphCiNEA1TQmyC0p/OJ01sCmpiHAg0qEt/sa9RWrGQDZjr/NugEpbM68yjvpj
XTG2oAKDqYYUDVCG5nCc4h2tz2Nby4GNhAiIsBLFRp1grWUx+hKJbpicEJnyCpzc
/3vzlYYlXi9bU4K0uZXvUf6EzPgsk7ZNB82DfDS5vtVMe0xDhYaJpuVLTw3Jeyg6
ckiOX4r9Kx8oU89/XMIjcRZ6aUNnqtGhbLV2sJNqpiEKxx/UaukJSdbBF4cQ8IQh
PByc0DTNlW9WgnI/OnkHIIaKh0dplLoUAk++0i+yT2GrivnSw21QZTPHkNg49Qmr
llvO/CB3uLNgViiDbf5BExw2Ppz9cqtiEjq53q9R56PzYuLPDZL+bJGfuXBM7Cwp
gzKHGdWnh1CyDp6OjhlqSiZBXNtGKU/5RaGlNdhhekzUJhoFExCuGPcwjgTYlJA5
vmAOZr3uLGeTjQlY5nrlnXsH819xlwM/SXXdO3GZat/qTL59B4oGLsYQEe6bfPR4
nscS6HoDFkaJSL6dpW+SxzynqIKltu939yKYdcRlKNxUg0ClRyF5I4dulGm2ViLg
9gUkxpv6Ft/f2NHpZjgYRMJnK1t9A04KPZXTeOf/73lQ75i8YgIDpdKoxkD5fmTD
vX6c/rDrKjrw5+iL8LXsepPiPSib0y/gFEeEVBEQTOXzlrzCKOplxa/lfN9lOgvg
mTvw0UVp7Qrjhj3HCAvkVsKjd2/PrqPi+IDm+8F1PBd2ws5fDEMmzeX16IkaJYJa
UuAmBKPGsCcJsm67tKAybYppPGAHErMHa+bpR17TvaBx3thYhab0bGm7zg7zgz/3
IMf3fj1V5FYFergxl2+PnceBxq3LMHNSVTs6WkQYzqJSVIWerfBQyioUAEIGs9k0
fezWQoAS6Ycuj/31PSfodeiAlTyAPfqicFPf3UDXlJ77+0Lj9zNrUACIp+QouDYL
VpNRWoJtWCFyMkLfQ3xhTawZXtFutYXs6p/lSm2uuBrUUeViskqoc1OzRo+9zfdY
B3i9331qTSpJMzxNWB6Mk8Iaib016nXkNXSO+XTasKQdNRSYz1+F3X76rZptjfsk
xcJ8VGFgx6jbrypTKb4g2uWN4VSxJgRBfPDXrRXrh9aHRfmLU0Yd3OguNafcAAJh
bAEhw5Kt9b+fLbbD85AnoYZyk2U0GxRxsz6wQj/iWw1bpwpp68nywHZkqgMkQ5mm
yUMYTethzTqNyIpqKnjBzEpesVE6LNlfk0nBLwtgj1VK1CXOqtMJvBDmdU1A1gLK
o9u1bChZmoaxB9UctlPdA4GssS0GB848XiwbeqnntevSIUUhfywdl5hYH9OzZW+8
7/5MIBfR909DzkpVk11h+wOMfcQU/dv/PYdSU1VW/rnDcHro3YgFXQeQWGPVDRbh
oOHDmFft7BiC3WXNEUSkiXyyDEIIL9Gmk2Gz7oMsrar8f+N6cB79/wI/KLgOhoEi
dQccnYHM0pUboKR/n2gIyMbVMR6++d6iGao9YhV/V9Ir6NqdXvrdxgFpzlkxznyp
ih36MyaRNNKSBrDlIjZ3ZBRoi9wo2+ALmrBA7mDG09bqTKzrYjSKQ6sczHOK3Z4x
GyLbrJ7HyK2g8W33xQb/FlykIIK1dW3v9yvZKXOBoZpYbcRVMaa3iCynE9JJp/xZ
DH4gPqOw5/b4JriO27dKP1Kja6VdhL5GwSzZSxhDjJhUcYV+/hukuxNoC76Ql5MA
+//vmhH3ScoyP3c6hxJQX/xRGCJIds/HFvg0rHsniTZr3zbwvi75v6IIy6b2/p0V
KZcMLF8sKr+nnZjuMoj6i8ogbmmqwHzqj1wTlpo6NjP6UgtBxLFQ8HaJnKmTmhWZ
4ElnIitr1jQ+lQrS67cFapig/k6myUVkcDNmc2jr1diGcmQbTYlfncL2KrrjCfRx
cMUHMLMIkdASNf0+yvlBlG0grH5NJBHlUHmRFopAV7mojj5nKgzLT6TYHBlrlSm8
IsTNVlOdvXG/apkTp5MqYrJCfTfQkfDCASKdP29hSKlA3RmRMNAuiHB5rjuAbFai
Bj28dpLtXFC2MA0AtX19zTMOzwuJbxiKs+7y9SWa41db4GF/zL9/O5CLshkLJI+C
lTwL+Z+27ylN/oEkXkJQFpTdpNTZBTQXW90HMkDv/OAVlLerFJEjU5PhIoLdrvfy
Ukjn25O0YKqrBYw2ou3krbDOycxeJkWPsgwolLiAaNB9hmnd6UlRxbyNFHkYo8Z+
cVGuKRPprEwZfVYmQAJLheBBdGgujkyIFlKmA7F/BcvWiPwmzyY2HQRLpM8Sws0W
sUdhKCOV5uYexUSuXB235vDgN1KhNR0BSa8FH3oTzoFC6CyQxjfM7RBMd+adFz/a
S9pz+23PcK/U7HZjtNi1coNB/VTSjbbNDTVlp2n1hXhdFA4BinJ4SsAz4N2giy0b
Ohei3KV4WRY/opOyWQCrBGpcYpJSvx4SLPr82isTBGEsHI91o+xSVMSdKxJ03sVO
XH5/KYNk+vEyvAlvTHwOrrKj9i/cZI/MQCA6C5qJ+H0aNXLLSJdsKYucyFdqnLBf
Cj0F25hJQFwruscRYBXy7PO/Mhtsuy6FXAu2FytbHUcT8Le6LWgzWEsq399+PMWX
My14mZo3UA5xu1izgd+09tYItbLjx44N3oCYYhvdZ8+WkVF8J9bL1f/JyJNCyUrN
lQrQ+Ziq6a32ok4CNF3lC0nAzeCIvRegQi7z1v6LG9FDyduFuc1NDZ1xcMaK1CAL
zb8szspByspnqX8xqwusk9o2WiwMEtXs1ECS0k0r9juvbeByWhKhLUH22SZgJZQ4
/GyWa9sFXg5tTymZFBXvxdQuyDBxxsHkBEf5Nrq7/YslRiIP6W72TsWD2r60myuu
m7RlRgI2hHY/OydERosm7XkRk94WX2hqGLDc0aTGCBbThaudkeH6cGNSyPe8hnua
OdPVyCi6SQqTmGigkHHr7umrAfEROZN3G2S7OXlopSoGl+cJwSJy8sWWDZAG3MWH
muOkkXH66DGOSEvQUEjGC9yZqFrA5/smMhkIYF5xm7U1Zt7NyArBRUponU0mfM09
ALwF0fl2In0UQGeiRUPVpvOmrNnfGjNQBSpn2tHEpaiTMmMLVk4Vi9yUi3c3ygg1
cHWOfmpTu5HoJFDXoFPr1vLay9Adg2VHVokMaT/t429zEOc8X6JfzhPxgV+ON4LX
o6G610uHzSG/lVTvFy0uK77bQeDCdVLMPcHdapKB5eNjMDIklzHj8i1pw3Funmsp
`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
b3X+GwZg2etWQX+7uRGhiLvEgYyVB+4F5CC03wwFLOb6xx2ulp/4KzenlGHSW2Ea
XoJlQoJozgs5OpxwaFUZtgVqyVtisuRYM2h/N0B5GFoZMN40DSgj3+GuJcEvk6Jg
Mq5BWxKy+6IMWYDyVuzNazUWEAxFMn77m/KlvXuYr5wd3T6H90xbWn/1A9jd0V/r
vZESQSxLaunRvhGWTCDB9GMWETE0xDBfZykHWQJmhTs+lRCZCwwfN5C82lKSl3Y2
IdPikrizw8p4VQU6YBx48JLHCZXk4R1jS7vFxT8miOOKqhe/E5mb3ys47oCc2Sqq
VhX/SHcwNRIerH5zrW0K0Q==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 4336 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
IlMYoC/KR6eE3SjuxAzaWgXWwYoz17VShtj+lHytEOeOsGM52dSANbX86IfQI26N
Wr3ONJ/nhCCumHpUDRyyi8ufm9M2Nsy+QpBm40xl6zHued/bd2ceuF5EQB0JNLRW
50ouUW3poUDQ9PWZuysIGwfKmgFH7ccS1EBf37K8whsDnL3qc2JwGsFWKjfvNyY8
7MW7V4rcTX4b0yr8MG1KV3rDhE31erxxoRngFSZVnFdveb3V2kXEnTGGPzZwMprb
AgRnbbz5VvMcDOATWQXbNnL4pNLQbKKkd19I8QveMivUTNpuEASxuzi7hxav2aXN
2t7gEvNlSXBZCCBTCzt6IQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 5728 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
fdu183/jYKgYmVKgU5poG6YlHEZLCfZzcmrBSCRAN9apUwTuaIgHfeHbmop1DUns
bFjlm33S5xHP5xw0+H+yJ92dDMbIrJoLay7IQ9vzZIjETpubONWNCk1Vtr/JdYEn
MGA4N0qtvljezlc9IRScaUmdoaY9pSFiMd2Q7y7f6LZUmctBBej3jxR4oYasplTX
aX6C8yNsZ6WyUuTZMK42DcQcFVonSicjLZYG80ByjezljKSS5SJTcc1JptKbEec0
Zz8RfSuDUnWee8B7Gy5WKqbkWZ7e+WaMBH87StYTJbYRUdRudH7dyLQelOM/Evts
T4w+woT6j5MyWOlMjf5MCQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 2496 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
i0WlLNoA5TdeHVjL7A3SBgCXcQiCU8saTmMcdhpQ0oSTkFYBEjSqwliNWo8wq5/d
paDNL1W+6hpRNtCFaWIYT5fxwxaxAu+6K5A5Mj5pI9S652qJPPhgXb1WIRn29KIB
6iN5gvKYwx6iJma+BAqVuYjWo970B/qTNCmJgN/6xCrYop4O1e/izp6U5MIIcvz7
4C1JzNrZWoWmojXYyU0UzuB3X2eNSVTMILWeR3siK/RYLDkRilESwCQ9iDLQevX/
fCjJoHOtC0hvb7nVkmscsS+njCiq1q/IRIAvl7cnVwD5wFSjx+uNdf0OE9gDrCtL
SlbaGTnGM7oljcHC51cbJg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 54384 )
`pragma protect data_block
advVkVI79ouhbXnum5OrgLQk/EmyXzjJHAV+rS8KN1TQaSwWR96tiVKjuL31sUMo
IvJxtt/OIy7pGmRXFXW8yRTER07OfuB9LWE2f8xZxRvWUNEHwjz7l59VdcVSPcwA
x5gx5lCSA4Mx/QukxxOtMcHOvrPPrLe172Stv1jw6H87wQUtZLfLykA8A2jLtpvc
groObz2hgFbBUm4fiYlZaltcuMotsIBerjOqNZ2nKQb4uqdLRItM2fcARUNnFwA9
oejCZ4SGIFSYgbUKDAXM1JydAP0Llncz0GDdIToZW3saRiVTe7Bs/VJ6BmFHex4M
0NPqzE/aVkl4hjDax0E8PN+2JjoA/grDh/Tz9v4r+evZoHvFHP9PqIYY0qFI6xS6
8QJ9s9eY98Sg2wqCm8mNszupTCoZWjAhWyY58OrgohfKf7A1r78rVTP7/R38fhMy
1xVudd4K87IUrYfnXHYH++BHxl17YPgMO8wm2DOhPOGCYMLGvajk2alonVe6dLWF
49rEFrrPO6kPaZYqOgH28B2jKZQEPN4zzYAAaGbPpdobLE+0zNNARriKq4mWs9ki
gTzqjgjDz1HcF5zAOWWud0KRDl4zn0aDv0D7LYtDTBoaSs/ONAjYvgKJMMNQkX3Y
rCyEMM4dX4/MpLz6vilgeFdV3HTfwCwuQNFOreaDxWTiLdMgrmTv0iR58YIeNcwV
SOK+QW1Qu0oZ8hlXDxXiFWSVOmiPh21n7IRC3vSJlnh8dV63oUjObyTAX1eBKAXN
BvjISL+M0cWkHyleD5LOTQyXPhxMxkm3h125CTV/qD6IgX95wON7ft88PVy6suiJ
QjvPskIHZuS02Om/AeWa3rueDr6AxREK407V2wMj82ADdHKXGXTufMp31Q7EcdiW
KQ/sZk5Ze3rX/H7rK9IbCFROPKNZpCTOY+dZ1eQCx9o2h7PdYbZugLs02f/7ZmM3
NuzO9HjYu05R8rr218XoYekmLEkqvmRDVy8nE85T1H8NEK157f60FF0tqhOIR5Mt
ldTwK85f9GL3V9fJYhVzNHmkRqYDEXcUQSu4n53fShcd/xQZFH9d3RXMGi3xUKw6
pZ8Y6Lh4wI5hu+CBmWKgi8ttaaw1YLuU1+kfeKytcxaAexbxYWd20NDNDdoYhmoA
BpQL0RvecISOsaD7sYqNUiHrvO0v8Q9gxCjV28BpQvq/Ir/SNJLpHSMe/ipwTQB/
Vdw5dxh/KDM+1ENJoIlfwQIKu69UNlLFj4ibGTBzXSs6pg6Qa7uMtgWPZXhWlPkS
HJffqBHIHSXkz/UOkGYtZbbDnhDKWxuKE4tPjQxxAIS0N3s64lrpxJiHCZsHl5bg
Z9j4R803Q1pkYzUULm6SVbycr5PW4ISUn+YvhAsf2ycsJTJCIV9Jo8dBkOWKSy/J
RctxiEmty31IxB8erL98uWAAE02MtV6N6Ej5lT3w25uY4KMUweKOKZza6hx9F9V3
Fmd3B1/P27rFanjuup6uysFp/xEz4C6XMld7ku5DQzVmh/hU7bDc1HGghtDyjFwU
9GHNZFv5TlxTbTdLYhjDztZvWiIT88GHLODTHIwTqV5fcBGe9GjGUT3wYpMeVbye
nFIURVuA6OVugGOyfg5eoxl/UgBTZ1Jap6NsLWf4ex2ccqEO4GkcQHvJUnEcfxnN
FFtMPAeSu56+OENbnOa/n7ZnOyXXOU05GKRvnjHxVhHldi5sqMMYhax0l2WqSN+v
WfYSzIoOvxUlzlSoL73aOCZskG6b41t30f4QuHejs2D6RiRmDLZ/SETDVZVE9j1d
BJnWoLcqdWuR36SVoeqKR9JWLPaIirqnp86knKlWfhQDfYsfHLfzBM9tt/50s7t5
rIm15vDA1LHonVGkGZvaR15QdVuzlxzt1l5PoxLPsjvadaB/3h5ka20EMYkGAIo2
srOConSsERf447PM92TqSUbdv4h+xzx3y49ut/RR1pIdAvWsihkIMYHGDavxSs4T
M99XTVYt06widKO+8TFqS6uDj/mevpavRJQZZMaqeFcmi7GeAW5i80m6DjoHNg1u
cSXU6p283YaVSMGHWQOK1+YrBYi1wKntZm1va889lnjE1WhhR3Sri664AhEPLZU1
OBXnifDxWanJ7+FmeOgdz+GDFkRdcpV723N/CHNw5j0tAQhviStHQJ9OkSrQMt4H
dyetmg2BiQ/d2oNQb0dj8JVag9hftzU9m3ZHTSWLIbsepBADpcyWSMQsMW+sDbBA
iTiXpB9NERUAoV+FhbxwwNS52A1FQPb0/pDYgebXbcZLB1w3nbGfPwUIdOpom+oB
3Ktniqo5oriqcC9lq7r1XkzS/+qH0o2/8E+inQNkARGdwSbl9hAceN7QMJwbK2Pf
HBjtCo2s2sG9El0HVvvE2dBntEnzWO18kI5wUfvMCuxREil5u40Se7MT5EWiwVmy
ILDDqm5fD2vqlC9UqquPJrFNuJev2ivr701UCZaycgcg+W844FIeLrItryeKzdj8
/j9mMfxZtpVqpuAbiR/pTfpKb3BBsLar5pezxiVNW32jD85g+hAgV8coNJdgsUq1
BhCPUXjuZUFpRz109jYI681W2UzCyS8H6QlKA8Vzv+nTzaMhbpX1kPKuT3RXwDnL
ufgJFffleVME0RMwd5dh90BM4i6nnQy1zsHWEjRitY9d4MgRKnrYKd/QbaDQyc4P
uly8F26jzS1tJEbcATX5GXB2M6VPFySJcJCryAcNHu+QlJXEHjK3/qjOcivRK6fq
LSXWmUm6f8pQJKP2UY3rcSv6dmwokkhW9JZR2qQ4P+NoL86hGkjPKJfCnThXKenk
NgG2I7trmcf8WkBFXN8ths4PayPQpK2AIu9co4M30HVxShz2U8a4J2If2i4rfnXa
kaYVAUKSfjNiJi0kDluJsFS2VFVsgT+1cggkT2t0WBo85wc1x5ddm5MAA0SewXGg
idVFAsXre2nag+Vh77YgPxCAMSwVI0Y/EAogYCkoSSQsxRuvqF+INMe1+MSe8Fsd
nXZR5DmTIjTjSd2ifKfKrysUo+CmX5yZ0qEDewGcAlSfPlDFsmwpfwqYcVlkQH+Z
7Kv22UxOjfHsppEn2wnDU6hlDG4Y+s8/8sck1WBMakFA29GnUbe+DQXHRPEmfdXE
4943jBRTmAn8P5nqpmftwmni67ytpgI2f7Ec8BFme5zq/BXF/Yh4vOnkj7Q2C75e
V+xsqJRCfYTtrQsHd1kRXPgqAGfVEcOKSCjxh2eN3A7TF6xuH/VforafsJI1j6Cq
bGnK1g+3N1Muf1RNTCWhKFIKePA779xYEESLWndCVj+b0+vBurYRFDkjbhBTT+Ni
Hf1PTyxKD6d4PWLsHbS4ZAsTeMoncBAam3aSxSNZ9hqYetEYMEUpOjcRYfQZcbsX
gSIaaDaZDEk0AI6qLcocrxeUHPbS7q0SKKDl9egTSwxvZX+54FYXEcu+dfL/W6T3
o8CkLzoSC5MUsLSPdNaetg4JCNpskW/G18W5UPMgoBkCw7Ek3ChBhUZ6z9rk2NcV
//w4Ix/001Ty93CdkRxaq8eBBsxhIfGea+JHZGJuGCM+AS7Wv7nHCTH5gbtM2k+m
4mPRydnGUV7Yxp3MPqOCWxbu5mYQkrmakAIaVtRrv1GmDPy66T3S7tQXXeB6PJGL
poXcB+Mbu0lpdfkJAMnwu2mDJRHa0oSO25tjFazdnoVDfP1t0wS4ZQA+M/SN/JZ/
YpjwpDuHH+PuU/i/af9F1s4BgYBTf/4WT9l5/V0BoWhuwJ5/C6QsC36cyt2SOiRA
9xaTXAzdiH1sqAvAtZEr1HXpCn4mEDKbaen/NIvI5fvO8NjqOJpL5ksFF/GM54Ej
Q5vjuQUvSFDPi1PiceLPju8X41fRJiwtmeZHVF5mTdTUy7RdidocjD5zqc089Zms
cCxXX6mswPRZkdfZFk9BEDQREnb4sG4B2euuty/1TxOMZp+HD1t6hBfSWZUGN8KN
vtS8gmjjSJocg2+vNGmdN9VEeXDIB7vrllFRXCHaP1KS/2b65G8VXSpjLhqv2r18
tEySvsR0rZxkBCt6W9oAt31qEwINrGCPG5nxRTdya9kyFonrAOtrM7GTbKjqfIIt
mJ9D844J90REHKqGdCT0oSLHYhX06qcd3SV76WA6VeYG02QM1bUXnQEwUsX9rOM/
6Np6sDBnecZodtt99V3cVRQrMEiUgV68Ga8PA1dLSNnomF7Lg+rQ0J6jU1Hmr1lf
uAYkGU5ZKk1KwYRh++7ch1KAXOoa24FDriNJq4Etlm+yCbSO2Tuh24JqaOhXiFAU
er6Afx/YQDGTzjDibSw7koeCqlNvAG6/5bKG1aRvDjEmeJa7BBD5v4qb0T/Sfv+p
pQI5oN0cFZIYuVAkdpevhriqwPw+frInH7DOZVuOxVzyuwnnlbROQ1LZ45jI040n
pEex3USHUMCL7NgGi9hOxS40pN3gN6nWFmSPXzSlZfzAGqD80nCHfsuV3vjSSKcN
i0MSkXaOcoHsmBwrsHadOkbt0POZ3fm/h8meOU5jC7DT+0uptMUjnoYJr8QwHayo
eBZcW8iRI9sF6IHUBRiJnP6p1AqwXzoKsn7A16Nloq3ZP9MAWWHXK/Q5ojQ6UKzW
lOUcsjPmFvP+rUsTrcdzYqHdbhH5qX578i0C6K0ZYC7FS1OXjst1Fk3uWEg4DII7
UENwKdrcfSxegMVYEBzrng2R6vWnJiEgZI/CBCwJFCVyrJp+Eb+Mc9lHCdPaAj/u
Wr6WTeFWJfdwxnJ12bWuefd7gzJHQL4gkuIjGqHZpEXiaGA0ERVoeHZy9Qfc9I/u
Q2ivNSmWvNX71KEgSU5JKgPmHztGa3t1OUKfeMxoxDVoJJZfjmESakCP3oHrSTa+
EB9BXZpou5uKEdR9cKOBvL0RUHXsXnvu8dR9ElO5SPs1b+H+wTAhxUQda+i27M4R
v7H5ApOi4xxAVqB9xvEBjxnkjsz/FWkc/Jp5YeDF27om6oIWIF/EMxLrtBEJFi8t
ps+BpbQCyPYRWz3D3lJdnAYLZrjDQnBGlIVEOnw3XvdkswXqwZ0grmFBEQfW+GHb
EVxmYdl+Yb6fqvK+PyhnfRBvGhc85wZgcQ8wfDSOZPNQ4WbdizFZxXt2EDS39MDr
Lm46sWJQJFJqF+EMUyKsmG2pGHT0flMxCQWw9mThXA57oXhXkb/JWVvsde6DWvLZ
XI+lqxE8YaxDj1cZUaLvqDnGmCkTjowhM9aMhDbjCHUgTyvAnZSC/R5pmGdGxSSh
xv77CMPNVadN3nQT84YMnHk0MuG5cEtLLCPIvXiA04nEcWV8Ywp6jfGMUg0BM8RX
jOF0lNGH4XUjNGKS/lljjUbFBm7U0pjxYOyETxPHL+cp929j9eNJVku2yb1Z9RiG
5pTRnYPXnruoZHYqpMakDQ95AoR4W7vf+7nPWab5y1IY0AwlPbSbcypzvVgYNWp+
5+Rs/QtboDRwcC+Xy5ftxKsDoSq0cHbbT5I2NuXbmEs1JxJ//8Tl7cGYxvyacHzF
j6Z2N3k5eiZNOL+hzFzEfM1qrNnMp7oZrfA8fHmmSSinuaRCt8J4MVHO08VBMWAc
LwzLJEsPASnuUAifjAaq+v/Em3wqhxeY+x8yc8NKRtQbYIBXQg7bxGGRdTomMfgt
zYo/i0qvJBjDBmIwuZrgc8BRvfIbuaCrRSQZsuu9BAXq23pLlopbhIA1axgPiwqg
JE+aSH20/bbDfW3AcxseUwPrbgjSVc+wf5lcv9G7fTPGvXK/fRiAJ+UyuM/U4//e
pU7m6p/Jw/98qpT2T5T45itrD6iCEBTykYb6saokPEB9b0IACb3+562SOR+NtPcR
sFjiiwM4rBzf8qctvbKZ37Wa6kKzELWRawH3+02/KmqWRcLzUfOpeDCIs06rOl4P
URbyKtX0WEsm+BOERuNiVYzEuhl94OIMnzzcJhRW5oM5XzCPLrJ3w8aIfQg8iOQG
ELtmt9rwRhZqv8C04xddqDIosv4o8gjoDN0+D1FPqSSAQ8zlWuXBCk722RGFuCbB
lH4rt3rsA3q0h+CPXVrUwRfCTg/sMxVnFEe2HYbmK1eU+ciRv1n9B8ZYvG72PpAx
bFUoGYIcere+9mRMx042apVS11MiS+Z5Cg9Mag8RagrJ3pFaoc7HBs1KMO0T/GN4
lIi6I4j4v2+uzKnKlqSHnqncfqGs56Da94qHTSznJokRjPgNl7xAV62b8u+X8IOd
UgdUpV7uOmYLbtADi9A3hYWGMc0RqmXgf9ykMIPk7q/o1TuySncyrsITFPfpbPSQ
nigpwpzNWmPI/CBzMXgbfcWhpTe2FDRFTnAmDvS3JNzg+604cuQpFIx5Y9qE1VM3
xj7+MXNDrDJtvbYEagADyjhZG1xLp4Jlc35eyX9ZcAJKvo6zUxOAkQJj4FEIT+s9
9qkfAeID8ktwZBKW6KykkfDaXAYi4gticzKAaFsTpAhUjyagZ78tQTyQG7gKnbpw
LlcSyHsGZvMKCXJq+ONWS+OQQaviBt0yg4RmFYtMP0VPnqSKXC9jfXxa62tAYmLc
83r2RdzikUI6K+9dT3QWVOpCWyw9a/R+t0G3GtJWHj1U+3q1Q+XZ2NFRxULz/tUH
oYHYSpT0i2Co1PpbKtKUhkBqNAu7/qTT9Rua45UM7f89syUIZOXjf2jC0Jye7iO1
3LtEi75XOkIm5SmUldJrT4PpFkxf+WraFXx8mAllYNWVhDJa3W9jl7uo7eghwhGj
yys/Cvor/LBzIw8UY7tdGazcIw4WvnntJRZZM/7EyrsKIINnQG1/tM6KVrpVDC58
AT43ZoqVpe1sb9oC4oADNK5orjvgzZ3o3RLRA89PEU/c4nDU0fSns6Hut6tPRWQl
sYqwdVuvBhYJ4d/4NTD0NbAKKGD9cdCgyGhwvowQ1x61NYtR7ddJO3kV5FcS5Avj
KrZ9IvwFYyIoC9EOAi4+zFrYaEC25nHwOVjCndD7/lm6BpNV6W52kMMpqB/OUJLY
pTUiNAPCLdkXMYP9n1yhhu1rwZdm+eYjKhMsss5URyyY6USuQ0vcf2zPM2hJEdY3
Kq9Sq1oY4BuMqT+2nesCKoDRj50/5iNNK+gaSyjljQQNdaxt0JFHpSYizVXXBvGi
mu/SZWHbQOjtjluVGHOQ+Rw/9Cebt3P14dNlu/WqUb3Q3gqHKkxn19iWAzvz/9KO
/0HNXDHksbPcISXWnDV9s6SFCWpkXH2+f++tyIrE60uvp/66fQopepboolYRjJJk
od4smIZ6cpIATXDVDr2QjDczG/KBhjltNz49wNHJuJvbR3CmWbiKuJ1dB2aPJzzR
353HUeZb6wUw+Lxsq+72rHaeprAT679ZiD2mlM7CvjWLI9+evG+W4mwVzcJuvF70
GOK5s9I53AtvtAMjJZYsDwNvx/fY5KV9GAVvwETOERmm1RelFg0uJBe/7NfR667n
oReagq42itw7qvB/y2y6GT78fVsEO5K/E8RbGqPUIK1LtBNHyWfezgz7v2CZXopb
mexFYxo5FsG8p+7IQ6oLMLYeVv/O+RJQMZbTVtqQivGaXRKjL3+VGzAhrGAmJMmV
fuknK5qH5wJk3/vd9beVxV9/018Vlk8mGIxRuRBcfnxOfrc2fG5RHaQiAwqIhj20
4z56+Y2cb3BdA0UBuurj68NmS/gi2Cc/d4ZIUnL+dBZOshnMYQHenAXY3GT5Oi5t
7DS++cENMfgMe2EQ6sWFbgOZjfc3TcUXYrKOx3hAa2yRui6dcIY+HM5i3Thm6ila
AecXViElVW9bXt9UtE0ECJCUqSabHbWkypP9v2XhlJUoPhjY6FX+QdHY43QiivVM
oWiooxK3fwZeD/PaMMkMvsSnieVZ3HWM3kWPSgveI34iet8+5ztEMP141dXn6BwF
O92m00XH+B6iivxiklaDo6pOzv6G1F8PWBgV9lLCo+stF4/LrJS0iFJgiM6rVXMY
KSRT4593ek3llEG432qGK18XsUoa0I2vXxzRdB03xbkv/Cm3IdRZoheSw+a4zzYV
7aXYrsDN8I2qFd4r9UUoGnf/wPDyB9pq2YaNB+UZsy5Tcndqhs0L4WU019ggvY+0
ltEuH5eiWBkenuYB5xgs8fVAqUR0KsFQXJYgYXuK22HUVOeUfvnIos9EFnOBcYyV
Bv3nLZNYGNl1ucQmeZlKzOmNyqR57ZA9fQI/9x+qjH9KvXLjfNkVLmPgNwkKnB9G
4EwpeXSVZHxOJnAfB+2QbxD1u2rgaYo80TqZ2fHJG7Qr41YQF8OOerlZ9aO5+ksG
4LRsTQl1gS3pUuiSGZ+oKmU2jUKz3W++sfEMYGi0/Dk8AYjeAe8tT9KXVzdvoG6s
09mEHkC2doXTcPGRuD1Od2jHBSG8CaOwbZ+A5FaLAWfpbkc3qBSprXk0VXJGAWgN
ZTxnRhNR1QLcCULmvPNlr5JZIQ+/KX2lvbHmUWrwOWneV769GlaNseDLQ/xW8pbQ
FYhMDuWTWF2HdN9qY4IX/MdvFuJpVbtLu3R4S0wszCgHlrY+q4cIb+fQ25z5L5bP
UwKbxqM+s/dpaqkf0cIwapsklWkj3LeGzveZUR5uSTInGIKs+ebgdmc6h/M7KtrN
SqhZ27KQyknG1XEd5oKp+hx0Oyxqoqo7BYH6PLA9AWWt4u63CGPMpm8lxPchhMDg
RQ2VXIR/OSEoy/5XuOL8Y83x7Ho73cqIcBI6jX9xwD2U0GdYRLWvWT0qLRPAPGEV
ZMGrwz194OT+SelQ2Wax4O9jLTr+ho4swtCx/cyNsxm1DHYn+5i1qgBAtME8NgKG
65k1lz2qKuBl3mOmEY5S2O/BIlEUHz1eM3Aayja/DWwxuhOZZ9gnpYLsAe24Yv/v
WHz+Y+TcGWlRktyI0hBoPKHkUnngoyD9BrhsjofwiVOuaNcZvuNiME2v7D3sTkwK
uK0I9kO5lZp+zplhsmsLozJPOWTGYlQ9+3yBNFkFPZFDXspetWoZMZCzD5z5EuPv
vbqy/TcX88ON2I5N2KCEo3CX1ox+KVFmAci8v69INGbmVRB1YIyAYuqbAuL9eNpC
Z2vrcYPMZQldcoLzNFgKJhSjRtSffK9Jr+pOAnfw8MZ31OKK+Of6Ur9StMiChrhA
7OQ8NxJdpaznJa7pqVGEwmF09qXFbIQqhfd98JyD6WGIAI3q2+sDY7DfkfsbEgBo
ZtN7kLeylgyERHNnJ0YrXuFMgdT240p7tZCQZqBfgxgr6SgdLNmD9p1hKQSm+UVU
63psc53CpYSqSWWivEHEun8tgXhpU5OQ3rIfPTO/Nl9nJHllg3oSJ5EsoKhbGM4j
6PZAndFaiPK6QTHhZlROfEHNi5YI0k+poZ+y8InBpz0y4E5sx1mx9FQPqKVwgO1f
7w5n7BD58Gm0cFNX1IVKloQ43k9fW/0+AcxcvVCA88DR+cbB3l3ZCF6KTOGUup1J
uNEDTb6FNllNIY+ttpIOUmrFC5U4Xy0DRoqvaDT0HYVwjGFle/JI4l+RssIlC6mP
ffglnZomMv6a3YIEMwJIOWJ39FDtmnPFvIlpFi+j8I6ZgRAhk9a7aOOZ4DiQuse9
tR+XoMIF0l773vENkRCXUM9Knz9+m/hsBlLd5eXgJrl9VbgGzN2gQ1R6wIAqNv4/
4gnL+kwpTiEQLky6mjHc+TNpof4MZgaariWyNSsMc4wEi2euhhRE4ZnOl9AkD5fC
qJslBPqWSv1YwWLteZLakCSnDIXnVLMqZTQJv+n4Vswy5hAF9hv1izqTPIlEeuOG
QbSGTI+ywgthel3jiNgOQgvLCnSou52nE2treFmoPOQtzfjRctuxgd6Mm/XQFxmC
nGjroSh6LZjzyuca9nKcqvJkn5l206OKso4CgBzk0eBEz15pVaR70+WYmp6wvsge
5R1xL/pMOkx9Mlawi0fxsyQvaiovcFe/jnFfmeQ8qXeubCg/EG+IV7CM2fW/7oMz
9KO3YL45CZcV1UEjRcX9xa1t+K/S0lzOX+35jg6seq4Te243vBPhRQUMNx0mdiL8
JL68wrjhfl3M/sLBo/ogCB0JmsVEipTddINdqxgibEZm1JKckf7qDSvjNo1TJIGn
N68AUwKYwAOqweQUZjx3eaGiMg1eNrkOUvh+LPJ0gMl9U4QXxf7O7b+w5ThrzPPl
23WgBZxaq/l86vQMTiL1avCUTvMxSnWMu8FTBiBZaVK574kfJUVuHZvMTyvJF+yy
xyoYYslmMyL5SSexzSZ7GbphO8FCWCRZZELMY57lP9/aeNWOKd4P64dz7hl+g2Yq
Yko5nF3/BB5MmtQnfFDWE7V0/1MXvHoT9xnoJImMXP753FbkD0YuSjO91i69i5cK
DPQp3MciWnNZAyULDZAAcLTfKWM4e1rUQjuMZHemA3mLW/6Af5QNOm/VUkRBS5nv
m3g1J8799LTxJmaJDDU4F7v1UOSg35tctaa5b3eQUz/t1Vtq5GykRrwmWC4DluMN
Cb6Z19VW3tKhptwYPJ60Q2x+o/H7UMH+12AZ+V8aDmTLdOVTkos4GMuYRpxxmPM/
wv7tbiDXBAc2TlP30u983xyUY1dCN7F9KZ1Us42YyOKKcDtCFPRylQvjWJEMf7UF
4bJDij8pGoc++s24PcW4ikLOL7VxmHbrjoRBD3eJTcUbXkovR1jxdyikZ89HAPnX
Kq6XkYxW5uViWhkwkMrBGJJxD0hefUKpa52SCTDChvA+5NbrNdMd/KC+XO96ve8l
m42ovuxPJaTfJVUwpGTySB6vbcq7xyp0TI3i+xQTAhLnKb6Xj0FDzK9snTLT3lwe
NjL98OYkP1d9Scj0DjlQpdf04NO9nYlpzOaMgY5C5qjQSBwfSOJ99FFiZZqvXocP
b3v+p7Hsnr3pWhyR7+Q14FirHxzfuoZfDmf2WNpASrwEgj+74PyzG425M1aEAe1v
TQSNfv7dgPRXGaIGhu4SKoOvnijWicuMRT0fUa/CmwbUtfg80ay1CIOZCTFNNJQP
XOrcxBm+6bO7Mi+N//I/HXlpXVfrPqDndY4lSEhkqizaaggIE4lQUQNy8Bt3bMtv
sYuOp0j0bGgAt22jF14Nb6H/25Zs9Zznv4o3wRYCgBifm20ofUwKEEqWBjSQ20dB
adV1nxXNi9Ts38sKJJpbH77RrY+ra5X5ewKiluMiMhUo+0z3er7z0AmwdwtCav/P
hQym4+2Xh9XqpIJ3+42bfEHYzqEnO4eOzaieBYhxlp6/nMwv59nku5VTU0Xkx6qv
s+sfx9qX1iM2q8NAcl8P9Yfy6A3dTjSjvsPjvDa5FyxaIFpbqh4n3uu3pRqPSkFP
JPE0+DIFiZ6n1xAJ7+jeGb6aL3srFMEHE5UUm1x9UhC74+7oCfthoZbaWhBP8EKY
JkWmZrGu+jvA+8LKcrua3asUFrXEmKxGkjpuzNjsRH0P5I31E4PWOlWz0eYcnzca
r7QLMUUE8apw3wHnqi7HqoVgOvaP1OsgCvFylNwtngvfLV84sfXtxg7NX2uHMnW4
kNnO6FjPHyyRkvK1zTO3fSqcixOHl1yjF49LBNk7jx9B7Dash43dGculQFf7rbZO
/GOQoxZ4WxBZwSKt+QgZDBCRfY4oSnrX+V3PzRZUA8F3lo9XbPGW/HTUAPIZLngD
M9+Ymz5sfR5rImRqhkPuKaq6n25VadZfe6oezQ3NPBVnhqb1/nLbYniEW6SrVxn2
7crL8gboOMALyd7NoiQHxOVZ9WkXj5c7Vgo5RcIzZ1wJV5Fd4Bl9nUL+dlfnKK37
y2cj/wNKOg+9bnMBFxf0QhfRYM8l8c19QlwgzOLPxUWPnUMyICGqceG91E/KxZFZ
d+vkFLqiFjyMTVMQwd5JJ5GWvwxYNzoP2EFJGwpw0pmOS/lPnf82xJ3yx9hQST/9
xEbAoh+g4H8MK1yVy21fRGIP0Lq54lx0aEzAQl1lo+vSJXt1I9shO7vPnmclDkCG
fN0RzCPzXWhXXawsyc39RUlKNQE9KtNaOWtJGfZ1kPI4dDPJhRkMmqMq5A6Nl0+q
JLC4XyckhMkvM/eEdL9Bn170IJ5OtKe6/V5UcCDJAblA7BsBIBVNcO2wiK4A67Gx
qH49OIJ3Ew621MLMUN+WV/uijmnnmnnc8btKlDac8NQpEnH0bZlXmBoJGmosYyH1
9nR8jyxEvJM3MN/ziIEI7dODW38UO13qQTPbec6u7gAgeSv/zlr7hPjzC+Clwj6r
fPoGIqqTuxX4mMAjgSsD48B16w1H1udEUlLMU3aBBVKM1yjxz2/WBGlXOIN5JQMq
o/bowJP/62S78qu1EwHzE5K4trjhmWUEsXqrth1aL40gO8nsHhNlFDfj9brA3/XP
RvxaQvrUxSC1S3ImnQ+gqmthaXBCovHapMWauXI733QRnfi+6uWn/VpMH0qabcFL
GQQGITkgtMknCtifwFJDR4f6jowWnhxEIeoJIJ9xMciIXRBDWH/RiENpNm0nFhqq
iLU8Cw91Q9dmtwxOcSnsgSRhIBk4mTMRYRUG9kjYG0x4ojjmKJOnfshJxuSP74LE
Druv9XVBmRVLC4m5FLEAOnWd4rJhuTxk3ys/M2TImeip7Wz2lFWsBQ8X0xGcXLF/
BczIpG61paE/wSLo4Kac+9C/Rf1zBMXOzQmLozta+lfoVmcG4P+OTvs4XMwmX4AX
OF2Bx0DPF1oPKZ1ZSABIhYn/MEzj4yGs+nQ8Utk4/VfDtbb4qdLmEfLewbIscfAk
xYO4adYtcRkBOLFn4uhoNkru6mrCzX4+BAsF/zB+tKzrSCs7sFXGDSF0P0e8btHt
48qm6ieM/2K4BnIhIvf0nq0bLe6c2Ny8lu6vNJYW9uwu4WtSGOSkmr0IfJcdXr8+
X4M/xRn1S6fxXc6mjuOqMLQb71cDR6TUExfAi7V6H8abb3IjQNLXm38s/R8MjsDu
vUZ/ct6/eyO+y2+fvlX3y3Gc0xU5Fo7Y+6jF4TZPY59K1C+JVPw45kjmRv99TOKh
WeZ4C7JdMo02tPShlEPKpYIFva+kIg45+fDxvuHdDQWiGYGhKRS60Oos0817O9IP
EURlbPxC3JkLPBGxJ+aHJqFxw9Z3OeEbMax0a+fI1Ucc2bLX9RcWbuWnt173cQg5
0ymyFKY5hZvulDigVKuvffb00gbhbmns2wT0aG+xIg9RW0LqZTtl7MfGgW8xlPiM
N8i0FXOsk7QYsIE5LbGodOsuYI6hBVlLcNd1XtnD5gD3fsIgoQEhPKedBrnyryWN
BPa5187wHHrP5W8STLZr/DL8OpXHPqsxEyKu9dmUH+9ZB5WfPX+zBMox5//uUrWH
rwyXh5Gg2PHLa9S4uWtPR1IL+hVuPuQ2ZmlmrzvI5G4HM/lNGm5r32ZqpRHpLyid
TyY0P3wGPBQon9aHFRmf1/HOVROF0kfyOLAcz3kclxNLTapPC/qMB3o8LfSyjMEI
PRo6NCPLUfcwHkIohCKMSyDm9l0hWELzT5fOl3E40OLb+o8+b9L2YtcodcoDTA4t
QAoLWlJTgwNf1zqIWjAl0vVJbfFJbJY7lDSAVHfLIPcKDgCG2IA1hbOBjRdjnHi+
+wlOKUZ9SEEaFFIM+tz/L4RV8F5wnS6EEp8sQVBYRaIIeKO14IoxGgjNpIstiIu3
E8Ego6p4m21O7dlvHw81PbwXv22csSTLAFoKuGAqwCET0KC0oL8XQ1RFs31eohd5
iVW8Uat9MlFBl1kqrnIwIUV1GHAO3Ugp5L4+ybm3v5AMct69RhbImpODdhNpgZtA
kpPOAx6zGRRwdQRkqkthq2a82Zq5pas4UgJ94ACNwbHxPV+6hbP1ZHF1srryo/Gc
j8cyGUfV3QzRTgKVevtfVNPFRA7e6RqRGmyxAS6o/GCom8heH9Uktqb/dBc9Jhfy
E8TEriL+R+acooOaQIpZFCeXJIx1iIYe1jZoZX4nAuZyTAUbWVev/vZpq6aUVO24
sTgxMhXxKQd+ktDl50Y8oiqcLN8es5+DBYcIEO9wHXefI68qgO+zA2QkzX07rEFW
41JfLa1Lwkcky30UdKOuJKF8c0nNLgnCug6xhz93ElawvNOQEmMF+5DhNT/YVn11
Ac/oXw7y0ls6UobRzpp6+mADi6x3siOA8ir2AaTADqtAUmZHArrAlI+WauL2iPta
8+L1AziXksKe5PswzD55bWfi2xRGxSbkoMCPeZnpVsD+HMP99Y/FYjUacowwC+yI
S645Fi78u9CAYDT9EAjL/QPM97Wi4USvV/EFoeZshkvOelSMX+cSiPnxqkph38UI
YCzDuf2jbEPcMrdx+3dFVwW5GekMJPjmvMUWFsx1U5poHwn82/zx7qjXz5Vd6dEE
LfAdBCyRa83c72vsILSGbuTGMUYZ5KCVS/qIWxHhMKL+jb0r6hkMvIsLc3jIBT/+
n5FldtRy22YXFGQytP9q0fVL3yheirnoopWfvVLOgQpgSAc9WNgubamSmG7L3Pyf
64zTXPdvVAmQDpGhQ+spyZZKvvYat1Z86Z3Y6aRk/xAUeUDr81sx20c5xlZ+82zX
FoHg9laqao6NKsTbSXc8kSR7IYhQXXsuj0BkojSJvrzCDu7my6NffUyBkXewDwGJ
C25hRHiPXR610rnwX8SBUx2pL2b/fOmTjcgzb+xi+W5ysf3xUd7tS9ylbBX8/yMi
PBUhBOxDHBR1EYn5ORSyd1Jik1V7MYv7jioZTbDFPyQaBJui12MTnfjjKacDle7W
G2TpKXzaw5mTllPjrL6Zj8nkdoUJr6OIPKBx0vmzTR4vRx90stA3h2Jvhw0FRLf2
H0hzpe7nE/VdPjzy5ToA1g9v7vX8CgDzqIDhiLw9wN3dvXiHBR688rjLrBVKbrex
ZcGsQTyrNnch0+F9y6BUDcCXCQ42VbbwTo82xIHuPg+a2sAmk+GVOHQJBaK0BXJ0
z2Io0YHXwFyvp5lCg+QLwZps50X4VWl/2qSMXX7Y0UbZJ33yrffk7f2M2EALFGxH
OFahhSIoTWH8rPxWvERP6u/evF0kr5YZkZASpbd3xVkSZNPQZroO/AvPCEzg6Hhd
ZYDFTTbgnOGOCJt9L6Ys9ATWKJNE+ELUIbjflgHxLgFCzui/XCIfwWvzemm3knC/
W9OCdrjCJmmgHrk3xve2VUyxSlmj4whi23n+EoQsdogmC0EBuRU3Itvacq/GR3Xa
5xnhvYzW8dtK8VBU3RIHjz/itI6j3c0phOtJO5ZNlX2QIsPI2kroXd0sagA8oepr
L6Q0H8C5wtrf7echmAD4bMWSD+nGPAglK905B0/Uy3nYsNdp4bOpozj2pqwPWExz
jCY8YktXmfaFRv7tfI+tltLHtH++PVXXdYR6eP9M3Jh9ZvPd7V85DDy5r3/uO7pY
r1VRCzwbOHk00LY3qqLB82CcOFSOJw4au10uG3GKupihktb1Yvefp7hmQfUAd1sQ
gi3RUwOc2Ej3+20XPOPvfOPk0us2MDfAiLUYRtsxX7RGn6oUjpooTDtnTXfCo3xq
4VuiD4zGWVIuGUeMW1RdIEvNmXzgnzj4JQz9jiFlPJupthedag79XmmyWnrWj8oA
8AGSoSnyJBpUWXKimyG/z7N8iJq0+C/oA9Dx7j7GUXhZPFumO6hRgUVHim9Lvvqm
OdYSOJzMhxE9dsHtcgGKF7ngcG7DK9UMjAtQd0puuxUsy8YAUMqIwKcQ35xj+7BQ
JqBPrssH2q7MikFF/wQM8Qq5VUu9Ox70KIR5sJtqvozj49jEJHZOk9uDkGu52OAK
6CM7+fnkBFNk7MbInxWo3tRrBHRFbqAv2vv+wu3wHroF+v6m1Y4hdwWyseaVR8Tt
/UgGQiKfD3D+2fFo1tEkx4/WwzWAit/OoRbhaDrNOovF83ZA8i3KQ1Tn6thqdyRS
+ZBqJ3o4j+NVWompMtYAHHQ08Qh1U7FnGuKPBGaqQjIQrx5lRuvSHsEFdo8fj19P
9NEZXIqXhlqnB7GTE7F416JNjeTtTKjRbKBrmMYoMWu46arkIvx/pPPs9VgY1D7a
aCG0TCthEQtLxr6iTMRpXkX8kDHo1PbOkUgC1xBhFxBNn8n3fkncKEFAKCvIDLYy
yqzxOMO2f5PqJezOqeGYAtEYAisKN3NJBX+xg7r87XE6W4lYLInoZUnybvPl/vjK
CA0zytv500n3vhqi7BECwxndtLXETgiHLdkL0dc7NMNEMKJEikXCJmCyYyQFteaC
7DxQflFnImqm9me3PEUxGQ2ZkSOErasRO6U0EbpjUSXNxYqwOe4zhLC1cH8E68gc
BAn8wkMkhtS0l4PZ+v5juL6OjAVRhOoDmlyoPBeveZrBrdwsvDe8+xcD3QzPDbh1
/oxvjDnQKHojVYiDkApo0OFjoVpW+y3vxAxmtUMa+Rkv4lZh5x880WbxU4L8AyQC
pYoLwkGvhDukjIMKz0LdznPDsoJLIsjENzcQN8Fy/iQVdHQ1Ol278nOt5BcQZ0Jz
WwMOyVrLvoL9JXChF/Xjc+fng22IbQqyfmCgMwGKQvG50mrS9DNANM3AMEkYPdAv
LPHBVwgYEZlvrQYaUXTO/1XzTPtnuqoHr9DWhasASHBphmiTPS1h/gJJg8BqguDo
SFai5XOr1WI4lFLUrfFpquw5oeXfeqYPd/TyRF9e5DCobakCX5+tgyd40BBcBJ2W
9V4skdaZ9A8DPHRAkC3M0d7P+ei7RX8J2EbatjFdD6lC7OCjXPQ7aP2X56LaYwee
BLmUYZE0HKoF/aD3vxk+mMC4q/vbB6KLAnG1SXWtCdV6VcCbmDDPfDOyxh2Zymww
84C3+qR8HknaouA126tO2NTHS3OvnB5Ydr9JQ7jDdpD58LaI0gcJfUEGtXqMw7lr
AQA5vzZCy+VoCWvRwzD+swUCGUeArusHM29JbxswXyXHHT7oyUub0XWX544Qz7Tf
Eimc9Q5CbU4zRkpgt9qHtP9lJVaVBuWQrgijmThRZ4jkQwBRK0EkK2+GLMSV7z1d
ns86WnXSiF8cGYpQMNg9/+Ou+rabatD7qV/GopXyiptYMf94vsYAC6JR1yQHfiql
0qZp/i5Hr6NUTZG3dtYCQ0rz2qS/cHFy6Jsitdf690rDS+UiFaK3+cRA8TULbPFX
L5InRjEqFOU2FsRFk1YPzyzJcU2smDCC9kYASUNl75gKrB+tvyJnfx8UHsWMZ+cO
GMZcEKUVN17s8t8cLLlv/HEW0vzlBxoEbZV3sIUmMp92zfh2wuK0y8Ph9k446LIT
EjAq2bo+vRhl1tffK32K8HQCQ86VPjy+rgfbHEsvw2/2BNJrUdVd8rbA9MeNBCIn
AXu4sGhiUQOIH5YBHlSKlsdoqGps3R1Bdd0yOXfG1L1j6ep9xp5CBEYgjUmvJiVL
sGXAPeEbeGf3tA6Urn+wUdHCMiwPz0/+HdBfGxleyxuAo1W+rGLOjeO7bwfPVPAt
lQJ5uT4V1EGEtAJ1pEjqaoFCu+gjJJ+m1zHEaBmCUA/Hwo0J1ocHAXL2f3qJH4U4
oHlRc/jemcIYlrTp7MHKnFekQl/iDZ5Vls/Dv3TkonYFiTtbq1mUQCELFPXjkQzV
Cht/Vd2coiLlJ4bCra+XWsiXNs+yG/mrWy/yIzcBB65FKgY4jzbpgl4ejTXOLwZi
4AUwrVi6NVYkdzOKs5kd91aAM+weiMyaQqjJlbgjVI2umpCVhCqv61y521iRpoQR
bQbQ24VdXGKv7P6Z9pYQ59ChBS7tXk80yOihque7hvOZiiOw9s8yhdquiKFHmZXD
tX6UUIM1a501VPxYGBY82gAbOoG7pc8i/DubuxIXAkA2OdbKtpBjtuYLgy/B/45z
BCgcEgrcEoMB1obEjcLm/lHvb6QewOczG4e4sV7D8iv3Uw6fE4ElKYgxZVfZsI/g
lW979c3LbQrryk1JU/hnQd6sXVLUlnDVLBSZfwQLpmxIClPdCtQej2K+f2Nj7FNg
UEMwBe1KolA2ivRsMi/0kd0/1krLMNgX6GaJxUsY8l6QInM9cUuRZtmdPSNHZSEu
6gv8wf/Qc3s9MaSemjx2sJiuXE6ME7qXoEWOUrb/z7P7YEMKYakItS09ntA2rpqW
r2mZKlqKK9QdV2aMdY3oEmIIoU6HvBwKIyPQ3MT6CLxr220IuHfDVNEZrVhawv9j
ACbtcX72TRgrf3IaTgw+pF9T9LZzrWwNbBkoFDL8TXm6NMqgn7XBrv+sj91Nd1as
OXHzAD85GKCdX6IGF9iRHJgtoglpAhvMDah8V4VoXab11Z+5m0a7MvqYHkjijQZc
xBkMuZu5YNAyXU0Q7akhv2c/DpA2Seymps2itaHGwu3uu+R8hUGACn2kiWwwRp27
7DcZ53uLDYshxR9pf1QvWc0QEhITBck7Xwvz6bwXdA5rRd2w2szbon5R74PqiUBf
hBK5zDJfesU7cM6bU903nnStfW3LLFQi/5V2lILT9um434r+tktGhCPKnNla7c0h
eO5abDKjyVDsBOoq3SXt3wgpMMG7UldTwNbypVOSllFQxDWJ7hxklgw1pjfWZDCY
nTz6kMNNxJgHrhOcL0XinW3yC6qgJmeC4t8AeZkPuwxljJ5lF005OxDbW6OVnm5f
M5YkSnSG5Fk/OoEf3ZQTKI5nlbA2/MsPDkYN3Tl/bQgOCUnhl+H94m3PjNvuIz7Q
zFMFGA9b3Noj3S7eMlTD2LRwtmwQrA5N6OvjEeYQejuF0HVqdi4QATdBDYqWNAkG
4SJfJE+a85V3Y1dCY58ivg81ITujh0GbbB2IqEjDFWP0A69hdj7TavmBFGoDoqvg
P2pczrxTCN6WZLN0gXacAUDNvz8eUF4t6lnq4QfzuImGtaR6HXH+7wj9NfId5Nvz
fBRniW6DXHF52ow1W6eD3QL1XRNfF/bPut/u+Qt2Ezm5x6w2Z0f9othW/GWpCcq5
mULmt72nb2azwck7In7HWUPGNqJf25OCBQKm2jBP0MF9kVGqbAjlJA5rXCelYcgY
g1Jhdgisvh1BU+nK53Q9iy3wxTJ5YIqdkBjPlUQb67UVEnedAX+LjrnutTKGrEX2
lvZgFyLL5vqZkDaHHjvMenzJTnuqDx4aH77Q1s/fQ4VBe7ptiyubMX/hdXW1qdj4
lcmXE7gSJfsY/TceyW0+t75rDoc2rmbNI9JUgX7qv6STTYFuYfpO+IDXfofaLhGM
BvPiM62X9ChrwgqCbLMsHF599UmdFOd6WarFWkyfJ8+lA2PIrJSdtxm0WRTwEqOX
kkA+giQTQBsAHVqtuxImmLeI035u9YK3T0GmYXlV82zU6sEAgMtRO1XR4J8+Du3n
lVSkTmTfwP8GRY0uELYkzB7f80drAskleOCriBae5+VfEDMR4UgXXqQjP/HVxO1t
Sle5KHSOPD73foJKHuwaL3RwEYB5NYxEYs/aq4Ofe8c9hLpyq5pyI+7TKF6/Kj4W
XRhnz5JnOQe6Lfmy5ZtS3nuMii2wMojuY2hn/9PwxBJmRKIQcMxP3atzQBTkGK23
ph9Y5GR2MNy7Yj0GvR3q4FTHt/59mXY4DyPW8nXVKIWQ9sS66Dc161qBiQbLSxge
gwdL54K21fCz1FADukSFdVvfX+RuwPCJUo8YQt/ubVd/Bw3/+rXASFbgKOVIQ9IH
2lsta/o27KdVo6Y+BtNerC53+1twmud19zCeBR12hUG61zX4CF8vnznV4Zt9LYJL
dBVkk8PGkZWy3p+zqqNV+HBuM/G71h5jgfKYbNud6AHJ2kSWphMYSw+axziEBsEf
BsMNET3kAxTmHLV2fcjaLhdBZQP6sWP1dGjT8iF1ngoJQAPaAmqSyh6grnV+T2h5
HVNO5HhuuvCVFvJ+M/ubFkUfyUhvx9cPLpTTErgCAsNYah3Wp5pxfq+EQ8DBe+84
3geYcxwcAb7Ro1UUsJ0xKelX2H2sJBzJU8fWW8IbPiiJvR2HT2nMme6v53iRfgSn
giGPhI9as7YnyJqxHkwPA/GdrXrd+LlvCQ+VjIdxIzIMaKGbf4Q9+DpSnPcPpQ7m
NPXf7ZoGuWdnJCIzXTYJonYd2+Nhaww3a5ke9zvigofqG0uvFFVCt6VIocaFuVSC
Wzn2Eo6kUyRiOJFiJ5hPxtu5BlPiFd2n/KzMnUAprp6k4VqQseNU6v0xNRWaaueM
npiJHB0nCLMdEDzafTdyEKKFXAxWQeFLzkCAIBn5ofwNsLKGZKnSNcFrMgi4an0x
dVT9kxZCxpBpaLjum20DXBitqPkCiGP3zmBIl0Eos95hvF5nX6318oba6QSXAV+B
eHM1R2OrYhvbEzeK9v8jetiMJiiGwv8jna8lq8kFWQj5+xOtkTc1VGb+z94gclYE
UKx93VExjg6msiMeDaOG9ZpSzhlg7CXu2CCM3yny5qk43ZM1c63sUOaMnNkKNfWI
hgyw7+Z7xWuxRqKBvLtmxQLb8CGF4r6zi7q34aiwK+uQRhkgOtPsJjD+JwpopZFK
s9rkZq/Jo1wlKfaX2OHlOICqfJx7N/zFxl6s3sJ5FEtNfF4KGcQJdIhS94+5pzoL
Z4y1DfQ5UMLgMiBill9GQCZqOrvELgGw2qKKnG9AKYyTWajHxyWDnpavuhDQB+f2
tkANnAI0BhF4MO+r+G9QzVfqGuGj2TTH+FmFxYtBU4iTpOF+bpJGv5AEsTemwmhU
Cq5CgP1L7NDT3R6qHEije2WVcDtNoHptC2NaPiJdBlsChZWa4YHTnpX/6f3EroG+
ZnGq/bqZ0ufEmWAul5TUa1olKrbB7N7JrlWdrETw57lV4YNjveL/16cX8z1NsTd3
Liztx0xS7I7gyiw9k8ViXkj6LfKFL6OaDRek1ZdqkDtlKP0eBk7+6lDD2l2vezh7
DAQv5oWN6I0T1Pd3iMbJMJOmfPTrGShvMVfeQux8BLlD8ojRslO9Uqdc1641g6Ar
ZbzCJ/jFou40S/U96Nkp9TYx8RNzZgbv5Zh/PH1YxS5HZ6j/wrTe/vapTOjF9Yz4
NIj4rPjYR2+rNDJDH+FGwIP2aKbqjmsDFVmALyz67vVSrai7xHTMxMK3rbwba5En
a0CI7T6xg7aKAshX3mVD0FSz6AxD3UAWm4Vj+2aru9h6k9WF75t0WLc28yVLgVYp
pPNbvMwTY5GagoA53ULT41OHYqlucL6hkR04YeWTJswbgEOX15MpepHGIsIZViLd
VrpMWrSTiOSunpX9Vx+96aO2ngFCMHrO6rcXHOe6yYUe4TS5mG2w2c2oWeBJz0nV
8sUcY4UCoAvx3lo36TL7YtYnBsVQwZdl3bZRJTXxMJi5ntC4FYrlcG96iGN0zkYl
xmiNO+6zZo1kHHnq/D/PIPQnF1MGRNCOzOnxEy3nr+Elt8kL/EX0rXzw9HcHApw/
KdkDF4blw4y+oUkiMOZvl8N88Xn3mACMZK0DeSbK4eTmLauph8x1Xzb3BIai/EfO
Dx312BnNJez+URtu1ExmKJMY9xRuDg8pDrxwE7QPRV4f7FNXoX3wMoFSRvE7uA+B
Wfy08YeccjwL7xXg61dQ7QX74+PrWlxc5uNPCG+v9wcz83JwwpnBMbK8odJBUP4F
G+7589hvGog8Bt9CCrsYoSZ46Jy10ot1CHPXEUL6BoZQR/O8gTbE4IfegaMM9lt8
0DmS1tEufKcV/8Uz2J6+VlmNdrSd4wjubq7TSS94N+xH9iT9vQwpR8Xh1sRBMU/a
EGU+uEbRe/A8SXZj8EfUjCOuRLU6dkPcOZQb7T7tr6W24vny7gybEMqEPE0Qrn5c
S1ajpbskTmld6KmOmCpzCJZg9TICWtgi1N5W6sAp5HM6VyaQ9vKj4ZwbMdD5+qNv
N5QGMhPCdEEebPbFar3K/Hc5ec+wsffNYvVq7OX1h4TmC+MFu/O/ldtZP7wbq5IH
MwsgU1To06rpo157lbKQivhTrSf1JedcbTUAYql0XJs4iJeqEwbfjtyncjd5MHzb
R4dmXqjXior9APTOiHyDZk4as2Euwd9dsCXFQJVqJNCFXS44dYFIf3M9VB+CajHe
DC1lWlLnBBdau/aR8Zu5USSbfIuoOCS6gcEH6fL80EMeUDZm16D4CZUX0vqs6+FJ
mIoI0D5tDNfYT766JK2WdipHnscfIYBfPcm8kl0+0eyzopMya3ughcz9TsuDGUt/
QeieiCCeQPyDEo32t6Q7ihB2C5u7AL4vA4bDKP9VbTJWmAtyx6Bwj8t4o1fjPEDa
//ShvQVeokRRUXEbFSYAJtIc+d6UV4zNktjBWFcCj27isnRRadztEQdS4EXZe/H2
PDQQtVxoMw69y9S7rRZ8te81F6hwzoZW7WbDsKxuQk/wIF+BzxCRGvxWmW/Q2u53
zhK2dwHU496FwgY314WxRdZIu4plWNdPvnxu1wcVEZmLLhljdFG24WNhWfk0jnpt
2mu4hyRjyfCLQ4X3A18KBS0qz12Q4FWUHUP7e1KOVGnqErq9hVFosIU0jlJ8pgnn
XeLmhdb0bA3X3ym+PDWNqnhxbk2RTqxCU0Qx64cUoJjAKf2t7wFWaQhw85powkb2
b16eQioig+f4AXKsKTNxYuELzA5mKSIT2Gw7n9zM+O1cdyUoSWBZruGDY88ZP58u
CpcYKlM0mXwDUi4DK7ol/HIvJ5WLrl3WJ8bV2oS9QFgu/DBsT6m+ZIyTnnxSppXp
2QhlQ4oKxY4I8kq1I0X8FzNyW/eNsJy1+mGYzEo19t6sFp74ACMoBdiAq7ThTXwT
OlWeIAloiEpSbNuSVjWFLnTeS71G0ZAwMZ7+4aql7Wch5srXbOT2rJlzuVxJ9BHf
qIEOzWUHmQkaFbxeSZP/R6GAY7Xqtwuulqy0NBlkIGBk3qseCaKGuPm2Lhs7nPUy
speonNWN2oY/VD/M4sKrDl2TDJQhXjcbndF3la/4aHep7T8YYl9px87uMvITZWQt
1fVHRsZQdJrKO1F+trObialr+tW1cZ2drokMlUG8sXyfaeNbC5/JGgdYts9ZVqQ3
5wKvzt35Q5S9FJqsZTRBfwK70zDSBUDFYzEHg4CjJxYV9kf26Bhr8t1vnKh2ek+a
x1YxCDYoJ0IVcIefR90zIDVLXXL0ptEkz6Mm7hZzJBiObdMIksBVP8mUseZAbE/c
mACkzkFYGcOtw0r8Pt4Lpe0yyLyOfQNdu+vgOpuI3kCoUMx0PzhWxrKNKhtjX52H
TqB8xfClmb5+Z/Nj9e/JYjvfQPRPl+OKmGRZTJ+SfNYHY4bNgkFDV1xwgiw/hund
Nv6GwlfmMIpq9ExUXLT2sy41F+10q+rxLrIY2b7qeI+z7XMmIHaEyz6jJbGZ0+M4
KGcoL3ZoLxSOMinPFnYTOKITWVR4OE+3rTIXnrEISzGk45FcplVamlqLlc5v4trT
7Ii11IQTuxuUF0TYGCnlTxk0oraR0ExM6UpiP97R3Nec5VZXbkYPgqLbBLtqwZe3
Y3mxRhsxlSPlLyD6E4767kZHUx2FlFmB2pZqZvG9PqZdXho/oHicWSfoduE6ursu
6Yv0wwK+9d2c5153lpHwi1fiEysm0lW6kraqvxk95qcc0zO9KiRNXctcvBlImqvb
XfDF0a0qIz5cYcEu0kOOLZKehIVi44jB/rHSO6coQCLBIXkrx72G8Qpjk+EJqqiq
nApe/5OMwO49AnexEkIh3U/xpblV+F1wQhoevBm9KfM4aX55MvMgpMs8guTkEnGb
thMML3nP2njG2BmRojyYSkiUTj+uffGUYr097xP1YSzyFdXP1yfZXtLvL3ob7T91
rJW3FUh9impFyQ4uCoqddRABrUQrr+0Gy9mWQWeTxXTcuJo18zwUyPwPTwiHE/L+
OvQTjvTb3TBcPGUk7fis1OCwU1/T8HRAQkGsvAco9scxrm1h/YXEicdonv1Zdrp5
/P9dm7LSEoccBqbUnDEj0lEoX1tha8gRg9PBHCxIjT2ssmmsBkVf5m4gy4ZzVqhU
irls53xxQCuywocJznQ20N1oTbRDJiB+QwpGANPBDSejtdLZ5EzjRt55/M7YhRT7
eRcPmRNo+QAwEmydxBc3UjkLFTVSekliR3+vi6hkjzqs7sJ+W+WJCDdMcXAgnd+Y
JK30ltCP+5xPuWhyD/oXsxMD6OOpfG5HTQEEJT8yT55SGJkbQpO342FTI97FiMiU
nMv9er9e3GhsKUhe20Mt+BhqEJtrKZ9/QFIy1gNrK/ZF5bO2u3uvomrnXjMpvUrf
H2e2Vd/kPdwMpCXLwB3Urq5dZogQ+LhRv9MqNYHcB620R5pJUN8zfq8+4NJy1Fmf
8PQo+UJye8P28ImVGXaq98hCyCuvIP6Defr1Pn8HmBSK1kKvVeKciAEXs5igVoBP
rODYARzZtdmoCOyt6gpRfOecGGQDrFDVnDl9xPnrPF9vvhR8WJEeWgxYzmSceZ34
xJXIlPoFek9f1/dSBOddJuYTq5n8g0I49uFWXHGiko5+fsZv6uNb6PLISztv+usG
SuQYn+6kdDlNeoZWPFywXWQJDNUVJjk0G0bBX6qiyajdtPEMmZMkUF7SJ1OcmfAF
rjOeps7TYFwEnoHhEpFJZ9yva3lT+Ad7zf6NHSYUTKO0fLX9/T2mXL0YDji/vUe2
RiqWoqq2KkSy/8uazQ26M7qI1NE6Wm1mZunALVBEzesV0Hn9K2zs2XpMr6b2VWLK
HkisntrWAm9mpjCPNhSUK6vlHaHTKyanp1s4wXsbQ4ANwtGyoAQyoOBAZ/GDLbG0
H3cnb7ej80xXekF05SGn9B7EBTM6M5twoPG4fyiodfFnJq8MrIo0zAS6bUJyd2l2
Z5hHP2gXMqP49lQ22dwe0TALeemHRWnuXhSSCZKaYYKksBe8k/zsMiHNByFGdUX0
MVzhQ8YYLN5uJFAIoY79Q9RbB/nz1nmXaAIQtx+u8LfUBSXNPUEFD8AXbNHNthio
IzPamJ4VO41+n3WyicqK+j53VgFuRqmyQzViPWAOR4yd0wCGmu8U1NEYe+n8iJAG
pTwT0fRi5l4bqKGGA9NhIom8O4k9/a6ov1E+oKNCsG7iYtYu9wa/wsRKWlsTKBkN
wWeZmXCHoZIRKsDb0MFdCO2ufSBZEMZzfgCgOedpi0Rt9A+wfjuAYQBoNxBqtlrJ
c0VjZvCls6Ty/1lYEq1XUxCtgD7CeJMDQC+z/+0qMMbP5mkhe+WFIk33mhbOmcqP
qo+r5KeJecbjUNPNlNtzbnLIglmY8zp1S+7YbhdC9P6X84cQ+0Sw/1FIcwXu0yl8
jTiKUMOzw8KFxQBQ45JT2rM1l8Majf6odNplgj2o+VSKe4FaBrUKMz2zpBQbR4R4
Gdu2IXFXTDp3Aug5maPDTGKE1FEcEboP8T4cU108R62J3exMe8VeOJ2jVu1hUCFz
1qrGg3O6ba1ZbfuKnJ0kOYPfkYkgDlLY2Skh+43Gmrz6IuIKIPER/g1AKGnB3vUe
QFPAC3FUyLKPeCsl896JCfmS08/CsNR9e+H117Xt1cL9Gcmlbqa1q313MCT9oQc9
ZKRLABy9xYZhyHpDNCkXWTGCX1+d7SeUdtIx7Ux/mvP9mrHQykdRP0OZMm4VbbqN
10uyLY4bZoPX0avIf6/veaaIpxWi4ZCXF5GPW9jI+4ZAW5C6VtUs4m/3wuygPPLH
MnVsjinR/zmJ0nFvDSfM8iMSBJhPOiZ3PTLhTFZUQDpilouO9UCOWpz5bxtyoYqQ
hKiUoeOVHnwQlo1jGrZI/AaHY2ogJTJZppqVWJAlrmLviimxRzwHj2RMG4MQ0p8p
lZLUPo9/dtRcMY/aOACq+z2PV+OtVJS4HrB1liYUO/Y9Klr9c7Hde2T5SwcvN8JC
hTcHsNBzFQBcrrHbbjaOQaR1wjLewDyJWEEFotKUe+bCc/m4doXJ6AQsKok4+wCr
lSIWxywi9xjmcDfpULFL6X0YkfFI+Ad/hY/9Uh8DreQA/3/LVmc4P2Inb8VTptM8
VcrlBNywH2qPNm6KEKx/io0jPK1eM0++Pei/rspC7Oe+Rgeek2HV2eCbKQquhEaK
uGE4xIj6pzrZQlFmbeHiea0h9sS9nQj2Oa3jHxLFL1pOOE5XaevTg+/QADrtgrT5
K9ziK8IVeNXyFr62Kf1M7B3WiHDJj8AzTSJNabecSv6ziS64kfbHi2n0Z1/TDNE0
ZlBW3la55F6iW/10ssMbLDrqoqq1XZBFJlt8THF+B8paTTNhG78NdISE7ZW6SHBe
+fFu70g/lqanPL5CMqoD5WeiYwydKe/M1FuBkHxApdUkvb1MAO/Hl+zp42Q7zPK4
oyi1//mXjMBvHNpPNeUA+6BTikgzJj6g8AB89Vxbcm7OFLeEDcPSbO0IVSQIvmSJ
t4TLBXCBSjFgdTKCWY7U9tD2YU4YAg+SmZVQmhjcaUUJYHYDZ0IuAHNtRLuntyQc
wcuOK2NFw8+cHhhUpI7Kj3tNlGflWYiDkgawgrp41wg+8Q3a9Tt3BpKZIDUA7kFo
kFePih3O97ekq48Tr3I2FnRtuJWWHvrWQqE760s/ARCIF3ENAmPvFdLh0zCYZ2E1
M/alEVt9qktATN8Gx29L0s7o87J/IWyhhyjErmcnQZfllxQHyC38Xox9Ork+NO/u
CSd3+1M75DtGUuaFXb5eAU0o0swegCzkJO2J21nuIaT2gOtX24u9M/SD407+oigB
bbi/q70YXmRU1DHZRy27J34o7AdEUHIBtS8IEHMm3wO8hmmHLNMZAH7swflO5XGP
EHIjnkB3TKcivUzGBC2L+9Xo2rx7uvDyyj9yPv4cvwbrlAgyLq1W5SqmB14sHXJJ
BY7XqoKoWd2p+ZuSmsgBPyyWuPYaP+ZZuJ42rGGIvlUVQfWFSHed4N1Awr7Qx0gz
YreTYBa24FAXZEGdZzLIRJKZo+a93bQlOG5OTb5PfB1VgCXVwBwLRTCzA8pzHjRe
+MgCzhPDe+zQ9l8CDtQD1v6CLmXbD5Z7bsJtkZ5l7cUC8Mh8oo/jR/OH8FTaV7o0
sdJV62OoDgOlswpuR38P3zo85vSsnpn/R9zAwBXqIxbaa8hpVW7ye9pbIWlEUlCm
fW4PpU9FDRE2IOH4stKYsuDDk6SBdT2453RxFkzCt2rGRfwPi+7kJGgN/ovbjOWG
BYULH57KOLs5MwVwDcp1CkRvKIvSHS7BvQodY/wP6wJ4th/FcRxAffvkdpwbv6F4
+UpPWkct6BuO6vlr5BJRY0Tyll802Um8y3KiDvHW7L1uFgF47bmX9U+JTva5pmLt
tp4TaoUj+fWwrUlIWtz6xCnjVOE9TA4DM4A6zuIQSDsJ7cC5XjzC2H+kxjbmOkyz
B+4mqjY91x/VSdGaZCERl9fy9hmtdCzG4RSfmnl02ge0jIzgjNSpsWBDPEDIZRBp
bcdZ6yawfd7D7o5d/FU/yRgTjqIA9oOSN8h4JViUMfkQQVn8ggnHG7OJt+LysILf
sgTzPz564iOdoPWNeneIT55X+irjKzjjP8cjvZ3ctedPatNJ19Pc9kTPwrQSzbvY
9oZqDNs6f241BsMHUQviQZ7kkPF7Mq9yZBRbfx833wxonrhMmxXoX3DIRW7nBI+A
2TzTiCUIpqF4MReEg/DK2scPdqTMXGGEJVSD8tL4oUZAWAIWxYP6bK4ubT6TwOKi
bYmd+eezNTPdBVDIlA7avfsNXIbhZSkzqutbWpp7ALW/t+TdN+oMcLKM7X+Gz5yf
ADKpM7IpqvW5bpDIwFUwbp9zyY5ZJRKaXSByKDvomoF9sTt8bt5fYR8cYjdhAnpv
4J10ZvGBMsW2qyWFqu8z2Gs5oVtkjwRcfJv0wxbSQ+oJ68uRaqx3G3Hu9vbpa2vD
t9XZhgMccSyRMaaNB6aWk4Y+kYNJD3P2BZFIELpQ5b+Rc8UvK1Siv3Dg74ZjRCaf
49MksDvRe+uJxs52rqb4DcFaC21U4f6/e62vLwNXnuYK96rgH+5SA63pYCEQyZbp
LpK8dM3QRF3ceqng7xDuCBXdmTuBteBRvuIBwo3ZEuXspTjaWPjsfqyC4Aj+iomD
pDDAyq3EhewYa2avmbEOshiSRYIx03xDYSvoPSxE9aXBzZprOJdlS23bHtE93rSo
HL6IO6xCRsLRFBL4H733jsFA8V+fLr7eMx7LjkQClhAE8x6/+5ZOCP7oezK0GQ8q
nqvWlFASRfwHWf5Y9Dd7qCG04u1AOi6BlJyfyar2sobhTw1Ki78euOEZs4JU1F02
SrKCbHqX89cID1MprtxKvR/G7CCAN7QS9Su1UUcAfTfgrXTEpnCfh5eKEFCnGd5b
l0+4FIzVC+pBd2sDTqbFrEBrMtMbrzJlY31VQ+DnuV5Bo8Gxt0N6SFBW7PKKkHMp
B/vxA41ezt2y/YO9nQmmRN6qPwnvSFiqkOkwRUy91jhYP3EiAyE08nj6W6TG7BBH
IBz+YfYT3osuEjs/+3culglaAQgXu/muxGconcLp1tiZGPLWDnRJ262jK0MsuJ9v
0yOs4GHvWwaga51JwoNRjrnfqB7OWDVUZx4rKte/G1npC0RtrrfvWau7BPruyllI
U9w3nq9lDMz39rGLvWZWf7XJXoiyqqGANVBy4njgDQURGFu4heTD12GIAyc2ZS9K
xDOJTSldYIQJmTLdZpFT0qryLViSNvvfL7f7SOc7OtKVWlHteHDcNyow+S/qdCKV
nWdWrNkBq5cGGnSu8jOLnUfM600Kd4mvvdp8QdspnBFqjn0Fatu/ag5+JOJv1Mvu
GFnW/OoCcv+t4uitZn73TAIo6Jfwuj+RZOETp9y8O9Qv6Uqfv+2Rx0iV7zIXtphJ
thHqO7m+YldeBoTRX2cAX+pzJWPC1EyhWQECJKnmN0+adB9vv/FxFhHGiy3Se8Ap
rQvPAvhDSWQKaTG/LgDTMkT0y5JgmveQbJApPcf35QGEJq1F5O9gOKbkjWooLzet
RN0S/lVap79+mOT1EfG2L0trqTFfBnWFGrkbwuj1s+vpUZTVlOJRcBTGsGG7KC5V
QJ/BOYRqutDLdKIYb5h1RgO+IzvZn8SIZSCR1EOrF3CSx9SLAe7rFu9urGRf5squ
kmRiyCPsRHWRIi07jMVULuzjGna4dq4kVredc0Sr+TMTC+5UUOjof4qN0FIVN+/H
4S5JvrMmCzQRJkiUyJKHgD06pW4imkXfwpF8pkog0dv1brTP7FlyEQgNKvLkxY2t
l7IzPPmz9lqcJSx6+iVZwpShHAU1y8PGU/CujptM/RprPiFRh2wvG6Njq636iH7D
KyJdYCTIRuCwDQchrWdpXVqAPfAympNX4NF5MNriikVB0ksNVfuAWW8KqrFnZ9Uu
V8WWM8t6bjh3XLYE9ETRhF0R8BLc6ZkTv0R/VVU127o8/YTCATNuTjfUMybxHuG4
3h34ZMXsaiEaPXB7U/D3nNsSf+ylM7tpg6+/np5fX7JXwcHa439/21MWFNBG3qin
RuSWzjac8ZE5oBg61wHCD2WfX1bkTooZWma586ucrVzL/ma381t1/AaX/5z4qXAy
vwY/LJWye9Kjy6wvxTVWUARRj5tlVvK6Mp6upSepyS9GzKSBQkaYBBKORvn9uQb0
3aS1P6/gg93SuVkVFRfHza7SvUFv1xCK76WfJsL+JTK7A0QiDx+cw7wgoPr2xxrL
Wh9nRcE886o7MDgLKV0iP6gnScxMWG36Mdwzu2n/xzubZGq1U62Np6m6Znk1XNpq
Tx4XYtW2GcXe/1PYhrrjRI67nb7unsdTX6qm/OU8mirXCh1SLcZlPmJLhlWl3bL/
KwiCtvtols5SERoNNwsJ49wvIHgehx9lc1wvRYon5DU4wu3zslgzvv0rf7VpU0LF
T/q8uKpBoDbfjPZsMwNc3acerjO84XIUUytd1jo6BIadUohugGwAOqjwWPxFt+Ls
yxDxIIbpbXrQDVcjefs333Chk7iCyubfJ8k7wCiVTKw1Um1dQPVZB2T0aDjKBkkz
9qUFnTN7+QRAyvyZUmQFX3uePnM8zpqSmWQlRaeSYEJgj/6iYVAisTLCbSoZv2VC
9bC2nGyO0a7lkk3tDjANBf+NwZ1O7w1D8c9DOwoHGP1Wj8pJJB8ah7svoiFIG8uj
FG0nNNLe/mXIEfxOD/iIUYNu9XO465Mqgf40YJ/iKskC6Lpp0ds7k7h3PpZmczu/
Mb3j0uQBM/mRbh/Xbaru5jvqi4ghieZImpFJdP3CykE1jmt6jTW5DVCLagdQ2jYE
iC/T/sk22o1P7dZaYA0dBewILBUZaCQ652i0vJ2tnMWDgN/bPFagGPO2ApU0zAG3
LPap4v5dWqGzABD2/YCalBH7OxLpYmycpQ4Nce1OrjaofUFBf0PwbLnUKpvQI3vc
BBR7Cd2kGkFuLA1st64aF8GGsPF5H9355Zia1KGsVfCSz8nAv6RvOpRBEtPJ7L33
IMd6kRnXOdzv8CHRwemQJmWDuL0R6yZR1f63d2b06NKPojZtClpBpICXjQEE32/z
SRrH6QQnktxXwGkhRL9cb8nI8Udax1CGcvfFEtOJmQHybl4J0aehY+ycen8gPLdp
6OIwHeF0bbTpeh76/Gl7wGI3yE7aPQptoQTUBO6AjjY/lkT33lCphZbZx5MMG1Zv
QizwceLqjNjGV3HRzUqL3z3KHd0dyajC38HsJkRkS+zXynwegwLpZ6UyZLH9ND50
bMp1JruKEkNKO6C9GdQDsGfulUftbMULgdesl1GvX4qW4aMCoyOHFRWSLdgJ5RWY
29STPaFHsoxQsCGqeW/zVB0yLMYa1HjvgGRL4/s9O7EkGB2sKiTUobqLhts7XZ3L
/aMRybcX3gTxCMu5w+yh+CSIr3LTeTmgtCPpiUHz1i2JRIVDtep1D72FI4e7s/uw
aXmQ6UigD6diOVD1DDy090wuF+SstT6r+YFNGc+H5eE7JhrofCka8g1Zt5g5m53B
2t4QYc77cD6tow5lZePutk8X4m9P8kGyEi7uOuU5FOFm7sXNBYiYfy9Fu6thL0X1
u2N0PuPv7MdVPA2SSMFWqVCQbHbXYboAxwSFBwNpc2S18uFeWaGXhqpZW2kiHLD8
qvYgTr0f4BM6pLnevIFU1I4IRZ5JhAv6qAObFN6mb/b1ZFkrnh1qesiQv5KMFQoL
UCeKuuNgZIPejH6l94UxicO6h2MtpEtgt2k1YZ9Jen2ErgbN5Mt8+3OBVnn+xPZP
Ey8wCm2/i4NSWcM11rUGmOmqxTfwRAL+r08flabpopeLOBFoVQPiNyLqBuUuYQ9x
Cj/unjf3d3dY37q1RhJc6qRaOGp4vNXSZxnpEqMEhUuScWAi/wh7g4b0WrzGYW+g
qA50UAvTtlm83duSBwUFCab8wltQOIdLlg/U12mdDGdhNdbSEJaxzMtC4xr9jomF
vjpjmp3umqEMbDE48FUUMCWnIm3QmqLlji7oqDa1wOuhgIWAzvRtNhxez96EmPZR
OmeJ9IRt0OsDDUrwRdzDagi524MebZhDlLGLoSdVvWkb/oEypm+3AszOmHvBpfdv
cyEf9ygS756+/b44huwCcVi6idq9QLq7KVfktBDqV3wOytiA7jSo0EV2O9WuhLbI
4CAcx8lKx9wSOFZ7K0Kg9Svjfpnqn6NkWQAbGZHwTTsq4KzGHltR9G9NIFYTnbfR
2M1xtC+4m7H3C0tlT8o0SpCzbQKUDOWBhbdcXXjVkaxWaL/IUZW6tusdIuUge8w8
Kemd1BU1R27anGWVSho7lY6QOGlGJibXVbFoCCAPO6ROQKW6FIw8SBWfs7B64HiZ
qR9b43fFsEXJV4U2uzwm6RRt65VR681m20DMV8tSlry+iQit633lcg9Y/yqS1Fe2
RahWnmSxi+/Prfblp/jwKnBF0jmwSeWWK7rGWAon5hzj6KexyEAuKhcsOTIshS7q
rf/44/hN6WXF55NZuJ2GFeo4QXOgLQBKUU353MCCwn1CDYacznXG8VHX/dAl+Aej
HvtflIPCoKoMXiB7NXOKVKvrjXdrMN91kfnb4bR9mGAuBPifRL9belM9wC3MBS+F
dPCcjoJrUaZFmSJt5VgpM10mNp1uuxZ8xT958y1ECe1GhvsM24KN3wkWBm5oydCx
XC1tpBmDfLHHcCE8nVUJjAvuZhVOLLWcDw3Ab/RPuHFtjSFLtg1T9WsHRVewdMv/
pL4RiRsm0xydCHV4RhQZa67QpziU3Lp8TVZH+/cCpLObvsm8NzVGTg/rLYnCp8NN
PNWlCpt0K7W56vtWtHKR096trZ3fz52eWMg017CztGWRX6FRAxF2DPg39N+16XVx
QLzEl3XMw8AQgjggbwhRPiEZ4n7WaNzk/SFazUFHx5aD3xMSXd0BGhd8JBP3TnO3
DnFtABGiYhGlrmFemtreKX9+HtiW8ve6s+GgUakNAlF0HnCuvd9Vr9eAVfapZL7g
RiVFoNi6yEnnzjDnDDRi3h2YYuffEjv2vVA/MH7KX7cUfivq+mfcGOBPUM3quOkx
4KyiEg8cvcHQla2kL+ppWC4C42G6uyvZ0ypqoLx7/O5F4QGKCVyCxaeos8maXpkQ
QD2cmTC3+k7qMjCaCqxzv2wheu0IygZ37TxgF8oft51fgqRS8tlqySVCt9BsNr+r
e6mrmkVKyOZxaBPaIy9BkxgQrY8g5WgIUQBg/l7HlS6ZnJsKCmpZyQQSDxrXSDOD
goLKOIczX4QBqy1webk8fQCNwUMY5KuA/cp+XrXVryAJq+Sd4eo5GY5q0Lz1f+3V
f47yqlPOxc0bmbGB8LyDZk04biJagZAHmdg7pUTvaVmiAmSLGnMhmdW1/ssJ8hxK
b6Wm/r7CQ9zon2diGrLmoUgTXYAmpQ/bJgovWFQ90GGtRv+8JTQDFhb7TK6rWPg2
1WQyJcxOzQBEeXN6kpuLsemE9/3zW9W+qXZQ7fy12yqI0l8Ewl7n3mzHnqwbRDYP
MwDI/V3Wt0Mb+hgDyBG9NmJ/iKpedIJ9sh4Pn/J4oIhTV023Gmdu+FUWbsJV1aDc
7qlIGAoGf4a5DxJRMVAUrgftMR8Ri6H1aN2Zu7+NtFBxqKMloqhtJ+iU1IVk5+S0
EkepKl67kzPFelD6NnuVLjAPlfIW5nXE2yZI1Wt8O3RwB+F3JLf47k21eww2aoxF
DBRZxIuBDQxO8Ld/TUwcd190JwINe8FDPRk+Ho9I8tLJA/QQGkytUbZiqEtSggQ1
Cosey0mBr0Vv9F4QBAXdyveRLXQhopto7aerVEwDYNHKBLKDjvs1/+4Hn6Rry7pV
r+//elMlo2iRPFsU0A78hJMivirUslRxoOi+OX4qSfri4Z3ctWlqG/Wg2KD0sfD8
gjSitrCypOxKNulQvfMlmAZlrKF1KLVNetJdCIVE3nNlcguedtwKNPsd1ff0U/2r
HmAuTyP422CFOH5pPus9cKXySE05z01iYTDHv5HvsCn+2ekOy4Wh+7RXL0/tWjjq
0KWSVs5eThEsAHWuwhC77hZWZGnrIp4/IamtS24qFkbWeTMfmJR0jRU/pjRBlYuY
x6664hSmx9fdmmbwSIX0/+kNejGwNnHinirI14D0Z8gAzFFkbWMnzDR3bF9UT+8i
w1A8azD8YgF5bRA4UBGmNDMD4gogCIfOxtm69GlD+ewLvljz6soCXS6yi5EmPkUn
JhD7M1FMrwOuxchG4ELPvsU3eZotDXOHLYEOaZnty16fxDYVU5mDBsC2UBUkzEC5
2oRxE9uGhvxdkHE8xuw2UpDxuM8EFi08XvimxvaFZZCNn/vGTTEfpJNPCc+nL/pb
XXXPD+cvDjEEqSDZNmVLS7OBdJxZyNiMtoZS39tCzQ9SWjTQx0eTHZtIrZHlGpo+
PyGaNuJx6fvUPCyi8zz0lgG70o8jlkDotW2d9xN0dO1sRLySoy9QD1vuK9dX6acZ
sJwMHLRWp4EQqPoY/cM5YXfaMqS32FrOg6VpT8eGneE0Wb+qqStsspZQhKaEOqzj
hjc1TMsHVKHQ4fbzRN/pnqDbqiQuiEsjWXFqMgiF0rZZFXkmUG8rIHJTFwUNhL4l
5XlWjvsDLVibAgVujjZfzWWki72ibRr8YGV+AB9f+Dp687NVzz4+Aayy+6sBov3/
QmLJARYBINaTNOB7ohg41OtbZGFRFWUi0QQGB5CQyKvMtgc0ZMet4HT4Te4DAwaD
6qchXjAPHnwshoUOTpR4cJjoJZb8AOrf75qQqiJYvyrkhCv0NUvqANMxZFSXCF87
gkc4ILfckZ4GLQqbzfBffNK+E6uec3KVN7jBYCyR6pxyCNYzWFrPCfC85Djc4Lnk
fNZtaUtqsxBFVpXn9eVSbqsLNPr/R5sWQ4KDI9/JAPURU8UfpAgeDP+jw7cj36YE
ypUqDf9pDG11UQH4WYrri8QdFyT8kaBIo6U9pYC0V/fA/gwf1/Wrb97WNSD15H+H
4RVd2hbkUYXfiK46yR7/cwnCUCekvZz2ioHiQjTcTUMXdkcTrQDCvC8MR+HR/PZn
BvMIlS933XEkTBZ2dalmAC/5B2Z+DlwpyMKrk9NCDGMWY2DOBFr5tnszcuyZS7YY
mE4jtSeHpDQ3lf1KoCu0pS1BCOrqzbxSFVOK0Bz2kSBZD3EU5fkPzx0ZzHtLScZr
Dd5kYklvlevYnxon7TmFsvxL6er0E0IwRqHvO2nbi3uxpsNPskoyZbGpDMrzDMw3
tq4PuwKJIufj8rIpJCKQ56MjZHj2qVrak8O344U6vBjW8fs5fgVj3vb6Ceb91mH6
KqMq4nz10RxfZgrOucbJb2OZYifJKvTqJAsTxNyJSzWu1wpkOPhE9sTkykGcCQBo
IDWxQL0O95Dq+n0X86aVA4x65YEEMp0dzKvTdrL80tSDIMkv+r/J2hjNMVXEx9Pg
n01lszXyMnXyTvsUnR8WZxlwlSmk7EU4dzkOhoEs/yc7y66og+lpiBS1/WQtKFIw
PbPu0bjOSe9PHHyNBujn2FpmiGd8UpbTOTH5cHr3pWWGnsVyc+UxVWtRdPbDgcsm
ruk9x/4v7gMPmRhgj6qdkS3sJG/n2qppM1G0vE8zyggI04M7EWG+XrAqvHsMcroD
1uC+lo+5MYM+Vevrygd1+dU/j4dCHcdIPM0vfRdO4RL9McbGbQPag2utzyU2fqhp
d6RSJpiyb611uWoW2Q8Qn3GNjqo5lpCrObkiMElvfqtTJgT/fhV1icWWDvA+Av2p
j2Hn8cI6L/9RyxQDFztiR9E63fl0SpFw2HMnS8ikjnwjUS8RFSZ3Hh7buyfDKPB8
+wAifzN9lpRogVk/ksXMjg03bz5BOEvt0wKJAra+5hiW/V2PPxCf/Va0C/0tPChz
pEzopm0RMBgqpjIjj+SOPJ3rlKnzWlfyW6z+6gAUIj3LRxdErDNX5QwY6yWAVHX5
MU+3tW0zF5zo7mKH6qVlF/EFxZXgRXNowjT2H4mAUto4N1EDepGY8UlQol1ysHtR
TbKtkhwm60W4hVY3sePm1Y2sRBtfx/YMO5cQWzj4gMxEqIkwRlUF6sgkUefgPNma
VzzSy18lHKhNCGGUb1BKjwqIQMcqnI7921eM6/cLnmhlaOqk7YPOWcq6WPTG40hU
Xa9O8y80CbjvjRQgXPqe3breT5zxTkk459bcxBUyvI4cT2fvlInu9hRgrOs33Zaa
7x15eKtzOOb0lIEoKPNjvQu9XAgNwnyUChOhwVw3+Qkk+M/OLTbRwN+pXFTCmCi1
mJT0MlMkN/CBnjzbtSo8t7mbR2U2vj3zYvEnRCbP/5tvkT97irzOEIMqKI9Jkr6d
z4mg4AL3V4tvbuwC2xOqUqZsIMuGUMWaqnUkc/tD/Yeof9bxNGNgxcdXPirS9GFX
MTICceB3tWVFPe1SaZAKRCdbqB1v6uFTey3IF9wltLDNl/4eaiiB+MTsy6LD3wkV
CPSFa14nfleWvVMYR4g9GIDhM8RqncrDlhyrphGk9jg8qUe1r3KMQGqSc8H+aT6J
kvbAxGAtsrB3g9jnKWeD6OQPrjLD76kBZ4oVp1Lhh109+5KfdQn7ndfo8XCVDhKd
3L4ukpZ22DKKTyfGt+Z8CHshuI0+4ewfxQweIYPGiivg32absfe6ODYwjIFV2BPb
Pe/RNJ7rY99GtWOKzrRlehv7JZ7GLlm2gdedQhD2t3kLoFVMvKPrFweXMRLu5Kx0
SZSWA2hFpFJdO0R4IUZbeYWuzb6RFOAx7oB/HkNzjVkdih87GSPjRokcsGwkOfIN
/KgqtocGHpb2wiWDM3AQ0NvcR9xqm4HnECY/fvUv7AQyPgu33GLaaPpWhPMJjnJs
dGhlq4PkHbRB+YMf+HGYzvGSha17U+OCwkGjDR8BaYNUYJ4sEBhudEl3Jm2C0qYz
AMGjJPPbGV3/0MWzoghX0BubxNJhie10aW3fgvAZO/KjTszWIHIw/C2l/4nIewpC
KKfYQL2VZ5LltXgF2WfIWjrvu81YupYOtR4I5g0bKWqGgfFCqqRgPmckcjdCU9xh
XiC8oSK9TD7ML4maGrrMcKGXhdNnfLb8CbHHCh2Eupkj++c2uvXnawKoiMds8ICC
Yl1ltO+3dWK6RiDaDFobMsRxjb6zFmowJl8ZrJ9NtHqrOkRslfNJ+qgXv65Mw7rK
ipYiMukCpGI5Z9wUzDX78gVhDLjon+ySTO50fXW2a//3cxiv4HQycSCK/MrXCppS
GP9R08kmua1Nb1DGM1aRLLTCwNYp3bGvLOzHWN0TBUZx1erPl7y62ENXIvqe3jxn
3eH2gcOKlIryKbMfWhNSQE+x4Y3UHQvJhA64NC3/LHHCRHblGibg6zLjflqSlI6g
LZulvedQmWiNFVEkqepRDgz5IXNMBpXVyt4JmBMwgEPmI8iNSV07vzzfBVq+eKfo
LouxfJI0PO5LkLo49eYQ2JiChq5z6McmQvMFcISXwVS9ZFqHTlHF87RQ5R6Y61xv
4dPquewbPkBs8Dnb27F43rVA0h0YXGhlq9fY3GCPzvjNXzIems/EszrX8POG1OzX
xatZmdCj3R4fjh3Tt1XW+XlKFQT3CRo5dNjEL12u+S89g1u9Qq8AUI8rm8q+aH1G
0WnIb8I+FZrHcW/Y2C7HuYWGyFSChpTXrbpMpl/5DgwVTvIyf//2UB5PX7UZNBZA
0tbWh4py4f9D6YtpEjnkMto3nupqG+AoJKQKOVtu/OzB3betgv5htg1ieoSOepRH
vOn6EyArix6+SvWUDFuxA9q8PT+AqW4L598jDiO9EizqFYSesRJw6s6+aBcBWxrn
nTEnrCJWgq9iVvpnO59whjhwxVhG20EA4jt7M7iv9jFM3XigPPyOIPjTKpjMH9gt
lxRXhBHydIIgz8J/vSZ76frcZZeQ1FPogUlCKqdf+PfpYHCb0USo70cDjC3J/KLK
on8zo5wM7TJs2xyMgNCocPdOZYTSxoL0UXspcD1E7nNrC5WZj0oiYlqxKZoCH6iC
RG6kXn0wfC7jg/OvRyIKWwKmqwe8aqvdcWX9zPcwvQdj4JrG0qaXjExe90gODmLV
sOaxrahsi8Y1Yt9SgZZLmGWlarJrEAhwUwV46xcooS5uziQb4ys8OCvVokEGw39d
mGk4zx83OEVw9FdKUaNWGOtPOmMEjFLrWXvoEvmBfuIiarKgLxD7tLVqAMUt0yym
r5PB0fAI6lRrxR/wl7wvzvicw7f59GDvEIv9aXShdCNbhwEVrIKaivVUfFZyEfOD
MtV/vikNEenivKZnfWEVa4Xd4bu4sYb9VDsn/bs2rdg/GI9ZZUXX+tvdvPsyjCPA
e4X7A3vPgyp9/Hdj4EXpi601fVZbQvOFSQ4Euup7GAoYf0JqBZOBObX1/ER70Gpi
wh4V/uBIBBIEWrCaYx8ON154fxKdE0AVutm5cHl64yA8HllJortoXaYHIBK/sucb
ULN1jfDPrTXsfLdgeMLgOA48jV5Om5Kqwmyfa19gaSA+jaCHqrMu4JI9CZHDoHo5
uZW0g5t/GN+XpiNqOCqvSk/hn9ry8ILiaSybGBxOnvxOPiRfbtps8r1Uj35G+UCq
5gfDA8okSZg9GSbdCqW5POrcJ65/mBaVb13RvINAYVcaXBiXvhOvncn/qCUhvlc5
aFzvsAjr+WHSh5itNGnWzUR/EzThAzZFLzcjbDei5/dpEGZXs4GEXyx798yuktB6
PmcE/1OsYI6cHiwP5kvPxSdpSmYf6H5wGrH+eC9rO67WS8olNlx6lP14hfjO8wyU
z5OQmLaZ1APLd9G99tMxbNryfphOtZUETHrFW6o93oXqh0OFzIVoL/f/n6RURkQA
EOEiSfAWAOZl3QeJt3YEN1AyeDFTJPf5cJ3tciPLGXRQVqYZkp83Au4IY+IQZjne
5iTX4Xijuo+z3vc5UFi2Fn4UrFzOrXTv0xqDfSG/MbTJGXBV0Ti4HNACIBpGG6zg
KG4QJfFb8/HwDSD0cLtvF7KLiNS2HiENNTbFzbqbLwjphhPyVrvHqKwNujr98jqN
tmNfqcCQEFZfZn5BwYx48DI6V0mRFO8cZodeLlzBpBzgpsI/t9pQi0SWarp5Ao7F
N5dXdAFU0RpnxE3KDA+ufBNgo7wswBv0tiPm23cIvg98YN8a1kHAzF5YBbTY5bq3
c0cLH8Nr3Zid2l4GepuRP/gvXGRi11SzWFMFmSh2yWdTD9qJPXt2tVjkEYD/3b25
NI7o4SRGo2CtzbPleyAL5G1eP0zlbPQJD3lEfuE3YFUlMiC2TCTb7bJ+vyDh+NWw
vWnu3TAcfBhzkx9oRbsGhgjX73hveFrIb7Sj8re8N1HjKflvMpQ+4UJB/AT1yc4i
CycQGxxcOdFOdfPXA1eojZ5IAKWj1LAomD5kMjLjiY2LsVSd9MW/6YNHRFRycfzu
SWlHgakB6McJ9vPtlaCz7PPaY2ZGkBNasW8dptIgZXuR7vtZAq46gVhd/r25Z5t8
SC/kmENtL85gwVXo7iauhL/18eVFL1TLsxZTjfE2Mmsu7NQ+wzlKSZYgf2p0ZLaR
lDqkVsRzfuKjBaLKHRVNG30xDbDdC9XAjqRZuEyHMOrpssdybRQusjUuHHwS2QGw
XJlv9QPOnje1uXW7U1XLijiT+BO7q0aTS7szWoFWhTtCyr8xtP/RRLXtfKe0pLK3
/2JEMrwT1IZzIg9iKmYYaLg9ZeXLQ5W9mHjm90DmeJ6BvZU6BQSjd8xui1sBFmdU
A2NYa6bFkR1rTCIqAL7gCPPvmcvk+duMB5MmVDaSKB1//BoFFB6Qt913q4hxsM48
YhaLPrVow8uZB4/s8zWdYNMw3yAwkVZE2jjHYvq98fh1qZwv3tBwftfacAXivnu8
m+XGEtkA/NnTx9YuZTJ0caZZET5rvGtDHND5hMcGjCp5ofgSlebo9ZtsdrEm5dK8
4+xinWQGY6cP3Y0ht1DywBC5/mtMES3Za2FbDZezG7kKA7Z4JA9p6LbsLvEUQlHg
qwyiYiRf6Lww2j5zSw6kGshYqgYDrTAiIhra0LztiWNriZdbM3MLHkF43ckceK4q
n5iK/Kqkim92GpmMrvGSEjrvujTVaB9RHkpG41R1fcz4WGJ0PnlKE8XrEIRZloeq
OMGTxG/xjfUXrgnk2YGrimHRiT+FXVTnbw4ZdXunI7plIE5Rl4sPks15tr0//dbB
/ybqitg2Evt/PJeEdN7LBMJqjN4DQS1d492uj0tHU4BtbkDKBSmiviAibLpTs4Qb
y8++/acKAG1/DeARt+tn1/a7J6gGlWWPj8CN/H+Dk5mHpS/anISZmYX4nGJbit3J
YqLU8eD/90DAZ56Dnb2LeaTkTVJ7RY4tyr7AMOfbDZofN1SJrt2HYJk7fuYOgMQX
2YFmLtXSVAx+LutaZvH8QuzAESmUXSp02zzoHa948eSiUWbfiiI1VDnU2/lzkYSs
PV2b5LxUkxpMI2mvIrun4QQDqcWXza6x6HQlArR6VOLucj4SisQfwLvSq6/NgYEP
vjw8Z/2qfaJFtyiK56+idxS7jTfXuMCDzJOwXxadppBf9vkFUa+t5obB/mtgnjHt
9Xs6ZaUnJAX4vAiVEtQoXyuDtxaiRCd7m+ZalTV0tFFmdK4Y7GnzjuKiMqWTUpB6
KYMSTVAeUFaWe9B8PXW2+ehFdiOFjJXWLYn0hbZJc8BND7QF0aUuCOKqf1/PdjPD
Fo3GArShK8tQSNaCLC5N9bTMCH8B2Z/g77bWdk6Lll+8AXIQaU48b7wud4jReZ0j
ytq68Rir4Q4yXNmoO/Ob5h04K9NJV96opXmI48dmN7PD2bG7ls+Ev1G6gqyuTaRM
LHMx3BsBKfUEnM9hZT4TREf9qTLbYdcbxJhjlERDFjRJlbplaJnOdekysc7Ma2a2
hBaKobv91cN+7qkyRRQ9uQLoatR8PUYjNjOarYqHBeBOdp4C2I6JfrLkutJNgUVh
SGc6VmPCDXZ49fxt01q5csXyl5aa3oNMurTGyVr+1vk4aH9guTE06vo5H6i0R+5O
um1zgkXw3JroVId0pE/RCu04C4UXsc0zvN5P8QvGUDyJy7VXihOEJnnEVWyJzq8Q
oRuL6yAM8fT/Qks5mDIr70pbI16GsYwmbRudTHZGzU/infLPdyUqJj5N8faTcpVx
teCk+WjuTG7/qu9I3MHkW0Zrido0ZOhfQcisxn7G3b70vf4WHvcdoFOWMqGNhs1c
Yp3yZWO+VXi9+/U21vtjFzQEIfH1TigapRyRcd0rG/pz5G5lDyScANMI2EMkmLKg
lX0bbd5b6RWugLltF91L9/5XQkPpVcXwK4ploAX3jNGIwvJ8BNhhXYD8OIc2/am0
yuUhIVD9LW/lpNBS3brhVc8WiZu7rFO/jWKdHmDR7JQZkaHw03UGNxiLP6wcz9pc
WwyNTqg/6b0JBey6menwUdCGcahP7RO99ERXdm/jA/FWqZ8+lCeVv6BJ+48BU4XD
LPbJtN1QHJuOsG5bA+0MKTYvoemPnUjsrIhDduj1bOZVqmvX4R+EoRAu3nfUDyRG
l83T/gLSQbOPJOnSoE5xC9PYig60kyQjZId2+hiN+ckbzWUaD19MrgdM3p5L0Qoj
5QD6lf5ghsmwJyBpChf+B13Xf3oeDnmYo2YwbBaCc5e7oSHkGdyEgb2PvXHf3B1h
KfnQeis/3Ol8tJVP2QYo5OGLubkl8SW2FhOH05QUA5Jo2yvDiYWDaWDDJcr6iNaZ
y4WAPhuU4115oGCtZnFF5ooRz/6ta9nDS9/EIori/gh8z//581SJj8RJxXnexxee
Cp2dY3Q6oRTp5j+AcimhPVtitZp96XuprG+n/hlm12r4n6gHZAM6UBdzaxoRALuH
O+blKkyLHO5z3BHne1JCYzIGsp8UAc8Z9VVCt1Vzn5mGIeR4IgVg4oW9DVhw7DVV
f6w3Wr0dGFBg3oOSFkPKS9WbMqSOqoxayIjPMLuSMSGuKK2qcZGh6PyOakl6KfcK
yaNaIHqmOhOrlDlPcmnSiV6nJyp/TwaTb67okvamH1mcpz+CHmC1TmWq738W7+Qw
YDpR17IukqPyzG3Afj29rsjSmN1le8u4vFMFckgIIkSpxfjoupLIx1sscnX+db96
AdLRfWUBROgI9cE6g+cmXU/jYkEcbz0ENdX0fzQuqzOfwzdoawUxqW2UCpFwBXS5
+K2rryQTaUg9pvsHmb0Hn8C7xxSVz4ODwelzTKfyYCVOTcfq1XKbYs+G2Tt91bAb
EWkLyX6aadTJ4beFys4NHAa5ghf7Xpy7d7Pv6rww/AZpNNYTT/B6BlZn7jNPHFqS
w207VD6F5/7SwQ1o5x/1J5j1LwgBcw8i0k6OyJWKNKmDq4Dz55ujWCmUq0wGdiYm
B/clQ32v0FqcNpMKpZG0T5yDxn7n2hM6TMq8u3/kF/oxZiR4gn1Iums32NQs3xIz
kluyEwGf7aXfTvDVv/prGgASGWIq+IqY1UHiQfBdm9eHUGuLPD2A7yKgY3R8wuJQ
/sob7pBDC/keg9pBy3JSCFxdVuLeXk3AopBk4+oYATIdRu8aN5wL7S0QRl4ttvfb
cHB1boQoLQVmthcRA69fJMcQkyZooQd+0BJ4rqyyR1U2Ti4snlHuTR6t/1VeceUd
KB9Cv0uHMDhzxT0ziH+m7OV5vaDa4ViWps5Go9EhpBYWpAbJIAhFoedtoqdr1JRe
DWVYhjDZCPixQ0LC5Yyeme7oalePcEFvlkVlPvqC2pRXbhFM478sKecMEHSHfLAS
luj/XYeET1HBxoJOtkIpFNUDusyZiy/XW0fgEmHgo+7z0C6SXU0vH6X8IFU6ciln
oSiQj63E7X5H+/apXkcmOjFfmX4mL67iW4y20e829DI5V5VYMDAKfJ8Bw7xE2sTa
3Y1REQypynp3uR6ilFCXFyTY6kQ2Ix/rI5NtUsQDF0rUB6ckW7Pny4yV33/gTxtL
nj/czIXRQt4xcI26XmyXLyrdAoNqj1nXtLQ9I1kLJJusP4eBVxYW9+CWYA5jRegg
sEEOG/9Y9W9pokHQ/IgenZa5LfXoZN19j1DgquEKGDdMjGBcF9al7IT+8Rfevhh+
OvrWlAcR4XGKvC9yGIgc4YZzr5PDcNmRoOPVWnJmeSZSX1LXwkywKc/uIAsCo85t
XQuHV/M/UNEApcwPmQY8FKucBRB3mN81bPwDvAanOPDHbimZyiKEFL506JiIW91H
mn55TCOqc8z7cJ8TPo7WlSTvSInHdLBGYsJnA4MAcsPQkPoHa9g1MJfMBwiz8uUs
gYdvYDiTpPsDVbCbBhmGZzqhdKx8GdlGeeAl3sdpZVngJu4mshBjDp3iXHPOBhe0
J/zeejeZySAsm6hRlrPe0hZvZSc2EDnMbl0CQ+c0RkDzkRVXTYOJKDB9HXVS1piB
zKhAKHXN9foPPaSqBmJJB3nFfKs9AHHh1GuAt9QzUJWhYBDQNm6D68LFGfL5vCE9
eUvUHMw3f7BUAIezRi9UAFYmEVcsMcy+KCpOvh9yE8w2pmL443GoSQ8HvBS2fidu
fx841Ofgh1Nb+2dlcm6C88X8UGt1xjK/BJg1g2mkf2wQEed9u6jPMmPvjD6lHuYc
NstO2TdjI91le4v3a+EFFa1BC578n3wjPaQTnlmDGdZW1V/SS6xJdT7aM7WU+bL0
sdf3RP/W5G7Imt+Otfa8nUnzwOtUiK0ncXMZrl2UM5olWC4WTTmrY/5/XDS05Q9o
IK6KwWkLaDAicQPHoewooBMcOKW0Hwda23+JP8Ka+56fSkdTl9kyYuMXXf5GPW+5
JY4ZQMu2MgiXMy/L0e3ZPQa34zMhenSCmvaY/4b19f+uywJI6ho9Rs5+6+NyIwId
D18J2xoTWBuX7JuzMu8OgVW0I4CxXavVp+uWBbe7pUdPLsM19TDiXBw/53/cSOLV
rtLEIEgXK7wIVDaJ8YFyHTao90BadF3Pz+d44kEfWujtxqTkm2U4RqvSJC6i/ViC
CIVf3yVG/RcinS/AK3zsAVIeHyN6w0xLxYpD9o/Y4LH7Vgh1sLzsmEGUzwDcTsMX
CgunouWkbOsLxCVBlmxy4NCroCCcSAna2njn83/YI5Rk2O16TqUdM8lDY7rdnhBK
7rkjVakJpEA/KwQtWDm2fPUKcw1tM/5+zTqC2zrlc00ZQ+9xd7koXyX1XNMJhXEH
8fE1dYADC7Z7NF4qybCPGGpMR8uXsF6XL4oRRalIVPCDv6NcPJgnoewC3kgECcZv
L2bj0ozGv1WShnZYSQbHgKel3PTniHegacJAwLGglFLuY50JjuMKKJRVpn720IrG
zZli05UzKeZxia7X1AIsA2KjfAxwcMZgiZXsHZpiKq+cae4FQr2TioFCfqXbaiXZ
Yi9S8COnebtGgdRTnVxLl8S7S4feCiJhBbD6BpIsx4ILmXpDrTM/6fXYw+RVSJKs
4vVeF53AFComVZB4kVyk4Y+ZmT0nhsknv8YHWHIm13DNpQhNX5ACeL5q67S05yj2
WzW2/kP9YVlBZmQC7/8JDnyzunVo3UaqheW+I+5omczZKlDOTW3KLj1rFIAGI/lA
rNCmYz47GiaDlr/G6PDSrdhKiNfCOMTqYLasReD1A0M6aTdY89n4n+NtoVOEu1yQ
wwKAS1a2Hw9AbrVmobdR3wfg7yQtf2mIfA5mW1BRNmXOgX/CpVR4qKX0drsJWBO2
ifFXtgjPufmIwUv/TlDy1BPmxy202P/snPtyxT3k6sw/lO8zqAUVU9bR7vlOG2DC
IeOxULaP+yKhqNCHD52oQv/IU6VoFJyB6gfy/XHnqqXwFGyxGG5DKssyoV75lvYD
dtP9+xHDLwvYKG18cp5yBW520pvY5IWlyHmhZbwOwrcIuicR47mdaCgpqQAh5whf
uoRErUHvCykVEOq0SdKcCJLKz3yAHiWrOlGuDu9MiGwvwwaPkOTKYRecQbkjC1C7
YTDrTa8FDsWhFSyY9Mmm/2baOJkg4HhTiEWZiUXwa1SPebCx1QMbOvmtF2DzbRyp
SD7HhRziQ3n/6NTVD2qNsLYFdlN3x+ilhFyXVUxeERjuJiFcTBKzOmJZO/xC8Xcx
C0ENBdvSNXa+utn8luQBVV6XPfnCd581cZP8kyEyMYEUmvCJs2N2be/cvQZJ1ta4
QUk/UYwcc5rqyIG14hftQBz9NdBUSWKJdjDaLq8uhYEIWMF1Pc540N2wYnw6JhlJ
m7SxwqSGFToBq5BST9jMzCUJ9akb7h+c5278UzA+M1b78U8PfmDjNY9l5m0mXpRA
ZNNr7jikPqcdsOG6G6kg0Gv+ixgeuWu88RiMikXXXq+LacwZq7oCTM9Pcy2wkg3D
XjXCHuK+0oznGriGJAmahARmMBFyqJ3BqEqF2UCVjWjHFHo3GjjY+61geaO6Rli7
SHBI2KpR7VAtUiXbc4Rcal3dXrLnZsaoHYec9zLzYvBwJVWzR99lKg+MPlQXPs9V
2XGjygcfeGIDxpEGg65oliAqA/ilkVyfeuTFdwlbuQq9Hn+zAlhT2IFTHxm9+gu+
wwsfKr5So8qmUaXVvVCsP43nW/4/mqiXkKj8czn/NLu+IbOwCUsDMaLxeWlrJEos
trZ9yjMmDIo0j7vW4cKuQm+GtVBcW2QOCTh7JhQ1VSHfffAw8sjT2p0uJ+9dwPfq
ybq4VPR0Lc1CA08ELu+qG+AyykRXb2KkLp3fIUbprZbN2WGWUI5a4wXAi9uANbrK
Ox5vBHDN3K0E7NjZ55qehbQdoDqWCTQb8SONWzoNU/dGTTZcqle5/CS2zhORWmmS
jiDYXENShs1LayyzqP+ovi9+aJ7UV0qejPUl7Seczj4glvFxj3TVUohSnrioMYZe
+wRIIIn/eyBUL2x26tqrR2Nr//bA1UzOluSD7PqFp+D2rZP/VHvHEz0tdDUEPOdG
3tblVqzL3ceZ4vpDiYHPW1s+/wq9fO/gFCqsmCHoX4MQhj5irLZaTc5hzZyp9Gtp
/0pyL6HxS+Xq3HzFS4I/qbeE97EqluNEKwCzKfuzw062WrTwbsc/TcI50f4S5DqN
rT7a6EoN/2Z4ZrdTbuuPG5FjhPx/+sY6TIA2C1ZuabPkPd+pvtb/pC9u4nETgsON
wVmnSV2SQIgp609YY04JMuJ0dNYNxjSCRQPxzQIKCyB91NJ/orZL98vIbwp/Y+Z+
1Q/czKMKnY85tQsvLGWMnn5k99xlmz7cLNoqFilXxq1asJnIM0f8uzUWqLnSJhtI
/yxjVrnzxHEzIFlbWCYG/DmgQQPUSSyeELERNPt3BJDfQchUP5jNZjfDTn0z4WvF
gjUih+owxWuj7OIBs3mSnpWuAzg+8vFAa4PGO+TPLAEI6WxJTYGgFrxl7nXkg4hk
wzYKtgunMxBKdz4aDNwvtpAn7bhkSDq2KD37kMw1ZrngssBoFNs73STY73Pi8mOT
/JdcSBBQ22jwKoSUWChSHNx+YOVBr6Dq2H6tx7fnO2VHTqKW0+vZv8TbJDL71CQ7
xf1Eo2sRNV8K+s+6AHNQZYvuBHJkX/B9YJBvG8M+oLlcmjIUWQuHxxdNCHTxyZJh
UzJMov+I+EdySzNLyTgBemjyQUuR0hxxHbucvY2oczVewhudLeWrsOgC1H2yqH/1
neTaicWvG5KRPAlUjBARhJtyDQJ6S8TagJRePctyOkGx1Sl9cPgdXkRUJ/xARnWc
WBlUzDF33+oVHK7fG6q1b3nCYMdbYAH5yyGiPmOCVrKMm5kRcg6LHKDHuNZl2re6
90iAnz7/wk6HTvWGbPbCg3lktL+CGCeVzhxQkUHR7yiNrenA9cAvZhlJvXJOxpjb
uHLBL7oo+CMTGg1ShaPVRKcqHjA+NKgmPGkCJwhu8YdKGkCjIl2wqbGtI2HAxuv0
jqnNkCw0xZNT/rB7kCT1G6C7uxXTSrwREhVcWNTpdls/GLP3EzhlZKK9jlTlAXlg
wzCsgV5ozPXWzNQL/bkvszeWRDgOFjvgwL1FiHy0WSAJ2W5R5PpQgxkHvYZ1AtJg
FE/DSguwRLqI/PrYnZi7lSOMhBm5vPXhVLZwRRBmBU3d2l1Z0Z2E9uWA45YPm+bX
Nl81gtDw438RtSnwyTObUrQkjTz+O04BMLBEH+oFFKHkYnk2lJ2n5biLCWB5dwtP
eVT8LdTsRyuTQdSM0VDz2rZPG2+vux+MXhpF0lIu/YQ2bzdrEGy3Z2sKpsPDjTQ6
/E6pdQ3XDWlxXd8KzRsXgHHWzir1D4FNWcOK1nQGFK6wl6ShKQ5PmlWNlJOdya6H
OJlujOgmOgLcjiZCxpfz3cm4s40IWjYrz9mMmR+FkRX5xEV2HWSYTmphSofrEg7E
Hm/6uHBFObo7NYr0Li0lD0jDwqu0fk3AQNh4Y/AyXmfk3Dw1WY6Zb3lq5rKtuNYj
zT/gfNG9Arr/O4dA6rS7L3CZ8NIoVSZc3W6wVTAh6O8sEBCUbSbdLzl3k3SYv86c
jDZGsd5RCImKsz536j6J4qKrgaEOdtyNoaSGRgVud8pb6htyVHUbdJyUV9NBye18
1Gg02bAPxihRhMtSBHBQ50WdwS15SjNFDhpHD4P0QYJOWsasmZNo4Qr08AS5O0e8
q/GxeNy1Z1SipuLnIIt8jjiZBuzwF1OO+QajFEkf8OTbXJv8dR+9ARV5IosxANWT
/mbMpPuShaQ8T/izJhI+yQyPp73eLh543c2Sl1MaorWXstZ/MMO/LURnlE3Zdna0
XRWf//vQnpQYlrZFbBWCsUCPQBGGA0qgEpu9xEqtgX06vkbAmJJpNXGVgGulVmBb
znfsJr26lEzWgyK4QKJLREb2IVCiUKtjk+g3YY3isvZ8tB+wqdPOtmR2RqB1pzXT
DgF7D/LTVnJ+oqm63yJSWXIZ0VyVcfH/w0PDb7mYgiMVFGG4WRClMdb5VJDr9IT8
PdZWcmQWXbch71LNoUx4HTsakgqg1Pfq242JU0pDaL56S6J1HrkuiUrOdyiM8Q4z
6xqYOMEKc7XywbSPgtxfEkxu2HjzhDV+9vSz0GTkBhvOFK4/Tgh0XRfXlf1NtfZs
RisrzevnE0JJ2agSFyEaBhW7G6vymYj7IScazwnIucQc1ngFpHepp8BLOk8YbacP
QM+dl/AOL46mq1gZVAwSSRxC9qmfHRONKu9vv1AuSRXD3pNuEQw71FV3CmJ/E27c
S5cNqk5TQVIN+XEofdFAvaLgrq7RRMDHk6eNqbCcKGcrj2ykm6soQ4imj5ysp6rh
4m1IRXdBMv9lNh/pdl14GdLAQk9SfuQjcdPMRvr3vM6SyLXPl1lYuAIxEcp/zC6Z
a2ExH8AsPIFNCa3LIMCDBewpSl+1fG9SSJtKgXw32r4fxl2sQDAb0FvAVbuHb9Xw
uWaYqkyl5EAnhfJIBNkpGtlXEgyEy7xpvrKnbj7l8MypNDa+zuBZTMdlJbGRsVhS
53Jl5Z8oLkNu2gLnONlJOXNKLPxrAMQFlshIVLavIradGbXorSfT2TSuyE5ZRU9E
ULQyY3Dqcq22vYMA8sQ31Qwm7iLRl+6URaIBJZLtHz2uqh6HREMQuV5yzMrJ5f2a
FGi/Z74MzvPqI7l8EW2i1BDpw+NDLXvYND8NbP3lGuABkOGJq4SAn1ImfHm4oIff
JFrUzzow522Cf8W82PEt/gJFzPQ52DBSFBqyDkugJS+dIIwBL5DN83U7vz7szYyS
CjzgzXoj0TJiw8wyhN3YexP21GhO88laq1W4QzD8CLjCHSoqPTKsz95zy+YnbLDw
gdzwVpkTCI9md31Yf3W1yFb77srSntoi6bq/8uj17NAXRo/mI8GczvS60zHMoG6d
fI7O04ul9uUijyq5MjB+QIPL3zWF3QkTJYr+yN0N1Hmt/LP+4ZwcaaYF7nXfpa7u
O/NTMTYeDndTEv8CE/YWyQXsAvR3Sim3NfAlFWLzWdqTxkpTq2jfxSqzZBJlNuGz
7XHJtVNN/RMcb4pY1tOvTSQtEwjjXZhmcGMdqcxhuoYcNEv+2RN74aLuB2k43Oqq
8NqfcCKjExlDORcExAxKKywo7xPmz+5NcgATm+E/nZ5zmjjK7uxelCOOA0VlRb5H
97wHm8FlK8JFkLIgyzUI5HM0mWvMnYY9qoFr97oY4cGaDkxPVh1fHbgHgBU9r76c
tHTKHCJIPj/BoweowwGogoMVoVVYkmKNutT6z9BAv4nVksphkzkJVzacGKWNrxcW
+MVhvMeTdKy/09TMM3Jb9AoIZj33LrOaYjaM7UIH5g+jjxJc5LV/z/S9P+reMh7a
AgmqQavKAcRFjOgWDdVgvLsFGjE+YELJ7tjuNX6OiFqmOkkNLbBIBf/rxFWCcUrp
uM47W0UXzU7jpGlr6s7qrNoRMIqjHWgGZohKGI/oUP+Q7ecSqA5FB5fISWnbB2QO
JXvMHM1+vxRYtP65FcAyVSZidj1L2ej5Us6hy1vCDoNsBtuB2EhTRhHMHQnFWoX6
6IimLYVcl5ex0L24X8tyvnO1FiD/5CFeBezbvbVFgWtwqapv0IMyKDR+yyy+m6mg
lQWU7Enba6SiTT6PZtJqnnU/OUO/1DeagFCqOWZE7o2cZBTEsNcGMMtoxqn71fLm
354ZisvT92BktwNmc3GGX71vyPSy6iXpHqXJsRqWb8/MYyMlV0PI7B/OI/h59F5t
OiZLnEkqfEcFNtCGW6cxNZ2Fk8kSLB+MAJFvzCOj8KTpFCsg8nYFB60azYPCEyAo
lqETWfjN8+J+ftcLk/8LNB3xCOm50LHOKcrnGji1FQv0RKcpfM8Nh6fxaKMS2AhO
MD0ikiQoLki8oLnRcuheJG+plj/+3CJXmT/e22AM2NDkCOJ/K+Mj3wCx5HzvIiK8
ukwTgat7y9vKtkJL0n9KPf0rt45UMcPchnxFqOKqagyBSnYTuZ1PjSZ2Y3qeRPGa
lnWswdS1P5MheAxdIGmqyv6P2vzmB7KKiM6g0zK6v5QfYQoe1nMlsjorjLAkd16Y
sT/Lu23XGviItQMZOMI+mZcxlQQamWG/Ge7yQPWQtSiUKSxt8CMbfQBFRcCCvKxH
HatAVqZhupa/SGld5L/UzL27KC5t8rSdwbBrgrpQ4JWaXb+VoP28jFS3J0Uy1/Wt
TtxwQXNWCycLUme+X2CroCvcL/CsOKn9Yd0LGrH/bS0JFa7GC1eERNYflaEMX6G4
KTDKNmHixWFUblhJDS+Pv0PFJC1hlgA/FCmrs4VF4U8n2Sfoc2GncPZUHNmGMvxf
PNAPQzaqsuAALjK8ZjlfyJ8Ee1XwgDyKL0EhdkgPoiAWHRkoVDcQoRgizrZIk7v+
tIcVosDVD3w4Jx+2pMgvY7KfiQdFFnvjMOi25ch5PbHmgt4CJ/w7qsfHBJxMQztg
cYYpHXZEeDJpihh6sO4f1bL/7Pp8X06uybL64BMRFgY+jdX0TSzDfaqJnK57Sijs
WzgRHPWXkZfahEWyOOmqQAcoWo/qzxK9O6AKBY9yUjTsTVRpFy3HJTDUhADnK32H
5/MrwBVwIdGwVe2Hr5IrMHIlK9r+GrBs5nyN4STvcJxCoczR9EmDrgVWYXQ7Q6yn
ssUjHgyArwqfgjYwz67UVWYNoCUyAi3YoblAtyOmFKmOGX3oKQHTsDvV6GGeh9nu
bj/od0Jo7LIuZVj4Te9bQvZJD3txLo8pOGcu0SbdsTnVxv9YirDEC+ZjhoX8du0C
3fdRw+Ys/930jHnFFwXNlYvquAhRcjCA699s8DrXrXshe+ATuAJEIWoSrftXlcrX
dp//o+OU1yqUmNd3hsXFkiEGaPgoaI2hA1bUXEyWZhA51YMJSX01NI0WEiLgtETU
pD+rIb1G61bTZnYQOiD5Rkc174mhhplkDeo8/DMHYE7idP1t1S3cAkls7LUrg4Wn
l0sprn57vvAT47lxbS8PvTAbwdbpaH8RyJzFI8GMu20AfvLfsjFwKuvQW17kJeh1
nLTFE/cIjEgLKlG71G7GQ2Avi1FsUfmdr0ufcUQ0gfALDWZwRPQX6tzmjAPiWksr
xDZRaWBc8z3R/idxN7Eyy25oTk+KXyoWEs0rmCQ7+Ujb8Mz+KMrpke2dVPepHwmk
Gzpo6I7+OTTu6QvnE4k3wexwukuXgnBYzpx+Vyi5gibFpRyndf2csOfSsBs1bPuE
oeNjE21aUXsRMs9ZcfYOEy2gYWZzY8iEVwmROuWUjniM9mtsA+0OzOat7llJOx0k
Wwz1wH2KThJ8sdYMMrb5ndXFqfL9aQWYX7+epZ4A4L3SjdhZRJYjG4aMA89oM4JY
0r6bzohOoI9mAT8FT0CWp8SubwSTfc/HWjfbxl2PzmFlqzQSj4kp6RTbLmoWjchM
dr3CJ6U4UtTs70/SmFKIqfArXr5g4Fi3Pyz2TDQ/gv7bdHFWiwlPDuGf3oCfH7oc
oHOKMQNvpBoU9nagkzfJdGLwUNlnyMgiKkuZTcz8aXicMN1Sm+fj2Ymf83YkKQuc
4MynCouCeMUg+RQHx3DjBfDsOqVwsbbh0E7t7PWefnvHC0HA2IrJfDKQkR1jhHC9
77IXoJyFg1rb6gaLAjwDmtBcWzm6f7XxzRhuTvl8BiNZw6v9pQTN4e3y13AVGlU4
UDsO1R/6xN8zXaRPyOO34tBP8XR7posIp/XIzUX/qeYMTkxR2cygDG0a6jE+QdaA
WaXU17acSfpBNV1YrnzBY9u3puqVZjpZ2S6h9wx8GovqEXmBFb76SKPuXMd2APus
q1UTCprrQvx4oxgQLj2IHXQW9B6rWNkzCwKf3/dnqDmxh67KoitrreOUZr8ouyJE
7foFrkTi5fuHjjLQ0/E+V+uuzxgF+ipGh1Q+WSCENrwlb1+0/IxzqZOkXpXzn9Bd
sLIVAhYtI99vdPC93oCegmAV14/bVJOtb0lOfn20D2qafxOqgIROTC/9iFXqyesW
Sa28S7V0LDAzp2SoFpWkBIuB4I42EmeUjdvZjqSzjY2Wor8TrwLp3/mNjcxAGlvp
FAEp/oyP0O56fIVOZ5mUtPlW6WsHd+eVGE6dN98xhZLp2C0Uwg6ixhLt9dS3fHbm
SnQR2FAM0wjbNvp4vAgPbZIj0v2WGDrzqlhEa2/ihX9FM4zAUAjfkI9AKukuz7xp
j8OY6vFPGEzlOssndGTLnf3q3ZwVmPqBlssHQGcXtWFGMM5tKcFq/vzQ50tnk+t5
hqHiRh65qDhZb6XMLWTTezjvDydvDg2Se/egz7AS0w/369xzKOIgKakWlad+zo85
+RgrKfdmRXvpyFVdiWmBOLXEn8PLuH5N+varWRGdSUaTm89lB6wdIn3PTcgVwKh9
oTFrNM7uX9UGVTAgG1JkuF2wUnUjwzVW/f9Z1+uOIPPmZB+EeMA2oCv4dh5SSRGF
1WRh8+A5o/59I99h2RHHuUsa9va5573QJiTZrQNW0dFffbcfs9bqP0Fz3GmrkbEa
NW4O1B+fwS5ZcFzQ0qlsrnXiPSY/voi80+2Ym2Het31znxWqgYjZkNT/SoCYHWUe
L3vvOgsKrhbOnb5NcVcts11haPTvgCct/B7omY50wX6p/ul82cQiIwbo4xxapiuN
jlajH+1v80jwKHRHhyI+ZVAoq9K38exzPXGAXfmU5kXzSYN5V/92ZOjOPBC9oOsN
OJfbGaiClN7aCJIvrchdynUPxVDgUhDQ3ihFxlV2+EZXMEn2IyhM7j/SBRLlV+UN
HhxkOniscvLIvuCs9pi6FOz2uF1JLKQtmgGAFL3cFu1M7mlHjC/DJjb9mLPthtmt
NytNCBczpozAF9RcCYQ3UVxoyOebs3kMDkIdpAHDWqyKutXoWGJm/ZXap+KTMPZI
pXnJQ6N9HAlirALJkxVvaKq9DiZSpgITQhoJCuGUBpEnyoVCOZo7RJ1tLvYSLYCi
7UzE1vZ4UVw7MoWjErC2rNIK8aT3mG6YWDTk6mMXfmzmtTyrzTIxP2d9hS3O15Bx
FcWWrx+2sR3bzY1AmfJgE9pSZWbBrUwt5aUVA+UJSCWqbuC4bw1vaU/gWwi4j5v1
Wuv0//NiFF8+S4bajdb+CZx0eMFgqzbUcV2fF48y6JEiQLeo12wIROCl0V84eHfF
2lF0EFuOgz/bICw24avSfrdBXsGJvNj4bw2v5XtYPhSuanA9XGlaBvNG5LrSmYxA
leGXnm6wIX95sgSuZYFB4P0nGqYpFAaln2Lf8eB2L2oJyqdcqGHSkgYSwcOmTXDA
brJIarF/dXi8tlP1CAb8uxpIjYGHKPheNpT5xAriSj3cmlr+wmVOfmBAUJ92bQFK
87LbK0D2k0sjMOJUxwRsqRmjl/07VOU4YFiTlmx+LSucsURkwj5ITYk5TR2y8BwG
uA6f1wiwgI9rHB7DPuaijP3yBxrabTjCoTGTVJoAv4xjj957t/1ss1+w6zNpf54v
nlQNY7Twq/DGeJ40j5TfjqpY9yjZYF0s0o7vnQzdsK5fUZyCLk3RBNDEGw+6rwSh
xnbMzc7fHMrqdVOv17D9NCe/SrZST1Pb2kb22rTy7zPxEoGfvuaA+8qZGWsgGj2z
ggFHr3BkFJETHKkx/f3CTj52sGW0GZ8KzC7obxPrZu0JbTzu2ix2GBtyl4ACyR9b
GlXxSHSwmQKd1eD5fE1DHoimABjJNnMQXypWVSv6xcC2Ol5gLxjxsL47uGBJdrha
wSUN2HzsirFhFcv/3II5hYXB3qeJv0VuiAiHAHqRxIGbgkQlYqWbpwJTgTp2A7Q2
upR6y8gGGmwhjX1Wno+W8feRT+mGMlt9izKoKcS+V0cirAhXxOs+5q4G46WAO+Hd
lztUS+O/8tglkSCdJLhH5+jBGwRgOEifgJ8CczTPxcmr8B9vqyR7zWtZAMRiIOp9
ynM59uArZKvKrOVVpD/Uerdppg1m+W99DrQCdm4mH9ZyHcbO9BQyENw2dV1XO5v4
XjnYD+IcYW2+yzWU+CinNrRJgjBvnIGQ0V3iYBAeo5tyFeFpFQ6ngoZp7CECeIDz
F/NnS4YAD5omW2mnMf740xxJAiOFsrLsA2jjTakc1xXMxB7JIpDYsMVj1o/y1k8q
kQetT9FRF4UOxpwNV6X4WWpJGeYGnTHVCH50/Z1x9l+mbvBYmaYp+LLclirL6S9f
lQ8q0vWMr3TlU4ebVA3AMKWeDikRunTww8ND6gobzMp6y9OepRT6ja78kWgN9mSS
0z1au0IuFKgYI3R3cB5mquBc+dIBMeA30+KSsq2g0Z9EXJsBQmVyFORht/cJEnTw
8kbRiHuKclx1zCP0tBQ60OnjugJx0lN4PaAXiN7Yyre1OGqIy0j9xzyzOujhBXEA
WTvWNuiZFvomUPWO7pswB41xwUFjORsX2jcpfiJpyzcd6EapVtqu4fDdSqcQAa5+
rY6smbY88GiN6BN4WOime84iZTbfKWPwRer8mU7zU5DehZAN1mONS/VPQHWsOYXL
GDF/Hzc5dtMGrXpcE2YiKssTZ+GVnI8W7dUSiucqnmWOWOjXTZOrwqBMVs/BjlP9
B85SQygjriO367I1PnqXDqxYvcY5BtEL+gOztpXn0gX8Ihtupb0BWG4J9zO2mx/P
sagZunnZdvohO4zferPdm2qWNWJDCS6Wlpx2hHljRpFm2Qt0jAp4Rq1BrAyHc2QC
9FQoD8/E8T7Dun3UjPTqfDna2gdRYj2d0SixUttP+u4WZH0WiHfCLiExO5tNwBbb
jybp//5EDzCYxB+i6zgugrQdc8iwiUvxoq1G2o2cuH0t9m8lPo+OxWWaNnBBlp3o
TtDJ8SbwJ01z2dqCIo2SZhWUXbWkSiuMfW0R4bQeFWwxw1QQ8Ft2yT7md0UX/UgC
hJgwZPJLD9n2b+DsL4i+RVmv7dpkjF0Wm7tSQOs2CJwdBPh/pxNZqGaueufpIJrN
2f71SSh5Rn1szE83MkTNwX+zh/xlSocLhxTTpjpQOJdPjsE08KPPdMIVm+euPUlR
LdbMFmlxNyCIXDAaYJww3B4N6rIxPhQvASUJ3ZjUVy9N39TfOb3i8hYuFHfJ/+bP
A3CzGXYKh+RgJbJCjwVFem4UpTGqOjDAGmtVIdmggcwLaaSgI6embza3rZi2BzWL
+IHkvvfEslPy55c2D1ePeSQUILsPVfMDoiT+o7walMGP10iYkzs6dbvdJNUbDMpr
8wX3Ka0i/6y7ZGG3X7gWdfv9TOLlKRui3uTYJoYNpD+rtk/EQp2NoPpat3zekwkx
k3GaNQ19cJsZwQYTC/9NHnuKXDskjIXfthrn98p5Vf7Yqrv9J60uspTWNJ7JxaO/
9Wh2JIYrkxSDQ6GS/BQb/B1BnALlG7MjzQyddryuo2bKoYx0hxRWdlujuR6oS3W0
NTFaeZvQ0pAwn5RcLCrbk3jRtYNp1OTJHj5gsMQvNkO8ZEc/+hUiTmM/4z3rtIRR
5IpYCCF/XoYtnkS7LPCaV7HQyw7kcNRmWq6d56/sDEbY7kqNOlsoQmZsu8eKNZ2y
9kHQUCDxhPxkjhZvJW0gBegaQlFvcC+pi7hWYfqHHeeguTVhLWdD7w8JCE9mwBl2
JJPoDgyBBbwg6O7xoJN1yfnOw3sZyOQ5l9KR/6kalkD4ViuTwgyruW1VQluA8R/X
Dako+DvWuqlXIEWJUSsWKgYjBScXMZvaSJ2ndZVyNh+O8K7NkaxhXxl4r5HhuVf8
hHu9bU7Va+ZA7B/9RschGEyeU8etw65/jp3PnOlLSWl7sZDcEulTPBBRK9vzP912
y85T5elfmkVdoiQjfyzbBzUTqJuVIx+gn6AFmKRb5ICtonMrUPeP/cShrap/5UKo
S7zd6mgu1x0i9hG03VgKFtPBS7oINFWEPG+D9vibpp9rtmU/S49SI/4jUH3VAl5K
7UTuMBv/+Jr2v/jswo7QB5TRf7BLBHyHrmXaADiZhWhrGB9rUgvxdpFnFLpEXr/E
HiqBpIWbanfj1cx9Vwvr/bJ9GdHN9G9IkP02KMv41wnfFn2oYuH6uGn/n82199ee
ZdWaqZnokvSuBCqEd+W4Pdc0MSmo2pTdR4AH1O5XGKgAOuyG9go7ic5CgNiMQupK
NV0MNM4PRCUIWdzCN/9ALPSas1S89jnlxBl6B9UViKLKuSAlPmNud6ZF0mhHfLNF
WpK8Dj0wPncLUAn7XZ4SGwJ/qHF4cZ2KXW/qqTyp08nGBLD4YzUNwKMVuydr4ZNC
/oV0w22QENS+4rQU359DNwb0q5J4iqU3RuDkc7OiC3pnzFiWvCa1AKi+0y/WwtkQ
aRIP2w1fT0MWtZUYTWPGROAJFUBTUTKqnDoNCC6jVoVoGfbhMOeH3MVf0Y/t1M41
/ju1O/nSytZEVCGBafhxfWBkhax5TqTLb3vmfctXaif/bWAzDYRyzh4IboNMWw8V
U8MsqvTQYpJw20/NWk7T94NMUVrSAnx0ggZUeQznGIozYp/vrEIdYl4x0wGhTeXI
D0aFRSrcC9s45lFznuXv4fedxyAU4LRXXsWNADdTodYrDtEe8RKHo/hjUIRDQ/BT
wuEaEAoUitjpFebJIG6TY018QD5zRUa0imwXsDy4obV1Rx6u/gFGvXbgIP4I6H23
MBzFhbRn14IMosf8vIVKpBYUT3Qz4h2Xaw1Hks5HmJhhy+jgfAg9veC4RZ902TuD
ugCZHjxtbbm60lEliI4ocFXfi736X9LHGCa/pZsHsEbM1+upU0FIAaGBO28BOB2O
GCGhivoIgyjlQykRMa7sDC+gsaIo3ot0FZlQ6qvY7jMn+4cHod2hCdxoJxH6RpDY
3CJdQkPOBS1lqK/tfgJlsyQa7/dP3K6wDF43OiW8EueWgidNLoI6dxoex8CrcQNi
/0eghwdg2+UbFDW3YSDm4CMFITXjX4bqiB1nloBLbnXns6Mrri2CwTcW+qLSalOE
wGuLzD0nSajZeeAfKaJjxCJ5xBi+nAUtisgki/ei3Ad/MZmZWWeoYkzSyAR/62NI
pNTOKSrlIjPjdlROZ/dih2ojQ8kkjNojQH4H2NsxCLuAGDsalKLb+FNSc/0Bv8j6
cr8iG0Rq1ZPvD1RmDy0l6zhnw2H6QGeCb8LxkuDjJeSIJCALilBuUaGP6KkjBbEk
p1EsEdnBPvVw9by7pRSeE/FbQ3gx/+CY74nO+OMsnN3V1ZBbOPVvqCnIS4EE4/Lv
9KtsiYe4zKO1Ex5qA1fQ/HDnrnZ2Lpq3j1JC/sRY1ljKJFhuz6KmRUerx4Q6VWuC
cNpJMrU84OfIQxQF/2554yzQjeXJcgwr2m9frZSSIXatqlmsdL/b6AySSsgjsCwN
SOpdR0opSjQ7J+oK0LzZheZboYSAG5JTSjTIBv2GhkRGv4RNsTAIoHSu+hIRfZ+Z
fsS4RwR/Yx8i3Z7APNu9IXdoS/Hr6KKjRAgHCcAD8/7KxnUcC7qSTcdJX6otUMEW
GoldULRITbSiDdsNXVK317s45yQdEDo92IoGM7F6y70ltR6Es2me+9J4B1RDFBZT
FmaTx3r4pBRy3yH7S2xnkA6YlusgP2HvI5m9+/6tFS0XTj0hXh8eM8BcM+KMDOE0
LorhIA+x3AG9LNb2prqJiqZV6HCkNjYJW1Cp9rh2ydmNOSymZkDy2nNGQAnEDQLc
wLjiEYzXRlMPSdS2BT2uRlLjmDYikv6UsqMwJ5FtkV+Mmj4gAxUc4wnbaN3SVpMU
znbM9R1/hAkLTTf5MzyWj90DSDOa0+O8tco8/ldGciP5fxPuObojrOeqOgmhlPk/
BFnm98BWGuY/VvmS+t6ITxhZ1xp03g3tjfT5TmjOJ+B54TXK+4B4Sw+mp36l9Glh
j7ZI5c9Srm09Zs8LzplcdDAYwTK3WgXa7hCEg6hmVuq5lFrow2BBLaRyaxlS4Hu2
C8WZRzwCc2HufHDMJumE2zY3RDl5wHKNcuDtv02o1B7ar8ppVsMbH/M41tFyV1eE
qT4uo1knjjlzpMI67t2uuvjE9DXDUYjd2TFuW3ODBR+fIWbvR6Fng6AisSWXwpWl
UWk58DmfvIOweoyCcfO7qu9TPzk/PoWl4Xf/3FpT1zbuQzUg60siNEekOJVf5SHh
iYG2A2yU1rsQfai1Jt/P+/MUMyuNR3dWwAe6u1b77LqBxOK0W/J4+TNmahvnsfDF
UjagLRkjOT6POoiC6PGTIAm0K9oKnWuNDtojwtlcixDkPUcIO/YIOGqIA902jbA9
SaN4e/nFRVKXsUBJcU9GWw8ezBKrHdjr+2if+DbWBNL5Vjpo0gAz6pMKARkCuAYL
nkLNQkvUOu+OqWNgr2J9DutLAAZdkpbct4RHA6dR5l6zFKZMMGTTZ2AT0LOwAMfK
x0KCHnGP10zKKrEIThkYxOwUI1oTFWSeCDwgQstxldqnEJcEp5rd9xLPibe3zjFL
kLwml5wDAtd+AI+gKCBLQyvSOjLxbQ1l4dNpSz6GO5JzM6uPP7PCW0yQfXIYGhHs
BaqnK6oNUd1n+/9NnwdR5UDgYRjf+hXBBk4DlSHELO9FupDvUqP8xyZrG6yAJLAD
4HashdU8mD3q5XqeQhnLpgZeL4nVenk8nm95hTsaR9vI+lJBu+HmsmuWE4w+FOJH
oJvc+tnNFaNqvPXHL244mpQkkMQubOJFc81bXcDmxVzbCjbaTnc9gyu7pglXdhnp
WOXzSq2wsjo8RoVspN6wqj8coaOd8U5WwXobCTZwBSkbzctkn4PYKEes6ZNaxXQq
Ux7H5qN1ykvOJyIL4TK1dTulcSW1egTiU8hcoy0riWvgeEooizQFJHenpjRCyPxW
FuoIgHj1TbdFN54OqY0vtzT/wI0icmKMED9/T8frVQz5fOOp8YGnO/ywpuOA4gfO
A0WfKMMID1EYKTDS5u9Y4dgz7OIfTmB2hyZ2AK0ZEgzYRp6SfEJVcG418eUjX9jF
Vn0v655mek88dJus+xnqF+YZSJZe2mnVUUyPaOyzoGmgD0kDYDa+q1wfu3RUdBYc
NByDasbYUPvzGaEtuyfAVVhM4BsuXz1ClTHaTtP1QqMWu1RGcDFPJbxirfROCf10
3OvcLASCljko5lqq4GVLEP1mUti96lZT0/CCjF6NGl5wof87LrMMDA8jyal0fu2c
c6UWsq///FBwCoiRYlOKDtvD7jujYv7M8vI8PgDhHDQHlgcxHl4b3o9Ki+5WjciP
WNH7+OFr4y2BbAEfljXWtYz4d3QIE6jHW+sZAtLZ3DTnmxVOAD2Yv851C+G8BA4M
zTo55uAju4Egsg2UNQrAFt/8bHLfUHmFkRo2XgcaKJbDJvHrt9oljPoUcskSMWLU
9zIWaJ5muyqd6AL7GBRSEWxPtt+tmKiE1sGzmfLrIKzk1UwYTIpyY1hJv4cTXwyV
Ga+UaGwVsnF+lsJHUOtGLNHMnNfX2gWt9CX6u5oqtV8oohL/pYXsQ2Y4D/k0ILeh
8jLKfSSPQHIWaPbrthn1i/p++d/Msj9L4JSeDqAIz8ihmvY19FCKlBIzUkYyQG0T
Yy3D0SDRaCvhkqiPy452A0h3ES6fu9taCBLyAGEXQ/DVJi7jNfYqMsdpi6Ou6y3Y
mQsNiVQpQJYgWLvvbzV4VaNN36KCjYsgsnvkluGjxlLfhXQD7w4PHUfquaOXHOIr
K54MNwspJR7uTwTLlq84wCG3BCa/zqiDHZ/gLRbBYdYhLN/Wy9NA2ue6Vf3hXe2u
caywWyyaUFHxx+8XjxR+dVB1bbpCG17QmrVXRhk4u/NwrWM13MNjDvgp7EvaB9Pn
pDgC/UAf+6vy8o6HZ8Fx69xwVbuz33sM7ekM17vtGNf3hLiA6LhxgDIyLJawCRs3
Yq0+fXl7UPCOdA5Vc6rifqLuvSEpcx2A4uU850XWAhS2RU53iBv4P5CfsbWf2ugo
XSrxAK6VimlffPOZx3UFxIVDGsVSxLAMilvTHjDZswB4KwyNYodf3n39iGw+L5rS
h4otD7luSkJcYwuil/uMA0WisZTWij7aLRyVe0TvrdpKTqDf+j8CkzRG4ett9w1u
WiUYPbMqb2ZtkS3qWJgn6v8yBaPsxdw83CxnifiAX9tGlP3fG90An37Bt3/Qqz5g
Woago7DYf4ROuYlYMaMHZvNsuFBVbirVLvkOyJKhVuAwl8NR6B6jBots2x5r2Z6v
CclVHXZgsDNnd9r6FWzZeXUXeClCfvTH/m57ws9b2XglNkIjYxtPekqOnA+WxS+W
yKJwYuLg7zdRO0FnQJy4PL10Lua2QacL26F4S/36v17tNZFHg8QmBKMW9joVi7kn
Bh3VWGtCuylJsdDTBJvcpHhW07CZJ6MYHBkGg3oPYL1sWxC1h+kxyGEr6BKgara9
xtW5C8Y2Z1rXrdW8hK5s30sdnyXcUJwGmYlHuAn0h8whguhmatjzsfv9jfgcdadt
7OEZwZLibcT5OvVMYGdRxzAca7Vz8PhMuJANsAc2iYGbnnywaGwIdOm+LX2qSrt4
SI2aq4NMcexolLU8s2YkxIZqTZpN4PRfBpfxW/fzcBQsjnmmHKlh/S7d3uON6knw
KFlvh6IOQhWNYfrA+wVgPRzqqFpHIOqj6jyOOfTvMmI2UA4TWKxFoSlBi7VwEigY
gnxCGuGVZAS08UhRWmcXrVlZiOiQt8waS97YHnup/+ZDGY0qIGXMGAtZ13mHT8dQ
roMgJoIwHxiDPGnJ4799Udu0QQ8NHcQTd3vH+HwBpZNXjgDaSI6+NrlOfC9PuPby
M6PUEcxKkVOdl9fuYSIPhd17dLWZ9055CujWmouU09lN4alGKIBhCdeLIcX8PUTd
yqDBLfHrXnbGn1YpKgLqsK3ynledvpAKoPj5Cxd9/r9ICYy1pl611jjPyLuqdce2
2UBY16ThBQKEW1wtioUJ/32WwkelE1+15Yw9Wsd38fQ44nzWCIeqvwr8/BTF/47i
+0TUfz8I2T+VfalmAZXj8o4MqN5TSyq1xZOjpd8zDbehJ+h04z1e9llCHmz+z4pZ
CFjOj5eW5G/y8aEGRYFLkz3M88gJspobAt7vZY4y0jkbB+VpfB5mUbz9L5SpNq8u
wqpbqUS9b2NGrqO2h6jeiy3xM1vuSLWCb4aXa/n7yuHIgQ9RWRr3EDGVaPycBHA2
ixW+YyQcLOlBK558TBbcBMuIt99HjU2ZpZaWv7K0wIlS++AqWwYgK+UiRxxwiYtH
yAD+N+hxGmry/ryDOuY2Kie+TzNj219b92vfYFJcHdAWPklRy1Vn/k/EgGtaANTe
MOquF9LBbFUhyUb8z3vOnBFBMi/snmYvEZKed1fg40t2m9r9/Qkjj8xIn09G4OGI
inHJXuhSpdjQsFwUXoIkX2Cev9CGPp+RiwwZlpdJWoYTPD+JautsKzIDdKsNf+gm
QeafOpLAGmxQ6PhLW7NIdbj9GQFQLP2F6/6eeiKotT8hdt37psWLGMKxx1CT6wML
rNwh95Nf1bGDH3eNrpUy3FJbp7nTaux20soMOisN7wAy86aRnVz9Q4WwhbH/lQDV
rqjyzPRvOkELaW4r3uSLpEqTMKNoG/IQH+VGQZq/NsU/jGp8IKbI2EPDYKMXitVs
7pwE3yj59FOH81yV+1H7VnhuIprLOmtOX2ozR5D6etpCo47av8qOmSB/UZBeskIw
mMJFxt2d6eLSmLHpazSHCJBdNYjarCuFTqlFZ4KsynzcxuvkyJIh6kyE9ZwSNgxp
Flb9x5kVlNTdBUye2D+AkAkzohtQe+emIsDDMg8BxLQQaxIjkyhJJ6QFvSOOtMNC
LOEfXJsWS/G4zwcUQns+ICxEXdlhn83oPtgBApt2Jo2klZAIQa+xTERzhzTvU4hf
+CeDlskp8c/Kw3ybjbGxxI3150MgGnQjgsX2h47pLhtjwwEdof9chOAligSg2HzJ
c2CnaE5OzUvvBpiHd4aGKVDGsj80voF34AW8M4G5/Xx/E3ywlojuCgV4KmM1bUV3
8tPr6u58XJrRa4i1EERMYm9yKdh8+WdYDOChqhXbZLJBuDIZOyb188yebnTFOXPH
GOVoEIZYT3Ux9WboXyhU/IfELBL3EHWB8Mf0HdX4Zlctvptrpffqp31K713NwKal
vUNqSbgSY24t/xw52XUHO5zpRNvacCXyO6km4U6B1VwUr/Q5bferJc2OHY4QJgYN
8jL2CwL9svI11Ujd4kug7vZhDLTB/D8cwD+XyZd/SOV4nNlyjtIInF6uE17ssyY5
esTNwleEJzjHSjHxeYA4NgvT4/3uR8EP02sufTtuU9NBLRKb/BghouvqKbOt4Zwz
8lS6yGKMvjyfEMGLJkU4ZMwV5gUbY7HlTcMOf47NQQtMh0S/7csWUenpEOrezqRH
neICTzppyAf+sKBqEARxXmq+VnuFtbRQEyWaetCkHKmyOeNH3f5V3HxPuki978k5
nHDMIhp1kBS2mt0B41DgqxaJamBV8yrXehG00ddLCYKoqcqtCuUx/FSV+uPuq9o0
xB8HtKnUXbn7vO+1aEWpxOun9G69JcE5iGQ15MNURv3vpjMnblJnH6AXJOzvHI6n
ED+Kd5lzz2CdWQDjqWcV4Esfl7Jcm0IPVCXDitcU+bh5iSdLxziuxQ2pFy+XZ0S6
bVOl577V3YFeof8i4ZNNbMsbN3876RQ/nupHcdJy7TOZ862n2HvwqwjjdbQxXFL3
fmWBD9EZSRom6ddHC+5L91VDPyDhmtID7MqPK7x2/aU7pUFDHBaDFBNFX/LgeDEY
F7fV1tyie1XKO6jlckNdRbsWRoCVCK9i3RkGQiUMWSRsYAmWWBMDHAYHJrTFEpYz
raPG3SGxy+8QcZ6Q2JO4PLvSFcevH3yVERa+KkHiNrp0Yllz2HpRu8RjVjEWivbH
tJFEUGFAx5RFk+/dtmP3cnQOv/Z/jKIXn+ZjdY2Cn2RZK6UftymMRG/cvU6jlAb8
kDdFE3x6Xu8ShnGrZp3KSn2E/XB1AaK8QLc9wsqAfVrCFi4qD9SxkK5xKlnYaRxU
vtiRphBeBCCnHt54plK7RnxB3b4WM0MNLlw5WRHnBzs63xmFkCTA11AQ4epVu38V
KykIyDG/eS/URfEpe+5OdehCr7KOcdqVyPvDAGSbKfEdHEbjgNLTbPGeAkyZkf3X
8AUKU+nPoFplhOyqXbsDAlWvz/X5dh0WV97W5VXj6B5RH87vZ+ylKlQhnsWaWgUr
45+7Cq8azzADe8GADf4PvAweTFQi11chKe6Q7ziuicCr3tUGxR8gUok++uTZRCrU
GMqEWCD+3vcVFF/vbWJ07FoFqxnCsPueZI8r5RabCfpH2N2mNR3601SDJD+N12FO
/VmGOB1iPKrwavCVGl1wreCUg+kCyo6hMKiepLQ37XNVJ1t6DVpc/nHxUxBDWXsd
F7+qF7yDn7dzWhg4IyAywmem6flwHuI+fHGhZayjtUAahkm2w+5YClL4I8vFd46+
cdks8SeCiX1syM9P18v25Jkx3SrSMgUNGTcOkFabo7fsUBt1R+VcTOKWYF8E9PHH
0TuxHm0OWSsZNlEQ+gh6nM2q47x7qfXX+CC99rZGLCnvdLBRMpD6Tgm4kKU75LyY
tThTkL8QGWIzsbnGRL5UUrUdc9+JoMTIBhqMNUQYG540nW4SRKtNVx4cf0XhNVf3
zQYYCe+1q3e40d7V9l3XRxD6/R3k53qQNTLV2juvIVNFttcf0VJOaN7Xrpor/V+K
e3tqIu9Jr15LJVp78ZSY5rsFDQlnx0LQEa1h2O58tI6Pl58uaSbQvptxWxu6Gdwy
LLIeCqsa8jePdSHV6/HKhkSnJjfk+NnxfPuDVQzcDS7aW5lKUHh0uunz3QlmdW4q
bD3PEkOYrZfS55+LUB2z5uQHRlGJYmzJqOPT9w8PAEM+YuE1ysoAS7X3ho4MAP9E
pv4Qo/UInkXefbOqSPsWmAhYjLr6YlNRVTFcnxh7qZGCGkwcRSW1mYZOqMKcHJHX
U6Mtuti1Z4oxZKxAjV1PLPwvjqz6RnAuLcakNFIQwNR8ceROu4NVn6C36vfZ5knJ
fofCmO3HA2ERR42RQt1OQqX6sPjAZWCBD7rypLZOEzMuD7MB9XM0mTwUWAfOOVQG
ttDYeuER8yQb/+Cp1vl1sdMxYcrURpK1pQxScqvBfp14f5RLugC7QrhYUY3+N4VG
FcyoMLvJ6qFdIZXfBApQXoQgv9ChIcokPymIpDzbBMEmohBgJWJD3YPfXa0PZbji
OLTW9aIg80ZhxanNA6wn6ZBgvF400Ty0umE06/jEr/oB5OHnbL59yBG40nXSvKD0
7xdEGF+eoncmcrP4RiAzem6l62ZfEGyWrUL7XT5rCESwdEX+MmsS9mfpNAdJhT2q
2yHBUXxryVNiRHbUx/3pjBtKAh01QoDhewLtCvH97TNuKUlh4/HNUZwXMReDl8kA
r8ABt3HXyV8fiLV7vF5FN3PySH9rv9vNePaXBu0+3Gdsgys/vYqH9855PGyK5xxu
dOwBJ8lc8l9lyWVkTm90gif6gP/vaMd6Yqub3zjA/JuHkHPYlHsAc/9hw11E2jIK
FVAcUbGpVjTeCkXbl1ASIDeLQw6CVFJhBTwU3THCJ/YLzEyF4uT4L2pRJt0Fyrhz
YTtdqb6ZyhmCCxZ5Hy/A+hx7fS+M3Eif7YfTw27CsHDpK+IKrw5ZIU49quD0ARFv
iluG8Vjn6YR7RDxocJMVz75cL3QhkS0U7V3xUdL4JU4uQ4LEXU8WVHq/XWa7E/6o
YYjb6n+OuOdGu54KeSRIQ2+FotmYqVJuJ590QTsFL3S9si651IegQXcKl4SIpSeZ
ZjJE9+40dzweQM9HNhHVumXKR9v/PXxmCRU+eUuxkkt2uHBZxlWfk3hipr7sJORO
5pV5mcgLEiOT/mAU76SRIn0o0Y+IsW5BIML2VXwnHuMyWj/2Ay5hd2AHN2aoTaUv
6hM97jAXLoW6GkUFu5V6LA8xKZy7sZjoSyeA20wcxr7iVVjRXLL76C4v0anmO/df
4baiE66LVvtmF1IYIUgZZ2jh2RT/an9sStcP36ALtG5ERsgPjiM8vzmo3VChyerR
W1CkSyX6HLF15fZrejHV1370TzX95XWY8OGcPQrfW4eQ8P6WlBAafPRY/Wk5S+OV
DrZoNLkC7sh+u7E8+GS1qc7aosi2JyBlhm+YtvH/GgH91JtCC6VUd+dJAZ7vydGc
hIulmYq/1UQc7wr+piK8+LaoIqvmcvibC+z4k0mBOAkApKwgCGK80ZHyDPfY13kq
KND+35/qzpdDd0MSLoFprMoagb/fJq9vOapYnmepbz50RDM6j0p+JDrtgtTFbKd1
y4frHHDzB2mFcLLpGGzqFxR8/FY5VbfV/jERe+KACMyegWaWA8azULCk5Ei0LFqI
0X4AuRWFSFqQoOviYh/7cNfBW0aF8bq8UZPjWbuf3vR6bR7SKz+f8Ka/05L413hI
zdHnnoXbnJz+LLJVWgcgmcTkRXoKdt1mbcSEguJTA2B+0jpYelFj0trjCd3vqD0H
HS0DM3ir9C34gzmNxv9T6SusgmhqEENNjMjYlOeVkWz73KQ1uTT3IbJwJMp3nsD8
MAtnURXqs1AOzuxVm+Gm3w7P77Wu0zzOPjPfXegttSpq4HRS+uOrZ2ju1yvcOeFY
F1thWOX9lZQ7BNC4jheXywQi+CcPWq572cRET3y2Mj+ssjJV5pR/iGw954mOnI/b
Itchqp0jH4yorzAIcAzUNaQ+3ppvFeIlX8oPXm0ZImA7gbneIsKfWFYp1e94x9wl
3DbOXqjpnbMXU6fyrx5vCiZxoiJkpvA3aRGNdV023BuenOTd+/xCnl1OSM/DTO7v
deSx8FmIgqxRBSxSnZodqr4lU3z+snK5QnbmtGpn4tBkCoYFUWAjxJs/c+nKcUMX
e6gMMb0vPmcl/feAuAqv+aiYJQ+bcjUGyxw7wZHiE5jzUV2X5Ri5dW1StDvUs+XQ
mY/bfiH1P+C+tug7mB53LeSXYoIEqrJ8M6rx+Lg1NO9vp1igZK1Qb5Yq9U2ypg1y
CiHCDWOWFN1tj0JJPXSs6lXpFlBx3DPPjara8DJNzRn6xKuORg9C+UCBN/YUoY3D
lgwK03QnYQ/Ilw/g8mzHT9olZYwOx/SOJgf1wSGP4g1MKSk4X9IxpVTYVtEJ8UUT
VI/0DroL/IPdRQrl6pAsPE7Mu3GhCv9LDa7pNtge13lhOVmqAFQfARtDRkFYMbfJ
eKyeVfLVMslwUb/V76acMzzq5iKzCSr1YYzC2ZwypJQ4QXLblOWClXNPBScOglz7
MS7IGx7W1qzgALYpjlQmEM8B215wEoKGYdecIewImRiYRq+qtzPotrXZ7XBFOIOW
SxhQv+sZhhKLuKJDqQ0sv4mtlMc4gDWAqJ2T0irI/Ld/PiAreHYKZzxxeVKZL2K1
1XacAKHgPPGcENqVoEXzsGCKVdL0e8ogIRXlrfL3bl0G7wF73Gx8YDwnCnWnLIq9
DKih16oKUJ/RTKsKyWUuD5jG88rA9anlOohuWW0uC9xv4v6wk2yLN3yTQm0lyFbh
G721n8iARI/tvbG3WMH2xL5tOQ5RnJm3UgtAnWVOv2roRV7EQkxs8+Xi1PMtQCrx
NPz2Yv/ovtyPA1rF1PQwck35GKEb+8rOqMQkolmZSh3cMqzdOCCUOGwUoo8H0Ffq
fMDyNGxK+8LQsfhRBHhVvaUEQVZ3NHfcryEHo/IK9RF7G/0fFNVa4A+g+gTQ5Z8n
L+RyplL6KbrO02q4NGNFm/pLzX89vz/3+TFlFS0nKEkX/IIRM7g5kNmeBfzw9Hi0
cWlaepLuUnNjwn8BqHrvOvGtzZ1hlPMOQvoVf2d3p+hrucc+hAyMrRogMqMxfyD0
Tb9AknmynFjqomYM5cSJnMgVaZTQkqSee8qg8sQBDRM8ygsDxF6ztSdlpkpt6Sk+
hjeJoj9NM9dwAIBB+jQWEGwbyOn2On4Dxq4Ww4iF5LJfalJcT+EmSoACQvc7w4AC
DVKym2Z+S1rvvjqqR4q6/rHHnVVVJeYWCmuVgn7wnkgOkaactWQZmeler93teEyl
iNOPU5IYeKpyTP8rwT1hrH+gnsbG+adb7Co9/IR1fyH0IvFmdehbWv04zt9rh+vC
kByxmBdtdnMBe4qDezey2vz9VrhSX2+NQDMbIE3kCv0HqgoHlSgqGNr4MQXMN9z9
Ex/ZGzU4upKm9xSg6/Ji3jQrzLimUPVhRgmi1YGo9ts12ctB6JeSngxJaFkovu4h
TrdXFsmJyQKh1fYbLMK4NVRLX4rsGREM+1kIKwgRP58+vmh2mLf9kawgKYwagISS
NP7DVc1iROY650CXiCiIEXFzmXMyKMJmrdkSKhPwgkdorjLdCS7L28Jl0NOINM5o
TTghDA0LgUbpOuK/UPYOptKCTQ6qT3loAGvt1/l0DDeq2o0uU9wzald11Ti3A2JN
oAnAmr7TZHDSA0muaQyMPBFDxrmcGOFfs8ED/iqvPavUGj09TbSL/7gRONud5y0u
umpwvC1D5thlvHszwOT8HRtF+rexQEwaatp3VW/LdLD8xwzTd+ywSLHpsyg6vnlw
bo6FaXyrN7I45exfrJxy8OJ4/CKX0umwZ9Ra/rtuZlssVU8olX/oOHKXugjsZF1W
FR4y31oR4dc5R/XhKf1Fk4t6OdftQYGdFOEdce8MN39hArnO0N9DN9ohKDGKDsmx
O+dC95dIZObCDs67GuV9ZWA5wHMCcuGvwcWyDB5cWZmrAnWJ3sIubdTiXDxdgsyB
mow2PRyXgRseDWZ36Meh3XoIccrimG3fdW6Ybft1gaYhioWgv38kS0wKJA3OLdjS
puDU/FipCFh4AKBz65lYGVE/7hibUghl3y/+YsoxqqUIe/5pCu89YCdKuQWv6pRq
TqG3KvcDYKWzojW4uSb+OvwVqPZYm1t22825uQXUlDBZU6pyZtq7nsmJIFlhOTc3
1REuWMI+KV0CxvfVs+Q8MyhCVonPKmWD6sB79+13auShqSJ/UJQ88HhKj9qdDhIG
P1lVQs+fXrrvrcRJrfKTZDskkz3dm2FgJhwEgBXHViUF9krSJ4BQdC1Rh/+wcJjj
ICyPdSwHBd1hN0QGS7ZY06MXBiIGSr5DZsciGEIOgTm6jZVjbJ2ZQlEL+keGgkBl
AX0zNBkXPiqearGqLLNjAo9EY7use0T+HhKyS1RlEKXtRIR9/p7nPJLBBPPmNC8f
3K9P+phHAb4nj9/cIWyHHhOj4Bn9CKz9uAKDaEE7MaHFq1poc/5G/pqyjQHqoSKp
EiUIiPZBNi6UDj+IzNzFb407uZO6hJz5ybbk4UnOmYz2+viIu5gCCgHX7np4Fm1j
JUZTYR3XEMcP7RK8OfMQ23YOfn4Hy2sPyJ1dz3vxRBE3eb3d5ZECwuoePqn8x4uX
WWj4Dz6zHaCe7f3E2Xpr8hOUXZ/f/0p9AortHFUicI2qLX1gScNMuTxYEht0DPow
Xbb3KtS+VtI+sgIxSzVNydi5ILHtZqNMWPKAybCdIoNJ7L4vRIxV+RP02adX381f
OWJcwnTGbK3rkQYQCKqxiXXvTxQTIY7X3QNEOx6DbeBHWRatbPOAkfhzbEngm+4R
JX8LT/xUloPHUWStQcZ9HbHMxEmKv37fh34h/my5sgog1uRQpfTVy0fjmbqqXK/u
MWVebka5cNWj/qJekdFV9ipUbOYGzImGt6ZuQiujJ7m5fd+mDdkYvssLHXOZzXPW
5h5olvtE4Lw1YLXPSrYWmDOH+FFOS4NssuU18RUqQXAaqX9FdTwVCCxaAJT2xLhJ
LvVItbtTvQTvhF90wxB9Zibix716bT1la8UUkDupjv4ZSIZn8agyH29e16IQniHh
3FD8Y/5q2H8brVfC4QqZXUtDxfYvdy3dwkXfMMYGmEemM5fto380h82L4K7kweUT
M5sULwpRBglyuqwUCs0OumH/TSl3M7iQGKCT4NB7YhJFfcQmr/v68vsEIZXOH7eU
6DDSKD980O6QMtrU/4tJM9zz1rdMdob4mHbi7mJFQqY2yXCfsl1a2FVF3f+KUlBR
+U2kUFXGbfSY5OpDgkiVOy0UUaolsPYnWB+W9u6Rn5I71pLyHfJLImBs10iuxoxl
wfbavsJz7GKRELv6EP8ppfTBKV6By1w+dGQlfpKufLITBLYX5G9+fQoSavG9hZRe
uMQPAr4+nNA9MKXQmXpdsQ4oIRoGKxxTEcVh8/UmcYiJnCj78xFajNQFH3iqIZbW
fNYrdbHNwmyO3i7iknw4iOBOha0SafmyS9W/QQCCS0jSPvrIHJX3Y+el+XIMj8Uv
hDmsa9FRg/qOujkCoKkIoEN/lgZCjHPX8Nsb+qsyySe7K7dm4ikNL2gJ/GNecnf0
L1OaRE3Rf+aV5s0T8dCf+IKBUyf9VmKAvxdsc/Dje9HsSNX1lPmlc2KFnmbvyiHF
p+rInXff11hBjsDgO5hlXCdaOCrLlPJ6JgwLtVv0ZgZv3QoyiyqMfVAjpJLwvjeH
Sz+lZnzbTl4e9BpwkXzJgDNEauimhcmO9h4SmNHfKqd32ARpUvV1MUovGngW2f5G
eP0yWIcBF+OJjXz+JFOxbsp6GgFLJxProQl5/emBDqo4CTMCTwBW+B5wJte25VBw
MZ+bAHp7RGOmLO2+OkKp+vjaneiFz1HmHd0LSlgCEoxbeANVqeY8FFcFL85hq4Wi
+agwuLiZYE8fCvTFP8m8i9jsnqOxl2F7b5G0lkvUUKKVc5Saj5XWy9hQm5UxWM+v
BIp0TmAnYSKcahJQgOjn19AJyYs0z57hdSW932qd3WfN9QGZ0EG/R8DpD7qlO8Db
4umVFPKpiWQ9dk9rY57sUjai3tcsPlrG/6i9xAOweS64fu0qFl/Oi2+wO2cpKo25
ytnf4e+gJK19Xe0idsQsIx76zYf6H8JBnBkqyCRmFLQxOKUyHezDRyPp6qUGRjF9
FT+9cowHmVWbApdIJD4eHt076JQ1gQxUT7berHfDNgsKJIrB/J1VPqaDeoE9257i
g57d4E6JYWJ/5rBJLk2kFA974nFeqbur5EYzAKusExfKaEOyYkJ2jjzlkUtUuQXX
lLwYNBtL3Mgq8UEC4hmrC7gMmesAV0RnSGEVLJqTQIdqGxNUYh3d4Hoq5R5LXW3f
yYT05O28Zcdh6Vwzp8fJA4AOwWpwpV8IATlILT/4XMW9fCr0UHL6+8hyx34Bn63M
L/t4Z6R+/nDEoArzkl4N8r8JpCiJC7SJBMefEF3Ne3wFxgWAcEyL9UlhTUl57kca
hMAzbmQviFMLTBuizhWWeFaHjOMvxYmXqauu3gq9fbBEgiXw+TOqf69npTp65ZNR
8X39rFkkoYWv3DPYWynSppGXfQeWKVxLcX2v/WmxOoNZsM6WW3MM7atowlgaW729
5ncUL6QIxMbLaLTFb8x0tFdj6Sc0lLSuvDKViIXG3g+Q8hgpiziQ3w6IODkq9PXl
VzHzLCJCKSbbvStSOd1ANDwo0+kEy0WigGqE40ngq0AOMXBXVAjFGjguLZv9GcsI
XaQ8KM3fidHj4K3YCcwmjdWN68eOgP/4dA7Ai/FDfNefBsawiFJnVxDw7gaGoyYZ
zUp547daK6uYTJXW8fYVqVAgfqDDRO/ECa+8kHtns1y3HS6Uen0ydlGuNwaSzTlP
LTE0DBvgrnUBYoTDicrD4xPp1UQOXql3A8yIsQJrT3hPHzTP5HSCDuuMqTLtCn0F
RiSVeLazkjk3/eydLLCiOSbglRWdi5F1kA9cSGztTA4k0zCtuqlzNGeb0ZVaXw0v
ij5zlm0UvS6GuD4Cw0OSuWsgyTZmKhhN6eE3jhkuc4jAbADuTeO8U6rYhZiTv6FM
Q4mLF7UeOg1lgv2cctSaXuFE6inPtOAE8SKY2nbMx3MFYEuYY3/MaG9Rjtz5QM6/
8jZ8qgOkhxw7UQOVPIztO9YJLeAa+L2KLD5EiY/jEZh5sNhAED1HDDfjjCuzC9yw
/A7xGhwappNPHtSacpk8Lv4Ia30g7PfZ+6YNFVy2qXbtOe//hgTYt5hwR7i52oot
HyZtv081gxWNhuYrUU8IyncK7Im6mrfZgrMmz7qpfC+sG2JyFTHC35fAiMibBtwY
e/rYaDW5km6RuN4HLSoCJVKQtK//sqB3foIjgjI0rRrH/ewQxQ3WzpnmbqgYqr0/
1SQ52p/XgBoeVsG3LFAR/TNs9hQdcScttsTtvvzpB+UyPEVbdCW8zhDiijbhrI8L
EWneqc0RKA2dyEhP9Qe7RAdXktus4z3+DOa0H3vCIgvX+qilifuiQ+eWcw12JqhM
SwW9lIt1bwRV6YujQLUulV/aOZ+733Ha7J4Nnm/eIUbDd4EVQGbq0bEkK1e1JfnC
mfTHblxN/MmJp/rPEBOuhfxShHHw7x5VtLRXFp/pZYIH4uBBnCp6cMS2E99AHB6e
3V4Pn0QM4iOGEX8VDGQP6jjLJmd5nRS2GlM419mbHBrdV9je+FK3Fl0/IrrY20T9
Jed2imVCA5Njl59dN5WFs53+MzaBiX94B2MDgRB+XQbjtxmOBGaZTrwpFr+DnTEY
WdBZODJI0MPNKGVjdTMeGfkeUaJk9DJ7RnZrZ8xVsizhQ3kyPjdzCwV8ZeNpnNZU
rn/yLQwqiitYLp8MRWH1RRiT9GS2FWQlpoMV48xCMMcCHVhtrXrYhs5b85Hn8Mt8
FlTew/bwe0zgdomR3O4Ie+4kC8dip476IuKAOvmYaGDXjCvfFh2RKYf8/D3Vg3Ei
v9Y3AUUDebmCkzuZPjPuUffwCwYrcUW0Qmn4BEhd1yof7lp2C3hZJgQAFrrOT7Xq
cwYrPmJ7Lew9xEXHoPUdZKx+Dmy+URJIgnHDx+wD6GNdtwY7Ydy8bhL5TQ6aMsYY
VGx71XfC9KZ5FigLw1aCYKgdfSkdWDOW2CDEJiAlclI1vrQtOyUbjo46r9ubFzrH
O8wALqP0fruoa8DOYpH5PgmHD4tJU4HM+UWqKZ8YQCtgdiO3ciZ6CPPAIIAi/CH1
VU6xC9R1t35gzB3c0WbLn2w0ui00Oy/Fj5SepPFvz4W7+qVjYN2AX1S7JTJywO10
Ejh6FCAfDl7aAAgoFluAxpx+HhYP2OFSQMYkE9GxdqghViitfjPwqeZ+S3OTyEuF
FalYAqXaX9WpkzD63pThYOqg4LreHddNoX5V8g0FUCjNnmb/RnnqT/LloXd/qbhQ
J/7WMZ1tnwcOUAITaAk7DYksUmKGS5HNDXhZjD+FVS/SxFKLaPOuXgqE8hpCys3c
gJZhUrIoKKsdEx9N7gw0cnZ08ME66aF8ckCGXVtOK43/X+NeFjevq2h/1QiO1Ppd
rJh0BSSfJeLRJVUTJ+0z++/4SQmgNa0scaG6GggbWvsZmC11A4gyUbvjfGFBgy+V
gwdwGoPubs9vcOVArHG9lQd3/dKQNm1Y9DOz1drhAcdJgnd+P4llFolpjNEdzWLs
FvQmtpxA32ToMnCz2+1muscXAXF6ARDDfbUB1sK7kdwzYhCsAJxnKgjOLSCUFj9A
vue7UW6uItfs3BARpKIMQvepv6VWegVC0GyijZSJuU2KdxkSTs3FBie4F09L0WOV
TNopvoTbN9ddqGA61JLwHQLudPZPRGARVwbAULFwkunnbXeZUQBVLdoFPXpvCPR2
Vgs+jD4/Wd+N/4oIPuBLXgADy+NM3xoFJWSE4UNE7H0E3axIpOMDjAWr8/Ph3UTC
S3G4htxLPOh7+xUSiFNe0N50Wb0v4U0VH9MW33B5azFMD0fXoj3ucsIQPGx2N3sU
K044x15UaMYMbS9c+B1QpfUm1XcRMnt12U1k7s9jmiLRm9MjILwpmIxJ44CYCtIp
wqb5DuNJdZrUnT2TKwLpcfyL2UizCh7SHxcRHINLDBpGJYInDpBRaC54Orp35r5Q
XIN7iEZ43ygn0HGthBV7DBid7Clto7sgzgqlgFHOQJxHJrlx3VYS6zco0nwzAs3Z
cUwMSUoU+mslf27YXqOLe8ErwG9b3t0UJvxJzcu1/aZYzLoBfysA98Q0Dz+xCD0f
Cuv//rLFloNMmT6iRntBNYZPgMLsrsENAqAH9j/f4f1pJKo7m8OnhJXbbpVyTkd8
jpewSbcxI65TXw/XUYiiSdA/cB9xs+GI6I6QO34VFMNbV2gKX8MLt/M3yTUJsmSD
02kOAxSpH3xAJFAodHEKQekqOoLrad+lZG5aM4VQ4oUc0fvlqxvsKXHmaOtdzxL1
ZvdwECdLe3lUiYSL4916a//IZ/hd7smjcKyGSdQcREAcRc68IQOVjxsVYrw5AljQ
UAW4P4om4EZzsLSgwER/6Bsp41RBljeVsYGdvh1JbQKzH0Si9NmXjgt4+EbBbTSf
fcMOhc5fPTokSfAEwgZcRii1xYYJK15qe3WFDhzqf+2uVzROkdvhaq7F22roAeEW
YhE9xoRdNTkP24utLgCmbTJcGWYurxZRf6If/VscwXpY7Zuvqm2tq84aSTso8h9E
XoMI1z/9L1Is+x106tRcaHZrzxpq9HIjFit3Kq9wYwT0KjizZuLCnu7pfQxWkj1Y
1jjBQ15hyuP+FbO2IZboYyN1fsn/hNhXKRJegzUMtPlpTGHoqbgh35m+gN1DqxJz
`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
SxG7kQvzHF/h1vtRsQTT4wPQE2WDfSODrL/js+0JY2f5V8x+WnS7bUxTYPza/VWA
VVTvdrQ8bwZpG5OoGltRyiXTSwMbk9HEr9P12ACSIdWGA7LMwGD0Hvf3+1YqZcHQ
IN3rpME8bcalx3pkjqwCRoahcS/sg4/tMR9VOLwv898VegQm5XstxwwVLL0iWa8Q
G5jPh7+y3nAtLtB/IepsZKHtr5Azw1YO7WabwNlPQqU37eFM8/wa37KfKm5QPI2s
xKMXspMm2X3KVISsMfHqkI3z0trA6tcLb26FuxwH3WjmgBWFjFxiByVubMsP9ykh
+fs7+2LEUSV0Mx+yEn2vog==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 9568 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
bJoDSvu4NeC3DmSBeT1hJeAL2tvFpo75lr9GU+BtE8GSOfxsTeP1VhZSmpBZlRrA
84CwRBoK8EVIkJY3OXUF81tPaj7Qe6nEmsK/3HsVVgDU3C/f4rcChZ7Rit2LTnaC
AbKLfrI/xQ32vKTWHgzLT98YCQQUzskg9M9ck5qkQR4lOcCTvT7WyzOXXfAvrYFU
rlebFlrz9ZY5BBHEj4IDJp9vYpMpHSIInKM9DteGmce4tYy9UXTzuSWI1yYvK4mF
wUD004n7MwvB0XoQlcmjIS9Vb61QDDssWPf65uqY4nlwjbpXzWtRpTGwOyj2Znmm
gcmP3cJBt0oIOpEqf1m9Gg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 3440 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ns
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
Ib4Lvyu2DYa6TeKqbiAMLrLL93cmx6ZI/oJKZizxC2eGS9CKvm4ucRXyHqagrIOi
loYgshlJR+covBOhHCA+hrjcSVxskrmPdcVpFXHoQN6rBb7YDOE0bD8Q9vlXiOgr
6OfkkIVWCw2KBcRuWpRtyTxCXATJvBP1NFa0l4tgaE1MymlVjAPPLdEhiu5ZsbBm
Lo+eCOjKpav6eMcduzt56nFU8G7GxmgX52MxG6meW5ZwytPRcEezq+bn0syYgvhs
LmNtYwwGqW/z/7fsLnKy7r9t07RGwRDi45qWyYa6QXGL0MdLw5R1rcgSq9PtKFYi
GqXC/izwdul3OwDwgmLcAQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 27056 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
NrVE4r/ZpithOfop6/XHu7+D1oWzVg3EIQUqUUlsPIBxRcg8yEefx0aP7nSCrgen
Th2YCxKoACfM1r/bedZkYrg8/g+cNbELYF/y36cUi+CrfFsfN9f5k4B+OAKiZcmS
3k3ZzaTKy6+6Gp9/QkHP3ATmIhzK5zfnoEkxIHmRVSdwWdtypwKDouKNtndpJG1M
0ECVrFIPyD+FYVigjA3D0NAxqh/xHeVNzPT/axmuMiI3g/MHtt12nxPfR5Kc7sjS
dx5vU2zvwwXn0fvbOdlvRuRCFoGaOYlPp74Rj0B4iTFQDaOXwBFu+KXi6FI9Sg5G
7q1vua+qhVom+Dw7r0Xing==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 24048 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
h8/KyYlXhccdzI7hirn5qAaFuMjsWz6fRj39Kl9iJORzD/3hF6Z4Cg8PDc0O8paG
R3ZylKu87aUwz7fZab3wcFgVZww3o1or307los+Gu8x+go0FWBlRimgQIsgf0kSp
gy5mpMAaWihDux8iDwDWrLdXFTybfy7gDfrcTlNqkoNiHFc/2nxQrWR9wMW9LosM
5MqzDN0pVRngbI2Km0jVf6tHUfJFciz6A5G5ZCo0xizLLjmoJhHUeAIfc5bqNxE6
Tv4ptzwfCd311jp8bu6HKD4bMfyBKnwveiZvLTQcExmx2M5bG7E0C3gp8deXTeCa
Hfrv15zYfin2/tVV+ezh7A==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 9952 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
fkOWy9aIPMeKPN1Y9xumr4dftU3qGmhTmk+EBc9kTg8w/wwKqOEndNAfvvLva5Y9
0UtB7RqRowH/Bp8+a8VdPxN67jzgIAHdDJRAVe55oc/DKDjq90aSUb9cVc5dfKa+
nLqQqqxGOJwVgGFxQ957vy6czuppSBqS4Nsn21twVC0Ah5Uvj52aZN/Wczp2eHsX
850qxYpdwm0H+xdLN7nlqu7CdVpDhqyExzbilEyg6A91yj30uitYtU9Yx9CffHQr
Jt+tG1hYuhMwtFHsHqoYl/Q3Ko+fri7lj+DHe0Xy+pXmGXFxcLQrfh7kawU25Iwu
pZq9MvnHcWBdKqw8ABlMZA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 8688 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`resetall
`timescale 1ns/1ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
N/gcJTr7NGypzL5qid8R624vOuDVmjr1k/Hg1jsx5XtfBy7QFLWddnOCLIRIbyro
lyAyegR/3xFM0pCqZtOFDZHWAXviVVkNQ7Pig4v7k3dAJWbufPycEMsPx9jASMtv
ujH3fE0YvvdtL8FTrZs/mu19hipV2gvnb4u/5btw8c/k6x7GWVU9q6MQtYvCxao3
Bsrm8rz9FBwCo+MimgdvmAvuEWp+6bACR/Z+fl8W8iOovg9acG/YDpTyORNOW5jX
FDIOPA4FLs9cMaYsq3fdPxm0cn6Low+k1JC/wMxrnHL2yFYHVdByQ7kdT7LISeU2
G7OoC2YKG0HKrq8snW/SZA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 656 )
`pragma protect data_block
GiKM3wCE68y8R+OCVaectGfe/gCuEe3UlALAhiO8jLLT7AyAfH0MjPuDB3c6ALRH
2FfMNO0y00qVXqVxHTKH815tTAWRWd6tu6unR6HIgexpTCty2YipUXd0wdOC/uR2
kJbJP+F2PpiU1AC9P47pKJsupaji3+lEUem+5nRhfox1yQDF0X8EnBA+SicmyGCt
/lermk+yUpxfrZMuSScTM3WWiNa4955KPDSHrahwsPpyAsiteYlcDAR52IPDrc/2
74kntneMtEs4UJHoxY0cvyR8IEpotK+U0f5Wf7tvaFThrkZB8sL3TIvobHJ4+ur0
E32h2J4sfY3z63yG9GpiRC78FzpXYfqES84CzLEnkW/nwvSaPaGWttQnvKK84mgt
e6hsuRKEKu9g9XF9m1zU2nepntiKv2JC3Dxv4knRyKzBeRE6RZ8GCL/pOoEz+amy
/3B3jlYo0zcDMddHCfZIdizABreu7IQdLIabll8OuMTKfLzg19/0oJBjKW1IhZh+
XoVFfooJiavWF5A85I2uRRRXpYxGorHgsr/dSRgi4t2FFwRx484s8s7Bztb1Loi1
KwSDVNeMTVG6ejrvyTBaQ92Ta71PNYYnVT551bNXsS1zn9rc9ZSd0Q31IQWkPSoi
FVn0i4BKAvDrfURB95ylit6HenWJJaLrtehpsZdlULNMXVpFwBna6t+3LgFsw3Lz
0kd1foECYANEpbd1VJCpMP7WgYUREFqTRxqFT+anlIWrYJyt4exWho5pt5oUBupX
WWQO2BfgMe1LVL4CWcWJbQhlX25HouxftB+ZHjXh/rFSBY7+4gF94hlw//brCsYZ
PFw8de419f79x29zwy0wSD7b7AHRHUO6JkKRZTHaAx8=
`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
b/+2IQUB2XJduo6QvCuEYm8RC9sXRc4bUQ6jqeFxdFkbL3qzjHXRNZCsJaPM0uoQ
vt1UnqFUmhoudvvG+Xn3VH+yM3fAb6r6NodQXgFLrdLlaGe8xDv3FqrDhpD1ZONR
HIQ+XIYssJfhn51U13fBoLnSHl4IOFO+zPdAUqzDMpP5aXnndRAx5UWlKfVIbAju
uPDCMBOX8Dt3rgx/agN2LIi8yGW0rp5qHhzQ1BqeddNan3ISmS4S+n1FJZ2U60ww
Z32QVdWifMnWarVbZ7QHi7yFqxabNKGdClhwik8roNVqdiDJo4OIPYXHnNHqoORD
hMfbWfiVgrRWbaWZamWzdA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 13024 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
nXR9pXj63cfQcdCFItKG2j3nI3Ph2iaqLZmo0nJVkwxFBXv+Bg5YXojTMlQ5ri5N
J3B+n6TWMDCmQ5I7sau/NC9v4hYBY2AZ8ywM5S/kOK/n1KQixL8HBcGS0C84xCjn
0DI3LEUKIu88fMUrQucrLAz49pEvg6udSVXlgbMNrU3XnW7T+fksWtek06KwFsHu
3Zg9afNr5ADE0DVVr/CWV7azFCL4CKZ055mKtu+zhhOYPREDT1qVgEZm2nWf8+e6
OhatHG8lAf69Wa2WMwO+e1u9IZib67ZyrI/E26wjLLcRviIBA1TPh6IsOxNsdyNN
0mXPyxLG+vplbrV8c4sqrQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 544 )
`pragma protect data_block
suEtMs+GGsxerBWmzT3ZBoWCPzrHdkhKS0Mhf6WIg8eZrD/VuC9TozzXT0Alns1c
caz9jWIMynUIHqo0r5/Z4N2G06x3Me/h7WOIltv9GI6DWRwPciNiX7Jw3nhhcrOm
eW7BVNEH6+hS5liaMzyQiu7K9Nad4zSSQAO/QQnYFYlK3EVxNa6PWVEbw3rHnHKW
1sFoTYZMyi/DuELZGb2Ozcli+wIbGFMonvnd0Rw4KF7AswbmN5F+0Eat0zajPFeR
evdkyobQVWeC2UsSABzrHYrXKVCNsKyyqqy2hVqnRlu7E24k841XVQ3o3Cl6WOax
KjvAUQnILxw0ZmG6dXh30hkXbBopdrx6kJUQ5XedTnJlOD7ev78o2kh59m1GrBvQ
BI5kIlA9goaGr/v1IUEdVzZ9p4D0f9qJuTShTtrVFSLiSB4jbWBHJbsu4f6cJa+3
1H1tVv5TFCoY1XNq08GAFRoXKqx1/hwb4OfnXrembrpB+TEWybkiqBFPvpWOIxEd
Ne64VVh1JJ72udVWvYqcq66KB5YALQEoVFfXcPJTunikybFTz5gwVsiER0A08QLP
MgxplNbLTYBLpkDjp18i2UMZsSFIGSmrTB7ayOj/NUdibCi7wV2xsZ15zR4aeB1H
1JpgOW1d4kTADQe1Y7jZtXumKZaoKlKSugux3FYDMw5E9t3KINvMU98oZLY7ZMi4
mTGdIfU8yQJiG2itMqpz4Q==
`pragma protect end_protected

//pragma protect end
`resetall
`timescale 1ns/1ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
VjZRhydz8WRs2hEgjo24zYjvpweHF6u8Dlhh40wlTnJRiKYCkQcFqg6zw3i8n3vD
uV6XWDXTIZmaWYT1aKuiIDpxEwET1ZojNw7dnwPOGKhyWP389fXd4aExeWs1IBDL
dNw1flTqaOpLvNdszcGjSazBylsZetqAoDCuQ0vD3K6I6QYJx6Qau8p1X4c4BENU
gWYfjSwkifYnNOxisxaXqBzuHrUy2x4neaqnAPnM9dcJeU5HB+N2SdgH+vRj0zAd
Z4VpubKc28kOKP7nFES3w5+8wW5LEdVghVgirJ8avL2etR0eWNFAoChoCH+W3noe
Me+CYxX2Nk77AYY4CrPpJQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 704 )
`pragma protect data_block
ml+wo/NouVuE+iixsEa3RbDZ2Ab/dCy9c2xfVCZhR14BmnVvCHldLJ2Cb31VtP4d
7AbnEMStA5SFFER5XlSR4SQL3jTu8CxEKGgOeZTjQFkHErg3df1MPEQ/8I5dAm5n
LTkXl1kI1Hfwx4vY1ZD26/vbCv/gyrAE4xBafPFVQ5TFrj9wbuwhiuuaV45smeED
dm0TTFCJEh06FnmftCQdMYOqS9FT2dPJDEwli/uvUAyCTkUa9ojlAQZa0oJCpNxZ
QJE00RWO4DDHNMFNqIHelfuqorjVMnFD5vFQEaVrgFs+nE8ITJaMQIqhvTB5x10p
02rJ2S9O2vxThuWkJHFjJg7apRS/n5X8mP+g8jWOfKVJ0wUSCmgp5n1rs2mBpaI+
0M1KMcz0TTVU1DQKD0k+MjbPW3ITnkHwSBYmnMiA7uz9wVY4OlvXiFjYC+LLV+HK
EQzhydEGy53o4W/dsn6gfASQ68jTwXE5iOAylS2saYkD5YziBGP+CUqW/WIXmTJF
eCB/upL/zx4+AOYRWrcNUW6xLQsUgzPekEX3IQvL3bPvf0H3IAMKREHdpndKIenD
bD8H78vrF08brS6d2VxpdWYmJZBV9KoeLhVYIPxRYADoPUmpyEYAZggNEen7FE43
9eo9249j/NY5J/AAQcei9iulUqKN7NIVKKgSixTRS0sZdgB6mChEx4ODD0pQ73No
O1qt4nIDcJGE9cOG881PbCqs9oINYVR0pJloW2Bp0bSOGzh8WXCZfnUHD4VL1h/p
L6WHyoqmlTVlkVY32by7i7X0vzxiRUGBfFBKlQaPHdeRWXinerAIUvF+SOAlmKk4
myu4BGYJaX3u7KhyxvUIKM0Z2M4O0PSvzoERpGZFByAgf3NkL6+AjrQyoudqiWSA
O4OgvLtypoGUsm1suJiVDKptpGMjQ0UcDSXQH1ZKEv8=
`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
m9zGME1JL2LKYvO7Jd5BKl2wG02xQUCWxfiTpsWX54v4vemP/FDQBjKJBBZhqIVx
jja1i4ICEh3XlDPnvFA5fL5b2AouwW2cvHBmAk9f+Wu3v0M8cA/nf/MGqfMszhG3
TjuvCZS+6X8JLFQCmSZMKGbysrTpZgsb40dY8slrF/kKmSzT1CEh15lBqPhCz8Od
rrL96kBqmJZwGXXSdcboTfc5IdUh6oaOvaO60gVH/vF/jspiRwHdqmItusKxSN/k
ZDGUuDbcbGCDS7sL+tkYrnDoFH5vind38j4f4sTcRonRz9fZD7MTD8auoB4402Ob
/9ZKE/d3yFtQGxBGFaXejw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 10128 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
TrP5o+FMr48jt8gei+jAkcMSCj0tMI7eulEROzluN7VClV+bElcc1FNilUX5xK9c
dZfFCCLQ38txfvyFItC1+39jO7CblqML1DEH12IO3YtdA1BUzrDjJ02QGZ4Ewpzy
lIf/vpZP7XWk2VK+ASMpFmIS02HKmb8IwZZGiiI9Hmz1Q/cAcO+Ik7S3d6JttNYt
wpjj253WbmV3Eimu7l/llKs/C6Pt8/6kWq07vsLFZu5UQYcOzz5W2xhgdy89Nu4q
rhKVtjRL4Pb0xONQRidtvTxTxyfSXoIaHSumPz24jO+dWr5uwMpxeZVBZq47e//n
FhhZv8/AfBQsDBM0YuxBYg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 9360 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`undef IP_UUID
`undef IP_NAME_CONCAT
`undef IP_MODULE_NAME
