`define IP_UUID _mipi_csi2_loopback_design                      
`define IP_NAME_CONCAT(a,b) a``b                                
`define IP_MODULE_NAME(name) `IP_NAME_CONCAT(name,`IP_UUID)     
//////////////////////////////////////////////////////////////////////////////////////////
//           _____       
//          / _______    Copyright (C) 2013-2024 Efinix Inc. All rights reserved.
//         / /       \   
//        / /  ..    /   
//       / / .'     /    
//    __/ /.'      /     Description:
//   __   \       /      Top IP Module = efx_csi2_tx
//  /_/ /\ \_____/ /     
// ____/  \_______/      
//
// ***************************************************************************************
// Vesion  : 1.00
// Time    : Thu Mar  7 09:55:39 2024
// ***************************************************************************************

`timescale 1 ns / 1 ps
module efx_csi2_tx #(
    parameter tLPX_NS = 50,
    parameter tINIT_NS = 100000,
    parameter tINIT_SKEWCAL_NS = 100000,
    parameter tLP_EXIT_NS = 100,
    parameter tCLK_ZERO_NS = 262,
    parameter tCLK_TRAIL_NS = 60,
    parameter tCLK_POST_NS = 60,
    parameter tCLK_PRE_NS = 10,
    parameter tCLK_PREPARE_NS = 38,
    parameter tHS_PREPARE_NS = 40,
    parameter tWAKEUP_NS = 1000,
    parameter tHS_EXIT_NS = 100,
    parameter tHS_ZERO_NS = 105,
    parameter tHS_TRAIL_NS = 60,
    parameter NUM_DATA_LANE = 4,
    parameter HS_BYTECLK_MHZ = 100,
    parameter CLOCK_FREQ_MHZ = 100,
    parameter DPHY_CLOCK_MODE = "Continuous", 
    parameter PACK_TYPE = 4'b1111,
    parameter PIXEL_FIFO_DEPTH = 2048,  
    parameter ENABLE_VCX = 0,
    parameter FRAME_MODE = "GENERIC",    
    parameter ASYNC_STAGE = 2
)(
    input logic           reset_n,
    input logic           clk,				
    input logic           reset_byte_HS_n,
    input logic           clk_byte_HS,
    input logic           reset_pixel_n,
    input logic           clk_pixel,
	output logic          Tx_LP_CLK_P,
	output logic          Tx_LP_CLK_P_OE,
	output logic          Tx_LP_CLK_N,
	output logic          Tx_LP_CLK_N_OE,
	output logic [7:0]    Tx_HS_C,
	output logic          Tx_HS_enable_C,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_P,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_P_OE,
	output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_N,
    output logic [NUM_DATA_LANE-1:0]         Tx_LP_D_N_OE,
	output logic [7:0]                       Tx_HS_D_0,
	output logic [7:0]                       Tx_HS_D_1,
	output logic [7:0]                       Tx_HS_D_2,
	output logic [7:0]                       Tx_HS_D_3,
	output logic [7:0]                       Tx_HS_D_4,
	output logic [7:0]                       Tx_HS_D_5,
	output logic [7:0]                       Tx_HS_D_6,
	output logic [7:0]                       Tx_HS_D_7,
	output logic [NUM_DATA_LANE-1:0]         Tx_HS_enable_D,
    input  logic          axi_clk,
    input  logic          axi_reset_n,
    input  logic   [5:0]  axi_awaddr,
    input  logic          axi_awvalid,
    output logic          axi_awready,
    input  logic   [31:0] axi_wdata,
    input  logic          axi_wvalid,
    output logic          axi_wready,
    output logic          axi_bvalid,
    input  logic          axi_bready,
    input  logic   [5:0]  axi_araddr,
    input  logic          axi_arvalid,
    output logic          axi_arready,
    output logic   [31:0] axi_rdata,
    output logic          axi_rvalid,
    input                 axi_rready,
    input logic           hsync_vc0,
    input logic           hsync_vc1,
    input logic           hsync_vc2,
    input logic           hsync_vc3,
    input logic           vsync_vc0,
    input logic           vsync_vc1,
    input logic           vsync_vc2,
    input logic           vsync_vc3,
    input logic           hsync_vc4,
    input logic           hsync_vc5,
    input logic           hsync_vc6,
    input logic           hsync_vc7,
    input logic           hsync_vc8,
    input logic           hsync_vc9,
    input logic           hsync_vc10,
    input logic           hsync_vc11,
    input logic           hsync_vc12,
    input logic           hsync_vc13,
    input logic           hsync_vc14,
    input logic           hsync_vc15,
    input logic           vsync_vc4,
    input logic           vsync_vc5,
    input logic           vsync_vc6,
    input logic           vsync_vc7,
    input logic           vsync_vc8,
    input logic           vsync_vc9,
    input logic           vsync_vc10,
    input logic           vsync_vc11,
    input logic           vsync_vc12,
    input logic           vsync_vc13,
    input logic           vsync_vc14,
    input logic           vsync_vc15,
    input logic [5:0]     datatype,   
    input logic [63:0]    pixel_data,
    input logic           pixel_data_valid,
    input logic [15:0]    haddr,   
    input logic [15:0]    line_num,
    input logic [15:0]    frame_num,
    output logic          irq
);
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
njHgVTcI70XrvAR2hs2PLO+gOUDUnAzRWLz+jxyCqWYEbNAhNe+ILq+RggXSKYdc
2qxgQLxzIEnSi1NT9C+On680dtXdf71NshA15RV6lxJJjibxVFnkUrQO5rpQTaAt
/hBaHK8iE5dnGhKofg2bfcdZZPU3svOGkHboqM5EIqKbE/1Ouylz+vyHrz2hB+7N
GQvalbEmb2U/83oWfmobU121zB6oUWnNScYVENFAaB+fZLLASuqJ2jDWjPGOLw51
Oeey9pOOyjUv/dmwp070vVCsmLOYLjipEZK6eFKuxqKW8VL+Ux/8jC8OsjFlxI1D
AXVj75CAaNa33Xfk0tOHVg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 7648 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
FKNVaNZ6RTHWn52nXo3FGV00I4zCdEX0xvslQdTtQMFeFSAuzi5szpIOg2AH8N0t
HN/0HcF3aWwLZepdmN7gHBBU8mv3eAbIVusAZEwa7ZHYOXzvFbaOUH5F92hZeSyo
H/6Iox01oad7Et6Vpdj7XYO0NUZk8PTgjY1A8D79GRSmGVrF/naWOp/36f6u27js
DOAYiWqriXigZ774KQR6oSHw9Uq9o7t16qIS5bW4Q7bkbdUqkU1Aj/77B7CeN650
jJu+y9LGIPjGO+ffVNeGloweq38cAyAs+FZ65AgmSdd1nTQcvFbDHCjwtoEbu111
+edFp1XTzwEfuQ1ALZIcKQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 6336 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
hd8rV8j7S3PM0oY5zj7gobJzgGoab6oQXUfwwvM5BBg2OBIGkfEnhjK+fAgLrsQj
4zZEPV044EShKK4Y+3vLv+Hx66ScD9haMjCN/fxsDalT0eRpZUiZNePOji3dKEIG
/QbAkJxwsXvIwLsfX5wQ8XIdLD+sENkeNW/DxFTAQWb+eVjl5r+5ximeWM+799rF
tKWjW5xjH74WSA3+wxl0R1eUtxmFfrJf/UQWEnq+ES0Dl1DFQDEr+FfZME6nhFHZ
xxZYnfXFs9fdCQpxqIm3qFCAW2fUzId5oFSOpg60dMXZFd0kVKwyXUNGvlL1NqcO
TqmQuQoVXCjInKeydXqfcw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 832 )
`pragma protect data_block
dnTZ1ZqQd/LY6yEuitejpG8rbynR5RTzuwMWgjQ0sze7H297YhicoQOi6gY3fh67
RxjSXw1/ThCQewsQrgIpSoM0PGqm2B9nznELr3mFhrM2Ol4hDBLVlLUQF/awg1pd
4e3vjTMlaBfSKNp2ewwOpD7QJJlKKmVxozOJlEnNEZ1ZeNCupEHND0R+ujleFdJ/
XSZruIahWLDZxVJQ+UhSxRAfX3/6jF7bpzawK8Ms2J6npv7yNJMZzoKZr6UBawDq
zrRCglw/B5+m9bn7whW7ZI59YXPxi11GKxKVJBe62plKON7SvZd+Zo+WUU6FCw5a
7NHYaj3mZSlGxemc/3gjV6vcV8oyJwDUjCf1FsCzjfp0JNtMFYMgD8vPjlW189wr
8xwC3YkAzDQg1Do3miXPzaoonwMaydDwL+WAsCmPh7zOpVTM5ngPdWL1imz1l1eZ
AKivcJ3lVibxn1RWgcEuOe20KeaR11gimZ2I8QQuFMH9oGJw5WRNkB0PES0ARV8w
6ZcFk34OwoFfrCevic/CrXYUZF5W2vZa5VfNn9fVidtcxgaDD8wMrrJxMIUURhup
npqD/K9Stwc1WqfaUBySxDMXesk82AgA6ldVaMBcTJ6IFi9ZvbM8yOw1g1qoahSr
oqcni/wyBspF1/XHuoi7uy5Lm5v39yKwJyLhpNvFQSAEn9W+n4/AeUy75xlB29T/
/yzsUiSRI3VRILfczl9kb7334oh6eskb7FnWN6+gAsXpo7+k6S/K6OvvwLoHTXlW
azPHDLXie5JZvDz9I+kslGotzjdQpV84qPSuTUN+aMvlKeStIDwi3X3Skb7tXlTF
9SG2qtQ23dttJlnZ038N+lkcq/dd6TGuyf/heDPZvsEsvda8K959TUJixTj1cKDY
rBdhIHPXGqocWYP8YIpFVoW7HU3bGNvphNBspsFNPV/dkkj8NdRo5G+Ux8BeMEdq
eXMjyb+BbxiQ3Ul9mt1vhL3VjuKhGOBplNDZZmLm78FTm/pVwoc5GKqoXhu7Y3Mg
WN+GB/g26q7PogNfauUO2Vad1jyXdyCPrvUaL0Idl8QbK8zlL/dLvPw8UGaiXSTD
2CGmlF+teJA73tSSErRfAA==
`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
bTCdPrxYz6BOkb1PAgAKMejKAK/FAvnO5674FBK5Mbu5B23YDRf63yXgO+i7Qw45
LMenHHU7xWr34JG0lT0Cd946f9XTAUkqbRr3HLrsSUwwFiIfQgDFkhFsBV+dgaf7
E0uEAq3Lpt5i68SDkHKPEQTTBfF0KJQuuoxelvCiUMbaDTUDPpCJ4KZDLv9pjWBB
MlaJ4WnXmOdcwvi0aV2+AQvwUp97bxZrKc5Q6xansc8nVSw80HXlUO2tbPoZQafm
1B3jpXxMV5v9NkbzyKGM46rAimwxuws58JjTVz9WBjYQGiaMqniBe7/9mLOjyYuZ
CmtYah1XUXPwVpwOWx3zKg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 13328 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
h7NtJn6tv/49D1uJxOdrQuOglRNpa3kvfxrJV7N6LzHu4FwhWMjj7OSWOg4yqyqK
HnvAJ5tE5bTm33gymO+0ruZ4VNnWwsnRmdJ0EUS+ENJ/mIYLage58n0dHWpLfnh5
qWKo7iCVhd7dDZzGxd3Mq5SBP9sRXePGSKyDFje08WhpTAvIUSE/mIp/6XOx/sGP
iIWgwtsy/czYeOL1G5tgkyFv35jHXu8nqbEWa2CeZMX6F0y/HJfSspdDGVfoi+mT
jhiZMfZGtKA27L3p8oZa10Hz6rLlOlZc3xp9FlsdUykdEWtuoVwOcIrQ87oIS0RW
FV+24/w9EZ4sr2hJ4JGXLA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 8800 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
dDPUR9xi9UQh9utPkBIed9+WgD0n3t0K7nemUUCy2/fEE7+0JtesHBQ4oNilacfD
3pvjRMSMyFK6YlFi7Xha8Y1ToAk4EzZRJVQPBLCrcr0s7/b+9YhhtUptBlBlP1I3
wnEM3DzyJZZZ02uw//abj3TqohsVsFFk4Md8cj/5TnxAwG//znnzaZVF/WmzKUvD
zXj89INKsy9j8N2xVLF3oaq7nHvY9w95g6Z4D5epz7Tfz8DfhCfVCoFx64vkpxoj
+K5gJR4hjUgIk0kupa3HQgz/5EvL6vtAiHaCGlk5i73YHltXT6Vm3DkWj24kB+/S
XfFvIhdNgNvydbkinXYstQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 7408 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
IDIfsbw8WswrFIqolXR8pE2vNWoWc6g1OSw6ELaWxUNO5JvLfDvB4zYt+W0Bp4ac
h9BQyb6aukqTC3dQqVAJ5X4RzB/F83RHB7vaPOzUvhBoyoqZmbhn1vR7nPVkEejw
XURuHnjqAmtYH1paj17qvte6DiTaVBvua8wd+kUolsuRfDzBOKPMxEzRy3UFdb6V
UfyAL4LXXaI7ZiknWf2uem7rrMxFfIzrE90guDpmTorghXcWLmzAD0h02Odd0GdR
YP9pPWj854e4HweBm6jUZK2ad+uzSOLfwjslHM+TeqDsUBM8fanYYZTNCRJeLe2D
np7kMemVTZXPotR3K+y9pg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 15888 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
B8Dz2CmrAwYunga/zH5IUOVQKcrD8BWmuHHQ9EdL3EL2kEwrU6R63Z9NIS1vRzq9
WjW6jyhBp32fqz3z3W6RxKy/JtkfnIumSLwRuDfaIEeGs85Hp7CLveqr9MhFkLzg
VdLIgpEb41/9hcjt8y8ECDuR+CmD2k9tzabos+uFBNDRVjwInLGKxo9bpWMujuCc
oR7k7JNrY1mWOt/zsh7dlXbQNCnao38xbnHbnOSv8Wf7xuFG3ZmzxGVSKLfVFE/K
mn7TPLbup9mMMtkqLaYIMIKGmcf8bTuFutXlttGOXizsVsxNQV9ZkVdMpNCSJ9Dd
rAvHiUrvsJTO544XJhN8Sw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 5616 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
FoQ6uBymWZL/VweRKCbcuoxGVKFa58RRX8qxaqbsOyRftELOadzIFJsVJA/OKvPX
WKXipwhpQT3RGz1lEE0AoI+8eXTwICwu+HGyY4ymSCVG8vUNKrcvkrLLZc0GFOiZ
ytGUaEZ30HdLc0T42lMl8/geS0MEZNEbs7BKGyUBtGR/3lwLJMknN2WJx5wgPi3V
20j4Go1fbzUDx1p1YvE6/h1k80ilpEmF5SQyUco3RqGIoeqA0/psw9QrQOL1L4RI
Qmgg2iQW/f9nhmvEbItz7elrggEbD+bGG/xsjtJEfzFzLxjYGQ3LcnmlhXpw+GSR
gFbXUF6D0OItn3N1+yQl+w==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 6416 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
eLLJr2XCodkzmtXe0f3M+WLg+ijW44MhUUq3DW+YZtpLztsB42FEGdzM/DjsyoTB
zA8h8jtsNM2EMtTaKcu0mAlnKB6kcgSAHUMyy3ujZcoG7ZoI0v9YUbBmCmlokAoO
GBvM/P3AX6G+bTpIk3zcKXVfAaI0vRDYybvtZsfEG+Q+wFmGDMXelZjXatq3aSE6
2f8ynfR7HLAhLznncnaO3YWyZMkqM4xg+GTRTLdJS0Lcv1Zn9KnPkuG9YO+tUKF+
WsVShnMDwmsxecwJjIURe1V0tifiLSXbPM1ijdBLwA+utUdmRC0wL92AaV7wlFrK
xl/qZ6LGHgxXuthBB66mTA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 1776 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
i/S2NqcRNK+lKROEmcdFy+vmq1jF1rvdcmuDDKTNbgP/ce7rPietN9xo3AFHrUwK
pzgcFj/OBAxrXYcamdRSXWdrfqHwl6ZZJD5QgE/XMefK3l404+RajXSA/8QfNPMj
juWFRAxCEuTAR7KBc6iRmzvPFK+TUTfuYfwnbpMkfB2je7M3wgpy19SoU1WxmbLx
mcJeSqZBXgPWxbEJhn2nQcY3705X0vHSUAiqBqGX4bF1Y/kLBgFcODxueQfuuAKh
F+xWah6JKBa3+whDeHoLoDgHcRbWdRVd8LJh73okecaijeyLHpot8ABaybAQ+Kjm
gEqmyrjK3QEPpxip9sO5ig==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 31312 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
mrXZ8Tg1Ou4l66AaT8uctihV2Lynu9/lkEEGMYTedYE9pU8imi4cKDnI7fLz1+bF
5M+xH/lySzZUtAjVDYmx4m6iIsg2PqPYPf/eamlFqp3k1fBqaSfcBKDD7GM0SuJ1
2A11ENxxVQ1LW+zTyGmK77S5/9JH4XFH0owvOjzH3rESSqHkP0a6k/VkyaSpCRXZ
Bje6f97cIMwwwCZv4bERyBEkaAkjVvqE8XhqprRcBF9V2nCTvy7cK5iagcQHJE8v
A0ckeItnNPYSiVIxx4fR2ZfFxE5WUULfFalWqZtauhMG2+SGvm97mt9A65GyTXPz
TzKb8bKd1lFEe2CXcKjdTw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 2416 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
BsZhjjJgjG3NgbByLwQ8OAoNv77R0YVpWddDQ+LtQ47635ul3VOY/QWJGZIEAJhL
KnzU3AffDlQMFc5WWxtBBMx3xNYKY4zqYjNHB3iFOKdkXn5VMxZc2gjJIE5ukMqm
A9PAXFCpsjzaxnRA7Wwq5Tg03lSX/I19vVRkmroPbE9WrnT1yO15DGEqGjBVaeYD
5W/GKZg4lPGpl5NXqO5mF2/RVx3azHNYQzupXnp5zriSL8Q1H/My42Tteh3q9d65
hcnnBp9fwimFhN23gKrKKgeUFBNmGBC9yO7VbbJpbPItAvIEGBt5VRgYm4iT9St4
4AcRRTshaRfeFtT11C4Pgw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 1824 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
GEEGi/BoGsYYz1Fx7sxSoiO4XrnB46KjzMsLgBsWiaGzEkixjtj0MHsfwFROGs/b
h2B5+W3ep7JrXP4T8N9EYz/32yT1cgsJfM8fj4p+G/1PU73R2Boj8F5gJlD7u7Yk
QAGSix4p2BAct5Q4QLzxOhIRyRWeKxiMGjRthO86wFdxnwixZXnU0gcknS9c/8we
EdhPczspi4oWVmVRu5/ZJIkx47GyQd7Hrlm1M3UefbUU9DQsynZ+b4oZnWF2HYoX
K+jizSLJSOPfu6dxVdKHUe/5eOQrKw/OIMrqQwx1ZEeC1+sRKXf1ozYY9EyyrYoz
nhdDXKNqgQklrZ1RzUwAzg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 56416 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
kHYhbqRO/rf7APCNbYQX8qqCPm8BffGkCg3eSkh4PP5m0+xHWFF5W60rV1pFFGM7
L73zUPVKYUjY7AIxe+XP52zPpXTlQxTdAJTINQFKyg9djVchgRtlxM0pssDfreX4
E5fosy7bAauIPDezlFyCY9er43bLHw65U1fG22n4y+lAGt75drdJPg1sDip+inpf
C8u/sKy0QaPwVugEcSmCNMjs0CSPC+SYNgB2UToEZg8sj+8DCz/j/ojh9LQIthLS
5JNWeMlDU1ylLnOAV65+N5IpxSenCT4uLwtF8VNiC9kxUsdTB0SPBWr+XnCfwMq8
UUgTAfuNeCpETZYicECU3Q==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 24720 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
WyoxHWJJ3e5+jaDL1s+qjpQzoxdRYPzxPU6jAMRCu8l6vfd4qiMbixA+k9K0i2Lt
RseCvIklhg7k0JeO9B2ZBDmtZm3RSevK1wn+T3y2KeAXqmdwwyZLPNaoHg9KT1XB
LAkbPrtrECZioP4YyLluipmtRqzQ2rxK+6frsJh63rQ6ItciAkkKadSzkI8MmveJ
z2hVjFZnuSQ9WZ1oYIXXpE4mZmkzfyc51SacNuxrIgoqgllB2dzlY1HWztCUyIjN
SEEH37W2ihfyAfAWXaI9Dk0Oz4MYZzNEw6NKuka28eMEj9M6E6virMTEWGyrqffZ
duSo3tUaO1byp0jFfqclPw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 6800 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
lnO+feyXS+2rij2X3Oej7z9kIcyDyuN9/rnL6f9VCvaHt2HgsiWKaZxL41Y24c9Y
rWLMpmSAp9PHCZ17QrGCyIybRVsp2N06AtBCsBjrXncQObrfV43/KpEbYJ41NpFZ
VrcVUzFH56ceDrIpQ/VW/XvLngej0ZqWzmUz61sGXkCkPCZof25GT2cPkePiziAZ
o2Uu9jjPhOVfAgjzVQVJxI08YVjRJJwI8G9D9mKOCoDeBohBxtcFgg8iFgYN0f4V
QSRWyfSYTnRR620mkGx3p0eX+MB/ma+nIdIvypaMjv0EEKbmoFBmw2uHPwD8yHxS
/xiNg103nLV5qC0uGAMY2Q==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 10352 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
cE5yajb9wQIjCnRpUsZ/0cVHkgdeYd/VGcvpqaILVDfTYue46ppmjG3iDIzfAZZe
G0oK3mIG0RgXuPavMiVpkz8rDG1LS8GerznxVHe6P2kUIwd4STsbqYB5xOxGKoZI
I97hpGOtiOUqXLoYCOKSn7ruaCdg0iEbOAbipNPpQOC4pYOhfwPTwytLCJjsQ0CK
c0AKoqVzR/1Xdf5VrnLnpkZric7ljG3pSPLkEUfuFZoP84gY9CVWwm63cnAx5t2H
/QUNTxxM+BGQ3JQe9RPmxu3sG1+nwG5Wcdb4v7oCi1EetaeIkoR2+IPUztASD4KC
d0DTP2ODv3cEW3Cw+5EUgg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 2512 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
l2/G3RsNRKh0xR+9NPPrSlqItANzF8bZ3j20mFkpkao2fWSy6SDZVD1Fgcti/f6P
f3P6Ity4U/C1OOK/Rd/x6cxgXh8uZDJ5SBuP2O2t79zyDlDHO7yhc6O5+JI9vTL1
ocDTkwKBGv0jyAa5Ec1MPrCLqocQqPVW+r2uYtHnqbjZe2s194hndOTtNfNyTG9L
SbwxdQxGFG2d5v9ou75Jz2UW2uqtbFj9kQyp0Vngnj8auWIOXgu2ImFdjZycSbXt
6XImXog0IUM4BBq1qwtj4XfOVySsBmy2A1xZ7g8pK5RLyy2wpEPg0PnW2V5jgzME
4y39ijpWL9VBZBT3tzBnxw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 22496 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
ScDPB+QNlFHFFUZTAG1VLS8vHwqOjejm0s1Jh7va5I+6pitnSnTUclqVLaYS4KwA
mFbsvacfUiU3aOyu7r6Y2ha9olSafyiP0tK7g05WQldDVe0TTz5sW+8+XK9zPtMM
sbScv/nIZbH4RiiC5vDB/ZNSSiKqxuI1mgJgfKhgDuSlwi3DAhTZjumSWWgtZhmF
BKla8PEi2Whr1GE5G9183ypT6Co84mf8koBbcyHfnUFILcaAWlsiSva2/pcRUte7
CnzZQNZ1lK70YPKsLwJPwSOgDwnjER5mAvZCwIjD9LpM6+Mzml1xx0QGi6cR6/6h
y1Vyx9U++nUzkRFx/4fVdw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 21040 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ns
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
bvo68O6LRDVvBbAmfBShUXJJgJz47KwVqx8qtC+aNMRj5u7+Ab6s9XlkMi0GQcN6
WN9Wsd1duNXsEwZeQET2dotRejxxm6KmRsq1mqtveWqyflWf2w1GFz9RSWFbdTzd
7mL0A+egjuamUmJ0lwtLJLSCFIW0oZ4hivxgg2crgE/bXRFJXVMUkKfwjSUqV+E+
ximoEERu3T1NMnxEDf6Gm9ohQzMaMqwxAfDDiaLkC28TG23XUQHiYGepLTuBnTOf
TmWUeoRH+2A4+GJQ3FcRZDK6jFfFbRUbk3WsIiArk729nI/cBFh1cK90KRnGDLB1
tJnH96+X0YlASRNJ006S2w==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 19328 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
kbO0vzzHKzo5F7YAvBQgTbDM3ATf3UBt1igKj9zZQwig+M1zf2cZi3CeOM2QGok+
bfeXrdxDL71fibywQETWjFS1qI4/KSqTSVZESx7vInINLcT3UAn0yu2bFAPgQ+jG
neiPmGLPFLdSp9qPQnyhILr24iFYnnlRWbrMyVhDyzS4MRLQ1Frhxl5WRKGr+i4H
+A1u11/kbnqVsHSdzFaS4g/C4B7ck6QnOTgm0U8jt3p21TS8bn75oupcVjgYruHM
luTqvjYm6/QPy4sAZGeaJybYUtYPj+eBk42lXTOsUdGKg27ob0LSdf2nIqL8oM/9
DTiCNM2mSKkYfEHyd+Axlg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 25632 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
eSYO2uBNGMuigJOFvCVwLGWndpJA64ikbojku+pd1PhyJyg5tIbPuEZW0OmP8xdf
lorE1p6KZ0FkquRN3ysd4WDwR+37UxLqzmWoXSp1GM/jVawzBKMunCwfWXo5IPFe
B2FQqUP6MJtk7Yb+AMfRqJ7Lbg138UD2zOgFLqO+oFBH+BNVolIAymDGseJwmzBi
43Fn9fmYnwsRoVRlzP0GpOkhF+Xuryoa3Ek8k3lfXr29/it7NC8pzk0Td3VSwr4l
WXmvnKVfhO+byY0xqXrVkFqRb8mzNTmK8cHh1HTK7MbAfSfaQvuILpsu9e8DSYMn
RHMH4XPkPajWFk21od9/kA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 9952 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
MsMWVNrZdJEzjOK6oa7XQDTw0mFRbKOIEqP3D1zU0GbO8fU5Ap/NC++p92zJIVf6
AAgAuFuc6bh/VIG2e0Obie+ZsHZXZgcZXxBHbg/QxEo5akxjKFa6pvZErojmH2a/
k2SYzPt9CPRH7g+sN+FAkV9yDzJlszD9XU63CoP8+7tLKm9v8gQeAylTaOgdfaKh
jxyP4fEQRKaWvHlaC+1oEfoMmKygSyOQD4J6lhw0rQ8CANGfxCe2bVOHHFizxQsh
9rg1VRkTbifOfKNh1iPhPs9vJBNHX1TjqrWJnrWkU0cBYYi2QbJ6GF5Lpnby3E6A
ojhhpbXPcOOUxpnsl5lssw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 8688 )
`pragma protect data_block
UOD0r1L12BVMre6gbGca49jGxmemCTzQnyVZwJ2XnyIDSiKBn4ppCQ4IPvKu4JYt
3j3LK7+I1JVrWXOjOMMOZfVGxd3bQmsD2SR7E9g3mQZTOobzAKBG/7L2VRTAXS/a
NWFxO4nc+hxiddVKpyRXhXRsnGicT/pms4tp8sPCWIBoRapED2iNh4E3pReNJFuA
+hi4n4QmaugDU8NsrsA+Ky3dnhfikt9tC+RsMZ9HTCHadz8aJkY3pKgGW7+8dDlm
SlI+JRRgc8r29U/Q9tGnyQ12nECLx5BHzi9iDx3p+4KHMXSenGA2xJNUcU6yOI0d
MZrAXpyCGkyFz142tUZHe3Sb1kQGmUFJrbirXb26O1n7NQIpkxn5/v5+swwC2RDj
bw1IHMkSCKQ3ZdEGriDwHfqOEtJrpX9TkHWU1YHhjEmpP+d3AVO8JP0LFv9VZ2OG
h3t/0VBaJnXq4P3gp2bDb+f4vSpGM7zH7kzIa4ACFS3FdAKvX72pjRfOObj2XfF5
kRqEpQE5z0VpBKGdEObtqKqTLtCUhWgUs1kT8P/fu+prpY+PR3TIjs5yHFghVyhN
OBJTN/qrhsltJiA+/Njyx0CjFzN2EC7V2Kq06zneAnnRy3QmZuS7EH1hWRE1haJa
Vc7OyE+36gwLgvNk9L4MeBqjxrFqtpZryXlDT8s/u64lxZGsFO1OLMj4ezsqfyZ+
EF+JFrIr+EuvwrOgZPsVmPJPydLGjazRBADPx0Mw5UL4QHhIAasJXP/pnk9Oj1/W
HiBEYsj3xkofRRK9s3NN3/9m+qEeLBH+pm0JvfeUwdDafMoUq5ltwF3atXguHw+w
svEmApYEb3OHWo4JCBZT6GJ0lUwSk467KovrndB3poy1bBJgC5a6168kS4ZN2GT1
E/8SMHc8UzQb62Fs0dyQJBobmZGkO5X17/maVr9ItczlC2DWhe03NvL8kIvVprDU
6+AenQuhazrcPPGR97ODwJGxfk8EcybtvaNhbTv42CJpNJoex5/OA7UwnT9RBbxo
c2MH7XyjniKPB3WiAkw2NcTvXvonEAqkbw+pxjazuLwx0rWF7oTGCswWqFCikDhG
kD/ozI0zWZP7K0DZzvboFJeUbWPWdm6BEPRabjslKVw4dF3QbJBvLIBZ8F96MSEa
yVwMFXDSlsMhnrMjNMmZoo2riH5Sa55baPCiTX8JgOXXu6nkaSG8Vuluru7ZApIf
/2m8T0yPxSn3ulTW4vtDMpoCgcZQPT2pL+vmdE/rk97enXklgbsRAIdWh6g3R2I7
EqHcdPusIbbE6RuSwrZOoSvjSyfVc5gWPQ+EsKc84ZF0RWgxjX5Pio6ZTG23E/Jm
MbM1WDG64D22ChsgZYT5i0UfdU5yhmInDOLgd1WuD+7LKjDuLn/KLmjQxqV9YPaV
HywUetHYPG9PSY1jMBEseNAs+jqoBpq01Xs/mJE1xqxCPFWAbAYmLXIMgcdbF3iv
5cSpIQ3kL9/fzSyto5o9BpznAoeOHQuj0yMjou+ZLVCSsshcI+lwWfnxgipcwZ1v
Vm7dmOzGOyAlQ60EZCoFIW94f5w5tA6a3Dt8m3BQf/c9G6SIMgSDdhvm9nKrw9oH
ze9qmlfMQ280nGAP/xPZ3guMYnpV22ZegnVt7W4pL0gZ0J0xtCBJQKndo9fHohGW
zuNivymP7u7sDITfM6+mo4j7a9zD1rXCPJHE5jIg1yfOH4C0PJGgH3DVDbPTWRQG
+CYb7PVPBo+cGgKmpZiZZGBYDS9L/XFDVATgkduMI4+PSWn4jFjRRZwBnda+Ey6j
DUZbUl9h1g/tL+oqsgfXwidDRUYDe2aNmdn/5l5huSYKzCk4wHrLyunVW9Hp7XGz
OxoMTUjdGXkn86UhjulVF7IN7EAm13AaIc72xFjwIDNWuzCcajwzOckMrPiEdkWp
qU5FFXqsy9Uoxd0XHh7iolNpRc0mGl+q8zxunAIjyliM4Q/xVPg6QWeg5xfZOT/W
b+XMmUxaN8Id6lkQ7feLrUsMVxgxL0+xH3MeZyxAVfdeSb68INQH1GTgRR4eatvp
2BERHlhj9K927+dlAQn0PEBvNneVCS3b1wQ/WXi+6vH9BM+SMsA4uEZ+o8CyTvIK
GVZPiSqHdxl0z7QlpLTJXQm8PcpJeM22ETuVhXF+qgceaneWU2zM1gKm1KBc/InO
3HYK/i59mllJ1+34ndd4GlyXTSMpU06OoukLmNoFqa9Nl2Hudez+gOlW8EAM+tJF
9do/8oLrby+bYp7HkU6eiCT8Nu9FtMMe4k7h6UxGzBtHZKj31fdleF7RE6zMsGrv
jiIy7jEYr9KXhuIoabN7MNdbv109ghNxTJIrYiZN+sHe7b17SPJmHV+onzhwQ+XY
sxEyjvbAbLHMMns/iMr6Y6Ecjcncs8brATfgwkWeZU4TGKwiYp8oTzueCGzf5sR4
6BOtnBMq/WIA/n23qempU67heoXhLGSrD+CEbvk5zjMZKhl9wD40BUrN3ZTdvglI
hpWl35P1RkKaIUd89pvnToipGkaAY+WIO+sVLoPfljRccxmQP/jFBzg7vs7NL4mW
omWR66NLbFXgYxtiNh0rsEGmOqQr2Py3FbcplhVNx4p4WYzy7421i0f0WeC/2F3g
rViy3Voj3jFUUpljuZPK6LMbod8vyTZ29WsZrmAAI500DQTePybWCHwe71VIrqlD
dKTNA4Fai+vgmJaywligO9egx2wiLM1GdCtip2y4iet1FwHqH+6eKr24W8bg7ysR
479iNWs0UwECq4BIBOZArqmAZA96eigtNTcVweH7Zww0hIR9EGzUBMvj2WKa39dl
XWFCrLxkXcW8WD69ZWR2raY/mJJqcLMJV4amG1CDEIIk2P72fbRztRO656PcETVG
YIaA+qSzPDBQ2Grj+7Nmkd2fOy08gB46oDCSiJc7Ox2vLSj75s+FoTGT2o8J+2Mr
a0jSZJ1aeUPl2RzdMS8u6zAVlpjZDbDQYht9UqUt5eKwgrQGVM428RT3YVgk+tgV
q6ZlpoP2Ark2SKt8Yf6LII0mbpOIpINjrOm6Czi2bsshgvoC9hrQBSetGO6yYr6x
/LJ3yeKCX0kHZdOd4sUZ+1AAf7i/VC347SPljf3lfcWTMdYC6xrpovPkFmQHcHC1
+alLILs/P5+xAXZXiba5ENm1bFiSVMSak8B2WxYdFbkhVO3atwMxP3pjH8eRkO9T
zaR5NRYqFLY24fB/iITRoUX9bQqgoROyLhhs8O0/edZn7d9OSOCDGNXTFOIFoTkw
6ck7+Tk6F6sYq0z/MipjhbCgQRajTtjn65tP+LI6cKE+UBxQS3OsnsyFXyaGsDfH
v23fc3L6AU8E/72UEg0ieV27p2PbR4/dPGX0D+Zo5/ry/FmrB2m/WcOkG4RRoKBH
tTKIBbMYo+xuY9ZCADiYmpZ65avlO0uaK021srQ2y+ml036ya44UjIroyjerS/Jf
+xyIR/6qwQovtg5rgDejVm2ItMiObEXkCItPspg9VnD/52f4hcC+frY5VXjc+TAv
6lnY+zMQnUjA2Z+55q2b+8c3hFCa5JSWUTdvZjn5LNcAZC5iOsGYfBFh6NPSdH0C
30+NfZSdXYh9+oVQG77NGzDVKGewoXkysjWbrSNn+wojMUiR+kkYVxtNTCG/jAei
bpLiUiR3ol2XiDDCiMyMblXoywbBpvmr9tjzlCzLtTa13UoQCPlHkBHIkoxgF6Z7
WIOhiK+kIqmpAWXCwdRbGWe6l/t3fHSfD+oco57lZP/aW2gTX23+NTc3bNlK8KbO
lLk5swU61/5fUIOCi4qB13LQaRBXQqOFZjCOg5JB2TPD/gBh3tBsBDw8ggPwScnQ
ldra/yCrZWKydvbD/tKlpOimQdblsichnR/ZOGX7Nn3oWZc9OB4bK2a/XI/9/CYg
INRq4eEd5dD0AiybMY9KYLJluKWaYPr557R/bJ7l18ecvFL/IvjJ1Ibrg9brA2l/
oZMhW1AxHBLOk0ZsDrsqiDNWxNMhN6z+OW5zBQHnGZ4yGzcGGnrtfmkZn43llkV+
aXBNBz0KVrx66ZvQ+tJ8KD9vfbEvWOZ972b9AD34TpS++sZoN8xVVJB7w12wQLEz
MdTY16zgVM6wUKfE0KzbsZueGHVYUs10Y1rzvdM+v1wr9TVmxFRvDVWdnFoct8X3
Ld6KRdklFKlMWkIt8N0lVRyl/3r800RgoISgtU8pENeqGK7D353UUZlA8+ZcMrzw
lCW6qtyQy5HIqY8XwR5SsIv8INuup7QND2dqEW3wJdAIpet4BWiBzpr/bUBwV6Gp
yrMPhXaXzsE1KZB0ePuw+uLf2c0kFnv1FH4NkE3KuT80UMMcGkETFldY74FJYAYM
KWDGXKdDgWUoCzJLY6Y4buY4/yKgwN3CGoBaf2g+ivUOwpQyE9A3Pvh48YDmyFct
OAswFarIy+jS/9rA/lyYZv/axCPSJ8+L1qPrSdYdj7/k134UCRyUKYehFVbLkM7V
hPrn/7QZv3fvejQwT8NRAnQerCizvdMQoMpTkicupHM/t04fhgKllfPCQwhqAb7N
J485V/GFrw5kH5VFGyQfyjpaXSpsHjS8wUdzaIdXwtA4wi6QZSYbzVR2MYnIZn3Q
iNTVwwjZZDUzD+ZfQLuRmO3e/+P/1R+07Cg4cjbWlLwCRN+cXfQqBvRbhsWadE9N
hlWaoHMIM1la4aqeKo6RAaQEBg6KDlqs6fxdtKI3bfyvogjWikNrqcz6L0O3PPoi
g4Ehc5vo0zM43Rp28w7VAfWqN0NOmhFmN5He2SamvpQDKEqt0kRM1+LfXh3FW9cv
IiLdpB/WJlcEqK+9Hf7CViijBi3FPAmEYh54cuwr5rRvMNd51rMhNmu4kAVw5fhx
zm2zHnkBW/s71TADsh03/oVuVSJfXNdTwbmo6Gb7sl3UtmBl6VtMeR4eoXV+Ht9L
BIHn2kj2zwCORGGh2nJQfPnPdAMP43juNtVZss7TU/QucUOPJIVcsKy51rp7vFFL
P9pWj2vuAKQCl6/MqOpKwbC2lQeQBkhrsh4u/zIbchYaO70se3rc2Wk0eq+7yCcc
bvanXhb14ha8+46Ezm1U8kaibsGxfEhwYyhr8mW+mr4TSHDmAt3Qj9hkLh5nURkd
gSRguLYSK22kPaDJxGaTPMYxPaZiAcVfJDeWCDkXToXgdkN2Zq9DU9YVqnGK/MQ/
519YPUHHIw9BmCH305M/Y0ZAHJoHK8E9iJENyjp9Tf+wiwulXRfdE5bo0AoraE4X
Bqm4qEbmV7sGcz5L7r1hb1SksgV4oUvciGVnd95dpbmxIUB4CcC+x1qVUjpG8wwL
8mGSK7JaTMkp5LqV9yEhCIVRAwfvNVlgf/ZHAr3sv5c5BWzyleO2AHuovoVZvxAf
tjdhR/MU1UIn/Qyo+TTWQlX6+dGUAB7SN216U5kWG/ukYgmQtdsBOhTpL+y7qhbn
XwUgbAk5BLh73dhfLATdp8IRHgUPaNmgvuXf5w6tww34JVv8zPfJQl/2/JF9a3CO
oV4WWOPpZh9vRNJnugsPpb3HB0YV1d+/0fgrDnRKFXTKHMeBvB5nCxfQ9ReWtBSM
O7Wlno6hlfTk3kpoUEf85OX/QBRVvNHr2Jn93eJk7jk6qT15djlUEZSoELgkNEpb
kabVOwCfoIAOizyNXIVk++yPPSvyqhgNhr6Pumdc0DxO2hNYY7UluMXdNs12QZMk
dQj39w9hgulQ9ZGBNX5r1dIvQov9SsDZy8tk7F1W240KY0xlS1ZtHcq0BXzC5KJk
waUd+h06AXMqaVqSFTTvIRitZV6CYDyRXGKc7YtaNC2s+h3PMMiW0/AQPU7Rgh37
MsbDySqMJgikm3YSs00fl88DxTyZzM7smO89Ur+FdAfEOtXzYV4zDer5XFkGUEGO
d/eMmMQ9vj6wW2ThPMGYenWpgRYFeISBtsJtxyi+pN3odzTzr5+RtoMdnEEaDLPp
RUGmDHxCGxwwshoyv8TsMi1uoPM/qCCUvacld9F2+kEfBLecV8Sr0NimMEqWbTQG
dP8g0b7v3Z166FdmQWS1Lel2k86FxzKTlRV/xucUibiZPEVPg68ZqVO1GbiM7a7F
Fe+bNEQLz4rePgFxI7NK5Dtdm+/3bE7Teml55BBNbGgR+UFoxb05q1bY+OmHcSlx
g0NRDv26S2xcS29eoshJwbISAmxjOL4FZUjq01cUlMPr4IWw2PZc6Y5IP+LN+kMc
azIRrRbpkDaBReIf2h+K6n14vjUn7guFEVCCMvKtoAo+/2p5YYloih22A2CT9i15
fFHdmyHIkcMOzqqJKkHM/R6y9IKnE5dwyKOltABUqwyNMEuHMUb4ZyLrwvQvMy2z
IwgP9TqRSvKlV8Voxt3yI7zxCLD8lGUm1dpAgxpIeUGeDt10bJzNdhCVdCcsaMrX
wKPoroshY+jzBvIU1u5mazgj9DKRiKm07aYMl201HMp8oVK5Ofv3QM5FuaXTP1Jo
C9tNCUvumvESJcfsNeGvXEq8LpVgkui8NHRkIO5JW1LLVwHK13uxFgMWGMcywwN1
QIh3sMxiIyEYQW3mcbkSZblp8rq7Rh93wsqAU0fGrAs8WBnvHxgTMvx2yx195GHR
Dd57P+DUjH3are2Zw7D7WdkIFFV9FEWV4Da6WdlFiVbaRz8Y+xEZPNUJ2V+0cTEA
fF1nS5CsRLjlEHA+/H6nMLy1dv9uvpRE33O86w4eoasBupHS1BlWd1Qs5tf2TZr5
4sfrpF4UIQJiBysmERYVviFQS/6gMiYKIlMsaqrXEtay3U8z9SlAfpOMsLuLL9x5
XFAID3V+YDQzDiQmwvz4LfExFUoR3OXKz357DlS4sRjBFgp3I1IRLcEzPm9lVbHw
+3SCXIFXlRMgj5dKKZFW31YufRF257e1gHxhDntdJipwyzQn+Z0DLbv2/jvWiQeT
4ttggKDleoXpOHDCqSMmvVfnVyVRut8OcNoAMLbaiQJbiCoiFcm2hb0VvrZQloOr
ag1swQwVcBDs5koVTGknJpgqG9r2NIWyq+PpJvrHzU6Hnq7XnIcZEYQHJvfP8Vd9
0+jcE1ro/1XtbT4CyJRgWc8A4N8yj04mcYhtNstndCW2eKyTrSSuHBTODFvwr2sA
7iIY1Vqclgw2QMtMaZIrrHUSQ2guy1UqUqw9gOEV3zwyqOZ8mKDiar/nhz4Ptmw4
fljKjCySkGm6rp7z5HbD80zkmQ8O9BB78GYzsgwr+e/EnOP1+qGf6sItGaBTdMb7
DKcU7iUHREiuVEyIEVFAjnHXHTxj4cxDh8rH8byvef4m01BRggLJsSIfA1mZD3R9
MPIStoxmx32I+qMetVO3vF/YWL1wzCSTTA6JR3h1Ph0bl+iO5dtbVj5GF4VAuqgF
qQEgYPL0RUw9u/115iWvmGB4ChsBAjkQ1hmzSwHBdTqIYDKYf4jiYroklgdxQ6E2
QC2mGC0aw0Vko5mPZ8EfUrKoe7kZUVYgkyz8QUMa9PRtHysVUR3WwHuQ9pZFP3U9
FKMDR4A1USewddE1/rwoEGyMnTdM4CEzxqYdDwO9QbEQDbdYFMgGj4LaS0y3X0uh
EyLpnjw1mMDawGG3iAtqkBqTlek8C2FAViBIIfsAmuu4FE7IZxxS4AIZJyhAY8kN
GosIWUCk+BGFgSOropTmY4gCV3qQCzsu5WZO78QWaAeVIRaTfJ6bwJVJPd/mxL5j
EkUSgofznk1nu1/YvjT3Ky2hagGRsPWUKdv/YHAOEosEbd885GJQGS3gyFqqxWll
t/uJ3AER/L6i3Ot2asMuzsjtglkCEp7X9koJa27lqvC+GVRjzN5wEGpevb6S3qZ8
DiqErCemLfAGTCTqCkpGhl8nlwG3o0HV1fg2HxEA1gM9/qVsBKytKB+GRuCuoBmr
E5LzpcawVhoBKju5HmyPvGN2D15lBDFbQqMBjI8Hq13T04Ezgu9Z95zFJ5as5gso
AbGi76oD5S23Q8BQT7c0tBbhLi5EDpdREsjPwAsSKv845M3PiHr5P75mclscGptg
BMb+Z/mJma80PVrLrYXtzVyp6VLTX08CemZjYDXhulwUewmnz7HtJfGqylbPe25f
ohJeXvoAdKWMfoyOXui3ifeOmxpoiKvlaj0hV8n5o5frJnCJsIWYzZoAiT8EETqe
hXITE/chOPtVDBgnorpIUUIZq2wB+TcOzBmWFExpDoUvGPKOetckArz1Ys2+5nbd
Xp9ILepED5goQ7jeRO6QT5/AqM1zzc/LbYyRHbQlUiMAXHmYFFcWtaeNJTpwmSu2
suXX6D0g3MxZV0gVnsTw/FpDn89IoRzYzA5XwHEbXGDSydL8mJrcgRZbP8Ikc6lJ
P5im4KUZ2JAJ51dOLIvACn8zv6xFtF545NwPYR/cokvGjr/5gyIEa4OqzF2xmKQc
twlFuFoc3Ea20o0vFlUBJmuxUOfTY/e5m9l49cHl+o/OwJWsNPhAMIRFgg7uLNIp
5POyvBdD2kI2ANMi803OGiB1hy+Z9OlePBrlepJI2icUh6uM4/ClA+Iq+jWL5DsH
mu1IwMNN0b2IxfD9llSrb0XdFFja7xT9l/Ar3334qhDujHivD0j96LpANUZUnN33
UfD7eVftTEwTkgXxGwvESf4I14kL13OJpjgreXIzgfZKlcLwCk5n+HxF28PKffK5
xqtd500NM3dsVWWLw+wV7I0aeRFVNJOLD9HHWlgk+/r/zTl1qiA6S54vS8pbdvn/
eRmr6eMCP3iX8vQQTJiWevzIHpz5Z2P3v+DZf+2u1H44tgNf9OIUAvrTYooOWBVZ
Evd8KR+0IpQtgRIfYtQQDE/s264uVZ7Ji+xMJvdNXRgfPs1zdHyAweANsmXjG8zg
VNtFHpgx6d0vKqstv29b03aQ45jLayh7jm6wDZNxz4Ae6o4SQ0tpT7hafmoq/L2T
IYWlynsq96fZW52L151dzp2D4rlgTTGWTDZJZp3oyN4xG8KZT24cXPJggKNBB6TD
23gHQjX2n/p2tQga/B27UWjMcpca2EJ1i35UNY5t5CDa7OPvr3dc/i255Bj+9WQV
W1z9otUqcAmk9YamyOHG87Kl4kn/D7bF0Go8qTJFvdpriar/sJj7RFfvbUenPyIS
+TWe93nxn2qmzp0TP3k/IxceOl5rsK2e6ckZ4JfHyq3pVAylJsGWsU3BxSioCSJv
el9l/uHM2RwIyo3gB1N21Y9W87YVzQfnd5wBr3fs+JmSJEk4zVGjo0PztMTHhm72
PgH0hVpKm/Zl7wB57tKDOxLeuWK+hQKO26mQCkWHYGLQUo5oLD4aCNgjVYUgdv6K
Ykzbvju6//GT+szFJC+QemvFI30DE/NsaXzljRPfgrrGEeu3B18MMF1YhGCJggLn
2IwjA8z6mIgOn81iMZwwjUjhJ/+HBogHfxr1Vtnz/TGDPeoNOB9Oah1O97m+yxzE
oXf6svLFJUEHcG6HZTAYwut9aG4S7dgBcpFNzJGOgK+e13bXaIjGjZgCvyVpbLL8
Y0jiGCUsSsA8CXqQzOlJAVT2ejBqApPL2cWEB5y0EoExVEXEgmJFmb7vMby20k/6
99JVxXLw37FeDKxaLNkWOQpLLY7p1X3G6gKL11QWGdMZafMpCrxED/8ywTgwapje
+pktIw0t/txpS3svVgcAnCvprSJOU0lRYsXDFc5nhE52jT9sHqyP+v6PeL9Eac4I
Kua8CoK1GAjTbaYhwEu7uaOW++Acoy5Jm/QHLFrXbw48wuZHZnou1LJvezpkbwQQ
QnVnNBZcIKnrQ1YfIrOqupVt/uJ8fkOKEuiJjhunceNOV9MfiO5u8jZVm3J2i0Tc
ucZpaXhlO3QMl0yPlRPGuEvlasBJwlo0jQChbSSWkDmp0zGW8Vc+WNNaEGndlm7o
hmMH1BXuu2y4ConkWn7z6PBsh9wS8Q11FKrFyxq/vnA6GeqeWh8esza3cokMrVfE
NsiNmdBF8jlohU7LxfSx+gSfaHNfNx7hW3DrIlm6iiTm6OhZkjxAbz7D0DQ/bkJN
4CXvAvdCeb2VBQgyYmMVszw8yBTze819IsBeiZr2skeFOU7RVt/B3a95ragHvNHs
NYReQ4r5fQNtVT9umkVSam2YX16G3bRsxdGPdNa7zX7CMEIA3s1RdGyemzZHAInA
f83Q/qrAkUPTWXxM607pbwlmfM0f3EiZOdKdMeWhO6QOhOJPzTWA5FKIjmhD+ALI
hlDzNR5xiwEVFhHnb6/lqEFZ338Qml9nCrh+hLKJahlGoTfPcCn3eD9sQkmM38Y5
bpi5AVDn3ba3j/0K2ymLWIb8ttZ1W8MX+19oPXc30dvrR8Zu4LxlxVZ6HY0KrUkc
MTivLXn+clWOBhFTAJ8AG7fXnmVJpN7eLhxJ4rpRkJ8qrkRSlqFfz3ofB4oNbQnQ
4uIZqqiwZx7lnRtlLuXFSeoOGQqvCUpbSkd4SsvNiN2UHzcButDt9nJBB5g16dqQ
V0EenfWSoXqikcoTJSUvs08x7Q2t2DvNbmvYts6HBAdcyMkfno/ulcC0ulMdZeLI
4McfMATZ62HWm6f0dPzxx4sfWGVCxlbnecKWnEJuhcNSRfcZxFWWfHXbH2ujldCj
ovIl9t0NfYnq9oYphApn4oS25B0tRhcIbXUOlbhLeQLIkR102eOdEZ0vzzJhrwRq
X98xHtYNYtRvKXkoTdNWjIk94igRYXT1zoe7mJcjtKMf+7NpON7uKjSVSVTi4Qgp
5uRdOC2Oh6F4GCOzBkkPBj1N4pwVKJ9pINpdCFY9Z+j9Eg170h25zjebI7TpCRK+
odmRU+Dp0MbSt5M0JoW0itZIQHs4J8E4jEo3LUVnlDjLCCITvGJQaUGUZEfFNtaP
dcy32gG59V2Jebp1Kp1q0KEBpVV2WC2UHz4dKIDZrQYcMmRRf2fMspWR9nz5x1DU
Hq5cf0jN7TtzNtT28DieZYh3xquI58BweITsbDsyrWAPM240hn5VfWPZeEB5U0T0
cNRfspPQHDFwcJhwVie/vWurRzrCm/wu/8r9vnvUe2scoXrVELsi8nfNYgJKhMCt
mm9n6/XA4fVeAE+hJXFyr7mfN4z7YZjVO0iTeQ6FT3C82qMHqnIqjZ4w756r6TYj
UX91IrIitFtJQb1qSmoDd9AWOTzNo+0io02lZ2dJIc1G5mgULaG+Q/gsAwvXoF/w
mZ18KvO68slWyHjxICCfJZSIlT5a529ZsUC757XAXnQkPuQrnnccZWmH5xq9/+nN
pEISIOlZFFM8ZUbJL9i8liPznMVlYCUM972rXjiME8p71rBAOzusGLkHepUtJiqX
jy9VEpSA4+bAKSsPOVRx5QBnJ2tbtL/6f0A/qoQDzUKd7ohuGa1v68bz6illb49p
6XnjY7IRi0gpJZaSRD+F5D0+8wKyuUmdcxAdmVvrPALn/HhfRCu/nQ9MmcBSGv+e
D60nBjlCkJlQ6oZLTQu1efZIPJXJc7dwgJJfwJVSAyiHTUG1LW2i1d1hIN65F0xy
m/WrJ6x/H8onRxhavU9AxXWU+dpvKYxHnqp3oPKJm4o/3xmUSmqn0vCR6ViUo0D1
1EuxjsHHBPSTuXcg+w8KIXD9s/pHB+TTKDLNCKqwmHhe4TYEX+40FoJAsu4AJdUF
`pragma protect end_protected

//pragma protect end
`resetall
`timescale 1ns/1ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
jeHOjC3pRhPhnwtXuCQoA7uxz9scVbgeFjVUqzYJCKyk+rk3oVBoiFdVsP5Pxt2V
8ItngeGMlfqOnDxlORFsmWOy+ghPIWJep5I06xovZ0jkshF5l1hYgbElNE08fcSP
CjtEQCRrrVI//hMN6aQQs7uIFiMWindteezyXiLVaZvu2VqgNNLfRjtur4kCYcoV
kuDg1k2UNhbMkkABE/blgbcd4f/9sHAP24K/BgXsNsdWPaMnFyAvbP5kpNAq8JEq
IgR+/KJm8K7TSIHnUBBzb2gOVT84LBEcl7d4psTQZi0fU0z6TilCPSNK3dySz+D0
LtthlGTO1itIdvRzk6Mq8A==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 656 )
`pragma protect data_block
Khz7bHuP6JzHRW5Py8VT37qN0Zbcwj/w0t4HNx+PjiykRzPnI5hxsAiYKzNzvJxx
idzT0XAFcekdFkK/KC+9EHnV8/NyoRYcuk9KBYix1AKncOfvDKfejcXyu66lJ+10
U3oKq6K0aQaip6fbXoTo6z34UkKaVTBt1J8Bw0jaxN+idH/OS8LF5yxsYz9Vi2D8
bs3tb4sFin/NS4hJ/XSQV1Ms6MtDfkitjiFQFf0IYbh2Xq+hISFSI5n7PJA/L9A5
Pru4riA22nJs69VdJhOgYLTYbHE7gs9Prd4JpB6kCQm8s21g4Ti4p97h7fQx4g+B
Q5GNQORpqiswSrIy0GSzUkMJ1P8bDvsKvvW5Ybjb8mvuxNvRLr3nquwOsEnrNVIN
pADstRNN9B3AHD/PdO1e+js9th9sXj6YLRwJkZxbNtlQmkt9wHlwQ5O/ErxziCaB
ywcU/VpiE7orq7e2GyqL8+7UCiZqEBaark51MHNfkmcICfHLILtRoBqsFOcb/BEE
5asqdtCw6je+G0FkRhdbl8+OAXN9ryfC5IS8hgGdWjuTPXdjiaPoe2yu91nLncGw
YiespF+VMH9rB8iq8c2qElkALaK+/4VvIL4F6jyMlq2Z7xzvNF2zMtDx7hLhCRRa
w1NsBQR769hH3in2ruYMl2K7JE6gEfHCqLaqI01dJMcRJV1PuBOGVDI5tjGdAXGP
fUShzrqkaKT5DffmIbteTGV0BdVPukwYd19d+JSTC8DiYuaBIw2t4XFa/1IQJ7wH
9YshqjZA6vhwSv/B8tvwtbIQL2oq0kVxTOX6b7x/gEUI4yoqBEUK713XVvBUprkq
FScZbJRPWhIxC+PbBRgz2I7pNEKUcnXcD3OvKAFyLAI=
`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
Vx1cr5frQqhiwl4Vunn/aFyWxHBho1h5TGL2v6MRCObto9a4dvARtJTTzvqVz4kg
dd7j7ziG+JCYnQrXcqymQKo0ZXjnK9So6adLmJU8foabgqmIw5tNXGyae82fCIr8
4e7wSTZyMwb1ie+I+ZHxRwlLI9GYZ5IxixJ4eQnmeasunPuFvPfr1DTt3TRhssiD
7ilfvh3K9CVRGZv5TiNnIiPRBm0QhCVfOgn17e/XxpNX8bylXT8PP8/c5M261Mk4
MtS4zeAZ2ZlNhZmZXe2kvcb/vdIo1LPb/nF6cpy49Se/BFz9MxtKpF7y7GzJot0B
3CWFp2XguBbupKQrCuq3Gg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 12640 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
LtimP/yUTtKcWfoFFlAtyHEgX7U7CN0kPLK+iE/7ONe+0mUnHh/a3u1nUDBdoNA4
ZQkGqVSLYv2YX0FaDR3c3ND77SU6vIoAhcMqiqVvkMQVTU+zFkYudSSiIBiLGcJp
/ayvjYvqRw3tor7/viX67c7IQgVvVgV0m2I9ry9AzQvXCP2kk7MavHwHmBn9G3+s
ykZ94S0izDzWJaTSv9Y+flvji5K6W5qNMz8dWAFNeyiKuVrGxmhcXd15YaDnUei2
qTajSg+pXIXfDe3eiUhlLRTIx4WMwJPIpZlmwaBe5E55fcsj+7S6LHcOrVg6IflX
SfwXrO9TT7NiDIEtDX3z9Q==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 544 )
`pragma protect data_block
c/IAj0Z/ssBgyO4Mh1Y7t57s4g2A4p1GIUedHCOHrt6ppS/CYDuvxEIFMuvCKw58
0RvVpNHlFzWih3VW317h0saZTaaTnWEZkdM55vuhvrGObF9E3hAJhYAMjW9ZgXQT
oPBHydgFa58W754y5Yds6/pOs/R8mZjLxkqd0xfTZiU0++wimAG6jfxMjjYQEoXJ
brEbPsFdwf5G+Gp22bIoVJRWSHmyBSaOt8gC6qM3TwRfhFy6d5WPWOJyRxWF12N5
wMe72LiLyUiJMu+IFcUQ+Cw46eCcyHcaXO0wCHBexlTtupCcS9sxB987bL0ktsuf
RIWwEncc0907ojWKeMPYKbNZKQ2MqFqO2A+rCykSK5Sfb7LrM3elksPFyFG+1qp0
v9jmDOr/qdrGK4QfnzbAa0KYbP35LqaKKvQE2KgByDr5yZ9ujzbdsnGOud+uJC5g
Xfp1/1iFbN5A9knBaaPtclB/f8kYAIrjOxgK97mcdRp/59xRxA7pSQeM9HtS03a+
FDL8qphihRh1smKsGJ5aLdtMQQMgDxRITJkECC2fvwONqBObTR5hJgUqxi8TqrLo
CBMdf0i1K1A7jpLRtS5wQMTuyhBhZcRhM5mZ6g1yrsjeL/lZGm8qyzAA+yPk2wFw
JACFcM/0JgmWgRfvLSZ1ReNRC6WQmQyou362lj23sfBeHCpjy6iZ5KJPOgepOGFE
7eo9D5BdzA4XUajpl04gOw==
`pragma protect end_protected

//pragma protect end
`resetall
`timescale 1ns/1ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
D6R9kYnkJ8/UnqeP/rT5Gaqj1FZkhjD2yHJYJnNgBVXR84NpuRwNJfQu5aX3JLss
viVdMBXEi03ImmFODf6upCYDs/6Dn0yBITAJnGPTKc8rQJWuNTd3peIhPhruIG2j
5WQ2Wf2yopGBHzPE22LJQR7KuNRottEx60RPeGqlYmzrjOuapg2uxCUdFla25BOW
/pipZN95a8BUY+mdZkt4xTHGZyiJc7Bi+XiVr2TV8Yo9alAQpHApCUHG8OfGNMd1
aF1Vwwa2VbHxA+KZLIiVMqyebmecd9SdK1FDsvsYjalQxtKXsb3+kngwOnugjHkU
1VQHMx3T4BYdbSxnS2Dsnw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 704 )
`pragma protect data_block
rLAw/HBUPsryIebBY8mO5k96Cq4g+xv2JAdSRCnMW+z+UUZA3Cj8MlnBUrWd1R9P
h9WQ4YxArCcYl5HKDXiX+PHgv0eYj6K9w3aVwOcAS8Au3SJRNm/wxagX9uG5rw3B
aV8W8U/McFkvBz+btaTqgN2ltfS99k/7s73LyPJRojK4dLC/GG/DHvR6b5YoY0Z6
m8K7LcPaA/EFmGPa8gI05H15YmKuO3kGCwtIi82HvX2RM2QJtOhUscUQWXvu6JHj
o2mIDC6EhHg8m9jakKBK9p2iVXSnqWzcAa9ywKWemi2xlBBk1PB/w4arF0LkjdBd
d5abTEvLvWpsDnFZM0hfaihHkkitxaPpUG/fkcL5TSnie4UnevEx/P+mbC1ppDz6
SSVlnV348DcR04yCrW68ZqILwWSZEJc1pPpwL+qx3h0dvxaHR59x1JBi22ycC/0A
zHnKIpVTzAxCYkxCa3m+3HQ37dxVw3760ebIZCKII6B2YDCjo3WK3N8ealgdJREf
OXcT8Mqz1AOwyMEThG5VUYNODBK3KI0FRaI8TINTMS3F/MwNYMKFPkFUWexytXgd
b5MpbSujf9c28wkRceLGjnV74J2PPpIm35MVQG8NiVcR7uXGY4LPhVSvP9cDsFLT
9K97eSj0cYztMbsfi6SV35sIIsqae8LTqGE7s5VJR3TjfTVoQ5ZFVSIULr6Zf1eH
k2Zyby/ziA9gTCpp/GnKqqlA9EPBp5NblzybeB9Ws2SjmDI+ja3p3NARTVrdPCTl
gARWlwhJrIDkkjS/PgVEBAlP6zxW/PCTd3c9P82fptgUE/DotzFGvSaK9yQ7GJhX
lSNN6O/qrrmr8Er4cmqHswbpiJ/zPjQqJ04ITNw5Lx5m+MzJ2AtelBuW7BMdhSfR
1fyoCsTxB7WgWawkG8Cn/P2YID9fbLbZovJaHnZokM0=
`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
JXs4xIqvWn/XgxmuTScq9VDLhqiCLGXKd81OmMJDmAik6pgyCzDZA14nqf+9XLWu
9IczzLCOiRTDVKq8DPlU1iW6Sead6eqxuSLjAHs11/4na0Kf//H53Cn9K8kMd6bw
Ac8GJV1VVWyu9AADzzzA2FqWZy7O9AI1kVyt2v+bH877tgmjkkuv0bRKxIK2wdl+
DPaFKtbkmqUclnb2pm0Qws3+F1y8sFD+4CPokMWuWP000cy5eDntFQ/3s+y8O33Q
5sw2zROu9GHhxluNbUMb+qehEMu+Af+qXP2uzXfXr8ZdbgQvxzarv6nvfPD8MHtY
kldzF23C/lUPYMggwMzgrg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 9968 )
`pragma protect data_block
bKfehnk2YjeiW8LrFdxeL/dPFkPghaNks/iVBxbXvk31KNaVNtDrjzbkjscUotJW
u/AAw2MipwV3qyiciijYibFLx+Saif+lXaEHpREHkv2TVngZodLFVz6jNv2zJDli
mPkRSf/uvFAPj3jT16L8jppFa5QHo3f4Joz3eqXo6s8dITjR8lAlzJRtW3GGOc7h
Ighp/9VIsbyFNSyE9OH4SKjexiX3xio4UkHRdW5ZYpUDCeYgDq2cfNc1sZK17+5N
kC2MU78nrOGbD7lli/+jhrCbSSGZ87zFBsh8hOsAW6hyFDDxlAY9eRYLWhef2Wpl
+prPLQMr0035X6AuitS6hFZoLgTvE9wG3hqv6QII90aubEUdNzUfqdc49H7r5bQz
QmHhGc/eZcArYJn6BPGnTjSJeRtG8BFNyxP7z3EW2jIs+kPvX4u3K5PObI7aZ8hi
pEbZmLWrZBLGCu8CsF1el82uzpGQsU8nNJtae3OfgD8W+kGExy7Sry2HzbbVa/ph
UnhKMrtasFEuvgKdD+1k9gypZz0gchGXmH0YWIFkSPlEW3taPL0VQhrPchZqWLBL
h+Np1EFvbUobn/jUprC2Zm8beLMdEbqdVfZTu8Qd/qgsA4J7rVJNhti4anFJjroZ
jNL3yndT8uBn/3aVKDd9IzTtL4/ixB132b9i8lclNo7Q4Jy6/kCYTg9G85tTJVfd
OSSE9cclyzo3DmrcaW3bVKpmIsqeRSOjb5HvK1ct6NI75sTLmwyBDU6FDu4nqd7m
1Jy2Cn8DgIJ8Im7XpdFeSU13ix4j2TDTYvnhsGV6EKXAwsFNbeqKj9uE55vM3sC2
23dSq2m8B6jOpvjlfMqkoUngrze5qEJ2/kHCGoCeRvapluVYjqhejKqJZtC7pQUG
o3G+ALGTnUyYsVx1b/utnztbuOeD4CAsl+HD/+3SbehHlf8Fnxm7BFyvC3W6qYdL
qokPy2aS9XPrCha7zaTBuOJpWZ+vGXuZbwEV0+7Ufu4ZHKpDOoRM3soLbIEqQynn
J7MvfoL0y4CKx8wCLShy17l8mZ4gu/EG1nD9wLz7PN66fVNnvbzv/IvAlWjcuqSl
XEu0/2uf/SeP2hZ9U6iyxgmZYdSqhDk29Cm30nXjH/gvjM7kO+7vM2tIO3o8BAT6
SX5TPPTZ9mZgGkOwAAlrxZeiix68tlzI/I9y13SHsaeG6dmSJQQalCVH1P23F9ox
Yu3K/JEtSJDgUErUj5Tn4y4T7hVZ16CRPMWpPZan4KtRB2r/Aw2MhallxOWn2oJN
i/DpXP7r4wNYbMEYPMG+sxrPUs6vmsywUxdxmJAxoG4hzKeGXQeoKrn0BFS3X7Uo
vZBULoDkKFoh4PhDrkopG7nphs1jzeCGQ8b876GKo2OsXaSxIh8Vhp8TEwQZKjqs
uiFvjA3lTJyA/AG0b/TS98uqh/zKCrdJ7H6Db3Qlhf+WcVtg/X44JiwZDvHbc5Qh
W2TP3GTHMPP6TJlBahmnb5l1tcSWCyEPmeWy23QDzcercRMJOQsRJJgkwk5EZqrE
31xThPo4+VgOPulE5x1+OzMR5KDPH3LfgIK10FkPaQmWTZL2er6OjnWNNCe9M7f4
THBbrkMRdK4L0dM9ySGQL3ZlOHtQjRpioPzxA4pNfgdgZb2270skBaFXDN8e0UUU
QbFpNsY51rTNzL8J1mXrJgaLwZhFlJL9orakG09Qu48fC8jtrHtR3enrqO9fDofP
SEWySr3RGddm52ojmdkzwrJCMNnib2/si/yjQOmcSTTDwXp4lRBtB8B9zn3x7241
28s0I+HXgIMb2+OqyvCpzG5a+mo4yrTMFoPW1URNkdIJrp2v0gtxoDsK3/+TkymV
ehs5wE9Ps06QeDe0MUqDObx2GPRFep/TXPDurCRUQXWsOEIESIoR7tuKnnUGZW7C
96HeNMmmf3i+ceafjnisypoO6YzTmiDObuQx6nT704zMnDCD72vTCLjRHzcGn9OP
SIEr7Q+uSAkJLtmQsRGFGY/7H5js80tJDwrTwO9GnIo7RtfGC7BYLbAfjAgpS4X/
o3es96a/S5NGbbLr+mp9Pa1GQfFHaVfs++JOCMlkATU6T/1qOIHv6wbisY4rjQlq
7y6kiOhKxeZh5dzww9fjMuc2Ixvu+w9C6NDYc4hskJMn4GyLXYqJpy5rLEVTrzvb
vdDQDsy3qoHvIlDHFkTByFBiKBeYlXrXlcFiec4ll2BQNd9vI/ALf+TIWWtbR9uB
Gk7r2ZkMWCUBW8o4VdYlmqEEP4Gf22jz/0k9YHph+OWIhEWZbZnagS/gP52YKstC
pAG/9iF2X/88GsXl0Y4u+WHkFxgOV5oEpsmIwgl+hplLwz50T/hRLWTJWq/I+o2y
f6K47uh6dxtAFM13Tg4Z8fdrRKa+yVu7CSmp1N1otKX4oFPrBXPOsXJHqFeplUDy
B6XORriMjy1U95DvFOs9y9x3lY3ZoZfy9OokmuSYMCEhDE+8/j9C8GG0zMHfNaa+
DJvelnIo6asqEdPJkX8aMIq6y5TSaC5Kd7a6UlgkuzNB1GUrwnVFe3tEBlSayEwK
t8Ue4NF0wW8Z42K07ub4tYJvBdOqgW/uiD+9D++AYtGNsSd4QFAhdQ1Q91iYlThZ
+S89yIaZhDhpKsC/LjRJht49R/gbYbAeapVsy1Q180NFJW8k1CCeZ/vyH8LJYQwc
rxwS30axqiYkLhzAldv0RfIR+ArBOeYulZm1dbZEzGiMDNkOPuo7/YiHZupyEQNw
k3BwoXJWKxN7WZM8FD8CxSfzxLcvNhDmc4+M6QQYMWdFYAcdW/R0PnjDMK0PLCpZ
9jEcNUaEzfBXwJ0U/Ek5OKz/FK09oIVjVw6YycM3Ou8x4LNvlb7Vaa0gDgyqaCvy
yiDm0IChyTAMDUIF6raxwX3iJlgfBg2q8hO5jQ6vYdFkUynUY/g4hhObXSeJjSPB
iZ9u1U21znwW4W9dC3dllX4sEEh9O7T8hOc6X56XJkAcNcecFx+1ZJdvzs4eufvh
20GbLxBYxtkgMRNnheqT7NItbZ3UTS+fqsGTWLU9r4Y3KlRs8BqQSXYzTC2vVv+2
d5qUrcq9ujLGUcnOqpK7FvusOe8Ka0XeamTy3Qi2ORAaCB3CTXPR6aWNwgQ65VDQ
dlr8uHhMEA/FueNAiZpyxcjDAhRrzZm2yIPyPVFSThYx/4+CeKYVVGBai5IJ59C0
fPWyJ4BAUOvyei/r3qRdHSbWRi6AkgAr696RJEMY5fD9uPtqhj7VyxywxhUsImUI
7zrrF2EpWyjSlny2o7uj5dKpR/vUfbFjqiBWGmeNXc6m6XRrL+NK3pstc1bi40d8
6dz4jScjqWqm3oMseYts0dBDpJqiDWB+L4/zTiduSPpRnqNUTfgpM5vv6CVzo9nZ
dIScmXYwfLTNshq6TLekYaaY0izlOjBM/n6jGKr+uCY0UShYTmXdpXY6YP3NYNtK
09KwkMuHb7NNFm5JSaZwMh2FRJdXcMbzM9Sg0KkIXKWop0RIWOHZSZ8f13XvsOti
kbihkl+M/19afmDY6xwsTrYVkyClzimieMOW8nbHl4gbSQUN2N8+wF7Gg1XkanIT
9+jH1u0sksZarQGTRJV8fV7dnQx+trJjTqplYHXImX9InRwoKK5UHC0QjdHtq2w4
nv4pQiFgciku5l7Jf+YPGec/1jw8gR9wjwaZX48XG7OdSypTn2luscplwrwjurKc
C6aRGN4UNHlHnSQ1ROyEdyqUgMH9znp4Da00TgE4kVpuJGYqgXoGvfm1vCvZeDXA
5l1KdErn1FEmr3N7Sdtg/FNvGfqTCYusZCJkCxAVikvEzU0vft39UKRg+UQi/sM2
AzD9K4awKgDYP/9igKee07jnRWH6hED4kTNTCejklFGj+/mqVWVDKR8XOJrhTXVG
MzhRt+QUQmGUgF+Gxd+cSQgMflaJnRZDTvSPrFGWA5n5eoSj4aSR9n5D9I+qgRZw
VFFncLaS4KJiR/SuxMn2SLzryEgJtDM19AqN6vGlsFbzqDRyujOeySgWUkssXd49
8dFgKYCWGWGwIbYMKeLlLkudzDuqLsZ9nSFb624Zfe+OqNgwBPS8xFn8bU0d8ib3
kJFXVvMuB7L2+qSWwxKI3eN52GHhsFODi8/hchJZZBuTBszwCCylIfu5zGptyyzP
1al47TXv3PzwvnJ93oXP2kkKdz/mvIPsjb7s79/0LBAMeF94fMorwpVkhGpXOwEx
/BF0sDxMkOgJQ7Od9zTTywia5QxQGssYZ47Z53DqTKsXxlZ34ej++0r+MPjnKf9a
4+iYx2TGaQq3pc6jnOjQvbZhR0ufgVqI+2yz06Dw2cbSoNqAPI0WPfx7qYR5ySVS
EyFqDt/VLeoGYObCtE0iFVmWbBfPnJXoQqtUf6TnCUa5c7ycNwBYlwyeu7/kjrId
EIQSzUdheznYZX9tKm1hk2Lo9KEN+M/5zxfu2xN3Fbe0zSoMgmBFCJQx1w8ARNKE
8cQh0vnaqVzkErfF9AjM/s4AAWqAZ39I5G2+eo7DAQgagOTk7m4FVqD9u5JrlwqY
cUSi0t++yMt6SbHS7NPctBJa2bfQ6QbKW4gt09AqLL0W6/epieILHK2XEmvIK8vx
lCrHrXeMbt3+hpE/I4q5JYRXmb5sZ2YIcSlVl3+8uJ9bBE5o40Yla4jTP/8jvlSN
sKkv3xdw6eLVse0tM4ExRJUC6HFuW16O049J2kCJj/rGRaUJA/CVofgLP4QjZpCT
Ms7nqYjzr81AXg3RmPnl1jwTndxZ49WZpeQLaHi0mqyheGEGDF5bdO1MMrdoENOT
Y1Vs0noI0dPloU0p8b+MHKgMP0PoOyLRS15rvkjMJumawZj2ovVMzaZsRCSuYpmE
/vqp2sIseXOENHjAx9cJxKGIcygbvX1kxfcycEuOz7S4UvQmQKYkzQf4KhTQpiGc
d3VLH8j5PJmLuPV9palfs+miJVv5dyqKqRzEFjDasvo93PVFi5tSdjIgJJmR6NDp
AegCqdpr0ZgZupu7n2jItmntSgbQLP9jZTXYKB4NHFUj3IQtnRrDuYNc0zJiUKRR
AwOazD+mO5IsyeQtjAyJ+sWNuJI730o10dO3jl96S1MJudeMepWqffzIWJQLjKwJ
onJGIV8Oghsi5mz8pHN9tMHMcmYAR+52QEJbYVsmhfaiP3aQ4NqCeGYLg4Eu28kC
/iz6rGz5viu1yHuuBTs1aZOrF+T6+nVWV3SRoLryXEoaBtAnBnDMeqD7bl7LSe2P
NJHN4iv5SO18/XVx1OvBUfALHQK75abc2kmYBSYxUPM0dhpS5NewGQFodYD015kY
wvV4eyacRigVKv1T65Lx+/0koIRHdpjU3IY9z9X7nH4eCvy7xwxaXg8UElBEJwnE
u4CSupY/rRLd9/3JU/EXZFwUMzh1oewe4XH4OQvkXF/NuoeEpIQpU3m9Q/Pe9clV
G4b7gmI9DtkF/Kf5KhuWZpAhzGsRgK/I2bHlyDb3RLF9/UNtiLVWhZGVWln6W9Mr
qGB61LtgNPGel4ZlqyBsyUQgVh1Y7GX9cUDKAUsuswZ2W23Gu7+fVzrQGKXY/viE
ByE5tAvQnUUVHT9om2JpoUymOR3SrliPKPzHGbUgKlkJvWd9IZfn8gTGo3czTAg8
SH7ogNxCUKyXTeF5qqczP+cwiTTEVdvaglE1yFsMReWAGKc9mDTIp+gs9MnvvkKw
PQLu/MpOb/aTFjXoO6qtwluFDHKLOJnihPkZ9STbywy7LbloqLXzso6ASEdk8Q3i
pep8MFmLAxXt26QZvIaIuCtXvzgWTEFYpNlDkVBeQ5xUBXtcHecxha3XHSa4H75v
HpblagfjdW984mFi7HGOy21JPPWsC4uwlN2O/kPq312bJLxKtdgFk8wZJbusH7s0
8GEm6Sqf4xeO/um08Fxbsc4p7bBPEifctJTE1ikkOMrz+Un7ff65lTPUxofgwJD6
UutpyV6dNfLbvKz2pRX0bjiOBc3nMGtJDQyJ6arYI69CLCEcnOOR/GTJvA58OTAS
QQBnNJVR+JzeDSKvWuQ3k1TQmQn7kU2incofH1uGLvgjB/XhibnEkfbVMpScloHR
mEM89RnmZ19T2mUAXbT0MBFziDiJTXflSnv/qOCXws1UMqxyGJjenfUXj6ry6L3d
Z7DnefMYZACEH9GP1DdzCsMJZlw8iaIRm14rM27CFDKhhh9Jv1nx91gwZYYvOPBT
ku0yPGpPChXpTD5MsPAzWGX2HA4pL7K6KJ+Dy/tqmHbeTqpLmEYkFQQ/n46a0vG6
BlNYUstY9MuDDY2x/dbFlsfLKigN/Hz8piUi56M5xUjs4fgY/MHSmarRJH6tICIO
z90M1L/G5HavVH5+6Bvha9GyEZJEZxIxDv2DDgJbwkr2rOS2Fx6qRUcgZIeGZ5N6
u0ly9cgxNbKI3PU1h1LL/72jAT/IS9kSIQPeQu5Krl+qi6UhXov2WVxcSXOhpyP0
2CFFoAzqSP3VY7DpIKlUDtykb/ssDbbiD68hUx4FhkRbXhsLnrrZNHhpaOUM5XwV
srcEP3G2l6I9hH2cfOC4KKOAEPaEl4kZu2Ct0d8zkDEY7srv1LhZcELEWVmv6Dem
nD4hEycrENdVARDC/GI5VkFABvzSdILGZ2e7mwPUcffS9B/E1YhT1ZgWVXU39ky0
W9ropMV74ZyTE11h2NTBXC9fsOLs/mBCaCioZviOZhv+BmaCtlG2jX26/bHyKLy/
nopXMZbcMrRpDcTfbPlfUo4W3zbg4ihqCFMsqgIeAuS/x2cM1ZhZkN8Y/qVe0T/n
sotT1PcYJkAyR7TxaVz+PjLu2h7qkUikOIEWStp3dSakFO6XAovH47JhiXJQNOg8
2JAdbijxiltS5YVUeBBYI7rUqMQ7UW//387E297L5agm5jslaMKMcdWLNnfzdZGq
SYkEsoEQ9EHruyrZoMBeixt2HIpficcbaliWbh6IVFmzk486N3UKEy1DfDBXqe4c
ZNDwNUMvQU1zuRPIJwrHAYcqynGCLRqbkrMuJKiQjUzcHktHCXNTbZ3KlGorH8II
owPNFeLbKZRYnMS+HyBJWpAQrFtv0n/UGznfpZzBz9TWKQKgIESoQ0IFLyDlqJlb
LnV6j7g+eyFA2KdHdoNphQ66OUewn0fO413g0Rzenv6EmtVf3VdyvPWWvuMNdRZH
Y6MGBFrVWfwN74Ycc6mfbMI/ZDcohjLw9xncxGZo/zlUR/32HG16Hgvsiq5l+86n
wlui99O7Mh+voa5+gZpMxsDgFCLXCkc504ZGRqYx8TlOYVtVnbhtcDUw+KxjJEvT
4GFQ4FeEKxSr6aGjqFJcL67N3Y/vq7eG35wqqrTdbLYQdxUokzZKHoZkI9eKoUF8
Oc5lrE+ah/+ubL+XfZ9Qj/KBp1Xisu3fDXNfnkGO0IaORnuVkG9AJNeGsTMnzBxr
x+R57S7CRsgbWLdQT9yMxdERy/wAXBNTZ2kwxWn2cboasyZyZDfGBWVC1+/dLUmw
8/QIAXYVReX5f2NRCQwI8z+FL/cr9u/GZAf1MS0RTNVuPcRqT2TqGrsF+KRiVGw5
yUXqw8+kdnkMw5S1mwH6Dz8jagkUE51d9hxfyoIsDz5cnY0jCedxl3/xvFPMye7T
wrXAYNSBEfKe0weImFkgaB8Iyoc2E7ouaYLcKLrP6lPdBjOlC9x+HlGOkT+nRVPY
zl+jKkmKu0z85/0KU2DFdTxcpNNRVYKodE1dZeRDmaoVujJ18sNom7aMbZTwgKog
uOYWDhz+N9jZ1xStX5Huhfv6Z1bY0xossyKmIJUD7VQHQZjQ906tkVIM6LJSygES
4qWjOj+nshkwNuzdabmktqSwWQVRIK7Fyge7bVdAKQNUzRwhbcgXM9C0kaj6tZ97
SniF0sfaz4FH4mP8vr3c+ESe1qvJ9FXj3Rj1DnyzctXQJk2ztcKcfo17vwit6FLc
uePcBwl1Mphlwz3uZcOTTGghsycB92KSI6A/T4bxd8E7P0AlmsiHCkX4HmGCzRT9
rG2g1zT/wUP4ZkGGpJ/ujbu21aOdXUBUtZtnQFlD6cL6F0q8YulNbtlZC2Nv045D
PrHitbtQHInqtRB82iBxqs1HzsNKlFqV9hMsu1NHD4XH559ZKyH7eBpoYYEoPA4q
bHL9WfVzPYJYyOFuLz/Y6LrC1HuP6Tryx9L9rJsbh1zY8UKG9P/OIBvtsMOjTjxA
tHWoe9Nx/iqs6NF72dGGOMov7TgfbNJxuedDPYxONRddigJqu7X9YIiNJ33gQZLn
dpEcG1vzfYNYrYxKpWeFBUVhhxb1ZL9PSnHblgoGPI89GZWeHEEBO2S4a+nsUXxG
6xdpgQ44ebeKnNGdotdNdH4gmNADpTysqhIGkRM0/ThpC6zAP/NoOQBQIv6/zi+O
JeP0SydYRR3VdYjVBL0T9KFArP1Ixe5drzyGDwgYYwg0ZYvU3kVQJzBmHHhv3kn9
k21qBsIJv1V3Dj5SizTwE3cAKqsBNAFtUd448nb7JQV9YDabe4VQBHeQnQB5lMr7
m172PKP00F964uYZPmzcWlGAjiZMJVBpvp577cBOpZKpIfplK/jEK+IMFERq1ji2
BKYNX18Lomlv3bInFG9bL/WIdYt6vCLiJJVEI5G6LqQWe5qHq1v4DRd6tCYSZa1e
RBf1ITWKUNGWIQfkUI0Bk5sZda2atstaNNv6i0W7QGLtPjGLfUxhv/yiBkmWCqdp
lp8oYOJdeC5//dfr8paQtoVFX69ssk070g0vWhz2TnjP0IeQhh0RIMiOBBQ1095X
ijUv7kFKSXee78gfZfk29+hHI8UlZPJCPCrKqTsNeiBFPK/wJl+/vAQTrna5ZCBn
lqn+ThHJCxuXTp/PiEy87L7IZUCOyzLQa7qK3q+g+fvsj03bJcdgJicYteX5yLEi
mig7KORwctqL28/6+RflwpvZ1zvb6syqrD+rje2Hvo8KH1YU80raFjLaM85TvlL5
konX71v1W56K87THl/hdZeeJv/gLee02i63k4mG0ezZ3Lg9UjVZVxbvlpCXWAzuf
Zvlth21UvlIB57I7+1/6Sp1Jgu2yCUlFJVCZhNa692LyXJ97sNfHpncwgGZxYOCK
XTq0myTGxV50VpS8kJHuE7DqiRr5lu978diVozxNtAkttMi8OpJSrihs0h7Q2wRd
0RFVifApoi2TGfh2SAUIZIB6jR8lwS8FF9MpzaTuuco0DebIxV7W1Fqq1OfsABrE
ijN1yPvZ8io36fqsPtCLaVhKRxMkXsK2+I8Id4tAiT3DVM7uvTvxdUolnGi1KrEl
eNDsZE4138IftJOZUpvFVO18c/7N3ykLfX/Qy+lDxeyueZL6dXoMsX739PPalvfX
3482koa3FnRgA3Y82czZ3/6lLW1w8zrXEckW1rhyUUTTSqTPPoIidP9lfZo7WgEk
EF1s3bYIG5v+PuwuDr2u+3rN6n2KMIhSvUPakz9tz0tZN4esR7+B67pVzRLyNovs
V8Lm76XDVuLuLMn/j0BFF4cE41RSR4sWr7wbgBEhFVNh4c2D6bGZRLU9UhEEGsJ0
E7k5C8sNQss/dBkZGSa1LGyfWkTtHAcv8j+ohxXG4i2VwT+ckHM+XkP2BmG7tbIp
qGz5wmYHVRe8CC3sWopV0wNB1I+XJCbfObSvXKdxFbtllIISmj98PH8Geqr9wqJM
uRCb3whErx1KSBuytoJAPfYfjbv0y32kZzLQNPSJWf45KdtwGbJT8nsAyfyBjN9r
vyainQybzodH+4zNedC571TILcqau9twD5ccVON5ZJ8YYjPAtGrDAuotKzi64qC+
/mbvFsJuWucylBQViYGwhV4WAZZCPqRKsSr9eLXwtYUwmc78AngGWQVRstDEdTLv
A8FNePffd4UhKKgEX4KWsvi1AaeyGqhChJCHrml1KBdfNi7B5H3NqHWeP/ftCdb3
XEbl3uFKRZuVofyYXk0+Wi33FrYMkpBa/M0JxAYLGhS/FYOhXLPDLfumbT2cXfGS
j4ybfVRMSPWPzu6ty2Fulm/g6p75CvrOj1PHabNRJTA2S6qm6pT/Bnbcg8KKbi9a
crWGL2TYZTkzzV6gwMbTGDont7tvDJSYMhu2B7ZkxV3kyBHqmA19+65aVGgru77g
CF2XZhw4zHMp3K0Ns+cty1os7SJaD9lz48D6u2B8bo+G4u88Wgf9b8fEfNE9Alml
fOVUgpS1viixD2+19L9Bbptp/rryaXvAn9DdrPSSOxhhzsC7hOo0kiITsGC+oHaB
SZLQfQIQxURxfsnr+bmh3AcsOfrtJ7sgvNEY/zALMI5aXeQl9dty8ogsKW9qDYds
a3MNRTWVWgzjOPqeQHv4So22IrLf5iE/FtFa+F9+hcTFSg+Ql/Wv+gZ1BEgngNCk
TxBLQJdgf0bFxlIjUkG4O0gSB7YU8V2RMfZpdxBF8gkyDZHD5e5W5fkH5LnYwSrf
5nxLkIanKogiInG7+6J4KZugpv7FJyu7PxLwDXTRmoskYjWox4CskKTEHYGnwIDF
hVHNIM9ZGCCXo93h9KFj4sVuGkdilieKansUFt9Mfywv+QhLP3yxP69vp+kEdPcG
gyS9yXsKBd2AgFLNeQk3ZVsY2cjAoK+JO8U0c5ghphiRbu/assa8gUHm5+PFJ1Fv
hDSNY1CwHfUtioby5vhM9pJB+rif5kb9opz15Fvjwf9CIiIKQ8XaBBqt9sFYb16t
lTWrVLcjPhMwoa6hPxGNR/2jt6+tB2KgkgycwvG7DbMUXnPhrcF1EXl/Sx365dzw
McB55qunL8VGYX2RDGAmQTRym2n1A6oPq+FoJdYZ+pd8jPp2nq75Zj1blnXRjndR
T2m9ydHsWuIUhb2pBlEzZrKns/ZHPIf29T6Lk8Zr6e2PJnCaGCHjVhnhV4HDe7us
jd5PrgaWSNSLCDUa4TnvUdTeITyAkOACC00+OLREuNyQVb6Yf16Ce7/Od4MmmRMy
Shrzr+SEGQm6rQG7NxDn1bBP6zPIaoe5fi25nNcVf8QKj4ik8Qe6SGpiqenlbYUh
FxFzHWtOwA6il2j65/hxH0slrw43lYRgPPGKLlySnTTWE9YA/6gmeJqr+u9QgrEU
1lBiTQq6B7B7AwRZB6L2s2HYM8thCM4kHV/PxlAhVmGfV9t45fwiTfgd582Bq5Y3
KayR8bM4CKV7WsjmnZgCddXeywELbq4lvkmZvkqY5VXhh+AICY4ktK167/A11vB/
8JoO49K+AAb6MIP8d7+uwpV06UIsYBxkcdCwaHgOEvb+ckirvpv6gZSxYGbTsQ46
Z1whxn07SR3xjQ+J4/oqQLOpUe2hluz5ZqSae0B3HNUR7G/REwscoRiCxlgyIijF
BL5lM42wpq8hdJiPp6GjtyfpRkSe3cWrv9qAI9bI8ae3jMDNnikyxuDPikdhZh3d
lWw3dj77GzJTvL43bWu3xyAJP0ZGkHtF6Z265p1B80G52rVWKvcd0ubsjTNr0Vm7
vp6BMdmc98fWskfpR0It4H09bPAY85B3JDQ66U0zGTIBD7zBNZf1T1qbte6jVGqS
hBBRywesZWCRLEdiE1RYYF00n3IFLlPm4ecOs0tY8QkDiW+KXVfQNGxyVXo9kNyl
HlnxWCvWBami/rOndW+tnBy63habwysQjQmOtBm/SEFMgWzGZhd8ASqvMghlv6Ot
HjUeVnEyJYGXLKY7YTbHyKnXkG1Ekr7DPeM3RzwIaZ2ZPyrslNit+A3n+R7nTmFt
1UHlrlw60n23AV5F+8ckRztxgehcNVt2g36g+v72iL3jItspPRkh2SZO4wqXeB+J
SEtJZDyk4XQ9E+p+AOxr0CixN0p8jiI1ZFRaCQSZVFH2AtG5FwbeSUEeWPFt7K07
UTXYSmcYaMxGe3FNw4XRWiVeuq0b9GmyqJ8HTrcmbzsAYT25zJU9TF/16IWpl8nR
fJTsl5sFzj/Z5HDWPFjVbNthJOaTlTFoHmOiNPzL0RkCDnIG90y8BG5ZtywkI5zf
2fmTefzBFf7KZ5JcDS/J+UHH6ERVPb5hayvpaAExrD3FHx9lqI9pWKd7je1nzNjN
q+/lC3YTBxeATnIJPGzlUwZG80PyyrSGgxRIOijIIpvIkEjMSOy2vhUakj4hXjEl
VJm0Rybd+fyxS82CYrCjcj5H2yNCLy9K2oHbpNL0gb+Tgsjc4MPVCgThFsNp8GFd
7G+OasA2z6idcQJiVJ3CvFKyFn2g5mvrTV7wGFrakmOgiRrZsJ/MAtB5HGRc8S/k
Ka9WNckt5FkEJgJ8WXymJdoJcxsv08iKRulp8aTHlMTrPc2Qd72Ql/ZT7ohwPvQD
NrAs7vht+iJ1yt6w79l9vxLpGVq5YNoZGIWD1PSAMcTcUvVHUzlRoMuhFTLDPh2I
Ev+3EFx0Bgm5DFXLo5Z56GfurDTzRh0POs9ut8DOre/x0Le8jNDQspYv9QF8g7ho
bUVnYBO3ubN/XbTejBOUAQWTL1HpymCObkEDOBbgXRqWE03TQ90vupRExn375Yrt
5oN9JmBdczCQwLRWY0F2IU+TLFzgrb4M0GA9FzlAIWYEdrVBWArQlSRTtt0Tp1a3
kDeE6tV8EyogBYIdmkyGsxcWcZZ9aMmbyLwpaAvFzK8nqY3A83q9N5fOfI2zhTa6
8niaXuFodqWZBTBTgSyt+LaelH7C0Le2WyJeFlD9oPcgAeprOu7r2KXCDjQ6+00j
DIuKSQ+1lMh9dkjvc85JU3jKbw3xRmihKLsX0dZu8m5LcC87dPE+4eqbBu3bnJxo
5TlpfZPYSsF6Yvi7J8aIhPt1j6brFlZI1uzf4sspzd5UBvjrcQGlnGdCElGdBp/t
XSvxLipp4evLQ1nDyBMo4k4zV6cUa7Vyn17fiZJ0Vrde1m2UB4nX6elB7fuCJSdb
o7tlMEh73c89Cove9wIiWFdPCe4pXf8qtAikEW6xqNlVac3OF9pOEkIZeIfDf9vR
+P8NRO96BsbvjrvmHpkQf/DJA7WZB3/MQPTRcKz0yAtKu+yaPZ5veMhi94ehmY5Z
JfhTaxSVLdWF7/DlFDAeOlT6yPES5FjWYBMO6I9PGYxJ0+jwfX31dV39EEu6S+Sn
Q4POPar4VCRS53c7A1NuZFwJAXAOVnJFgsdwVJQKlgEuuFqf6cDwQQ+x8CAjo8HM
R/tm13h5CTf7sEajoHGnwRwt/jqlMcUBk/IRMG69lB5f8Rq/RdE3lR1SOTEZLeIu
OshBH6P0GhIo7w1ulrM8l2e61GH0olw9RKRm9PJxA7+YJ2m2Oey9U+C9n03bowPo
uYpHtfCWln8UEgQ5VRpViS0281lXXnhL5mcQDSisUzk=
`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
G+QBI3K3KslKyXd/SPhSbzvpWD3av0TIWfklm2iGiu7e9jWrLsp+TT6s3WYMgNff
BF+us7iwpRK5JiKEIswF/FBLpzY/izuAwrt2UsnM6hV0yQV5e/PWT4bdDj0hS5P4
eazcyqVFQTlhjdm6ddKvn6pG99EvHPxtGxKuEOExoaLjubN80iolyylIUhEs/oyu
l798fNikIdR1syKfzpwTxaxBjl5oi2OEAl1CnIF8ei0b6Efj9lZ8SKklN6rxbPaM
jssQpB5GT/V1AHjzKCCXArx6bT+I8YHkKg1g0jpkwsi7mwmFkSLvNv4wobK7oDyu
eFZRUoXNz31fQx+IT2fCKg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 9488 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
j9qmKfob8/WK6Buy60WQrTWMHKyF+zuNfwKNX6bSPIy/qUaoCqByZ5ajHTI4b3T0
YCxf5WfHqQs7sMrfRGRQDRRq1w3p/bpRvx0eRxTzvVLFNfpkEpOxfK+tOqPvsG1c
8eYwwNz/2cQyJD4/rFB2WIuBX+i6Y7ygunb/xjLcwnxBoVi4WZHeoD4slnsnriOn
0FABP09Ebwc0pvF51n7vHuq9GDQP7QX3aMGz6UGMQl6aLEsqxMBi6PHEo1IiVF1M
rMfkXwUEcENu2c4vhV9+Gnsn9q2jWRdfHQAjmWqBkizqUmhxzHBJwr2GVr7MzpDR
cFuyHKR63Soy8YkhNoJUVQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 1664 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`undef IP_UUID
`undef IP_NAME_CONCAT
`undef IP_MODULE_NAME
