`define IP_UUID _mipi_csi2_loopback_design                      
`define IP_NAME_CONCAT(a,b) a``b                                
`define IP_MODULE_NAME(name) `IP_NAME_CONCAT(name,`IP_UUID)     
//////////////////////////////////////////////////////////////////////////////////////////
//           _____       
//          / _______    Copyright (C) 2013-2023 Efinix Inc. All rights reserved.
//         / /       \   
//        / /  ..    /   
//       / / .'     /    
//    __/ /.'      /     Description:
//   __   \       /      Top IP Module = efx_csi2_rx_top
//  /_/ /\ \_____/ /     
// ____/  \_______/      
//
// ***************************************************************************************
// Vesion  : 1.00
// Time    : Thu Jun 15 14:07:36 2023
// ***************************************************************************************

`timescale 1 ns / 1 ps
module efx_csi2_rx_top #(
    parameter HS_DATA_WIDTH = 16,
    parameter tINIT_NS = 100000,
	parameter CLOCK_FREQ_MHZ = 100,
    parameter NUM_DATA_LANE = 4,
    parameter PACK_TYPE = 4'b1111,
    parameter AREGISTER = 8,
    parameter ENABLE_VCX = 0,
	parameter FRAME_MODE = "GENERIC",    
    parameter ASYNC_STAGE = 2,
    parameter PIXEL_FIFO_DEPTH = 2048  
)(
    input logic           reset_n,
    input logic           clk,				
    input logic           reset_byte_HS_n,
    input logic           clk_byte_HS,
    input logic           reset_pixel_n,
    input logic           clk_pixel,
    input   logic                       RxUlpsClkNot,
    input   logic                       RxUlpsActiveClkNot,
    input   logic [NUM_DATA_LANE-1:0]   RxClkEsc,      
    input   logic [NUM_DATA_LANE-1:0]   RxErrEsc,
    input   logic [NUM_DATA_LANE-1:0]   RxErrControl,
    input   logic [NUM_DATA_LANE-1:0]   RxErrSotSyncHS,
    input   logic [NUM_DATA_LANE-1:0]   RxUlpsEsc,
    input   logic [NUM_DATA_LANE-1:0]   RxUlpsActiveNot,
    input   logic [NUM_DATA_LANE-1:0]   RxSkewCalHS,
    input   logic [NUM_DATA_LANE-1:0]   RxStopState,
    input   logic [NUM_DATA_LANE-1:0]   RxSyncHS,
    input   logic [HS_DATA_WIDTH-1:0]   RxDataHS0,
    input   logic [HS_DATA_WIDTH-1:0]   RxDataHS1,
    input   logic [HS_DATA_WIDTH-1:0]   RxDataHS2,
    input   logic [HS_DATA_WIDTH-1:0]   RxDataHS3,
    input   logic [HS_DATA_WIDTH-1:0]   RxDataHS4,
    input   logic [HS_DATA_WIDTH-1:0]   RxDataHS5,
    input   logic [HS_DATA_WIDTH-1:0]   RxDataHS6,
    input   logic [HS_DATA_WIDTH-1:0]   RxDataHS7,
    input   logic [HS_DATA_WIDTH/8-1:0] RxValidHS0,
    input   logic [HS_DATA_WIDTH/8-1:0] RxValidHS1,
    input   logic [HS_DATA_WIDTH/8-1:0] RxValidHS2,
    input   logic [HS_DATA_WIDTH/8-1:0] RxValidHS3,
    input   logic [HS_DATA_WIDTH/8-1:0] RxValidHS4,
    input   logic [HS_DATA_WIDTH/8-1:0] RxValidHS5,
    input   logic [HS_DATA_WIDTH/8-1:0] RxValidHS6,
    input   logic [HS_DATA_WIDTH/8-1:0] RxValidHS7,
    input                 axi_clk,
    input                 axi_reset_n,
    input          [5:0]  axi_awaddr,
    input                 axi_awvalid,
    output logic          axi_awready,
    input          [31:0] axi_wdata,
    input                 axi_wvalid,
    output logic          axi_wready,
    output logic          axi_bvalid,
    input                 axi_bready,
    input          [5:0]  axi_araddr,
    input                 axi_arvalid,
    output logic          axi_arready,
    output logic   [31:0] axi_rdata,
    output logic          axi_rvalid,
    input                 axi_rready,
    output logic          hsync_vc0,
    output logic          hsync_vc1,
    output logic          hsync_vc2,
    output logic          hsync_vc3,
    output logic          vsync_vc0,
    output logic          vsync_vc1,
    output logic          vsync_vc2,
    output logic          vsync_vc3,
    output logic          hsync_vc4,
    output logic          hsync_vc5,
    output logic          hsync_vc6,
    output logic          hsync_vc7,
    output logic          hsync_vc8,
    output logic          hsync_vc9,
    output logic          hsync_vc10,
    output logic          hsync_vc11,
    output logic          hsync_vc12,
    output logic          hsync_vc13,
    output logic          hsync_vc14,
    output logic          hsync_vc15,
    output logic          vsync_vc4,
    output logic          vsync_vc5,
    output logic          vsync_vc6,
    output logic          vsync_vc7,
    output logic          vsync_vc8,
    output logic          vsync_vc9,
    output logic          vsync_vc10,
    output logic          vsync_vc11,
    output logic          vsync_vc12,
    output logic          vsync_vc13,
    output logic          vsync_vc14,
    output logic          vsync_vc15,
    output logic [1:0]    vc,
    output logic [1:0]    vcx,
    output logic [15:0]   word_count,
    output logic [15:0]   shortpkt_data_field,
    output logic [5:0]    datatype,
    output logic [3:0]    pixel_per_clk,
    output logic [63:0]   pixel_data,
    output logic          pixel_data_valid,
    output logic          irq
);
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
HOMTVzZreJVSnqZFSmye6kUNxiLt3RR5mexmT+Af2eyvktsewhNM8OYUeiXIMKQv
URpHnyO3S95XlrNXy1giH0eVUTvjz504U6NRxe783pRrP7lRAFWwah5K01j6bhCv
qpsL8oP3e5fRObdS24ZEzihgxdS/SCZhYDpoJh9TTfZD5I49caDCzM6olZbI6VUj
WxU2hFNICrcuYw3ysTH5RXZ3rblqKlK0n447TFOus5FwxiZhSYA0lcB6/wnNDplp
A4CEv3gjR1zXMF7MOyK7kyqDcyero9zQN/EaCX0mregoD8RGKOf65M8kc0ddS+pH
O6uT3rFVpmVwUD92Ne40jQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 19872 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
bzAekV04NWCYj1+1qqZchi8TXtcBgLllTYKF1J9nWaQAyFDwvncXxYyqmTKkd+Q/
DpJlTCGz03RvAV5IojttPOwFVa12cGIbY4sbnYfcv/tQ0CWfeCNL8+RIGj0kIsal
xghixBxpFGM7i3z9IrOOQp2TVt1daik69mRmV31gF8DQ8F5aVx2VUksvM37Cna8G
XkNmmzHjnhzGxtqe4RrKa5Lk1CNGsqz/Fp/dO4nHz9ohyNBSbPPFJ9OF1dOAKnIY
TQY1xSfXLf2SrT00h8TOSM8s8xwWt+aFAcc2MWpA7W08g9pCZnNlTOgHtHoQeIw+
+q/G28uebVtVCkjjd83Wdw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 944 )
`pragma protect data_block
kt/VvuAPnIn4Hg64MGLKlyYXn3J36W87CHgFPsHajbc1NMOwh7MmXm4L86wapUPB
vIs0OoloOCL5OpTymY6d6zkf/rG8mAtNwrp31SbNLvxA+nwr6icFXKh/7O69V9dU
Uit7QT1AxrVqKvJlrLW7XQ6SWaUKZ0lczBqisPNQjQb234klkxfVZjALkMG82X11
rs32nNDUNw/hMVXoqvFz14RDSSt9RqMH7L6FzPjGMeYrlYPyxhykWdi9UuhtxFlR
TEFMHCy/PAoK4MERM1h7lZAwTquO/sHcmm4ZCPE+yyCPLdUHCfE5m/EWUP4g7w7R
kJxcVknTzzyRSCDr5PT/utYTRc3jxs99G+4zwwT84hEQ1B6TE13Y1HOcNuXi8I57
jZz0UV0PocaWyJrGzOh0guORYu9++qw/ZpLYO7VCb3IIm+G7qwIw4d1ZP6w48dkE
piPBZcXKg072sv2x35VRhlllN+Rw0AF627ATfYmv/t74i2uDcrnw9spFVzkEFILY
I6o0yV7Apk+4DBT+oq9sAN8+jiEZhX1Fnl9dX/oSNm0DysUz+BKeeDxNrLXlIEYP
iVdpkygwqkQ8rrj2zr1qePRvpZZEfMa6rxS/CVvAfCH0WvovS0emiV1EaQ9ToHPD
AXKb9aRA3AfA1LiB3KuxouMCGeI2NNesOXnRC9I5I1dI7cw1grwN6nTmLUmHvP3K
nl70hL/ilv6GuogoBoXlVUQyMgxUUYyB+HkIFGg/ynamL54LkUVKjHknJHhGrJWi
75yalMnNpTqQfKYNiG5FIIUwtPuqAgfe4qlpY/RfislTDQSyUyds5JeU+RAiAQQ4
sQFbJriEyW5Jsfdb40bW9rQ8HsZnPvq0tUKDVA6y2yfC1P0NRNOPCHhSgdFB5VCo
DI2su+Y+FM+DDnK2537dyUXQGR8ug0LxtRqtgGTK1EZQlkSalE2e8ewgMKNuD8GF
aCPz3Q61mlpJvBXApmPVs2+bxLIeY+yfI/ZIdq3i86khGrQ/XoTLVmzJ5zATzWAv
z6zhZN0Np4bOWKMYhK8nYNmwUkBCgGtgFSLOo1jdQVPcNzX1l/I0pTDaiGEuEtGA
Pzn1bmwIqXhx4RNVE+j9HldGtqSV6vJK0/GltS7p3vw9aXI+OH5O5QlRPb1eaMNN
UQoE00jaqOCIWWHIMCWymiEEjDcQxt5zjTVrNrN0YaRRsZpqGRzUKvhRT8ttlP46
uLICgH5tNv2AGBFunbrkZqdv6S/xD0CAsbUtvopKjm0=
`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
Ro4b+BfirqJ/K+1xE9gqqhgnDcX1H2dbbFECVzDEqactlD0MiCqpGuIjMKKBQn0Y
fl1qU3hcw+URum0UxxcSZ7XstGSfwiOlJzOmDbm2JzzuR2F2LQ7vlTytJTYi67Wi
zrNAZBD1DLz9n1Vl2aT+U+Vxfrfr58hxuK7jY67w7y92Hf1Gv5hQ9ffz9pu05L4E
PXk9mbSCbrkEUkj+TgXqA4VHBKhFcISHQb+fEFOUtSRk2GnJgsypCDa470v8ElxH
gW0KVd1P94Unu45r/FmgVTLKGtPipCHiRrS7VhOoCdZwGvtLoWihr2QwJ4lp5v0m
GMTSwozzThEgtKprpZyOIQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 26432 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
enFrYkTlCeHfG2vmDgiV+1Pf973Ky2rVjSLYHUYmQTRvWaPC6xShhqMlDj3JWN9H
MzMojnuISC1NF02KFxcoM+ft2FlW/OfFv4Dv8uCM1k2hyX2v+ejeG778roxei9YD
gc5XPTpuajmU8jmgMNI0DM7shZsHVftniNtrf1NILd+ZWfXdHShuqhap7D9TNuvB
7QFbDfqXIlDUHxuLlwvKNTOGsqQF+i1njSaWIaAXSCZn1pKX0FeboV567HBUfhNB
T8B1Xid3Evh+M9BPIuWiAgXrE3A7kchf8QMXeq4V1O0GsTfjFfwa0mNVPdepCq6P
hpUQzPDE5/ds7UWfwp7tAw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 4672 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
dopCbbeWN2VakwuWFGcOJXSInshC3AKlNlYGWW1TsU5lNwLjQ+soEsc0KLkfZzBu
S+lV3imtVbEH5us4Ys9QZZNsW9F9JretR4Hh9LWeFD/msAS9bk6H4S0NPbma6i1Y
uEJm4H286BdY/oPKIEF4DRg+ywnRdC+XtTbd4ztXnrop04zVb2ZpP7jZi/GMMxCE
2yiHNLqDMn8HFmRRZakd/wgedKouoKWB1xYEjqTXZQ+4MTDAefmfMZIWYQdX92KR
NcP7imKyqFNG1ztS22TclvYZTY0qMqkP3N/UJZjImJMukh22bsi6eYUOeG13tmjG
T0bnQ0ib4DLImrSUh8MbNg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 11552 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
hOPi4G+NYk5OuxK8dQdc7hoVC4aZtIz1L0nUeyIkMW3wTuFkih308DK9kN8z2NHW
3S1A6eLhxfcRpARrsjROd4WpQMc0soD7iN/vCKgLAKXqjY1hL+r39Qh+c474Iuui
qPnyLXyLNVQhOb4cX3dA+jYF0xt1lzOKz2FWIz61DhXpDyKkSLd1P0SsOrlj0bsy
i7xcQx1/g8SxwhQ/UBf7QDFfNzf8n/2K2tZWp9xsyDOQfkeKt/PP7iqeRdS26iZY
4z68azI094jdVMOZwvJxuJbw0fyhpupRTDcvoqkhxfH6GrS61leZ5BVeph79tUlA
MuGEYuSXTvTfCVMdvdQ3Ng==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 31312 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
bKdPQdULKdDuyakUJwG0QDIX3nB9lfNDUC25kAuGgf9d/0Qcv9dIf8Maa+RrPVQO
j4v4gPZfiHIOdu2EAUgTIm3RH/pAs++p8ZV5sJhiKAeM6gZ6B/pPw9i6ANJ+e8y3
tB2J8ORaaAmOblVcYI8m5jmjlJRPVPRZnzy/20HarOc5wj6SgqcTGDK5v/BnR2G9
Oy3IyZy2dJ1T/9XAe/GwsxGd837NWs/PQiiMOzMY3W1iX5grjr4vyGFFr3uc8/bq
WmmFxZ/5MSjy9q0QF7EtWdwlyx2YPK6UrTyew3k18xYH8WoPi+mff8LUuISe0wdB
Gkbcevurz7OAu/b40aw5SA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 2384 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
cJCo6QV6jZHKjVmabclLNWQ7Jk95cwEvkCgQzqN504wxHpZWeuTQq3HVQ/ubpX0P
1JGRCFVTazKzjrhWDQ/GXE+90Qgt/mA2wQVJj91uCDjuDcmjSag6BXRyqH8toEYs
Pb1qCxKAypQvmFQIwoAv3uTECsgXV33dhniq7bsFZB1NkDdnjpn1B7oC7rrJcFC0
uznhKb6gdUf84vqaZYkl+OZ9zSRIxDEuYYtfJf0hnnH8+UE2MAz1tP0CGnSYvdNL
gWdgY7hBXRnoz7cR0JwAxJNTI2+axccwDPzqfjxwxgYpjaVEhDJLVP4+7uCoeuzJ
8+IrEczkdCymqOANQqzdIQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 6048 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
XTJCK4RzTOvRmTAvbmUKheMTd83xFw7cnhuNYW/57H2vc3xNIfga54hx1K6GBWwi
x93j4fvAailII9l66atp46AuzQu9EIXAbmFBei3V90YICjLKtEafmqf3keDZewZl
Sb7CNw3kEZeNcbuBIA2Igg21zVZYEeriH6ZIlSA9lt6TK0bXLw/O25E3MlWbsU0S
w09R/pacfyijpn5/mNAJNwoxsr+/lmvt+1gPtjothFSbpf50aYvz+L2aJo2bvwh3
dGqhKOZKcNkqpPvNsfGlniFTjWtYXixifMg0IsYyj+SLuz6oJy6TSearl9VE6aJ7
EoMxsoywqMsiUsQTF+KM8w==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 4336 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
ZjV8QtN8BgTN6MAkh6vDl7HUyvV/asqXtyo5C3QZQO3LyidAxfH7ELFtf7n2JBQP
9jJPUaGd/wQLhhTaXXX2CrBy9J4+PRdKM71B+uuVgEdm82beRqsbgmc6AJhxfo8O
8Em93KnrYRLldY8SSxKIqjy6ChZyFRpzE8JqK01kZArrPnTL+6BeWpC6DLluZ4jv
BeFc/dwauTP+Ry6jeKhuI22v6dyQc4OWXDwpifJ8gkAlAzRCACsqn7AWDEPrjLEZ
IVVAW3YiLSwHixve1qHLD2KsT7iNOCyGMUtmRkubWXaHcYHYt8Qk/tYFxuB8XH52
cwvhanTCzYl4/dN9YAC4ug==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 5728 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
EgLoh41jjLS9zf2FID7XCjO/i+ZzJOi4OtOLzm5zoSCPw6/KikMeXjYk146JpGwP
nDDQtHtMYvXyL53cgEDWPw+2946B613mcdHGCWhPoKfCdW8sZbxYQMkn5WCtyUfs
EHmxq7c9EVCEYRavOR4Osn1t22AN0SS9fGEcaMaj0ORMK0vGUChYfJvxNCehlomB
J7sNRdcv8bu1iwRRbQREEkjYMqHnJ0EwSem6mQ6iudbuBzqlw26zQhXBNFbkUkeP
upwZNlYqWpy1MkqG/u+Iwx35BNEQblP3jkYxL22UUaZMU13SFzWYgKTR1K/TFHyX
y/aIPzLZtJ2l1yAZO4Eo1Q==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 2496 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
DYS/4W8xmCn08yGUk3GQ8zAtD+yxeZ3iLgC/+LVN/zSxkuctl7K29VDzuazNauSk
5RjPPZhp9+RX1msXeLOLn+SUFMIHmzxROwTHlQeaf47GP++RxOtK0lkRbTkQSEWj
ZMQIRgtH69xwxXygMjzfLUA//SF9imTramMynJQ4SrsUIi3FI8AolfmPdLnwImbT
zHI4tCAqMOELiGiwLa8yQsDBtcfEiKu8QSlhtOuYakq01Dxj2iHC/WgwStOpOUZI
0QT0Yw+zT1ipkUpfqVxrwrcFnjUWY4gSDXCqGiNJmqUzlYBGeimBD0VDLNZHL+X4
zi0/4eN88GvkBUsgXe5M6A==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 54384 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
jhhj2GcBbnGtlRgnIXiFFR3dIBLKOAsMruYFzhzrkCayjBa++LT962WG0kvOHoVG
ArKVQHZe+7rieNzKDneJvH46nclPoZZSXUsw0A6ppFDUKGK8qybONFVu9yFCTzcP
VNlXQMRU4+zuc7Dsp6Jx7YKltj7o/LxCGGyGspl7Q6rpEut3KfepRjl7oagz4jGM
5+Lrfh6z5nyrbDyFHWpchLGn4jiyAM6YiNkojGC9sOIZZT2vRNGPySeg5VHjE3Wj
xrqwTyyKMz3t30hZAJxyiIpfce7sx6DmOGhpbf1+8m7Eifr1Ec3u6DLNvsdsc64V
YQIkM2HbFFu5TFnHvYLwkA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 9568 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
eS4ck6aMH5ADSdF8gtNrTuhBmK8aEzioBgwYE45PgCydpo7778D19lqcd3cyr3IL
3H4+Rk5hJyQksWW40iIEOFUzylhGj/R3FDZ3fWV+c12be3AT8NDDh4cJin9H6MAy
5r319wpGMco79vK2dXONo/gKIjs1D5znu0FC6U/IRrvDapfLYHQZA655j18lZ+lb
+Pxrezw2xhuL9cx0Vctt9dw3/kLVPPFZlxdlBifh9fd4mgHLbDWR9JPMhUaatvHs
XXMf6TEabLQLUcqZFq3aOAO3VfKtnv0CuiTMqoF3VHnLMAERg9+CnQRDTZ+GLf3X
qrSIoNKDF/XTUPpybi8KJA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 3440 )
`pragma protect data_block
AOr5H/AMASUd0Avf4j5C1Srl0PBKKqlO/HZM/Q+fr8YB8JY+NO/Fc3WZItxOWnFB
1hb9qiSvaFuEK/9QSxUqivvkAYwkGpWJiH+WfEYHVkeSM3gWNOG1uJIJdR4tdRnC
QLGGuCyA5TfLB+J/CStqjhLaMQlD5qhm6JTOrR0g3mvXKjapvA6nw139yZZV94gH
lxpCglLxGg238iIh4oBtkBY9nStunbryPHp3KgylZtVjVy8T2VbOO0wrYRo4+SFG
rigg87wiGuNsZrkixsAzHkAV4VFP9phxEs///LKaiEZiSen29S5fzo5vsXdJ3dvN
tYR/qifhAnABG/z97i0qcC2TSTOL8Cg/FTApJLgIZRsRvKLvJf+aVP5KHEMU2Nfb
VSS8vcH/hExRfwgU3aaMiKqWhZod8Gbi2n4nUHj/Vg/P/lonSlb6llv9GRjOLt+P
Qbprl6x1/ujqFjxxuUQ1pwQuCJpR3/Ck1C5oatJwL9ad9TaynOb09ie8LHop2mB5
mCWU7HzKoO6Nm8Jn6o9Q0KK4gMBMozSEu23qGyZoknVsjjxa5gBDt/6W2Pouk42h
RHkDH5e/wP0M2poI/EKH25KAb0l5I66fJsUNJXtn1rWkI8HkVWT/Yb0uP0XiKAlj
Qi4AcO/VAqO6rAuCiN10cwWvgN+9VKbN/HM2p3I7ftZ3+jVfa9BFbCC4Gq5YBnfL
G5AcbThnHtu8ijbkzIn06zTdn5YUTsXusSzHlSJCJ2ZkwkSPN8dPPmwOOTYbLm9U
bG5YWBlEVCOFy13hnqINjHQeY42CTMMZ/VCLOLYzPWQjU5gRqbwLfR4EaqfuY3Ut
5mFuTkadQBfyf83W5/LqcETUBpaX8KQhK+twh1Dcd8cbHUgA0nuyyZy2XkF6vxR3
ncwf6nDPrFLoJ7OQvpQsiRO3EHTuxmsCxrTJ42lE2FfXdcZQc3KTg08mAnsm3hXw
PaBFjm/KazPLE8zsjzaUf80wYe76D51Jb9jf93KwwP+axIa0yGHE3J+J8FlADwk3
Ri6ATbOd6Yohp1v0hGT71VX19p5V/WtwMJoAfVYikou5oHhKyQZ97AJRPWwZ6Mp4
ShdJZF6JI9C7fzHsJZs/A/UzVJSsj+ClqhPNhyUjKcmUK5mjQVgNKU1oBPzI+Fmt
nmz3iVZX3MIsKx7cbVITpBfUpTwS4yYodpP9jiM0qjGNs4TVdnk+UDcL8iKYMq2K
aLv3OrXrQEpiNkBiysVS5omu4Jdh9hUhvXF7hvhPPgtdpFQvEc5MH8byQkdZIzgR
x7z6nODGGKpKf872gySh+i4pwmbwI4QjH/fDn5TA1G/I2I9o9atSAQ4Myu2qIgF7
QLKGPTj7ybtJb2dBj8OwZxzKOIaxsB/epXJGN0/sx5okJ2cIoq/ZllEpQ0TNIfkU
9NYYReG3Jt8auFXKhm+7VyuecNG361cv7NrpvQYpLsb2Owmtp+Bu1taIFSFg0DIf
evTY4elC8ygERzMgCyTtZJ+dxqyLHJpcQfI8PzfN0MsW9lNc6ywxTE1iccVE/iUg
pkHxYsRJZHKu1iO3kewWDvc+VV3uS6yBIN8uQoEw+KvWJiJUQEKZQQJ/hmsHcCHV
oQNK8Tc3fJHmVk+qknD7wv3maFvVBftAqQdL5EpcE4t98sOG1+PbHcetVQbzeb7k
jBL72tz/1X5FN71KEjP/RSNZLAq5PE9cCCzA88Rv+nUqoExpsukeI5zX3ve3DgIN
fSv7EOcQ/ZAGNwgiyTM0jY2NAPcPZfrPMdpn1WIi31oCwk/FMJ0FxJHVZ1s/YcKp
gaxMmvyysa1Os+itWdwnOco+dWyheYZycglV4d5mU4BuIECJRQaE0zMGNp4kmeai
5hI1llJUXM3J3ZhiU4nUXsIyGRqhOKviRo7PbiEmufdR9xOrhb0bqSmEpOjDGKDp
Lo49rM0F7zdl/tQ/0IUXDuz91keBEqaQGeh77Gjv9CYQQtSucvtbYfHkZ1PYY26P
KGC5b30iHxi/nRsLWIqIa5lDKbqQGAdlCtvOPwv55fZk3cUAg4mJRRmdmuVa8OFf
0wmlDaWuYsoQU8n0/hzO/F21CVO3nZl0BUXQQiXJL6tCzMEVxbiezPJsjJAWlP7N
djVXWKC/zaqU0Rji7Z9yHUvPl7HSOhJElTwECI2t90PQF3SWvxX/QC8czu1brEwv
EBbImTAekYroSPhz4Mb16fOiCtINnQXoRukHzSEdAl8hm0WJ51Gkt8iIQkJ0ECAW
MRklopQ0P1Sfy/V4S4BQFLD4nGIWa/3URyD0vp98azslJz/3i+5Uki+FVerGK5GE
Nl1cmdkd4jiDe599tTpt8RLPZ319CA17jCmlGZRJyCQVAtWqNDhOiuChQtdQsx6n
juAAh5Pwup6W1RUg9QkH5Dx1XjENLddj/1e63BoG1DDrnFzmunBpf62kD6Y2KarU
yk76GtNoTD8+SWJLd7PZs9dDEbV0zjGFTKPm32tx1tEFBd0elqIOiiynDLWG1Cnq
mWub71QaaOu2Piy72Yzmm1bktME9v6vTvLtpZr5EHksMtHDtQ38Cg+pXTyBmWkMM
ynPrmO5RhSOXM9jgSvchxK6bvBa0eR/66LbAcl6aCgWomhA9HljN5QPqJxPYeHGL
wtsW9qY0nIn+TRf2TBw+rGmv0/djl+/21pcf8h0MFzeI6dT7IR8cZkK5LrPazDhq
7yYspaFBRr4CLKJndJZ2PnVxtt9wTH799/mX6qcb5Yq6VdVCeCos0rUKU17KTZuS
aTHxYvPYWLlgZtfOHgzewkJ7r8Zy+xnM7utBXA7ufF/PTMXgVPi5nbxPr6XyvtSd
VDM2oUA7iRzHAxhnaei0R5YFUYJWAbiJ5uO9vP4kiSS1r9CDtRtUKdCgXWU2YoT1
IT6005pr3rC86Lz3+DUTsSnPJlQmI8aZRJt3frdB05Df+HqBLFP1NM/UdOT+dmWl
IlCl06zPquHgNxj5tG65+YK9zm7Ix+DMUYiR6eKcECRYBUfX4oz8wEUPKHPm4wz9
f4hP5tPaiIgUkOOX0k3kHY+7z28LB8OLUN09SCq9R4mQD9KO8EkbMqoB3Ire1SyE
y1fx6b8ajKRRt16nLEYvjWYs5hKbfMbDXlmVkXCs3VqpBptADSmgpg/h6ckGv6XI
yXiehOT0IH+40LUqxsBXNlk5YPVpIA2tNNrE6CqmPpbXmhaZ+fCkfX2wF3g3n+mn
nPK0wRDu20ur4P39JvLnyBYMjZxNynkdusgnxJGX/2pfnw/dWChd1i9yk04bA0X+
9y13OHzwf8wRDNQae5WN+x6pOHimzZo+zWwveUK1AyZfJ9IFolumMkjof2tqo2I9
PieAVc0NN6WUvNAlvqz6aulWtLaXuCT3pigM0WNz6qfqGznzssr+uqVcBBI8xGhF
Y/whWHRsOV/3MvH+URQtWBllZ6JX7K1OBrYNwRjYp6jx6BH3t2e8SMD2oJlGuIUV
UAG+061XUBTEo2UY1CPBMsjk0IskiVBPgAKD4iSpE9bKryfrJdoUQ/xCw93CP2zt
yoLI1+/9wLVD6Wp/eFJAxFeUQqTaldhyUVYON9gWz96AZetAsLzsNAQz+bMfS0E7
4CSEjjOkjsYk9SSN7LEERcNzcl12+ltSn2WGVrROCdystSX3EesoXKs307Xc/xpp
g4fzyUsWwRSlW1NFAxGY9LRpP4O3vtAv1lWe0RmRJfc2fMS5kPK/K3d1AtTKFSs8
eSYt0H2CVfgywX8N/AO1U3oA0VPWolSFSMWS7cCcTHcLxiyb3hzJ2wma3B7jEBuf
emW4u/DpePlU9l9yIfAF75C1vIUEkeMQDK6XaM3ugPRABwhpcVbr7uUCNCJoVbQt
iaR8WR+IxaiqFBj4x8ZYML/H7CKfW2f9iWmPOWH1pRqAOvqvcXaOSzLJTM4OmaCH
WuqddU7ENzfoXa+zzgoTzk4fSEKUh9GrdZbE6DcC6AG9qWjeL7MiVUgYlqI73g9g
kxS1hMBDwkmWnDazcQ9z9sYjeaM96gVyp08IspDt95zZ4otKlAoxZL6Jps8J2nGf
HTsHBMNF1rHKJY642BBRf5JoUQWYLYvPYJwdISyEepH6dHKbh3ryX3PUbcl9F0RY
ZNImVO1dVqLJuUFAbWimfhdIk3qsWlfjYl3XZgK23/l1wRzVNPclKAiIRf250z9g
Ju1zXFe7zvX9R0APvqLNXucCwGUFEqLT7QVIIR6fjSD30Jykl7praOQy+NFM32tt
zRJpIjceURRXGAdpiubSMQCMPiRy6kMjosYeSq6onlUMmyh7sWA+pejuIHsVp9SL
XTi1rYlPdFksVA60fY30doEhqkkpVrlmNeOMnAFQI3ZDiNjZLeAy1ZVf8ZBlCyW1
48nfYlXErn+6rt5hVe/XEdvb3atSjOQnnjDmAQ96AFVZGe99ZEkaT/FocP8415UH
ftTB7CBiIhKTJG057UBL7BAPnrxexlUs/3oW7AWT8gIm0mnxjLFPMgprF8XQ18Dq
tLyE+EwoazQzqmqlVX0abUV+I2Pte+NYP8DIkwY/TdYG408pc+dxj2uCQ5iIXhwJ
plj0maiVewpoIU8B41UxZXPjyxCPj/YzPT6HhG2VODM=
`pragma protect end_protected

//pragma protect end
`timescale 1 ns / 1 ns
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
cLoqwoMSZxuORjhg+M3hOo5jC6pD/xqC0mEkHF2TTwc6YFSlhtOX6U0G/SHRqNvR
chWpHevIaEL2ql6PAprrgWTYyMONUlpSqAOApCIgFu4SRq0YnMySHbcvEX4nn58H
2sHD7n/k/a8Sms7w5KmQcxKSAb+xhJF7t/IuRSCumn9OJKYwJmraYibUDLznocUe
Lsp/n1B8WdzF+tXx58S9QyU+F68gMIXmbQm6TLWKcjImr4xzMhh1tw9lk+jee2KC
TSelGovFkzrAYjErCtJF49hvMdcT2eU+hDSEKQr+iPdJH5tvt9YepLpYNzLZ7z7j
N7vg7TWRtS80I7xeY0viZQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 27056 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`resetall
`timescale 1ns/1ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
WM65bOXJ597jxLPazfYOt5IZDP3pI+ETCWj0U8wfWRfKtJhqULAlbiU0ps0KJJjR
Xy8cjWF6qwOlxCySN/mN2f7qv/+BbhKIaaMwvrFoKPjbek6Ao0Ju6lD+3Ljj3raN
VVf4EZCKxXfoVgCW5t7rx9NZjES1Dd+wZHRgi47H/zduxqzsmJccAmUTcWQkas9N
ekc1NbkDx8dmI68+tHNtSLCl1wfUQFrCGDWyKzrS/L0ajpFDB/XWt1aVSAkf01yM
ze5n34wlUH8nKA5tXWyXrENyFlzSgACIfHD4YLEW9xZ/cAwQTiexYSW1B0XTQF4x
/XJ+nHLPeptrQgAY5THX5A==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 656 )
`pragma protect data_block
KGvaQ8LbXz1KmXU+WP2YBloPcp+CqfOQ0I6pbtErXxZ4dqyNwVPrsStcgbfbrfxM
oyQjWUVwMyc8fBWhNEYK3Js0YEZFGaf/axgBekS069BgNJ5yUcJ52n7anFdRTdzk
+jXqnX/6SWrlt4z/PCCMI6relTnZo64XZ7DMz+tvSixYImXtGeQLTouzSHE7w7K9
EVbiho/O0pc33evYBe9IVwaNaMxMcG1OwgT8RFseK2X2LM0TBt6bcpxh+9LI6V01
BD+EEDxmCVheB8Ew0cAmdZvJdC/Xu88aMWOe+jf89+z9pcj7G3wuL6UZuaRcPMQO
OCxVoikAt6IJePSdFFxosTsDEGpbcO8BAb0i3lJnY0F1vBedM8apG8eYJ4AEm93r
arnRNzqtO6owdO9s/1la1HoeAt/emKv6aMcNgdpkZMnrV1DNY5O1ZHavTpW6Ne76
ZItPHOS+3T7GjW5ptpnS0atEoj+50edpadPjA0dzch1F65E3yjZGKuSNIxnLtU+J
F6PHbbfo6o0uWMbH8UIEHdwY5Hw6FrZ65aaLLvddswpJHR81yJ16RE+9HqpBy0PW
R046c1dRHkVp03/0t045ZyWx1UI4b6tcSzeV7pyFrzj7blM1QAPuAIyAwNmLu81I
i0+6NOXdu7Ilw51eUshlEYTMe7NJ8jZ/TJ9FEy0eN6K/2Fm4b6aClI8cy/USx8XM
4vHXWpjtmKCeUXJo/9PCIZvmzapVVb/163DxiTDOnEd0jWBYIGFJIe2m2rg7XEg1
xF7czEhsdERQC/x62id263bpjek2jEpYFFlSqDgCPCnf2IAmUN9dfGzThI/saqkM
O/6ZzDEaUEPY2aoazZjLRlrf5ZHr+HK7kiU0D939xnA=
`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
Qr0TSBqLHHQs0b8ViNnnOVy71ESFc4d08P15XOcgKano8I/Xn9gZSQUPd0bCWy2e
/7IHJpSClWM/6crBU7pExHL7S9kpPPPGArUxKr3d2n1rvtNfV3GoArM22oT7gu27
pOASQm/zzpp8xkAcPpcHOC3FMJFH55e65Ba4br6eyaEpA8FcGnueWV4eoKpGocpz
izKGSzfM/Uaxhe1BXpWtOfF34OlPbHp7Bjoh9PtXja96YfnNVZqaX+Aj6qeg1Pw0
4KEIjv8JCYlhPklJMvdnDcjGzjt2xMXcGt8GqLlUNa2LamIvoK9cWEd9YRfvv6k2
83v2Y4QH3r/Gih7V19K4mg==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 13024 )
`pragma protect data_block
m5JeOp5y98kKs+7gLWA444b76FCVZb0VLRkh74knwvnimvdmihpQ0sONQzXEnHwW
Gz6xhS6IdXVGe2J8VmkBqVuzYHTyzWTaJqrpBxPpIm6eC2F1qLracfpiXnhSSnwU
09NZfN43SlFgV4v3p/DqwBHd5nIYJRSjRQNNiz7TrI+I10WWw/G7RasT82WbGLb3
cOQlmeWG+U6qqZt4YNbeB+EG40fx8lZQJ/M2dTSbpsbztxwf5HvN064v6iTw1Hyk
HmHq2yVKEKUPSphChnuNLn93lfGxHP8WRYQs40iuY0oEwTFWXnoNSnzprY8KQVyL
YYonCxZs3QS6orpIbhZwXwUzWwphYEQOQ6rKqGEvI/fm4s1UA1LlikWfKOzrrgge
G/Zsa2Q9QSiy4mwNs5hjl/R6jvj4BBMmSrKgQdLAr/w5rmp1vD7aErkNkbq+mNhE
47rkMUYae86Fd3028+wMiJXqQqlRcQfBJ4HAPNDiOt8NS06Tup49KtJxoq61ROGJ
rqVVOGTv6XT9/UGYN2DfYlR2ZXRGC2XZatW8TBxnFXg5rxlUfB+CK+JSg6zXFtcx
Re+SELrHwZZL9I+/WYIaK/O5FJPYqSp7psG+WvzwPzXnxAtGcaU8JvPB2lns5+fS
sIqJDYt5nTeLGZirs+R6mwcEF2Hcqq+d7vCzxEMDn8qzc6NqfzqrIHrlMbH6LioV
racoBEJCivaRtVFUS+yTbj/Xm8wnLsywy/0QRzOHWKhPjOo2lrQjVY8jB+c9BT3S
0Kk1hukC8OptklqOcP75Hu8ZfC4dcHo0HciLrxDT/iCUrXHEZU9HwJxoOOUcemHH
7pztB1LR47hl6bC6vvUvX73McLKoKbdNcEdZoTO5Tm2LecsRjH+iiBQ7tF4H78q6
w+TfqM0e9IloY2r8rv0TdgYFlGr/bGFv03PLw7FG4de1YSQIyqO6ugtOBt/FjX6f
C/eBOg0yqHVszQYtgNdvePmnAqrpyO5byzRqM6YuomMPqsJscftkqzOVFZTZhTmA
/6xww/KKGg7iHMVHUo40b9ughoLJlJCaQeDQbYlsBhS3elte6cp6TIV59xPWUuty
2SfYd20hbXL7dMHIxjWwb3eDuuw+J6JfOrwZXzGmBfCTcUcAm4wlcjGN95grB/mX
GWCuj/sBnwYc0z5Q3xROjT1eLROrdAyLzeyNNL3DlFKs+XVbjuU0smD0SQnCvRtd
pU9Eroe4reGtgdUMyKX8TsFe1cxZ5MWKj5DdGQDErj6mpEWcov4ATYCEEE2ZGgQB
72iwrUwxQvdF/RHofW29EVZyQ/K0zNt3k97WlYeb/3nFp8PBnSe+nRLwQ/zVwJTS
88hD51ayy6jTHzWtWRJmh2FzdQpbAPWP05EutPFDchf+fQAnyhQ6EAQhCIhGT3Tm
C3BWfJ5BkrpLMPsycfLmvAS74aYtS4VCEIurC5K7l8KrF6u6nS54G5rjKM/ugKLy
IDiBPvOJ30v3aMjiBVxy0C+5Mtkwbo+STcS/A9mzdE1ZdXK2rqSGugpeD8AvEGh7
fEeDk7avROa5AkQhlynH8d6J5WVXvGMUwc5WNqJU7eke034WOQNG9LMMyyWUmsnL
cJLHL7pLjxen23Esdq3RGN8oyqOpBDZ+tfoDqRKlEF+OtkS4Gp8UBPybcfk1keAw
kQT8NxhwQTjVF7vkGpQ53+cm2kJp7ldM8Ua11rjKBCwwUp2H0X9WGuOdIBgqmqFG
LeHzTDBwX3PzaJ9zoNY1L6glUdZYburEcoalOTqiU7Q2/jFOgMMQAxmtfHldPuoM
jL4LKtpMtzquAl6cQmDp6Dj+FNTujgfcbrCSx/8LPXjYXCmsb4Y3TrSs6TLE6pbE
VHkw/3Fd9F/HF1rsQZcMv1YmNDmZiDo9UqOoyOeyGF64MLIq166Fo+dmdNNrWkgv
8qrfXEJwQSEAC1vUGeKp95T3PoBSnQg5ITlE4wLLGuejby60dIxkBsK2ahwmRezx
U7hY7oJNcrIWWM2Y103meReTvHStKA2EpP9XOV8DU3m+Yp9Ppe74mzc6DKA+w8Fg
TgthfJP13rub3t/Q8oyfOHps7rHfEtiI3+iE14Lp84qkq09+aI1FgRJ+3YB7bh67
4UgCKK1ifOe8ovr4mRWWSV/LDmwYdUGDL27Vlp9WcHUKTTpOYqDybhx/ijkmrLav
SQ5wDUSzbMxC1ffP3BdoDaWcY9/0rY1oTFgnVrh0mwPK7XeIFCfjM/6xtBrMw84e
ALwCYkU6HIJypSpq04+MKE5MH1PicUfEipzhl8OxuejitAD+ZPpOh9S1iLRSvYwI
toCUR6afa4n3rpQwUizFKI4zXuz7P+q4BxeXYBxH8R6v3HOHQTcQqw4pmAB91nPU
gtNtozM2FQytapZ+HnBYwOUFUWlUvUXGeX07jOL1+qonoj6/JKMUiY+l1OOXuCAp
DLGlDmhBVwAMSGdNqdWxZhlDIFHDD/lCCpXBZqrQ6Mr0RhumiRh6H+0pAhRwD+ZW
kXreBUHG3TSw/JG89fwTZVYmXzfLvfucgU2+9ArtTDyGPjM82TzwuUeM/vtt8ogn
ottQ8LKSkUpNadZlOLY6PtoPf4gfqxKxlKBQLv98QN7B60byxVWfN4m36CiVIygq
vtZn9BxEugec4WSIbZJEO3NO2DtYqtWIWdLDTDzNElo1jzS7ePrzb5G5sabwNHZb
GvUqos+x+oJUEgcZ2yFXKNXKuQM+6jCzPv1MnZMik7tHKdgSx6rGInQGR4FLV0na
TT79hR9p6a2R5ryCBkxNCDcYQ7/9atcEi+s+r+LIpKhUvvFM+dF6/RrNrt85kJ4w
7cA7jJ1WUbCRLB7DInC0AiwW+YUVgnZz37idtTexmmrkdW0ZweXt13EoJRYz1DmV
BMPNd+CRvyiIv2A1g5xfDoX51iOugiQRmbkxxo0ebbc9yh8xi4N5dwrdi6FoYKu7
Ck6LhQnKHUlRIrhy3aoF/Y5um12jeJhK6gvztRLUrW8J9b8NgjoXBrjrR/lc67yC
Zxkp55OBo9ck2fdykSIBaL7HGAy0FDCyp8Gd6fkZvPooIMGU6tMLNr9Oe/K5bL0Y
gfKOejVkMAtbZOMkOZyU1kJyf0zi1HCPsN1W3ECileK3EFWyyDU6ZMHw+xoeNpof
KY80dcJ5ZJM44oZeqWIAi2ifFAvzZACIEvx/Mbtqx7RMfx6IIwpdHav1oHPHNmXE
QH1hv81ZwbOeFRozm3uM4igpinPqB/etVUiY3ZUav4WrHlioFBiaBsE4v/Q93jIL
2+nVsEClev3evxh4j1qTpFy4nDnT7fQBSLmWBWGXUhTRQqmZPrEJ1teE13JuQ41t
N/5OnAQnralz7HARLaTnMQr+4zX6yFaBagiaUhXOKOZdB55+kmst6s8n/xcokU8Q
Wc0/zajEg0TOzC/Pk6ZiZ/7+wv+XbUFsLS5+C9fTYkiDtAuz2AMOU7yK3/trvw1H
ct40kDyb8qyxS1hc4NZPi6AABZWi7O2nbEXLbhBZfP6ytJEr60DIYFRr27HoO9h7
wyxRca2+/ypnCxqWB7XdwKp3A90TyW8QWcjmNHqWkJT3swpYlyWzoXHqflzjYDio
LACKpzlmU9pMtgXD+5mLoj6amY8ImjVEWGFfzhfjpdFLWsiirBW0iui14kFJwrt6
keXfIw7MXtTVGt0NF6kPpRZSA5bBBTTVfR9aDdRAt5Q+LgmzKf8ZGgag3psC7W3K
CupAM9bAQl/9nAp8dU6sDWbs9DO7QwLIwn1tuMf+cY071SySO1eyzEGlw2N4EeIf
W1GSQ1q0ypBmYOttcFhtWsu3kSlyvtHSPkzpptizXnk/ZMffKFnDmqIzbe4Lj6VO
QodMeF4VGaWwCZP7qVnqSAwDJOsBP/YASGQEXQnUBOl4ol/8OCUDRjMgpo00ESe+
RFbCbxtBf3Zrr3od5Ju4BpcMZwVbQYGwXWFcO9GZqDJFATGES0FjKDTt8XhFx6OS
1QYl2ph5dZko++9vXQH//Ot3YbXd3RN00TzSbRSiX58f5JqQisQSdkA8FsFozL5O
WSostWP/p487qObV6ceL5/9xfyi8I1uZnAihU8AGH0Ozy7KXEBfL0PA13VkqQ9aW
uekYUC/0aRtgASTE/SxYjh8Bt9CIKrDqhvH7ZyYfwpmiwXuwb0LPXrDwN68GaQUJ
Ojz4vBt6rTzmCrgUa26VYYTB9LJYWJPxS8eOuLK6ZUNSC2bqTHzDnItTI0quRVCN
z3r2Pe77O6EKgF2Bbs4ACHwjvEzvJqO9/+smgPKJkyzZvQv4HNVVGo6+OCmN+mxO
i7jsEu1nLy6SLvAZvCg5XXfYNgMn2dDDNxMrSJZWbIjowfl8V7Tiy/OpV29BMAb/
TjKp0EHRHwIJXB7+A14UJAbt+VNy91wk++CDxd+SGHhIFFkzCfwbZV/aeej5taYo
Xm9Hmh0UJQzk9rJ94yAwKLbhht+GOlFl3jRw1k/PcIgO3mIALqTiZD0dZOeVphDO
RXJ+I6cKmuuHB8hwxtb7mpR8B/Dqu4M41DRyiN3CWskTzIu9ZOvm4OSLzClv8j2J
MnF6F/tvD0jQVj17Vg6wHmkwOZ5YLZwU8gfh7H2ejOJEa3XZwwUbhHBmtYrkzmgl
fD43VtpYMD5CHmTfobNZRr0uHiYiEggxut/gKllE/tCenPHq0OKfp1PYXOxsfyom
cqrULuqMR7zP7BVLzljNUTU0pa5XXG8u2AGEjfCHhVfAMriwqL+M4nGH8rUasZuX
fIu+AYQJTYukbWunZ6Tq30nkLsvYmk0/x8UT2GXht69ygyjW39XmkO0wSsJiUPJU
FU9v7LGLI3gBT7fiP1SpY2Z/u8XQPq5oRL/I5pb/KeYrEtjcXLRS5xDWol/FYxQ5
DSBql3ODelD+ZPIUCCLqmubAxrB5qfVbm+ubOJHcWlx10hhq/l/d+rZpJ95NCkxA
7n9ntmYdV7iVsEoJ/1qNYUd9VsRiqLgmWyFZtZvcmC6/1S4/Fr4GriL8vn1vLYUs
olonqLiwroIZZyXLNZOS7uqVXkfhpG+JaZU9bvnNlk2vwvHWO7Jo8qJYEaLtWHwf
4duBXIFe0BSGVmdZMMTSAGeRab/5QofzuBpx+/9fVqFph6bWmCF+Z9lhgxsQgQMQ
w/S8uLX0H5Ti+Jt6tDMTnbh2Q+r7laUiGqSpsDOlPlTME7eFwYGezpyvZRrwsCzl
0fZDKNdWetMHuLhohrNDtsLz7UlP7nGT+UUnRhOZgcKhUISe2LehPlEx5eTv124i
S31XTTGbLk/QxW/X3bUlUuAIVh3VQ7WJuP0AJFsbanUVa1666JTY+GuyFIG/rssi
nhQRVpXXGI7fdWTTscukYK7zkiqDAr6quyaS6eoS4IYZX/kI4hqrWKEvgBSXwU9f
yRXf8b91kcrlK/GFJw4fUnZ1tyDi3g1lwXXK52iubw77VPgAoaELN23hR4FNDpIZ
X888TwCPyHPc4KUrYP/cnz7ou5VIg1Ncm/jQAkOqmMxHcvxaVaur0X0hyzOuORNy
Tzty9xKOj2ZIiYTbAKUQDmVOQKNHtwP+Td649gj0ZmxjiI/8wjPhYaAlbQelsLZd
3X+Y/oA5RqMYFuKRMaJPhZC86sL37wkStsWnZsun8y2MjdO2CmK0cQcpOf0DZpOE
gfhlMwxNZNWi/Dee/jOB8QFpr61JItPPMsfwnibPCquFOgozmJ85bPODvuKwnPc2
pKBzMM2fJ88J2+/8xi2S/5quDB+lHFBLeK8vBVUemziBBniAALfJdxtq6Q3P4ORl
wywJh3w4nMCPCQwkklTsnPBhC7T36vKWEOuac5V5uDr9YhKmYV48s9Rn9TaEhUJa
IA0T76QsbnN6n0rDwgzR4XteUBmkgKt7F6XLdwqI5IT7XBoM+jIZ5j1hbA3sxHsJ
15GIKg9MvSgaYyZJ+6Ja1iW0gBMjfXEBUcCcV8MFH3YYtxi7WypN1lsFgisDDnlA
UFiE6RWr7lkdEDO2cM/GRCMeheOQjO4Vup93WeZxa4VRDN2cYzGrrTTCJiTlY8QC
JwYtJlGz8fsopVKXB9LOP7DJqUOOo0pApLnHI7fXQsWp+piZCCJvapWj3wANB5re
pV0YrFKlel9cIMKzgvw9WUbaxDS4IdlNKNyIXYaNMGmhtdEWJRBY0LTqWkoJY3Dp
+2pgohuAviwIV8B2u2dVqpwJT6c6HJvTbIjB3dUjhcVbvzGaxYJsarwlhwdVHIZv
lIou+jluX0jhyPcjdTcdxHvMfSHvK1PoW/vRyEJEmcI0f/M9pRsYjGaxs3Tgyjbp
FEI5YIidVu+zQQf0GYlapdqXzBD16jZ5V6PBbCXl45HdSOFYgWKG4uMnWenKlXlP
jYUYju2jj8jTxM52DC4UGZnLJxxwgDnzME6FnUSPe6Q2vYmkYIS+3fItSz3CmXNF
E1+qoyLu+Y6qw4tEj34TjR0/3m/uAkUaJPqWEWAnxVizX+tjiIBsm3nQmYmNAoQE
5msFSx97Z1uw4HNwwEmI0Du8a8H13t0mZ8QZkBlTokxM2G5dpKjYp6sTSGB+fbG8
C9wx2F0AO7xRqosNxsDEtjgyFM7zjhSLBBGmhwoC8EFfhN7qYbFhL9CY3i/+x01r
1FtpmfI+oToxQTxDxyET6MAvq+QYZwMG7acFVejkUf6oKBD10eIRIy2oIgx679sT
SG7R3rTpV5sVdAzHOchZ0hEsyjolx9HBVLZDD8y0t0tcqv/y8kXNKPN+f3lE0FSQ
9SSdEh4+qsdVdbhfOQS6f2YETZaHlJXltPpN+qOn8bCKPbEwkXM0JNQcdX/mhtKm
S9P1uj6INb8+tXJABQU/OwH1nWpIlkJzJ+h0DhTvxk3yISu3FQnLchGcQNbnK0uo
qC0EP9PFOqWvWkN293tvGXdX21WM+bNPjDqWypkXvHLHeoYSXm2DKT3HShLQZ+zI
aGq1uf7d0zkw8+HEXkJ0YxoA0u2LcZPq03PeTbHLZG+Ykk49W/Z7+bZ3gO6uJ8Z8
2QrFfdgEbknx/i4iFR4JJkqQkLAlI23B2KYc6TirNzONTuztqbvjkb6SMMY+QC56
RjT0UxfaLxNf2qcT/eiOBqsVea/FLKMVV7JpBhM5rZ95+oTlwtMjgeX69coC37Lk
cjdqStOEwKJNjUAarKIi5OzlxSEkwL/Sz4fOGEyjJYZz1AUqVI8uzBxgVp40AtlB
+rEhcXr7wad5+t+31udhDIo5euwkhtUrEdnRsrLpw86x7mRzfSgthWl/8neus+vd
wpvG+fq3/Y00cr5MczK0obUjBJnj5qE7EsUoZEPkqopvFvTrASgMGdtJ4a1vluI/
w6jzBEayTiYH/zILxhYee3zuQ5wmK7vOklCJsbUh9ekFVbwHLUgRLIWI6VTldsPz
NHeXSTZmiH7gHWyVR05Ot7M5kE0xgOxNI0anzBRLx/NnzboxYi1HDOsW4B8ySdXa
A+TgNLhRRcyuDBHzClj1/bGtyswxb0a4hdCn59OIRe2onh8417HRpU65QGXLY2sQ
qisAyf7FRfUsEdOwdZWMPI9B1jtFKOL/zo52xe2E5weUpBt9WarH8+aU7pi9O7JR
Xfd7r5LzYC1gHSWjpKeYWunFYL0aiXcJY8PGWx3go2F24ZhMkovm2Syf90BfN2YC
r+0praLAxz40xRPJT4cacgKE0Ht94et41x1Tnqt2Co/3m0hrilhni1mxmp4JA1Bd
XS2Gh/HDfNEnwL1Mqif/Z5tbaz5I2/bwKmDPsi+IMpBcnDWaO9H3p0sKC2TfkiSQ
cvurPM+9UDwafFCM3bTCiQ4DB3oHpuUvC+uQiuDcXoluMj2f2g9RDOCVudBvRsF4
W0F1kwbvKXeA8zOH4wWrrL5jXFyK2Ht602U5nHSStgvEbO6PD3D14k0zKbFRhcn2
x+/agdJzLpqLIP8k3MJyJ8AY5HiV+iv/RpgrLzc0gOHyTRduyUEJplF2lhMGkHgY
v5ZDNEHfptIqv6HapUBYmWlOJVBUQQanE5iiMf0Ks9S1zoqwacvWisUgdMbokxw9
pRprrmNEdVff7cqyYxzgnTFjbiN1jg/tIpdsttXsK+2/J2W0WQJ6Cl+Yp+kX0L5S
9/h0sIawQ7XhQu8gxbAOCR41Ny7oSjQjP5ihIMGn/zze8SsZXjnhfqIqcCRb8phs
HizIINqGSZ7yX8ma9P2u9qjoS0Z9L7keuaWsd5sj5BNzzXAXU0meNwWg+7oAvbkl
WOIwJR7xHHAMfG1+A9CtNuY4ULrR82lGo20mPvVebbpqlb62WVzGb+QK3WbLqAex
QLskZLxBab8Ner8gwIgkSjRACTO1nQywU68mRPWB3JDX1LAPG5VqRvJJ7EUoi35e
HSG0mpUKwPhbTMwaFguH1tcaJEHDs+mmvSXUh4Ba8LaIqa8iOb49ozwPTqSLTNlr
yk6eChmjMjlpytSVqbYVGlu+r6sEz0gOlKMml2co5YA+Qog2sgKTPpMXgXjo/Xhg
f0MO8aHMZxw18q8KytiwoEx4AsaIJ6AB2wwqbpRLgf+jGnYjyTDL9GSZA2OqhsP8
8431d6P/0bDhraozmkiTdnn8SovkVwLCZC2Wq7VapEJxFse7SJOA+ZKbylnNM5dr
U+TLgWvpH83mo1tqOmqPzjl3lvW0z69FWMNvvGR/mxL12miZcX/wnOCYAWq71V/H
RJzYSsIdWlpMIGwlSH+UKJjOQEKMjbN2Z0MBfZg16wF0PMHMGLMPBIY/GlRjqfLM
3dpQPvkoRhwsBUIYxCezE2sJghGB4uJv/wbuQesmvrqzEJswEWBwZKBpQeBRdSbC
cWcO/zbs2jw7uYTmwqQ0jCeFu/pLtu3DXbZQSv3aevUbgXwlMxCH3W7NXaqKVan9
8/jnLAjpWzYYVUerVmC37DUAiOHSf0c7EN4GMPfBV0HzDIkkPjWardIF3Q6oTUF3
vbvgzSN3SWylfnMMuplTvAyz/RdvJAkVtppv/ADZ9hh6nn2ELnS+wrgMqAJaVMTF
BhC842ES5kRf0rI85wGfjG0dFcVk9ZBAvlY0/ea5Ws9JpMguD2QX297dT2mnu9Z4
wPW4shr9OxptLu1ZeBT0Fwwqy/Nqvb+UUzFVw2Rt80DUxqKQYXyE6DIfK6LSNT2o
A6UpoNyFEjt5x9xmk1/cFlkmCl9e0lkd+xwWX99xYCWyTObrTmKqXoykjmgQqwRj
0+Z4U+RTu80MnJpo1IEz154ALXexbKiCE5d1ZbDqovV/zZe5MbWZ58QoE3IfhJ+o
k9+ULnnCLlQeMrFPPDwsbrY1pQ1p8h0vwKtU5V9m5g21nozwFD8g/DImJjzyRGpe
LW9pPHtQ44wBOTO8Srw2J22qKp6TvKWRRYpEXZZNAi6CrjIy00emssGUJtJpZt+H
5FuONduBqlg8b3snNyCW8v7wbVIFWTcxPNPuTpTZmLpPLYKgw82pFMFCaDDqXn/Q
OgCuk67Jqbwkaprzt/gZUdBnb8KPtBboDs4Um059DDfqsqvXTXU1A/I7Mapzo0UW
g1WsfsFrBc26KEgJI7bcJy1O916nDatTRh/y2TS6oxwGO6D/tEb/xTw5k9S1O5W1
fndslhCH6kIsEomzzQ69BtHV3nSleks7K8iqE+pJCSC2XVii8FwzhMm+RG3pqW5Y
ph7HSP1TEoI3gMLmBoXBZUmSC48DTdXT4AQwQocNCHnpd4E9/n25CjcC6wE+JLkg
enJr4dpmURJjHOO/OsMcwhlefcynUKSZetDh+9bOXqKGLr0dY0/f39wxeAMxcQbn
OhtbBxwsZAtpGLz34sKgzupYs7Wg/E46QmczllpDOXLy4lmdiKtVtVPNpEl9V8c+
qfGzlnqfa9Lha8nA1N/fHykgImifQPwq/jFf1zRD+GU1jzF2ig3CcPczHoH1aQuZ
rwKQ47QES2McM+V1mew2NkZCRMwF78uA5cj+SbsmjDXaO1uWSmf5u7XQnwMr38ax
kxXJsUvLskVnrYSuIcmi65ue0XZO6CzPSTX6oL4E1Slss0e9OQi16fcSW/5jWCEx
UlDDCgfO65aCKm3DJSmE7sQJQwIkP7w7PYw9MD3sGHFrPU27zBYIMDjhLR0bTy3c
vK8mOJaLYEELu++/j4/Eo9qNRPpllkdYUlfx/yVLTLdQlfKKFHjjJjjUqJhs2zg2
SjMD+AYFeWG26KrvRWwvKqAwJDKZCvgQbhOkr80q6KLlVci68ZQ8SV64TES/atJX
QddT4ZK4T9nJcXuiFnDCTTQhNC0EfLCNMfGSdJGabBVTTx8/I0azRWwC7dmWHwCa
3wWHSMV98eq1oDdbI2IYV+RECMnqTw3woTBjvK1CQ7wKs56eWQGd3cSrKwx4TLzM
dMzkNGSRA5jcub7AXeBqiha5Ij5aFEJ3ITe8+3uQjY/1SdvnFQdeBuHjmbCX6fs5
QUyW60+8XHjAybNd8KbWt+WLudP6LSt0NW8+pOMcz56Z5MUgUTMyx1bqdAMrEBAh
GuGCO3OYGd9Dr/x2dzQgs95eKvDwIjCUeJfPmXUVyi1PU5N3PZ2ILzrEAFxIVjr9
lKphCtoAz3JnI4LEfx6rXqfrKS1S5JULgPAsCvQRsx0kL0P6+Z9nsjBP6w5TF9xX
n8GJ7gRKM9NlqseSRAankZ6Pje0ErodTaa0RdQrofc5LEwVNjhZKd1noBoF2DPlw
iVDPX71RbpgkmNNyHKqfedJntdPDsVmJo4FnwdpBNW3SfyFEbu3nMjCu4SkGNJkD
Q5B3MkJHzotJXZ/jmCBSCsmHfEeAd7b6QWrBRmsjt38YJLTFVNk54SaxmUPkixbN
4SplYGUcgBuF2U8UD7gzn50oH3Rq1M6B0uBMU4CopDbK36oXsZVI0C5eE852hBKL
pewc9jkx9p7peKr9f+4ZBvEHBedK1z5ppanP5HTOibsmJhucoD7TVSFA+iqQDL4C
T/PDnJweZ33xmOcNbv9hSnx7AGePnd77o/++DYM4qwpsVha4Mid/h0R+c9Lw0UWx
s32TU5Ui+w12KM4i7Vxrf6a2ArnmqrAfoL7PbkevjF9Zl6VF8l05VAzitfmpfeu4
aXN7qAeNaZF9wuT4+PKyXvORul3qGl+Gc6Zc4+V1GZqj+yCDXqDKhDJp/IJXOwQm
nCXVotegJjqvv/TTimguGa9TTvNmBTLboccPtRK62pghn9L2naEmH/tVSLls+2tV
OQ+ic1sch0Ya1H7niqgSqgcNDPbTz2VCLL84BMdYvektYHq0XXTKpI5Ftx0ljlzq
fCmzDSr1d8R1jctojHguz0sfEDEKKA/XctD8rzFAn1xNmeUP7aRW94Vb1uPYMoYy
NF5x47FiSSeRt8w/hP4oDxgNy9xJ5kLMH8fnLcDYaGNx1cBSODgPaWyy5pw08vn2
utm3l9jH7UNhW4DqnSty94myiG7oGZKyiTlU90AlgTlmXyypbOYn2Ev/bs7/d3Sr
oWy+tYfkbZ+ZEQS88N2bsF2OG7ikww306upS5rUhEt78GzBUiwzqo7MTGTb5EFAO
0P3tG648SAjUhJUfGnF+9HRWMxmu/Bjt2IIsqtqwbgChcAZAf07/o2aazK8eY3iE
cNxcTrpHCdvWRu2hJ2/KpHe3z2pRhJrH587RPrNRorTY9oPBXoai9pT2PAs6cMcM
O4fegpth89XpqQ6xkd+QtqLrbpFcHNDSb0K177CuWpcUmCaVXgv3OyKyjEy3RLJK
ZYWM/WQN4xRs13tQSgiiTFdkETBYxBaFGqmgm9zTRBSEzLlH61QmetTF0Pr+uTWS
z5t7SNMgoLbEc2DSZr2skBsn+ptjKtnyqVrKS7v6JISWP6+CppZhU3P6Ofg0d+HA
P7rT73k5kICaHFByQ6qlxBtd4VQQzR9GA7xm+gvDx9MOoaZnLT352tyPsKSRC8uJ
aucwUoJDZO46TUZFdnOWAC7EcTgs3b/TYHSZWiVtkwxqDHgATsWARytskKlWtdJS
XzxAVAV0WBhaGoskTi9pvmwBtaHBUv+mU+2YSrEtGwMpGmDdwIGL2+zlHyutnq1u
4hMf6G9in+dx5eNA+q1H7mmISZuQTMEUDV0mvCo4z1cSWFlCkaUIZ/m8xQAMbuuL
7Zk/ZjXOfm08JVaOplafUquZ9xc1Br9mt+/gJFPNlkrI0YAMGEp3xFtWtc0N6SEo
qQLDSSfQ+I08aHecz+VQT6wMnQ/OcL4Y5js1TowBxTfZd76fzxw5IbnP+U5qmUE4
utEeMFMkzWKyqq3myqohGUO4w9Tl3tgRRJKxoHrnv/D6XjMh3S6qPEUpXDol2lwf
sHDoU+bUBREGqc1CfmT0C7Ul5c2qxoJleJvWBvaaRnMoKgRrCrSbUqwcmz5UsVAE
L8AJRQf1HvgusWBNyLlmEbv3BuSX26nPI43ybPL/7lAaqLLGGDtaE/Ma7b7X1RLN
smofKia6ehfKUR+bwTpiC/VpLWf2Wg4ph7uUb9opmw4nn1joOGGtHPSxqKEcLVC4
jJ1q3SZGP0IzdUKUN/re7JWGqeYXK1mjf/qvoOs20qRPwCyaB6+k9Xi20DIWJCu3
+qq/f42P0JQdMxRb+wl1FnI25U8F//TRtXWoGlggcmKR3lKOqeDFaJ6P7PnhF0fL
7joMUROo7DOoY4E7LFbtnZ16w23xTOtxbEr3U+GzKvi9aLxr2wukwmQW0iLGLO/3
dSCAawEqPWXig33rCaN53r2aT4Gk4XZ0ZsESo3HaBm8JCaLTm8y1GoUldWjeT3Za
ycqVh1MKyNOovrgX5RYDwxHrmzJvlUav+izNBLnpd89kW1gZG41xj/RC4c8IelrP
YKMwzPOZYzbFkZjwK5d3ofbUZX8CIE0sT5C/TJ50JHaubMRQtvRUIEbbirfyP2+A
6N3zyKKU0Y9XvEpNCoG93y9LikUSuI8FLwcGzyDZghcdr2B2yDLO76sOqo7fsF+G
mvV+W2/NWavOzLgjjBceM39uf48uCrIdCc4wBqCkoEzD6nWGlqBqn9uzenqm5aQS
tkiblWm//zYl2ANO2vU3g8Er3upFiB7QLG1swJp2noaXxIRn191wLE0CTJZVgjJs
DuG4lswNTDCt1a5BjJ6ln/yW0eBIxS9iB4/LlKvXXRZZYH5n7F65bXTCc8qG7eoB
l6aXLQtL733cPRkKf+aXSb5mDyJwtKTE50Gn6fko7QOxi//hwANQH7Sz72EPQboM
pVXrqL3mckMvM8tIdsIvgHzrv9ERih3o5LGCiyZIJjhC4EUcqHWVasVmfz6v8YKH
rEL5yPmeDMOIrNilWH5CJeYRXCXTZvtfbHx1xq2I4KoDrmetUd78CJDsPpnBGWXE
oL9Xjul0VsIEKFOBlXVWPUKpRXYiBr5QBRyq6ubnkQ/LOPhzRcnNSnKwZucXoStn
dHBctHG7BGFPh0FJdmtNkGF70hRkkKrTC8ZK/xUHOVhUM+ebfMe5wAgAU8BVCPLV
IRKDGgkfDHChpgtXcUznOiM4TDj8QiRMNNZR7yYElkCjPB+h1wLbD6i9SvgL9MRE
OfKE0p1BPWOgS+/IO2Djy1R3RP4u0cZn3TVRWz2gotRX/gS41UFm2o48Joy/2wwo
i0Io8Z/5KJiihrRT9OeMewPCVrwsdTV5Tf2EinyPKIp/PdGUS5c1GqZU64/NONn7
QlVslmU0uc3tRnvHLq/h5Q8hkxGMNdlGCT8OfR0+huWMl40iD8aeG0OIjXAr1IrO
ZG7mlRrydSoPU9Cs/0prcARdAf8DAlOvnyzY3dAfE1FESXu/7v+1Q3OkAqHGaL0E
NFbI1IyZeHxN445LEuKJzHmZH/aQCQ9Bpw7wQfbGsfDImKf79Ap84XuZJNDrgJtd
9J9M+mWY3JNssi72nC0G+VLR7c+myeS8LhwlCgAYV91BXXlVDtOIP30PWv1M1Tsr
+4eFoX+43ODXRALIGdBUnS9N4JjTo+5aHgBLCY30hqOa6Irvu4pW6Dc8JQ0FZXrU
I0Sy0MlcSwLPUnkMsNXq6trzPzImFcpyN3+Wk8IhMFZ5PMiWkGIngoeg/pfC61y8
eZ4mWGga1cnWx22Tt0MT0KF45yRjIFYo6FL/mLfCNXf0f904xvEaypW+/akhjwSt
dwvw75ga96pcfeBbLRwpq0zRWFmhISAAWYpyCylB5ODUq0ezh66tuw8RGey0UIFr
h2siczuHH4KuaYmN0w0iccABWbeJz2jiOhRQkkcHp6rMzaUl/CvzOROa8A2/eknM
W8gfDGMPZNuwN0Xby+rgx/ugJOw117GzYjNPyF8KQH7AGUygQfN5cZqM30rj4J9I
y1c5b/se+Goco1E9jAantum71ERgH2bE4Yg5VC2qc6SE1J2Y0LFKMSGV1HiDpPNM
5awgHJBzRqfafWs2kMldBkcuM2wCiR8pq3v0VIHGb7gUtBOSx+D5s/dDyftrSezo
puaGywDvo/MJxYllv27SmUmX6b7ezLTEGLncjPP3MJKakVW2VRtCP1IEQZaVdqya
5ByH3ujDyDstbgp3wYWvOD1BPb4hjpjDZoR7f5PYxj3/kEsNWIC7LC/lsZo5VM07
IUJ9EwKq6Adtbm7vO7RMcFOTEVbmbygao9OFADRidW7l1TWFeieqiCwcsbHsrDac
TdIw5HA9muegbx4z0k1Bsj4VkPCHVrVbQ9DdExVq6Ds08miIDA01KXugmTgl8H6B
gioYv/qmWue9YFAra2VdyQpncKxLnIBIBjio5TUteXsLz7K6jYrj4S7yGs1CoQL9
Qik9TvjiH4lIfQnrkcuX7IxUijXs1Cn5+weIh1w2m5JoM4FYLzJT/soco81sgBYk
CfrIAr17L4jX1RGVyuCBiS+pMZR1bF0xI9WLQ33kU1Rfe5ZY6kgfPla7hrF4W6vV
wj9AkanAEVmnH7qCHSo0bXWnvxz0AwKg00yhgNFqFZ70oftdog1csTbVJh+8ScGT
8GrS/AElpOuW5l0HH7sufLcndgrTl5TzNUXMKfIgvsoIZbqQmgt97k6Gy2nhsQ47
dMX8NCit/50RRBnhgMj1Jtgb7difK0o1a7HdMtYYEAojFy5NThEJyPDzIVr8xDon
/TxNsh9cF5ePFZ/VqbuLtyFeWXnW/YrHTDVSCUfM/d1T0jL3CBP2RSx1pAMszf7y
vJdDIzmNEkPd0zmvlzcHes3Q1/Ah42dQbM8tQesqt9avOM/aQgXcdnJEP4IYfW3V
tRGAPTqBFJQYJrMDwY+tbMFKqGU/raw7IXe/6SU2Mjfq4WL3ezaXnpS5lcwXQBP/
9EqtoL67I9ixrDUmVEhG294Dr9rkbFDv+CKSYID/d2YiaDBYIG4r+A0fCDuLejRO
KNMJ3xr8nfr6ngjlxxTiTtcXZgfpC3s7fA37mTl4IloFI0i8OU8N0tX++NdONgj+
qAJ4u+CKlBADotH4urLeTU7nbug/TcLkylRSbNv/7MK9/GP1ZP9VfWt5SbYCrIKi
68StzI3jK4JAWtw9f0bW5MVKnqxxX85FLxKFn8W0Xq9wHEorWMeTZmCpofeNeQLF
Z7k+mAAQhjaUum3LEFWjQKJM6XaYJXNcKIqVqo4te2NPbqyOmoVWa8mxHp4rPnDz
ujlhcfRxewYRRE91QSlcL1Gr+G7PPeZziLK1sgJeB9Y8TeKmLqZJRPFiPvdPIHU/
CTKdMPY+rKIHo/SsZVKCU/jRzDkafikn3H11vpK59HwjIISOTWVUeghium0J13xD
tutNDhdoBiiPFByNk6lB0bP0X4qQy3g2mZ4OabMpPic19RnZ5GgHtEQnun5GfrOs
atoXwXkQcums+tkY85P+qmmsOXG8jfzzc8AXSJgWVvDsnCXcYRwbywG30VFFu3r2
WgNqGq9c0HqSx62ZaBvGv5uxBPhu5W0toofCx+AbWJ3tb7aoCyMPJPUNzAIvNn3H
RSdVjpkThv+HjXH6FR1rN2YXGIhl5OE2z3agwF2XQlOCvB1X0rc/kNU9s+rd3UPO
92b2wTqV7PfI08xlgKjLUpcP7MJd/nvT6CkLhAc/7YnYO6Ba3NTSyiltQa3P+t+p
vmYVoQPNxq0xFBMfxcPtMmV8EqRe2Zuz4fyAh2HIjCabyfsM6Ep8+pO6bEt26Gc7
xnGlPnXgBL0Uy04iu+uW0aSSgokGE7YmyG/mFySPafZ+bymcHgl2ehGMdf+Z+bpO
muaozS92CXCOCIvR5NFMLdplZptdSAPpkzUS4/6zhMXgv+9mTKYXVL9sKAeP/XX2
ksGhmIma2WX53yzPAZhMTQ0pjMLNtDVQd0AVXMQHHnTTR7TVARZqPJQYCs9yktSs
GjlMqjakBtXb5b+B+nzYACqUiP30FE2AV1TfvxiAj3q5kIh7/ldDoPo1cIwtnHR+
rCSaEkVdFQJgvdxb/fKqBOeoUYIAgzQRyB9Uvap19wH/QmIxLUquEDoIZkfEy+WS
pqdBNDa/5YyNVvzk/Z5la1H7VmlkYWRICLgxcIEEfh8rtxZRk30xn2o4S3rnvmvo
frL6dsI7toLYhxZcU6uaBTEdzkGw4ifNOZe06w9owHOPFcwEiQXB3O5plZMS2hsE
UZdKVdKWsqOwdT/tjtT59bgVGDq9YrkzV5zIt0OKlFSWZjHpuhFe6ZMQNFxGUtPt
jOoJInyFAEq3TEL77lMfOfIQvX/szgL/TkW21RSptC2APMLfZN3k4y/RiWZT2MVV
szp/S6itxmCFhmtgDfWDUfoUn3GQgakkwlqEfcyDaai2Wj5jMhaKIoI1L1Blui2P
WQQd38af0wvibX14uwYiD21xBDh56CzPBX5ginLSOJ0FBHo9KsB38JHh1tK9A1Za
xmILy3NeC1n4BkJ9cqdXiYZERpyDsfWrLd/Temh0f8tQoqjBJ25slobpbVBkoNIH
2fM6Yh46O0CtljAB2jqluVXED6x0iEf2ZBVyX6mrIdFncWp821PvgW2V/mG26Lwt
3KDhLYX6p5LTtEcX7USAegCd1OgmgjH9Nm4W7QLUEPVdofzPdYQR6sJo+k+8dggg
GJLQ+AgG2swnXgZN/0XAy91bJ1wv9AVNlmxeDDAXx7DAIMJ6JJoewZi5SuMszg+6
RmMenZjBvvupZdosed1zmtdKNMf1Th4jo02W4B4jn6tRjdqDWEXPEsoifA14lA5F
a9Km8Ia1FY9ARtruo50hdiwcIjbXaXIdULWfLjGPsEETKK2eHRIcGzojd3kGIZ5s
RebOtFYNgn66sMqHWOxNBqKl/iWmBk6uGptIkG6gGDg1DbtbPsvy/T7oHeMKqju0
ZwW48q6Ih5SlYWyvpqAfbbXsxHghYW9ln2TfZx6O3v8dmClf/puw4EIhhZvIoTxO
K/eQueK5dPgAKL2dT3z+IjvyGYf4/C9dVdT5b/gLshTpgm30N2fidQoAVlPiQUma
FBGyKjP+N+WXp+NEesoQsWtSy2BOETAZBaZe2vfbjH1gsCCS/Kh8+c+MIH6DbJf2
RExjfBx5pVRUr1P5vD5Sag==
`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
RE2fkgQR8s8oAo4HjmKzx1ZYEzkHho0px3uH6CuGm3rZZJNagB1kBmcnIChRou6a
3iCKvsBmHoiU3KhuzLwQuJhfZQLeVTPP7SfORtj+pdJEais0wTpLYFxUVI3nSPw9
yJtBy0gq5ZKCy4stkkuObvA474Gs1iSp7frRHSxHJG0xpBr5qF1IznQ5LrgLtuso
bNaFSql5I0gWbAdB8UL3n73XP/6LOrTMb53lqasMYuqmx2Hk9bGK6DSDvt9MnGip
Q80miEO3LUDhCy6iXcs7sTO1bpmn9G9Bs3ZALJAZLwMJhGDiIasb+ymYjZPNNxjk
NEnDj1YxlI7rsyGN5gB/ZA==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 544 )
`pragma protect data_block
sGfyzotgAThK3F0XY9wr6I3ue6vpHW6QMeHF04hj3ICzKmgn75OyzfJYsNdNTO1c
o+a1GZy7SHompjsvylrNW8UoMF6KGAa/zPujJcMh4ohrX+fMcX8rpGonl9oJO5yF
vDFgPHUlZBKpyBpCZ5NlpW4jQKrpwSM1GmlbE7FKuk9JrI3SfRPU7WiNJzUfWnXa
Vq2SgESwk3P1E37uoSIlL6Qap5eHZc1qxBGoEZxeh0MQWsG/Wsw1bld5Cz1al58D
vW8+6oc0Ag/u6+bWyHy2g61G7qqcnYySR+DCXZYUzd1VxMwfFLMtkqJGGsZHz+5f
VqbVnBYH94Kk4nK2TE4h+sBkKFtTg1LetY5qFIggbzYZMDPhHY3pEewn1c/5ezBi
+qvKezYxoeiygVulVZHjkTFXM2msPa1A7I6IMqQTsokEvrwsC5JvZ1DKrU/UQYam
vofV1m+IXJDDy3yuHoNOjkTwxvOZUWN3B4OzleYEuiiLFUiL87ZNjp044iX295Zo
yFTljrJUMVpbzS3ev/xVvrO1U676JfHkF/GhJ3AP1b4uJ6O+78FnXyaaMA9nJPy8
kx53q8T3eYgaw31ojewbbr94nJWVDLJ2FqKwrusOR/sdvLK/eKagv7FkIRhvoy7e
f7+EaSWLqLAAD4kknC1JXpqbDn4DdUsyU3ubqqoJmnXz5OW8haIDe2HuyNGjJvA1
D0kU6ph45W8eKffCGXDgfA==
`pragma protect end_protected

//pragma protect end
`resetall
`timescale 1ns/1ps
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
mRU/Fp506gxNHeQnkpepTsXZwhY6O1QezmrgJ6IldFOKsQeWlMFxkZKyAmPqXzJs
6Aa9GGpGl2vMAIcMX9ONndVKK8an3nlotHKNQoZzee732JsEerWRN6CK3I10z+4e
aZ3nGAihUeSm2LVOSPr7z/3Ukeq6Qu3L/D7prH/EdAW8qYISU2FKHSRmC4xE2TLv
Fin1ZG1vP8T4UFHXWtQWSzuRUkRB5r40MFikEI3VVZByfbOKdE/JnZRY+vb5DQms
70IxOnxJGrrVUytzPz30yTJc4j4jn3Vlbt+G16uSIItqd4o/koHhhSluaESViFed
lU4pEkvxMhcT0Tayetc7Ew==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 704 )
`pragma protect data_block
lNELXjZDL6OBu2ZR76S5r87cdicAZRBYdOFbp58mQov+D/42vECKvYHMjau1blB+
km1sIrWFKv9vGa8xBPDgoH+M6AIz7RDk+6XKWNrn5FdY+Rl02vK1qpH5ekjkg0Ch
v3TLaWNe+Mdyjsu01KCHJ1OQ8mNzGWhgAPVS6QqlRs59LWgpn0ofcyzuWCiIkid/
rbpNSyDPHPs+H+VZf36uyLnKYAH8z99Y5UJMOCGTPyG5FfzqPv22NNu5NLLpNch2
PwIbBFhBqU+dFU3uPwxeBWMSj2ICK/GassMBlrtd+WS2Gpf3rHZkc0xiQO/UvpDV
ij9uD2gcMfAbumFnzU9qe5QXkzshKyO9kMILS073aQlYdTaqNafsVC9IGaqwyXA/
boLjyqf1HlNStY+9pUJ8lg/7cdE/JeKB1CXJS2STnF+bm514cCSKnJ6M4tMqQFoN
8bOY3maDUUkIdSe1mimyDKBkVKpMyIDAIdQlkJKPfSounRoRT5ESmt2w4N3gUpM+
bCrqVUDTMybejHiLzz7IAlCA3T9kilVSqxknHwDjEsg1vGuRYdcQzWCCjzCFbbFG
hVqxlvp3j/VNGCPHfvMiaLT046AyH61IeYQ9rYs0baXhfzN5AX9n92UYOzJrmVVe
ILUKNrFo7FMK/+3umAv2JYFYEbnA/tbQU7peXmkpgVQRxBNrwfqZbHFh6KD/avC6
A/bHjhQZIadXU6gdrh95MwO89o018fiGsU0y6bt7k4K/jH7iK7yUHjKg7qK0/bxH
XsbzGdogQ1/+u+IIhXpHxfJ31bqZRK1zBkUrzJzQ6xIoFAA2IkCremGvfyChCA+j
mwSqOKb8e4Ww8jx87GtIgkrzYA15vC4An/hghHmQD6wpUAKUPQpK6VFoua1dq7/i
ZUOl0QFBo8BoIEckzaa8c+W32IL2jxH3Mcihf6AM38A=
`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
kY5UwC50faD0b4q8LnoCr3s2A+nWahRu8368R5/t3F2gbMyP2mhJw89nz6SMvWk1
LVOO6KpAFoBjB4NO+V8DmT0UqKUluaytionp4LciZo6UjiqxVnvJ3Bn4ZicYOkbH
EWbjbQWClap1Ol76giXF78yTmfJZYkYrgQNJrVQWOZYvbPt8u8w/+gUfBUqwl7x5
gI1vmGidjn/BKnP5cLUuIO9Qzzg/k36ghjHV2ISY59XmL07v/FKh79oDH7GaE/cJ
8rjg1qhQv5XkhqpCIl3Qz9w01vS9WIFliXDsZXiEAa/tcPlztuQq01jtQBXXQMnn
ks9PN6S/vmUMhczrpyxVcw==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 10128 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
//pragma protect
//pragma protect begin

/* Encryption Envelope */

`pragma protect begin_protected
`pragma protect version = 1
`pragma protect encrypt_agent = "QuestaSim" , encrypt_agent_info = "2023.1_1"
`pragma protect key_keyowner = "Efinix Inc." , key_keyname = "EFX_K01"
`pragma protect key_method = "rsa"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 256 )
`pragma protect key_block
JgZGaTnyQ5qzkvPicS+YaPeBOiaff87mTqGyQNGxK7nTHu/I6tEByJlYt1y4HLPS
zrjyfOgAiRaHBqZlmWnUN/CfUs/ediH1XisMlVbXc4Qq3FyksoRBk3qydaMjdTvS
MwxL6Vmmpd7RaP6DiLvNc/vlYi7VmzmlL79fbguN2j/qTkBUBp/kw0hK0V4shDnF
CfmfAmB5Noo/idSfGsULP79J5Uze3nx1nMvMJDnQes18/nFeM1Aclg6BmCiF7W9M
Ps/7GN+xSM1LkiGYtCz/K47Wmy7IJ0IKxBnyY3er5nb5j5LlWbqqzMH91EtVDBbp
pj+1wG/1burU71YyMHidJQ==
`pragma protect data_method = "aes256-cbc"
`pragma protect encoding = ( enctype = "base64" , line_length = 64 , bytes = 9360 )
`pragma protect data_block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`pragma protect end_protected

//pragma protect end
`undef IP_UUID
`undef IP_NAME_CONCAT
`undef IP_MODULE_NAME
