from PyQt5 import QtWidgets, QtCore
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QDockWidget, QLineEdit, QButtonGroup
from PyQt5.QtGui import QCloseEvent
import sys
import os

from Ui_main import Ui_DockedMainWindow
from viewmodels.transceiver_debugger_view_model import TransceiverDebuggerViewModel
from views.eye_diagram_config_view import EyeDiagramConfigView
from views.status_table_view import StatusTableView
from views.eye_diagram_view import EyeDiagramView

EFINITY_HOME = os.environ['EFINITY_HOME']
sys.path.append(os.path.join(EFINITY_HOME, 'scripts'))
from _app_info import _AppInfo

class TransceiverDebuggerView(QtWidgets.QMainWindow):

    def __init__(self):
        super().__init__()

        # Setup UI based on UI design file
        self.setWindowFlag(QtCore.Qt.WindowContextHelpButtonHint, False)

        self._ui = Ui_DockedMainWindow()
        self._ui.setupUi(self)

        self.setWindowTitle("{} Transceiver Debugger".format(_AppInfo.APP_NAME))

        centralwidget = self.takeCentralWidget()
        self._ui.le_status = QLineEdit(centralwidget)
        self._ui.le_status.setReadOnly(True)
        self._ui.le_status.setObjectName("le_status")
        self._ui.le_status.setText("Ready")

        self.reset_dock_layout()

        self._vm = TransceiverDebuggerViewModel(self, self._ui, True)

        # create child widget
        self.status_table_view = StatusTableView(self._vm.console)
        self._vm.event_postJtagConfig.connect(self.status_table_view._vm.onPostJtagConfig)
        self._vm.event_postJtagUnconfig.connect(self.status_table_view._vm.onPostJtagUnconfig)

        self.eye_diagram_config_view = EyeDiagramConfigView()
        self.eye_diagram_view = EyeDiagramView(self.eye_diagram_config_view._vm)
        self._vm.event_postJtagConfig.connect(self.eye_diagram_view._vm.onPostJtagConfig)
        self._vm.event_postJtagUnconfig.connect(self.eye_diagram_view._vm.onPostJtagUnconfig)

        self._ui.dockWidget_dockSlot1.setWindowTitle('Eye Diagram Plot')
        self._ui.dockWidget_dockSlot1.setWidget(self.eye_diagram_view)

        self._ui.dockWidget_dockSlot2.setWindowTitle('Status')
        self._ui.dockWidget_dockSlot2.setWidget(self.status_table_view)

        self._ui.dockWidget_dockSlot3.setWindowTitle('Configuration')
        self._ui.dockWidget_dockSlot3.setWidget(self.eye_diagram_config_view)

        self.tabifyDockWidget(self._ui.dockWidget_dockSlot2, self._ui.dockWidget_dockSlot3)
        self.tabifyDockWidget(self._ui.dockWidget_console_2, self._ui.dockWidget_terminal)
        self._ui.dockWidget_console_2.setVisible(True)
        self._ui.dockWidget_console_2.raise_()

        #self._uiLaneStatusTable.tableView.horizontalHeader().show()
        #self._uiLaneStatusTable.tableView.setModel(self._vm.getLinksStatusTable())

        self._ui.actionExit.triggered.connect(self._vm.onClose)
        self._ui.actionHelp.triggered.connect(self._vm.on_show_help)
        self._ui.actionAbout.triggered.connect(self._vm.on_show_about)

        # TODO add user event(not depend on text changed)
        self.command_userClickedUsbRefresh = self._ui.pb_refresh_usb_target.clicked
        self.command_userChangedUsbTarget = self._ui.cb_usb_target.currentIndexChanged
        self.command_userChangedRemoteHost = self._ui.pb_edit_remote_host.clicked
        self.command_userClickedRefreshStatus = self._ui.pb_refresh_status.clicked
        self.command_userClickedImportJcf = self._ui.pb_import_jcf.clicked
        self.command_userClickedConfigJtag = self._ui.pb_config_jtag.clicked
        self.command_userClickedUnconfigJtag = self._ui.pb_unconfig_jtag.clicked
        self.command_userClickedSelectImage = self._ui.pb_select_image.clicked
        self.command_userClickedProgram = self._ui.pb_program.clicked
        self.command_userClickedStopProgram = self._ui.pb_stop_prog.clicked
        self.command_userChangedUserInstr = self._ui.cb_user_instr.currentTextChanged
        self.command_userChangedChipNum = self._ui.cb_chip_num.currentTextChanged
        self.command_userPressedTerminalReturn = self._ui.terminal_command.returnPressed
        self.command_userPressedTerminalSendPb = self._ui.pb_send_command.pressed

        # connect commnad with event handler
        self.command_userClickedUsbRefresh.connect(self._vm.onUsbTargetRefresh)
        self.command_userChangedUsbTarget.connect(self._vm.setUsbTarget)
        #self.command_userClickedRefreshStatus.connect(self._vm.onRefreshStatus)
        self.command_userClickedConfigJtag.connect(self._vm.onConfigure)
        self.command_userClickedUnconfigJtag.connect(self._vm.onUnconfig)
        #self.command_userClickedSelectImage.connect(self._vm.onSelectImage)
        #self.command_userClickedProgram.connect(self._vm.onProgram)
        self.command_userChangedUserInstr.connect(self._vm.setUserInstr)
        #self.command_userChangedChipNum.connect(self._vm.setJtagChainChipNum)
        self.command_userPressedTerminalReturn.connect(self._vm.execute_terminal_command)
        self.command_userPressedTerminalSendPb.connect(self._vm.execute_terminal_command)

        self.eye_diagram_view._vm.event_eyesurf_start.connect(self._vm.eyesurf_start)
        self.eye_diagram_view._vm.event_eyesurf_stop.connect(self._vm.eyesurf_stop)

        mode_group = QButtonGroup(self._ui.groupBox_Mode)
        mode_group.addButton(self._ui.radioButton_Single)
        mode_group.addButton(self._ui.radioButton_Mass)
        mode_group.buttonClicked.connect(self.mode_group_clicked)
        self._ui.radioButton_Single.click()     # Trigger the single/mass mode change

        self._ui.pb_mass_mode_input_file.pressed.connect(self._vm.on_load_mass_command_file)
        self._ui.pb_mass_mode_output_file.pressed.connect(self._vm.on_load_mass_command_output_file)

        self._ui.pb_run_mass_terminal.clicked.connect(self._vm.on_run_pressed)
        self._ui.pb_stop_mass_terminal.clicked.connect(self._vm.on_stop_pressed)

        self._ui.cb_mass_mode_output_file.stateChanged.connect(self._vm.on_mass_output_file_check_state_changed)

        self._vm.event_mass_command_start.connect(self.eye_diagram_view._vm.mass_command_started)
        self._vm.event_mass_command_stop.connect(self.eye_diagram_view._vm.mass_command_stopped)

    def reset_dock_layout(self):
        self.removeDockWidget(self._ui.dockWidget_console_2)
        self.removeDockWidget(self._ui.dockWidget_terminal)
        self.removeDockWidget(self._ui.dockWidget_program)

        self.addDockWidget(Qt.LeftDockWidgetArea,
                           self._ui.dockWidget_program)
        self.addDockWidget(Qt.LeftDockWidgetArea,
                           self._ui.dockWidget_console_2)
        self.addDockWidget(Qt.LeftDockWidgetArea,
                           self._ui.dockWidget_terminal)

        self._ui.dockWidget_dockSlot1.show()
        self._ui.dockWidget_dockSlot2.show()
        self._ui.dockWidget_dockSlot3.show()
        self._ui.dockWidget_program.show()
        self._ui.dockWidget_console_2.show()
        self._ui.dockWidget_terminal.show()

    def closeEvent(self, event: QCloseEvent):
        self._vm.onClose()

    def mode_group_clicked(self, button):
        if (button == self._ui.radioButton_Single):
            self._ui.widget_single_mode.show()
            self._ui.widget_mass_mode.hide()
        elif (button == self._ui.radioButton_Mass):
            self._ui.widget_single_mode.hide()
            self._ui.widget_mass_mode.show()
        else:
            pass
