from PyQt5 import QtWidgets, QtCore
from PyQt5.QtCore import Qt
from PyQt5 import QtCore, QtWidgets
from PyQt5.QtWidgets import QSizePolicy, QSpacerItem, QWidget, QMainWindow, QDialog, QApplication, QPushButton, QVBoxLayout, QHBoxLayout, QSpinBox, QLabel

from matplotlib.backends.backend_qt5agg import FigureCanvasQTAgg as FigureCanvas
from matplotlib.backends.backend_qt5agg import NavigationToolbar2QT as NavigationToolbar
import matplotlib.pyplot as plt
import sys
import os

from Ui_plot_canvas import Ui_plotCanvas
from viewmodels.eye_diagram_view_model import EyeDiagramViewModel

class EyeDiagramView(QtWidgets.QWidget):
    def __init__(self, eye_diagram_config_view_model):
        super().__init__()

        self._ui = Ui_plotCanvas()
        self._ui.setupUi(self)

        figure = plt.figure()
        canvas = FigureCanvas(figure)
        toolbar = NavigationToolbar(canvas, self)

        lb_horizontal_open = QLabel('-')
        lb_vertical_open = QLabel('-')
        hlayout_3 = QHBoxLayout()
        hlayout_3.addWidget(QLabel('Horizontal Open: '))
        hlayout_3.addWidget(lb_horizontal_open)
        hlayout_3.addWidget(QLabel('Vertical Open: '))
        hlayout_3.addWidget(lb_vertical_open)

        hlayout_btns = QHBoxLayout()
        btn_run = QPushButton('Start')
        btn_stop = QPushButton('Stop')
        btn_stop.setEnabled(False)
        btn_run.setEnabled(False)
        btn_save_result = QPushButton('Save Result')
        btn_save_result.setVisible(False)
        hlayout_btns.addItem(QSpacerItem(20, 5, QSizePolicy.Expanding, QSizePolicy.Minimum))
        hlayout_btns.addWidget(btn_run)
        hlayout_btns.addWidget(btn_stop)
        hlayout_btns.addWidget(btn_save_result)
        hlayout_btns.addItem(QSpacerItem(20, 5, QSizePolicy.Expanding, QSizePolicy.Minimum))

        # Spacer
        verticalSpacer = QSpacerItem(20, 5, QSizePolicy.Minimum, QSizePolicy.MinimumExpanding)

        self._ui.plotLayout.addWidget(toolbar)
        self._ui.plotLayout.addWidget(canvas, stretch=1)
        self._ui.plotLayout.addLayout(hlayout_btns)
        self._ui.plotLayout.addLayout(hlayout_3)
        self._ui.plotLayout.addItem(verticalSpacer)

        self._vm = EyeDiagramViewModel(self._ui, eye_diagram_config_view_model, canvas, btn_run, btn_stop, lb_horizontal_open, lb_vertical_open)
        btn_run.clicked.connect(self._vm.on_run_pressed)
        btn_stop.clicked.connect(self._vm.on_stop_pressed)
        btn_save_result.clicked.connect(self._vm.on_save_result_pressed)
