module trigger_skipper #(parameter N_WIDTH = 64)( 
    input clk, 
    input resetn,
    input trigger_in,
    input [N_WIDTH-1:0] skip_count,
    output reg trigger_out
);
    
    reg [N_WIDTH-1:0] trigger_count;
    
    always @(posedge clk) begin
        if (!resetn) begin 
            trigger_count <= 'd0;
            trigger_out <= 1'b0;
        end else if (trigger_in) begin
            if (trigger_count == (skip_count-1)) begin
                trigger_count <= 'd0;
                trigger_out <= 1'b1;
            end
            else begin
                trigger_count <= trigger_count + 1'b1;
            end
        end else begin
            trigger_out <= 1'b0;
        end
    end

endmodule
