@echo off

set EFINITY_BINPATH=%~dp0

:: Set Efinity Home one directory up.
call :RESOLVE_PARENT "%EFINITY_BINPATH%\.." EFINITY_HOME

:: Add binpath to front of PATH
set PATH=%EFINITY_HOME%\python311\bin;%EFINITY_HOME%\bin;%EFINITY_HOME%\pgm\bin;%EFINITY_HOME%\debugger\bin;%EFINITY_HOME%\debugger\svf_player\bin;%EFINITY_HOME%\debugger\serdes_debug_tool\bin;%EFINITY_HOME%\scripts;%EFINITY_HOME%\ipm\bin\ip_packager;%PATH%
set PYTHONHOME=%EFINITY_HOME%\python311

:: Fix EFINITY_HOME to have unix-style path separator
set EFINITY_HOME=%EFINITY_HOME:\=/%
set EFXPT_HOME=%EFINITY_HOME%/pt
set EFXPGM_HOME=%EFINITY_HOME%/pgm
set EFXDBG_HOME=%EFINITY_HOME%/debugger
set EFXIPM_HOME=%EFINITY_HOME%/ipm
set EFXSVF_HOME=%EFINITY_HOME%/debugger/svf_player
set EFXSERDESDBG_HOME=%EFINITY_HOME%/debugger/serdes_debug_tool

:: Qt variables
set QT_LOGGING_CONF=%EFINITY_BINPATH%lc.ini
set QT_PLUGIN_PATH=%EFINITY_HOME%/bin
set QT_QPA_PLATFORM_PLUGIN_PATH=%EFINITY_HOME%/python311/platforms
set QTWEBENGINE_CHROMIUM_FLAGS=--disable-gpu

:: Efinity is running under MSFT's Prism emulation layer
:: Disable TCMalloc as the memory protection procedures do not appear to work
if "%PROCESSOR_ARCHITECTURE%"=="ARM64" (    
    set TCMALLOC_DISABLE_REPLACEMENT=1
)

if "%~1"=="--run" goto :RUN

goto :EOF

:RUN
start efinity.exe
goto :EOF

:RESOLVE_PARENT
set %2=%~f1
goto :EOF
