/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.wishbone.sim;

import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple2$mcZZ$sp;
import scala.collection.IterableLike;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.runtime.java8.JFunction0$mcZ$sp;
import scala.util.Random$;
import spinal.core.ClockDomain;
import spinal.core.sim.package$;
import spinal.lib.bus.wishbone.Wishbone;
import spinal.lib.wishbone.sim.WishboneDriver$;
import spinal.lib.wishbone.sim.WishboneStatus;
import spinal.lib.wishbone.sim.WishboneStatus$;
import spinal.lib.wishbone.sim.WishboneTransaction;
import spinal.sim.SimThread;

@ScalaSignature(bytes="\u0006\u0001\u0005-q!B\u000b\u0017\u0011\u0003yb!B\u0011\u0017\u0011\u0003\u0011\u0003\"B\u0015\u0002\t\u0003Q\u0003\"B\u0016\u0002\t\u0003ac\u0001B\u0011\u0017\u00019B\u0001b\f\u0003\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0011\u0011\t\u0011)A\u0005o!)\u0011\u0006\u0002C\u0001{!9\u0001\t\u0002b\u0001\n\u0003\t\u0005BB#\u0005A\u0003%!\tC\u0003G\t\u0011\u0005q\tC\u0003V\t\u0011\u0005a\u000bC\u0003c\t\u0011\u00051\rC\u0003g\t\u0011\u0005q\rC\u0003j\t\u0011\u0005!\u000eC\u0003m\t\u0011\u0005Q\u000eC\u0003p\t\u0011\u0005\u0001\u000fC\u0004t\tE\u0005I\u0011\u0001;\t\r}$A\u0011AA\u0001\u0011\u001d\t\u0019\u0001\u0002C\u0001\u0003\u0003Aq!!\u0002\u0005\t\u0003\t\t!\u0001\bXSND'm\u001c8f\tJLg/\u001a:\u000b\u0005]A\u0012aA:j[*\u0011\u0011DG\u0001\to&\u001c\bNY8oK*\u00111\u0004H\u0001\u0004Y&\u0014'\"A\u000f\u0002\rM\u0004\u0018N\\1m\u0007\u0001\u0001\"\u0001I\u0001\u000e\u0003Y\u0011abV5tQ\n|g.\u001a#sSZ,'o\u0005\u0002\u0002GA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0010\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b5\n9!!\u0003\u0011\u0005\u0001\"1C\u0001\u0003$\u0003\r\u0011Wo\u001d\t\u0003cQj\u0011A\r\u0006\u00033MR!a\f\u000e\n\u0005U\u0012$\u0001C,jg\"\u0014wN\\3\u0002\u0017\rdwnY6e_6\f\u0017N\u001c\t\u0003qmj\u0011!\u000f\u0006\u0003uq\tAaY8sK&\u0011A(\u000f\u0002\f\u00072|7m\u001b#p[\u0006Lg\u000eF\u0002.}}BQaL\u0004A\u0002ABQAN\u0004A\u0002]\n\u0011BY;t'R\fG/^:\u0016\u0003\t\u0003\"\u0001I\"\n\u0005\u00113\"AD,jg\"\u0014wN\\3Ti\u0006$Xo]\u0001\u000bEV\u001c8\u000b^1ukN\u0004\u0013\u0001D:f]\u0012\f5/T1ti\u0016\u0014Hc\u0001%L!B\u0011A%S\u0005\u0003\u0015\u0016\u0012A!\u00168ji\")AJ\u0003a\u0001\u001b\u0006YAO]1og\u0006\u001cG/[8o!\t\u0001c*\u0003\u0002P-\t\u0019r+[:iE>tW\r\u0016:b]N\f7\r^5p]\")\u0011K\u0003a\u0001%\u0006\u0011q/\u001a\t\u0003IMK!\u0001V\u0013\u0003\u000f\t{w\u000e\\3b]\u0006\t2/\u001a8e\u00052|7m[!t\u001b\u0006\u001cH/\u001a:\u0015\u0007!;\u0016\rC\u0003Y\u0017\u0001\u0007\u0011,\u0001\u0007ue\u0006t7/Y2uS>t7\u000fE\u0002[?6k\u0011a\u0017\u0006\u00039v\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005y+\u0013AC2pY2,7\r^5p]&\u0011\u0001m\u0017\u0002\u0004'\u0016\f\b\"B)\f\u0001\u0004\u0011\u0016AG:f]\u0012\u0004\u0016\u000e]3mS:,GM\u00117pG.\f5/T1ti\u0016\u0014Hc\u0001%eK\")\u0001\f\u0004a\u00013\")\u0011\u000b\u0004a\u0001%\u0006Y1/\u001a8e\u0003N\u001cF.\u0019<f)\tA\u0005\u000eC\u0003M\u001b\u0001\u0007Q*\u0001\ttK:$'\t\\8dW\u0006\u001b8\u000b\\1wKR\u0011\u0001j\u001b\u0005\u00061:\u0001\r!W\u0001\u001ag\u0016tG\rU5qK2Lg.\u001a3CY>\u001c7.Q:TY\u00064X\r\u0006\u0002I]\")\u0001l\u0004a\u00013\u0006)AM]5wKR\u0019\u0001*\u001d:\t\u000ba\u0003\u0002\u0019A-\t\u000fE\u0003\u0002\u0013!a\u0001%\u0006yAM]5wK\u0012\"WMZ1vYR$#'F\u0001vU\t\u0011foK\u0001x!\tAX0D\u0001z\u0015\tQ80A\u0005v]\u000eDWmY6fI*\u0011A0J\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001@z\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0011g2\fg/Z!dWJ+7\u000f]8og\u0016$\u0012\u0001S\u0001\u001ag2\fg/Z!dWBK\u0007/\u001a7j]\u0016$'+Z:q_:\u001cX-A\u0005tY\u00064XmU5oW\")qf\u0001a\u0001a!)ag\u0001a\u0001o\u0001")
public class WishboneDriver {
    private final Wishbone bus;
    private final ClockDomain clockdomain;
    private final WishboneStatus busStatus;

    public static WishboneDriver apply(Wishbone wishbone, ClockDomain clockDomain) {
        return WishboneDriver$.MODULE$.apply(wishbone, clockDomain);
    }

    public WishboneStatus busStatus() {
        return this.busStatus;
    }

    public void sendAsMaster(WishboneTransaction transaction, boolean we) {
        transaction.driveAsMaster(this.bus, we);
        if (!this.bus.config().isPipelined()) {
            package$.MODULE$.SimClockDomainPimper(this.clockdomain).waitSamplingWhere((JFunction0$mcZ$sp & Serializable)() -> this.busStatus().isAck());
            return;
        }
        package$.MODULE$.SimClockDomainPimper(this.clockdomain).waitSamplingWhere((JFunction0$mcZ$sp & Serializable)() -> !this.busStatus().isStall());
    }

    public void sendBlockAsMaster(Seq<WishboneTransaction> transactions, boolean we) {
        package$.MODULE$.SimBoolPimper(this.bus.CYC()).$hash$eq(true);
        ((IterableLike)transactions.dropRight(1)).foreach((Function1<WishboneTransaction, Object> & java.io.Serializable & Serializable)tran -> {
            WishboneDriver.$anonfun$sendBlockAsMaster$1(this, we, tran);
            return BoxedUnit.UNIT;
        });
        package$.MODULE$.SimBoolPimper(this.bus.STB()).$hash$eq(true);
        this.sendAsMaster((WishboneTransaction)transactions.last(), we);
        package$.MODULE$.SimBoolPimper(this.bus.STB()).$hash$eq(false);
        package$.MODULE$.SimBoolPimper(this.bus.CYC()).$hash$eq(false);
    }

    public void sendPipelinedBlockAsMaster(Seq<WishboneTransaction> transactions, boolean we) {
        package$.MODULE$.SimBoolPimper(this.bus.CYC()).$hash$eq(true);
        package$.MODULE$.SimBoolPimper(this.bus.STB()).$hash$eq(true);
        SimThread ackCounter = package$.MODULE$.fork((JFunction0$mcV$sp & Serializable)() -> {
            for (int counter2 = 0; counter2 < transactions.size(); ++counter2) {
                package$.MODULE$.SimClockDomainPimper($this.clockdomain).waitSamplingWhere((JFunction0$mcZ$sp & Serializable)() -> this.busStatus().isAck());
            }
        });
        transactions.foreach((Function1<WishboneTransaction, Object> & java.io.Serializable & Serializable)x$1 -> {
            this.sendAsMaster(x$1, we);
            return BoxedUnit.UNIT;
        });
        package$.MODULE$.SimBoolPimper(this.bus.STB()).$hash$eq(false);
        ackCounter.join();
        package$.MODULE$.SimBoolPimper(this.bus.CYC()).$hash$eq(false);
    }

    public void sendAsSlave(WishboneTransaction transaction) {
        package$.MODULE$.SimClockDomainPimper(this.clockdomain).waitSamplingWhere((JFunction0$mcZ$sp & Serializable)() -> this.busStatus().isTransfer());
        transaction.driveAsSlave(this.bus);
        package$.MODULE$.SimBoolPimper(this.bus.ACK()).$hash$eq(true);
        package$.MODULE$.waitUntil((JFunction0$mcZ$sp & Serializable)() -> !this.busStatus().isTransfer());
        package$.MODULE$.SimBoolPimper(this.bus.ACK()).$hash$eq(false);
    }

    public void sendBlockAsSlave(Seq<WishboneTransaction> transactions) {
        transactions.foreach((Function1<WishboneTransaction, Object> & java.io.Serializable & Serializable)transaction -> {
            this.sendAsSlave(transaction);
            return BoxedUnit.UNIT;
        });
    }

    public void sendPipelinedBlockAsSlave(Seq<WishboneTransaction> transactions) {
        package$.MODULE$.SimBoolPimper(this.bus.ACK()).$hash$eq(true);
        transactions.foreach((Function1<WishboneTransaction, Object> & java.io.Serializable & Serializable)transaction -> {
            WishboneDriver.$anonfun$sendPipelinedBlockAsSlave$1(this, transaction);
            return BoxedUnit.UNIT;
        });
        package$.MODULE$.waitUntil((JFunction0$mcZ$sp & Serializable)() -> !this.busStatus().isTransfer());
        package$.MODULE$.SimBoolPimper(this.bus.ACK()).$hash$eq(false);
    }

    public void drive(Seq<WishboneTransaction> transactions, boolean we) {
        Tuple2$mcZZ$sp tuple2$mcZZ$sp = new Tuple2$mcZZ$sp(this.bus.isMasterInterface(), this.bus.config().isPipelined());
        if (tuple2$mcZZ$sp != null) {
            boolean bl = ((Tuple2)tuple2$mcZZ$sp)._1$mcZ$sp();
            boolean bl2 = ((Tuple2)tuple2$mcZZ$sp)._2$mcZ$sp();
            if (!bl && !bl2) {
                this.sendBlockAsMaster(transactions, we);
                return;
            }
        }
        if (tuple2$mcZZ$sp != null) {
            boolean bl = ((Tuple2)tuple2$mcZZ$sp)._1$mcZ$sp();
            boolean bl3 = ((Tuple2)tuple2$mcZZ$sp)._2$mcZ$sp();
            if (!bl && bl3) {
                this.sendPipelinedBlockAsMaster(transactions, we);
                return;
            }
        }
        if (tuple2$mcZZ$sp != null) {
            boolean bl = ((Tuple2)tuple2$mcZZ$sp)._1$mcZ$sp();
            boolean bl4 = ((Tuple2)tuple2$mcZZ$sp)._2$mcZ$sp();
            if (bl && !bl4) {
                this.sendBlockAsSlave(transactions);
                return;
            }
        }
        if (tuple2$mcZZ$sp != null) {
            boolean bl = ((Tuple2)tuple2$mcZZ$sp)._1$mcZ$sp();
            boolean bl5 = ((Tuple2)tuple2$mcZZ$sp)._2$mcZ$sp();
            if (bl && bl5) {
                this.sendPipelinedBlockAsSlave(transactions);
                return;
            }
        }
        throw new MatchError(tuple2$mcZZ$sp);
    }

    public boolean drive$default$2() {
        return true;
    }

    public void slaveAckResponse() {
        package$.MODULE$.SimClockDomainPimper(this.clockdomain).waitSamplingWhere((JFunction0$mcZ$sp & Serializable)() -> this.busStatus().isTransfer());
        package$.MODULE$.SimBoolPimper(this.bus.ACK()).$hash$eq(true);
        package$.MODULE$.waitUntil((JFunction0$mcZ$sp & Serializable)() -> !this.busStatus().isTransfer());
        package$.MODULE$.SimBoolPimper(this.bus.ACK()).$hash$eq(false);
    }

    public void slaveAckPipelinedResponse() {
        package$.MODULE$.SimClockDomainPimper(this.clockdomain).waitSamplingWhere((JFunction0$mcZ$sp & Serializable)() -> this.busStatus().isCycle());
        SimThread cycle = package$.MODULE$.fork((JFunction0$mcV$sp & Serializable)() -> {
            package$.MODULE$.fork((JFunction0$mcV$sp & Serializable)() -> {
                package$.MODULE$.waitUntil((JFunction0$mcZ$sp & Serializable)() -> !this.busStatus().isCycle());
                package$.MODULE$.SimBoolPimper($this.bus.ACK()).$hash$eq(false);
                package$.MODULE$.SimBoolPimper($this.bus.STALL()).$hash$eq(false);
            });
            while (this.busStatus().isCycle()) {
                boolean ack = Random$.MODULE$.nextBoolean();
                package$.MODULE$.SimBoolPimper($this.bus.ACK()).$hash$eq(ack);
                package$.MODULE$.SimBoolPimper($this.bus.STALL()).$hash$eq(Random$.MODULE$.nextBoolean() && !ack);
                package$.MODULE$.SimClockDomainPimper($this.clockdomain).waitSampling();
            }
        });
        cycle.join();
    }

    public void slaveSink() {
        SimThread dummy = package$.MODULE$.fork((JFunction0$mcV$sp & Serializable)() -> {
            while (true) {
                if ($this.bus.config().isPipelined()) {
                    this.slaveAckPipelinedResponse();
                    continue;
                }
                this.slaveAckResponse();
            }
        });
    }

    public static final /* synthetic */ void $anonfun$sendBlockAsMaster$1(WishboneDriver $this, boolean we$1, WishboneTransaction tran) {
        package$.MODULE$.SimBoolPimper($this.bus.STB()).$hash$eq(true);
        $this.sendAsMaster(tran, we$1);
        if (!$this.bus.config().isPipelined()) {
            package$.MODULE$.SimBoolPimper($this.bus.STB()).$hash$eq(false);
            package$.MODULE$.SimClockDomainPimper($this.clockdomain).waitSampling();
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$sendPipelinedBlockAsSlave$1(WishboneDriver $this, WishboneTransaction transaction) {
        package$.MODULE$.SimClockDomainPimper($this.clockdomain).waitSamplingWhere((JFunction0$mcZ$sp & Serializable)() -> $this.busStatus().isTransfer());
        transaction.driveAsSlave($this.bus);
    }

    public WishboneDriver(Wishbone bus, ClockDomain clockdomain) {
        this.bus = bus;
        this.clockdomain = clockdomain;
        this.busStatus = WishboneStatus$.MODULE$.apply(bus);
    }
}

