/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.misc.test;

import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0$mcV$sp;
import spinal.core.Component;
import spinal.core.sim.SimCompiled;
import spinal.core.sim.package$;
import spinal.lib.misc.test.AsyncJob;

public final class DualSimTracer$ {
    public static DualSimTracer$ MODULE$;

    static {
        new DualSimTracer$();
    }

    public <T extends Component> void apply(SimCompiled<T> compiled, long window, int seed, Function1<T, BoxedUnit> testbench) {
        this.withCb(compiled, window, seed, (Function2<Component, Function1, Object> & Serializable & scala.Serializable)(dut, x$1) -> {
            testbench.apply(dut);
            return BoxedUnit.UNIT;
        });
    }

    public <T extends Component> void withCb(SimCompiled<T> compiled, long window, int seed, boolean dualSimEnable, Function2<T, Function1<Function0<BoxedUnit>, BoxedUnit>, BoxedUnit> testbench) {
        boolean bl = dualSimEnable;
        if (bl) {
            this.withCb(compiled, window, seed, testbench);
            return;
        }
        if (!bl) {
            ArrayBuffer traceCallbacks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
            compiled.doSimUntilVoid(seed, (Function1<Component, Object> & Serializable & scala.Serializable)dut -> {
                DualSimTracer$.$anonfun$withCb$1(testbench, traceCallbacks, dut);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(BoxesRunTime.boxToBoolean(bl));
    }

    public <T extends Component> void withCb(SimCompiled<T> compiled, long window, int seed, Function2<T, Function1<Function0<BoxedUnit>, BoxedUnit>, BoxedUnit> testbench) {
        LongRef mTime = LongRef.create(0L);
        BooleanRef mEnded = BooleanRef.create(false);
        BooleanRef explorerFailed = BooleanRef.create(false);
        ExecutionContextExecutor ec = ExecutionContext$.MODULE$.global();
        AsyncJob explorer = new AsyncJob(true, new File(compiled.compiledPath(), "explorer"), (JFunction0$mcV$sp & scala.Serializable)() -> {
            try {
                compiled.doSimUntilVoid("explorer", seed, (Function1<Component, Object> & Serializable & scala.Serializable)dut -> {
                    DualSimTracer$.$anonfun$withCb$5(window, mTime, mEnded, testbench, dut);
                    return BoxedUnit.UNIT;
                });
                Predef$.MODULE$.println("Explorer success");
            }
            catch (Throwable e) {
                explorerFailed$1.elem = true;
                throw e;
            }
        }, ec);
        AsyncJob tracer = new AsyncJob(false, new File(compiled.compiledPath(), "tracer"), (JFunction0$mcV$sp & scala.Serializable)() -> {
            ArrayBuffer traceCallbacks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
            compiled.doSimUntilVoid("tracer", seed, (Function1<Component, Object> & Serializable & scala.Serializable)dut -> {
                DualSimTracer$.$anonfun$withCb$10(window, mTime, mEnded, explorerFailed, traceCallbacks, testbench, dut);
                return BoxedUnit.UNIT;
            });
        }, ec);
        explorer.join();
        tracer.join();
        spinal.core.package$.MODULE$.assert(explorer.failed() == tracer.failed());
        if (tracer.failed()) {
            throw new Exception(new StringBuilder(39).append("Dual sim reached end with failure, see ").append(tracer.logsPath().getAbsolutePath()).toString());
        }
        Predef$.MODULE$.println("Done");
    }

    public static final /* synthetic */ void $anonfun$withCb$1(Function2 testbench$2, ArrayBuffer traceCallbacks$1, Component dut) {
        testbench$2.apply(dut, (Function1<Function0, Object> & Serializable & scala.Serializable)f -> {
            traceCallbacks$1.$plus$eq(f);
            return BoxedUnit.UNIT;
        });
        traceCallbacks$1.foreach((Function1<Function0, Object> & Serializable & scala.Serializable)x$2 -> {
            x$2.apply$mcV$sp();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$withCb$8(Function0 cb) {
    }

    public static final /* synthetic */ void $anonfun$withCb$5(long window$1, LongRef mTime$1, BooleanRef mEnded$1, Function2 testbench$3, Component dut) {
        package$.MODULE$.disableSimWave();
        package$.MODULE$.periodicaly(window$1, (JFunction0$mcV$sp & scala.Serializable)() -> {
            mTime$1.elem = package$.MODULE$.simTime();
        });
        package$.MODULE$.onSimEnd((JFunction0$mcV$sp & scala.Serializable)() -> {
            mTime$1.elem = package$.MODULE$.simTime();
            mEnded$1.elem = true;
        });
        testbench$3.apply(dut, (Function1<Function0, Object> & Serializable & scala.Serializable)cb -> {
            DualSimTracer$.$anonfun$withCb$8(cb);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$withCb$10(long window$1, LongRef mTime$1, BooleanRef mEnded$1, BooleanRef explorerFailed$1, ArrayBuffer traceCallbacks$2, Function2 testbench$3, Component dut) {
        package$.MODULE$.disableSimWave();
        package$.MODULE$.fork((JFunction0$mcV$sp & scala.Serializable)() -> {
            package$.MODULE$.sleep(0L);
            while (true) {
                if (package$.MODULE$.simTime() + window$1 * 2L >= mTime$1.elem && !mEnded$1.elem) {
                    Thread.sleep(100L, 0);
                    continue;
                }
                if (mEnded$1.elem && explorerFailed$1.elem) {
                    package$.MODULE$.sleep(RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(mTime$1.elem - package$.MODULE$.simTime() - window$1), 0L));
                    package$.MODULE$.enableSimWave();
                    traceCallbacks$2.foreach((Function1<Function0, Object> & Serializable & scala.Serializable)x$3 -> {
                        x$3.apply$mcV$sp();
                        return BoxedUnit.UNIT;
                    });
                    package$.MODULE$.sleep(window$1 + 1000L);
                    throw package$.MODULE$.simFailure("slave thread didn't ended ????");
                }
                package$.MODULE$.sleep(window$1);
            }
        });
        Predef$.MODULE$.println("Tracer success");
        testbench$3.apply(dut, (Function1<Function0, Object> & Serializable & scala.Serializable)callback -> {
            traceCallbacks$2.$plus$eq(callback);
            return BoxedUnit.UNIT;
        });
    }

    private DualSimTracer$() {
        MODULE$ = this;
    }
}

