/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.eda.xilinx;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.BigDecimal$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LambdaDeserialize;
import spinal.core.HertzNumber;
import spinal.core.PhysicalNumber;
import spinal.core.TimeNumber;
import spinal.core.package$;
import spinal.core.package$IntBuilder$;
import spinal.lib.DoCmd$;
import spinal.lib.eda.bench.Report;
import spinal.lib.eda.bench.Rtl;
import spinal.lib.eda.xilinx.VivadoFlow$;

public final class VivadoFlow$ {
    public static VivadoFlow$ MODULE$;

    static {
        new VivadoFlow$();
    }

    public Report apply(String vivadoPath, String workspacePath, Rtl rtl, String family, String device, HertzNumber frequencyTarget, int processorCount) {
        TimeNumber targetPeriod = (frequencyTarget != null ? frequencyTarget : package$IntBuilder$.MODULE$.MHz$extension(package$.MODULE$.IntToBuilder(500))).toTime();
        File workspacePathFile = new File(workspacePath);
        FileUtils.deleteDirectory(workspacePathFile);
        workspacePathFile.mkdir();
        rtl.getRtlPaths().foreach((Function1<String, Object> & Serializable & scala.Serializable)file -> {
            VivadoFlow$.$anonfun$apply$1(workspacePathFile, file);
            return BoxedUnit.UNIT;
        });
        Function1<String, Object> & Serializable & scala.Serializable isVhdl = (Function1<String, Object> & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean(VivadoFlow$.$anonfun$apply$2(file));
        String readRtl = ((TraversableOnce)rtl.getRtlPaths().map((Function1<String, String> & Serializable & scala.Serializable)file -> new StringBuilder(6).append("read_").append((Object)(BoxesRunTime.unboxToBoolean(isVhdl.apply(file)) ? "vhdl" : "verilog")).append(" ").append(Paths.get(file, new String[0]).getFileName()).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n");
        FileWriter tcl = new FileWriter(Paths.get(workspacePath, "doit.tcl").toFile());
        tcl.write(new StringBuilder(714).append("\ncreate_project -force project_bft_batch ./project_bft_batch -part ").append(device).append("\n\nadd_files {").append(rtl.getRtlPaths().mkString(" ")).append("}\nadd_files -fileset constrs_1 ./doit.xdc\n\nimport_files -force\n\nset_property -name {STEPS.SYNTH_DESIGN.ARGS.MORE OPTIONS} -value {-mode out_of_context} -objects [get_runs synth_1]\nlaunch_runs synth_1\nwait_on_run synth_1\nopen_run synth_1 -name netlist_1\n\nreport_timing_summary -delay_type max -report_unconstrained -check_timing_verbose -max_paths 10 -input_pins -file syn_timing.rpt\nreport_power -file syn_power.rpt\n\nlaunch_runs impl_1\nwait_on_run impl_1\n\nopen_run impl_1\nreport_utilization\nreport_timing_summary -warn_on_violation\nreport_pulse_width -warn_on_violation -all_violators\nreport_design_analysis -logic_level_distribution\n").toString());
        tcl.flush();
        tcl.close();
        FileWriter xdc = new FileWriter(Paths.get(workspacePath, "doit.xdc").toFile());
        xdc.write(new StringBuilder(37).append("create_clock -period ").append(((PhysicalNumber)targetPeriod.$times(BigDecimal$.MODULE$.double2bigDecimal(1.0E9))).toBigDecimal()).append(" [get_ports clk]").toString());
        xdc.flush();
        xdc.close();
        DoCmd$.MODULE$.doCmd(new StringBuilder(61).append(vivadoPath).append("/vivado -nojournal -log doit.log -mode batch -source doit.tcl").toString(), workspacePath);
        BufferedSource log = Source$.MODULE$.fromFile(Paths.get(workspacePath, "doit.log").toFile(), Codec$.MODULE$.fallbackSystemCodec());
        String report = log.getLines().mkString();
        return new Report(report, family, targetPeriod){
            private final String report$1;
            private final String family$1;
            private final TimeNumber targetPeriod$1;

            public String toString() {
                return Report.toString$(this);
            }

            private double getPulseSlack() {
                DoubleRef lowest_pulse_slack = DoubleRef.create(100000.0);
                List<A> pulse_strings = new StringOps(Predef$.MODULE$.augmentString("(Min Period|Low Pulse Width|High Pulse Width)(?:\\s+\\S+){5}(?:\\s+)-?(\\d+.?\\d+)+")).r().findAllIn(this.report$1).toList();
                pulse_strings.foreach((Function1<String, Object> & Serializable & scala.Serializable)pulse_string -> {
                    anon.1.$anonfun$getPulseSlack$1(lowest_pulse_slack, pulse_string);
                    return BoxedUnit.UNIT;
                });
                return lowest_pulse_slack.elem;
            }

            private String findFirst2StageInReport(String regex1st, String regex2nd) {
                String string;
                try {
                    string = new StringOps(Predef$.MODULE$.augmentString(regex1st)).r().findFirstIn(new StringOps(Predef$.MODULE$.augmentString(regex2nd)).r().findFirstIn(this.report$1).get()).get();
                }
                catch (Exception e) {
                    string = "???";
                }
                return string;
            }

            public double getFMax() {
                double slack;
                block3: {
                    double d;
                    String intFind = "-?(\\d+\\.?)+";
                    try {
                        String string = this.family$1;
                        if (!("Artix 7".equals(string) ? true : ("Kintex 7".equals(string) ? true : ("Kintex UltraScale".equals(string) ? true : ("Kintex UltraScale+".equals(string) ? true : "Virtex UltraScale+".equals(string)))))) {
                            throw new MatchError((Object)string);
                        }
                        d = new StringOps(Predef$.MODULE$.augmentString(this.findFirst2StageInReport(intFind, "-?(\\d+.?)+ns  \\(required time - arrival time\\)"))).toDouble();
                    }
                    catch (Exception e) {
                        d = -100000.0;
                    }
                    slack = d;
                    double pulse_slack = this.getPulseSlack();
                    if (!(pulse_slack < slack)) break block3;
                    slack = pulse_slack;
                }
                return 1.0 / (this.targetPeriod$1.toDouble() - slack * 1.0E-9);
            }

            public String getArea() {
                String string;
                block4: {
                    String intFind = "(\\d+,?\\.?\\d*)";
                    try {
                        String string2 = this.family$1;
                        if ("Artix 7".equals(string2) ? true : "Kintex 7".equals(string2)) {
                            string = new StringBuilder(9).append(this.findFirst2StageInReport(intFind, "Slice LUTs[ ]*\\|[ ]*(\\d+,?)+")).append(" LUT ").append(this.findFirst2StageInReport(intFind, "Slice Registers[ ]*\\|[ ]*(\\d+,?)+")).append(" FF ").toString();
                            break block4;
                        }
                        if ("Kintex UltraScale".equals(string2) ? true : ("Kintex UltraScale+".equals(string2) ? true : "Virtex UltraScale+".equals(string2))) {
                            string = new StringBuilder(21).append(this.findFirst2StageInReport(intFind, "\\| CLB LUTs[ ]*\\|([ ]*\\S+\\s+\\|){5}")).append(" LUT ").append(this.findFirst2StageInReport(intFind, "\\| CLB Registers[ ]*\\|([ ]*\\S+\\s+\\|){5}")).append(" FF ").append(this.findFirst2StageInReport(intFind, "\\| Block RAM Tile[ ]*\\|([ ]*\\S+\\s+\\|){5}")).append(" BRAM ").append(this.findFirst2StageInReport(intFind, "\\| URAM[ ]*\\|([ ]*\\S+\\s+\\|){5}")).append(" URAM ").toString();
                            break block4;
                        }
                        throw new MatchError((Object)string2);
                    }
                    catch (Exception e) {
                        string = "???";
                    }
                }
                String leArea = string;
                return leArea;
            }

            public static final /* synthetic */ void $anonfun$getPulseSlack$1(DoubleRef lowest_pulse_slack$1, String pulse_string) {
                List<A> pulse_slack_numbers = new StringOps(Predef$.MODULE$.augmentString("\\s-?([0-9]+\\.?[0-9]+)+")).r().findAllIn(pulse_string).toList();
                if (pulse_slack_numbers.length() >= 3) {
                    StringOps stringOps = new StringOps(Predef$.MODULE$.augmentString((String)pulse_slack_numbers.apply(2)));
                    if (stringOps.toDouble() < lowest_pulse_slack$1.elem) {
                        lowest_pulse_slack$1.elem = new StringOps(Predef$.MODULE$.augmentString((String)pulse_slack_numbers.apply(2))).toDouble();
                        return;
                    }
                    return;
                }
            }
            {
                this.report$1 = report$1;
                this.family$1 = family$1;
                this.targetPeriod$1 = targetPeriod$1;
                Report.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getPulseSlack$1$adapted(scala.runtime.DoubleRef java.lang.String )}, serializedLambda);
            }
        };
    }

    public HertzNumber apply$default$6() {
        return null;
    }

    public int apply$default$7() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$apply$1(File workspacePathFile$1, String file) {
        FileUtils.copyFileToDirectory(new File(file), workspacePathFile$1);
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(String file) {
        return file.endsWith(".vhd") || file.endsWith(".vhdl");
    }

    private VivadoFlow$() {
        MODULE$ = this;
    }
}

