/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.eda.microsemi;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import spinal.core.Bits;
import spinal.core.HardType$;
import spinal.core.HertzNumber;
import spinal.core.SpinalVhdl$;
import spinal.core.TimeNumber;
import spinal.core.package$;
import spinal.core.package$IntBuilder$;
import spinal.lib.DoCmd$;
import spinal.lib.StreamFifo;
import spinal.lib.StreamFifo$;
import spinal.lib.eda.bench.Report;

public final class LiberoFlow$ {
    public static LiberoFlow$ MODULE$;

    static {
        new LiberoFlow$();
    }

    public Report apply(String liberoPath, String workspacePath, String toplevelPath, String family, String device, HertzNumber frequencyTarget, int processorCount) {
        String projectName = (String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])((String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])toplevelPath.split("/"))).last()).split("[.]"))).head();
        TimeNumber targetPeriod = (frequencyTarget != null ? frequencyTarget : package$IntBuilder$.MODULE$.MHz$extension(package$.MODULE$.IntToBuilder(100))).toTime();
        File workspacePathFile = new File(workspacePath);
        FileUtils.deleteDirectory(workspacePathFile);
        workspacePathFile.mkdir();
        boolean isVhdl = toplevelPath.endsWith(".vhd") || toplevelPath.endsWith(".vhdl");
        String[] device_parameters = device.split("-");
        String device_die = device_parameters[0];
        String device_package = device_parameters[1];
        String device_speed = device_parameters[2];
        FileWriter tcl = new FileWriter(Paths.get(workspacePath, "doit.tcl").toFile());
        tcl.write(new StringBuilder(363).append("new_project\\\n  -location {").append(Paths.get(workspacePath, projectName)).append("} \\\n  -name {").append(projectName).append("} \\\n  -project_description {} \\\n  -hdl {").append((Object)(isVhdl ? "VHDL" : "VERILOG")).append("} \\\n  -family {").append(family).append("} \\\n  -die {").append(device_die).append("} \\\n  -package {").append(device_package).append("} \\\n  -speed {-").append(device_speed).append("}\n\ncreate_links \\\n  -hdl_source {").append(new File(toplevelPath).getAbsolutePath()).append("}\n\nrun_tool -name {SYNTHESIZE} -script {} -defvar {} -defvars {}\n\nrun_tool -name {PLACEROUTE} -script {} -defvar {} -defvars {}\n\nrun_tool -name {VERIFYTIMING} -script {} -defvar {} -defvars {}\n").toString());
        tcl.flush();
        tcl.close();
        DoCmd$.MODULE$.doCmd(new StringBuilder(23).append(liberoPath).append("/libero SCRIPT:doit.tcl").toString(), ((Object)Paths.get(workspacePath, new String[0])).toString());
        return new Report(workspacePath, projectName, family){
            private final String workspacePath$1;
            private final String projectName$1;
            private final String family$1;

            public String toString() {
                return Report.toString$(this);
            }

            public double getFMax() {
                double d;
                String report = Source$.MODULE$.fromFile(Paths.get(this.workspacePath$1, this.projectName$1, "designer/impl1", new StringBuilder(27).append(this.projectName$1).append("_maxdelay_timing_report.txt").toString()).toFile(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
                Regex intFind = new StringOps(Predef$.MODULE$.augmentString("-?(\\d+\\.?)+")).r();
                try {
                    String string = this.family$1;
                    if (!"ProASIC3E".equals(string)) {
                        throw new MatchError((Object)string);
                    }
                    d = new StringOps(Predef$.MODULE$.augmentString(intFind.findFirstIn(new StringOps(Predef$.MODULE$.augmentString("Frequency[ ]\\(MHz\\)\\:[ ]*(\\d+.\\d+,?)+")).r().findFirstIn(report).get()).get())).toDouble();
                }
                catch (Exception e) {
                    d = -1.0;
                }
                double leFreq = d;
                return leFreq * 1000000.0;
            }

            public String getArea() {
                String string;
                String report = Source$.MODULE$.fromFile(Paths.get(this.workspacePath$1, this.projectName$1, "designer/impl1", new StringBuilder(27).append(this.projectName$1).append("_place_and_route_report.txt").toString()).toFile(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
                Regex intFind = new StringOps(Predef$.MODULE$.augmentString("(\\d+\\.?)+")).r();
                try {
                    String string2 = this.family$1;
                    if (!"ProASIC3E".equals(string2)) {
                        throw new MatchError((Object)string2);
                    }
                    string = new StringBuilder(28).append(intFind.findFirstIn(new StringOps(Predef$.MODULE$.augmentString("COMB[ ]*\\|[ ]*(\\d+,?)+")).r().findFirstIn(report).get()).get()).append(" COMB, ").append((Object)intFind.findFirstIn(new StringOps(Predef$.MODULE$.augmentString("SEQ[ ]*\\|[ ]*(\\d+,?)+")).r().findFirstIn(report).get()).get()).append(" SEQ -> ").append(intFind.findAllIn(new StringOps(Predef$.MODULE$.augmentString("CORE[ ]*Used:[ ]*\\d+[ ]*Total:[ ]*\\d+[ ]*\\((\\d+.\\d+,?)")).r().findFirstIn(report).get()).toList().apply(2)).append("% Total CORE ").toString();
                }
                catch (Exception e) {
                    string = "???";
                }
                String leArea = string;
                return leArea;
            }
            {
                this.workspacePath$1 = workspacePath$1;
                this.projectName$1 = projectName$1;
                this.family$1 = family$1;
                Report.$init$(this);
            }
        };
    }

    public HertzNumber apply$default$6() {
        return null;
    }

    public int apply$default$7() {
        return 1;
    }

    public void main(String[] args) {
        SpinalVhdl$.MODULE$.apply((Function0<StreamFifo> & Serializable & scala.Serializable)() -> {
            StreamFifo qual$1 = (StreamFifo)new StreamFifo(HardType$.MODULE$.implFactory((Function0<Bits> & Serializable & scala.Serializable)() -> package$.MODULE$.Bits(package$IntBuilder$.MODULE$.bits$extension(package$.MODULE$.IntToBuilder(8)))), 128, StreamFifo$.MODULE$.$lessinit$greater$default$3(), StreamFifo$.MODULE$.$lessinit$greater$default$4(), StreamFifo$.MODULE$.$lessinit$greater$default$5(), StreamFifo$.MODULE$.$lessinit$greater$default$6(), StreamFifo$.MODULE$.$lessinit$greater$default$7()).postInitCallback();
            String x$1 = "fifo128";
            boolean x$2 = qual$1.setDefinitionName$default$2();
            return (StreamFifo)qual$1.setDefinitionName(x$1, x$2);
        });
        Report report = this.apply("C:/eda/Microsemi/Libero_v11.0/Designer/bin", "E:/tmp/test1", "fifo128.vhd", "ProASIC3E", "a3pe3000-fg484-2", package$IntBuilder$.MODULE$.MHz$extension(package$.MODULE$.IntToBuilder(1)), this.apply$default$7());
        Predef$.MODULE$.println(report.getArea());
        Predef$.MODULE$.println(BoxesRunTime.boxToDouble(report.getFMax()));
    }

    private LiberoFlow$() {
        MODULE$ = this;
    }
}

