/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.eda.efinix;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import spinal.core.HertzNumber;
import spinal.core.PhysicalNumber;
import spinal.core.TimeNumber;
import spinal.core.package$;
import spinal.core.package$IntBuilder$;
import spinal.lib.DoCmd$;
import spinal.lib.eda.bench.Report;
import spinal.lib.eda.bench.Rtl;

public final class EfinixFlow$ {
    public static EfinixFlow$ MODULE$;

    static {
        new EfinixFlow$();
    }

    public Report apply(String efinixPath, String workspacePath, Rtl rtl, String family, String device, String timing, HertzNumber frequencyTarget) {
        TimeNumber targetPeriod = (frequencyTarget != null ? frequencyTarget : package$IntBuilder$.MODULE$.MHz$extension(package$.MODULE$.IntToBuilder(500))).toTime();
        File workspacePathFile = new File(workspacePath);
        FileUtils.deleteDirectory(workspacePathFile);
        workspacePathFile.mkdir();
        rtl.getRtlPaths().foreach((Function1<String, Object> & Serializable & scala.Serializable)file -> {
            EfinixFlow$.$anonfun$apply$1(workspacePathFile, file);
            return BoxedUnit.UNIT;
        });
        Function1<String, Object> & Serializable & scala.Serializable isVhdl = (Function1<String, Object> & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean(EfinixFlow$.$anonfun$apply$2(file));
        String readRtl = ((TraversableOnce)rtl.getRtlPaths().map((Function1<String, String> & Serializable & scala.Serializable)file -> new StringBuilder(6).append("read_").append((Object)(BoxesRunTime.unboxToBoolean(isVhdl.apply(file)) ? "vhdl" : "verilog")).append(" ").append(Paths.get(file, new String[0]).getFileName()).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n");
        FileWriter tcl = new FileWriter(Paths.get(workspacePath, "test.xml").toFile());
        tcl.write(new StringBuilder(987).append("\n<efx:project xmlns:efx=\"http://www.efinixinc.com/enf_proj\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" name=\"test\" description=\"\" last_change_date=\"Wed Feb 14 2024 02:46:20 PM\" location=\"").append(workspacePath).append("\" sw_version=\"2021.2.323.4.6\" last_run_state=\"pass\" last_run_tool=\"efx_pgm\" last_run_flow=\"bitstream\" config_result_in_sync=\"sync\" design_ood=\"sync\" place_ood=\"sync\" route_ood=\"sync\" xsi:schemaLocation=\"http://www.efinixinc.com/enf_proj enf_proj.xsd\">\n    <efx:device_info>\n        <efx:family name=\"").append(family).append("\" />\n        <efx:device name=\"").append(device).append("\" />\n        <efx:timing_model name=\"").append(timing).append("\" />\n    </efx:device_info>\n    <efx:design_info def_veri_version=\"verilog_2k\" def_vhdl_version=\"vhdl_2008\">\n        <efx:top_module name=\"\" />\n        <efx:design_file name=\"").append(rtl.getRtlPaths().mkString(" ")).append("\" version=\"default\" library=\"default\" />\n        <efx:top_vhdl_arch name=\"\" />\n    </efx:design_info>\n    <efx:constraint_info>\n        <efx:sdc_file name=\"test.sdc\" />\n        <efx:inter_file name=\"\" />\n    </efx:constraint_info>\n</efx:project>\n").toString());
        tcl.flush();
        tcl.close();
        FileWriter sdc = new FileWriter(Paths.get(workspacePath, "test.sdc").toFile());
        String arg$macro$1 = ((PhysicalNumber)targetPeriod.$times(BigDecimal$.MODULE$.double2bigDecimal(1.0E9))).toBigDecimal().bigDecimal().toPlainString();
        sdc.write(new StringOps("create_clock -period %s clk").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$1})));
        sdc.flush();
        sdc.close();
        FileWriter sh = new FileWriter(Paths.get(workspacePath, "test.sh").toFile());
        sh.write(new StringBuilder(39).append("source ").append(efinixPath).append("/setup.sh && efx_run.py test.xml").toString());
        sh.flush();
        sh.close();
        DoCmd$.MODULE$.doCmd("bash test.sh", workspacePath);
        BufferedSource log = Source$.MODULE$.fromFile(Paths.get(workspacePath, "outflow/test.log").toFile(), Codec$.MODULE$.fallbackSystemCodec());
        String report = log.getLines().mkString("\n");
        return new Report(report){
            private final String report$1;

            public String toString() {
                return Report.toString$(this);
            }

            public double getFMax() {
                Regex.Match[] matches = (Regex.Match[])new StringOps(Predef$.MODULE$.augmentString("Maximum possible analyzed clocks frequency\\n[^\\n]*[\\n][ ]*clk[ ]*([+-]?[0-9]*[.]?[0-9]+)[ ]*([+-]?[0-9]*[.]?[0-9]+)")).r().findAllMatchIn(this.report$1).toArray(ClassTag$.MODULE$.apply(Regex.Match.class));
                package$.MODULE$.assert(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])matches)).size() == 1);
                return new StringOps(Predef$.MODULE$.augmentString(matches[0].group(2))).toDouble() * 1000000.0;
            }

            public String getArea() {
                String luts = ((Regex.MatchData)new StringOps(Predef$.MODULE$.augmentString("EFX_LUT4        : \t([0-9]+)")).r().findAllMatchIn(this.report$1).next()).group(1);
                String ff = ((Regex.MatchData)new StringOps(Predef$.MODULE$.augmentString("EFX_FF          : \t([0-9]+)")).r().findAllMatchIn(this.report$1).next()).group(1);
                return new StringBuilder(10).append("LUT ").append(luts).append("   FF ").append(ff).toString();
            }
            {
                this.report$1 = report$1;
                Report.$init$(this);
            }
        };
    }

    public HertzNumber apply$default$7() {
        return null;
    }

    public static final /* synthetic */ void $anonfun$apply$1(File workspacePathFile$1, String file) {
        FileUtils.copyFileToDirectory(new File(file), workspacePathFile$1);
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(String file) {
        return file.endsWith(".vhd") || file.endsWith(".vhdl");
    }

    private EfinixFlow$() {
        MODULE$ = this;
    }
}

