/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.eda.altera;

import java.io.Serializable;
import scala.MatchError;
import scala.Option;
import scala.Tuple3;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import spinal.core.ClockDomainTag;
import spinal.core.Data;
import spinal.core.SpinalError$;
import spinal.lib.bus.amba3.apb.Apb3;
import spinal.lib.eda.altera.QSysifyInterfaceEmiter;

@ScalaSignature(bytes="\u0006\u0001I2Aa\u0001\u0003\u0001\u001b!)\u0001\u0004\u0001C\u00013!)1\u0004\u0001C!9\tQ\u0011\t\u001d2F[&$H/\u001a:\u000b\u0005\u00151\u0011AB1mi\u0016\u0014\u0018M\u0003\u0002\b\u0011\u0005\u0019Q\rZ1\u000b\u0005%Q\u0011a\u00017jE*\t1\"\u0001\u0004ta&t\u0017\r\\\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0003\n\u0005]!!AF)TsNLg-_%oi\u0016\u0014h-Y2f\u000b6LG/\u001a:\u0002\rqJg.\u001b;?)\u0005Q\u0002CA\u000b\u0001\u0003\u0011)W.\u001b;\u0015\u0007u\u0001\u0003\u0006\u0005\u0002\u0010=%\u0011q\u0004\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015\t#\u00011\u0001#\u0003\u0005I\u0007CA\u0012'\u001b\u0005!#BA\u0013\u000b\u0003\u0011\u0019wN]3\n\u0005\u001d\"#\u0001\u0002#bi\u0006DQ!\u000b\u0002A\u0002)\nqAY;jY\u0012,'\u000f\u0005\u0002,a5\tAF\u0003\u0002.]\u00059Q.\u001e;bE2,'BA\u0018\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003c1\u0012Qb\u0015;sS:<')^5mI\u0016\u0014\b")
public class ApbEmitter
implements QSysifyInterfaceEmiter {
    @Override
    public boolean emit(Data i, StringBuilder builder) {
        Data data = i;
        if (data instanceof Apb3) {
            Tuple3<String, String, String> tuple3;
            Apb3 apb3 = (Apb3)data;
            boolean isMaster = apb3.PADDR().isOutput();
            Tuple3<String, String, String> tuple32 = tuple3 = isMaster ? new Tuple3<String, String, String>("Output", "Input", "start") : new Tuple3<String, String, String>("Input", "Output", "end");
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            String masterPinDir = tuple3._1();
            String slavePinDir = tuple3._2();
            String startEnd = tuple3._3();
            Tuple3<String, String, String> tuple33 = new Tuple3<String, String, String>(masterPinDir, slavePinDir, startEnd);
            String masterPinDir2 = tuple33._1();
            String slavePinDir2 = tuple33._2();
            String startEnd2 = tuple33._3();
            String name = apb3.getName();
            Option<ClockDomainTag> clockDomainTag = apb3.getTag(ClockDomainTag.class);
            if (clockDomainTag.isEmpty()) {
                throw SpinalError$.MODULE$.apply(new java.lang.StringBuilder(136).append("Clock domain of ").append(i).append(" is not defined, You shoud apply the ClockDomainTag to the inferface\nyourBus.addTag(ClockDomainTag(ClockDomain.current))").toString());
            }
            String clockName = clockDomainTag.get().clockDomain().clock().getName();
            String resetName = clockDomainTag.get().clockDomain().reset().getName();
            builder.$plus$plus$eq(new java.lang.StringBuilder(547).append("\n#\n# connection point ").append(name).append("\n#\nadd_interface ").append(name).append(" apb ").append(startEnd2).append("\nset_interface_property ").append(name).append(" ENABLED true\nset_interface_property ").append(name).append(" EXPORT_OF \"\"\nset_interface_property ").append(name).append(" PORT_NAME_MAP \"\"\nset_interface_property ").append(name).append(" CMSIS_SVD_VARIABLES \"\"\nset_interface_property ").append(name).append(" SVD_ADDRESS_GROUP \"\"\n\nset_interface_property ").append(name).append(" associatedClock ").append(clockName).append("\nset_interface_property ").append(name).append(" associatedReset ").append(resetName).append("\n\nadd_interface_port ").append(name).append(" ").append(apb3.PADDR().getName()).append(" paddr ").append(masterPinDir2).append(" ").append(apb3.config().addressWidth()).append("\nadd_interface_port ").append(name).append(" ").append(apb3.PSEL().getName()).append(" psel ").append(masterPinDir2).append(" ").append(apb3.config().selWidth()).append("\nadd_interface_port ").append(name).append(" ").append(apb3.PENABLE().getName()).append(" penable ").append(masterPinDir2).append(" 1\nadd_interface_port ").append(name).append(" ").append(apb3.PWRITE().getName()).append(" pwrite ").append(masterPinDir2).append(" 1\nadd_interface_port ").append(name).append(" ").append(apb3.PWDATA().getName()).append(" pwdata ").append(masterPinDir2).append(" ").append(apb3.config().dataWidth()).append("\nadd_interface_port ").append(name).append(" ").append(apb3.PRDATA().getName()).append(" prdata ").append(slavePinDir2).append(" ").append(apb3.config().dataWidth()).append("\nadd_interface_port ").append(name).append(" ").append(apb3.PREADY().getName()).append(" pready ").append(slavePinDir2).append(" 1\n").toString());
            Serializable serializable = apb3.config().useSlaveError() ? builder.$plus$plus$eq(new java.lang.StringBuilder(32).append("add_interface_port ").append(name).append(" ").append(apb3.PSLVERROR().getName()).append(" pslverr ").append(slavePinDir2).append("  1").toString()) : BoxedUnit.UNIT;
            return true;
        }
        return false;
    }
}

