/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.bus.misc;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import spinal.core.Bits;
import spinal.core.Bool;
import spinal.core.log2Up$;
import spinal.core.widthOf$;
import spinal.lib.bus.misc.AddressMapping;
import spinal.lib.bus.misc.InterleavedMapping;
import spinal.lib.bus.misc.OrMapping;
import spinal.lib.bus.misc.SizeMapping;
import spinal.lib.bus.misc.SizeMapping$;
import spinal.lib.logic.Masked;
import spinal.lib.logic.Symplify$;

public final class AddressMapping$ {
    public static AddressMapping$ MODULE$;

    static {
        new AddressMapping$();
    }

    public boolean verifyOverlapping(Seq<AddressMapping> mapping) {
        Seq<SizeMapping> sizeMapped = ((TraversableLike)mapping.filter((Function1<AddressMapping, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(AddressMapping$.$anonfun$verifyOverlapping$1(x$1)))).map((Function1<AddressMapping, SizeMapping> & Serializable & scala.Serializable)x$2 -> (SizeMapping)x$2, Seq$.MODULE$.canBuildFrom());
        return SizeMapping$.MODULE$.verifyOverlapping(sizeMapped);
    }

    public Bool decode(Bits address, AddressMapping trueMapping) {
        ArrayBuffer<Masked> trueTerms = this.terms(trueMapping, widthOf$.MODULE$.apply(address));
        return Symplify$.MODULE$.apply(address.asBits(), trueTerms);
    }

    public Bool decode(Bits address, AddressMapping trueMapping, AddressMapping falseMapping) {
        ArrayBuffer<Masked> trueTerms = this.terms(trueMapping, widthOf$.MODULE$.apply(address));
        ArrayBuffer<Masked> falseTerms = this.terms(falseMapping, widthOf$.MODULE$.apply(address));
        return Symplify$.MODULE$.apply(address.asBits(), trueTerms, falseTerms);
    }

    public Bool decode(Bits address, Seq<AddressMapping> trueMapping, Seq<AddressMapping> falseMapping) {
        return this.decode(address, new OrMapping(trueMapping), new OrMapping(falseMapping));
    }

    public ArrayBuffer<Masked> terms(AddressMapping mapping, int width) {
        ArrayBuffer ret = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        BigInt widthMask = package$.MODULE$.BigInt().apply(1).$less$less(width).$minus(BigInt$.MODULE$.int2bigInt(1));
        this.rec$1(mapping, new Masked(BigInt$.MODULE$.int2bigInt(0), BigInt$.MODULE$.int2bigInt(0)), ret, widthMask);
        return ret;
    }

    public static final /* synthetic */ boolean $anonfun$verifyOverlapping$1(AddressMapping x$1) {
        return x$1 instanceof SizeMapping;
    }

    private final void rec$1(AddressMapping e, Masked mask, ArrayBuffer ret$1, BigInt widthMask$1) {
        block8: {
            AddressMapping addressMapping;
            while (true) {
                if ((addressMapping = e) instanceof OrMapping) {
                    OrMapping orMapping = (OrMapping)addressMapping;
                    Seq<AddressMapping> conds = orMapping.conds();
                    conds.foreach((Function1<AddressMapping, Object> & Serializable & scala.Serializable)cond -> {
                        this.rec$1(cond, mask, ret$1, widthMask$1);
                        return BoxedUnit.UNIT;
                    });
                    break block8;
                }
                if (!(addressMapping instanceof InterleavedMapping)) break;
                InterleavedMapping interleavedMapping = (InterleavedMapping)addressMapping;
                AddressMapping mapping = interleavedMapping.mapping();
                int blockSize = interleavedMapping.blockSize();
                int ratio = interleavedMapping.ratio();
                int sel = interleavedMapping.sel();
                mask = mask.fuse(new Masked(BigInt$.MODULE$.int2bigInt(sel << log2Up$.MODULE$.apply(blockSize)), BigInt$.MODULE$.int2bigInt(ratio - 1 << log2Up$.MODULE$.apply(blockSize))));
                e = mapping;
            }
            if (addressMapping instanceof SizeMapping) {
                SizeMapping sizeMapping = (SizeMapping)addressMapping;
                BigInt ptr = sizeMapping.base();
                BigInt end = sizeMapping.base().$plus(sizeMapping.size());
                while (ptr.$less(end)) {
                    BigInt step;
                    BigInt bigInt = step = BoxesRunTime.equalsNumObject(ptr, BoxesRunTime.boxToInteger(0)) ? sizeMapping.size() : package$.MODULE$.BigInt().apply(1).$less$less(ptr.lowestSetBit());
                    if (ptr.$plus(step).$greater(end)) {
                        while (ptr.$less(end)) {
                            Object object;
                            BigInt step2;
                            BigInt bigInt2 = step2 = BoxesRunTime.equalsNumObject(end, BoxesRunTime.boxToInteger(0)) ? sizeMapping.size() : package$.MODULE$.BigInt().apply(1).$less$less(end.lowestSetBit());
                            if (ptr.$less$eq(end.$minus(step2))) {
                                end = end.$minus(step2);
                                object = ret$1.$plus$eq(mask.fuse(new Masked(end, step2.$minus(BigInt$.MODULE$.int2bigInt(1)).unary_$tilde().$amp(widthMask$1))));
                                continue;
                            }
                            object = BoxedUnit.UNIT;
                        }
                        continue;
                    }
                    ret$1.$plus$eq(mask.fuse(new Masked(ptr, step.$minus(BigInt$.MODULE$.int2bigInt(1)).unary_$tilde().$amp(widthMask$1))));
                    ptr = ptr.$plus(step);
                }
            } else {
                throw new MatchError(addressMapping);
            }
        }
    }

    private AddressMapping$() {
        MODULE$ = this;
    }
}

