/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.bus.amba4.axi.sim;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.runtime.java8.JFunction0$mcZ$sp;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.util.Random$;
import spinal.core.ClockDomain;
import spinal.core.log2Up$;
import spinal.core.sim.package;
import spinal.core.sim.package$;
import spinal.idslplugin.Location;
import spinal.lib.DataCarrier$;
import spinal.lib.Stream;
import spinal.lib.bus.amba4.axi.Axi4;
import spinal.lib.bus.amba4.axi.Axi4Ar;
import spinal.lib.bus.amba4.axi.Axi4Aw;
import spinal.lib.bus.amba4.axi.Axi4Ax;
import spinal.lib.bus.amba4.axi.Axi4B;
import spinal.lib.bus.amba4.axi.Axi4R;
import spinal.lib.bus.amba4.axi.Axi4W;
import spinal.lib.bus.amba4.axi.sim.AxiJob;
import spinal.lib.bus.amba4.axi.sim.AxiMemorySim$;
import spinal.lib.bus.amba4.axi.sim.AxiMemorySimConfig;
import spinal.lib.bus.amba4.axi.sim.SparseMemory;
import spinal.sim.SimManager;
import spinal.sim.SimThread;

@ScalaSignature(bytes="\u0006\u0001\tmf\u0001\u0002\u001d:\u0001\u001aC\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\ta\u0015\u0005\t1\u0002\u0011\t\u0012)A\u0005)\"A\u0011\f\u0001BK\u0002\u0013\u0005!\f\u0003\u0005b\u0001\tE\t\u0015!\u0003\\\u0011!\u0011\u0007A!f\u0001\n\u0003\u0019\u0007\u0002\u00035\u0001\u0005#\u0005\u000b\u0011\u00023\t\u000b%\u0004A\u0011\u00016\t\u000f=\u0004!\u0019!C\u0001a\"1A\u000f\u0001Q\u0001\nEDq!\u001e\u0001C\u0002\u0013\u0005a\u000fC\u0004\u0002\u0006\u0001\u0001\u000b\u0011B<\t\u0011\u0005\u001d\u0001A1A\u0005\u0002YDq!!\u0003\u0001A\u0003%q\u000fC\u0005\u0002\f\u0001\u0011\r\u0011\"\u0001\u0002\u000e!A\u00111\u0004\u0001!\u0002\u0013\ty\u0001C\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0001\u0002 !A\u0011q\u0005\u0001!\u0002\u0013\t\t\u0003C\u0005\u0002*\u0001\u0011\r\u0011\"\u0001\u0002 !A\u00111\u0006\u0001!\u0002\u0013\t\t\u0003C\u0004\u0002.\u0001!\t!a\f\t\u000f\u00055\u0002\u0001\"\u0001\u0002L!9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0003bBA1\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003G\u0002A\u0011AA-\u0011\u001d\t)\u0007\u0001C\u0001\u0003OBq!a\u001b\u0001\t\u0003\ti\u0007C\u0004\u0002r\u0001!\t!a\u001d\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBAB\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0003S\u0003A\u0011AAV\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007Dq!a6\u0001\t\u0003\tI\u000eC\u0004\u0002`\u0002!\t!!9\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"9!1\u0001\u0001\u0005\u0002\t\u0015\u0001\"\u0003B\u0007\u0001\u0005\u0005I\u0011\u0001B\b\u0011%\u00119\u0002AI\u0001\n\u0003\u0011I\u0002C\u0005\u00030\u0001\t\n\u0011\"\u0001\u00032!I!Q\u0007\u0001\u0012\u0002\u0013\u0005!q\u0007\u0005\n\u0005w\u0001\u0011\u0011!C!\u0005{A\u0011Ba\u0014\u0001\u0003\u0003%\t!a\b\t\u0013\tE\u0003!!A\u0005\u0002\tM\u0003\"\u0003B0\u0001\u0005\u0005I\u0011\tB1\u0011%\u0011Y\u0007AA\u0001\n\u0003\u0011i\u0007C\u0005\u0003r\u0001\t\t\u0011\"\u0011\u0003t!I!Q\u000f\u0001\u0002\u0002\u0013\u0005#q\u000f\u0005\n\u0005s\u0002\u0011\u0011!C!\u0005w:\u0011Ba :\u0003\u0003E\tA!!\u0007\u0011aJ\u0014\u0011!E\u0001\u0005\u0007Ca!\u001b\u001a\u0005\u0002\tE\u0005\"\u0003B;e\u0005\u0005IQ\tB<\u0011%\u0011\u0019JMA\u0001\n\u0003\u0013)\nC\u0005\u0003\u001eJ\n\t\u0011\"!\u0003 \"I!\u0011\u0017\u001a\u0002\u0002\u0013%!1\u0017\u0002\r\u0003bLW*Z7pef\u001c\u0016.\u001c\u0006\u0003um\n1a]5n\u0015\taT(A\u0002bq&T!AP \u0002\u000b\u0005l'-\u0019\u001b\u000b\u0005\u0001\u000b\u0015a\u00012vg*\u0011!iQ\u0001\u0004Y&\u0014'\"\u0001#\u0002\rM\u0004\u0018N\\1m\u0007\u0001\u0019B\u0001A$N!B\u0011\u0001jS\u0007\u0002\u0013*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\n1\u0011I\\=SK\u001a\u0004\"\u0001\u0013(\n\u0005=K%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0011FK!AU%\u0003\u0019M+'/[1mSj\f'\r\\3\u0016\u0003Q\u0003\"!\u0016,\u000e\u0003mJ!aV\u001e\u0003\t\u0005C\u0018\u000eN\u0001\u0005CbL\u0007%A\u0006dY>\u001c7\u000eR8nC&tW#A.\u0011\u0005q{V\"A/\u000b\u0005y\u001b\u0015\u0001B2pe\u0016L!\u0001Y/\u0003\u0017\rcwnY6E_6\f\u0017N\\\u0001\rG2|7m\u001b#p[\u0006Lg\u000eI\u0001\u0007G>tg-[4\u0016\u0003\u0011\u0004\"!\u001a4\u000e\u0003eJ!aZ\u001d\u0003%\u0005C\u0018.T3n_JL8+[7D_:4\u0017nZ\u0001\bG>tg-[4!\u0003\u0019a\u0014N\\5u}Q!1\u000e\\7o!\t)\u0007\u0001C\u0003=\u000f\u0001\u0007A\u000bC\u0003Z\u000f\u0001\u00071\fC\u0003c\u000f\u0001\u0007A-\u0001\u0004nK6|'/_\u000b\u0002cB\u0011QM]\u0005\u0003gf\u0012Ab\u00159beN,W*Z7pef\fq!\\3n_JL\b%A\u0007qK:$\u0017N\\4`e\u0016\fGm]\u000b\u0002oB\u0019\u00010`@\u000e\u0003eT!A_>\u0002\u000f5,H/\u00192mK*\u0011A0S\u0001\u000bG>dG.Z2uS>t\u0017B\u0001@z\u0005\u0015\tV/Z;f!\r)\u0017\u0011A\u0005\u0004\u0003\u0007I$AB!yS*{'-\u0001\bqK:$\u0017N\\4`e\u0016\fGm\u001d\u0011\u0002\u001dA,g\u000eZ5oO~;(/\u001b;fg\u0006y\u0001/\u001a8eS:<wl\u001e:ji\u0016\u001c\b%A\u0004uQJ,\u0017\rZ:\u0016\u0005\u0005=\u0001\u0003\u0002=~\u0003#\u0001B!a\u0005\u0002\u00185\u0011\u0011Q\u0003\u0006\u0003u\rKA!!\u0007\u0002\u0016\tI1+[7UQJ,\u0017\rZ\u0001\ti\"\u0014X-\u00193tA\u0005a!-^:X_J$w+\u001b3uQV\u0011\u0011\u0011\u0005\t\u0004\u0011\u0006\r\u0012bAA\u0013\u0013\n\u0019\u0011J\u001c;\u0002\u001b\t,8oV8sI^KG\r\u001e5!\u00031i\u0017\r\u001f\"veN$8+\u001b>f\u00035i\u0017\r\u001f\"veN$8+\u001b>fA\u0005Ia.Z<Bq&TuN\u0019\u000b\f\u007f\u0006E\u00121HA \u0003\u0007\n9\u0005C\u0004\u00024Q\u0001\r!!\u000e\u0002\u000f\u0005$GM]3tgB\u0019\u0001*a\u000e\n\u0007\u0005e\u0012J\u0001\u0003M_:<\u0007bBA\u001f)\u0001\u0007\u0011\u0011E\u0001\fEV\u00148\u000f\u001e'f]\u001e$\b\u000eC\u0004\u0002BQ\u0001\r!!\t\u0002\u0013\t,(o\u001d;TSj,\u0007bBA#)\u0001\u0007\u0011\u0011E\u0001\nEV\u00148\u000f\u001e+za\u0016Dq!!\u0013\u0015\u0001\u0004\t)$\u0001\u0002jIR\u0019q0!\u0014\t\u000f\u0005=S\u00031\u0001\u0002R\u0005\u0011\u0011\r\u001f\t\u0004+\u0006M\u0013bAA+w\t1\u0011\t_55\u0003b\fQa\u001d;beR$\"!a\u0017\u0011\u0007!\u000bi&C\u0002\u0002`%\u0013A!\u00168ji\u0006!1\u000f^8q\u0003\u0015\u0011Xm]3u\u0003\u00199W\r\u001e'f]R!\u0011\u0011EA5\u0011\u001d\ty%\u0007a\u0001\u0003#\nqaZ3u'&TX\r\u0006\u0003\u0002\"\u0005=\u0004bBA(5\u0001\u0007\u0011\u0011K\u0001\u0010O\u0016$8+\u001b>f\u0003:$7\t[3dWR!\u0011\u0011EA;\u0011\u001d\tye\u0007a\u0001\u0003#\nQaZ3u\u0013\u0012$B!!\u000e\u0002|!9\u0011q\n\u000fA\u0002\u0005E\u0013\u0001C4fi\n+(o\u001d;\u0015\t\u0005\u0005\u0012\u0011\u0011\u0005\b\u0003\u001fj\u0002\u0019AA)\u0003\u001d9W\r^*ue\n$B!a\"\u0002 B!\u0011\u0011RAM\u001d\u0011\tY)!&\u000f\t\u00055\u00151S\u0007\u0003\u0003\u001fS1!!%F\u0003\u0019a$o\\8u}%\t!*C\u0002\u0002\u0018&\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001c\u0006u%A\u0002\"jO&sGOC\u0002\u0002\u0018&Cq!!)\u001f\u0001\u0004\t\u0019+A\u0001x!\r)\u0016QU\u0005\u0004\u0003O[$!B!ySR:\u0016aB:fi2\u000b7\u000f\u001e\u000b\u0007\u00037\ni+a.\t\u000f\u0005=v\u00041\u0001\u00022\u0006\t!\u000fE\u0002V\u0003gK1!!.<\u0005\u0015\t\u00050\u001b\u001bS\u0011\u001d\tIl\ba\u0001\u0003w\u000bA\u0001\\1tiB\u0019\u0001*!0\n\u0007\u0005}\u0016JA\u0004C_>dW-\u00198\u0002\u0011!\fg\u000e\u001a7f\u0003J$B!a\u0017\u0002F\"9\u0011q\u0019\u0011A\u0002\u0005%\u0017AA1s!\u0019\tY-!4\u0002R6\t\u0011)C\u0002\u0002P\u0006\u0013aa\u0015;sK\u0006l\u0007cA+\u0002T&\u0019\u0011Q[\u001e\u0003\r\u0005C\u0018\u000eN!s\u0003\u001dA\u0017M\u001c3mKJ#B!a\u0017\u0002\\\"9\u0011qV\u0011A\u0002\u0005u\u0007CBAf\u0003\u001b\f\t,\u0001\u0005iC:$G.Z!x)\u0011\tY&a9\t\u000f\u0005\u0015(\u00051\u0001\u0002h\u0006\u0011\u0011m\u001e\t\u0007\u0003\u0017\fi-!;\u0011\u0007U\u000bY/C\u0002\u0002nn\u0012a!\u0011=ji\u0005;\u0018a\u00025b]\u0012dWm\u0016\u000b\u0007\u00037\n\u00190a>\t\u000f\u0005\u00056\u00051\u0001\u0002vB1\u00111ZAg\u0003GCq!!?$\u0001\u0004\tY0A\u0001c!\u0019\tY-!4\u0002~B\u0019Q+a@\n\u0007\t\u00051HA\u0003Bq&$$)\u0001\u0007iC:$G.Z!x\u0003:$w\u000b\u0006\u0005\u0002\\\t\u001d!\u0011\u0002B\u0006\u0011\u001d\t\t\u000b\na\u0001\u0003kDq!!:%\u0001\u0004\t9\u000fC\u0004\u0002z\u0012\u0002\r!a?\u0002\t\r|\u0007/\u001f\u000b\bW\nE!1\u0003B\u000b\u0011\u001daT\u0005%AA\u0002QCq!W\u0013\u0011\u0002\u0003\u00071\fC\u0004cKA\u0005\t\u0019\u00013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u0004\u0016\u0004)\nu1F\u0001B\u0010!\u0011\u0011\tCa\u000b\u000e\u0005\t\r\"\u0002\u0002B\u0013\u0005O\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t%\u0012*\u0001\u0006b]:|G/\u0019;j_:LAA!\f\u0003$\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0007\u0016\u00047\nu\u0011AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005sQ3\u0001\u001aB\u000f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!q\b\t\u0005\u0005\u0003\u0012Y%\u0004\u0002\u0003D)!!Q\tB$\u0003\u0011a\u0017M\\4\u000b\u0005\t%\u0013\u0001\u00026bm\u0006LAA!\u0014\u0003D\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003V\tm\u0003c\u0001%\u0003X%\u0019!\u0011L%\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003^-\n\t\u00111\u0001\u0002\"\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0019\u0011\r\t\u0015$q\rB+\u001b\u0005Y\u0018b\u0001B5w\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tYLa\u001c\t\u0013\tuS&!AA\u0002\tU\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u0005\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t}\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002<\nu\u0004\"\u0003B/a\u0005\u0005\t\u0019\u0001B+\u00031\t\u00050['f[>\u0014\u0018pU5n!\t)'g\u0005\u00033\u0005\u000b\u0003\u0006\u0003\u0003BD\u0005\u001b#6\fZ6\u000e\u0005\t%%b\u0001BF\u0013\u00069!/\u001e8uS6,\u0017\u0002\u0002BH\u0005\u0013\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\u0011\t)A\u0003baBd\u0017\u0010F\u0004l\u0005/\u0013IJa'\t\u000bq*\u0004\u0019\u0001+\t\u000be+\u0004\u0019A.\t\u000b\t,\u0004\u0019\u00013\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0015BW!\u0015A%1\u0015BT\u0013\r\u0011)+\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r!\u0013I\u000bV.e\u0013\r\u0011Y+\u0013\u0002\u0007)V\u0004H.Z\u001a\t\u0011\t=f'!AA\u0002-\f1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tU\u0006\u0003\u0002B!\u0005oKAA!/\u0003D\t1qJ\u00196fGR\u0004")
public class AxiMemorySim
implements Product,
scala.Serializable {
    private final Axi4 axi;
    private final ClockDomain clockDomain;
    private final AxiMemorySimConfig config;
    private final SparseMemory memory;
    private final Queue<AxiJob> pending_reads;
    private final Queue<AxiJob> pending_writes;
    private final Queue<SimThread> threads;
    private final int busWordWidth;
    private final int maxBurstSize;

    public static Option<Tuple3<Axi4, ClockDomain, AxiMemorySimConfig>> unapply(AxiMemorySim axiMemorySim) {
        return AxiMemorySim$.MODULE$.unapply(axiMemorySim);
    }

    public static AxiMemorySim apply(Axi4 axi4, ClockDomain clockDomain, AxiMemorySimConfig axiMemorySimConfig) {
        return AxiMemorySim$.MODULE$.apply(axi4, clockDomain, axiMemorySimConfig);
    }

    public static Function1<Tuple3<Axi4, ClockDomain, AxiMemorySimConfig>, AxiMemorySim> tupled() {
        return AxiMemorySim$.MODULE$.tupled();
    }

    public static Function1<Axi4, Function1<ClockDomain, Function1<AxiMemorySimConfig, AxiMemorySim>>> curried() {
        return AxiMemorySim$.MODULE$.curried();
    }

    public Axi4 axi() {
        return this.axi;
    }

    public ClockDomain clockDomain() {
        return this.clockDomain;
    }

    public AxiMemorySimConfig config() {
        return this.config;
    }

    public SparseMemory memory() {
        return this.memory;
    }

    public Queue<AxiJob> pending_reads() {
        return this.pending_reads;
    }

    public Queue<AxiJob> pending_writes() {
        return this.pending_writes;
    }

    public Queue<SimThread> threads() {
        return this.threads;
    }

    public int busWordWidth() {
        return this.busWordWidth;
    }

    public int maxBurstSize() {
        return this.maxBurstSize;
    }

    public AxiJob newAxiJob(long address, int burstLength, int burstSize, int burstType, long id) {
        return new AxiJob(address, burstLength, burstSize, burstType, id);
    }

    public AxiJob newAxiJob(Axi4Ax ax) {
        package.SimBitVectorPimper qual$1 = package$.MODULE$.SimBitVectorPimper(ax.addr());
        SimManager x$1 = qual$1.toLong$default$1();
        return this.newAxiJob(qual$1.toLong(x$1), this.getLen(ax), this.getSizeAndCheck(ax), this.getBurst(ax), this.getId(ax));
    }

    public void start() {
        this.threads().enqueue(Predef$.MODULE$.wrapRefArray((Object[])new SimThread[]{package$.MODULE$.fork((JFunction0$mcV$sp & scala.Serializable)() -> this.handleAr(this.axi().ar()))}));
        this.threads().enqueue(Predef$.MODULE$.wrapRefArray((Object[])new SimThread[]{package$.MODULE$.fork((JFunction0$mcV$sp & scala.Serializable)() -> this.handleR(this.axi().r()))}));
        if (this.config().useAlteraBehavior()) {
            this.threads().enqueue(Predef$.MODULE$.wrapRefArray((Object[])new SimThread[]{package$.MODULE$.fork((JFunction0$mcV$sp & scala.Serializable)() -> this.handleAwAndW(this.axi().w(), this.axi().aw(), this.axi().b()))}));
            return;
        }
        this.threads().enqueue(Predef$.MODULE$.wrapRefArray((Object[])new SimThread[]{package$.MODULE$.fork((JFunction0$mcV$sp & scala.Serializable)() -> this.handleAw(this.axi().aw()))}));
        this.threads().enqueue(Predef$.MODULE$.wrapRefArray((Object[])new SimThread[]{package$.MODULE$.fork((JFunction0$mcV$sp & scala.Serializable)() -> this.handleW(this.axi().w(), this.axi().b()))}));
    }

    public void stop() {
        this.threads().map((Function1<SimThread, Object> & Serializable & scala.Serializable)f -> {
            f.terminate();
            return BoxedUnit.UNIT;
        }, Queue$.MODULE$.canBuildFrom());
    }

    public void reset() {
        this.stop();
        this.pending_reads().clear();
        this.pending_writes().clear();
        this.start();
    }

    public int getLen(Axi4Ax ax) {
        if (ax.config().useLen()) {
            return package$.MODULE$.SimBitVectorPimper(ax.len()).toInt();
        }
        return 0;
    }

    public int getSize(Axi4Ax ax) {
        if (ax.config().useSize()) {
            return package$.MODULE$.SimBitVectorPimper(ax.size()).toInt();
        }
        return this.maxBurstSize();
    }

    public int getSizeAndCheck(Axi4Ax ax) {
        int burstSize = this.getSize(ax);
        spinal.core.package$.MODULE$.assert(burstSize <= this.maxBurstSize());
        return burstSize;
    }

    public long getId(Axi4Ax ax) {
        if (ax.config().useId()) {
            package.SimBitVectorPimper qual$1 = package$.MODULE$.SimBitVectorPimper(ax.id());
            SimManager x$1 = qual$1.toLong$default$1();
            return qual$1.toLong(x$1);
        }
        return 0L;
    }

    public int getBurst(Axi4Ax ax) {
        if (ax.config().useBurst()) {
            return package$.MODULE$.SimBitVectorPimper(ax.burst()).toInt();
        }
        return this.config().defaultBurstType();
    }

    public BigInt getStrb(Axi4W w) {
        if (w.config().useStrb()) {
            return package$.MODULE$.SimBitVectorPimper(w.strb()).toBigInt();
        }
        return null;
    }

    public void setLast(Axi4R r, boolean last) {
        if (r.config().useLast()) {
            package$.MODULE$.SimBoolPimper(r.last()).$hash$eq(last);
            return;
        }
    }

    public void handleAr(Stream<Axi4Ar> ar) {
        Predef$.MODULE$.println("Handling AXI4 Master read cmds...");
        package$.MODULE$.SimBoolPimper(ar.ready()).$hash$eq(false);
        while (true) {
            package$.MODULE$.SimBoolPimper(ar.ready()).$hash$eq(true);
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((JFunction0$mcZ$sp & scala.Serializable)() -> package$.MODULE$.SimBoolPimper(ar.valid()).toBoolean());
            package$.MODULE$.SimBoolPimper(ar.ready()).$hash$eq(false);
            this.pending_reads().$plus$eq((Object)this.newAxiJob(ar.payload()));
            if (this.pending_reads().length() < this.config().maxOutstandingReads()) continue;
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((JFunction0$mcZ$sp & scala.Serializable)() -> this.pending_reads().length() < this.config().maxOutstandingReads());
        }
    }

    public void handleR(Stream<Axi4R> r) {
        Predef$.MODULE$.println("Handling AXI4 Master read resp...");
        Random$ random = Random$.MODULE$;
        package$.MODULE$.SimBoolPimper(r.valid()).$hash$eq(false);
        this.setLast(r.payload(), false);
        while (true) {
            Serializable serializable;
            if (this.pending_reads().nonEmpty()) {
                AxiJob job = this.pending_reads().front();
                package$.MODULE$.SimBoolPimper(r.valid()).$hash$eq(true);
                for (int i = 0; i <= job.burstLength(); ++i) {
                    if (this.config().interruptProbability() > random.nextInt(100)) {
                        package$.MODULE$.SimBoolPimper(r.valid()).$hash$eq(false);
                        package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(random.nextInt(this.config().interruptMaxDelay() + 1));
                        package$.MODULE$.SimBoolPimper(r.valid()).$hash$eq(true);
                    }
                    if (i == job.burstLength()) {
                        this.setLast(r.payload(), true);
                    }
                    if (DataCarrier$.MODULE$.toImplicit(r).config().useId()) {
                        package$.MODULE$.SimBitVectorPimper(r.payload().id()).$hash$eq(job.id());
                    }
                    if (DataCarrier$.MODULE$.toImplicit(r).config().useResp()) {
                        package$.MODULE$.SimBitVectorPimper(r.payload().resp()).$hash$eq(0);
                    }
                    package$.MODULE$.SimBitVectorPimper(r.payload().data()).$hash$eq(this.memory().readBigInt(job.alignedBurstAddress(i, this.maxBurstSize()), this.busWordWidth()));
                    package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((JFunction0$mcZ$sp & scala.Serializable)() -> package$.MODULE$.SimBoolPimper(r.ready()).toBoolean());
                }
                package$.MODULE$.SimBoolPimper(r.valid()).$hash$eq(false);
                this.setLast(r.payload(), false);
                serializable = this.pending_reads().dequeue();
                continue;
            }
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(1);
            serializable = BoxedUnit.UNIT;
        }
    }

    public void handleAw(Stream<Axi4Aw> aw) {
        Predef$.MODULE$.println("Handling AXI4 Master write cmds...");
        package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(false);
        while (true) {
            package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(true);
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((JFunction0$mcZ$sp & scala.Serializable)() -> package$.MODULE$.SimBoolPimper(aw.valid()).toBoolean());
            package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(false);
            this.pending_writes().$plus$eq((Object)this.newAxiJob(aw.payload()));
            if (this.pending_writes().length() < this.config().maxOutstandingWrites()) continue;
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((JFunction0$mcZ$sp & scala.Serializable)() -> this.pending_writes().length() < this.config().maxOutstandingWrites());
        }
    }

    public void handleW(Stream<Axi4W> w, Stream<Axi4B> b) {
        Predef$.MODULE$.println("Handling AXI4 Master write...");
        package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(false);
        package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(false);
        while (true) {
            Serializable serializable;
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(10);
            if (this.pending_writes().nonEmpty()) {
                ObjectRef<AxiJob> job = ObjectRef.create(this.pending_writes().front());
                int count = ((AxiJob)job.elem).burstLength();
                package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(true);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ((AxiJob)job.elem).burstLength()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
                    package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((JFunction0$mcZ$sp & scala.Serializable)() -> package$.MODULE$.SimBoolPimper(w.valid()).toBoolean());
                    this.memory().writeBigInt(((AxiJob)job$1.elem).alignedBurstAddress(i, this.maxBurstSize()), package$.MODULE$.SimBitVectorPimper(((Axi4W)w.payload()).data()).toBigInt(), this.busWordWidth(), this.getStrb((Axi4W)w.payload()));
                });
                package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(false);
                package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(this.config().writeResponseDelay());
                package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(true);
                if (DataCarrier$.MODULE$.toImplicit(b).config().useId()) {
                    package$.MODULE$.SimBitVectorPimper(b.payload().id()).$hash$eq(((AxiJob)job.elem).id());
                }
                if (DataCarrier$.MODULE$.toImplicit(b).config().useResp()) {
                    package$.MODULE$.SimBitVectorPimper(b.payload().resp()).$hash$eq(0);
                }
                package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((JFunction0$mcZ$sp & scala.Serializable)() -> package$.MODULE$.SimBoolPimper(b.ready()).toBoolean());
                package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(false);
                serializable = this.pending_writes().dequeue();
                continue;
            }
            serializable = BoxedUnit.UNIT;
        }
    }

    public void handleAwAndW(Stream<Axi4W> w, Stream<Axi4Aw> aw, Stream<Axi4B> b) {
        Predef$.MODULE$.println("Handling AXI4 Master write cmds and write (Altera/Intel behavior)...");
        Random$ random = Random$.MODULE$;
        package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(false);
        package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(false);
        package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(false);
        while (true) {
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((JFunction0$mcZ$sp & scala.Serializable)() -> package$.MODULE$.SimBoolPimper(aw.valid()).toBoolean() && package$.MODULE$.SimBoolPimper(w.valid()).toBoolean());
            package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(true);
            spinal.core.package$.MODULE$.assert(package$.MODULE$.SimBitVectorPimper(((Axi4Ax)aw.payload()).len()).toBigInt().$plus(package$.MODULE$.SimBitVectorPimper(((Axi4Ax)aw.payload()).addr()).toBigInt().$amp(BigInt$.MODULE$.int2bigInt(4095))).$less$eq(BigInt$.MODULE$.int2bigInt(4095)), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> {
                package.SimBitVectorPimper qual$1 = package$.MODULE$.SimBitVectorPimper(((Axi4Ax)aw.payload()).len());
                SimManager x$1 = qual$1.toLong$default$1();
                return new StringBuilder(47).append("Write request crossing 4k boundary (addr=").append(package$.MODULE$.SimBitVectorPimper(((Axi4Ax)aw.payload()).addr()).toBigInt().toString(16)).append(", len=").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(qual$1.toLong(x$1)))).toString();
            }, new Location("AxiMemorySim", 526, 13));
            AxiJob job = this.newAxiJob(aw.payload());
            int i = 0;
            while (i <= package$.MODULE$.SimBitVectorPimper(((Axi4Ax)aw.payload()).len()).toInt()) {
                if (this.config().interruptProbability() > random.nextInt(100)) {
                    package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(false);
                    package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(random.nextInt(this.config().interruptMaxDelay() + 1));
                    package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(true);
                    continue;
                }
                package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((JFunction0$mcZ$sp & scala.Serializable)() -> package$.MODULE$.SimBoolPimper(w.valid()).toBoolean());
                this.memory().writeBigInt(job.alignedBurstAddress(i, this.maxBurstSize()), package$.MODULE$.SimBitVectorPimper(w.payload().data()).toBigInt(), this.busWordWidth(), this.getStrb(w.payload()));
                ++i;
            }
            package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(true);
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(1);
            package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(false);
            package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(false);
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(this.config().writeResponseDelay());
            package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(true);
            if (DataCarrier$.MODULE$.toImplicit(b).config().useId()) {
                package$.MODULE$.SimBitVectorPimper(b.payload().id()).$hash$eq(job.id());
            }
            if (DataCarrier$.MODULE$.toImplicit(b).config().useResp()) {
                package$.MODULE$.SimBitVectorPimper(b.payload().resp()).$hash$eq(0);
            }
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((JFunction0$mcZ$sp & scala.Serializable)() -> package$.MODULE$.SimBoolPimper(b.ready()).toBoolean());
            package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(false);
        }
    }

    public AxiMemorySim copy(Axi4 axi, ClockDomain clockDomain, AxiMemorySimConfig config) {
        return new AxiMemorySim(axi, clockDomain, config);
    }

    public Axi4 copy$default$1() {
        return this.axi();
    }

    public ClockDomain copy$default$2() {
        return this.clockDomain();
    }

    public AxiMemorySimConfig copy$default$3() {
        return this.config();
    }

    @Override
    public String productPrefix() {
        return "AxiMemorySim";
    }

    @Override
    public int productArity() {
        return 3;
    }

    @Override
    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.axi();
            }
            case 1: {
                return this.clockDomain();
            }
            case 2: {
                return this.config();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator(this);
    }

    @Override
    public boolean canEqual(Object x$1) {
        return x$1 instanceof AxiMemorySim;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AxiMemorySim)) return false;
        boolean bl = true;
        if (!bl) return false;
        AxiMemorySim axiMemorySim = (AxiMemorySim)x$1;
        Axi4 axi4 = this.axi();
        Axi4 axi42 = axiMemorySim.axi();
        if (axi4 == null) {
            if (axi42 != null) {
                return false;
            }
        } else if (!((Object)axi4).equals(axi42)) return false;
        ClockDomain clockDomain = this.clockDomain();
        ClockDomain clockDomain2 = axiMemorySim.clockDomain();
        if (clockDomain == null) {
            if (clockDomain2 != null) {
                return false;
            }
        } else if (!((Object)clockDomain).equals(clockDomain2)) return false;
        AxiMemorySimConfig axiMemorySimConfig = this.config();
        AxiMemorySimConfig axiMemorySimConfig2 = axiMemorySim.config();
        if (axiMemorySimConfig == null) {
            if (axiMemorySimConfig2 != null) {
                return false;
            }
        } else if (!((Object)axiMemorySimConfig).equals(axiMemorySimConfig2)) return false;
        if (!axiMemorySim.canEqual(this)) return false;
        return true;
    }

    public AxiMemorySim(Axi4 axi, ClockDomain clockDomain, AxiMemorySimConfig config) {
        this.axi = axi;
        this.clockDomain = clockDomain;
        this.config = config;
        Product.$init$(this);
        this.memory = new SparseMemory();
        this.pending_reads = new Queue();
        this.pending_writes = new Queue();
        this.threads = new Queue();
        this.busWordWidth = axi.config().dataWidth() / 8;
        this.maxBurstSize = log2Up$.MODULE$.apply(this.busWordWidth());
    }
}

