/*
 * Decompiled with CFR 0.152.
 */
package spinal.core.sim;

import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.LinkedHashSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import spinal.core.BaseType;
import spinal.core.Bits;
import spinal.core.Bool;
import spinal.core.Component;
import spinal.core.InComponent;
import spinal.core.Mem;
import spinal.core.MemSymbolesMapping;
import spinal.core.MemSymbolesTag;
import spinal.core.SInt;
import spinal.core.SpinalEnumCraft;
import spinal.core.TimeNumber;
import spinal.core.UInt;
import spinal.core.internals.DeclarationStatement;
import spinal.core.internals.GraphUtils$;
import spinal.core.internals.Statement;
import spinal.core.sim.SimPublic$;
import spinal.core.sim.SpinalVpiBackendConfig;
import spinal.sim.BitsDataType;
import spinal.sim.BoolDataType;
import spinal.sim.DataType;
import spinal.sim.SIntDataType;
import spinal.sim.Signal;
import spinal.sim.UIntDataType;
import spinal.sim.VpiBackendConfig;
import spinal.sim.WaveFormat;
import spinal.sim.WaveFormat$DEFAULT$;
import spinal.sim.WaveFormat$VCD$;

public final class SpinalVpiBackend$ {
    public static SpinalVpiBackend$ MODULE$;

    static {
        new SpinalVpiBackend$();
    }

    public <T extends Component> ArrayBuffer<Signal> apply(SpinalVpiBackendConfig<T> config, VpiBackendConfig vconfig) {
        String string;
        vconfig.rtlIncludeDirs().$plus$plus$eq(config.rtl().rtlIncludeDirs());
        vconfig.rtlSourcesPaths().$plus$plus$eq((TraversableOnce)config.rtl().rtlSourcesPaths().map((Function1<String, String> & Serializable & scala.Serializable)x$6 -> new File((String)x$6).getAbsolutePath(), LinkedHashSet$.MODULE$.canBuildFrom()));
        vconfig.toplevelName_$eq(config.rtl().toplevelName());
        vconfig.wavePath_$eq("test.vcd");
        WaveFormat waveFormat = config.waveFormat();
        vconfig.waveFormat_$eq(WaveFormat$DEFAULT$.MODULE$.equals(waveFormat) ? WaveFormat$VCD$.MODULE$ : config.waveFormat());
        vconfig.workspaceName_$eq(config.workspaceName());
        vconfig.workspacePath_$eq(config.workspacePath());
        vconfig.useCache_$eq(config.usePluginsCache());
        TimeNumber timeNumber = config.timePrecision();
        vconfig.timePrecision_$eq(timeNumber == null ? null : timeNumber.decomposeString());
        if (config.usePluginsCache()) {
            File pluginsCachePathFile = new File(config.pluginsCachePath());
            Serializable serializable = !pluginsCachePathFile.exists() ? BoxesRunTime.boxToBoolean(pluginsCachePathFile.mkdirs()) : BoxedUnit.UNIT;
            string = config.pluginsCachePath();
        } else {
            string = config.workspacePath();
        }
        vconfig.pluginsPath_$eq(string);
        IntRef signalId = IntRef.create(0);
        ArrayBuffer signalsCollector = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        GraphUtils$.MODULE$.walkAllComponents((Component)config.rtl().toplevel(), (Function1<Component, BoxedUnit>)(Function1<Component, Object> & Serializable & scala.Serializable)c -> {
            SpinalVpiBackend$.$anonfun$apply$10(signalId, config, signalsCollector, c);
            return BoxedUnit.UNIT;
        });
        ((Component)config.rtl().toplevel()).getAllIo().foreach((Function1<BaseType, Object> & Serializable & scala.Serializable)io -> {
            SpinalVpiBackend$.$anonfun$apply$14(config, signalId, signalsCollector, io);
            return BoxedUnit.UNIT;
        });
        return signalsCollector;
    }

    private static final void addSignal$2(DeclarationStatement bt, SpinalVpiBackendConfig config$2, IntRef signalId$2, ArrayBuffer signalsCollector$1) {
        DataType dataType;
        String string = config$2.rtl().toplevelName();
        DeclarationStatement declarationStatement = bt;
        if (declarationStatement instanceof Bool) {
            dataType = new BoolDataType();
        } else if (declarationStatement instanceof Bits) {
            Bits bits = (Bits)declarationStatement;
            dataType = new BitsDataType(bits.getBitsWidth());
        } else if (declarationStatement instanceof UInt) {
            UInt uInt = (UInt)declarationStatement;
            dataType = new UIntDataType(uInt.getBitsWidth());
        } else if (declarationStatement instanceof SInt) {
            SInt sInt = (SInt)declarationStatement;
            dataType = new SIntDataType(sInt.getBitsWidth());
        } else if (declarationStatement instanceof SpinalEnumCraft) {
            SpinalEnumCraft spinalEnumCraft = (SpinalEnumCraft)declarationStatement;
            dataType = new BitsDataType(spinalEnumCraft.getBitsWidth());
        } else if (declarationStatement instanceof Mem) {
            Mem mem = (Mem)declarationStatement;
            dataType = new BitsDataType(mem.width());
        } else {
            throw new MatchError(declarationStatement);
        }
        Signal signal = new Signal(((SeqLike)((SeqLike)((TraversableLike)((InComponent)((Object)bt)).getComponents().tail()).map((Function1<Component, String> & Serializable & scala.Serializable)x$7 -> x$7.getName(), Seq$.MODULE$.canBuildFrom())).$plus$colon(string, Seq$.MODULE$.canBuildFrom())).$colon$plus(bt.getName(), Seq$.MODULE$.canBuildFrom()), dataType);
        bt.algoInt_$eq(signalId$2.elem);
        bt.algoIncrementale_$eq(-1);
        signal.id_$eq(signalId$2.elem);
        signalsCollector$1.$plus$eq(signal);
        ++signalId$2.elem;
    }

    public static final /* synthetic */ void $anonfun$apply$12(SpinalVpiBackendConfig config$2, Mem x3$2, IntRef signalId$2, ArrayBuffer signalsCollector$1, MemSymbolesMapping mapping) {
        String string = config$2.rtl().toplevelName();
        Signal signal = new Signal(((SeqLike)((SeqLike)((TraversableLike)x3$2.getComponents().tail()).map((Function1<Component, String> & Serializable & scala.Serializable)x$9 -> x$9.getName(), Seq$.MODULE$.canBuildFrom())).$plus$colon(string, Seq$.MODULE$.canBuildFrom())).$colon$plus(mapping.name(), Seq$.MODULE$.canBuildFrom()), new BitsDataType(mapping.width()));
        signal.id_$eq(signalId$2.elem);
        signalsCollector$1.$plus$eq(signal);
        ++signalId$2.elem;
    }

    public static final /* synthetic */ void $anonfun$apply$11(IntRef signalId$2, SpinalVpiBackendConfig config$2, ArrayBuffer signalsCollector$1, Statement s) {
        Mem mem;
        BaseType baseType;
        Statement statement = s;
        if (statement instanceof BaseType && (baseType = (BaseType)statement).hasTag(SimPublic$.MODULE$) && (baseType.isDirectionLess() || baseType.component().parent() != null)) {
            SpinalVpiBackend$.addSignal$2(baseType, config$2, signalId$2, signalsCollector$1);
            return;
        }
        if (statement instanceof Mem && (mem = (Mem)statement).hasTag(SimPublic$.MODULE$)) {
            Option<MemSymbolesTag> tag = mem.getTag(MemSymbolesTag.class);
            mem.algoInt_$eq(signalId$2.elem);
            mem.algoIncrementale_$eq(-1);
            Option<MemSymbolesTag> option = tag;
            if (None$.MODULE$.equals(option)) {
                SpinalVpiBackend$.addSignal$2(mem, config$2, signalId$2, signalsCollector$1);
            } else if (option instanceof Some) {
                Some some = (Some)option;
                MemSymbolesTag tag2 = (MemSymbolesTag)some.value();
                tag2.mapping().foreach((Function1<MemSymbolesMapping, Object> & Serializable & scala.Serializable)mapping -> {
                    SpinalVpiBackend$.$anonfun$apply$12(config$2, mem, signalId$2, signalsCollector$1, mapping);
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError(option);
            }
            return;
        }
        s.algoInt_$eq(-1);
    }

    public static final /* synthetic */ void $anonfun$apply$10(IntRef signalId$2, SpinalVpiBackendConfig config$2, ArrayBuffer signalsCollector$1, Component c) {
        c.dslBody().walkStatements((Function1<Statement, BoxedUnit>)(Function1<Statement, Object> & Serializable & scala.Serializable)s -> {
            SpinalVpiBackend$.$anonfun$apply$11(signalId$2, config$2, signalsCollector$1, s);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$14(SpinalVpiBackendConfig config$2, IntRef signalId$2, ArrayBuffer signalsCollector$1, BaseType io) {
        DataType dataType;
        BaseType bt = io;
        String string = config$2.rtl().toplevelName();
        BaseType baseType = bt;
        if (baseType instanceof Bool) {
            dataType = new BoolDataType();
        } else if (baseType instanceof Bits) {
            Bits bits = (Bits)baseType;
            dataType = new BitsDataType(bits.getBitsWidth());
        } else if (baseType instanceof UInt) {
            UInt uInt = (UInt)baseType;
            dataType = new UIntDataType(uInt.getBitsWidth());
        } else if (baseType instanceof SInt) {
            SInt sInt = (SInt)baseType;
            dataType = new SIntDataType(sInt.getBitsWidth());
        } else if (baseType instanceof SpinalEnumCraft) {
            SpinalEnumCraft spinalEnumCraft = (SpinalEnumCraft)baseType;
            dataType = new BitsDataType(spinalEnumCraft.getBitsWidth());
        } else {
            throw new MatchError(baseType);
        }
        Signal signal = new Signal(((SeqLike)((SeqLike)((TraversableLike)bt.getComponents().tail()).map((Function1<Component, String> & Serializable & scala.Serializable)x$11 -> x$11.getName(), Seq$.MODULE$.canBuildFrom())).$plus$colon(string, Seq$.MODULE$.canBuildFrom())).$colon$plus(bt.getName(), Seq$.MODULE$.canBuildFrom()), dataType);
        bt.algoInt_$eq(signalId$2.elem);
        bt.algoIncrementale_$eq(-1);
        signal.id_$eq(signalId$2.elem);
        signalsCollector$1.$plus$eq(signal);
        ++signalId$2.elem;
    }

    private SpinalVpiBackend$() {
        MODULE$ = this;
    }
}

