/*
 * Decompiled with CFR 0.152.
 */
package spinal.core.sim;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import spinal.core.BaseType;
import spinal.core.Bits;
import spinal.core.Bool;
import spinal.core.Component;
import spinal.core.InComponent;
import spinal.core.Mem;
import spinal.core.MemSymbolesMapping;
import spinal.core.MemSymbolesTag;
import spinal.core.SInt;
import spinal.core.SpinalEnumCraft;
import spinal.core.TimeNumber;
import spinal.core.UInt;
import spinal.core.Verilator$public$;
import spinal.core.internals.DeclarationStatement;
import spinal.core.internals.GraphUtils$;
import spinal.core.internals.Statement;
import spinal.core.sim.SpinalVerilatorBackendConfig;
import spinal.sim.BitsDataType;
import spinal.sim.BoolDataType;
import spinal.sim.DataType;
import spinal.sim.SIntDataType;
import spinal.sim.Signal;
import spinal.sim.UIntDataType;
import spinal.sim.VerilatorBackend;
import spinal.sim.VerilatorBackendConfig;
import spinal.sim.WaveFormat;
import spinal.sim.WaveFormat$DEFAULT$;
import spinal.sim.WaveFormat$VCD$;

public final class SpinalVerilatorBackend$ {
    public static SpinalVerilatorBackend$ MODULE$;

    static {
        new SpinalVerilatorBackend$();
    }

    public <T extends Component> VerilatorBackend apply(SpinalVerilatorBackendConfig<T> config) {
        VerilatorBackendConfig vconfig = new VerilatorBackendConfig();
        vconfig.rtlIncludeDirs().$plus$plus$eq(config.rtl().rtlIncludeDirs());
        vconfig.rtlSourcesPaths().$plus$plus$eq(config.rtl().rtlSourcesPaths());
        vconfig.toplevelName_$eq(config.rtl().toplevelName());
        vconfig.vcdPath_$eq(config.vcdPath());
        vconfig.vcdPrefix_$eq(config.vcdPrefix());
        vconfig.maxCacheEntries_$eq(config.maxCacheEntries());
        vconfig.cachePath_$eq(config.cachePath());
        vconfig.workspaceName_$eq(config.workspaceName());
        vconfig.workspacePath_$eq(config.workspacePath());
        WaveFormat waveFormat = config.waveFormat();
        vconfig.waveFormat_$eq(WaveFormat$DEFAULT$.MODULE$.equals(waveFormat) ? WaveFormat$VCD$.MODULE$ : config.waveFormat());
        vconfig.waveDepth_$eq(config.waveDepth());
        vconfig.optimisationLevel_$eq(config.optimisationLevel());
        vconfig.simulatorFlags_$eq(config.simulatorFlags());
        vconfig.withCoverage_$eq(config.withCoverage());
        TimeNumber timeNumber = config.timePrecision();
        vconfig.timePrecision_$eq(timeNumber == null ? null : timeNumber.decomposeString());
        IntRef signalId = IntRef.create(0);
        GraphUtils$.MODULE$.walkAllComponents((Component)config.rtl().toplevel(), (Function1<Component, BoxedUnit>)(Function1<Component, Object> & Serializable & scala.Serializable)c -> {
            SpinalVerilatorBackend$.$anonfun$apply$2(signalId, config, vconfig, c);
            return BoxedUnit.UNIT;
        });
        ((Component)config.rtl().toplevel()).getAllIo().foreach((Function1<BaseType, Object> & Serializable & scala.Serializable)io -> {
            SpinalVerilatorBackend$.$anonfun$apply$6(signalId, vconfig, io);
            return BoxedUnit.UNIT;
        });
        return new VerilatorBackend(vconfig);
    }

    private static final void addSignal$1(DeclarationStatement bt, SpinalVerilatorBackendConfig config$1, IntRef signalId$1, VerilatorBackendConfig vconfig$1) {
        DataType dataType;
        String string = config$1.rtl().toplevelName();
        DeclarationStatement declarationStatement = bt;
        if (declarationStatement instanceof Bool) {
            dataType = new BoolDataType();
        } else if (declarationStatement instanceof Bits) {
            Bits bits = (Bits)declarationStatement;
            dataType = new BitsDataType(bits.getBitsWidth());
        } else if (declarationStatement instanceof UInt) {
            UInt uInt = (UInt)declarationStatement;
            dataType = new UIntDataType(uInt.getBitsWidth());
        } else if (declarationStatement instanceof SInt) {
            SInt sInt = (SInt)declarationStatement;
            dataType = new SIntDataType(sInt.getBitsWidth());
        } else if (declarationStatement instanceof SpinalEnumCraft) {
            SpinalEnumCraft spinalEnumCraft = (SpinalEnumCraft)declarationStatement;
            dataType = new BitsDataType(spinalEnumCraft.getBitsWidth());
        } else if (declarationStatement instanceof Mem) {
            Mem mem = (Mem)declarationStatement;
            dataType = new BitsDataType(mem.width()).setMem();
        } else {
            throw new MatchError(declarationStatement);
        }
        Signal signal = new Signal(((SeqLike)((SeqLike)((TraversableLike)((InComponent)((Object)bt)).getComponents().tail()).map((Function1<Component, String> & Serializable & scala.Serializable)x$1 -> x$1.getName(), Seq$.MODULE$.canBuildFrom())).$plus$colon(string, Seq$.MODULE$.canBuildFrom())).$colon$plus(bt.getName(), Seq$.MODULE$.canBuildFrom()), dataType);
        bt.algoInt_$eq(signalId$1.elem);
        bt.algoIncrementale_$eq(-1);
        signal.id_$eq(signalId$1.elem);
        vconfig$1.signals().$plus$eq((Object)signal);
        ++signalId$1.elem;
    }

    public static final /* synthetic */ void $anonfun$apply$4(SpinalVerilatorBackendConfig config$1, Mem x3$1, IntRef signalId$1, VerilatorBackendConfig vconfig$1, MemSymbolesMapping mapping) {
        String string = config$1.rtl().toplevelName();
        Signal signal = new Signal(((SeqLike)((SeqLike)((TraversableLike)x3$1.getComponents().tail()).map((Function1<Component, String> & Serializable & scala.Serializable)x$3 -> x$3.getName(), Seq$.MODULE$.canBuildFrom())).$plus$colon(string, Seq$.MODULE$.canBuildFrom())).$colon$plus(mapping.name(), Seq$.MODULE$.canBuildFrom()), new BitsDataType(mapping.width()).setMem());
        signal.id_$eq(signalId$1.elem);
        vconfig$1.signals().$plus$eq((Object)signal);
        ++signalId$1.elem;
    }

    public static final /* synthetic */ void $anonfun$apply$3(IntRef signalId$1, SpinalVerilatorBackendConfig config$1, VerilatorBackendConfig vconfig$1, Statement s) {
        Mem mem;
        BaseType baseType;
        Statement statement = s;
        if (statement instanceof BaseType && (baseType = (BaseType)statement).hasTag(Verilator$public$.MODULE$) && (baseType.isDirectionLess() || baseType.component().parent() != null)) {
            SpinalVerilatorBackend$.addSignal$1(baseType, config$1, signalId$1, vconfig$1);
            return;
        }
        if (statement instanceof Mem && (mem = (Mem)statement).hasTag(Verilator$public$.MODULE$)) {
            Option<MemSymbolesTag> tag = mem.getTag(MemSymbolesTag.class);
            mem.algoInt_$eq(signalId$1.elem);
            mem.algoIncrementale_$eq(-1);
            Option<MemSymbolesTag> option = tag;
            if (None$.MODULE$.equals(option)) {
                SpinalVerilatorBackend$.addSignal$1(mem, config$1, signalId$1, vconfig$1);
            } else if (option instanceof Some) {
                Some some = (Some)option;
                MemSymbolesTag tag2 = (MemSymbolesTag)some.value();
                tag2.mapping().foreach((Function1<MemSymbolesMapping, Object> & Serializable & scala.Serializable)mapping -> {
                    SpinalVerilatorBackend$.$anonfun$apply$4(config$1, mem, signalId$1, vconfig$1, mapping);
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError(option);
            }
            return;
        }
        s.algoInt_$eq(-1);
    }

    public static final /* synthetic */ void $anonfun$apply$2(IntRef signalId$1, SpinalVerilatorBackendConfig config$1, VerilatorBackendConfig vconfig$1, Component c) {
        c.dslBody().walkStatements((Function1<Statement, BoxedUnit>)(Function1<Statement, Object> & Serializable & scala.Serializable)s -> {
            SpinalVerilatorBackend$.$anonfun$apply$3(signalId$1, config$1, vconfig$1, s);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$6(IntRef signalId$1, VerilatorBackendConfig vconfig$1, BaseType io) {
        DataType dataType;
        BaseType bt = io;
        BaseType baseType = bt;
        if (baseType instanceof Bool) {
            dataType = new BoolDataType();
        } else if (baseType instanceof Bits) {
            Bits bits = (Bits)baseType;
            dataType = new BitsDataType(bits.getBitsWidth());
        } else if (baseType instanceof UInt) {
            UInt uInt = (UInt)baseType;
            dataType = new UIntDataType(uInt.getBitsWidth());
        } else if (baseType instanceof SInt) {
            SInt sInt = (SInt)baseType;
            dataType = new SIntDataType(sInt.getBitsWidth());
        } else if (baseType instanceof SpinalEnumCraft) {
            SpinalEnumCraft spinalEnumCraft = (SpinalEnumCraft)baseType;
            dataType = new BitsDataType(spinalEnumCraft.getBitsWidth());
        } else {
            throw new MatchError(baseType);
        }
        Signal signal = new Signal(((SeqLike)((TraversableLike)bt.getComponents().tail()).map((Function1<Component, String> & Serializable & scala.Serializable)x$5 -> x$5.getName(), Seq$.MODULE$.canBuildFrom())).$colon$plus(bt.getName(), Seq$.MODULE$.canBuildFrom()), dataType);
        bt.algoInt_$eq(signalId$1.elem);
        bt.algoIncrementale_$eq(-1);
        signal.id_$eq(signalId$1.elem);
        vconfig$1.signals().$plus$eq((Object)signal);
        ++signalId$1.elem;
    }

    private SpinalVerilatorBackend$() {
        MODULE$ = this;
    }
}

