/*
 * Decompiled with CFR 0.152.
 */
package spinal.core.internals;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcV$sp;
import spinal.core.ClockDomain;
import spinal.core.ClockDomainConfig;
import spinal.core.Component;
import spinal.core.Device;
import spinal.core.DumpWaveConfig;
import spinal.core.GlobalData$;
import spinal.core.Ref;
import spinal.core.ScopeProperty;
import spinal.core.ScopeProperty$;
import spinal.core.SpinalConfig;
import spinal.core.SpinalEnumEncoding;
import spinal.core.SpinalError$;
import spinal.core.SpinalMode;
import spinal.core.SpinalProgress$;
import spinal.core.SpinalReport;
import spinal.core.SpinalWarning$;
import spinal.core.internals.Phase;
import spinal.core.internals.PhaseAllocateNames;
import spinal.core.internals.PhaseAnalog;
import spinal.core.internals.PhaseApplyIoDefault;
import spinal.core.internals.PhaseCheckCombinationalLoops;
import spinal.core.internals.PhaseCheckCrossClock;
import spinal.core.internals.PhaseCheckHierarchy;
import spinal.core.internals.PhaseCheckIoBundle;
import spinal.core.internals.PhaseCheck_noLatchNoOverride;
import spinal.core.internals.PhaseCheck_noRegisterAsLatch;
import spinal.core.internals.PhaseCollectAndNameEnum;
import spinal.core.internals.PhaseCompletSwitchCases;
import spinal.core.internals.PhaseContext;
import spinal.core.internals.PhaseCreateComponent;
import spinal.core.internals.PhaseDevice;
import spinal.core.internals.PhaseDeviceSpecifics;
import spinal.core.internals.PhaseDummy;
import spinal.core.internals.PhaseGetInfoRTL;
import spinal.core.internals.PhaseInferEnumEncodings;
import spinal.core.internals.PhaseInferWidth;
import spinal.core.internals.PhaseNameNodesByReflection;
import spinal.core.internals.PhaseNextifyReg;
import spinal.core.internals.PhaseNormalizeNodeInputs;
import spinal.core.internals.PhasePropagateNames;
import spinal.core.internals.PhasePullClockDomains;
import spinal.core.internals.PhaseRemoveIntermediateUnnameds;
import spinal.core.internals.PhaseRemoveUselessStuff;
import spinal.core.internals.PhaseSimplifyNodes;
import spinal.core.internals.PhaseStdLogicVectorAtTopLevelIo;
import spinal.core.internals.PhaseVhdl;

public final class SpinalVhdlBoot$ {
    public static SpinalVhdlBoot$ MODULE$;

    static {
        new SpinalVhdlBoot$();
    }

    public <T extends Component> SpinalReport<T> apply(SpinalConfig config, Function0<T> gen) {
        SpinalReport<T> spinalReport;
        if (config.debugComponents().nonEmpty()) {
            return this.singleShot(config, gen);
        }
        try {
            spinalReport = this.singleShot(config, gen);
        }
        catch (NullPointerException e) {
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("\n            |ERROR !\n            |A null pointer access has been detected in the JVM.\n            |This could happen when in your SpinalHDL description, you access an signal which is only defined further.\n            |For instance :\n            |  val result = Bool()\n            |  result := a ^ b  //a and b can't be accessed there because they are only defined one line below (Software rule of execution order)\n            |  val a,b = Bool()\n          ")).stripMargin());
            System.out.flush();
            throw e;
        }
        catch (Throwable e) {
            Predef$.MODULE$.println("\n**********************************************************************************************");
            int errCnt = SpinalError$.MODULE$.getErrorCount();
            SpinalWarning$.MODULE$.apply(new StringBuilder(108).append("Elaboration failed (").append(errCnt).append(" error").append((Object)(errCnt > 1 ? "s" : "")).append(").\n").append("          Spinal will restart with scala trace to help you to find the problem.").toString());
            Predef$.MODULE$.println("**********************************************************************************************\n");
            System.out.flush();
            GlobalData$.MODULE$.get().applyScalaLocated();
            HashSet<Class<?>> x$1 = GlobalData$.MODULE$.get().scalaLocatedComponents();
            SpinalMode x$2 = config.copy$default$1();
            HashSet<Object> x$3 = config.copy$default$2();
            boolean x$4 = config.copy$default$4();
            ClockDomainConfig x$5 = config.copy$default$5();
            boolean x$6 = config.copy$default$6();
            ClockDomain.ClockFrequency x$7 = config.copy$default$7();
            String x$8 = config.copy$default$8();
            boolean x$9 = config.copy$default$9();
            String x$10 = config.copy$default$10();
            DumpWaveConfig x$11 = config.copy$default$11();
            String x$12 = config.copy$default$12();
            boolean x$13 = config.copy$default$13();
            boolean x$14 = config.copy$default$14();
            String x$15 = config.copy$default$15();
            Device x$16 = config.copy$default$16();
            boolean x$17 = config.copy$default$17();
            boolean x$18 = config.copy$default$18();
            boolean x$19 = config.copy$default$19();
            boolean x$20 = config.copy$default$20();
            boolean x$21 = config.copy$default$21();
            boolean x$22 = config.copy$default$22();
            boolean x$23 = config.copy$default$23();
            boolean x$24 = config.copy$default$24();
            boolean x$25 = config.copy$default$25();
            boolean x$26 = config.copy$default$26();
            boolean x$27 = config.copy$default$27();
            boolean x$28 = config.copy$default$28();
            boolean x$29 = config.copy$default$29();
            boolean x$30 = config.copy$default$30();
            boolean x$31 = config.copy$default$31();
            boolean x$32 = config.copy$default$32();
            boolean x$33 = config.copy$default$33();
            boolean x$34 = config.copy$default$34();
            boolean x$35 = config.copy$default$35();
            boolean x$36 = config.copy$default$36();
            ArrayBuffer<Function1<ArrayBuffer<Phase>, BoxedUnit>> x$37 = config.copy$default$37();
            ArrayBuffer<Phase> x$38 = config.copy$default$38();
            ArrayBuffer<Phase> x$39 = config.copy$default$39();
            String x$40 = config.copy$default$40();
            LinkedHashMap<ScopeProperty<?>, Object> x$41 = config.copy$default$41();
            boolean x$42 = config.copy$default$42();
            boolean x$43 = config.copy$default$43();
            boolean x$44 = config.copy$default$44();
            int x$45 = config.copy$default$45();
            boolean x$46 = config.copy$default$46();
            boolean x$47 = config.copy$default$47();
            boolean x$48 = config.copy$default$48();
            boolean x$49 = config.copy$default$49();
            boolean x$50 = config.copy$default$50();
            boolean x$51 = config.copy$default$51();
            boolean x$52 = config.copy$default$52();
            return this.singleShot(config.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52), gen);
        }
        return spinalReport;
    }

    public <T extends Component> SpinalReport<T> singleShot(SpinalConfig config, Function0<T> gen) {
        return (SpinalReport)ScopeProperty$.MODULE$.sandbox((Function0<SpinalReport> & Serializable & scala.Serializable)() -> {
            PhaseContext pc = new PhaseContext(config);
            pc.globalData().phaseContext_$eq(pc);
            pc.globalData().anonymSignalPrefix_$eq(config.anonymSignalPrefix() == null ? "zz" : config.anonymSignalPrefix());
            Set prunedSignals = (Set)Set$.MODULE$.apply(Nil$.MODULE$);
            Set unusedSignals = (Set)Set$.MODULE$.apply(Nil$.MODULE$);
            Ref<Object> counterRegister = new Ref<Object>(BoxesRunTime.boxToInteger(0));
            LinkedHashSet<String> blackboxesSourcesPaths = new LinkedHashSet<String>();
            SpinalProgress$.MODULE$.apply("Elaborate components");
            ArrayBuffer phases = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
            phases.$plus$eq(new PhaseCreateComponent(gen, pc));
            phases.$plus$eq(new PhaseDummy((JFunction0$mcV$sp & scala.Serializable)() -> SpinalProgress$.MODULE$.apply("Checks and transforms")));
            phases.$plus$plus$eq((TraversableOnce)config.transformationPhases());
            phases.$plus$plus$eq((TraversableOnce)config.memBlackBoxers());
            Object object = config.onlyStdLogicVectorAtTopLevelIo() ? phases.$plus$eq(new PhaseStdLogicVectorAtTopLevelIo()) : BoxedUnit.UNIT;
            phases.$plus$eq(new PhaseDeviceSpecifics(pc));
            phases.$plus$eq(new PhaseApplyIoDefault(pc));
            phases.$plus$eq(new PhaseNameNodesByReflection(pc));
            phases.$plus$eq(new PhaseCollectAndNameEnum(pc));
            phases.$plus$eq(new PhaseCheckIoBundle());
            phases.$plus$eq(new PhaseCheckHierarchy());
            phases.$plus$eq(new PhaseAnalog());
            phases.$plus$eq(new PhaseNextifyReg());
            phases.$plus$eq(new PhaseRemoveUselessStuff(false, false));
            phases.$plus$eq(new PhaseRemoveIntermediateUnnameds(true));
            phases.$plus$eq(new PhasePullClockDomains(pc));
            phases.$plus$eq(new PhaseInferEnumEncodings(pc, (Function1<SpinalEnumEncoding, SpinalEnumEncoding> & Serializable & scala.Serializable)e -> e));
            phases.$plus$eq(new PhaseInferWidth(pc));
            phases.$plus$eq(new PhaseNormalizeNodeInputs(pc));
            phases.$plus$eq(new PhaseRemoveIntermediateUnnameds(false));
            phases.$plus$eq(new PhaseSimplifyNodes(pc));
            phases.$plus$eq(new PhaseCompletSwitchCases());
            phases.$plus$eq(new PhaseRemoveUselessStuff(true, true));
            phases.$plus$eq(new PhaseRemoveIntermediateUnnameds(false));
            phases.$plus$eq(new PhaseCheck_noLatchNoOverride(pc));
            phases.$plus$eq(new PhaseCheck_noRegisterAsLatch());
            phases.$plus$eq(new PhaseCheckCombinationalLoops());
            phases.$plus$eq(new PhaseCheckCrossClock());
            phases.$plus$eq(new PhasePropagateNames(pc));
            phases.$plus$eq(new PhaseAllocateNames(pc));
            phases.$plus$eq(new PhaseDevice(pc));
            phases.$plus$eq(new PhaseGetInfoRTL(prunedSignals, unusedSignals, counterRegister, blackboxesSourcesPaths, pc));
            SpinalReport<Component> report = new SpinalReport<Component>();
            report.globalData_$eq(pc.globalData());
            phases.$plus$eq(new PhaseDummy((JFunction0$mcV$sp & scala.Serializable)() -> SpinalProgress$.MODULE$.apply(new StringBuilder(17).append("Generate VHDL to ").append(config.targetDirectory()).toString())));
            phases.$plus$eq(new PhaseVhdl(pc, report));
            config.phasesInserters().foreach((Function1<Function1, Object> & Serializable & scala.Serializable)inserter -> {
                inserter.apply(phases);
                return BoxedUnit.UNIT;
            });
            phases.foreach((Function1<Phase, Object> & Serializable & scala.Serializable)phase -> {
                SpinalVhdlBoot$.$anonfun$singleShot$6(config, pc, phase);
                return BoxedUnit.UNIT;
            });
            if (prunedSignals.nonEmpty()) {
                SpinalWarning$.MODULE$.apply(new StringBuilder(94).append(prunedSignals.size()).append(" signals were pruned. You can call printPruned on the backend report to get more informations.").toString());
            }
            pc.checkGlobalData();
            report.toplevel_$eq(pc.topLevel());
            report.prunedSignals().$plus$plus$eq(prunedSignals);
            report.unusedSignals().$plus$plus$eq(unusedSignals);
            report.counterRegister_$eq(BoxesRunTime.unboxToInt(counterRegister.value()));
            report.blackboxesSourcesPaths().$plus$plus$eq(blackboxesSourcesPaths);
            return report;
        });
    }

    public static final /* synthetic */ void $anonfun$singleShot$6(SpinalConfig config$1, PhaseContext pc$13, Phase phase) {
        if (config$1.verbose()) {
            SpinalProgress$.MODULE$.apply(String.valueOf(phase.getClass().getSimpleName()));
        }
        pc$13.doPhase(phase);
    }

    private SpinalVhdlBoot$() {
        MODULE$ = this;
    }
}

