/*
 * Decompiled with CFR 0.152.
 */
package spinal.core.internals;

import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import spinal.core.BitVector;
import spinal.core.internals.SIntLiteral;
import spinal.idslplugin.Location;

public final class SIntLiteral$ {
    public static SIntLiteral$ MODULE$;

    static {
        new SIntLiteral$();
    }

    public SIntLiteral apply(BigInt value, BigInt poisonMask, int specifiedBitCount) {
        int valueBitCount = value.bitLength() + (!BoxesRunTime.equalsNumObject(value, BoxesRunTime.boxToInteger(0)) ? 1 : 0);
        int poisonBitCount = poisonMask != null ? poisonMask.bitLength() : 0;
        int minimalWidth = Math.max(poisonBitCount, valueBitCount);
        int bitCount = specifiedBitCount;
        if (bitCount != -1) {
            if (minimalWidth > bitCount) {
                throw new Exception(new StringBuilder(35).append("literal 0x").append(value.toString(16)).append(" can't fit in SInt(").append(specifiedBitCount).append(" bits)").toString());
            }
        } else {
            bitCount = minimalWidth;
        }
        return this.apply(value, poisonMask, bitCount, specifiedBitCount != -1);
    }

    public <T extends BitVector> T apply(BigInt value, int specifiedBitCount, T on) {
        on.assignFrom(this.apply(value, null, specifiedBitCount), on.assignFrom$default$2(), new Location("Expression", 2431, 18));
        return on;
    }

    public <T extends BitVector> SIntLiteral apply(BigInt value, int specifiedBitCount) {
        return this.apply(value, null, specifiedBitCount);
    }

    public SIntLiteral apply(BigInt value, BigInt poisonMask, int bitCount, boolean hasSpecifiedBitCount) {
        SIntLiteral ret = new SIntLiteral();
        ret.value_$eq(value);
        ret.poisonMask_$eq(poisonMask);
        ret.bitCount_$eq(bitCount);
        ret.hasSpecifiedBitCount_$eq(hasSpecifiedBitCount);
        return ret;
    }

    private SIntLiteral$() {
        MODULE$ = this;
    }
}

