/*
 * Decompiled with CFR 0.152.
 */
package saxon;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import spinal.core.ClockDomain;
import spinal.core.Component;
import spinal.core.Nameable;
import spinal.core.SpinalEnumElement;
import spinal.core.SpinalTag;
import spinal.core.fiber.Handle;
import spinal.core.fiber.Handle$;
import spinal.core.internals.Misc$;
import spinal.lib.bus.misc.AddressMapping;
import spinal.lib.bus.misc.SizeMapping;
import spinal.lib.generator.Dts;
import spinal.lib.generator.Export;
import spinal.lib.generator.MemoryConnection;
import spinal.lib.generator.SimpleBus;

public final class BspGenerator$ {
    public static BspGenerator$ MODULE$;

    static {
        new BspGenerator$();
    }

    public <T extends Nameable> void apply(String name, Component root, Handle<T> memoryView) {
        ArrayBuffer allTags = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        File target = new File(name);
        target.mkdirs();
        File include = new File(target, "include");
        include.mkdir();
        File linker = new File(target, "linker");
        linker.mkdir();
        File socFile = new File(include, "soc.h");
        File dtsFile = new File(include, "soc.dts");
        PrintWriter headerWriter = new PrintWriter(socFile);
        PrintWriter dtsWriter = new PrintWriter(dtsFile);
        headerWriter.println("#ifndef SOC_H");
        headerWriter.println("#define SOC_H");
        ArrayBuffer connections = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        LinkedHashMap dtss = (LinkedHashMap)LinkedHashMap$.MODULE$.apply(Nil$.MODULE$);
        root.walkComponents((Function1<Component, BoxedUnit>)(Function1<Component, Object> & Serializable & scala.Serializable)c -> {
            c.foreachTag((Function1<SpinalTag, BoxedUnit>)(Function1<SpinalTag, Object> & Serializable & scala.Serializable)t -> {
                BspGenerator$.$anonfun$apply$4(dtss$1, connections$1, allTags$1, headerWriter$1, t);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        BspGenerator$.connectionExplorer$1(memoryView, BigInt$.MODULE$.int2bigInt(0), null, BigInt$.MODULE$.int2bigInt(0), "", headerWriter, connections, allTags, dtsWriter, dtss);
        headerWriter.println("#endif");
        headerWriter.close();
        dtsWriter.close();
    }

    private static final String camelToUpperCase$1(String str) {
        return new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])str.split("(?=\\p{Upper})"))).map((Function1<String, String> & Serializable & scala.Serializable)x$1 -> x$1.toUpperCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("_");
    }

    private static final void rec$1(String prefix, Object value, PrintWriter headerWriter$1) {
        Object object = value;
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(object);
            headerWriter$1.println(new StringBuilder(9).append("#define ").append(prefix).append(" ").append(n).toString());
            return;
        }
        if (object instanceof ClockDomain.FixedFrequency) {
            ClockDomain.FixedFrequency fixedFrequency = (ClockDomain.FixedFrequency)object;
            headerWriter$1.println(new StringBuilder(9).append("#define ").append(prefix).append(" ").append(fixedFrequency.getValue().toBigDecimal().toBigInt().toString(10)).toString());
            return;
        }
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean(object);
            headerWriter$1.println(new StringBuilder(9).append("#define ").append(prefix).append(" ").append(bl ? BoxesRunTime.boxToInteger(1) : BoxesRunTime.boxToInteger(0)).toString());
            return;
        }
        if (object instanceof SpinalEnumElement) {
            SpinalEnumElement spinalEnumElement = (SpinalEnumElement)object;
            headerWriter$1.println(new StringBuilder(9).append("#define ").append(prefix).append(" ").append(spinalEnumElement).toString());
            return;
        }
        if (object instanceof Object) {
            Object object2 = object;
            Misc$.MODULE$.reflect(object2, (Function2<String, Object, BoxedUnit>)(Function2<String, Object, Object> & Serializable & scala.Serializable)(name, obj) -> {
                BspGenerator$.rec$1(new StringBuilder(1).append(prefix).append("_").append(BspGenerator$.camelToUpperCase$1(name)).toString(), obj, headerWriter$1);
                return BoxedUnit.UNIT;
            }, Misc$.MODULE$.reflect$default$3());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$apply$4(LinkedHashMap dtss$1, ArrayBuffer connections$1, ArrayBuffer allTags$1, PrintWriter headerWriter$1, SpinalTag t) {
        SpinalTag spinalTag = t;
        if (spinalTag instanceof Export) {
            Export export = (Export)spinalTag;
            BspGenerator$.rec$1(BspGenerator$.camelToUpperCase$1(export.name()), export.value(), headerWriter$1);
        } else if (spinalTag instanceof Dts) {
            Dts dts = (Dts)spinalTag;
            dtss$1.update(dts.node(), dts);
        } else if (spinalTag instanceof MemoryConnection) {
            MemoryConnection memoryConnection = (MemoryConnection)spinalTag;
            connections$1.$plus$eq(memoryConnection);
        }
        allTags$1.$plus$eq(t);
    }

    public static final /* synthetic */ boolean $anonfun$apply$5(Handle view$1, MemoryConnection x$2) {
        Handle handle = x$2.input();
        Handle handle2 = view$1;
        return !(handle != null ? !((Object)handle).equals(handle2) : handle2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$apply$6(Handle view$1, SpinalTag x0$1) {
        SpinalTag spinalTag = x0$1;
        if (spinalTag instanceof SimpleBus) {
            SimpleBus simpleBus = (SimpleBus)spinalTag;
            Handle handle = simpleBus.node();
            Handle handle2 = view$1;
            return !(handle != null ? !((Object)handle).equals(handle2) : handle2 != null);
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$apply$7(BigInt address$1, ObjectRef addressLastRec$1, ObjectRef innerTab$1, PrintWriter headerWriter$1, ArrayBuffer connections$1, ArrayBuffer allTags$1, PrintWriter dtsWriter$1, LinkedHashMap dtss$1, MemoryConnection c) {
        BigInt connectionAddress = address$1.$plus(Handle$.MODULE$.keyImplicit(c.address()));
        BspGenerator$.connectionExplorer$1(c.output(), connectionAddress, Handle$.MODULE$.keyImplicit(c.mapping()), (BigInt)addressLastRec$1.elem, (String)innerTab$1.elem, headerWriter$1, connections$1, allTags$1, dtsWriter$1, dtss$1);
    }

    private static final void connectionExplorer$1(Handle view, BigInt address, AddressMapping mapping, BigInt addressLast, String tab, PrintWriter headerWriter$1, ArrayBuffer connections$1, ArrayBuffer allTags$1, PrintWriter dtsWriter$1, LinkedHashMap dtss$1) {
        headerWriter$1.println(new StringBuilder(11).append("#define ").append(BspGenerator$.camelToUpperCase$1(view.getName())).append(" 0x").append(address.toString(16)).toString());
        AddressMapping addressMapping = mapping;
        if (addressMapping instanceof SizeMapping) {
            SizeMapping sizeMapping = (SizeMapping)addressMapping;
            headerWriter$1.println(new StringBuilder(11).append("#define ").append(BspGenerator$.camelToUpperCase$1(new StringBuilder(4).append(view.getName()).append("Size").toString())).append(" 0x").append(sizeMapping.size().toString(16)).toString());
        }
        ArrayBuffer viewConnections = (ArrayBuffer)connections$1.filter((Function1<MemoryConnection, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(BspGenerator$.$anonfun$apply$5(view, x$2)));
        if (viewConnections.nonEmpty()) {
            Option simpleBusOption = allTags$1.find((Function1<SpinalTag, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(BspGenerator$.$anonfun$apply$6(view, x0$1)));
            ObjectRef<String> innerTab = ObjectRef.create(tab);
            ObjectRef<BigInt> addressLastRec = ObjectRef.create(addressLast);
            if (simpleBusOption.isDefined()) {
                SimpleBus simpleBus = (SimpleBus)simpleBusOption.get();
                BigInt busAddress = address.$minus((BigInt)addressLastRec.elem);
                dtsWriter$1.println(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(186).append(tab).append(view.getName()).append("@").append(busAddress.toString(16)).append(" {\n               |").append(tab).append("  compatible = \"simple-bus\";\n               |").append(tab).append("  #address-cells = <0x1>;\n               |").append(tab).append("  #size-cells = <0x1>;\n               |").append(tab).append("  ranges = <0x0 0x").append(busAddress.toString(16)).append(" 0x").append(simpleBus.size().toString(16)).append(">;\n                ").toString())).stripMargin());
                innerTab.elem = new StringBuilder(2).append((String)innerTab.elem).append("  ").toString();
                addressLastRec.elem = address;
            }
            viewConnections.foreach((Function1<MemoryConnection, Object> & Serializable & scala.Serializable)c -> {
                BspGenerator$.$anonfun$apply$7(address, addressLastRec, innerTab, headerWriter$1, connections$1, allTags$1, dtsWriter$1, dtss$1, c);
                return BoxedUnit.UNIT;
            });
            if (simpleBusOption.isDefined()) {
                dtsWriter$1.println(new StringBuilder(3).append("\n").append(tab).append("};").toString());
                return;
            }
            return;
        }
        Option option = dtss$1.get(view);
        if (option instanceof Some) {
            Some some = (Some)option;
            Dts dts = (Dts)some.value();
            dtsWriter$1.println(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])dts.value().split("\n"))).map((Function1<String, String> & Serializable & scala.Serializable)e -> new StringBuilder(0).append(tab).append((String)e).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n"));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    private BspGenerator$() {
        MODULE$ = this;
    }
}

