/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.enablers;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.scalactic.Bad;
import org.scalactic.Good;
import org.scalactic.Or;
import org.scalatest.Exceptional$;
import org.scalatest.FutureOutcome;
import org.scalatest.Outcome;
import org.scalatest.Timer;
import org.scalatest.concurrent.Signaler;
import org.scalatest.concurrent.SignalerTimeoutTask;
import org.scalatest.enablers.Timed;
import org.scalatest.enablers.Timed$;
import org.scalatest.exceptions.StackDepthException;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.compat.Platform$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class Timed$ {
    public static Timed$ MODULE$;

    static {
        new Timed$();
    }

    public <T> Timed<T> timed() {
        return new Timed<T>(){

            public T timeoutAfter(Span timeout, Function0<T> f, Signaler signaler, Function1<Option<Throwable>, StackDepthException> exceptionFun) {
                T t;
                Timer timer = new Timer();
                SignalerTimeoutTask task = new SignalerTimeoutTask(Thread.currentThread(), signaler);
                long maxDuration = timeout.totalNanos() / 1000L / 1000L;
                timer.schedule(task, maxDuration);
                long startTime = Platform$.MODULE$.currentTime();
                try {
                    Outcome outcome;
                    Option<Throwable> option;
                    T result2 = f.apply();
                    long endTime = Platform$.MODULE$.currentTime();
                    task.cancel();
                    timer.cancel();
                    T t2 = result2;
                    if (t2 instanceof Outcome && !(option = Exceptional$.MODULE$.unapply(outcome = (Outcome)t2)).isEmpty()) {
                        Throwable ex = option.get();
                        throw ex;
                    }
                    if (task.timedOut() || endTime - startTime > maxDuration) {
                        Serializable serializable = task.needToResetInterruptedStatus() ? BoxesRunTime.boxToBoolean(Thread.interrupted()) : BoxedUnit.UNIT;
                        throw (Throwable)exceptionFun.apply(None$.MODULE$);
                    }
                    t = result2;
                }
                catch (Throwable t3) {
                    long endTime = Platform$.MODULE$.currentTime();
                    task.cancel();
                    timer.cancel();
                    if (task.timedOut() || endTime - startTime > maxDuration) {
                        Serializable serializable = task.needToResetInterruptedStatus() ? BoxesRunTime.boxToBoolean(Thread.interrupted()) : BoxedUnit.UNIT;
                        throw (Throwable)exceptionFun.apply(new Some<Throwable>(t3));
                    }
                    throw t3;
                }
                return t;
            }
        };
    }

    public <T> Timed<Future<T>> timedFutureOf(ExecutionContext executionContext) {
        return new Timed<Future<T>>(executionContext){
            private final ExecutionContext executionContext$1;

            public Future<T> timeoutAfter(Span timeout, Function0<Future<T>> f, Signaler signaler, Function1<Option<Throwable>, StackDepthException> exceptionFun) {
                Future<T> future;
                Timer timer = new Timer();
                long maxDuration = timeout.totalNanos() / 1000L / 1000L;
                long startTime = Platform$.MODULE$.currentTime();
                try {
                    Future<T> result2 = f.apply();
                    long endTime = Platform$.MODULE$.currentTime();
                    if (endTime - startTime > maxDuration) {
                        throw (Throwable)exceptionFun.apply(None$.MODULE$);
                    }
                    Promise<T> promise = Promise$.MODULE$.apply();
                    SignalerTimeoutTask task = new SignalerTimeoutTask(Thread.currentThread(), signaler);
                    long delay = maxDuration - (Platform$.MODULE$.currentTime() - startTime);
                    Timer timer2 = new Timer();
                    timer2.schedule(task, delay);
                    result2.onComplete((Function1<Try, Object> & Serializable & scala.Serializable)t -> {
                        Try try_ = t;
                        if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            T r = success.value();
                            task.cancel();
                            timer2.cancel();
                            if (!promise.isCompleted()) {
                                long endTime = Platform$.MODULE$.currentTime();
                                long duration = endTime - startTime;
                                if (duration > maxDuration) {
                                    return promise.complete(new Failure<T>((Throwable)exceptionFun.apply(None$.MODULE$)));
                                }
                                return promise.success(r);
                            }
                            return BoxedUnit.UNIT;
                        }
                        if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable e = failure.exception();
                            task.cancel();
                            timer2.cancel();
                            if (!promise.isCompleted()) {
                                long endTime = Platform$.MODULE$.currentTime();
                                long duration = endTime - startTime;
                                if (duration > maxDuration) {
                                    return promise.complete(new Failure<T>((Throwable)exceptionFun.apply(new Some<Throwable>(e))));
                                }
                                return promise.failure(e);
                            }
                            return BoxedUnit.UNIT;
                        }
                        throw new MatchError(try_);
                    }, this.executionContext$1);
                    future = promise.future();
                }
                catch (Throwable t2) {
                    long endTime = Platform$.MODULE$.currentTime();
                    if (endTime - startTime > maxDuration) {
                        throw (Throwable)exceptionFun.apply(new Some<Throwable>(t2));
                    }
                    throw t2;
                }
                return future;
            }
            {
                this.executionContext$1 = executionContext$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$timeoutAfter$1(org.scalatest.concurrent.SignalerTimeoutTask org.scalatest.Timer scala.concurrent.Promise long long scala.Function1 scala.util.Try )}, serializedLambda);
            }
        };
    }

    public Timed<FutureOutcome> timedFutureOutcome(ExecutionContext executionContext) {
        return new Timed<FutureOutcome>(executionContext){
            private final ExecutionContext executionContext$2;

            public FutureOutcome timeoutAfter(Span timeout, Function0<FutureOutcome> f, Signaler signaler, Function1<Option<Throwable>, StackDepthException> exceptionFun) {
                Timer timer = new Timer();
                long maxDuration = timeout.totalNanos() / 1000L / 1000L;
                long startTime = Platform$.MODULE$.currentTime();
                FutureOutcome result2 = f.apply();
                long endTime = Platform$.MODULE$.currentTime();
                if (endTime - startTime > maxDuration) {
                    throw (Throwable)exceptionFun.apply(None$.MODULE$);
                }
                SignalerTimeoutTask task = new SignalerTimeoutTask(Thread.currentThread(), signaler);
                long delay = maxDuration - (Platform$.MODULE$.currentTime() - startTime);
                timer.schedule(task, delay);
                FutureOutcome futureOutcome = result2.onCompletedThen((Function1<Or<Outcome, Throwable>, BoxedUnit>)(Function1<Or, Object> & Serializable & scala.Serializable)t -> {
                    anon.3.$anonfun$timeoutAfter$2(task, timer, startTime, maxDuration, exceptionFun, t);
                    return BoxedUnit.UNIT;
                }, this.executionContext$2);
                return futureOutcome;
            }

            public static final /* synthetic */ void $anonfun$timeoutAfter$2(SignalerTimeoutTask task$2, Timer timer$2, long startTime$2, long maxDuration$2, Function1 exceptionFun$2, Or t) {
                Or or = t;
                if (or instanceof Good) {
                    task$2.cancel();
                    timer$2.cancel();
                    long endTime = Platform$.MODULE$.currentTime();
                    long duration = endTime - startTime$2;
                    if (duration > maxDuration$2) {
                        throw (Throwable)exceptionFun$2.apply(None$.MODULE$);
                    }
                    return;
                }
                if (or instanceof Bad) {
                    Bad bad = (Bad)or;
                    Throwable e = (Throwable)bad.b();
                    task$2.cancel();
                    timer$2.cancel();
                    long endTime = Platform$.MODULE$.currentTime();
                    long duration = endTime - startTime$2;
                    if (duration > maxDuration$2) {
                        throw (Throwable)exceptionFun$2.apply(None$.MODULE$);
                    }
                    throw e;
                }
                throw new MatchError(or);
            }
            {
                this.executionContext$2 = executionContext$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$timeoutAfter$2$adapted(org.scalatest.concurrent.SignalerTimeoutTask org.scalatest.Timer long long scala.Function1 org.scalactic.Or )}, serializedLambda);
            }
        };
    }

    private Timed$() {
        MODULE$ = this;
    }
}

