/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import net.fornwall.jelf.ElfFile;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.ElfStringTable;

public class ElfSectionHeader {
    public static final int SHT_NULL = 0;
    public static final int SHT_PROGBITS = 1;
    public static final int SHT_SYMTAB = 2;
    public static final int SHT_STRTAB = 3;
    public static final int SHT_RELA = 4;
    public static final int SHT_HASH = 5;
    public static final int SHT_DYNAMIC = 6;
    public static final int SHT_NOTE = 7;
    public static final int SHT_NOBITS = 8;
    public static final int SHT_REL = 9;
    public static final int SHT_SHLIB = 10;
    public static final int SHT_DYNSYM = 11;
    public static final int SHT_INIT_ARRAY = 14;
    public static final int SHT_FINI_ARRAY = 15;
    public static final int SHT_PREINIT_ARRAY = 16;
    public static final int SHT_GROUP = 17;
    public static final int SHT_SYMTAB_SHNDX = 18;
    public static final int SHT_GNU_HASH = 0x6FFFFFF6;
    public static final int SHT_GNU_verdef = 0x6FFFFFFD;
    public static final int SHT_GNU_verneed = 0x6FFFFFFE;
    public static final int SHT_GNU_versym = 0x6FFFFFFF;
    public static final int SHT_LOOS = 0x60000000;
    public static final int SHT_HIOS = 0x6FFFFFFF;
    public static final int SHT_LOPROC = 0x70000000;
    public static final int SHT_HIPROC = Integer.MAX_VALUE;
    public static final int SHT_LOUSER = Integer.MIN_VALUE;
    public static final int SHT_HIUSER = -1;
    public static final int FLAG_WRITE = 1;
    public static final int FLAG_ALLOC = 2;
    public static final int FLAG_EXEC_INSTR = 4;
    public static final int FLAG_MASK = -268435456;
    public static final String NAME_STRTAB = ".strtab";
    public static final String NAME_DYNSTR = ".dynstr";
    public static final String NAME_RODATA = ".rodata";
    public final int sh_name;
    public final int sh_type;
    public final long sh_flags;
    public final long sh_addr;
    public final long sh_offset;
    public final long sh_size;
    public final int sh_link;
    public final int sh_info;
    public final long sh_addralign;
    public final long sh_entsize;
    private final ElfFile elfHeader;

    ElfSectionHeader(ElfParser parser, long offset) {
        this.elfHeader = parser.elfFile;
        parser.seek(offset);
        this.sh_name = parser.readInt();
        this.sh_type = parser.readInt();
        this.sh_flags = parser.readIntOrLong();
        this.sh_addr = parser.readIntOrLong();
        this.sh_offset = parser.readIntOrLong();
        this.sh_size = parser.readIntOrLong();
        this.sh_link = parser.readInt();
        this.sh_info = parser.readInt();
        this.sh_addralign = parser.readIntOrLong();
        this.sh_entsize = parser.readIntOrLong();
    }

    public String getName() {
        if (this.sh_name == 0) {
            return null;
        }
        ElfStringTable tbl = this.elfHeader.getSectionNameStringTable();
        return tbl.get(this.sh_name);
    }

    public String toString() {
        return "ElfSectionHeader[name=" + this.getName() + ", type=0x" + Long.toHexString(this.sh_type) + "]";
    }
}

