/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fornwall.jelf.BackingFile;
import net.fornwall.jelf.ByteArrayAsFile;
import net.fornwall.jelf.ElfDynamicSection;
import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfGnuHashTable;
import net.fornwall.jelf.ElfHashTable;
import net.fornwall.jelf.ElfNoteSection;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.ElfRelocationAddendSection;
import net.fornwall.jelf.ElfRelocationSection;
import net.fornwall.jelf.ElfSection;
import net.fornwall.jelf.ElfSectionHeader;
import net.fornwall.jelf.ElfSegment;
import net.fornwall.jelf.ElfStringTable;
import net.fornwall.jelf.ElfSymbol;
import net.fornwall.jelf.ElfSymbolTableSection;
import net.fornwall.jelf.MappedFile;
import net.fornwall.jelf.MemoizedObject;

public final class ElfFile {
    public static final int ET_REL = 1;
    public static final int ET_EXEC = 2;
    public static final int ET_DYN = 3;
    public static final int ET_CORE = 4;
    public static final byte CLASS_32 = 1;
    public static final byte CLASS_64 = 2;
    public static final byte ABI_SYSTEMV = 0;
    public static final byte ABI_HPUX = 1;
    public static final byte ABI_NETBSD = 2;
    public static final byte ABI_LINUX = 3;
    public static final byte ABI_GNUHERD = 4;
    public static final byte ABI_SOLARIS = 6;
    public static final byte ABI_AIX = 7;
    public static final byte ABI_IRIX = 8;
    public static final byte ABI_FREEBSD = 9;
    public static final byte ABI_TRU64 = 10;
    public static final byte ABI_MODESTO = 11;
    public static final byte ABI_OPENBSD = 12;
    public static final byte ABI_OPENVMS = 13;
    public static final byte ABI_NONSTOP = 14;
    public static final byte ABI_AROS = 15;
    public static final byte ABI_FENIX = 16;
    public static final byte ABI_CLOUD = 17;
    public static final byte ABI_OPENVOS = 18;
    public static final byte DATA_LSB = 1;
    public static final byte DATA_MSB = 2;
    public static final int ARCH_NONE = 0;
    public static final int ARCH_ATT = 1;
    public static final int ARCH_SPARC = 2;
    public static final int ARCH_i386 = 3;
    public static final int ARCH_68k = 4;
    public static final int ARCH_88k = 5;
    public static final int ARCH_i860 = 7;
    public static final int ARCH_MIPS = 8;
    public static final int ARCH_ARM = 40;
    public static final int ARCH_X86_64 = 62;
    public static final int ARCH_AARCH64 = 183;
    public final byte ei_class;
    public final byte ei_data;
    public final byte ei_version;
    public final byte ei_osabi;
    public final byte es_abiversion;
    public final short e_type;
    public final short e_machine;
    public final int e_version;
    public final long e_entry;
    public final long e_phoff;
    public final long e_shoff;
    public final int e_flags;
    public final short e_ehsize;
    public final short e_phentsize;
    public final short e_phnum;
    public final short e_shentsize;
    public final short e_shnum;
    public final short e_shstrndx;
    private final MemoizedObject<ElfSection>[] sections;
    private final MemoizedObject<ElfSegment>[] programHeaders;
    private ElfSymbolTableSection symbolTableSection;
    private ElfSymbolTableSection dynamicSymbolTableSection;
    private ElfDynamicSection dynamicSection;

    public ElfSection getSection(int index) throws ElfException {
        return this.sections[index].getValue();
    }

    public List<ElfSection> sectionsOfType(int sectionType) throws ElfException {
        if (this.e_shnum < 2) {
            return Collections.emptyList();
        }
        ArrayList<ElfSection> result2 = new ArrayList<ElfSection>();
        for (int i = 1; i < this.e_shnum; ++i) {
            ElfSection section = this.getSection(i);
            if (section.header.sh_type != sectionType) continue;
            result2.add(section);
        }
        return result2;
    }

    public ElfStringTable getSectionNameStringTable() throws ElfException {
        return (ElfStringTable)this.getSection(this.e_shstrndx);
    }

    public ElfStringTable getStringTable() throws ElfException {
        return this.findStringTableWithName(".strtab");
    }

    public ElfStringTable getDynamicStringTable() throws ElfException {
        return this.findStringTableWithName(".dynstr");
    }

    private ElfStringTable findStringTableWithName(String tableName) throws ElfException {
        return (ElfStringTable)this.firstSectionByName(tableName);
    }

    public ElfSymbolTableSection getSymbolTableSection() throws ElfException {
        return this.symbolTableSection != null ? this.symbolTableSection : (this.symbolTableSection = (ElfSymbolTableSection)this.firstSectionByType(2));
    }

    public ElfSymbolTableSection getDynamicSymbolTableSection() throws ElfException {
        return this.dynamicSymbolTableSection != null ? this.dynamicSymbolTableSection : (this.dynamicSymbolTableSection = (ElfSymbolTableSection)this.firstSectionByType(11));
    }

    public ElfDynamicSection getDynamicSection() {
        return this.dynamicSection != null ? this.dynamicSection : (this.dynamicSection = (ElfDynamicSection)this.firstSectionByType(6));
    }

    public ElfSection firstSectionByType(int type) throws ElfException {
        for (int i = 1; i < this.e_shnum; ++i) {
            ElfSection sh = this.getSection(i);
            if (sh.header.sh_type != type) continue;
            return sh;
        }
        return null;
    }

    public <T extends ElfSection> T firstSectionByType(Class<T> type) throws ElfException {
        for (int i = 1; i < this.e_shnum; ++i) {
            ElfSection sh = this.getSection(i);
            if (!type.isInstance(sh)) continue;
            return (T)((ElfSection)type.cast(sh));
        }
        return null;
    }

    public ElfSection firstSectionByName(String sectionName) throws ElfException {
        for (int i = 1; i < this.e_shnum; ++i) {
            ElfSection sh = this.getSection(i);
            if (!sectionName.equals(sh.header.getName())) continue;
            return sh;
        }
        return null;
    }

    public ElfSymbol getELFSymbol(String symbolName) throws ElfException {
        ElfSymbol symbol;
        int i;
        int numSymbols;
        if (symbolName == null) {
            return null;
        }
        ElfSymbolTableSection sh = this.getDynamicSymbolTableSection();
        if (sh != null) {
            numSymbols = sh.symbols.length;
            i = 0;
            while ((double)i < Math.ceil(numSymbols / 2)) {
                symbol = sh.symbols[i];
                if (symbolName.equals(symbol.getName())) {
                    return symbol;
                }
                symbol = sh.symbols[numSymbols - 1 - i];
                if (symbolName.equals(symbol.getName())) {
                    return symbol;
                }
                ++i;
            }
        }
        if ((sh = this.getSymbolTableSection()) != null) {
            numSymbols = sh.symbols.length;
            i = 0;
            while ((double)i < Math.ceil(numSymbols / 2)) {
                symbol = sh.symbols[i];
                if (symbolName.equals(symbol.getName())) {
                    return symbol;
                }
                symbol = sh.symbols[numSymbols - 1 - i];
                if (symbolName.equals(symbol.getName())) {
                    return symbol;
                }
                ++i;
            }
        }
        return null;
    }

    public ElfSymbol getELFSymbol(long address) throws ElfException {
        long value;
        ElfSymbolTableSection sh = this.getDynamicSymbolTableSection();
        if (sh != null) {
            for (ElfSymbol symbol : sh.symbols) {
                value = symbol.st_value;
                if (address < value || address >= value + symbol.st_size) continue;
                return symbol;
            }
        }
        if ((sh = this.getSymbolTableSection()) != null) {
            for (ElfSymbol symbol : sh.symbols) {
                value = symbol.st_value;
                if (address < value || address >= value + symbol.st_size) continue;
                return symbol;
            }
        }
        return null;
    }

    public ElfSegment getProgramHeader(int index) {
        return this.programHeaders[index].getValue();
    }

    public static ElfFile from(InputStream in2) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int totalRead = 0;
        byte[] buffer = new byte[8096];
        boolean firstRead = true;
        int readNow;
        while ((readNow = in2.read(buffer, totalRead, buffer.length - totalRead)) != -1) {
            if (firstRead) {
                if (readNow < 4) {
                    throw new ElfException("Bad first read");
                }
                if (127 != buffer[0] || 69 != buffer[1] || 76 != buffer[2] || 70 != buffer[3]) {
                    throw new ElfException("Bad magic number for file");
                }
                firstRead = false;
            }
            baos.write(buffer, 0, readNow);
        }
        return ElfFile.from(baos.toByteArray());
    }

    public static ElfFile from(File file) throws ElfException, IOException {
        byte[] buffer = new byte[(int)file.length()];
        try (FileInputStream in2 = new FileInputStream(file);){
            int readNow;
            for (int totalRead = 0; totalRead < buffer.length; totalRead += readNow) {
                readNow = in2.read(buffer, totalRead, buffer.length - totalRead);
                if (readNow != -1) continue;
                throw new ElfException("Premature end of file");
            }
        }
        return ElfFile.from(buffer);
    }

    public static ElfFile from(byte[] buffer) throws ElfException {
        return new ElfFile(new ByteArrayAsFile(buffer));
    }

    public static ElfFile from(MappedByteBuffer mappedByteBuffer) throws ElfException {
        return new ElfFile(new MappedFile(mappedByteBuffer));
    }

    public ElfFile(BackingFile backingFile) throws ElfException {
        int i;
        final ElfParser parser = new ElfParser(this, backingFile);
        byte[] ident = new byte[16];
        int bytesRead = parser.read(ident);
        if (bytesRead != ident.length) {
            throw new ElfException("Error reading elf header (read " + bytesRead + "bytes - expected to read " + ident.length + "bytes)");
        }
        if (127 != ident[0] || 69 != ident[1] || 76 != ident[2] || 70 != ident[3]) {
            throw new ElfException("Bad magic number for file");
        }
        this.ei_class = ident[4];
        if (this.ei_class != 1 && this.ei_class != 2) {
            throw new ElfException("Invalid object size class: " + this.ei_class);
        }
        this.ei_data = ident[5];
        if (this.ei_data != 1 && this.ei_data != 2) {
            throw new ElfException("Invalid encoding: " + this.ei_data);
        }
        this.ei_version = ident[6];
        if (this.ei_version != 1) {
            throw new ElfException("Invalid elf version: " + this.ei_version);
        }
        this.ei_osabi = ident[7];
        this.es_abiversion = ident[8];
        this.e_type = parser.readShort();
        this.e_machine = parser.readShort();
        this.e_version = parser.readInt();
        this.e_entry = parser.readIntOrLong();
        this.e_phoff = parser.readIntOrLong();
        this.e_shoff = parser.readIntOrLong();
        this.e_flags = parser.readInt();
        this.e_ehsize = parser.readShort();
        this.e_phentsize = parser.readShort();
        this.e_phnum = parser.readShort();
        this.e_shentsize = parser.readShort();
        this.e_shnum = parser.readShort();
        if (this.e_shnum == 0) {
            throw new ElfException("e_shnum is SHN_UNDEF(0), which is not supported yet (the actual number of section header table entries is contained in the sh_size field of the section header at index 0)");
        }
        this.e_shstrndx = parser.readShort();
        if (this.e_shstrndx == 65535) {
            throw new ElfException("e_shstrndx is SHN_XINDEX(0xffff), which is not supported yet (the actual index of the section name string table section is contained in the sh_link field of the section header at index 0)");
        }
        this.sections = MemoizedObject.uncheckedArray(this.e_shnum);
        for (i = 0; i < this.e_shnum; ++i) {
            final long sectionHeaderOffset = this.e_shoff + (long)(i * this.e_shentsize);
            this.sections[i] = new MemoizedObject<ElfSection>(){

                @Override
                public ElfSection computeValue() throws ElfException {
                    ElfSectionHeader elfSectionHeader = new ElfSectionHeader(parser, sectionHeaderOffset);
                    switch (elfSectionHeader.sh_type) {
                        case 6: {
                            return new ElfDynamicSection(parser, elfSectionHeader);
                        }
                        case 2: 
                        case 11: {
                            return new ElfSymbolTableSection(parser, elfSectionHeader);
                        }
                        case 3: {
                            return new ElfStringTable(parser, elfSectionHeader.sh_offset, (int)elfSectionHeader.sh_size, elfSectionHeader);
                        }
                        case 5: {
                            return new ElfHashTable(parser, elfSectionHeader);
                        }
                        case 7: {
                            return new ElfNoteSection(parser, elfSectionHeader);
                        }
                        case 4: {
                            return new ElfRelocationAddendSection(parser, elfSectionHeader);
                        }
                        case 9: {
                            return new ElfRelocationSection(parser, elfSectionHeader);
                        }
                        case 0x6FFFFFF6: {
                            return new ElfGnuHashTable(parser, elfSectionHeader);
                        }
                    }
                    return new ElfSection(elfSectionHeader);
                }
            };
        }
        this.programHeaders = MemoizedObject.uncheckedArray(this.e_phnum);
        for (i = 0; i < this.e_phnum; ++i) {
            final long programHeaderOffset = this.e_phoff + (long)(i * this.e_phentsize);
            this.programHeaders[i] = new MemoizedObject<ElfSegment>(){

                @Override
                public ElfSegment computeValue() {
                    return new ElfSegment(parser, programHeaderOffset);
                }
            };
        }
    }

    public String getInterpreter() {
        for (MemoizedObject<ElfSegment> programHeader : this.programHeaders) {
            ElfSegment ph = programHeader.getValue();
            if (ph.p_type != 3) continue;
            return ph.getIntepreter();
        }
        return null;
    }
}

